/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.spock.ext;

import java.lang.annotation.Annotation;
import java.util.List;
import org.spockframework.runtime.extension.AbstractAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.SpecInfo;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.spock.ConfigOverride;
import ru.vyarus.dropwizard.guice.test.spock.ext.GuiceyInterceptor;
import ru.vyarus.dropwizard.guice.test.spock.ext.SpecialFieldsSupport;
import ru.vyarus.dropwizard.guice.test.util.HooksUtil;

public abstract class AbstractAppExtension<T extends Annotation>
extends AbstractAnnotationDrivenExtension<T> {
    private T annotation;

    public void visitSpecAnnotation(T useApplication, SpecInfo spec) {
        this.annotation = useApplication;
    }

    public void visitSpec(SpecInfo spec) {
        Class testType = (Class)spec.getReflection();
        List<GuiceyConfigurationHook> hooks = SpecialFieldsSupport.findHooks(testType);
        hooks.addAll(HooksUtil.create((Class[])this.getHooks(this.annotation)));
        GuiceyInterceptor interceptor = new GuiceyInterceptor(spec, this.buildSupport(this.annotation, testType), hooks);
        SpecInfo topSpec = spec.getTopSpec();
        topSpec.addSharedInitializerInterceptor((IMethodInterceptor)interceptor);
        topSpec.addInitializerInterceptor((IMethodInterceptor)interceptor);
        topSpec.addCleanupSpecInterceptor((IMethodInterceptor)interceptor);
    }

    protected abstract Class<? extends GuiceyConfigurationHook>[] getHooks(T var1);

    protected abstract GuiceyInterceptor.EnvironmentSupport buildSupport(T var1, Class<?> var2);

    protected io.dropwizard.testing.ConfigOverride[] convertOverrides(ConfigOverride ... overrides) {
        io.dropwizard.testing.ConfigOverride[] configOverride = new io.dropwizard.testing.ConfigOverride[overrides.length];
        int i = 0;
        for (ConfigOverride override : overrides) {
            configOverride[i++] = io.dropwizard.testing.ConfigOverride.config((String)override.key(), (String)override.value());
        }
        return configOverride;
    }
}

