/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.spock.ext;

import java.util.ArrayList;
import java.util.List;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.EnableHook;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.TestFieldUtils;
import ru.vyarus.dropwizard.guice.test.spock.InjectClient;
import spock.lang.Shared;

public final class SpecialFieldsSupport {
    private SpecialFieldsSupport() {
    }

    public static List<GuiceyConfigurationHook> findHooks(Class<?> test) {
        ArrayList<GuiceyConfigurationHook> hooks = new ArrayList<GuiceyConfigurationHook>();
        List fields = TestFieldUtils.findAnnotatedFields(test, EnableHook.class, GuiceyConfigurationHook.class);
        fields.forEach(AnnotatedField::requireStatic);
        for (GuiceyConfigurationHook hook : TestFieldUtils.getValues((List)fields, null)) {
            if (hook == null) continue;
            hooks.add(hook);
        }
        return hooks;
    }

    public static void initClients(Object instance, List<AnnotatedField<InjectClient, ClientSupport>> fields, ClientSupport client, boolean shared) {
        fields.forEach(field -> {
            boolean incompatibleField;
            boolean bl = incompatibleField = instance == null && !field.isStatic() || instance != null && field.isStatic();
            if (field.getField().isAnnotationPresent(Shared.class) != shared || incompatibleField) {
                return;
            }
            field.setValue(instance, (Object)client);
        });
    }
}

