/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.dropwizard.guice.test.spock.ext;

import com.google.inject.Injector;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import io.dropwizard.core.Application;
import io.dropwizard.testing.DropwizardTestSupport;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spockframework.runtime.extension.AbstractMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.SpecInfo;
import ru.vyarus.dropwizard.guice.hook.ConfigurationHooksSupport;
import ru.vyarus.dropwizard.guice.hook.GuiceyConfigurationHook;
import ru.vyarus.dropwizard.guice.injector.lookup.InjectorLookup;
import ru.vyarus.dropwizard.guice.test.ClientSupport;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.AnnotatedField;
import ru.vyarus.dropwizard.guice.test.jupiter.env.field.TestFieldUtils;
import ru.vyarus.dropwizard.guice.test.spock.InjectClient;
import ru.vyarus.dropwizard.guice.test.spock.ext.GuiceyExtensionException;
import ru.vyarus.dropwizard.guice.test.spock.ext.SpecialFieldsSupport;
import spock.lang.Shared;

public class GuiceyInterceptor
extends AbstractMethodInterceptor {
    private final EnvironmentSupport support;
    private final List<GuiceyConfigurationHook> hooks;
    private final Set<InjectionPoint> injectionPoints;
    private final List<AnnotatedField<InjectClient, ClientSupport>> clientFields;
    private Injector injector;

    public GuiceyInterceptor(SpecInfo spec, EnvironmentSupport support, List<GuiceyConfigurationHook> hooks) {
        this.support = support;
        this.hooks = hooks;
        this.injectionPoints = InjectionPoint.forInstanceMethodsAndFields((Class)((Class)spec.getReflection()));
        this.clientFields = TestFieldUtils.findAnnotatedFields((Class)((Class)spec.getReflection()), InjectClient.class, ClientSupport.class);
    }

    public void interceptSharedInitializerMethod(IMethodInvocation invocation) throws Throwable {
        this.hooks.forEach(GuiceyConfigurationHook::register);
        this.support.before();
        SpecialFieldsSupport.initClients(null, this.clientFields, this.support.getClient(), false);
        this.injector = this.support.getInjector();
        this.injectValues(invocation.getSharedInstance(), true);
        invocation.proceed();
    }

    public void interceptInitializerMethod(IMethodInvocation invocation) throws Throwable {
        this.injectValues(invocation.getInstance(), false);
        invocation.proceed();
    }

    public void interceptCleanupSpecMethod(IMethodInvocation invocation) throws Throwable {
        ConfigurationHooksSupport.reset();
        try {
            invocation.proceed();
        }
        finally {
            this.support.after();
        }
    }

    private void injectValues(Object target, boolean sharedFields) throws IllegalAccessException {
        for (InjectionPoint point : this.injectionPoints) {
            if (!(point.getMember() instanceof Field)) {
                throw new GuiceyExtensionException("Method injection is not supported; use field injection instead");
            }
            Field field = (Field)point.getMember();
            if (field.isAnnotationPresent(Shared.class) != sharedFields) continue;
            Object value = this.injector.getInstance(((Dependency)point.getDependencies().get(0)).getKey());
            field.setAccessible(true);
            field.set(target, value);
        }
        SpecialFieldsSupport.initClients(target, this.clientFields, this.support.getClient(), sharedFields);
    }

    public static interface EnvironmentSupport {
        public void before() throws Exception;

        public void after() throws Exception;

        public Injector getInjector();

        public ClientSupport getClient();
    }

    public static abstract class AbstractEnvironmentSupport
    implements EnvironmentSupport {
        private final Logger logger = LoggerFactory.getLogger(AbstractEnvironmentSupport.class);
        private final Class<?> test;
        private DropwizardTestSupport support;
        private ClientSupport client;

        public AbstractEnvironmentSupport(Class<?> test) {
            this.test = test;
        }

        protected abstract DropwizardTestSupport build();

        @Override
        public void before() throws Exception {
            this.support = this.build();
            this.support.before();
            this.client = new ClientSupport(this.support);
        }

        @Override
        public void after() {
            if (this.support != null) {
                this.support.after();
            }
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception e) {
                    this.logger.info("Error closing client instance", (Throwable)e);
                }
            }
        }

        @Override
        public Injector getInjector() {
            return (Injector)InjectorLookup.getInjector((Application)this.support.getApplication()).orElseThrow(() -> new IllegalStateException("No active injector found"));
        }

        @Override
        public ClientSupport getClient() {
            return this.client;
        }
    }
}

