/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.guicey.validation;

import com.google.inject.Module;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import jakarta.validation.Validator;
import jakarta.validation.executable.ValidateOnExecution;
import jakarta.ws.rs.Path;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.module.context.unique.item.UniqueGuiceyBundle;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyBootstrap;
import ru.vyarus.dropwizard.guice.module.installer.bundle.GuiceyEnvironment;
import ru.vyarus.guice.validator.ValidationModule;
import ru.vyarus.guice.validator.aop.DeclaredMethodMatcher;
import ru.vyarus.guicey.validation.util.RestMethodMatcher;

public class ValidationBundle
extends UniqueGuiceyBundle {
    private final Logger logger = LoggerFactory.getLogger(ValidationBundle.class);
    private Matcher<? super Class> typeMatcher = Matchers.not((Matcher)Matchers.annotatedWith(Path.class));
    private Matcher<? super Method> methodMatcher = new DeclaredMethodMatcher().and(Matchers.not((Matcher)new RestMethodMatcher()));
    private Class<? extends Annotation> targetAnnotation;
    private boolean strictGroups;

    public ValidationBundle targetClasses(Matcher<? super Class> matcher) {
        this.typeMatcher = matcher;
        return this;
    }

    public ValidationBundle targetMethods(Matcher<? super Method> matcher) {
        this.methodMatcher = matcher;
        return this;
    }

    public ValidationBundle validateAnnotatedOnly() {
        return this.validateAnnotatedOnly(ValidateOnExecution.class);
    }

    public ValidationBundle validateAnnotatedOnly(Class<? extends Annotation> annotation) {
        this.targetAnnotation = annotation;
        return this;
    }

    public ValidationBundle strictGroupsDeclaration() {
        this.strictGroups = true;
        return this;
    }

    public void initialize(GuiceyBootstrap bootstrap) {
        ValidationModule module = new ValidationModule(bootstrap.bootstrap().getValidatorFactory()).targetClasses(this.typeMatcher).targetMethods(this.methodMatcher);
        if (this.targetAnnotation != null) {
            module.validateAnnotatedOnly(this.targetAnnotation);
        }
        if (this.strictGroups) {
            module.strictGroupsDeclaration();
        }
        bootstrap.modules(new Module[]{module});
    }

    public void run(GuiceyEnvironment environment) throws Exception {
        environment.onGuiceyStartup((config, env, injector) -> {
            env.setValidator((Validator)injector.getInstance(Validator.class));
            if (this.targetAnnotation == null) {
                this.logger.info("Validation annotations support enabled on guice beans");
            } else {
                this.logger.info("Validation annotations support enabled on guice beans and methods, annotated with @{}", (Object)this.targetAnnotation.getSimpleName());
            }
        });
    }
}

