/*
 * Decompiled with CFR 0.152.
 */
package ru.zinin.redis.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.util.SessionIdGenerator;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import ru.zinin.redis.session.RedisEventListenerThread;
import ru.zinin.redis.session.RedisHttpSession;
import ru.zinin.redis.session.RedisSessionKeys;

public class RedisManager
extends LifecycleMBeanBase
implements Manager,
PropertyChangeListener {
    private final Log log = LogFactory.getLog(RedisManager.class);
    private static final String info = "RedisManager/1.0";
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.session");
    private Container container;
    private int maxInactiveInterval = 1800;
    private int sessionIdLength = 32;
    private int maxActiveSessions = -1;
    private String secureRandomClass = null;
    private String secureRandomAlgorithm = "SHA1PRNG";
    private String secureRandomProvider = null;
    private SessionIdGenerator sessionIdGenerator = null;
    private String jedisJndiName = "pool/jedis";
    private String redisHostname = "localhost";
    private int redisPort = 6379;
    private int redisTimeout = 2000;
    private String redisPassword;
    private JedisPool pool;
    private boolean disableListeners = false;
    private int dbIndex = 0;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final RedisEventListenerThread eventListenerThread = new RedisEventListenerThread(this);

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.log.trace((Object)String.format("EXEC setContainer(%s);", container));
        if (this.container != null && this.container instanceof Context) {
            this.container.removePropertyChangeListener((PropertyChangeListener)this);
        }
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            this.container.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public boolean getDistributable() {
        this.log.trace((Object)"EXEC getDistributable();");
        return true;
    }

    public void setDistributable(boolean distributable) {
        this.log.trace((Object)String.format("EXEC setDistributable(%s);", distributable));
        if (!distributable) {
            this.log.error((Object)"Only distributable web applications supported.");
        }
    }

    public String getInfo() {
        this.log.trace((Object)"EXEC getInfo();");
        return info;
    }

    public int getMaxInactiveInterval() {
        this.log.trace((Object)"EXEC getMaxInactiveInterval();");
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.log.trace((Object)String.format("EXEC setMaxInactiveInterval(%d);", interval));
        int oldMaxInactiveInterval = this.maxInactiveInterval;
        this.maxInactiveInterval = interval;
        this.support.firePropertyChange("maxInactiveInterval", (Object)oldMaxInactiveInterval, (Object)this.maxInactiveInterval);
    }

    public int getSessionIdLength() {
        this.log.trace((Object)"EXEC getSessionIdLength();");
        return this.sessionIdLength;
    }

    public void setSessionIdLength(int idLength) {
        this.log.trace((Object)String.format("EXEC setSessionIdLength(%d);", idLength));
        int oldSessionIdLength = this.sessionIdLength;
        this.sessionIdLength = idLength;
        this.support.firePropertyChange("sessionIdLength", (Object)oldSessionIdLength, (Object)this.sessionIdLength);
    }

    public long getSessionCounter() {
        this.log.trace((Object)"EXEC getSessionCounter();");
        return 0L;
    }

    public void setSessionCounter(long sessionCounter) {
        this.log.trace((Object)String.format("EXEC setSessionCounter(%d);", sessionCounter));
    }

    public int getMaxActive() {
        this.log.trace((Object)"EXEC getMaxActive();");
        return 0;
    }

    public void setMaxActive(int maxActive) {
        this.log.trace((Object)String.format("EXEC setMaxActive(%d);", maxActive));
    }

    public int getMaxActiveSessions() {
        this.log.trace((Object)"EXEC getMaxActiveSessions();");
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(int max) {
        this.log.trace((Object)String.format("EXEC setMaxActiveSessions(%d);", max));
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", (Object)oldMaxActiveSessions, (Object)this.maxActiveSessions);
    }

    public int getActiveSessions() {
        Long result;
        this.log.trace((Object)"EXEC getActiveSessions();");
        String key = RedisSessionKeys.getSessionsKey();
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            jedis.select(this.dbIndex);
            result = jedis.zcard(key);
            this.pool.returnResource((Object)jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new RuntimeException(e);
        }
        return result.intValue();
    }

    public long getExpiredSessions() {
        this.log.trace((Object)"EXEC getExpiredSessions();");
        return 0L;
    }

    public void setExpiredSessions(long expiredSessions) {
        this.log.trace((Object)String.format("EXEC setExpiredSessions(%d);", expiredSessions));
    }

    public int getRejectedSessions() {
        this.log.trace((Object)"EXEC getRejectedSessions();");
        return 0;
    }

    public int getSessionMaxAliveTime() {
        this.log.trace((Object)"EXEC getSessionMaxAliveTime();");
        return 0;
    }

    public void setSessionMaxAliveTime(int sessionMaxAliveTime) {
        this.log.trace((Object)String.format("EXEC setSessionMaxAliveTime(%d);", sessionMaxAliveTime));
    }

    public int getSessionAverageAliveTime() {
        this.log.trace((Object)"EXEC getSessionAverageAliveTime();");
        return 0;
    }

    public int getSessionCreateRate() {
        this.log.trace((Object)"EXEC getSessionCreateRate();");
        return 0;
    }

    public int getSessionExpireRate() {
        this.log.trace((Object)"EXEC getSessionExpireRate();");
        return 0;
    }

    public void add(Session session) {
        this.log.trace((Object)String.format("EXEC add(%s);", session));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.log.trace((Object)String.format("EXEC addPropertyChangeListener(%s);", listener));
        this.support.addPropertyChangeListener(listener);
    }

    public void changeSessionId(Session session) {
        this.log.trace((Object)String.format("EXEC changeSessionId(%s);", session));
        String oldId = session.getIdInternal();
        session.setId(this.generateSessionId(), false);
        String newId = session.getIdInternal();
        this.container.fireContainerEvent("changeSessionId", (Object)new String[]{oldId, newId});
    }

    public Session createEmptySession() {
        this.log.trace((Object)"EXEC createEmptySession();");
        throw new UnsupportedOperationException("Cannot create empty session.");
    }

    public Session createSession(String sessionId) {
        this.log.trace((Object)String.format("EXEC createSession(%s);", sessionId));
        if (this.maxActiveSessions >= 0 && this.getActiveSessions() >= this.maxActiveSessions) {
            throw new IllegalStateException(sm.getString("managerBase.createSession.ise"));
        }
        String id = sessionId;
        if (id == null) {
            id = this.generateSessionId();
        }
        return new RedisHttpSession(id, this, this.maxInactiveInterval);
    }

    public Session findSession(String id) throws IOException {
        String lastAccessTime;
        this.log.trace((Object)String.format("EXEC findSession(%s);", id));
        if (id == null) {
            return null;
        }
        String key = RedisSessionKeys.getLastAccessTimeKey(id);
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            jedis.select(this.dbIndex);
            lastAccessTime = jedis.get(key);
            this.pool.returnResource((Object)jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new RuntimeException(e);
        }
        if (lastAccessTime == null) {
            return null;
        }
        return new RedisHttpSession(id, this);
    }

    public Session[] findSessions() {
        Set sessionIds;
        this.log.trace((Object)"EXEC findSessions();");
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            jedis.select(this.dbIndex);
            sessionIds = jedis.zrangeByScore(RedisSessionKeys.getSessionsKey(), 0.0, Double.MAX_VALUE);
            this.pool.returnResource((Object)jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new RuntimeException(e);
        }
        HashSet<RedisHttpSession> result = new HashSet<RedisHttpSession>(sessionIds.size());
        for (String sessionId : sessionIds) {
            RedisHttpSession session = new RedisHttpSession(sessionId, this);
            if (!session.isValid()) continue;
            result.add(session);
        }
        return result.toArray(new Session[0]);
    }

    public void load() throws ClassNotFoundException, IOException {
        this.log.trace((Object)"EXEC load();");
    }

    public void remove(Session session) {
        this.log.trace((Object)String.format("EXEC remove(%s);", session));
        this.remove(session, false);
    }

    public void remove(Session session, boolean update) {
        this.log.trace((Object)String.format("EXEC remove(%s, %s);", session, update));
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.log.trace((Object)String.format("EXEC removePropertyChangeListener(%s);", listener));
        this.support.removePropertyChangeListener(listener);
    }

    public void unload() throws IOException {
        this.log.trace((Object)"EXEC unload();");
    }

    public void backgroundProcess() {
        Set sessionIds;
        this.log.trace((Object)"EXEC backgroundProcess();");
        long max = System.currentTimeMillis() - (long)(this.maxInactiveInterval * 1000);
        Jedis jedis = (Jedis)this.pool.getResource();
        try {
            jedis.select(this.dbIndex);
            sessionIds = jedis.zrangeByScore(RedisSessionKeys.getSessionsKey(), 0.0, (double)max);
            this.pool.returnResource((Object)jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource((Object)jedis);
            throw new RuntimeException(e);
        }
        this.log.debug((Object)(sessionIds.size() + " sessions expired."));
        HashSet<String> removedIds = new HashSet<String>();
        if (!sessionIds.isEmpty()) {
            jedis = (Jedis)this.pool.getResource();
            try {
                for (String sessionId : sessionIds) {
                    if (jedis.zrem(RedisSessionKeys.getSessionsKey(), new String[]{sessionId}) <= 0L) continue;
                    removedIds.add(sessionId);
                }
                this.pool.returnResource((Object)jedis);
            }
            catch (Throwable e) {
                this.pool.returnBrokenResource((Object)jedis);
                throw new RuntimeException(e);
            }
            for (String sessionId : removedIds) {
                RedisHttpSession session = new RedisHttpSession(sessionId, this);
                session.expire();
            }
        }
    }

    protected String getDomainInternal() {
        this.log.trace((Object)"EXEC getDomainInternal();");
        return MBeanUtils.getDomain((Container)this.container);
    }

    protected String getObjectNameKeyProperties() {
        this.log.trace((Object)"EXEC getObjectNameKeyProperties();");
        StringBuilder name = new StringBuilder("type=Manager");
        if (this.container instanceof Context) {
            name.append(",context=");
            String contextName = this.container.getName();
            if (!contextName.startsWith("/")) {
                name.append('/');
            }
            name.append(contextName);
            Context context = (Context)this.container;
            name.append(",host=");
            name.append(context.getParent().getName());
        } else {
            name.append(",container=");
            name.append(this.container.getName());
        }
        return name.toString();
    }

    public String getJedisJndiName() {
        return this.jedisJndiName;
    }

    public void setJedisJndiName(String jedisJndiName) {
        this.jedisJndiName = jedisJndiName;
    }

    public String getRedisHostname() {
        return this.redisHostname;
    }

    public void setRedisHostname(String redisHostname) {
        this.redisHostname = redisHostname;
    }

    public int getRedisPort() {
        return this.redisPort;
    }

    public void setRedisPort(int redisPort) {
        this.redisPort = redisPort;
    }

    public int getRedisTimeout() {
        return this.redisTimeout;
    }

    public void setRedisTimeout(int redisTimeout) {
        this.redisTimeout = redisTimeout;
    }

    public String getRedisPassword() {
        return this.redisPassword;
    }

    public void setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
    }

    public JedisPool getPool() {
        return this.pool;
    }

    public boolean isDisableListeners() {
        return this.disableListeners;
    }

    public void setDisableListeners(boolean disableListeners) {
        this.disableListeners = disableListeners;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    public void setDbIndex(int dbIndex) {
        this.dbIndex = dbIndex;
    }

    protected void startInternal() throws LifecycleException {
        this.log.trace((Object)"EXEC startInternal();");
        this.sessionIdGenerator = new SessionIdGenerator();
        this.sessionIdGenerator.setJvmRoute(this.getJvmRoute());
        this.sessionIdGenerator.setSecureRandomAlgorithm(this.getSecureRandomAlgorithm());
        this.sessionIdGenerator.setSecureRandomClass(this.getSecureRandomClass());
        this.sessionIdGenerator.setSecureRandomProvider(this.getSecureRandomProvider());
        this.sessionIdGenerator.setSessionIdLength(this.getSessionIdLength());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Force random number initialization starting");
        }
        this.sessionIdGenerator.generateSessionId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Force random number initialization completed");
        }
        this.log.debug((Object)"Trying to get jedis pool from JNDI...");
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            this.pool = (JedisPool)initialContext.lookup("java:/comp/env/" + this.jedisJndiName);
        }
        catch (NamingException e) {
            this.log.warn((Object)"JedisPool not found in JNDI");
        }
        this.log.debug((Object)("Pool from JNDI: " + this.pool));
        if (this.pool == null) {
            GenericObjectPool.Config config = new GenericObjectPool.Config();
            config.testOnBorrow = true;
            this.pool = new JedisPool(config, this.redisHostname, this.redisPort, this.redisTimeout, this.redisPassword);
        }
        if (!this.disableListeners) {
            Executors.newSingleThreadExecutor().execute(this.eventListenerThread);
        }
        this.setState(LifecycleState.STARTING);
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (!(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        Engine e = this.getEngine();
        return e == null ? null : e.getJvmRoute();
    }

    public String getSecureRandomClass() {
        return this.secureRandomClass;
    }

    public void setSecureRandomClass(String secureRandomClass) {
        String oldSecureRandomClass = this.secureRandomClass;
        this.secureRandomClass = secureRandomClass;
        this.support.firePropertyChange("secureRandomClass", oldSecureRandomClass, this.secureRandomClass);
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public String getSecureRandomProvider() {
        return this.secureRandomProvider;
    }

    public void setSecureRandomProvider(String secureRandomProvider) {
        this.secureRandomProvider = secureRandomProvider;
    }

    protected void stopInternal() throws LifecycleException {
        this.log.trace((Object)"EXEC stopInternal();");
        this.setState(LifecycleState.STOPPING);
        this.sessionIdGenerator = null;
        if (!this.disableListeners) {
            this.eventListenerThread.stop();
        }
        this.pool.destroy();
    }

    protected String generateSessionId() {
        String result;
        try {
            while (this.findSession(result = this.sessionIdGenerator.generateSessionId()) != null) {
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.log.trace((Object)String.format("EXEC propertyChange(%s);", event));
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                this.setMaxInactiveInterval((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)sm.getString("managerBase.sessionTimeout", new Object[]{event.getNewValue()}));
            }
        }
    }
}

