/*
 * Decompiled with CFR 0.152.
 */
package ru.zinin.redis.session;

public class RedisSessionKeys {
    private static final String SESSIONS_LIST_KEY = "sessions";
    private static final String SESSION_KEY_PREFIX = "session";
    private static final String KEY_DELIM = ":";
    private static final String SESSION_CREATION_TIME_KEY = "creation_time";
    private static final String SESSION_LAST_ACCESS_TIME_KEY = "last_access_time";
    private static final String SESSION_EXPIRE_AT_KEY = "expire_at";
    private static final String SESSION_TIMEOUT_KEY = "timeout";
    private static final String SESSION_ATTRS_LIST_KEY = "attrs";
    private static final String SESSION_ATTR_KEY = "attrs";
    private static final String SESSION_CHANNEL = "session-channel";
    private static final String ENCODING = "utf-8";

    public static String getSessionsKey() {
        return SESSIONS_LIST_KEY;
    }

    public static String getCreationTimeKey(String id) {
        return "session:" + id + KEY_DELIM + SESSION_CREATION_TIME_KEY;
    }

    public static String getLastAccessTimeKey(String id) {
        return "session:" + id + KEY_DELIM + SESSION_LAST_ACCESS_TIME_KEY;
    }

    public static String getExpireAtKey(String id) {
        return "session:" + id + KEY_DELIM + SESSION_EXPIRE_AT_KEY;
    }

    public static String getSessionTimeoutKey(String id) {
        return "session:" + id + KEY_DELIM + SESSION_TIMEOUT_KEY;
    }

    public static String getAttrsKey(String id) {
        return "session:" + id + KEY_DELIM + "attrs";
    }

    public static String getAttrKey(String id, String name) {
        return "session:" + id + KEY_DELIM + "attrs" + KEY_DELIM + name;
    }

    public static String getSessionChannel() {
        return SESSION_CHANNEL;
    }

    public static String getEncoding() {
        return ENCODING;
    }
}

