/*
 * Decompiled with CFR 0.152.
 */
package ru.zinin.redis.factory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisPoolFactory
implements ObjectFactory {
    private final Log log = LogFactory.getLog(JedisPoolFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        RefAddr passwordRefAddr;
        RefAddr databaseRefAddr;
        RefAddr timeoutRefAddr;
        RefAddr portRefAddr;
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"redis.clients.jedis.JedisPool".equals(ref.getClassName())) {
            return null;
        }
        String host = "localhost";
        int port = 6379;
        int timeout = 2000;
        int database = 0;
        String password = null;
        RefAddr hostRefAddr = ref.get("host");
        if (hostRefAddr != null) {
            host = hostRefAddr.getContent().toString();
        }
        if ((portRefAddr = ref.get("port")) != null) {
            port = Integer.parseInt(portRefAddr.getContent().toString());
        }
        if ((timeoutRefAddr = ref.get("timeout")) != null) {
            timeout = Integer.parseInt(timeoutRefAddr.getContent().toString());
        }
        if ((databaseRefAddr = ref.get("database")) != null) {
            database = Integer.parseInt(databaseRefAddr.getContent().toString());
        }
        if ((passwordRefAddr = ref.get("password")) != null) {
            password = passwordRefAddr.getContent().toString();
        }
        this.log.debug((Object)"Creating pool...");
        this.log.debug((Object)("Host: " + host));
        this.log.debug((Object)("Port: " + port));
        this.log.debug((Object)("Timeout: " + timeout));
        this.log.trace((Object)("Password: " + password));
        JedisPoolConfig config = new JedisPoolConfig();
        return new JedisPool((GenericObjectPoolConfig)config, host, port, timeout, password, database);
    }
}

