/*
 * Decompiled with CFR 0.152.
 */
package ru.zinin.redis.session;

import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionListener;
import org.apache.catalina.util.Enumerator;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Transaction;
import ru.zinin.redis.session.RedisManager;
import ru.zinin.redis.session.RedisSessionKeys;
import ru.zinin.redis.session.event.RedisSessionAddAttributeEvent;
import ru.zinin.redis.session.event.RedisSessionAttributeEvent;
import ru.zinin.redis.session.event.RedisSessionCreatedEvent;
import ru.zinin.redis.session.event.RedisSessionDestroyedEvent;
import ru.zinin.redis.session.event.RedisSessionEvent;
import ru.zinin.redis.session.event.RedisSessionRemoveAttributeEvent;
import ru.zinin.redis.session.event.RedisSessionReplaceAttributeEvent;
import ru.zinin.redis.util.Base64Util;
import ru.zinin.redis.util.RedisSerializationUtil;

public class RedisHttpSession
implements HttpSession,
Session,
Serializable {
    private final Log log = LogFactory.getLog(RedisHttpSession.class);
    private static final String info = "RedisSession/1.0";
    private String id;
    private RedisManager manager;
    private JedisPool pool;
    private ServletContext servletContext;
    private boolean disableListeners = false;
    private String authType;
    private Principal principal;
    private Map<String, Object> notes = new Hashtable<String, Object>();
    private AtomicBoolean isNew = new AtomicBoolean(false);
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    RedisHttpSession(String id, RedisManager manager) {
        this.log.trace((Object)"Create session [OLD]");
        this.id = id;
        this.setManager(manager);
    }

    RedisHttpSession(String id, JedisPool pool, ServletContext servletContext, boolean disableListeners) {
        this.log.trace((Object)"Create session [OLD] from RedisSessionTemplate.");
        this.id = id;
        this.pool = pool;
        this.servletContext = servletContext;
        this.disableListeners = disableListeners;
    }

    RedisHttpSession(String id, RedisManager manager, int maxInactiveInterval) {
        this.log.trace((Object)("Create session [NEW]. maxInactiveInterval = " + maxInactiveInterval));
        this.id = id;
        this.setManager(manager);
        this.isNew.set(true);
        String sessionsKey = RedisSessionKeys.getSessionsKey();
        String creationTimeKey = RedisSessionKeys.getCreationTimeKey(id);
        String lastAccessTimeKey = RedisSessionKeys.getLastAccessTimeKey(id);
        String expiresAtKey = RedisSessionKeys.getExpireAtKey(id);
        String timeoutKey = RedisSessionKeys.getSessionTimeoutKey(id);
        long currentTime = System.currentTimeMillis();
        long expireAtTime = currentTime + (long)(maxInactiveInterval * 1000);
        long expireAtTimeWithReserve = currentTime + (long)(maxInactiveInterval * 1000 * 2);
        Jedis jedis = this.pool.getResource();
        try {
            Transaction transaction = jedis.multi();
            transaction.set(creationTimeKey, Long.toString(currentTime));
            transaction.set(lastAccessTimeKey, Long.toString(currentTime));
            transaction.set(expiresAtKey, Long.toString(expireAtTimeWithReserve));
            transaction.set(timeoutKey, Integer.toString(maxInactiveInterval));
            transaction.expireAt(creationTimeKey, this.getUnixTime(expireAtTimeWithReserve));
            transaction.expireAt(lastAccessTimeKey, this.getUnixTime(expireAtTime));
            transaction.expireAt(expiresAtKey, this.getUnixTime(expireAtTimeWithReserve));
            transaction.expireAt(timeoutKey, this.getUnixTime(expireAtTimeWithReserve));
            transaction.zadd(sessionsKey, (double)currentTime, id);
            transaction.exec();
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        this.tellNew();
    }

    private long getUnixTime(long time) {
        return time / 1000L;
    }

    public void tellNew() {
        if (!this.disableListeners) {
            Jedis jedis = this.pool.getResource();
            try {
                RedisSessionCreatedEvent redisSessionEvent = new RedisSessionCreatedEvent(this.id);
                byte[] bytes = RedisSerializationUtil.encode(redisSessionEvent);
                String message = new String(Base64Util.encode(bytes));
                jedis.publish(RedisSessionKeys.getSessionChannel(this.manager.getContainer().getName()), message);
                this.log.debug((Object)("Sended " + redisSessionEvent.toString()));
                this.pool.returnResource(jedis);
            }
            catch (Throwable e) {
                this.pool.returnBrokenResource(jedis);
                throw new RuntimeException(e);
            }
        }
    }

    public String getAuthType() {
        this.log.trace((Object)"EXEC getAuthType();");
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.log.trace((Object)String.format("EXEC setAuthType(%s);", authType));
        String oldAuthType = this.authType;
        this.authType = authType;
        this.support.firePropertyChange("authType", oldAuthType, this.authType);
    }

    public long getCreationTime() {
        String creationTime;
        this.log.trace((Object)"EXEC getCreationTime();");
        String key = RedisSessionKeys.getCreationTimeKey(this.id);
        Jedis jedis = this.pool.getResource();
        try {
            creationTime = jedis.get(key);
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        if (creationTime == null) {
            throw new IllegalStateException("Can't get creation time from redis.");
        }
        return Long.parseLong(creationTime);
    }

    public long getCreationTimeInternal() {
        this.log.trace((Object)"EXEC getCreationTimeInternal();");
        return this.getCreationTime();
    }

    public void setCreationTime(long time) {
        this.log.trace((Object)String.format("EXEC setAuthType(%d);", time));
        throw new UnsupportedOperationException("Can't set creation time");
    }

    public String getId() {
        this.log.trace((Object)"EXEC getId();");
        return this.id;
    }

    public String getIdInternal() {
        this.log.trace((Object)"EXEC getIdInternal();");
        return this.id;
    }

    public void setId(String id) {
        this.log.trace((Object)String.format("EXEC setId(%s);", id));
        this.setId(id, false);
    }

    public void setId(String id, boolean notify) {
        this.log.trace((Object)String.format("EXEC setId(%s, %s);", id, notify));
        String oldCreationTimeKey = RedisSessionKeys.getCreationTimeKey(this.id);
        String oldLastAccessTimeKey = RedisSessionKeys.getLastAccessTimeKey(this.id);
        String oldExpiresAtKey = RedisSessionKeys.getExpireAtKey(this.id);
        String oldTimeoutKey = RedisSessionKeys.getSessionTimeoutKey(this.id);
        String oldAttrsKey = RedisSessionKeys.getAttrsKey(this.id);
        String newCreationTimeKey = RedisSessionKeys.getCreationTimeKey(id);
        String newLastAccessTimeKey = RedisSessionKeys.getLastAccessTimeKey(id);
        String newExpiresAtKey = RedisSessionKeys.getExpireAtKey(id);
        String newTimeoutKey = RedisSessionKeys.getSessionTimeoutKey(id);
        String newAttrsKey = RedisSessionKeys.getAttrsKey(id);
        Set<String> attributeNames = this.getAttributesNames();
        long lastAccessTime = this.getLastAccessedTime();
        Jedis jedis = this.pool.getResource();
        try {
            Transaction transaction = jedis.multi();
            transaction.rename(oldCreationTimeKey, newCreationTimeKey);
            transaction.rename(oldLastAccessTimeKey, newLastAccessTimeKey);
            transaction.rename(oldExpiresAtKey, newExpiresAtKey);
            transaction.rename(oldTimeoutKey, newTimeoutKey);
            if (attributeNames != null && !attributeNames.isEmpty()) {
                for (String attributeName : attributeNames) {
                    String oldKey = RedisSessionKeys.getAttrKey(this.id, attributeName);
                    String newKey = RedisSessionKeys.getAttrKey(id, attributeName);
                    transaction.rename(oldKey, newKey);
                }
                transaction.rename(oldAttrsKey, newAttrsKey);
            } else {
                transaction.del(oldAttrsKey);
            }
            transaction.zadd(RedisSessionKeys.getSessionsKey(), (double)lastAccessTime, id);
            transaction.zrem(RedisSessionKeys.getSessionsKey(), new String[]{this.id});
            transaction.exec();
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        this.id = id;
        if (notify) {
            this.tellNew();
        }
    }

    public String getInfo() {
        this.log.trace((Object)"EXEC getInfo();");
        return info;
    }

    private Long getLastAccessTime() {
        String lastAccessTime;
        String key = RedisSessionKeys.getLastAccessTimeKey(this.id);
        Jedis jedis = this.pool.getResource();
        try {
            lastAccessTime = jedis.get(key);
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        if (lastAccessTime == null) {
            return null;
        }
        return Long.parseLong(lastAccessTime);
    }

    public long getThisAccessedTime() {
        this.log.trace((Object)"EXEC getThisAccessedTime();");
        return this.getLastAccessedTime();
    }

    public long getThisAccessedTimeInternal() {
        this.log.trace((Object)"EXEC getThisAccessedTimeInternal();");
        return this.getLastAccessedTime();
    }

    public long getLastAccessedTime() {
        this.log.trace((Object)"EXEC getLastAccessedTime();");
        Long lastAccessTime = this.getLastAccessTime();
        if (lastAccessTime == null) {
            throw new IllegalStateException("Can't get last access time from redis.");
        }
        return lastAccessTime;
    }

    public long getLastAccessedTimeInternal() {
        this.log.trace((Object)"EXEC getLastAccessedTimeInternal();");
        return this.getLastAccessedTime();
    }

    public Manager getManager() {
        this.log.trace((Object)"EXEC getManager();");
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.log.trace((Object)String.format("EXEC setId(%s);", manager));
        this.manager = (RedisManager)manager;
        this.pool = this.manager.getPool();
        this.servletContext = ((Context)manager.getContainer()).getServletContext();
        this.disableListeners = this.manager.isDisableListeners();
    }

    public ServletContext getServletContext() {
        this.log.trace((Object)"EXEC getServletContext();");
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.log.trace((Object)String.format("EXEC setMaxInactiveInterval(%d);", interval));
        String key = RedisSessionKeys.getSessionTimeoutKey(this.id);
        Jedis jedis = this.pool.getResource();
        try {
            jedis.set(key, Integer.toString(interval));
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        this.renewAll();
    }

    public void setNew(boolean isNew) {
        this.log.trace((Object)String.format("EXEC setNew(%s);", isNew));
        throw new UnsupportedOperationException("Can't set new");
    }

    public Principal getPrincipal() {
        this.log.trace((Object)"EXEC getPrincipal();");
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.log.trace((Object)String.format("EXEC setPrincipal(%s);", principal));
        Principal oldPrincipal = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", oldPrincipal, this.principal);
    }

    public HttpSession getSession() {
        this.log.trace((Object)"EXEC getSession();");
        return this;
    }

    public void setValid(boolean isValid) {
        this.log.trace((Object)String.format("EXEC setValid(%s);", isValid));
        throw new UnsupportedOperationException("Can't set valid.");
    }

    public boolean isValid() {
        this.log.trace((Object)"EXEC isValid();");
        return !this.isAnyRequiredFieldNull();
    }

    private boolean isAnyRequiredFieldNull() {
        try {
            this.getLastAccessedTime();
            this.getExpireAt();
            this.getMaxInactiveInterval();
        }
        catch (IllegalStateException e) {
            return true;
        }
        return false;
    }

    private void renewAll() {
        String creationTimeKey = RedisSessionKeys.getCreationTimeKey(this.id);
        String lastAccessTimeKey = RedisSessionKeys.getLastAccessTimeKey(this.id);
        String expiresAtKey = RedisSessionKeys.getExpireAtKey(this.id);
        String timeoutKey = RedisSessionKeys.getSessionTimeoutKey(this.id);
        String attrsKey = RedisSessionKeys.getAttrsKey(this.id);
        Set<String> attributeNames = null;
        long currentExpireAtTime = this.getExpireAt();
        long timeout = this.getMaxInactiveInterval();
        long currentTime = System.currentTimeMillis();
        long expireAtTime = currentTime + timeout * 1000L;
        long expireAtTimeWithReserve = currentTime + timeout * 1000L * 2L;
        if (currentExpireAtTime < expireAtTime) {
            attributeNames = this.getAttributesNames();
        }
        Jedis jedis = this.pool.getResource();
        try {
            Transaction transaction = jedis.multi();
            if (currentExpireAtTime < expireAtTime) {
                transaction.set(expiresAtKey, Long.toString(expireAtTimeWithReserve));
                transaction.expireAt(expiresAtKey, this.getUnixTime(expireAtTimeWithReserve));
                transaction.expireAt(creationTimeKey, this.getUnixTime(expireAtTimeWithReserve));
                transaction.expireAt(timeoutKey, this.getUnixTime(expireAtTimeWithReserve));
                if (attributeNames != null && !attributeNames.isEmpty()) {
                    for (String attributeName : attributeNames) {
                        String key = RedisSessionKeys.getAttrKey(this.id, attributeName);
                        transaction.expireAt(key, this.getUnixTime(expireAtTimeWithReserve));
                    }
                    transaction.expireAt(attrsKey, this.getUnixTime(expireAtTimeWithReserve));
                }
            }
            transaction.set(lastAccessTimeKey, Long.toString(currentTime));
            transaction.expireAt(lastAccessTimeKey, this.getUnixTime(expireAtTime));
            transaction.zadd(RedisSessionKeys.getSessionsKey(), (double)currentTime, this.id);
            transaction.exec();
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
    }

    public void access() {
        this.log.trace((Object)"EXEC access();");
        this.renewAll();
    }

    public void addSessionListener(SessionListener listener) {
        this.log.trace((Object)String.format("EXEC addSessionListener(%s);", listener));
        throw new UnsupportedOperationException("Listeners are not supported.");
    }

    public void endAccess() {
        this.log.trace((Object)"EXEC endAccess();");
        this.isNew.set(false);
    }

    public void expire() {
        this.log.trace((Object)"EXEC expire();");
        String creationTimeKey = RedisSessionKeys.getCreationTimeKey(this.id);
        String lastAccessTimeKey = RedisSessionKeys.getLastAccessTimeKey(this.id);
        String expiresAtKey = RedisSessionKeys.getExpireAtKey(this.id);
        String timeoutKey = RedisSessionKeys.getSessionTimeoutKey(this.id);
        String attrsKey = RedisSessionKeys.getAttrsKey(this.id);
        Set<String> attributeNames = this.getAttributesNames();
        Jedis jedis = this.pool.getResource();
        try {
            Transaction transaction = jedis.multi();
            transaction.del(new String[]{creationTimeKey, lastAccessTimeKey, expiresAtKey, timeoutKey, attrsKey});
            if (!attributeNames.isEmpty()) {
                HashSet<String> keys = new HashSet<String>();
                for (String attributeName : attributeNames) {
                    String key = RedisSessionKeys.getAttrKey(this.id, attributeName);
                    keys.add(key);
                }
                transaction.del(keys.toArray(new String[0]));
            }
            if (!this.disableListeners) {
                RedisSessionDestroyedEvent redisSessionEvent = new RedisSessionDestroyedEvent(this.id);
                byte[] bytes = RedisSerializationUtil.encode(redisSessionEvent);
                String message = new String(Base64Util.encode(bytes));
                transaction.publish(RedisSessionKeys.getSessionChannel(this.manager.getContainer().getName()), message);
            }
            transaction.exec();
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
    }

    public Object getNote(String name) {
        this.log.trace((Object)String.format("EXEC getNote(%s);", name));
        return this.notes.get(name);
    }

    public Iterator<String> getNoteNames() {
        this.log.trace((Object)"EXEC getNoteNames();");
        return this.notes.keySet().iterator();
    }

    public void recycle() {
        this.log.trace((Object)"EXEC recycle();");
        throw new IllegalStateException("Recycle is not supported");
    }

    public void removeNote(String name) {
        this.log.trace((Object)String.format("EXEC removeNote(%s);", name));
        this.notes.remove(name);
    }

    public void removeSessionListener(SessionListener listener) {
        this.log.trace((Object)String.format("EXEC removeSessionListener(%s);", listener));
        throw new UnsupportedOperationException("Listeners are not supported.");
    }

    public void setNote(String name, Object value) {
        this.log.trace((Object)String.format("EXEC setNote(%s, %s);", name, value));
        this.notes.put(name, value);
    }

    public int getMaxInactiveInterval() {
        String sessionTimeout;
        this.log.trace((Object)"EXEC getMaxInactiveInterval();");
        String key = RedisSessionKeys.getSessionTimeoutKey(this.id);
        Jedis jedis = this.pool.getResource();
        try {
            sessionTimeout = jedis.get(key);
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        if (sessionTimeout == null) {
            throw new IllegalStateException("Can't get session timeout from redis.");
        }
        return Integer.parseInt(sessionTimeout);
    }

    public HttpSessionContext getSessionContext() {
        this.log.trace((Object)"EXEC getSessionContext();");
        return null;
    }

    public Object getAttribute(String name) {
        byte[] object;
        this.log.trace((Object)String.format("EXEC getAttribute(%s);", name));
        String key = RedisSessionKeys.getAttrKey(this.id, name);
        Jedis jedis = this.pool.getResource();
        try {
            object = jedis.get(key.getBytes(RedisSessionKeys.getEncoding()));
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        if (object == null) {
            return null;
        }
        return RedisSerializationUtil.decode(object);
    }

    public Object getValue(String name) {
        this.log.trace((Object)String.format("EXEC getValue(%s);", name));
        return this.getAttribute(name);
    }

    private Set<String> getAttributesNames() {
        Set result;
        String key = RedisSessionKeys.getAttrsKey(this.id);
        Jedis jedis = this.pool.getResource();
        try {
            result = jedis.smembers(key);
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        if (result.isEmpty()) {
            return new HashSet<String>();
        }
        return result;
    }

    public long getExpireAt() {
        String expireAt;
        String key = RedisSessionKeys.getExpireAtKey(this.id);
        Jedis jedis = this.pool.getResource();
        try {
            expireAt = jedis.get(key);
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        if (expireAt == null) {
            throw new IllegalStateException("Can't get expireAt from redis.");
        }
        return Long.parseLong(expireAt);
    }

    public Enumeration<String> getAttributeNames() {
        this.log.trace((Object)"EXEC getAttributeNames();");
        return new Enumerator(this.getAttributesNames(), true);
    }

    public String[] getValueNames() {
        this.log.trace((Object)"EXEC getValueNames();");
        return this.getAttributesNames().toArray(new String[0]);
    }

    public void setAttribute(String name, Object value) {
        Object object;
        boolean exist;
        this.log.trace((Object)String.format("EXEC setAttribute(%s, %s);", name, value));
        String attributeKey = RedisSessionKeys.getAttrKey(this.id, name);
        String attrsListKey = RedisSessionKeys.getAttrsKey(this.id);
        Long currentExpireAtTimeWithReserve = this.getExpireAt();
        Jedis jedis = this.pool.getResource();
        try {
            exist = jedis.exists(attributeKey);
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        byte[] bytes = null;
        if (exist && !this.disableListeners) {
            jedis = this.pool.getResource();
            try {
                bytes = jedis.get(attributeKey.getBytes(RedisSessionKeys.getEncoding()));
                this.pool.returnResource(jedis);
            }
            catch (Throwable e) {
                this.pool.returnBrokenResource(jedis);
                throw new RuntimeException(e);
            }
        }
        jedis = this.pool.getResource();
        try {
            Transaction transaction = jedis.multi();
            object = RedisSerializationUtil.encode((Serializable)value);
            transaction.set(attributeKey.getBytes(RedisSessionKeys.getEncoding()), object);
            transaction.expireAt(attributeKey.getBytes(RedisSessionKeys.getEncoding()), this.getUnixTime(currentExpireAtTimeWithReserve));
            transaction.sadd(attrsListKey, new String[]{name});
            transaction.expireAt(attrsListKey, this.getUnixTime(currentExpireAtTimeWithReserve));
            transaction.exec();
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        if (!this.disableListeners) {
            RedisSessionAttributeEvent sessionEvent;
            if (bytes == null) {
                sessionEvent = new RedisSessionAddAttributeEvent(this.id, name, (Serializable)value);
            } else {
                object = RedisSerializationUtil.decode(bytes);
                sessionEvent = new RedisSessionReplaceAttributeEvent(this.id, name, (Serializable)object);
            }
            jedis = this.pool.getResource();
            try {
                bytes = RedisSerializationUtil.encode(sessionEvent);
                String message = new String(Base64Util.encode(bytes));
                jedis.publish(RedisSessionKeys.getSessionChannel(this.manager.getContainer().getName()), message);
                this.log.debug((Object)("Sended " + ((RedisSessionEvent)sessionEvent).toString()));
                this.pool.returnResource(jedis);
            }
            catch (Throwable e) {
                this.pool.returnBrokenResource(jedis);
                throw new RuntimeException(e);
            }
        }
    }

    public void putValue(String name, Object value) {
        this.log.trace((Object)String.format("EXEC putValue(%s, %s);", name, value));
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        boolean exist;
        this.log.trace((Object)String.format("EXEC removeAttribute(%s);", name));
        String attributeKey = RedisSessionKeys.getAttrKey(this.id, name);
        String attrsListKey = RedisSessionKeys.getAttrsKey(this.id);
        Jedis jedis = this.pool.getResource();
        try {
            exist = jedis.exists(attributeKey);
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
        if (!exist) {
            return;
        }
        String message = null;
        if (!this.disableListeners) {
            byte[] bytes;
            jedis = this.pool.getResource();
            try {
                bytes = jedis.get(attributeKey.getBytes(RedisSessionKeys.getEncoding()));
                this.pool.returnResource(jedis);
            }
            catch (Throwable e) {
                this.pool.returnBrokenResource(jedis);
                throw new RuntimeException(e);
            }
            Object object = RedisSerializationUtil.decode(bytes);
            RedisSessionRemoveAttributeEvent sessionEvent = new RedisSessionRemoveAttributeEvent(this.id, name, (Serializable)object);
            bytes = RedisSerializationUtil.encode(sessionEvent);
            message = new String(Base64Util.encode(bytes));
        }
        jedis = this.pool.getResource();
        try {
            Transaction transaction = jedis.multi();
            transaction.del(attributeKey.getBytes(RedisSessionKeys.getEncoding()));
            transaction.srem(attrsListKey, new String[]{name});
            if (!this.disableListeners) {
                transaction.publish(RedisSessionKeys.getSessionChannel(this.manager.getContainer().getName()), message);
            }
            transaction.exec();
            this.pool.returnResource(jedis);
        }
        catch (Throwable e) {
            this.pool.returnBrokenResource(jedis);
            throw new RuntimeException(e);
        }
    }

    public void removeValue(String name) {
        this.log.trace((Object)String.format("EXEC removeValue(%s);", name));
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.log.trace((Object)"EXEC invalidate();");
        this.expire();
    }

    public boolean isNew() {
        this.log.trace((Object)"EXEC isNew();");
        return this.isNew.get();
    }
}

