/*
 * Decompiled with CFR 0.152.
 */
package ru.zinin.redis.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import ru.zinin.redis.util.CustomObjectInputStream;

public class RedisSerializationUtil {
    public static <T extends Serializable> byte[] encode(T obj) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(obj);
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing object" + obj + " => " + e);
        }
    }

    public static <T extends Serializable> T decode(byte[] bytes) {
        return RedisSerializationUtil.decode(bytes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T decode(byte[] bytes, ClassLoader classLoader) {
        Serializable t;
        block10: {
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            t = null;
            Exception thrown = null;
            try {
                CustomObjectInputStream oin = new CustomObjectInputStream(new ByteArrayInputStream(bytes), classLoader);
                t = (Serializable)oin.readObject();
            }
            catch (IOException e) {
                e.printStackTrace();
                thrown = e;
                return (T)thrown;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                thrown = e;
                return (T)thrown;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                thrown = e;
                return (T)thrown;
            }
            finally {
                if (null == thrown) break block10;
                throw new RuntimeException("Error decoding byte[] data to instantiate java object - data at key may not have been of this type or even an object", thrown);
            }
        }
        return (T)t;
    }
}

