/*
 * Decompiled with CFR 0.152.
 */
package ru.ztrap.bezier.curve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ztrap.bezier.curve.BezierCurveKt;
import ru.ztrap.bezier.curve.Point;
import ru.ztrap.bezier.curve.PointKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BI\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u0007\u00a2\u0006\u0002\u0010\bB#\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\t\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u001b\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0004\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\tH\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u000eJ\u0016\u0010\u001b\u001a\u00020\tH\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u000eJ\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J7\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\t2\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\t\u0010%\u001a\u00020\u0014H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0005\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0002\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0010\u0010\u000e\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006("}, d2={"Lru/ztrap/bezier/curve/BezierCurve;", "", "start", "Lkotlin/Pair;", "", "end", "controls", "", "(Lkotlin/Pair;Lkotlin/Pair;Ljava/util/List;)V", "Lru/ztrap/bezier/curve/Point;", "(JJLjava/util/List;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getControls", "()Ljava/util/List;", "getEnd-m9dLc0s", "()J", "J", "getStart-m9dLc0s", "bernstein", "t", "n", "", "i", "calculate", "calculate-oJOpirk", "(F)J", "component1", "component1-m9dLc0s", "component2", "component2-m9dLc0s", "component3", "copy", "copy-f2kwrXg", "(JJLjava/util/List;)Lru/ztrap/bezier/curve/BezierCurve;", "equals", "", "other", "fact", "hashCode", "toString", "", "beziercurve"})
@SourceDebugExtension(value={"SMAP\nBezierCurve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BezierCurve.kt\nru/ztrap/bezier/curve/BezierCurve\n+ 2 utils.kt\nru/ztrap/bezier/curve/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n27#2,4:63\n27#2,4:67\n27#2,4:74\n1549#3:71\n1620#3,2:72\n1622#3:78\n1864#3,3:80\n2661#3,7:83\n1#4:79\n*S KotlinDebug\n*F\n+ 1 BezierCurve.kt\nru/ztrap/bezier/curve/BezierCurve\n*L\n23#1:63,4\n24#1:67,4\n25#1:74,4\n25#1:71\n25#1:72,2\n25#1:78\n41#1:80,3\n53#1:83,7\n*E\n"})
public final class BezierCurve {
    private final long start;
    private final long end;
    @NotNull
    private final List<Point> controls;

    private BezierCurve(long start, long end, List<Point> controls) {
        Intrinsics.checkNotNullParameter(controls, (String)"controls");
        this.start = start;
        this.end = end;
        this.controls = controls;
    }

    public final long getStart-m9dLc0s() {
        return this.start;
    }

    public final long getEnd-m9dLc0s() {
        return this.end;
    }

    @NotNull
    public final List<Point> getControls() {
        return this.controls;
    }

    /*
     * WARNING - void declaration
     */
    public BezierCurve(@NotNull Pair<Float, Float> start, @NotNull Pair<Float, Float> end, @NotNull List<Pair<Float, Float>> controls) {
        Collection<Point> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(controls, (String)"controls");
        Pair<Float, Float> $this$x$iv = start;
        boolean $i$f$getX = false;
        Object $this$y$iv = start;
        boolean $i$f$getY = false;
        long l = PointKt.Point(((Number)$this$x$iv.getFirst()).floatValue(), ((Number)$this$y$iv.getSecond()).floatValue());
        $this$x$iv = end;
        $i$f$getX = false;
        $this$y$iv = end;
        $i$f$getY = false;
        long l2 = PointKt.Point(((Number)$this$x$iv.getFirst()).floatValue(), ((Number)$this$y$iv.getSecond()).floatValue());
        $this$y$iv = controls;
        long l3 = l2;
        long l4 = l;
        BezierCurve bezierCurve = this;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void $this$x$iv2 = it;
            boolean $i$f$getX2 = false;
            void $this$y$iv2 = it;
            boolean $i$f$getY2 = false;
            collection.add(Point.box-impl(PointKt.Point(((Number)$this$x$iv2.getFirst()).floatValue(), ((Number)$this$y$iv2.getSecond()).floatValue())));
        }
        collection = (List)destination$iv$iv;
        bezierCurve(l4, l3, (List)collection, null);
    }

    /*
     * WARNING - void declaration
     */
    public final long calculate-oJOpirk(float t) {
        long l;
        if (!BezierCurveKt.access$getAPPLICABLE_VALUES$p().contains((Comparable)Float.valueOf(t))) {
            boolean $i$a$-require-BezierCurve$calculate$22 = false;
            String $i$a$-require-BezierCurve$calculate$22 = "Wrong t value = " + t + ". Applicable values in [0,1]";
            throw new IllegalArgumentException($i$a$-require-BezierCurve$calculate$22.toString());
        }
        if (this.controls.size() == 0) {
            l = PointKt.Point((1.0f - t) * Point.getX-impl(this.start) + t * Point.getX-impl(this.end), (1.0f - t) * Point.getY-impl(this.start) + t * Point.getY-impl(this.end));
        } else {
            float x = 0.0f;
            float y = 0.0f;
            Iterable $this$forEachIndexed$iv = this.controls;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void control;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                long l2 = ((Point)item$iv).unbox-impl();
                int index = n;
                boolean bl = false;
                float polynomial = this.bernstein(t, this.controls.size() - 1, index + 1);
                x += polynomial * Point.getX-impl((long)control);
                y += polynomial * Point.getY-impl((long)control);
            }
            l = PointKt.Point(x, y);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private final int fact(int n) {
        Iterable $this$reduce$iv = (Iterable)new IntRange(1, n);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        int accumulator$iv = ((IntIterator)iterator$iv).nextInt();
        while (iterator$iv.hasNext()) {
            void i;
            int n2 = ((IntIterator)iterator$iv).nextInt();
            int acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc * i;
        }
        return accumulator$iv;
    }

    private final float bernstein(float t, int n, int i) {
        return (float)(this.fact(n) / (this.fact(i) * this.fact(n - i))) * (float)Math.pow(1.0f - t, n - i) * (float)Math.pow(t, i);
    }

    public final long component1-m9dLc0s() {
        return this.start;
    }

    public final long component2-m9dLc0s() {
        return this.end;
    }

    @NotNull
    public final List<Point> component3() {
        return this.controls;
    }

    @NotNull
    public final BezierCurve copy-f2kwrXg(long start, long end, @NotNull List<Point> controls) {
        Intrinsics.checkNotNullParameter(controls, (String)"controls");
        return new BezierCurve(start, end, controls, null);
    }

    public static /* synthetic */ BezierCurve copy-f2kwrXg$default(BezierCurve bezierCurve, long l, long l2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            l = bezierCurve.start;
        }
        if ((n & 2) != 0) {
            l2 = bezierCurve.end;
        }
        if ((n & 4) != 0) {
            list = bezierCurve.controls;
        }
        return bezierCurve.copy-f2kwrXg(l, l2, list);
    }

    @NotNull
    public String toString() {
        return "BezierCurve(start=" + Point.toString-impl(this.start) + ", end=" + Point.toString-impl(this.end) + ", controls=" + this.controls + ")";
    }

    public int hashCode() {
        int result = Point.hashCode-impl(this.start);
        result = result * 31 + Point.hashCode-impl(this.end);
        result = result * 31 + ((Object)this.controls).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BezierCurve)) {
            return false;
        }
        BezierCurve bezierCurve = (BezierCurve)other;
        if (!Point.equals-impl0(this.start, bezierCurve.start)) {
            return false;
        }
        if (!Point.equals-impl0(this.end, bezierCurve.end)) {
            return false;
        }
        return Intrinsics.areEqual(this.controls, bezierCurve.controls);
    }

    public /* synthetic */ BezierCurve(long start, long end, List controls, DefaultConstructorMarker $constructor_marker) {
        this(start, end, controls);
    }
}

