package security.whisper.javastix.bundle;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;

/**
 * Immutable implementation of {@link BundleObject}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Bundle.builder()}.
 */
@Generated(from = "BundleObject", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("bundle")
public final class Bundle implements BundleObject {
  private final String type;
  private final String id;
  private final String specVersion;
  private final ImmutableSet<BundleableObject> objects;
  private final ImmutableMap<String, Object> customProperties;

  private Bundle(Bundle.Builder builder) {
    this.type = builder.type;
    this.id = builder.id;
    this.objects = builder.objects.build();
    this.customProperties = builder.customProperties.build();
    this.specVersion = builder.specVersion != null
        ? builder.specVersion
        : Objects.requireNonNull(BundleObject.super.getSpecVersion(), "specVersion");
  }

  private Bundle(
      String type,
      String id,
      String specVersion,
      ImmutableSet<BundleableObject> objects,
      ImmutableMap<String, Object> customProperties) {
    this.type = type;
    this.id = id;
    this.specVersion = specVersion;
    this.objects = objects;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @JsonPropertyDescription("The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code specVersion} attribute
   */
  @JsonProperty("spec_version")
  @JsonPropertyDescription("The version of the STIX specification used to represent the content in this bundle.")
  @Override
  public String getSpecVersion() {
    return specVersion;
  }

  /**
   * @return The value of the {@code objects} attribute
   */
  @JsonProperty(value = "objects", access = JsonProperty.Access.WRITE_ONLY)
  @JsonPropertyDescription("Specifies a set of one or more STIX Objects.")
  @Override
  public ImmutableSet<BundleableObject> getObjects() {
    return objects;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BundleObject#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Bundle withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new Bundle(value, this.id, this.specVersion, this.objects, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BundleObject#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Bundle withId(String value) {
    if (Objects.equals(this.id, value)) return this;
    return validate(new Bundle(this.type, value, this.specVersion, this.objects, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BundleObject#getSpecVersion() specVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for specVersion
   * @return A modified copy of the {@code this} object
   */
  public final Bundle withSpecVersion(String value) {
    String newValue = Objects.requireNonNull(value, "specVersion");
    if (this.specVersion.equals(newValue)) return this;
    return validate(new Bundle(this.type, this.id, newValue, this.objects, this.customProperties));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BundleObject#getObjects() objects}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Bundle withObjects(BundleableObject... elements) {
    ImmutableSet<BundleableObject> newValue = ImmutableSet.copyOf(elements);
    return validate(new Bundle(this.type, this.id, this.specVersion, newValue, this.customProperties));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BundleObject#getObjects() objects}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objects elements to set
   * @return A modified copy of {@code this} object
   */
  public final Bundle withObjects(Iterable<? extends BundleableObject> elements) {
    if (this.objects == elements) return this;
    ImmutableSet<BundleableObject> newValue = ImmutableSet.copyOf(elements);
    return validate(new Bundle(this.type, this.id, this.specVersion, newValue, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link BundleObject#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final Bundle withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new Bundle(this.type, this.id, this.specVersion, this.objects, newValue));
  }

  /**
   * This instance is equal to all instances of {@code Bundle} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Bundle
        && equalTo((Bundle) another);
  }

  private boolean equalTo(Bundle another) {
    return Objects.equals(type, another.type)
        && Objects.equals(id, another.id)
        && specVersion.equals(another.specVersion)
        && objects.equals(another.objects)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code id}, {@code specVersion}, {@code objects}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + specVersion.hashCode();
    h += (h << 5) + objects.hashCode();
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BundleObject} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BundleObject")
        .omitNullValues()
        .add("type", type)
        .add("id", id)
        .add("specVersion", specVersion)
        .add("objects", objects)
        .add("customProperties", customProperties)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long TO_JSON_STRING_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String toJsonString;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link BundleObject#toJsonString() toJsonString} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code toJsonString} attribute
   */
  @Override
  public String toJsonString() {
    if ((lazyInitBitmap & TO_JSON_STRING_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TO_JSON_STRING_LAZY_INIT_BIT) == 0) {
          this.toJsonString = Objects.requireNonNull(BundleObject.super.toJsonString(), "toJsonString");
          lazyInitBitmap |= TO_JSON_STRING_LAZY_INIT_BIT;
        }
      }
    }
    return toJsonString;
  }


  private static Bundle validate(Bundle instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link BundleObject} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BundleObject instance
   */
  public static Bundle copyOf(BundleObject instance) {
    if (instance instanceof Bundle) {
      return (Bundle) instance;
    }
    return Bundle.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link Bundle Bundle}.
   * @return A new Bundle builder
   */
  public static Bundle.Builder builder() {
    return new Bundle.Builder();
  }

  /**
   * Builds instances of type {@link Bundle Bundle}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BundleObject", generator = "Immutables")
  @NotThreadSafe
  @JsonTypeName("bundle")
  @JsonPropertyOrder({"type", "id", "spec_version", "objects"})
  public static final class Builder {
    private @Nullable String type;
    private @Nullable String id;
    private @Nullable String specVersion;
    private ImmutableSet.Builder<BundleableObject> objects = ImmutableSet.builder();
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof BundleObject) {
        BundleObject instance = (BundleObject) object;
        specVersion(instance.getSpecVersion());
        String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        addAllObjects(instance.getObjects());
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
    }

    /**
     * Initializes the value for the {@link BundleObject#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    @JsonPropertyDescription("The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link BundleObject#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    public final Builder id(String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link BundleObject#getSpecVersion() specVersion} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BundleObject#getSpecVersion() specVersion}.</em>
     * @param specVersion The value for specVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("spec_version")
    @JsonPropertyDescription("The version of the STIX specification used to represent the content in this bundle.")
    public final Builder specVersion(String specVersion) {
      this.specVersion = Objects.requireNonNull(specVersion, "specVersion");
      return this;
    }

    /**
     * Adds one element to {@link BundleObject#getObjects() objects} set.
     * @param element A objects element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObject(@Nullable BundleableObject element) {
      this.objects.add(element);
      return this;
    }

    /**
     * Adds elements to {@link BundleObject#getObjects() objects} set.
     * @param elements An array of objects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjects(BundleableObject... elements) {
      this.objects.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BundleObject#getObjects() objects} set.
     * @param elements An iterable of objects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "objects", access = JsonProperty.Access.WRITE_ONLY)
    @JsonPropertyDescription("Specifies a set of one or more STIX Objects.")
    public final Builder objects(Iterable<? extends BundleableObject> elements) {
      this.objects = ImmutableSet.builder();
      return addAllObjects(elements);
    }

    /**
     * Adds elements to {@link BundleObject#getObjects() objects} set.
     * @param elements An iterable of objects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjects(Iterable<? extends BundleableObject> elements) {
      this.objects.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link BundleObject#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link BundleObject#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link BundleObject#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link BundleObject#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link Bundle Bundle}.
     * @return An immutable instance of BundleObject
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Bundle build() {
      return Bundle.validate(new Bundle(this));
    }
  }
}
