package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.objects.NetworkTrafficCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

/**
 * http-request-ext
 * <p>
 * The HTTP request extension specifies a default extension for capturing
 * network traffic properties specific to HTTP requests.
 */
@Generated(from = "HttpRequestExtensionExt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("http-request-ext")
@AllowedParents(NetworkTrafficCoo.class)
public final class HttpRequestExtension
    implements HttpRequestExtensionExt, Serializable {
  private final String requestMethod;
  private final String requestValue;
  private final @Nullable String requestVersion;
  private final ImmutableMap<String, String> requestHeader;
  private final @Nullable Long messageBodyLength;
  private final @Nullable String messageBodyDataRef;
  private final String type;
  private final ImmutableMap<String, Object> customProperties;

  private HttpRequestExtension(
      String requestMethod,
      String requestValue,
      @Nullable String requestVersion,
      ImmutableMap<String, String> requestHeader,
      @Nullable Long messageBodyLength,
      @Nullable String messageBodyDataRef,
      String type,
      ImmutableMap<String, Object> customProperties) {
    this.requestMethod = requestMethod;
    this.requestValue = requestValue;
    this.requestVersion = requestVersion;
    this.requestHeader = requestHeader;
    this.messageBodyLength = messageBodyLength;
    this.messageBodyDataRef = messageBodyDataRef;
    this.type = type;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code requestMethod} attribute
   */
  @JsonProperty("request_method")
  @JsonPropertyDescription("Specifies the HTTP method portion of the HTTP request line, as a lowercase string.")
  @Override
  public String getRequestMethod() {
    return requestMethod;
  }

  /**
   * @return The value of the {@code requestValue} attribute
   */
  @JsonProperty("request_value")
  @JsonPropertyDescription("Specifies the value (typically a resource path) portion of the HTTP request line.")
  @Override
  public String getRequestValue() {
    return requestValue;
  }

  /**
   * @return The value of the {@code requestVersion} attribute
   */
  @JsonProperty("request_version")
  @JsonPropertyDescription("Specifies the HTTP version portion of the HTTP request line, as a lowercase string.")
  @Override
  public Optional<String> getRequestVersion() {
    return Optional.ofNullable(requestVersion);
  }

  /**
   * Currently only supports non-duplicate keys: https://github.com/oasis-tcs/cti-stix2/issues/137
   */
  @JsonProperty("request_header")
  @JsonPropertyDescription("Specifies all of the HTTP header fields that may be found in the HTTP client request, as a dictionary.")
  @Override
  public ImmutableMap<String, String> getRequestHeader() {
    return requestHeader;
  }

  /**
   * @return The value of the {@code messageBodyLength} attribute
   */
  @JsonProperty("message_body_length")
  @JsonPropertyDescription("Specifies the length of the HTTP message body, if included, in bytes.")
  @Override
  public Optional<Long> getMessageBodyLength() {
    return Optional.ofNullable(messageBodyLength);
  }

  /**
   * @return The value of the {@code messageBodyDataRef} attribute
   */
  @JsonProperty("message_body_data_ref")
  @JsonPropertyDescription("Specifies the data contained in the HTTP message body, if included.")
  @Override
  public Optional<String> getMessageBodyDataRef() {
    return Optional.ofNullable(messageBodyDataRef);
  }

  /**
   * This property is used for generation of the dictionary during serialization, and used as the "Type" mapping value for polymorphic when deserializing.
   */
  @JsonIgnore
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HttpRequestExtensionExt#getRequestMethod() requestMethod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for requestMethod (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final HttpRequestExtension withRequestMethod(String value) {
    if (Objects.equals(this.requestMethod, value)) return this;
    return validate(new HttpRequestExtension(
        value,
        this.requestValue,
        this.requestVersion,
        this.requestHeader,
        this.messageBodyLength,
        this.messageBodyDataRef,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HttpRequestExtensionExt#getRequestValue() requestValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for requestValue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final HttpRequestExtension withRequestValue(String value) {
    if (Objects.equals(this.requestValue, value)) return this;
    return validate(new HttpRequestExtension(
        this.requestMethod,
        value,
        this.requestVersion,
        this.requestHeader,
        this.messageBodyLength,
        this.messageBodyDataRef,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HttpRequestExtensionExt#getRequestVersion() requestVersion} attribute.
   * @param value The value for requestVersion
   * @return A modified copy of {@code this} object
   */
  public final HttpRequestExtension withRequestVersion(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "requestVersion");
    if (Objects.equals(this.requestVersion, newValue)) return this;
    return validate(new HttpRequestExtension(
        this.requestMethod,
        this.requestValue,
        newValue,
        this.requestHeader,
        this.messageBodyLength,
        this.messageBodyDataRef,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HttpRequestExtensionExt#getRequestVersion() requestVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for requestVersion
   * @return A modified copy of {@code this} object
   */
  public final HttpRequestExtension withRequestVersion(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.requestVersion, value)) return this;
    return validate(new HttpRequestExtension(
        this.requestMethod,
        this.requestValue,
        value,
        this.requestHeader,
        this.messageBodyLength,
        this.messageBodyDataRef,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link HttpRequestExtensionExt#getRequestHeader() requestHeader} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the requestHeader map
   * @return A modified copy of {@code this} object
   */
  public final HttpRequestExtension withRequestHeader(Map<String, ? extends String> entries) {
    if (this.requestHeader == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return validate(new HttpRequestExtension(
        this.requestMethod,
        this.requestValue,
        this.requestVersion,
        newValue,
        this.messageBodyLength,
        this.messageBodyDataRef,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HttpRequestExtensionExt#getMessageBodyLength() messageBodyLength} attribute.
   * @param value The value for messageBodyLength
   * @return A modified copy of {@code this} object
   */
  public final HttpRequestExtension withMessageBodyLength(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.messageBodyLength, newValue)) return this;
    return validate(new HttpRequestExtension(
        this.requestMethod,
        this.requestValue,
        this.requestVersion,
        this.requestHeader,
        newValue,
        this.messageBodyDataRef,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HttpRequestExtensionExt#getMessageBodyLength() messageBodyLength} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for messageBodyLength
   * @return A modified copy of {@code this} object
   */
  public final HttpRequestExtension withMessageBodyLength(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.messageBodyLength, value)) return this;
    return validate(new HttpRequestExtension(
        this.requestMethod,
        this.requestValue,
        this.requestVersion,
        this.requestHeader,
        value,
        this.messageBodyDataRef,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HttpRequestExtensionExt#getMessageBodyDataRef() messageBodyDataRef} attribute.
   * @param value The value for messageBodyDataRef
   * @return A modified copy of {@code this} object
   */
  public final HttpRequestExtension withMessageBodyDataRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "messageBodyDataRef");
    if (Objects.equals(this.messageBodyDataRef, newValue)) return this;
    return validate(new HttpRequestExtension(
        this.requestMethod,
        this.requestValue,
        this.requestVersion,
        this.requestHeader,
        this.messageBodyLength,
        newValue,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HttpRequestExtensionExt#getMessageBodyDataRef() messageBodyDataRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for messageBodyDataRef
   * @return A modified copy of {@code this} object
   */
  public final HttpRequestExtension withMessageBodyDataRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.messageBodyDataRef, value)) return this;
    return validate(new HttpRequestExtension(
        this.requestMethod,
        this.requestValue,
        this.requestVersion,
        this.requestHeader,
        this.messageBodyLength,
        value,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HttpRequestExtensionExt#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final HttpRequestExtension withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new HttpRequestExtension(
        this.requestMethod,
        this.requestValue,
        this.requestVersion,
        this.requestHeader,
        this.messageBodyLength,
        this.messageBodyDataRef,
        value,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link HttpRequestExtensionExt#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final HttpRequestExtension withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new HttpRequestExtension(
        this.requestMethod,
        this.requestValue,
        this.requestVersion,
        this.requestHeader,
        this.messageBodyLength,
        this.messageBodyDataRef,
        this.type,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code HttpRequestExtension} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof HttpRequestExtension
        && equalTo((HttpRequestExtension) another);
  }

  private boolean equalTo(HttpRequestExtension another) {
    return Objects.equals(requestMethod, another.requestMethod)
        && Objects.equals(requestValue, another.requestValue)
        && Objects.equals(requestVersion, another.requestVersion)
        && requestHeader.equals(another.requestHeader)
        && Objects.equals(messageBodyLength, another.messageBodyLength)
        && Objects.equals(messageBodyDataRef, another.messageBodyDataRef)
        && Objects.equals(type, another.type)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code requestMethod}, {@code requestValue}, {@code requestVersion}, {@code requestHeader}, {@code messageBodyLength}, {@code messageBodyDataRef}, {@code type}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(requestMethod);
    h += (h << 5) + Objects.hashCode(requestValue);
    h += (h << 5) + Objects.hashCode(requestVersion);
    h += (h << 5) + requestHeader.hashCode();
    h += (h << 5) + Objects.hashCode(messageBodyLength);
    h += (h << 5) + Objects.hashCode(messageBodyDataRef);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HttpRequestExtension} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HttpRequestExtension")
        .omitNullValues()
        .add("requestMethod", requestMethod)
        .add("requestValue", requestValue)
        .add("requestVersion", requestVersion)
        .add("requestHeader", requestHeader)
        .add("messageBodyLength", messageBodyLength)
        .add("messageBodyDataRef", messageBodyDataRef)
        .add("type", type)
        .add("customProperties", customProperties)
        .toString();
  }


  private static HttpRequestExtension validate(HttpRequestExtension instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link HttpRequestExtensionExt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HttpRequestExtension instance
   */
  public static HttpRequestExtension copyOf(HttpRequestExtensionExt instance) {
    if (instance instanceof HttpRequestExtension) {
      return (HttpRequestExtension) instance;
    }
    return HttpRequestExtension.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link HttpRequestExtension HttpRequestExtension}.
   * @return A new HttpRequestExtension builder
   */
  public static HttpRequestExtension.Builder builder() {
    return new HttpRequestExtension.Builder();
  }

  /**
   * Builds instances of type {@link HttpRequestExtension HttpRequestExtension}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HttpRequestExtensionExt", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"request_method", "request_value", "request_version", "request_header", "message_body_length", "message_body_data_ref"})
  @JsonTypeName("http-request-ext")
  public static final class Builder {
    private @Nullable String requestMethod;
    private @Nullable String requestValue;
    private @Nullable String requestVersion;
    private ImmutableMap.Builder<String, String> requestHeader = ImmutableMap.builder();
    private @Nullable Long messageBodyLength;
    private @Nullable String messageBodyDataRef;
    private @Nullable String type;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.types.HttpRequestExtensionExt} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HttpRequestExtensionExt instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableExtensionCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof HttpRequestExtensionExt) {
        HttpRequestExtensionExt instance = (HttpRequestExtensionExt) object;
        putAllRequestHeader(instance.getRequestHeader());
        Optional<String> requestVersionOptional = instance.getRequestVersion();
        if (requestVersionOptional.isPresent()) {
          requestVersion(requestVersionOptional);
        }
        String requestValueValue = instance.getRequestValue();
        if (requestValueValue != null) {
          requestValue(requestValueValue);
        }
        Optional<String> messageBodyDataRefOptional = instance.getMessageBodyDataRef();
        if (messageBodyDataRefOptional.isPresent()) {
          messageBodyDataRef(messageBodyDataRefOptional);
        }
        Optional<Long> messageBodyLengthOptional = instance.getMessageBodyLength();
        if (messageBodyLengthOptional.isPresent()) {
          messageBodyLength(messageBodyLengthOptional);
        }
        String requestMethodValue = instance.getRequestMethod();
        if (requestMethodValue != null) {
          requestMethod(requestMethodValue);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof CyberObservableExtensionCommonProperties) {
        CyberObservableExtensionCommonProperties instance = (CyberObservableExtensionCommonProperties) object;
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link HttpRequestExtensionExt#getRequestMethod() requestMethod} attribute.
     * @param requestMethod The value for requestMethod (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("request_method")
    @JsonPropertyDescription("Specifies the HTTP method portion of the HTTP request line, as a lowercase string.")
    public final Builder requestMethod(String requestMethod) {
      this.requestMethod = requestMethod;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpRequestExtensionExt#getRequestValue() requestValue} attribute.
     * @param requestValue The value for requestValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("request_value")
    @JsonPropertyDescription("Specifies the value (typically a resource path) portion of the HTTP request line.")
    public final Builder requestValue(String requestValue) {
      this.requestValue = requestValue;
      return this;
    }

    /**
     * Initializes the optional value {@link HttpRequestExtensionExt#getRequestVersion() requestVersion} to requestVersion.
     * @param requestVersion The value for requestVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder requestVersion(String requestVersion) {
      this.requestVersion = Objects.requireNonNull(requestVersion, "requestVersion");
      return this;
    }

    /**
     * Initializes the optional value {@link HttpRequestExtensionExt#getRequestVersion() requestVersion} to requestVersion.
     * @param requestVersion The value for requestVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("request_version")
    @JsonPropertyDescription("Specifies the HTTP version portion of the HTTP request line, as a lowercase string.")
    public final Builder requestVersion(Optional<String> requestVersion) {
      this.requestVersion = requestVersion.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link HttpRequestExtensionExt#getRequestHeader() requestHeader} map.
     * @param key The key in the requestHeader map
     * @param value The associated value in the requestHeader map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putRequestHeader(String key, String value) {
      this.requestHeader.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link HttpRequestExtensionExt#getRequestHeader() requestHeader} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putRequestHeader(Map.Entry<String, ? extends String> entry) {
      this.requestHeader.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link HttpRequestExtensionExt#getRequestHeader() requestHeader} map. Nulls are not permitted
     * @param entries The entries that will be added to the requestHeader map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("request_header")
    @JsonPropertyDescription("Specifies all of the HTTP header fields that may be found in the HTTP client request, as a dictionary.")
    public final Builder requestHeader(Map<String, ? extends String> entries) {
      this.requestHeader = ImmutableMap.builder();
      return putAllRequestHeader(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link HttpRequestExtensionExt#getRequestHeader() requestHeader} map. Nulls are not permitted
     * @param entries The entries that will be added to the requestHeader map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllRequestHeader(Map<String, ? extends String> entries) {
      this.requestHeader.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link HttpRequestExtensionExt#getMessageBodyLength() messageBodyLength} to messageBodyLength.
     * @param messageBodyLength The value for messageBodyLength
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder messageBodyLength(long messageBodyLength) {
      this.messageBodyLength = messageBodyLength;
      return this;
    }

    /**
     * Initializes the optional value {@link HttpRequestExtensionExt#getMessageBodyLength() messageBodyLength} to messageBodyLength.
     * @param messageBodyLength The value for messageBodyLength
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("message_body_length")
    @JsonPropertyDescription("Specifies the length of the HTTP message body, if included, in bytes.")
    public final Builder messageBodyLength(Optional<Long> messageBodyLength) {
      this.messageBodyLength = messageBodyLength.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link HttpRequestExtensionExt#getMessageBodyDataRef() messageBodyDataRef} to messageBodyDataRef.
     * @param messageBodyDataRef The value for messageBodyDataRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder messageBodyDataRef(String messageBodyDataRef) {
      this.messageBodyDataRef = Objects.requireNonNull(messageBodyDataRef, "messageBodyDataRef");
      return this;
    }

    /**
     * Initializes the optional value {@link HttpRequestExtensionExt#getMessageBodyDataRef() messageBodyDataRef} to messageBodyDataRef.
     * @param messageBodyDataRef The value for messageBodyDataRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("message_body_data_ref")
    @JsonPropertyDescription("Specifies the data contained in the HTTP message body, if included.")
    public final Builder messageBodyDataRef(Optional<String> messageBodyDataRef) {
      this.messageBodyDataRef = messageBodyDataRef.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link HttpRequestExtensionExt#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonIgnore
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link HttpRequestExtensionExt#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link HttpRequestExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link HttpRequestExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link HttpRequestExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link HttpRequestExtension HttpRequestExtension}.
     * @return An immutable instance of HttpRequestExtension
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public HttpRequestExtension build() {
      return HttpRequestExtension.validate(new HttpRequestExtension(
          requestMethod,
          requestValue,
          requestVersion,
          requestHeader.build(),
          messageBodyLength,
          messageBodyDataRef,
          type,
          customProperties.build()));
    }
  }
}
