package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.objects.NetworkTrafficCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

/**
 * icmp-ext
 * <p>
 * The ICMP extension specifies a default extension for capturing network
 * traffic properties specific to ICMP.
 */
@Generated(from = "IcmpExtensionExt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("icmp-ext")
@AllowedParents(NetworkTrafficCoo.class)
public final class IcmpExtension
    implements IcmpExtensionExt, Serializable {
  private final String ocmpTypeHex;
  private final String icmpCodeHex;
  private final String type;
  private final ImmutableMap<String, Object> customProperties;

  private IcmpExtension(
      String ocmpTypeHex,
      String icmpCodeHex,
      String type,
      ImmutableMap<String, Object> customProperties) {
    this.ocmpTypeHex = ocmpTypeHex;
    this.icmpCodeHex = icmpCodeHex;
    this.type = type;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code ocmpTypeHex} attribute
   */
  @JsonProperty("icmp_type_hex")
  @JsonPropertyDescription("Specifies the ICMP type byte.")
  @Override
  public String getOcmpTypeHex() {
    return ocmpTypeHex;
  }

  /**
   * @return The value of the {@code icmpCodeHex} attribute
   */
  @JsonProperty("icmp_code_hex")
  @JsonPropertyDescription("Specifies the ICMP code byte.")
  @Override
  public String getIcmpCodeHex() {
    return icmpCodeHex;
  }

  /**
   * This property is used for generation of the dictionary during serialization, and used as the "Type" mapping value for polymorphic when deserializing.
   */
  @JsonIgnore
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcmpExtensionExt#getOcmpTypeHex() ocmpTypeHex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ocmpTypeHex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final IcmpExtension withOcmpTypeHex(String value) {
    if (Objects.equals(this.ocmpTypeHex, value)) return this;
    return validate(new IcmpExtension(value, this.icmpCodeHex, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcmpExtensionExt#getIcmpCodeHex() icmpCodeHex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for icmpCodeHex (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final IcmpExtension withIcmpCodeHex(String value) {
    if (Objects.equals(this.icmpCodeHex, value)) return this;
    return validate(new IcmpExtension(this.ocmpTypeHex, value, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcmpExtensionExt#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final IcmpExtension withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new IcmpExtension(this.ocmpTypeHex, this.icmpCodeHex, value, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link IcmpExtensionExt#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final IcmpExtension withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new IcmpExtension(this.ocmpTypeHex, this.icmpCodeHex, this.type, newValue));
  }

  /**
   * This instance is equal to all instances of {@code IcmpExtension} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof IcmpExtension
        && equalTo((IcmpExtension) another);
  }

  private boolean equalTo(IcmpExtension another) {
    return Objects.equals(ocmpTypeHex, another.ocmpTypeHex)
        && Objects.equals(icmpCodeHex, another.icmpCodeHex)
        && Objects.equals(type, another.type)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code ocmpTypeHex}, {@code icmpCodeHex}, {@code type}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(ocmpTypeHex);
    h += (h << 5) + Objects.hashCode(icmpCodeHex);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IcmpExtension} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IcmpExtension")
        .omitNullValues()
        .add("ocmpTypeHex", ocmpTypeHex)
        .add("icmpCodeHex", icmpCodeHex)
        .add("type", type)
        .add("customProperties", customProperties)
        .toString();
  }


  private static IcmpExtension validate(IcmpExtension instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link IcmpExtensionExt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IcmpExtension instance
   */
  public static IcmpExtension copyOf(IcmpExtensionExt instance) {
    if (instance instanceof IcmpExtension) {
      return (IcmpExtension) instance;
    }
    return IcmpExtension.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link IcmpExtension IcmpExtension}.
   * @return A new IcmpExtension builder
   */
  public static IcmpExtension.Builder builder() {
    return new IcmpExtension.Builder();
  }

  /**
   * Builds instances of type {@link IcmpExtension IcmpExtension}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IcmpExtensionExt", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"icmp_type_hex", "icmp_code_hex"})
  @JsonTypeName("icmp-ext")
  public static final class Builder {
    private @Nullable String ocmpTypeHex;
    private @Nullable String icmpCodeHex;
    private @Nullable String type;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.types.IcmpExtensionExt} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(IcmpExtensionExt instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableExtensionCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof IcmpExtensionExt) {
        IcmpExtensionExt instance = (IcmpExtensionExt) object;
        String ocmpTypeHexValue = instance.getOcmpTypeHex();
        if (ocmpTypeHexValue != null) {
          ocmpTypeHex(ocmpTypeHexValue);
        }
        String icmpCodeHexValue = instance.getIcmpCodeHex();
        if (icmpCodeHexValue != null) {
          icmpCodeHex(icmpCodeHexValue);
        }
      }
      if (object instanceof CyberObservableExtensionCommonProperties) {
        CyberObservableExtensionCommonProperties instance = (CyberObservableExtensionCommonProperties) object;
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link IcmpExtensionExt#getOcmpTypeHex() ocmpTypeHex} attribute.
     * @param ocmpTypeHex The value for ocmpTypeHex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("icmp_type_hex")
    @JsonPropertyDescription("Specifies the ICMP type byte.")
    public final Builder ocmpTypeHex(String ocmpTypeHex) {
      this.ocmpTypeHex = ocmpTypeHex;
      return this;
    }

    /**
     * Initializes the value for the {@link IcmpExtensionExt#getIcmpCodeHex() icmpCodeHex} attribute.
     * @param icmpCodeHex The value for icmpCodeHex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("icmp_code_hex")
    @JsonPropertyDescription("Specifies the ICMP code byte.")
    public final Builder icmpCodeHex(String icmpCodeHex) {
      this.icmpCodeHex = icmpCodeHex;
      return this;
    }

    /**
     * Initializes the value for the {@link IcmpExtensionExt#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonIgnore
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link IcmpExtensionExt#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link IcmpExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IcmpExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IcmpExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link IcmpExtension IcmpExtension}.
     * @return An immutable instance of IcmpExtension
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public IcmpExtension build() {
      return IcmpExtension.validate(new IcmpExtension(ocmpTypeHex, icmpCodeHex, type, customProperties.build()));
    }
  }
}
