package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.objects.NetworkTrafficCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

/**
 * socket-ext
 * <p>
 * The Network Socket extension specifies a default extension for capturing
 * network traffic properties associated with network sockets.
 */
@Generated(from = "NetworkSocketExtensionExt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("socket-ext")
@AllowedParents(NetworkTrafficCoo.class)
public final class NetworkSocketExtension
    implements NetworkSocketExtensionExt, Serializable {
  private final String addressFamily;
  private final @Nullable Boolean blocking;
  private final @Nullable Boolean listening;
  private final @Nullable String protocolFamily;
  private final ImmutableMap<String, String> options;
  private final @Nullable String socketType;
  private final @Nullable Long socketDescriptor;
  private final @Nullable Long socketHandle;
  private final String type;
  private final ImmutableMap<String, Object> customProperties;

  private NetworkSocketExtension(
      String addressFamily,
      @Nullable Boolean blocking,
      @Nullable Boolean listening,
      @Nullable String protocolFamily,
      ImmutableMap<String, String> options,
      @Nullable String socketType,
      @Nullable Long socketDescriptor,
      @Nullable Long socketHandle,
      String type,
      ImmutableMap<String, Object> customProperties) {
    this.addressFamily = addressFamily;
    this.blocking = blocking;
    this.listening = listening;
    this.protocolFamily = protocolFamily;
    this.options = options;
    this.socketType = socketType;
    this.socketDescriptor = socketDescriptor;
    this.socketHandle = socketHandle;
    this.type = type;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code addressFamily} attribute
   */
  @JsonProperty("address_family")
  @JsonPropertyDescription("Specifies the address family (AF_*) that the socket is configured for.")
  @Override
  public String getAddressFamily() {
    return addressFamily;
  }

  /**
   * @return The value of the {@code blocking} attribute
   */
  @JsonProperty("is_blocking")
  @JsonPropertyDescription("Specifies whether the socket is in blocking mode.")
  @Override
  public Optional<Boolean> getBlocking() {
    return Optional.ofNullable(blocking);
  }

  /**
   * @return The value of the {@code listening} attribute
   */
  @JsonProperty("is_listening")
  @JsonPropertyDescription("Specifies whether the socket is in listening mode.")
  @Override
  public Optional<Boolean> getListening() {
    return Optional.ofNullable(listening);
  }

  /**
   * @return The value of the {@code protocolFamily} attribute
   */
  @JsonProperty("protocol_family")
  @JsonPropertyDescription("Specifies the protocol family (PF_*) that the socket is configured for.")
  @Override
  public Optional<String> getProtocolFamily() {
    return Optional.ofNullable(protocolFamily);
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @JsonProperty("options")
  @JsonPropertyDescription("Specifies any options (SO_*) that may be used by the socket, as a dictionary.")
  @Override
  public ImmutableMap<String, String> getOptions() {
    return options;
  }

  /**
   * @return The value of the {@code socketType} attribute
   */
  @JsonProperty("socket_type")
  @JsonPropertyDescription("Specifies the type of the socket.")
  @Override
  public Optional<String> getSocketType() {
    return Optional.ofNullable(socketType);
  }

  /**
   * @return The value of the {@code socketDescriptor} attribute
   */
  @JsonProperty("socket_descriptor")
  @JsonPropertyDescription("Specifies the socket file descriptor value associated with the socket, as a non-negative integer.")
  @Override
  public Optional<Long> getSocketDescriptor() {
    return Optional.ofNullable(socketDescriptor);
  }

  /**
   * @return The value of the {@code socketHandle} attribute
   */
  @JsonProperty("socket_handle")
  @JsonPropertyDescription("Specifies the handle or inode value associated with the socket.")
  @Override
  public Optional<Long> getSocketHandle() {
    return Optional.ofNullable(socketHandle);
  }

  /**
   * This property is used for generation of the dictionary during serialization, and used as the "Type" mapping value for polymorphic when deserializing.
   */
  @JsonIgnore
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkSocketExtensionExt#getAddressFamily() addressFamily} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for addressFamily (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final NetworkSocketExtension withAddressFamily(String value) {
    if (Objects.equals(this.addressFamily, value)) return this;
    return validate(new NetworkSocketExtension(
        value,
        this.blocking,
        this.listening,
        this.protocolFamily,
        this.options,
        this.socketType,
        this.socketDescriptor,
        this.socketHandle,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkSocketExtensionExt#getBlocking() blocking} attribute.
   * @param value The value for blocking
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withBlocking(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.blocking, newValue)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        newValue,
        this.listening,
        this.protocolFamily,
        this.options,
        this.socketType,
        this.socketDescriptor,
        this.socketHandle,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkSocketExtensionExt#getBlocking() blocking} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for blocking
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withBlocking(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.blocking, value)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        value,
        this.listening,
        this.protocolFamily,
        this.options,
        this.socketType,
        this.socketDescriptor,
        this.socketHandle,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkSocketExtensionExt#getListening() listening} attribute.
   * @param value The value for listening
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withListening(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.listening, newValue)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        newValue,
        this.protocolFamily,
        this.options,
        this.socketType,
        this.socketDescriptor,
        this.socketHandle,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkSocketExtensionExt#getListening() listening} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for listening
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withListening(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.listening, value)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        value,
        this.protocolFamily,
        this.options,
        this.socketType,
        this.socketDescriptor,
        this.socketHandle,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkSocketExtensionExt#getProtocolFamily() protocolFamily} attribute.
   * @param value The value for protocolFamily
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withProtocolFamily(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "protocolFamily");
    if (Objects.equals(this.protocolFamily, newValue)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        this.listening,
        newValue,
        this.options,
        this.socketType,
        this.socketDescriptor,
        this.socketHandle,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkSocketExtensionExt#getProtocolFamily() protocolFamily} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for protocolFamily
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withProtocolFamily(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.protocolFamily, value)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        this.listening,
        value,
        this.options,
        this.socketType,
        this.socketDescriptor,
        this.socketHandle,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link NetworkSocketExtensionExt#getOptions() options} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the options map
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withOptions(Map<String, ? extends String> entries) {
    if (this.options == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        this.listening,
        this.protocolFamily,
        newValue,
        this.socketType,
        this.socketDescriptor,
        this.socketHandle,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkSocketExtensionExt#getSocketType() socketType} attribute.
   * @param value The value for socketType
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withSocketType(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "socketType");
    if (Objects.equals(this.socketType, newValue)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        this.listening,
        this.protocolFamily,
        this.options,
        newValue,
        this.socketDescriptor,
        this.socketHandle,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkSocketExtensionExt#getSocketType() socketType} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for socketType
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withSocketType(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.socketType, value)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        this.listening,
        this.protocolFamily,
        this.options,
        value,
        this.socketDescriptor,
        this.socketHandle,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkSocketExtensionExt#getSocketDescriptor() socketDescriptor} attribute.
   * @param value The value for socketDescriptor
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withSocketDescriptor(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.socketDescriptor, newValue)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        this.listening,
        this.protocolFamily,
        this.options,
        this.socketType,
        newValue,
        this.socketHandle,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkSocketExtensionExt#getSocketDescriptor() socketDescriptor} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for socketDescriptor
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withSocketDescriptor(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.socketDescriptor, value)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        this.listening,
        this.protocolFamily,
        this.options,
        this.socketType,
        value,
        this.socketHandle,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkSocketExtensionExt#getSocketHandle() socketHandle} attribute.
   * @param value The value for socketHandle
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withSocketHandle(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.socketHandle, newValue)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        this.listening,
        this.protocolFamily,
        this.options,
        this.socketType,
        this.socketDescriptor,
        newValue,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkSocketExtensionExt#getSocketHandle() socketHandle} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for socketHandle
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withSocketHandle(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.socketHandle, value)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        this.listening,
        this.protocolFamily,
        this.options,
        this.socketType,
        this.socketDescriptor,
        value,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkSocketExtensionExt#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final NetworkSocketExtension withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        this.listening,
        this.protocolFamily,
        this.options,
        this.socketType,
        this.socketDescriptor,
        this.socketHandle,
        value,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link NetworkSocketExtensionExt#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final NetworkSocketExtension withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new NetworkSocketExtension(
        this.addressFamily,
        this.blocking,
        this.listening,
        this.protocolFamily,
        this.options,
        this.socketType,
        this.socketDescriptor,
        this.socketHandle,
        this.type,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code NetworkSocketExtension} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof NetworkSocketExtension
        && equalTo((NetworkSocketExtension) another);
  }

  private boolean equalTo(NetworkSocketExtension another) {
    return Objects.equals(addressFamily, another.addressFamily)
        && Objects.equals(blocking, another.blocking)
        && Objects.equals(listening, another.listening)
        && Objects.equals(protocolFamily, another.protocolFamily)
        && options.equals(another.options)
        && Objects.equals(socketType, another.socketType)
        && Objects.equals(socketDescriptor, another.socketDescriptor)
        && Objects.equals(socketHandle, another.socketHandle)
        && Objects.equals(type, another.type)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code addressFamily}, {@code blocking}, {@code listening}, {@code protocolFamily}, {@code options}, {@code socketType}, {@code socketDescriptor}, {@code socketHandle}, {@code type}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(addressFamily);
    h += (h << 5) + Objects.hashCode(blocking);
    h += (h << 5) + Objects.hashCode(listening);
    h += (h << 5) + Objects.hashCode(protocolFamily);
    h += (h << 5) + options.hashCode();
    h += (h << 5) + Objects.hashCode(socketType);
    h += (h << 5) + Objects.hashCode(socketDescriptor);
    h += (h << 5) + Objects.hashCode(socketHandle);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NetworkSocketExtension} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NetworkSocketExtension")
        .omitNullValues()
        .add("addressFamily", addressFamily)
        .add("blocking", blocking)
        .add("listening", listening)
        .add("protocolFamily", protocolFamily)
        .add("options", options)
        .add("socketType", socketType)
        .add("socketDescriptor", socketDescriptor)
        .add("socketHandle", socketHandle)
        .add("type", type)
        .add("customProperties", customProperties)
        .toString();
  }


  private static NetworkSocketExtension validate(NetworkSocketExtension instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link NetworkSocketExtensionExt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NetworkSocketExtension instance
   */
  public static NetworkSocketExtension copyOf(NetworkSocketExtensionExt instance) {
    if (instance instanceof NetworkSocketExtension) {
      return (NetworkSocketExtension) instance;
    }
    return NetworkSocketExtension.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link NetworkSocketExtension NetworkSocketExtension}.
   * @return A new NetworkSocketExtension builder
   */
  public static NetworkSocketExtension.Builder builder() {
    return new NetworkSocketExtension.Builder();
  }

  /**
   * Builds instances of type {@link NetworkSocketExtension NetworkSocketExtension}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NetworkSocketExtensionExt", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"address_family", "is_blocking", "is_listening", "protocol_family", "options", "socket_type", "socket_descriptor", "socket_handle"})
  @JsonTypeName("socket-ext")
  public static final class Builder {
    private @Nullable String addressFamily;
    private @Nullable Boolean blocking;
    private @Nullable Boolean listening;
    private @Nullable String protocolFamily;
    private ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
    private @Nullable String socketType;
    private @Nullable Long socketDescriptor;
    private @Nullable Long socketHandle;
    private @Nullable String type;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.types.NetworkSocketExtensionExt} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NetworkSocketExtensionExt instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableExtensionCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof NetworkSocketExtensionExt) {
        NetworkSocketExtensionExt instance = (NetworkSocketExtensionExt) object;
        Optional<Boolean> listeningOptional = instance.getListening();
        if (listeningOptional.isPresent()) {
          listening(listeningOptional);
        }
        Optional<String> socketTypeOptional = instance.getSocketType();
        if (socketTypeOptional.isPresent()) {
          socketType(socketTypeOptional);
        }
        Optional<Long> socketDescriptorOptional = instance.getSocketDescriptor();
        if (socketDescriptorOptional.isPresent()) {
          socketDescriptor(socketDescriptorOptional);
        }
        Optional<Long> socketHandleOptional = instance.getSocketHandle();
        if (socketHandleOptional.isPresent()) {
          socketHandle(socketHandleOptional);
        }
        Optional<String> protocolFamilyOptional = instance.getProtocolFamily();
        if (protocolFamilyOptional.isPresent()) {
          protocolFamily(protocolFamilyOptional);
        }
        Optional<Boolean> blockingOptional = instance.getBlocking();
        if (blockingOptional.isPresent()) {
          blocking(blockingOptional);
        }
        putAllOptions(instance.getOptions());
        String addressFamilyValue = instance.getAddressFamily();
        if (addressFamilyValue != null) {
          addressFamily(addressFamilyValue);
        }
      }
      if (object instanceof CyberObservableExtensionCommonProperties) {
        CyberObservableExtensionCommonProperties instance = (CyberObservableExtensionCommonProperties) object;
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link NetworkSocketExtensionExt#getAddressFamily() addressFamily} attribute.
     * @param addressFamily The value for addressFamily (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("address_family")
    @JsonPropertyDescription("Specifies the address family (AF_*) that the socket is configured for.")
    public final Builder addressFamily(String addressFamily) {
      this.addressFamily = addressFamily;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkSocketExtensionExt#getBlocking() blocking} to blocking.
     * @param blocking The value for blocking
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blocking(boolean blocking) {
      this.blocking = blocking;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkSocketExtensionExt#getBlocking() blocking} to blocking.
     * @param blocking The value for blocking
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("is_blocking")
    @JsonPropertyDescription("Specifies whether the socket is in blocking mode.")
    public final Builder blocking(Optional<Boolean> blocking) {
      this.blocking = blocking.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkSocketExtensionExt#getListening() listening} to listening.
     * @param listening The value for listening
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder listening(boolean listening) {
      this.listening = listening;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkSocketExtensionExt#getListening() listening} to listening.
     * @param listening The value for listening
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("is_listening")
    @JsonPropertyDescription("Specifies whether the socket is in listening mode.")
    public final Builder listening(Optional<Boolean> listening) {
      this.listening = listening.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkSocketExtensionExt#getProtocolFamily() protocolFamily} to protocolFamily.
     * @param protocolFamily The value for protocolFamily
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder protocolFamily(String protocolFamily) {
      this.protocolFamily = Objects.requireNonNull(protocolFamily, "protocolFamily");
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkSocketExtensionExt#getProtocolFamily() protocolFamily} to protocolFamily.
     * @param protocolFamily The value for protocolFamily
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("protocol_family")
    @JsonPropertyDescription("Specifies the protocol family (PF_*) that the socket is configured for.")
    public final Builder protocolFamily(Optional<String> protocolFamily) {
      this.protocolFamily = protocolFamily.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link NetworkSocketExtensionExt#getOptions() options} map.
     * @param key The key in the options map
     * @param value The associated value in the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putOption(String key, String value) {
      this.options.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NetworkSocketExtensionExt#getOptions() options} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putOption(Map.Entry<String, ? extends String> entry) {
      this.options.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NetworkSocketExtensionExt#getOptions() options} map. Nulls are not permitted
     * @param entries The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("options")
    @JsonPropertyDescription("Specifies any options (SO_*) that may be used by the socket, as a dictionary.")
    public final Builder options(Map<String, ? extends String> entries) {
      this.options = ImmutableMap.builder();
      return putAllOptions(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NetworkSocketExtensionExt#getOptions() options} map. Nulls are not permitted
     * @param entries The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllOptions(Map<String, ? extends String> entries) {
      this.options.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkSocketExtensionExt#getSocketType() socketType} to socketType.
     * @param socketType The value for socketType
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder socketType(String socketType) {
      this.socketType = Objects.requireNonNull(socketType, "socketType");
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkSocketExtensionExt#getSocketType() socketType} to socketType.
     * @param socketType The value for socketType
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("socket_type")
    @JsonPropertyDescription("Specifies the type of the socket.")
    public final Builder socketType(Optional<String> socketType) {
      this.socketType = socketType.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkSocketExtensionExt#getSocketDescriptor() socketDescriptor} to socketDescriptor.
     * @param socketDescriptor The value for socketDescriptor
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder socketDescriptor(long socketDescriptor) {
      this.socketDescriptor = socketDescriptor;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkSocketExtensionExt#getSocketDescriptor() socketDescriptor} to socketDescriptor.
     * @param socketDescriptor The value for socketDescriptor
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("socket_descriptor")
    @JsonPropertyDescription("Specifies the socket file descriptor value associated with the socket, as a non-negative integer.")
    public final Builder socketDescriptor(Optional<Long> socketDescriptor) {
      this.socketDescriptor = socketDescriptor.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkSocketExtensionExt#getSocketHandle() socketHandle} to socketHandle.
     * @param socketHandle The value for socketHandle
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder socketHandle(long socketHandle) {
      this.socketHandle = socketHandle;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkSocketExtensionExt#getSocketHandle() socketHandle} to socketHandle.
     * @param socketHandle The value for socketHandle
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("socket_handle")
    @JsonPropertyDescription("Specifies the handle or inode value associated with the socket.")
    public final Builder socketHandle(Optional<Long> socketHandle) {
      this.socketHandle = socketHandle.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkSocketExtensionExt#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonIgnore
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link NetworkSocketExtensionExt#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NetworkSocketExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NetworkSocketExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NetworkSocketExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link NetworkSocketExtension NetworkSocketExtension}.
     * @return An immutable instance of NetworkSocketExtension
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public NetworkSocketExtension build() {
      return NetworkSocketExtension.validate(new NetworkSocketExtension(
          addressFamily,
          blocking,
          listening,
          protocolFamily,
          options.build(),
          socketType,
          socketDescriptor,
          socketHandle,
          type,
          customProperties.build()));
    }
  }
}
