package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

/**
 * The NTFS file extension specifies a default extension for capturing properties specific to the storage of the file on the NTFS file system.
 */
@Generated(from = "NtfsFileExtenstionExt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("ntfs-ext")
@AllowedParents(FileCoo.class)
public final class NtfsFileExtenstion
    implements NtfsFileExtenstionExt, Serializable {
  private final @Nullable String sid;
  private final String type;
  private final ImmutableMap<String, Object> customProperties;

  private NtfsFileExtenstion(
      @Nullable String sid,
      String type,
      ImmutableMap<String, Object> customProperties) {
    this.sid = sid;
    this.type = type;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code sid} attribute
   */
  @JsonProperty("sid")
  @JsonPropertyDescription("Specifies the security ID (SID) value assigned to the file.")
  @Override
  public Optional<String> getSid() {
    return Optional.ofNullable(sid);
  }

  /**
   * This property is used for generation of the dictionary during serialization, and used as the "Type" mapping value for polymorphic when deserializing.
   */
  @JsonIgnore
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NtfsFileExtenstionExt#getSid() sid} attribute.
   * @param value The value for sid
   * @return A modified copy of {@code this} object
   */
  public final NtfsFileExtenstion withSid(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "sid");
    if (Objects.equals(this.sid, newValue)) return this;
    return validate(new NtfsFileExtenstion(newValue, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NtfsFileExtenstionExt#getSid() sid} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sid
   * @return A modified copy of {@code this} object
   */
  public final NtfsFileExtenstion withSid(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.sid, value)) return this;
    return validate(new NtfsFileExtenstion(value, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NtfsFileExtenstionExt#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final NtfsFileExtenstion withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new NtfsFileExtenstion(this.sid, value, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link NtfsFileExtenstionExt#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final NtfsFileExtenstion withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new NtfsFileExtenstion(this.sid, this.type, newValue));
  }

  /**
   * This instance is equal to all instances of {@code NtfsFileExtenstion} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof NtfsFileExtenstion
        && equalTo((NtfsFileExtenstion) another);
  }

  private boolean equalTo(NtfsFileExtenstion another) {
    return Objects.equals(sid, another.sid)
        && Objects.equals(type, another.type)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code sid}, {@code type}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sid);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NtfsFileExtenstion} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NtfsFileExtenstion")
        .omitNullValues()
        .add("sid", sid)
        .add("type", type)
        .add("customProperties", customProperties)
        .toString();
  }


  private static NtfsFileExtenstion validate(NtfsFileExtenstion instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link NtfsFileExtenstionExt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NtfsFileExtenstion instance
   */
  public static NtfsFileExtenstion copyOf(NtfsFileExtenstionExt instance) {
    if (instance instanceof NtfsFileExtenstion) {
      return (NtfsFileExtenstion) instance;
    }
    return NtfsFileExtenstion.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link NtfsFileExtenstion NtfsFileExtenstion}.
   * @return A new NtfsFileExtenstion builder
   */
  public static NtfsFileExtenstion.Builder builder() {
    return new NtfsFileExtenstion.Builder();
  }

  /**
   * Builds instances of type {@link NtfsFileExtenstion NtfsFileExtenstion}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NtfsFileExtenstionExt", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"sid", "alternate_data_streams"})
  @JsonTypeName("ntfs-ext")
  public static final class Builder {
    private @Nullable String sid;
    private @Nullable String type;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.types.NtfsFileExtenstionExt} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NtfsFileExtenstionExt instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableExtensionCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof NtfsFileExtenstionExt) {
        NtfsFileExtenstionExt instance = (NtfsFileExtenstionExt) object;
        Optional<String> sidOptional = instance.getSid();
        if (sidOptional.isPresent()) {
          sid(sidOptional);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof CyberObservableExtensionCommonProperties) {
        CyberObservableExtensionCommonProperties instance = (CyberObservableExtensionCommonProperties) object;
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
      }
    }

    /**
     * Initializes the optional value {@link NtfsFileExtenstionExt#getSid() sid} to sid.
     * @param sid The value for sid
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sid(String sid) {
      this.sid = Objects.requireNonNull(sid, "sid");
      return this;
    }

    /**
     * Initializes the optional value {@link NtfsFileExtenstionExt#getSid() sid} to sid.
     * @param sid The value for sid
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("sid")
    @JsonPropertyDescription("Specifies the security ID (SID) value assigned to the file.")
    public final Builder sid(Optional<String> sid) {
      this.sid = sid.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link NtfsFileExtenstionExt#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonIgnore
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link NtfsFileExtenstionExt#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NtfsFileExtenstionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NtfsFileExtenstionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NtfsFileExtenstionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link NtfsFileExtenstion NtfsFileExtenstion}.
     * @return An immutable instance of NtfsFileExtenstion
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public NtfsFileExtenstion build() {
      return NtfsFileExtenstion.validate(new NtfsFileExtenstion(sid, type, customProperties.build()));
    }
  }
}
