package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

/**
 * The PDF file extension specifies a default extension for capturing properties
 * specific to PDF files.
 */
@Generated(from = "PdfFileExtensionExt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("pdf-ext")
@AllowedParents(FileCoo.class)
public final class PdfFileExtension
    implements PdfFileExtensionExt, Serializable {
  private final @Nullable String version;
  private final @Nullable Boolean isOptimized;
  private final ImmutableMap<String, String> documentInfoDict;
  private final @Nullable String pdfId0;
  private final @Nullable String pdfId1;
  private final String type;
  private final ImmutableMap<String, Object> customProperties;

  private PdfFileExtension(
      @Nullable String version,
      @Nullable Boolean isOptimized,
      ImmutableMap<String, String> documentInfoDict,
      @Nullable String pdfId0,
      @Nullable String pdfId1,
      String type,
      ImmutableMap<String, Object> customProperties) {
    this.version = version;
    this.isOptimized = isOptimized;
    this.documentInfoDict = documentInfoDict;
    this.pdfId0 = pdfId0;
    this.pdfId1 = pdfId1;
    this.type = type;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @JsonPropertyDescription("Specifies the decimal version number of the Optional<String> from the PDF header that specifies the version of the PDF specification to which the PDF file conforms. E.g., \'1.4\'.")
  @Override
  public Optional<String> getVersion() {
    return Optional.ofNullable(version);
  }

  /**
   * @return The value of the {@code isOptimized} attribute
   */
  @JsonProperty("is_optimized")
  @JsonPropertyDescription("Specifies whether the PDF file has been optimized.")
  @Override
  public Optional<Boolean> isOptimized() {
    return Optional.ofNullable(isOptimized);
  }

  /**
   * @return The value of the {@code documentInfoDict} attribute
   */
  @JsonProperty("document_info_dict")
  @JsonPropertyDescription("Specifies details of the PDF document information dictionary (DID), which includes properties like the document creation data and producer, as a dictionary.")
  @Override
  public ImmutableMap<String, String> getDocumentInfoDict() {
    return documentInfoDict;
  }

  /**
   * @return The value of the {@code pdfId0} attribute
   */
  @JsonProperty("pdfid0")
  @JsonPropertyDescription("Specifies the first file identifier found for the PDF file.")
  @Override
  public Optional<String> getPdfId0() {
    return Optional.ofNullable(pdfId0);
  }

  /**
   * @return The value of the {@code pdfId1} attribute
   */
  @JsonProperty("pdfid1")
  @JsonPropertyDescription("Specifies the second file identifier found for the PDF file.")
  @Override
  public Optional<String> getPdfId1() {
    return Optional.ofNullable(pdfId1);
  }

  /**
   * This property is used for generation of the dictionary during serialization, and used as the "Type" mapping value for polymorphic when deserializing.
   */
  @JsonIgnore
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PdfFileExtensionExt#getVersion() version} attribute.
   * @param value The value for version
   * @return A modified copy of {@code this} object
   */
  public final PdfFileExtension withVersion(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "version");
    if (Objects.equals(this.version, newValue)) return this;
    return validate(new PdfFileExtension(
        newValue,
        this.isOptimized,
        this.documentInfoDict,
        this.pdfId0,
        this.pdfId1,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PdfFileExtensionExt#getVersion() version} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for version
   * @return A modified copy of {@code this} object
   */
  public final PdfFileExtension withVersion(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.version, value)) return this;
    return validate(new PdfFileExtension(
        value,
        this.isOptimized,
        this.documentInfoDict,
        this.pdfId0,
        this.pdfId1,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PdfFileExtensionExt#isOptimized() isOptimized} attribute.
   * @param value The value for isOptimized
   * @return A modified copy of {@code this} object
   */
  public final PdfFileExtension withIsOptimized(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isOptimized, newValue)) return this;
    return validate(new PdfFileExtension(
        this.version,
        newValue,
        this.documentInfoDict,
        this.pdfId0,
        this.pdfId1,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PdfFileExtensionExt#isOptimized() isOptimized} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isOptimized
   * @return A modified copy of {@code this} object
   */
  public final PdfFileExtension withIsOptimized(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isOptimized, value)) return this;
    return validate(new PdfFileExtension(
        this.version,
        value,
        this.documentInfoDict,
        this.pdfId0,
        this.pdfId1,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link PdfFileExtensionExt#getDocumentInfoDict() documentInfoDict} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the documentInfoDict map
   * @return A modified copy of {@code this} object
   */
  public final PdfFileExtension withDocumentInfoDict(Map<String, ? extends String> entries) {
    if (this.documentInfoDict == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return validate(new PdfFileExtension(
        this.version,
        this.isOptimized,
        newValue,
        this.pdfId0,
        this.pdfId1,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PdfFileExtensionExt#getPdfId0() pdfId0} attribute.
   * @param value The value for pdfId0
   * @return A modified copy of {@code this} object
   */
  public final PdfFileExtension withPdfId0(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "pdfId0");
    if (Objects.equals(this.pdfId0, newValue)) return this;
    return validate(new PdfFileExtension(
        this.version,
        this.isOptimized,
        this.documentInfoDict,
        newValue,
        this.pdfId1,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PdfFileExtensionExt#getPdfId0() pdfId0} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for pdfId0
   * @return A modified copy of {@code this} object
   */
  public final PdfFileExtension withPdfId0(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.pdfId0, value)) return this;
    return validate(new PdfFileExtension(
        this.version,
        this.isOptimized,
        this.documentInfoDict,
        value,
        this.pdfId1,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PdfFileExtensionExt#getPdfId1() pdfId1} attribute.
   * @param value The value for pdfId1
   * @return A modified copy of {@code this} object
   */
  public final PdfFileExtension withPdfId1(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "pdfId1");
    if (Objects.equals(this.pdfId1, newValue)) return this;
    return validate(new PdfFileExtension(
        this.version,
        this.isOptimized,
        this.documentInfoDict,
        this.pdfId0,
        newValue,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PdfFileExtensionExt#getPdfId1() pdfId1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for pdfId1
   * @return A modified copy of {@code this} object
   */
  public final PdfFileExtension withPdfId1(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.pdfId1, value)) return this;
    return validate(new PdfFileExtension(
        this.version,
        this.isOptimized,
        this.documentInfoDict,
        this.pdfId0,
        value,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PdfFileExtensionExt#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final PdfFileExtension withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new PdfFileExtension(
        this.version,
        this.isOptimized,
        this.documentInfoDict,
        this.pdfId0,
        this.pdfId1,
        value,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link PdfFileExtensionExt#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final PdfFileExtension withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new PdfFileExtension(
        this.version,
        this.isOptimized,
        this.documentInfoDict,
        this.pdfId0,
        this.pdfId1,
        this.type,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code PdfFileExtension} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof PdfFileExtension
        && equalTo((PdfFileExtension) another);
  }

  private boolean equalTo(PdfFileExtension another) {
    return Objects.equals(version, another.version)
        && Objects.equals(isOptimized, another.isOptimized)
        && documentInfoDict.equals(another.documentInfoDict)
        && Objects.equals(pdfId0, another.pdfId0)
        && Objects.equals(pdfId1, another.pdfId1)
        && Objects.equals(type, another.type)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code version}, {@code isOptimized}, {@code documentInfoDict}, {@code pdfId0}, {@code pdfId1}, {@code type}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(isOptimized);
    h += (h << 5) + documentInfoDict.hashCode();
    h += (h << 5) + Objects.hashCode(pdfId0);
    h += (h << 5) + Objects.hashCode(pdfId1);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PdfFileExtension} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PdfFileExtension")
        .omitNullValues()
        .add("version", version)
        .add("isOptimized", isOptimized)
        .add("documentInfoDict", documentInfoDict)
        .add("pdfId0", pdfId0)
        .add("pdfId1", pdfId1)
        .add("type", type)
        .add("customProperties", customProperties)
        .toString();
  }


  private static PdfFileExtension validate(PdfFileExtension instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link PdfFileExtensionExt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PdfFileExtension instance
   */
  public static PdfFileExtension copyOf(PdfFileExtensionExt instance) {
    if (instance instanceof PdfFileExtension) {
      return (PdfFileExtension) instance;
    }
    return PdfFileExtension.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link PdfFileExtension PdfFileExtension}.
   * @return A new PdfFileExtension builder
   */
  public static PdfFileExtension.Builder builder() {
    return new PdfFileExtension.Builder();
  }

  /**
   * Builds instances of type {@link PdfFileExtension PdfFileExtension}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PdfFileExtensionExt", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"version", "is_optimized", "document_info_dict", "pdfid0", "pdfid1"})
  @JsonTypeName("pdf-ext")
  public static final class Builder {
    private @Nullable String version;
    private @Nullable Boolean isOptimized;
    private ImmutableMap.Builder<String, String> documentInfoDict = ImmutableMap.builder();
    private @Nullable String pdfId0;
    private @Nullable String pdfId1;
    private @Nullable String type;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.types.PdfFileExtensionExt} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PdfFileExtensionExt instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableExtensionCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PdfFileExtensionExt) {
        PdfFileExtensionExt instance = (PdfFileExtensionExt) object;
        Optional<Boolean> isOptimizedOptional = instance.isOptimized();
        if (isOptimizedOptional.isPresent()) {
          isOptimized(isOptimizedOptional);
        }
        Optional<String> pdfId1Optional = instance.getPdfId1();
        if (pdfId1Optional.isPresent()) {
          pdfId1(pdfId1Optional);
        }
        Optional<String> pdfId0Optional = instance.getPdfId0();
        if (pdfId0Optional.isPresent()) {
          pdfId0(pdfId0Optional);
        }
        Optional<String> versionOptional = instance.getVersion();
        if (versionOptional.isPresent()) {
          version(versionOptional);
        }
        putAllDocumentInfoDict(instance.getDocumentInfoDict());
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof CyberObservableExtensionCommonProperties) {
        CyberObservableExtensionCommonProperties instance = (CyberObservableExtensionCommonProperties) object;
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
      }
    }

    /**
     * Initializes the optional value {@link PdfFileExtensionExt#getVersion() version} to version.
     * @param version The value for version
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      return this;
    }

    /**
     * Initializes the optional value {@link PdfFileExtensionExt#getVersion() version} to version.
     * @param version The value for version
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    @JsonPropertyDescription("Specifies the decimal version number of the Optional<String> from the PDF header that specifies the version of the PDF specification to which the PDF file conforms. E.g., \'1.4\'.")
    public final Builder version(Optional<String> version) {
      this.version = version.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PdfFileExtensionExt#isOptimized() isOptimized} to isOptimized.
     * @param isOptimized The value for isOptimized
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isOptimized(boolean isOptimized) {
      this.isOptimized = isOptimized;
      return this;
    }

    /**
     * Initializes the optional value {@link PdfFileExtensionExt#isOptimized() isOptimized} to isOptimized.
     * @param isOptimized The value for isOptimized
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("is_optimized")
    @JsonPropertyDescription("Specifies whether the PDF file has been optimized.")
    public final Builder isOptimized(Optional<Boolean> isOptimized) {
      this.isOptimized = isOptimized.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link PdfFileExtensionExt#getDocumentInfoDict() documentInfoDict} map.
     * @param key The key in the documentInfoDict map
     * @param value The associated value in the documentInfoDict map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putDocumentInfoDict(String key, String value) {
      this.documentInfoDict.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link PdfFileExtensionExt#getDocumentInfoDict() documentInfoDict} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putDocumentInfoDict(Map.Entry<String, ? extends String> entry) {
      this.documentInfoDict.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PdfFileExtensionExt#getDocumentInfoDict() documentInfoDict} map. Nulls are not permitted
     * @param entries The entries that will be added to the documentInfoDict map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("document_info_dict")
    @JsonPropertyDescription("Specifies details of the PDF document information dictionary (DID), which includes properties like the document creation data and producer, as a dictionary.")
    public final Builder documentInfoDict(Map<String, ? extends String> entries) {
      this.documentInfoDict = ImmutableMap.builder();
      return putAllDocumentInfoDict(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PdfFileExtensionExt#getDocumentInfoDict() documentInfoDict} map. Nulls are not permitted
     * @param entries The entries that will be added to the documentInfoDict map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllDocumentInfoDict(Map<String, ? extends String> entries) {
      this.documentInfoDict.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link PdfFileExtensionExt#getPdfId0() pdfId0} to pdfId0.
     * @param pdfId0 The value for pdfId0
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pdfId0(String pdfId0) {
      this.pdfId0 = Objects.requireNonNull(pdfId0, "pdfId0");
      return this;
    }

    /**
     * Initializes the optional value {@link PdfFileExtensionExt#getPdfId0() pdfId0} to pdfId0.
     * @param pdfId0 The value for pdfId0
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("pdfid0")
    @JsonPropertyDescription("Specifies the first file identifier found for the PDF file.")
    public final Builder pdfId0(Optional<String> pdfId0) {
      this.pdfId0 = pdfId0.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PdfFileExtensionExt#getPdfId1() pdfId1} to pdfId1.
     * @param pdfId1 The value for pdfId1
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pdfId1(String pdfId1) {
      this.pdfId1 = Objects.requireNonNull(pdfId1, "pdfId1");
      return this;
    }

    /**
     * Initializes the optional value {@link PdfFileExtensionExt#getPdfId1() pdfId1} to pdfId1.
     * @param pdfId1 The value for pdfId1
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("pdfid1")
    @JsonPropertyDescription("Specifies the second file identifier found for the PDF file.")
    public final Builder pdfId1(Optional<String> pdfId1) {
      this.pdfId1 = pdfId1.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PdfFileExtensionExt#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonIgnore
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link PdfFileExtensionExt#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link PdfFileExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PdfFileExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PdfFileExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link PdfFileExtension PdfFileExtension}.
     * @return An immutable instance of PdfFileExtension
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PdfFileExtension build() {
      return PdfFileExtension.validate(new PdfFileExtension(
          version,
          isOptimized,
          documentInfoDict.build(),
          pdfId0,
          pdfId1,
          type,
          customProperties.build()));
    }
  }
}
