package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

/**
 * The Raster Image file extension specifies a default extension for capturing
 * properties specific to image files.
 */
@Generated(from = "RasterImageFileExtensionExt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("raster-image-ext")
@AllowedParents(FileCoo.class)
public final class RasterImageFileExtension
    implements RasterImageFileExtensionExt, Serializable {
  private final @Nullable Long imageHeight;
  private final @Nullable Long imageWidth;
  private final @Nullable Long bitsPerPixel;
  private final @Nullable String imageCompressionAlgorithm;
  private final ImmutableMap<String, Object> exifTags;
  private final String type;
  private final ImmutableMap<String, Object> customProperties;

  private RasterImageFileExtension(
      @Nullable Long imageHeight,
      @Nullable Long imageWidth,
      @Nullable Long bitsPerPixel,
      @Nullable String imageCompressionAlgorithm,
      ImmutableMap<String, Object> exifTags,
      String type,
      ImmutableMap<String, Object> customProperties) {
    this.imageHeight = imageHeight;
    this.imageWidth = imageWidth;
    this.bitsPerPixel = bitsPerPixel;
    this.imageCompressionAlgorithm = imageCompressionAlgorithm;
    this.exifTags = exifTags;
    this.type = type;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code imageHeight} attribute
   */
  @JsonProperty("image_height")
  @JsonPropertyDescription("Specifies the height of the image in the image file, in pixels.")
  @Override
  public Optional<Long> getImageHeight() {
    return Optional.ofNullable(imageHeight);
  }

  /**
   * @return The value of the {@code imageWidth} attribute
   */
  @JsonProperty("image_width")
  @JsonPropertyDescription("Specifies the width of the image in the image file, in pixels.")
  @Override
  public Optional<Long> getImageWidth() {
    return Optional.ofNullable(imageWidth);
  }

  /**
   * @return The value of the {@code bitsPerPixel} attribute
   */
  @JsonProperty("bits_per_pixel")
  @JsonPropertyDescription("Specifies the sum of bits used for each color channel in the image in the image file, and thus the total number of pixels used for expressing the color depth of the image.")
  @Override
  public Optional<Long> getBitsPerPixel() {
    return Optional.ofNullable(bitsPerPixel);
  }

  /**
   * @return The value of the {@code imageCompressionAlgorithm} attribute
   */
  @JsonProperty("image_compression_algorithm")
  @JsonPropertyDescription("Specifies the name of the compression algorithm used to compress the image in the image file, if applicable.")
  @Override
  public Optional<String> getImageCompressionAlgorithm() {
    return Optional.ofNullable(imageCompressionAlgorithm);
  }

  /**
   * @return The value of the {@code exifTags} attribute
   */
  @JsonProperty("exif_tags")
  @JsonPropertyDescription("Specifies the set of EXIF tags found in the image file, as a dictionary. Each key/value pair in the dictionary represents the name/value of a single EXIF tag.")
  @Override
  public ImmutableMap<String, Object> getExifTags() {
    return exifTags;
  }

  /**
   * This property is used for generation of the dictionary during serialization, and used as the "Type" mapping value for polymorphic when deserializing.
   */
  @JsonIgnore
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RasterImageFileExtensionExt#getImageHeight() imageHeight} attribute.
   * @param value The value for imageHeight
   * @return A modified copy of {@code this} object
   */
  public final RasterImageFileExtension withImageHeight(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.imageHeight, newValue)) return this;
    return validate(new RasterImageFileExtension(
        newValue,
        this.imageWidth,
        this.bitsPerPixel,
        this.imageCompressionAlgorithm,
        this.exifTags,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RasterImageFileExtensionExt#getImageHeight() imageHeight} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for imageHeight
   * @return A modified copy of {@code this} object
   */
  public final RasterImageFileExtension withImageHeight(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.imageHeight, value)) return this;
    return validate(new RasterImageFileExtension(
        value,
        this.imageWidth,
        this.bitsPerPixel,
        this.imageCompressionAlgorithm,
        this.exifTags,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RasterImageFileExtensionExt#getImageWidth() imageWidth} attribute.
   * @param value The value for imageWidth
   * @return A modified copy of {@code this} object
   */
  public final RasterImageFileExtension withImageWidth(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.imageWidth, newValue)) return this;
    return validate(new RasterImageFileExtension(
        this.imageHeight,
        newValue,
        this.bitsPerPixel,
        this.imageCompressionAlgorithm,
        this.exifTags,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RasterImageFileExtensionExt#getImageWidth() imageWidth} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for imageWidth
   * @return A modified copy of {@code this} object
   */
  public final RasterImageFileExtension withImageWidth(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.imageWidth, value)) return this;
    return validate(new RasterImageFileExtension(
        this.imageHeight,
        value,
        this.bitsPerPixel,
        this.imageCompressionAlgorithm,
        this.exifTags,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RasterImageFileExtensionExt#getBitsPerPixel() bitsPerPixel} attribute.
   * @param value The value for bitsPerPixel
   * @return A modified copy of {@code this} object
   */
  public final RasterImageFileExtension withBitsPerPixel(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.bitsPerPixel, newValue)) return this;
    return validate(new RasterImageFileExtension(
        this.imageHeight,
        this.imageWidth,
        newValue,
        this.imageCompressionAlgorithm,
        this.exifTags,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RasterImageFileExtensionExt#getBitsPerPixel() bitsPerPixel} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for bitsPerPixel
   * @return A modified copy of {@code this} object
   */
  public final RasterImageFileExtension withBitsPerPixel(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.bitsPerPixel, value)) return this;
    return validate(new RasterImageFileExtension(
        this.imageHeight,
        this.imageWidth,
        value,
        this.imageCompressionAlgorithm,
        this.exifTags,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RasterImageFileExtensionExt#getImageCompressionAlgorithm() imageCompressionAlgorithm} attribute.
   * @param value The value for imageCompressionAlgorithm
   * @return A modified copy of {@code this} object
   */
  public final RasterImageFileExtension withImageCompressionAlgorithm(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "imageCompressionAlgorithm");
    if (Objects.equals(this.imageCompressionAlgorithm, newValue)) return this;
    return validate(new RasterImageFileExtension(
        this.imageHeight,
        this.imageWidth,
        this.bitsPerPixel,
        newValue,
        this.exifTags,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RasterImageFileExtensionExt#getImageCompressionAlgorithm() imageCompressionAlgorithm} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for imageCompressionAlgorithm
   * @return A modified copy of {@code this} object
   */
  public final RasterImageFileExtension withImageCompressionAlgorithm(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.imageCompressionAlgorithm, value)) return this;
    return validate(new RasterImageFileExtension(
        this.imageHeight,
        this.imageWidth,
        this.bitsPerPixel,
        value,
        this.exifTags,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link RasterImageFileExtensionExt#getExifTags() exifTags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the exifTags map
   * @return A modified copy of {@code this} object
   */
  public final RasterImageFileExtension withExifTags(Map<String, ? extends Object> entries) {
    if (this.exifTags == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new RasterImageFileExtension(
        this.imageHeight,
        this.imageWidth,
        this.bitsPerPixel,
        this.imageCompressionAlgorithm,
        newValue,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RasterImageFileExtensionExt#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final RasterImageFileExtension withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new RasterImageFileExtension(
        this.imageHeight,
        this.imageWidth,
        this.bitsPerPixel,
        this.imageCompressionAlgorithm,
        this.exifTags,
        value,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link RasterImageFileExtensionExt#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final RasterImageFileExtension withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new RasterImageFileExtension(
        this.imageHeight,
        this.imageWidth,
        this.bitsPerPixel,
        this.imageCompressionAlgorithm,
        this.exifTags,
        this.type,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code RasterImageFileExtension} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof RasterImageFileExtension
        && equalTo((RasterImageFileExtension) another);
  }

  private boolean equalTo(RasterImageFileExtension another) {
    return Objects.equals(imageHeight, another.imageHeight)
        && Objects.equals(imageWidth, another.imageWidth)
        && Objects.equals(bitsPerPixel, another.bitsPerPixel)
        && Objects.equals(imageCompressionAlgorithm, another.imageCompressionAlgorithm)
        && exifTags.equals(another.exifTags)
        && Objects.equals(type, another.type)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code imageHeight}, {@code imageWidth}, {@code bitsPerPixel}, {@code imageCompressionAlgorithm}, {@code exifTags}, {@code type}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(imageHeight);
    h += (h << 5) + Objects.hashCode(imageWidth);
    h += (h << 5) + Objects.hashCode(bitsPerPixel);
    h += (h << 5) + Objects.hashCode(imageCompressionAlgorithm);
    h += (h << 5) + exifTags.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RasterImageFileExtension} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RasterImageFileExtension")
        .omitNullValues()
        .add("imageHeight", imageHeight)
        .add("imageWidth", imageWidth)
        .add("bitsPerPixel", bitsPerPixel)
        .add("imageCompressionAlgorithm", imageCompressionAlgorithm)
        .add("exifTags", exifTags)
        .add("type", type)
        .add("customProperties", customProperties)
        .toString();
  }


  private static RasterImageFileExtension validate(RasterImageFileExtension instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link RasterImageFileExtensionExt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RasterImageFileExtension instance
   */
  public static RasterImageFileExtension copyOf(RasterImageFileExtensionExt instance) {
    if (instance instanceof RasterImageFileExtension) {
      return (RasterImageFileExtension) instance;
    }
    return RasterImageFileExtension.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link RasterImageFileExtension RasterImageFileExtension}.
   * @return A new RasterImageFileExtension builder
   */
  public static RasterImageFileExtension.Builder builder() {
    return new RasterImageFileExtension.Builder();
  }

  /**
   * Builds instances of type {@link RasterImageFileExtension RasterImageFileExtension}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RasterImageFileExtensionExt", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"image_height", "image_width", "bits_per_pixel", "image_compression_algorithm", "exif_tags"})
  @JsonTypeName("raster-image-ext")
  public static final class Builder {
    private @Nullable Long imageHeight;
    private @Nullable Long imageWidth;
    private @Nullable Long bitsPerPixel;
    private @Nullable String imageCompressionAlgorithm;
    private ImmutableMap.Builder<String, Object> exifTags = ImmutableMap.builder();
    private @Nullable String type;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableExtensionCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.types.RasterImageFileExtensionExt} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RasterImageFileExtensionExt instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof CyberObservableExtensionCommonProperties) {
        CyberObservableExtensionCommonProperties instance = (CyberObservableExtensionCommonProperties) object;
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
      }
      if (object instanceof RasterImageFileExtensionExt) {
        RasterImageFileExtensionExt instance = (RasterImageFileExtensionExt) object;
        Optional<Long> imageWidthOptional = instance.getImageWidth();
        if (imageWidthOptional.isPresent()) {
          imageWidth(imageWidthOptional);
        }
        Optional<String> imageCompressionAlgorithmOptional = instance.getImageCompressionAlgorithm();
        if (imageCompressionAlgorithmOptional.isPresent()) {
          imageCompressionAlgorithm(imageCompressionAlgorithmOptional);
        }
        putAllExifTags(instance.getExifTags());
        Optional<Long> imageHeightOptional = instance.getImageHeight();
        if (imageHeightOptional.isPresent()) {
          imageHeight(imageHeightOptional);
        }
        Optional<Long> bitsPerPixelOptional = instance.getBitsPerPixel();
        if (bitsPerPixelOptional.isPresent()) {
          bitsPerPixel(bitsPerPixelOptional);
        }
      }
    }

    /**
     * Initializes the optional value {@link RasterImageFileExtensionExt#getImageHeight() imageHeight} to imageHeight.
     * @param imageHeight The value for imageHeight
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder imageHeight(long imageHeight) {
      this.imageHeight = imageHeight;
      return this;
    }

    /**
     * Initializes the optional value {@link RasterImageFileExtensionExt#getImageHeight() imageHeight} to imageHeight.
     * @param imageHeight The value for imageHeight
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("image_height")
    @JsonPropertyDescription("Specifies the height of the image in the image file, in pixels.")
    public final Builder imageHeight(Optional<Long> imageHeight) {
      this.imageHeight = imageHeight.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RasterImageFileExtensionExt#getImageWidth() imageWidth} to imageWidth.
     * @param imageWidth The value for imageWidth
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder imageWidth(long imageWidth) {
      this.imageWidth = imageWidth;
      return this;
    }

    /**
     * Initializes the optional value {@link RasterImageFileExtensionExt#getImageWidth() imageWidth} to imageWidth.
     * @param imageWidth The value for imageWidth
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("image_width")
    @JsonPropertyDescription("Specifies the width of the image in the image file, in pixels.")
    public final Builder imageWidth(Optional<Long> imageWidth) {
      this.imageWidth = imageWidth.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RasterImageFileExtensionExt#getBitsPerPixel() bitsPerPixel} to bitsPerPixel.
     * @param bitsPerPixel The value for bitsPerPixel
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bitsPerPixel(long bitsPerPixel) {
      this.bitsPerPixel = bitsPerPixel;
      return this;
    }

    /**
     * Initializes the optional value {@link RasterImageFileExtensionExt#getBitsPerPixel() bitsPerPixel} to bitsPerPixel.
     * @param bitsPerPixel The value for bitsPerPixel
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("bits_per_pixel")
    @JsonPropertyDescription("Specifies the sum of bits used for each color channel in the image in the image file, and thus the total number of pixels used for expressing the color depth of the image.")
    public final Builder bitsPerPixel(Optional<Long> bitsPerPixel) {
      this.bitsPerPixel = bitsPerPixel.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RasterImageFileExtensionExt#getImageCompressionAlgorithm() imageCompressionAlgorithm} to imageCompressionAlgorithm.
     * @param imageCompressionAlgorithm The value for imageCompressionAlgorithm
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder imageCompressionAlgorithm(String imageCompressionAlgorithm) {
      this.imageCompressionAlgorithm = Objects.requireNonNull(imageCompressionAlgorithm, "imageCompressionAlgorithm");
      return this;
    }

    /**
     * Initializes the optional value {@link RasterImageFileExtensionExt#getImageCompressionAlgorithm() imageCompressionAlgorithm} to imageCompressionAlgorithm.
     * @param imageCompressionAlgorithm The value for imageCompressionAlgorithm
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("image_compression_algorithm")
    @JsonPropertyDescription("Specifies the name of the compression algorithm used to compress the image in the image file, if applicable.")
    public final Builder imageCompressionAlgorithm(Optional<String> imageCompressionAlgorithm) {
      this.imageCompressionAlgorithm = imageCompressionAlgorithm.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link RasterImageFileExtensionExt#getExifTags() exifTags} map.
     * @param key The key in the exifTags map
     * @param value The associated value in the exifTags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putExifTag(String key, Object value) {
      this.exifTags.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link RasterImageFileExtensionExt#getExifTags() exifTags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putExifTag(Map.Entry<String, ? extends Object> entry) {
      this.exifTags.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link RasterImageFileExtensionExt#getExifTags() exifTags} map. Nulls are not permitted
     * @param entries The entries that will be added to the exifTags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("exif_tags")
    @JsonPropertyDescription("Specifies the set of EXIF tags found in the image file, as a dictionary. Each key/value pair in the dictionary represents the name/value of a single EXIF tag.")
    public final Builder exifTags(Map<String, ? extends Object> entries) {
      this.exifTags = ImmutableMap.builder();
      return putAllExifTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link RasterImageFileExtensionExt#getExifTags() exifTags} map. Nulls are not permitted
     * @param entries The entries that will be added to the exifTags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllExifTags(Map<String, ? extends Object> entries) {
      this.exifTags.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link RasterImageFileExtensionExt#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonIgnore
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link RasterImageFileExtensionExt#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link RasterImageFileExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link RasterImageFileExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link RasterImageFileExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link RasterImageFileExtension RasterImageFileExtension}.
     * @return An immutable instance of RasterImageFileExtension
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RasterImageFileExtension build() {
      return RasterImageFileExtension.validate(new RasterImageFileExtension(
          imageHeight,
          imageWidth,
          bitsPerPixel,
          imageCompressionAlgorithm,
          exifTags.build(),
          type,
          customProperties.build()));
    }
  }
}
