package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.objects.NetworkTrafficCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

/**
 * tcp-ext
 * <p>
 * The TCP extension specifies a default extension for capturing network traffic
 * properties specific to TCP.
 */
@Generated(from = "TcpExtensionExt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("tcp-ext")
@AllowedParents(NetworkTrafficCoo.class)
public final class TcpExtension
    implements TcpExtensionExt, Serializable {
  private final @Nullable String srcFlagsHex;
  private final @Nullable String dstFlagsHex;
  private final String type;
  private final ImmutableMap<String, Object> customProperties;

  private TcpExtension(
      @Nullable String srcFlagsHex,
      @Nullable String dstFlagsHex,
      String type,
      ImmutableMap<String, Object> customProperties) {
    this.srcFlagsHex = srcFlagsHex;
    this.dstFlagsHex = dstFlagsHex;
    this.type = type;
    this.customProperties = customProperties;
  }

  /**
   * Specifies the source TCP flags, as the union of all TCP flags observed
   * between the start of the traffic (as defined by the start property) and
   * the end of the traffic (as defined by the end property).
   */
  @JsonProperty("src_flags_hex")
  @JsonPropertyDescription("Specifies the source TCP flags, as the union of all TCP flags observed between the start of the traffic (as defined by the start property) and the end of the traffic (as defined by the end property). ")
  @Override
  public Optional<String> getSrcFlagsHex() {
    return Optional.ofNullable(srcFlagsHex);
  }

  /**
   * Specifies the destination TCP flags, as the union of all TCP flags
   * observed between the start of the traffic (as defined by the start
   * property) and the end of the traffic (as defined by the end property).
   */
  @JsonProperty("dst_flags_hex")
  @JsonPropertyDescription("Specifies the destination TCP flags, as the union of all TCP flags observed between the start of the traffic (as defined by the start property) and the end of the traffic (as defined by the end property).")
  @Override
  public Optional<String> getDstFlagsHex() {
    return Optional.ofNullable(dstFlagsHex);
  }

  /**
   * This property is used for generation of the dictionary during serialization, and used as the "Type" mapping value for polymorphic when deserializing.
   */
  @JsonIgnore
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TcpExtensionExt#getSrcFlagsHex() srcFlagsHex} attribute.
   * @param value The value for srcFlagsHex
   * @return A modified copy of {@code this} object
   */
  public final TcpExtension withSrcFlagsHex(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "srcFlagsHex");
    if (Objects.equals(this.srcFlagsHex, newValue)) return this;
    return validate(new TcpExtension(newValue, this.dstFlagsHex, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TcpExtensionExt#getSrcFlagsHex() srcFlagsHex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for srcFlagsHex
   * @return A modified copy of {@code this} object
   */
  public final TcpExtension withSrcFlagsHex(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.srcFlagsHex, value)) return this;
    return validate(new TcpExtension(value, this.dstFlagsHex, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TcpExtensionExt#getDstFlagsHex() dstFlagsHex} attribute.
   * @param value The value for dstFlagsHex
   * @return A modified copy of {@code this} object
   */
  public final TcpExtension withDstFlagsHex(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "dstFlagsHex");
    if (Objects.equals(this.dstFlagsHex, newValue)) return this;
    return validate(new TcpExtension(this.srcFlagsHex, newValue, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TcpExtensionExt#getDstFlagsHex() dstFlagsHex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dstFlagsHex
   * @return A modified copy of {@code this} object
   */
  public final TcpExtension withDstFlagsHex(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.dstFlagsHex, value)) return this;
    return validate(new TcpExtension(this.srcFlagsHex, value, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TcpExtensionExt#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final TcpExtension withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new TcpExtension(this.srcFlagsHex, this.dstFlagsHex, value, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link TcpExtensionExt#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final TcpExtension withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new TcpExtension(this.srcFlagsHex, this.dstFlagsHex, this.type, newValue));
  }

  /**
   * This instance is equal to all instances of {@code TcpExtension} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof TcpExtension
        && equalTo((TcpExtension) another);
  }

  private boolean equalTo(TcpExtension another) {
    return Objects.equals(srcFlagsHex, another.srcFlagsHex)
        && Objects.equals(dstFlagsHex, another.dstFlagsHex)
        && Objects.equals(type, another.type)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code srcFlagsHex}, {@code dstFlagsHex}, {@code type}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(srcFlagsHex);
    h += (h << 5) + Objects.hashCode(dstFlagsHex);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TcpExtension} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TcpExtension")
        .omitNullValues()
        .add("srcFlagsHex", srcFlagsHex)
        .add("dstFlagsHex", dstFlagsHex)
        .add("type", type)
        .add("customProperties", customProperties)
        .toString();
  }


  private static TcpExtension validate(TcpExtension instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link TcpExtensionExt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TcpExtension instance
   */
  public static TcpExtension copyOf(TcpExtensionExt instance) {
    if (instance instanceof TcpExtension) {
      return (TcpExtension) instance;
    }
    return TcpExtension.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link TcpExtension TcpExtension}.
   * @return A new TcpExtension builder
   */
  public static TcpExtension.Builder builder() {
    return new TcpExtension.Builder();
  }

  /**
   * Builds instances of type {@link TcpExtension TcpExtension}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TcpExtensionExt", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"src_flags_hex", "dst_flags_hex"})
  @JsonTypeName("tcp-ext")
  public static final class Builder {
    private @Nullable String srcFlagsHex;
    private @Nullable String dstFlagsHex;
    private @Nullable String type;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.types.TcpExtensionExt} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TcpExtensionExt instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableExtensionCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof TcpExtensionExt) {
        TcpExtensionExt instance = (TcpExtensionExt) object;
        Optional<String> srcFlagsHexOptional = instance.getSrcFlagsHex();
        if (srcFlagsHexOptional.isPresent()) {
          srcFlagsHex(srcFlagsHexOptional);
        }
        Optional<String> dstFlagsHexOptional = instance.getDstFlagsHex();
        if (dstFlagsHexOptional.isPresent()) {
          dstFlagsHex(dstFlagsHexOptional);
        }
      }
      if (object instanceof CyberObservableExtensionCommonProperties) {
        CyberObservableExtensionCommonProperties instance = (CyberObservableExtensionCommonProperties) object;
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
      }
    }

    /**
     * Initializes the optional value {@link TcpExtensionExt#getSrcFlagsHex() srcFlagsHex} to srcFlagsHex.
     * @param srcFlagsHex The value for srcFlagsHex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder srcFlagsHex(String srcFlagsHex) {
      this.srcFlagsHex = Objects.requireNonNull(srcFlagsHex, "srcFlagsHex");
      return this;
    }

    /**
     * Initializes the optional value {@link TcpExtensionExt#getSrcFlagsHex() srcFlagsHex} to srcFlagsHex.
     * @param srcFlagsHex The value for srcFlagsHex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("src_flags_hex")
    @JsonPropertyDescription("Specifies the source TCP flags, as the union of all TCP flags observed between the start of the traffic (as defined by the start property) and the end of the traffic (as defined by the end property). ")
    public final Builder srcFlagsHex(Optional<String> srcFlagsHex) {
      this.srcFlagsHex = srcFlagsHex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link TcpExtensionExt#getDstFlagsHex() dstFlagsHex} to dstFlagsHex.
     * @param dstFlagsHex The value for dstFlagsHex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dstFlagsHex(String dstFlagsHex) {
      this.dstFlagsHex = Objects.requireNonNull(dstFlagsHex, "dstFlagsHex");
      return this;
    }

    /**
     * Initializes the optional value {@link TcpExtensionExt#getDstFlagsHex() dstFlagsHex} to dstFlagsHex.
     * @param dstFlagsHex The value for dstFlagsHex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("dst_flags_hex")
    @JsonPropertyDescription("Specifies the destination TCP flags, as the union of all TCP flags observed between the start of the traffic (as defined by the start property) and the end of the traffic (as defined by the end property).")
    public final Builder dstFlagsHex(Optional<String> dstFlagsHex) {
      this.dstFlagsHex = dstFlagsHex.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link TcpExtensionExt#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonIgnore
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link TcpExtensionExt#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link TcpExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link TcpExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link TcpExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link TcpExtension TcpExtension}.
     * @return An immutable instance of TcpExtension
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TcpExtension build() {
      return TcpExtension.validate(new TcpExtension(srcFlagsHex, dstFlagsHex, type, customProperties.build()));
    }
  }
}
