package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.objects.UserAccountCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

/**
 * unix-account-ext
 * <p>
 * The UNIX account extension specifies a default extension for capturing the additional information
 * for an account on a UNIX system.
 */
@Generated(from = "UnixAccountExtensionExt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("unix-account-ext")
@AllowedParents(UserAccountCoo.class)
public final class UnixAccountExtension
    implements UnixAccountExtensionExt, Serializable {
  private final @Nullable Long gid;
  private final @Nullable String homeDir;
  private final @Nullable String shell;
  private final String type;
  private final ImmutableMap<String, Object> customProperties;

  private UnixAccountExtension(
      @Nullable Long gid,
      @Nullable String homeDir,
      @Nullable String shell,
      String type,
      ImmutableMap<String, Object> customProperties) {
    this.gid = gid;
    this.homeDir = homeDir;
    this.shell = shell;
    this.type = type;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code gid} attribute
   */
  @JsonProperty("gid")
  @JsonPropertyDescription("Specifies the primary group ID of the account.")
  @Override
  public Optional<Long> getGid() {
    return Optional.ofNullable(gid);
  }

  /**
   * @return The value of the {@code homeDir} attribute
   */
  @JsonProperty("home_dir")
  @JsonPropertyDescription("Specifies the home directory of the account.")
  @Override
  public Optional<String> getHomeDir() {
    return Optional.ofNullable(homeDir);
  }

  /**
   * @return The value of the {@code shell} attribute
   */
  @JsonProperty("shell")
  @JsonPropertyDescription("Specifies the account\u2019s command shell.")
  @Override
  public Optional<String> getShell() {
    return Optional.ofNullable(shell);
  }

  /**
   * This property is used for generation of the dictionary during serialization, and used as the "Type" mapping value for polymorphic when deserializing.
   */
  @JsonIgnore
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UnixAccountExtensionExt#getGid() gid} attribute.
   * @param value The value for gid
   * @return A modified copy of {@code this} object
   */
  public final UnixAccountExtension withGid(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.gid, newValue)) return this;
    return validate(new UnixAccountExtension(newValue, this.homeDir, this.shell, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UnixAccountExtensionExt#getGid() gid} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for gid
   * @return A modified copy of {@code this} object
   */
  public final UnixAccountExtension withGid(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.gid, value)) return this;
    return validate(new UnixAccountExtension(value, this.homeDir, this.shell, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UnixAccountExtensionExt#getHomeDir() homeDir} attribute.
   * @param value The value for homeDir
   * @return A modified copy of {@code this} object
   */
  public final UnixAccountExtension withHomeDir(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "homeDir");
    if (Objects.equals(this.homeDir, newValue)) return this;
    return validate(new UnixAccountExtension(this.gid, newValue, this.shell, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UnixAccountExtensionExt#getHomeDir() homeDir} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for homeDir
   * @return A modified copy of {@code this} object
   */
  public final UnixAccountExtension withHomeDir(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.homeDir, value)) return this;
    return validate(new UnixAccountExtension(this.gid, value, this.shell, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UnixAccountExtensionExt#getShell() shell} attribute.
   * @param value The value for shell
   * @return A modified copy of {@code this} object
   */
  public final UnixAccountExtension withShell(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "shell");
    if (Objects.equals(this.shell, newValue)) return this;
    return validate(new UnixAccountExtension(this.gid, this.homeDir, newValue, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UnixAccountExtensionExt#getShell() shell} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for shell
   * @return A modified copy of {@code this} object
   */
  public final UnixAccountExtension withShell(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.shell, value)) return this;
    return validate(new UnixAccountExtension(this.gid, this.homeDir, value, this.type, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UnixAccountExtensionExt#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final UnixAccountExtension withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new UnixAccountExtension(this.gid, this.homeDir, this.shell, value, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link UnixAccountExtensionExt#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final UnixAccountExtension withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new UnixAccountExtension(this.gid, this.homeDir, this.shell, this.type, newValue));
  }

  /**
   * This instance is equal to all instances of {@code UnixAccountExtension} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UnixAccountExtension
        && equalTo((UnixAccountExtension) another);
  }

  private boolean equalTo(UnixAccountExtension another) {
    return Objects.equals(gid, another.gid)
        && Objects.equals(homeDir, another.homeDir)
        && Objects.equals(shell, another.shell)
        && Objects.equals(type, another.type)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code gid}, {@code homeDir}, {@code shell}, {@code type}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(gid);
    h += (h << 5) + Objects.hashCode(homeDir);
    h += (h << 5) + Objects.hashCode(shell);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnixAccountExtension} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UnixAccountExtension")
        .omitNullValues()
        .add("gid", gid)
        .add("homeDir", homeDir)
        .add("shell", shell)
        .add("type", type)
        .add("customProperties", customProperties)
        .toString();
  }


  private static UnixAccountExtension validate(UnixAccountExtension instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link UnixAccountExtensionExt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UnixAccountExtension instance
   */
  public static UnixAccountExtension copyOf(UnixAccountExtensionExt instance) {
    if (instance instanceof UnixAccountExtension) {
      return (UnixAccountExtension) instance;
    }
    return UnixAccountExtension.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link UnixAccountExtension UnixAccountExtension}.
   * @return A new UnixAccountExtension builder
   */
  public static UnixAccountExtension.Builder builder() {
    return new UnixAccountExtension.Builder();
  }

  /**
   * Builds instances of type {@link UnixAccountExtension UnixAccountExtension}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UnixAccountExtensionExt", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"gid", "groups", "home_dir", "shell"})
  @JsonTypeName("unix-account-ext")
  public static final class Builder {
    private @Nullable Long gid;
    private @Nullable String homeDir;
    private @Nullable String shell;
    private @Nullable String type;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.types.UnixAccountExtensionExt} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UnixAccountExtensionExt instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableExtensionCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof UnixAccountExtensionExt) {
        UnixAccountExtensionExt instance = (UnixAccountExtensionExt) object;
        Optional<String> shellOptional = instance.getShell();
        if (shellOptional.isPresent()) {
          shell(shellOptional);
        }
        Optional<String> homeDirOptional = instance.getHomeDir();
        if (homeDirOptional.isPresent()) {
          homeDir(homeDirOptional);
        }
        Optional<Long> gidOptional = instance.getGid();
        if (gidOptional.isPresent()) {
          gid(gidOptional);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof CyberObservableExtensionCommonProperties) {
        CyberObservableExtensionCommonProperties instance = (CyberObservableExtensionCommonProperties) object;
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
      }
    }

    /**
     * Initializes the optional value {@link UnixAccountExtensionExt#getGid() gid} to gid.
     * @param gid The value for gid
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder gid(long gid) {
      this.gid = gid;
      return this;
    }

    /**
     * Initializes the optional value {@link UnixAccountExtensionExt#getGid() gid} to gid.
     * @param gid The value for gid
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("gid")
    @JsonPropertyDescription("Specifies the primary group ID of the account.")
    public final Builder gid(Optional<Long> gid) {
      this.gid = gid.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UnixAccountExtensionExt#getHomeDir() homeDir} to homeDir.
     * @param homeDir The value for homeDir
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder homeDir(String homeDir) {
      this.homeDir = Objects.requireNonNull(homeDir, "homeDir");
      return this;
    }

    /**
     * Initializes the optional value {@link UnixAccountExtensionExt#getHomeDir() homeDir} to homeDir.
     * @param homeDir The value for homeDir
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("home_dir")
    @JsonPropertyDescription("Specifies the home directory of the account.")
    public final Builder homeDir(Optional<String> homeDir) {
      this.homeDir = homeDir.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UnixAccountExtensionExt#getShell() shell} to shell.
     * @param shell The value for shell
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder shell(String shell) {
      this.shell = Objects.requireNonNull(shell, "shell");
      return this;
    }

    /**
     * Initializes the optional value {@link UnixAccountExtensionExt#getShell() shell} to shell.
     * @param shell The value for shell
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("shell")
    @JsonPropertyDescription("Specifies the account\u2019s command shell.")
    public final Builder shell(Optional<String> shell) {
      this.shell = shell.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link UnixAccountExtensionExt#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonIgnore
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link UnixAccountExtensionExt#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UnixAccountExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UnixAccountExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UnixAccountExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link UnixAccountExtension UnixAccountExtension}.
     * @return An immutable instance of UnixAccountExtension
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnixAccountExtension build() {
      return UnixAccountExtension.validate(new UnixAccountExtension(gid, homeDir, shell, type, customProperties.build()));
    }
  }
}
