package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.coo.types.WindowsPeOptionalHeaderObj;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

/**
 * The Windows PE Binary File extension specifies a default extension for
 * capturing properties specific to Windows portable executable (PE) files.
 */
@Generated(from = "WindowsPeBinaryFileExtensionExt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("windows-pebinary-ext")
@AllowedParents(FileCoo.class)
public final class WindowsPeBinaryFileExtension
    implements WindowsPeBinaryFileExtensionExt, Serializable {
  private final String peType;
  private final @Nullable String imphash;
  private final @Nullable String machineHex;
  private final @Nullable Long numberOfSections;
  private final @Nullable StixInstant timeDateStamp;
  private final @Nullable String pointerToSymbolTableHex;
  private final @Nullable Long numberOfSymbols;
  private final @Nullable Long sizeOfOptionalHeader;
  private final @Nullable String characteristicsHex;
  private final ImmutableMap<String, String> fileHeaderHashes;
  private final @Nullable WindowsPeOptionalHeaderObj optionalHeader;
  private final String type;
  private final ImmutableMap<String, Object> customProperties;

  private WindowsPeBinaryFileExtension(
      String peType,
      @Nullable String imphash,
      @Nullable String machineHex,
      @Nullable Long numberOfSections,
      @Nullable StixInstant timeDateStamp,
      @Nullable String pointerToSymbolTableHex,
      @Nullable Long numberOfSymbols,
      @Nullable Long sizeOfOptionalHeader,
      @Nullable String characteristicsHex,
      ImmutableMap<String, String> fileHeaderHashes,
      @Nullable WindowsPeOptionalHeaderObj optionalHeader,
      String type,
      ImmutableMap<String, Object> customProperties) {
    this.peType = peType;
    this.imphash = imphash;
    this.machineHex = machineHex;
    this.numberOfSections = numberOfSections;
    this.timeDateStamp = timeDateStamp;
    this.pointerToSymbolTableHex = pointerToSymbolTableHex;
    this.numberOfSymbols = numberOfSymbols;
    this.sizeOfOptionalHeader = sizeOfOptionalHeader;
    this.characteristicsHex = characteristicsHex;
    this.fileHeaderHashes = fileHeaderHashes;
    this.optionalHeader = optionalHeader;
    this.type = type;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code peType} attribute
   */
  @JsonProperty("pe_type")
  @JsonPropertyDescription("Specifies the type of the PE binary. Open Vocabulary - windows-pebinary-type-ov")
  @Override
  public String getPeType() {
    return peType;
  }

  /**
   * @return The value of the {@code imphash} attribute
   */
  @JsonProperty("imphash")
  @JsonPropertyDescription("Specifies the special import hash, or \'imphash\', calculated for the PE Binary based on its imported libraries and functions.")
  @Override
  public Optional<String> getImphash() {
    return Optional.ofNullable(imphash);
  }

  /**
   * @return The value of the {@code machineHex} attribute
   */
  @JsonProperty("machine_hex")
  @JsonPropertyDescription("Specifies the type of target machine.")
  @Override
  public Optional<String> getMachineHex() {
    return Optional.ofNullable(machineHex);
  }

  /**
   * @return The value of the {@code numberOfSections} attribute
   */
  @JsonProperty("number_of_sections")
  @JsonPropertyDescription("Specifies the number of sections in the PE binary, as a non-negative integer.")
  @Override
  public Optional<Long> getNumberOfSections() {
    return Optional.ofNullable(numberOfSections);
  }

  /**
   * @return The value of the {@code timeDateStamp} attribute
   */
  @JsonProperty("time_date_stamp")
  @JsonPropertyDescription("Specifies the time when the PE binary was created. The timestamp value MUST BE precise to the second.")
  @Override
  public Optional<StixInstant> getTimeDateStamp() {
    return Optional.ofNullable(timeDateStamp);
  }

  /**
   * @return The value of the {@code pointerToSymbolTableHex} attribute
   */
  @JsonProperty("pointer_to_symbol_table_hex")
  @JsonPropertyDescription("Specifies the file offset of the COFF symbol table.")
  @Override
  public Optional<String> getPointerToSymbolTableHex() {
    return Optional.ofNullable(pointerToSymbolTableHex);
  }

  /**
   * @return The value of the {@code numberOfSymbols} attribute
   */
  @JsonProperty("number_of_symbols")
  @JsonPropertyDescription("Specifies the number of entries in the symbol table of the PE binary, as a non-negative integer.")
  @Override
  public Optional<Long> getNumberOfSymbols() {
    return Optional.ofNullable(numberOfSymbols);
  }

  /**
   * @return The value of the {@code sizeOfOptionalHeader} attribute
   */
  @JsonProperty("size_of_optional_header")
  @JsonPropertyDescription("Specifies the size of the optional header of the PE binary.")
  @Override
  public Optional<Long> getSizeOfOptionalHeader() {
    return Optional.ofNullable(sizeOfOptionalHeader);
  }

  /**
   * @return The value of the {@code characteristicsHex} attribute
   */
  @JsonProperty("characteristics_hex")
  @JsonPropertyDescription("Specifies the flags that indicate the file\u2019s characteristics.")
  @Override
  public Optional<String> getCharacteristicsHex() {
    return Optional.ofNullable(characteristicsHex);
  }

  /**
   * @return The value of the {@code fileHeaderHashes} attribute
   */
  @JsonProperty("file_header_hashes")
  @JsonPropertyDescription("Specifies any hashes that were computed for the file header.")
  @Override
  public ImmutableMap<String, String> getFileHeaderHashes() {
    return fileHeaderHashes;
  }

  /**
   * @return The value of the {@code optionalHeader} attribute
   */
  @JsonProperty("optional_header")
  @JsonPropertyDescription("Specifies the PE optional header of the PE binary.")
  @Override
  public Optional<WindowsPeOptionalHeaderObj> getOptionalHeader() {
    return Optional.ofNullable(optionalHeader);
  }

  /**
   * This property is used for generation of the dictionary during serialization, and used as the "Type" mapping value for polymorphic when deserializing.
   */
  @JsonIgnore
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WindowsPeBinaryFileExtensionExt#getPeType() peType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for peType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final WindowsPeBinaryFileExtension withPeType(String value) {
    if (Objects.equals(this.peType, value)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        value,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeBinaryFileExtensionExt#getImphash() imphash} attribute.
   * @param value The value for imphash
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withImphash(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "imphash");
    if (Objects.equals(this.imphash, newValue)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        newValue,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeBinaryFileExtensionExt#getImphash() imphash} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for imphash
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withImphash(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.imphash, value)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        value,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeBinaryFileExtensionExt#getMachineHex() machineHex} attribute.
   * @param value The value for machineHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withMachineHex(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "machineHex");
    if (Objects.equals(this.machineHex, newValue)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        newValue,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeBinaryFileExtensionExt#getMachineHex() machineHex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for machineHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withMachineHex(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.machineHex, value)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        value,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeBinaryFileExtensionExt#getNumberOfSections() numberOfSections} attribute.
   * @param value The value for numberOfSections
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withNumberOfSections(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.numberOfSections, newValue)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        newValue,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeBinaryFileExtensionExt#getNumberOfSections() numberOfSections} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for numberOfSections
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withNumberOfSections(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.numberOfSections, value)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        value,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeBinaryFileExtensionExt#getTimeDateStamp() timeDateStamp} attribute.
   * @param value The value for timeDateStamp
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withTimeDateStamp(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "timeDateStamp");
    if (this.timeDateStamp == newValue) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        newValue,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeBinaryFileExtensionExt#getTimeDateStamp() timeDateStamp} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for timeDateStamp
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final WindowsPeBinaryFileExtension withTimeDateStamp(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.timeDateStamp == value) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        value,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeBinaryFileExtensionExt#getPointerToSymbolTableHex() pointerToSymbolTableHex} attribute.
   * @param value The value for pointerToSymbolTableHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withPointerToSymbolTableHex(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "pointerToSymbolTableHex");
    if (Objects.equals(this.pointerToSymbolTableHex, newValue)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        newValue,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeBinaryFileExtensionExt#getPointerToSymbolTableHex() pointerToSymbolTableHex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for pointerToSymbolTableHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withPointerToSymbolTableHex(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.pointerToSymbolTableHex, value)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        value,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeBinaryFileExtensionExt#getNumberOfSymbols() numberOfSymbols} attribute.
   * @param value The value for numberOfSymbols
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withNumberOfSymbols(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.numberOfSymbols, newValue)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        newValue,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeBinaryFileExtensionExt#getNumberOfSymbols() numberOfSymbols} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for numberOfSymbols
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withNumberOfSymbols(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.numberOfSymbols, value)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        value,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeBinaryFileExtensionExt#getSizeOfOptionalHeader() sizeOfOptionalHeader} attribute.
   * @param value The value for sizeOfOptionalHeader
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withSizeOfOptionalHeader(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.sizeOfOptionalHeader, newValue)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        newValue,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeBinaryFileExtensionExt#getSizeOfOptionalHeader() sizeOfOptionalHeader} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sizeOfOptionalHeader
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withSizeOfOptionalHeader(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.sizeOfOptionalHeader, value)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        value,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeBinaryFileExtensionExt#getCharacteristicsHex() characteristicsHex} attribute.
   * @param value The value for characteristicsHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withCharacteristicsHex(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "characteristicsHex");
    if (Objects.equals(this.characteristicsHex, newValue)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        newValue,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeBinaryFileExtensionExt#getCharacteristicsHex() characteristicsHex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for characteristicsHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withCharacteristicsHex(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.characteristicsHex, value)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        value,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link WindowsPeBinaryFileExtensionExt#getFileHeaderHashes() fileHeaderHashes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the fileHeaderHashes map
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withFileHeaderHashes(Map<String, ? extends String> entries) {
    if (this.fileHeaderHashes == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        newValue,
        this.optionalHeader,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeBinaryFileExtensionExt#getOptionalHeader() optionalHeader} attribute.
   * @param value The value for optionalHeader
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withOptionalHeader(WindowsPeOptionalHeaderObj value) {
    @Nullable WindowsPeOptionalHeaderObj newValue = Objects.requireNonNull(value, "optionalHeader");
    if (this.optionalHeader == newValue) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        newValue,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeBinaryFileExtensionExt#getOptionalHeader() optionalHeader} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for optionalHeader
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final WindowsPeBinaryFileExtension withOptionalHeader(Optional<? extends WindowsPeOptionalHeaderObj> optional) {
    @Nullable WindowsPeOptionalHeaderObj value = optional.orElse(null);
    if (this.optionalHeader == value) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        value,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WindowsPeBinaryFileExtensionExt#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final WindowsPeBinaryFileExtension withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        value,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link WindowsPeBinaryFileExtensionExt#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeBinaryFileExtension withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new WindowsPeBinaryFileExtension(
        this.peType,
        this.imphash,
        this.machineHex,
        this.numberOfSections,
        this.timeDateStamp,
        this.pointerToSymbolTableHex,
        this.numberOfSymbols,
        this.sizeOfOptionalHeader,
        this.characteristicsHex,
        this.fileHeaderHashes,
        this.optionalHeader,
        this.type,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code WindowsPeBinaryFileExtension} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof WindowsPeBinaryFileExtension
        && equalTo((WindowsPeBinaryFileExtension) another);
  }

  private boolean equalTo(WindowsPeBinaryFileExtension another) {
    return Objects.equals(peType, another.peType)
        && Objects.equals(imphash, another.imphash)
        && Objects.equals(machineHex, another.machineHex)
        && Objects.equals(numberOfSections, another.numberOfSections)
        && Objects.equals(timeDateStamp, another.timeDateStamp)
        && Objects.equals(pointerToSymbolTableHex, another.pointerToSymbolTableHex)
        && Objects.equals(numberOfSymbols, another.numberOfSymbols)
        && Objects.equals(sizeOfOptionalHeader, another.sizeOfOptionalHeader)
        && Objects.equals(characteristicsHex, another.characteristicsHex)
        && fileHeaderHashes.equals(another.fileHeaderHashes)
        && Objects.equals(optionalHeader, another.optionalHeader)
        && Objects.equals(type, another.type)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code peType}, {@code imphash}, {@code machineHex}, {@code numberOfSections}, {@code timeDateStamp}, {@code pointerToSymbolTableHex}, {@code numberOfSymbols}, {@code sizeOfOptionalHeader}, {@code characteristicsHex}, {@code fileHeaderHashes}, {@code optionalHeader}, {@code type}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(peType);
    h += (h << 5) + Objects.hashCode(imphash);
    h += (h << 5) + Objects.hashCode(machineHex);
    h += (h << 5) + Objects.hashCode(numberOfSections);
    h += (h << 5) + Objects.hashCode(timeDateStamp);
    h += (h << 5) + Objects.hashCode(pointerToSymbolTableHex);
    h += (h << 5) + Objects.hashCode(numberOfSymbols);
    h += (h << 5) + Objects.hashCode(sizeOfOptionalHeader);
    h += (h << 5) + Objects.hashCode(characteristicsHex);
    h += (h << 5) + fileHeaderHashes.hashCode();
    h += (h << 5) + Objects.hashCode(optionalHeader);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WindowsPeBinaryFileExtension} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WindowsPeBinaryFileExtension")
        .omitNullValues()
        .add("peType", peType)
        .add("imphash", imphash)
        .add("machineHex", machineHex)
        .add("numberOfSections", numberOfSections)
        .add("timeDateStamp", timeDateStamp)
        .add("pointerToSymbolTableHex", pointerToSymbolTableHex)
        .add("numberOfSymbols", numberOfSymbols)
        .add("sizeOfOptionalHeader", sizeOfOptionalHeader)
        .add("characteristicsHex", characteristicsHex)
        .add("fileHeaderHashes", fileHeaderHashes)
        .add("optionalHeader", optionalHeader)
        .add("type", type)
        .add("customProperties", customProperties)
        .toString();
  }


  private static WindowsPeBinaryFileExtension validate(WindowsPeBinaryFileExtension instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link WindowsPeBinaryFileExtensionExt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WindowsPeBinaryFileExtension instance
   */
  public static WindowsPeBinaryFileExtension copyOf(WindowsPeBinaryFileExtensionExt instance) {
    if (instance instanceof WindowsPeBinaryFileExtension) {
      return (WindowsPeBinaryFileExtension) instance;
    }
    return WindowsPeBinaryFileExtension.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link WindowsPeBinaryFileExtension WindowsPeBinaryFileExtension}.
   * @return A new WindowsPeBinaryFileExtension builder
   */
  public static WindowsPeBinaryFileExtension.Builder builder() {
    return new WindowsPeBinaryFileExtension.Builder();
  }

  /**
   * Builds instances of type {@link WindowsPeBinaryFileExtension WindowsPeBinaryFileExtension}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WindowsPeBinaryFileExtensionExt", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"pe_type", "imphash", "machine_hex", "number_of_sections", "time_date_stamp", "pointer_to_symbol_table_hex", "number_of_symbols", "size_of_optional_header", "characteristics_hex", "file_header_hashes", "optional_header", "sections", "required"})
  @JsonTypeName("windows-pebinary-ext")
  public static final class Builder {
    private @Nullable String peType;
    private @Nullable String imphash;
    private @Nullable String machineHex;
    private @Nullable Long numberOfSections;
    private @Nullable StixInstant timeDateStamp;
    private @Nullable String pointerToSymbolTableHex;
    private @Nullable Long numberOfSymbols;
    private @Nullable Long sizeOfOptionalHeader;
    private @Nullable String characteristicsHex;
    private ImmutableMap.Builder<String, String> fileHeaderHashes = ImmutableMap.builder();
    private @Nullable WindowsPeOptionalHeaderObj optionalHeader;
    private @Nullable String type;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableExtensionCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.types.WindowsPeBinaryFileExtensionExt} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WindowsPeBinaryFileExtensionExt instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof CyberObservableExtensionCommonProperties) {
        CyberObservableExtensionCommonProperties instance = (CyberObservableExtensionCommonProperties) object;
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
      }
      if (object instanceof WindowsPeBinaryFileExtensionExt) {
        WindowsPeBinaryFileExtensionExt instance = (WindowsPeBinaryFileExtensionExt) object;
        Optional<StixInstant> timeDateStampOptional = instance.getTimeDateStamp();
        if (timeDateStampOptional.isPresent()) {
          timeDateStamp(timeDateStampOptional);
        }
        putAllFileHeaderHashes(instance.getFileHeaderHashes());
        Optional<String> imphashOptional = instance.getImphash();
        if (imphashOptional.isPresent()) {
          imphash(imphashOptional);
        }
        Optional<String> pointerToSymbolTableHexOptional = instance.getPointerToSymbolTableHex();
        if (pointerToSymbolTableHexOptional.isPresent()) {
          pointerToSymbolTableHex(pointerToSymbolTableHexOptional);
        }
        Optional<Long> sizeOfOptionalHeaderOptional = instance.getSizeOfOptionalHeader();
        if (sizeOfOptionalHeaderOptional.isPresent()) {
          sizeOfOptionalHeader(sizeOfOptionalHeaderOptional);
        }
        Optional<String> characteristicsHexOptional = instance.getCharacteristicsHex();
        if (characteristicsHexOptional.isPresent()) {
          characteristicsHex(characteristicsHexOptional);
        }
        String peTypeValue = instance.getPeType();
        if (peTypeValue != null) {
          peType(peTypeValue);
        }
        Optional<Long> numberOfSymbolsOptional = instance.getNumberOfSymbols();
        if (numberOfSymbolsOptional.isPresent()) {
          numberOfSymbols(numberOfSymbolsOptional);
        }
        Optional<WindowsPeOptionalHeaderObj> optionalHeaderOptional = instance.getOptionalHeader();
        if (optionalHeaderOptional.isPresent()) {
          optionalHeader(optionalHeaderOptional);
        }
        Optional<Long> numberOfSectionsOptional = instance.getNumberOfSections();
        if (numberOfSectionsOptional.isPresent()) {
          numberOfSections(numberOfSectionsOptional);
        }
        Optional<String> machineHexOptional = instance.getMachineHex();
        if (machineHexOptional.isPresent()) {
          machineHex(machineHexOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link WindowsPeBinaryFileExtensionExt#getPeType() peType} attribute.
     * @param peType The value for peType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("pe_type")
    @JsonPropertyDescription("Specifies the type of the PE binary. Open Vocabulary - windows-pebinary-type-ov")
    public final Builder peType(String peType) {
      this.peType = peType;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getImphash() imphash} to imphash.
     * @param imphash The value for imphash
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder imphash(String imphash) {
      this.imphash = Objects.requireNonNull(imphash, "imphash");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getImphash() imphash} to imphash.
     * @param imphash The value for imphash
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("imphash")
    @JsonPropertyDescription("Specifies the special import hash, or \'imphash\', calculated for the PE Binary based on its imported libraries and functions.")
    public final Builder imphash(Optional<String> imphash) {
      this.imphash = imphash.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getMachineHex() machineHex} to machineHex.
     * @param machineHex The value for machineHex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder machineHex(String machineHex) {
      this.machineHex = Objects.requireNonNull(machineHex, "machineHex");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getMachineHex() machineHex} to machineHex.
     * @param machineHex The value for machineHex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("machine_hex")
    @JsonPropertyDescription("Specifies the type of target machine.")
    public final Builder machineHex(Optional<String> machineHex) {
      this.machineHex = machineHex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getNumberOfSections() numberOfSections} to numberOfSections.
     * @param numberOfSections The value for numberOfSections
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder numberOfSections(long numberOfSections) {
      this.numberOfSections = numberOfSections;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getNumberOfSections() numberOfSections} to numberOfSections.
     * @param numberOfSections The value for numberOfSections
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("number_of_sections")
    @JsonPropertyDescription("Specifies the number of sections in the PE binary, as a non-negative integer.")
    public final Builder numberOfSections(Optional<Long> numberOfSections) {
      this.numberOfSections = numberOfSections.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getTimeDateStamp() timeDateStamp} to timeDateStamp.
     * @param timeDateStamp The value for timeDateStamp
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder timeDateStamp(StixInstant timeDateStamp) {
      this.timeDateStamp = Objects.requireNonNull(timeDateStamp, "timeDateStamp");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getTimeDateStamp() timeDateStamp} to timeDateStamp.
     * @param timeDateStamp The value for timeDateStamp
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("time_date_stamp")
    @JsonPropertyDescription("Specifies the time when the PE binary was created. The timestamp value MUST BE precise to the second.")
    public final Builder timeDateStamp(Optional<? extends StixInstant> timeDateStamp) {
      this.timeDateStamp = timeDateStamp.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getPointerToSymbolTableHex() pointerToSymbolTableHex} to pointerToSymbolTableHex.
     * @param pointerToSymbolTableHex The value for pointerToSymbolTableHex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pointerToSymbolTableHex(String pointerToSymbolTableHex) {
      this.pointerToSymbolTableHex = Objects.requireNonNull(pointerToSymbolTableHex, "pointerToSymbolTableHex");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getPointerToSymbolTableHex() pointerToSymbolTableHex} to pointerToSymbolTableHex.
     * @param pointerToSymbolTableHex The value for pointerToSymbolTableHex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("pointer_to_symbol_table_hex")
    @JsonPropertyDescription("Specifies the file offset of the COFF symbol table.")
    public final Builder pointerToSymbolTableHex(Optional<String> pointerToSymbolTableHex) {
      this.pointerToSymbolTableHex = pointerToSymbolTableHex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getNumberOfSymbols() numberOfSymbols} to numberOfSymbols.
     * @param numberOfSymbols The value for numberOfSymbols
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder numberOfSymbols(long numberOfSymbols) {
      this.numberOfSymbols = numberOfSymbols;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getNumberOfSymbols() numberOfSymbols} to numberOfSymbols.
     * @param numberOfSymbols The value for numberOfSymbols
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("number_of_symbols")
    @JsonPropertyDescription("Specifies the number of entries in the symbol table of the PE binary, as a non-negative integer.")
    public final Builder numberOfSymbols(Optional<Long> numberOfSymbols) {
      this.numberOfSymbols = numberOfSymbols.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getSizeOfOptionalHeader() sizeOfOptionalHeader} to sizeOfOptionalHeader.
     * @param sizeOfOptionalHeader The value for sizeOfOptionalHeader
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sizeOfOptionalHeader(long sizeOfOptionalHeader) {
      this.sizeOfOptionalHeader = sizeOfOptionalHeader;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getSizeOfOptionalHeader() sizeOfOptionalHeader} to sizeOfOptionalHeader.
     * @param sizeOfOptionalHeader The value for sizeOfOptionalHeader
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size_of_optional_header")
    @JsonPropertyDescription("Specifies the size of the optional header of the PE binary.")
    public final Builder sizeOfOptionalHeader(Optional<Long> sizeOfOptionalHeader) {
      this.sizeOfOptionalHeader = sizeOfOptionalHeader.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getCharacteristicsHex() characteristicsHex} to characteristicsHex.
     * @param characteristicsHex The value for characteristicsHex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder characteristicsHex(String characteristicsHex) {
      this.characteristicsHex = Objects.requireNonNull(characteristicsHex, "characteristicsHex");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getCharacteristicsHex() characteristicsHex} to characteristicsHex.
     * @param characteristicsHex The value for characteristicsHex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("characteristics_hex")
    @JsonPropertyDescription("Specifies the flags that indicate the file\u2019s characteristics.")
    public final Builder characteristicsHex(Optional<String> characteristicsHex) {
      this.characteristicsHex = characteristicsHex.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsPeBinaryFileExtensionExt#getFileHeaderHashes() fileHeaderHashes} map.
     * @param key The key in the fileHeaderHashes map
     * @param value The associated value in the fileHeaderHashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putFileHeaderHash(String key, String value) {
      this.fileHeaderHashes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsPeBinaryFileExtensionExt#getFileHeaderHashes() fileHeaderHashes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putFileHeaderHash(Map.Entry<String, ? extends String> entry) {
      this.fileHeaderHashes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link WindowsPeBinaryFileExtensionExt#getFileHeaderHashes() fileHeaderHashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the fileHeaderHashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("file_header_hashes")
    @JsonPropertyDescription("Specifies any hashes that were computed for the file header.")
    public final Builder fileHeaderHashes(Map<String, ? extends String> entries) {
      this.fileHeaderHashes = ImmutableMap.builder();
      return putAllFileHeaderHashes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link WindowsPeBinaryFileExtensionExt#getFileHeaderHashes() fileHeaderHashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the fileHeaderHashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllFileHeaderHashes(Map<String, ? extends String> entries) {
      this.fileHeaderHashes.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getOptionalHeader() optionalHeader} to optionalHeader.
     * @param optionalHeader The value for optionalHeader
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder optionalHeader(WindowsPeOptionalHeaderObj optionalHeader) {
      this.optionalHeader = Objects.requireNonNull(optionalHeader, "optionalHeader");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeBinaryFileExtensionExt#getOptionalHeader() optionalHeader} to optionalHeader.
     * @param optionalHeader The value for optionalHeader
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("optional_header")
    @JsonPropertyDescription("Specifies the PE optional header of the PE binary.")
    public final Builder optionalHeader(Optional<? extends WindowsPeOptionalHeaderObj> optionalHeader) {
      this.optionalHeader = optionalHeader.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link WindowsPeBinaryFileExtensionExt#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonIgnore
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link WindowsPeBinaryFileExtensionExt#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsPeBinaryFileExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link WindowsPeBinaryFileExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link WindowsPeBinaryFileExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link WindowsPeBinaryFileExtension WindowsPeBinaryFileExtension}.
     * @return An immutable instance of WindowsPeBinaryFileExtension
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public WindowsPeBinaryFileExtension build() {
      return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(
          peType,
          imphash,
          machineHex,
          numberOfSections,
          timeDateStamp,
          pointerToSymbolTableHex,
          numberOfSymbols,
          sizeOfOptionalHeader,
          characteristicsHex,
          fileHeaderHashes.build(),
          optionalHeader,
          type,
          customProperties.build()));
    }
  }
}
