package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.objects.ProcessCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

/**
 * The Windows Process extension specifies a default extension for capturing properties specific to Windows processes.
 */
@Generated(from = "WindowsProcessExtensionExt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("windows-process-ext")
@AllowedParents(ProcessCoo.class)
public final class WindowsProcessExtension
    implements WindowsProcessExtensionExt, Serializable {
  private final @Nullable Boolean isAslrEnabled;
  private final @Nullable Boolean isDepEnabled;
  private final @Nullable String priority;
  private final @Nullable String ownerSid;
  private final @Nullable String windowTitle;
  private final ImmutableMap<String, String> startupInfo;
  private final String type;
  private final ImmutableMap<String, Object> customProperties;

  private WindowsProcessExtension(
      @Nullable Boolean isAslrEnabled,
      @Nullable Boolean isDepEnabled,
      @Nullable String priority,
      @Nullable String ownerSid,
      @Nullable String windowTitle,
      ImmutableMap<String, String> startupInfo,
      String type,
      ImmutableMap<String, Object> customProperties) {
    this.isAslrEnabled = isAslrEnabled;
    this.isDepEnabled = isDepEnabled;
    this.priority = priority;
    this.ownerSid = ownerSid;
    this.windowTitle = windowTitle;
    this.startupInfo = startupInfo;
    this.type = type;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code isAslrEnabled} attribute
   */
  @JsonProperty("aslr_enabled")
  @JsonPropertyDescription("Specifies whether Address Space Layout Randomization (ASLR) is enabled for the process.")
  @Override
  public Optional<Boolean> isAslrEnabled() {
    return Optional.ofNullable(isAslrEnabled);
  }

  /**
   * @return The value of the {@code isDepEnabled} attribute
   */
  @JsonProperty("dep_enabled")
  @JsonPropertyDescription("Specifies whether Data Execution Prevention (DEP) is enabled for the process.")
  @Override
  public Optional<Boolean> isDepEnabled() {
    return Optional.ofNullable(isDepEnabled);
  }

  /**
   * @return The value of the {@code priority} attribute
   */
  @JsonProperty("priority")
  @JsonPropertyDescription("Specifies the current priority class of the process in Windows.")
  @Override
  public Optional<String> getPriority() {
    return Optional.ofNullable(priority);
  }

  /**
   * @return The value of the {@code ownerSid} attribute
   */
  @JsonProperty("owner_sid")
  @JsonPropertyDescription("Specifies the Security ID (SID) value of the owner of the process.")
  @Override
  public Optional<String> getOwnerSid() {
    return Optional.ofNullable(ownerSid);
  }

  /**
   * @return The value of the {@code windowTitle} attribute
   */
  @JsonProperty("window_title")
  @JsonPropertyDescription("Specifies the title of the main window of the process.")
  @Override
  public Optional<String> getWindowTitle() {
    return Optional.ofNullable(windowTitle);
  }

  /**
   * @return The value of the {@code startupInfo} attribute
   */
  @JsonProperty("startup_info")
  @JsonPropertyDescription("Specifies the STARTUP_INFO struct used by the process, as a dictionary.")
  @Override
  public ImmutableMap<String, String> getStartupInfo() {
    return startupInfo;
  }

  /**
   * This property is used for generation of the dictionary during serialization, and used as the "Type" mapping value for polymorphic when deserializing.
   */
  @JsonIgnore
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsProcessExtensionExt#isAslrEnabled() isAslrEnabled} attribute.
   * @param value The value for isAslrEnabled
   * @return A modified copy of {@code this} object
   */
  public final WindowsProcessExtension withIsAslrEnabled(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isAslrEnabled, newValue)) return this;
    return validate(new WindowsProcessExtension(
        newValue,
        this.isDepEnabled,
        this.priority,
        this.ownerSid,
        this.windowTitle,
        this.startupInfo,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsProcessExtensionExt#isAslrEnabled() isAslrEnabled} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isAslrEnabled
   * @return A modified copy of {@code this} object
   */
  public final WindowsProcessExtension withIsAslrEnabled(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isAslrEnabled, value)) return this;
    return validate(new WindowsProcessExtension(
        value,
        this.isDepEnabled,
        this.priority,
        this.ownerSid,
        this.windowTitle,
        this.startupInfo,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsProcessExtensionExt#isDepEnabled() isDepEnabled} attribute.
   * @param value The value for isDepEnabled
   * @return A modified copy of {@code this} object
   */
  public final WindowsProcessExtension withIsDepEnabled(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isDepEnabled, newValue)) return this;
    return validate(new WindowsProcessExtension(
        this.isAslrEnabled,
        newValue,
        this.priority,
        this.ownerSid,
        this.windowTitle,
        this.startupInfo,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsProcessExtensionExt#isDepEnabled() isDepEnabled} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isDepEnabled
   * @return A modified copy of {@code this} object
   */
  public final WindowsProcessExtension withIsDepEnabled(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isDepEnabled, value)) return this;
    return validate(new WindowsProcessExtension(
        this.isAslrEnabled,
        value,
        this.priority,
        this.ownerSid,
        this.windowTitle,
        this.startupInfo,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsProcessExtensionExt#getPriority() priority} attribute.
   * @param value The value for priority
   * @return A modified copy of {@code this} object
   */
  public final WindowsProcessExtension withPriority(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "priority");
    if (Objects.equals(this.priority, newValue)) return this;
    return validate(new WindowsProcessExtension(
        this.isAslrEnabled,
        this.isDepEnabled,
        newValue,
        this.ownerSid,
        this.windowTitle,
        this.startupInfo,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsProcessExtensionExt#getPriority() priority} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for priority
   * @return A modified copy of {@code this} object
   */
  public final WindowsProcessExtension withPriority(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.priority, value)) return this;
    return validate(new WindowsProcessExtension(
        this.isAslrEnabled,
        this.isDepEnabled,
        value,
        this.ownerSid,
        this.windowTitle,
        this.startupInfo,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsProcessExtensionExt#getOwnerSid() ownerSid} attribute.
   * @param value The value for ownerSid
   * @return A modified copy of {@code this} object
   */
  public final WindowsProcessExtension withOwnerSid(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "ownerSid");
    if (Objects.equals(this.ownerSid, newValue)) return this;
    return validate(new WindowsProcessExtension(
        this.isAslrEnabled,
        this.isDepEnabled,
        this.priority,
        newValue,
        this.windowTitle,
        this.startupInfo,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsProcessExtensionExt#getOwnerSid() ownerSid} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for ownerSid
   * @return A modified copy of {@code this} object
   */
  public final WindowsProcessExtension withOwnerSid(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.ownerSid, value)) return this;
    return validate(new WindowsProcessExtension(
        this.isAslrEnabled,
        this.isDepEnabled,
        this.priority,
        value,
        this.windowTitle,
        this.startupInfo,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsProcessExtensionExt#getWindowTitle() windowTitle} attribute.
   * @param value The value for windowTitle
   * @return A modified copy of {@code this} object
   */
  public final WindowsProcessExtension withWindowTitle(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "windowTitle");
    if (Objects.equals(this.windowTitle, newValue)) return this;
    return validate(new WindowsProcessExtension(
        this.isAslrEnabled,
        this.isDepEnabled,
        this.priority,
        this.ownerSid,
        newValue,
        this.startupInfo,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsProcessExtensionExt#getWindowTitle() windowTitle} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for windowTitle
   * @return A modified copy of {@code this} object
   */
  public final WindowsProcessExtension withWindowTitle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.windowTitle, value)) return this;
    return validate(new WindowsProcessExtension(
        this.isAslrEnabled,
        this.isDepEnabled,
        this.priority,
        this.ownerSid,
        value,
        this.startupInfo,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link WindowsProcessExtensionExt#getStartupInfo() startupInfo} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the startupInfo map
   * @return A modified copy of {@code this} object
   */
  public final WindowsProcessExtension withStartupInfo(Map<String, ? extends String> entries) {
    if (this.startupInfo == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return validate(new WindowsProcessExtension(
        this.isAslrEnabled,
        this.isDepEnabled,
        this.priority,
        this.ownerSid,
        this.windowTitle,
        newValue,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WindowsProcessExtensionExt#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final WindowsProcessExtension withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new WindowsProcessExtension(
        this.isAslrEnabled,
        this.isDepEnabled,
        this.priority,
        this.ownerSid,
        this.windowTitle,
        this.startupInfo,
        value,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link WindowsProcessExtensionExt#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final WindowsProcessExtension withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new WindowsProcessExtension(
        this.isAslrEnabled,
        this.isDepEnabled,
        this.priority,
        this.ownerSid,
        this.windowTitle,
        this.startupInfo,
        this.type,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code WindowsProcessExtension} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof WindowsProcessExtension
        && equalTo((WindowsProcessExtension) another);
  }

  private boolean equalTo(WindowsProcessExtension another) {
    return Objects.equals(isAslrEnabled, another.isAslrEnabled)
        && Objects.equals(isDepEnabled, another.isDepEnabled)
        && Objects.equals(priority, another.priority)
        && Objects.equals(ownerSid, another.ownerSid)
        && Objects.equals(windowTitle, another.windowTitle)
        && startupInfo.equals(another.startupInfo)
        && Objects.equals(type, another.type)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code isAslrEnabled}, {@code isDepEnabled}, {@code priority}, {@code ownerSid}, {@code windowTitle}, {@code startupInfo}, {@code type}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(isAslrEnabled);
    h += (h << 5) + Objects.hashCode(isDepEnabled);
    h += (h << 5) + Objects.hashCode(priority);
    h += (h << 5) + Objects.hashCode(ownerSid);
    h += (h << 5) + Objects.hashCode(windowTitle);
    h += (h << 5) + startupInfo.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WindowsProcessExtension} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WindowsProcessExtension")
        .omitNullValues()
        .add("isAslrEnabled", isAslrEnabled)
        .add("isDepEnabled", isDepEnabled)
        .add("priority", priority)
        .add("ownerSid", ownerSid)
        .add("windowTitle", windowTitle)
        .add("startupInfo", startupInfo)
        .add("type", type)
        .add("customProperties", customProperties)
        .toString();
  }


  private static WindowsProcessExtension validate(WindowsProcessExtension instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link WindowsProcessExtensionExt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WindowsProcessExtension instance
   */
  public static WindowsProcessExtension copyOf(WindowsProcessExtensionExt instance) {
    if (instance instanceof WindowsProcessExtension) {
      return (WindowsProcessExtension) instance;
    }
    return WindowsProcessExtension.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link WindowsProcessExtension WindowsProcessExtension}.
   * @return A new WindowsProcessExtension builder
   */
  public static WindowsProcessExtension.Builder builder() {
    return new WindowsProcessExtension.Builder();
  }

  /**
   * Builds instances of type {@link WindowsProcessExtension WindowsProcessExtension}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WindowsProcessExtensionExt", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"aslr_enabled", "dep_enabled", "priority", "owner_sid", "window_title", "startup_info"})
  @JsonTypeName("windows-process-ext")
  public static final class Builder {
    private @Nullable Boolean isAslrEnabled;
    private @Nullable Boolean isDepEnabled;
    private @Nullable String priority;
    private @Nullable String ownerSid;
    private @Nullable String windowTitle;
    private ImmutableMap.Builder<String, String> startupInfo = ImmutableMap.builder();
    private @Nullable String type;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.types.WindowsProcessExtensionExt} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WindowsProcessExtensionExt instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableExtensionCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof WindowsProcessExtensionExt) {
        WindowsProcessExtensionExt instance = (WindowsProcessExtensionExt) object;
        Optional<Boolean> isAslrEnabledOptional = instance.isAslrEnabled();
        if (isAslrEnabledOptional.isPresent()) {
          isAslrEnabled(isAslrEnabledOptional);
        }
        Optional<String> windowTitleOptional = instance.getWindowTitle();
        if (windowTitleOptional.isPresent()) {
          windowTitle(windowTitleOptional);
        }
        Optional<Boolean> isDepEnabledOptional = instance.isDepEnabled();
        if (isDepEnabledOptional.isPresent()) {
          isDepEnabled(isDepEnabledOptional);
        }
        Optional<String> ownerSidOptional = instance.getOwnerSid();
        if (ownerSidOptional.isPresent()) {
          ownerSid(ownerSidOptional);
        }
        Optional<String> priorityOptional = instance.getPriority();
        if (priorityOptional.isPresent()) {
          priority(priorityOptional);
        }
        putAllStartupInfo(instance.getStartupInfo());
      }
      if (object instanceof CyberObservableExtensionCommonProperties) {
        CyberObservableExtensionCommonProperties instance = (CyberObservableExtensionCommonProperties) object;
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
      }
    }

    /**
     * Initializes the optional value {@link WindowsProcessExtensionExt#isAslrEnabled() isAslrEnabled} to isAslrEnabled.
     * @param isAslrEnabled The value for isAslrEnabled
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isAslrEnabled(boolean isAslrEnabled) {
      this.isAslrEnabled = isAslrEnabled;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsProcessExtensionExt#isAslrEnabled() isAslrEnabled} to isAslrEnabled.
     * @param isAslrEnabled The value for isAslrEnabled
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("aslr_enabled")
    @JsonPropertyDescription("Specifies whether Address Space Layout Randomization (ASLR) is enabled for the process.")
    public final Builder isAslrEnabled(Optional<Boolean> isAslrEnabled) {
      this.isAslrEnabled = isAslrEnabled.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsProcessExtensionExt#isDepEnabled() isDepEnabled} to isDepEnabled.
     * @param isDepEnabled The value for isDepEnabled
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isDepEnabled(boolean isDepEnabled) {
      this.isDepEnabled = isDepEnabled;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsProcessExtensionExt#isDepEnabled() isDepEnabled} to isDepEnabled.
     * @param isDepEnabled The value for isDepEnabled
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("dep_enabled")
    @JsonPropertyDescription("Specifies whether Data Execution Prevention (DEP) is enabled for the process.")
    public final Builder isDepEnabled(Optional<Boolean> isDepEnabled) {
      this.isDepEnabled = isDepEnabled.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsProcessExtensionExt#getPriority() priority} to priority.
     * @param priority The value for priority
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder priority(String priority) {
      this.priority = Objects.requireNonNull(priority, "priority");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsProcessExtensionExt#getPriority() priority} to priority.
     * @param priority The value for priority
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("priority")
    @JsonPropertyDescription("Specifies the current priority class of the process in Windows.")
    public final Builder priority(Optional<String> priority) {
      this.priority = priority.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsProcessExtensionExt#getOwnerSid() ownerSid} to ownerSid.
     * @param ownerSid The value for ownerSid
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ownerSid(String ownerSid) {
      this.ownerSid = Objects.requireNonNull(ownerSid, "ownerSid");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsProcessExtensionExt#getOwnerSid() ownerSid} to ownerSid.
     * @param ownerSid The value for ownerSid
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("owner_sid")
    @JsonPropertyDescription("Specifies the Security ID (SID) value of the owner of the process.")
    public final Builder ownerSid(Optional<String> ownerSid) {
      this.ownerSid = ownerSid.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsProcessExtensionExt#getWindowTitle() windowTitle} to windowTitle.
     * @param windowTitle The value for windowTitle
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder windowTitle(String windowTitle) {
      this.windowTitle = Objects.requireNonNull(windowTitle, "windowTitle");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsProcessExtensionExt#getWindowTitle() windowTitle} to windowTitle.
     * @param windowTitle The value for windowTitle
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("window_title")
    @JsonPropertyDescription("Specifies the title of the main window of the process.")
    public final Builder windowTitle(Optional<String> windowTitle) {
      this.windowTitle = windowTitle.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsProcessExtensionExt#getStartupInfo() startupInfo} map.
     * @param key The key in the startupInfo map
     * @param value The associated value in the startupInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putStartupInfo(String key, String value) {
      this.startupInfo.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsProcessExtensionExt#getStartupInfo() startupInfo} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putStartupInfo(Map.Entry<String, ? extends String> entry) {
      this.startupInfo.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link WindowsProcessExtensionExt#getStartupInfo() startupInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the startupInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("startup_info")
    @JsonPropertyDescription("Specifies the STARTUP_INFO struct used by the process, as a dictionary.")
    public final Builder startupInfo(Map<String, ? extends String> entries) {
      this.startupInfo = ImmutableMap.builder();
      return putAllStartupInfo(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link WindowsProcessExtensionExt#getStartupInfo() startupInfo} map. Nulls are not permitted
     * @param entries The entries that will be added to the startupInfo map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllStartupInfo(Map<String, ? extends String> entries) {
      this.startupInfo.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link WindowsProcessExtensionExt#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonIgnore
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link WindowsProcessExtensionExt#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsProcessExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link WindowsProcessExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link WindowsProcessExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link WindowsProcessExtension WindowsProcessExtension}.
     * @return An immutable instance of WindowsProcessExtension
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public WindowsProcessExtension build() {
      return WindowsProcessExtension.validate(new WindowsProcessExtension(
          isAslrEnabled,
          isDepEnabled,
          priority,
          ownerSid,
          windowTitle,
          startupInfo.build(),
          type,
          customProperties.build()));
    }
  }
}
