package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.objects.ProcessCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

/**
 * windows-service-ext
 * <p>
 * The Windows Service extension specifies a default extension for capturing
 * properties specific to Windows services.
 */
@Generated(from = "WindowsServiceExtensionExt", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("windows-service-ext")
@AllowedParents(ProcessCoo.class)
public final class WindowsServiceExtension
    implements WindowsServiceExtensionExt, Serializable {
  private final String serviceName;
  private final @Nullable String displayName;
  private final @Nullable String groupName;
  private final @Nullable String serviceStartType;
  private final @Nullable String serviceType;
  private final @Nullable String serviceStatus;
  private final String type;
  private final ImmutableMap<String, Object> customProperties;

  private WindowsServiceExtension(
      String serviceName,
      @Nullable String displayName,
      @Nullable String groupName,
      @Nullable String serviceStartType,
      @Nullable String serviceType,
      @Nullable String serviceStatus,
      String type,
      ImmutableMap<String, Object> customProperties) {
    this.serviceName = serviceName;
    this.displayName = displayName;
    this.groupName = groupName;
    this.serviceStartType = serviceStartType;
    this.serviceType = serviceType;
    this.serviceStatus = serviceStatus;
    this.type = type;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code serviceName} attribute
   */
  @JsonProperty("service_name")
  @JsonPropertyDescription("Specifies the name of the service.")
  @Override
  public String getServiceName() {
    return serviceName;
  }

  /**
   * @return The value of the {@code displayName} attribute
   */
  @JsonProperty("display_name")
  @JsonPropertyDescription("Specifies the displayed name of the service in Windows GUI controls.")
  @Override
  public Optional<String> getDisplayName() {
    return Optional.ofNullable(displayName);
  }

  /**
   * @return The value of the {@code groupName} attribute
   */
  @JsonProperty("group_name")
  @JsonPropertyDescription("Specifies the name of the load ordering group of which the service is a member.")
  @Override
  public Optional<String> getGroupName() {
    return Optional.ofNullable(groupName);
  }

  /**
   * @return The value of the {@code serviceStartType} attribute
   */
  @JsonProperty("start_type")
  @JsonPropertyDescription("Specifies the start options defined for the service. windows-service-start-enum")
  @Override
  public Optional<String> getServiceStartType() {
    return Optional.ofNullable(serviceStartType);
  }

  /**
   * @return The value of the {@code serviceType} attribute
   */
  @JsonProperty("service_type")
  @JsonPropertyDescription("Specifies the type of the service. windows-service-enum")
  @Override
  public Optional<String> getServiceType() {
    return Optional.ofNullable(serviceType);
  }

  /**
   * @return The value of the {@code serviceStatus} attribute
   */
  @JsonProperty("service_status")
  @JsonPropertyDescription("Specifies the current status of the service. windows-service-status-enum")
  @Override
  public Optional<String> getServiceStatus() {
    return Optional.ofNullable(serviceStatus);
  }

  /**
   * This property is used for generation of the dictionary during serialization, and used as the "Type" mapping value for polymorphic when deserializing.
   */
  @JsonIgnore
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WindowsServiceExtensionExt#getServiceName() serviceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serviceName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final WindowsServiceExtension withServiceName(String value) {
    if (Objects.equals(this.serviceName, value)) return this;
    return validate(new WindowsServiceExtension(
        value,
        this.displayName,
        this.groupName,
        this.serviceStartType,
        this.serviceType,
        this.serviceStatus,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsServiceExtensionExt#getDisplayName() displayName} attribute.
   * @param value The value for displayName
   * @return A modified copy of {@code this} object
   */
  public final WindowsServiceExtension withDisplayName(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "displayName");
    if (Objects.equals(this.displayName, newValue)) return this;
    return validate(new WindowsServiceExtension(
        this.serviceName,
        newValue,
        this.groupName,
        this.serviceStartType,
        this.serviceType,
        this.serviceStatus,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsServiceExtensionExt#getDisplayName() displayName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for displayName
   * @return A modified copy of {@code this} object
   */
  public final WindowsServiceExtension withDisplayName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.displayName, value)) return this;
    return validate(new WindowsServiceExtension(
        this.serviceName,
        value,
        this.groupName,
        this.serviceStartType,
        this.serviceType,
        this.serviceStatus,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsServiceExtensionExt#getGroupName() groupName} attribute.
   * @param value The value for groupName
   * @return A modified copy of {@code this} object
   */
  public final WindowsServiceExtension withGroupName(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "groupName");
    if (Objects.equals(this.groupName, newValue)) return this;
    return validate(new WindowsServiceExtension(
        this.serviceName,
        this.displayName,
        newValue,
        this.serviceStartType,
        this.serviceType,
        this.serviceStatus,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsServiceExtensionExt#getGroupName() groupName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for groupName
   * @return A modified copy of {@code this} object
   */
  public final WindowsServiceExtension withGroupName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.groupName, value)) return this;
    return validate(new WindowsServiceExtension(
        this.serviceName,
        this.displayName,
        value,
        this.serviceStartType,
        this.serviceType,
        this.serviceStatus,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsServiceExtensionExt#getServiceStartType() serviceStartType} attribute.
   * @param value The value for serviceStartType
   * @return A modified copy of {@code this} object
   */
  public final WindowsServiceExtension withServiceStartType(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "serviceStartType");
    if (Objects.equals(this.serviceStartType, newValue)) return this;
    return validate(new WindowsServiceExtension(
        this.serviceName,
        this.displayName,
        this.groupName,
        newValue,
        this.serviceType,
        this.serviceStatus,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsServiceExtensionExt#getServiceStartType() serviceStartType} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceStartType
   * @return A modified copy of {@code this} object
   */
  public final WindowsServiceExtension withServiceStartType(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.serviceStartType, value)) return this;
    return validate(new WindowsServiceExtension(
        this.serviceName,
        this.displayName,
        this.groupName,
        value,
        this.serviceType,
        this.serviceStatus,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsServiceExtensionExt#getServiceType() serviceType} attribute.
   * @param value The value for serviceType
   * @return A modified copy of {@code this} object
   */
  public final WindowsServiceExtension withServiceType(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "serviceType");
    if (Objects.equals(this.serviceType, newValue)) return this;
    return validate(new WindowsServiceExtension(
        this.serviceName,
        this.displayName,
        this.groupName,
        this.serviceStartType,
        newValue,
        this.serviceStatus,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsServiceExtensionExt#getServiceType() serviceType} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceType
   * @return A modified copy of {@code this} object
   */
  public final WindowsServiceExtension withServiceType(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.serviceType, value)) return this;
    return validate(new WindowsServiceExtension(
        this.serviceName,
        this.displayName,
        this.groupName,
        this.serviceStartType,
        value,
        this.serviceStatus,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsServiceExtensionExt#getServiceStatus() serviceStatus} attribute.
   * @param value The value for serviceStatus
   * @return A modified copy of {@code this} object
   */
  public final WindowsServiceExtension withServiceStatus(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "serviceStatus");
    if (Objects.equals(this.serviceStatus, newValue)) return this;
    return validate(new WindowsServiceExtension(
        this.serviceName,
        this.displayName,
        this.groupName,
        this.serviceStartType,
        this.serviceType,
        newValue,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsServiceExtensionExt#getServiceStatus() serviceStatus} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceStatus
   * @return A modified copy of {@code this} object
   */
  public final WindowsServiceExtension withServiceStatus(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.serviceStatus, value)) return this;
    return validate(new WindowsServiceExtension(
        this.serviceName,
        this.displayName,
        this.groupName,
        this.serviceStartType,
        this.serviceType,
        value,
        this.type,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WindowsServiceExtensionExt#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final WindowsServiceExtension withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new WindowsServiceExtension(
        this.serviceName,
        this.displayName,
        this.groupName,
        this.serviceStartType,
        this.serviceType,
        this.serviceStatus,
        value,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link WindowsServiceExtensionExt#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final WindowsServiceExtension withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new WindowsServiceExtension(
        this.serviceName,
        this.displayName,
        this.groupName,
        this.serviceStartType,
        this.serviceType,
        this.serviceStatus,
        this.type,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code WindowsServiceExtension} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof WindowsServiceExtension
        && equalTo((WindowsServiceExtension) another);
  }

  private boolean equalTo(WindowsServiceExtension another) {
    return Objects.equals(serviceName, another.serviceName)
        && Objects.equals(displayName, another.displayName)
        && Objects.equals(groupName, another.groupName)
        && Objects.equals(serviceStartType, another.serviceStartType)
        && Objects.equals(serviceType, another.serviceType)
        && Objects.equals(serviceStatus, another.serviceStatus)
        && Objects.equals(type, another.type)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code serviceName}, {@code displayName}, {@code groupName}, {@code serviceStartType}, {@code serviceType}, {@code serviceStatus}, {@code type}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(serviceName);
    h += (h << 5) + Objects.hashCode(displayName);
    h += (h << 5) + Objects.hashCode(groupName);
    h += (h << 5) + Objects.hashCode(serviceStartType);
    h += (h << 5) + Objects.hashCode(serviceType);
    h += (h << 5) + Objects.hashCode(serviceStatus);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WindowsServiceExtension} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WindowsServiceExtension")
        .omitNullValues()
        .add("serviceName", serviceName)
        .add("displayName", displayName)
        .add("groupName", groupName)
        .add("serviceStartType", serviceStartType)
        .add("serviceType", serviceType)
        .add("serviceStatus", serviceStatus)
        .add("type", type)
        .add("customProperties", customProperties)
        .toString();
  }


  private static WindowsServiceExtension validate(WindowsServiceExtension instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link WindowsServiceExtensionExt} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WindowsServiceExtension instance
   */
  public static WindowsServiceExtension copyOf(WindowsServiceExtensionExt instance) {
    if (instance instanceof WindowsServiceExtension) {
      return (WindowsServiceExtension) instance;
    }
    return WindowsServiceExtension.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link WindowsServiceExtension WindowsServiceExtension}.
   * @return A new WindowsServiceExtension builder
   */
  public static WindowsServiceExtension.Builder builder() {
    return new WindowsServiceExtension.Builder();
  }

  /**
   * Builds instances of type {@link WindowsServiceExtension WindowsServiceExtension}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WindowsServiceExtensionExt", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"service_name", "descriptions", "display_name", "group_name", "start_type", "service_dll_refs", "service_type", "service_status"})
  @JsonTypeName("windows-service-ext")
  public static final class Builder {
    private @Nullable String serviceName;
    private @Nullable String displayName;
    private @Nullable String groupName;
    private @Nullable String serviceStartType;
    private @Nullable String serviceType;
    private @Nullable String serviceStatus;
    private @Nullable String type;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.types.WindowsServiceExtensionExt} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WindowsServiceExtensionExt instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableExtensionCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof WindowsServiceExtensionExt) {
        WindowsServiceExtensionExt instance = (WindowsServiceExtensionExt) object;
        Optional<String> serviceTypeOptional = instance.getServiceType();
        if (serviceTypeOptional.isPresent()) {
          serviceType(serviceTypeOptional);
        }
        Optional<String> serviceStartTypeOptional = instance.getServiceStartType();
        if (serviceStartTypeOptional.isPresent()) {
          serviceStartType(serviceStartTypeOptional);
        }
        Optional<String> groupNameOptional = instance.getGroupName();
        if (groupNameOptional.isPresent()) {
          groupName(groupNameOptional);
        }
        String serviceNameValue = instance.getServiceName();
        if (serviceNameValue != null) {
          serviceName(serviceNameValue);
        }
        Optional<String> displayNameOptional = instance.getDisplayName();
        if (displayNameOptional.isPresent()) {
          displayName(displayNameOptional);
        }
        Optional<String> serviceStatusOptional = instance.getServiceStatus();
        if (serviceStatusOptional.isPresent()) {
          serviceStatus(serviceStatusOptional);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof CyberObservableExtensionCommonProperties) {
        CyberObservableExtensionCommonProperties instance = (CyberObservableExtensionCommonProperties) object;
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link WindowsServiceExtensionExt#getServiceName() serviceName} attribute.
     * @param serviceName The value for serviceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("service_name")
    @JsonPropertyDescription("Specifies the name of the service.")
    public final Builder serviceName(String serviceName) {
      this.serviceName = serviceName;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsServiceExtensionExt#getDisplayName() displayName} to displayName.
     * @param displayName The value for displayName
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder displayName(String displayName) {
      this.displayName = Objects.requireNonNull(displayName, "displayName");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsServiceExtensionExt#getDisplayName() displayName} to displayName.
     * @param displayName The value for displayName
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("display_name")
    @JsonPropertyDescription("Specifies the displayed name of the service in Windows GUI controls.")
    public final Builder displayName(Optional<String> displayName) {
      this.displayName = displayName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsServiceExtensionExt#getGroupName() groupName} to groupName.
     * @param groupName The value for groupName
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder groupName(String groupName) {
      this.groupName = Objects.requireNonNull(groupName, "groupName");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsServiceExtensionExt#getGroupName() groupName} to groupName.
     * @param groupName The value for groupName
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("group_name")
    @JsonPropertyDescription("Specifies the name of the load ordering group of which the service is a member.")
    public final Builder groupName(Optional<String> groupName) {
      this.groupName = groupName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsServiceExtensionExt#getServiceStartType() serviceStartType} to serviceStartType.
     * @param serviceStartType The value for serviceStartType
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serviceStartType(String serviceStartType) {
      this.serviceStartType = Objects.requireNonNull(serviceStartType, "serviceStartType");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsServiceExtensionExt#getServiceStartType() serviceStartType} to serviceStartType.
     * @param serviceStartType The value for serviceStartType
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("start_type")
    @JsonPropertyDescription("Specifies the start options defined for the service. windows-service-start-enum")
    public final Builder serviceStartType(Optional<String> serviceStartType) {
      this.serviceStartType = serviceStartType.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsServiceExtensionExt#getServiceType() serviceType} to serviceType.
     * @param serviceType The value for serviceType
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serviceType(String serviceType) {
      this.serviceType = Objects.requireNonNull(serviceType, "serviceType");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsServiceExtensionExt#getServiceType() serviceType} to serviceType.
     * @param serviceType The value for serviceType
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("service_type")
    @JsonPropertyDescription("Specifies the type of the service. windows-service-enum")
    public final Builder serviceType(Optional<String> serviceType) {
      this.serviceType = serviceType.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsServiceExtensionExt#getServiceStatus() serviceStatus} to serviceStatus.
     * @param serviceStatus The value for serviceStatus
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serviceStatus(String serviceStatus) {
      this.serviceStatus = Objects.requireNonNull(serviceStatus, "serviceStatus");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsServiceExtensionExt#getServiceStatus() serviceStatus} to serviceStatus.
     * @param serviceStatus The value for serviceStatus
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("service_status")
    @JsonPropertyDescription("Specifies the current status of the service. windows-service-status-enum")
    public final Builder serviceStatus(Optional<String> serviceStatus) {
      this.serviceStatus = serviceStatus.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link WindowsServiceExtensionExt#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonIgnore
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link WindowsServiceExtensionExt#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsServiceExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link WindowsServiceExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link WindowsServiceExtensionExt#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link WindowsServiceExtension WindowsServiceExtension}.
     * @return An immutable instance of WindowsServiceExtension
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public WindowsServiceExtension build() {
      return WindowsServiceExtension.validate(new WindowsServiceExtension(
          serviceName,
          displayName,
          groupName,
          serviceStartType,
          serviceType,
          serviceStatus,
          type,
          customProperties.build()));
    }
  }
}
