package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObjectCommonProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldDeserializer;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldSerializer;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;

/**
 * The Email Message Object represents an instance of an email message.
 */
@Generated(from = "EmailMessageCoo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("email-message")
public final class EmailMessage implements EmailMessageCoo {
  private final Boolean isMultipart;
  private final @Nullable StixInstant date;
  private final @Nullable String contentType;
  private final @Nullable String fromRef;
  private final @Nullable String senderRef;
  private final String id;
  private final String type;
  private final ImmutableSet<CyberObservableExtension> extensions;
  private final String observableObjectKey;
  private final @Nullable Boolean defanged;
  private final ImmutableMap<String, Object> customProperties;
  private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
  private final ImmutableSet<GranularMarkingDm> granularMarkings;
  private final boolean hydrated;
  private final String toJsonString;

  private EmailMessage(EmailMessage.Builder builder) {
    this.isMultipart = builder.isMultipart;
    this.date = builder.date;
    this.contentType = builder.contentType;
    this.fromRef = builder.fromRef;
    this.senderRef = builder.senderRef;
    this.type = builder.type;
    this.defanged = builder.defanged;
    this.customProperties = builder.customProperties.build();
    this.objectMarkingRefs = builder.objectMarkingRefs.build();
    this.granularMarkings = builder.granularMarkings.build();
    this.hydrated = builder.hydrated;
    this.toJsonString = builder.toJsonString;
    if (builder.extensionsIsSet()) {
      initShim.extensions(builder.extensions.build());
    }
    if (builder.observableObjectKey != null) {
      initShim.observableObjectKey(builder.observableObjectKey);
    }
    this.id = initShim.getId();
    this.extensions = initShim.getExtensions();
    this.observableObjectKey = initShim.getObservableObjectKey();
    this.initShim = null;
  }

  private EmailMessage(
      Boolean isMultipart,
      @Nullable StixInstant date,
      @Nullable String contentType,
      @Nullable String fromRef,
      @Nullable String senderRef,
      String type,
      ImmutableSet<CyberObservableExtension> extensions,
      String observableObjectKey,
      @Nullable Boolean defanged,
      ImmutableMap<String, Object> customProperties,
      ImmutableSet<MarkingDefinitionDm> objectMarkingRefs,
      ImmutableSet<GranularMarkingDm> granularMarkings,
      boolean hydrated,
      String toJsonString) {
    this.isMultipart = isMultipart;
    this.date = date;
    this.contentType = contentType;
    this.fromRef = fromRef;
    this.senderRef = senderRef;
    this.type = type;
    initShim.extensions(extensions);
    initShim.observableObjectKey(observableObjectKey);
    this.defanged = defanged;
    this.customProperties = customProperties;
    this.objectMarkingRefs = objectMarkingRefs;
    this.granularMarkings = granularMarkings;
    this.hydrated = hydrated;
    this.toJsonString = toJsonString;
    this.id = initShim.getId();
    this.extensions = initShim.getExtensions();
    this.observableObjectKey = initShim.getObservableObjectKey();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "EmailMessageCoo", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    private byte extensionsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<CyberObservableExtension> extensions;

    ImmutableSet<CyberObservableExtension> getExtensions() {
      if (extensionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (extensionsBuildStage == STAGE_UNINITIALIZED) {
        extensionsBuildStage = STAGE_INITIALIZING;
        this.extensions = ImmutableSet.copyOf(getExtensionsInitialize());
        extensionsBuildStage = STAGE_INITIALIZED;
      }
      return this.extensions;
    }

    void extensions(ImmutableSet<CyberObservableExtension> extensions) {
      this.extensions = extensions;
      extensionsBuildStage = STAGE_INITIALIZED;
    }

    private byte observableObjectKeyBuildStage = STAGE_UNINITIALIZED;
    private String observableObjectKey;

    String getObservableObjectKey() {
      if (observableObjectKeyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (observableObjectKeyBuildStage == STAGE_UNINITIALIZED) {
        observableObjectKeyBuildStage = STAGE_INITIALIZING;
        this.observableObjectKey = Objects.requireNonNull(getObservableObjectKeyInitialize(), "observableObjectKey");
        observableObjectKeyBuildStage = STAGE_INITIALIZED;
      }
      return this.observableObjectKey;
    }

    void observableObjectKey(String observableObjectKey) {
      this.observableObjectKey = observableObjectKey;
      observableObjectKeyBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (extensionsBuildStage == STAGE_INITIALIZING) attributes.add("extensions");
      if (observableObjectKeyBuildStage == STAGE_INITIALIZING) attributes.add("observableObjectKey");
      return "Cannot build EmailMessage, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return EmailMessageCoo.super.getId();
  }

  private Set<CyberObservableExtension> getExtensionsInitialize() {
    return EmailMessageCoo.super.getExtensions();
  }

  private String getObservableObjectKeyInitialize() {
    return EmailMessageCoo.super.getObservableObjectKey();
  }

  /**
   * @return The value of the {@code isMultipart} attribute
   */
  @JsonProperty("is_multipart")
  @JsonPropertyDescription("Indicates whether the email body contains multiple MIME parts.")
  @Override
  public Boolean isMultipart() {
    return isMultipart;
  }

  /**
   * @return The value of the {@code date} attribute
   */
  @JsonProperty("date")
  @JsonPropertyDescription("Specifies the date/time that the email message was sent.")
  @Override
  public Optional<StixInstant> getDate() {
    return Optional.ofNullable(date);
  }

  /**
   * @return The value of the {@code contentType} attribute
   */
  @JsonProperty("content_type")
  @JsonPropertyDescription("Specifies the value of the \'Content-Type\' header of the email message.")
  @Override
  public Optional<String> getContentType() {
    return Optional.ofNullable(contentType);
  }

  /**
   * @return The value of the {@code fromRef} attribute
   */
  @JsonProperty("from_ref")
  @JsonPropertyDescription("Specifies the value of the \'From:\' header of the email message.")
  @Override
  public Optional<String> getFromRef() {
    return Optional.ofNullable(fromRef);
  }

  /**
   * @return The value of the {@code senderRef} attribute
   */
  @JsonProperty("sender_ref")
  @JsonPropertyDescription("Specifies the value of the \'From\' field of the email message")
  @Override
  public Optional<String> getSenderRef() {
    return Optional.ofNullable(senderRef);
  }

  /**
   * Deterministically generates the ID for this email message based on its subject, from, date, and content.
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Multiple extensions can be added, but only 1 instance of a specific extension can be added.
   */
  @JsonProperty("extensions")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Specifies any extensions of the object, as a dictionary.")
  @JsonSerialize(using = CyberObservableExtensionsFieldSerializer.class)
  @JsonDeserialize(using = CyberObservableExtensionsFieldDeserializer.class)
  @Override
  public ImmutableSet<CyberObservableExtension> getExtensions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExtensions()
        : this.extensions;
  }

  /**
   * Used for generation of Map Keys by {@link ObservedDataSdo#getObjects()}
   * Manually set this value if you want to control key names.  Otherwise UUIDs will be used.
   */
  @JsonProperty(value = "observable_object_key", access = JsonProperty.Access.WRITE_ONLY)
  @Override
  public String getObservableObjectKey() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObservableObjectKey()
        : this.observableObjectKey;
  }

  /**
   * Indicates whether the data contained in the SCO has been defanged.
   * Defanging refers to the process of modifying data to make it safe to handle
   * (e.g., changing an IP address from 192.168.1.1 to 192[.]168[.]1[.]1).
   */
  @JsonProperty("defanged")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Indicates whether the data contained in the SCO has been defanged.")
  @Override
  public Optional<Boolean> getDefanged() {
    return Optional.ofNullable(defanged);
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * @return The value of the {@code objectMarkingRefs} attribute
   */
  @JsonProperty("objectMarkingRefs")
  @Override
  public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
    return objectMarkingRefs;
  }

  /**
   * @return The value of the {@code granularMarkings} attribute
   */
  @JsonProperty("granularMarkings")
  @Override
  public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
    return granularMarkings;
  }

  /**
   * @return The value of the {@code hydrated} attribute
   */
  @JsonProperty("hydrated")
  @Override
  public boolean getHydrated() {
    return hydrated;
  }

  /**
   * @return The value of the {@code toJsonString} attribute
   */
  @JsonProperty("toJsonString")
  @Override
  public String toJsonString() {
    return toJsonString;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmailMessageCoo#isMultipart() isMultipart} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isMultipart (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final EmailMessage withIsMultipart(Boolean value) {
    if (Objects.equals(this.isMultipart, value)) return this;
    return validate(new EmailMessage(
        value,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link EmailMessageCoo#getDate() date} attribute.
   * @param value The value for date
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withDate(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "date");
    if (this.date == newValue) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        newValue,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link EmailMessageCoo#getDate() date} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for date
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final EmailMessage withDate(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.date == value) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        value,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link EmailMessageCoo#getContentType() contentType} attribute.
   * @param value The value for contentType
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withContentType(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "contentType");
    if (Objects.equals(this.contentType, newValue)) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        newValue,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link EmailMessageCoo#getContentType() contentType} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for contentType
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withContentType(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.contentType, value)) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        value,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link EmailMessageCoo#getFromRef() fromRef} attribute.
   * @param value The value for fromRef
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withFromRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "fromRef");
    if (Objects.equals(this.fromRef, newValue)) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        newValue,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link EmailMessageCoo#getFromRef() fromRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for fromRef
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withFromRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.fromRef, value)) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        value,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link EmailMessageCoo#getSenderRef() senderRef} attribute.
   * @param value The value for senderRef
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withSenderRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "senderRef");
    if (Objects.equals(this.senderRef, newValue)) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        newValue,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link EmailMessageCoo#getSenderRef() senderRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for senderRef
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withSenderRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.senderRef, value)) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        value,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmailMessageCoo#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final EmailMessage withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        value,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EmailMessageCoo#getExtensions() extensions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withExtensions(CyberObservableExtension... elements) {
    ImmutableSet<CyberObservableExtension> newValue = ImmutableSet.copyOf(elements);
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        newValue,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EmailMessageCoo#getExtensions() extensions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of extensions elements to set
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withExtensions(Iterable<? extends CyberObservableExtension> elements) {
    if (this.extensions == elements) return this;
    ImmutableSet<CyberObservableExtension> newValue = ImmutableSet.copyOf(elements);
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        newValue,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmailMessageCoo#getObservableObjectKey() observableObjectKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for observableObjectKey
   * @return A modified copy of the {@code this} object
   */
  public final EmailMessage withObservableObjectKey(String value) {
    String newValue = Objects.requireNonNull(value, "observableObjectKey");
    if (this.observableObjectKey.equals(newValue)) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        newValue,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link EmailMessageCoo#getDefanged() defanged} attribute.
   * @param value The value for defanged
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withDefanged(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.defanged, newValue)) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        newValue,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link EmailMessageCoo#getDefanged() defanged} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for defanged
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withDefanged(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.defanged, value)) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        value,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by replacing the {@link EmailMessageCoo#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EmailMessageCoo#getObjectMarkingRefs() objectMarkingRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withObjectMarkingRefs(MarkingDefinitionDm... elements) {
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        newValue,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EmailMessageCoo#getObjectMarkingRefs() objectMarkingRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectMarkingRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
    if (this.objectMarkingRefs == elements) return this;
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        newValue,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EmailMessageCoo#getGranularMarkings() granularMarkings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withGranularMarkings(GranularMarkingDm... elements) {
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        newValue,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EmailMessageCoo#getGranularMarkings() granularMarkings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of granularMarkings elements to set
   * @return A modified copy of {@code this} object
   */
  public final EmailMessage withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
    if (this.granularMarkings == elements) return this;
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        newValue,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmailMessageCoo#getHydrated() hydrated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hydrated
   * @return A modified copy of the {@code this} object
   */
  public final EmailMessage withHydrated(boolean value) {
    if (this.hydrated == value) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        value,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EmailMessageCoo#toJsonString() toJsonString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toJsonString (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final EmailMessage withToJsonString(String value) {
    if (Objects.equals(this.toJsonString, value)) return this;
    return validate(new EmailMessage(
        this.isMultipart,
        this.date,
        this.contentType,
        this.fromRef,
        this.senderRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        value));
  }

  /**
   * This instance is equal to all instances of {@code EmailMessage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof EmailMessage
        && equalTo((EmailMessage) another);
  }

  private boolean equalTo(EmailMessage another) {
    return Objects.equals(isMultipart, another.isMultipart)
        && Objects.equals(date, another.date)
        && Objects.equals(contentType, another.contentType)
        && Objects.equals(fromRef, another.fromRef)
        && Objects.equals(senderRef, another.senderRef)
        && id.equals(another.id)
        && Objects.equals(type, another.type)
        && extensions.equals(another.extensions)
        && observableObjectKey.equals(another.observableObjectKey)
        && Objects.equals(defanged, another.defanged)
        && customProperties.equals(another.customProperties)
        && objectMarkingRefs.equals(another.objectMarkingRefs)
        && granularMarkings.equals(another.granularMarkings)
        && hydrated == another.hydrated
        && Objects.equals(toJsonString, another.toJsonString);
  }

  /**
   * Computes a hash code from attributes: {@code isMultipart}, {@code date}, {@code contentType}, {@code fromRef}, {@code senderRef}, {@code id}, {@code type}, {@code extensions}, {@code observableObjectKey}, {@code defanged}, {@code customProperties}, {@code objectMarkingRefs}, {@code granularMarkings}, {@code hydrated}, {@code toJsonString}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(isMultipart);
    h += (h << 5) + Objects.hashCode(date);
    h += (h << 5) + Objects.hashCode(contentType);
    h += (h << 5) + Objects.hashCode(fromRef);
    h += (h << 5) + Objects.hashCode(senderRef);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + extensions.hashCode();
    h += (h << 5) + observableObjectKey.hashCode();
    h += (h << 5) + Objects.hashCode(defanged);
    h += (h << 5) + customProperties.hashCode();
    h += (h << 5) + objectMarkingRefs.hashCode();
    h += (h << 5) + granularMarkings.hashCode();
    h += (h << 5) + Booleans.hashCode(hydrated);
    h += (h << 5) + Objects.hashCode(toJsonString);
    return h;
  }

  /**
   * Prints the immutable value {@code EmailMessage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("EmailMessage")
        .omitNullValues()
        .add("isMultipart", isMultipart)
        .add("date", date)
        .add("contentType", contentType)
        .add("fromRef", fromRef)
        .add("senderRef", senderRef)
        .add("id", id)
        .add("type", type)
        .add("extensions", extensions)
        .add("observableObjectKey", observableObjectKey)
        .add("defanged", defanged)
        .add("customProperties", customProperties)
        .add("objectMarkingRefs", objectMarkingRefs)
        .add("granularMarkings", granularMarkings)
        .add("hydrated", hydrated)
        .add("toJsonString", toJsonString)
        .toString();
  }


  private static EmailMessage validate(EmailMessage instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link EmailMessageCoo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EmailMessage instance
   */
  public static EmailMessage copyOf(EmailMessageCoo instance) {
    if (instance instanceof EmailMessage) {
      return (EmailMessage) instance;
    }
    return EmailMessage.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link EmailMessage EmailMessage}.
   * @return A new EmailMessage builder
   */
  public static EmailMessage.Builder builder() {
    return new EmailMessage.Builder();
  }

  /**
   * Builds instances of type {@link EmailMessage EmailMessage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EmailMessageCoo", generator = "Immutables")
  @NotThreadSafe
  @JsonTypeName("email-message")
  @JsonPropertyOrder({"type", "extensions", "is_multipart", "date", "content_type", "from_ref", "sender_ref", "to_refs", "cc_refs", "bcc_refs", "subject", "received_lines", "additional_header_fields", "body", "body_multipart", "raw_email_ref"})
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  public static final class Builder {
    private static final long OPT_BIT_EXTENSIONS = 0x1L;
    private long optBits;

    private @Nullable Boolean isMultipart;
    private @Nullable StixInstant date;
    private @Nullable String contentType;
    private @Nullable String fromRef;
    private @Nullable String senderRef;
    private @Nullable String type;
    private ImmutableSet.Builder<CyberObservableExtension> extensions = ImmutableSet.builder();
    private @Nullable String observableObjectKey;
    private @Nullable Boolean defanged;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
    private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
    private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
    private boolean hydrated;
    private @Nullable String toJsonString;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.objects.EmailMessageCoo} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(EmailMessageCoo instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleableObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleableObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.CyberObservableObjectCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableObjectCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof EmailMessageCoo) {
        EmailMessageCoo instance = (EmailMessageCoo) object;
        Optional<StixInstant> dateOptional = instance.getDate();
        if (dateOptional.isPresent()) {
          date(dateOptional);
        }
        Optional<String> fromRefOptional = instance.getFromRef();
        if (fromRefOptional.isPresent()) {
          fromRef(fromRefOptional);
        }
        Boolean isMultipartValue = instance.isMultipart();
        if (isMultipartValue != null) {
          isMultipart(isMultipartValue);
        }
        Optional<String> senderRefOptional = instance.getSenderRef();
        if (senderRefOptional.isPresent()) {
          senderRef(senderRefOptional);
        }
        Optional<String> contentTypeOptional = instance.getContentType();
        if (contentTypeOptional.isPresent()) {
          contentType(contentTypeOptional);
        }
      }
      if (object instanceof BundleableObject) {
        BundleableObject instance = (BundleableObject) object;
        addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        hydrated(instance.getHydrated());
        addAllGranularMarkings(instance.getGranularMarkings());
        String toJsonStringValue = instance.toJsonString();
        if (toJsonStringValue != null) {
          toJsonString(toJsonStringValue);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof CyberObservableObjectCommonProperties) {
        CyberObservableObjectCommonProperties instance = (CyberObservableObjectCommonProperties) object;
        addAllExtensions(instance.getExtensions());
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        observableObjectKey(instance.getObservableObjectKey());
        Optional<Boolean> defangedOptional = instance.getDefanged();
        if (defangedOptional.isPresent()) {
          defanged(defangedOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link EmailMessageCoo#isMultipart() isMultipart} attribute.
     * @param isMultipart The value for isMultipart (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("is_multipart")
    @JsonPropertyDescription("Indicates whether the email body contains multiple MIME parts.")
    public final Builder isMultipart(Boolean isMultipart) {
      this.isMultipart = isMultipart;
      return this;
    }

    /**
     * Initializes the optional value {@link EmailMessageCoo#getDate() date} to date.
     * @param date The value for date
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder date(StixInstant date) {
      this.date = Objects.requireNonNull(date, "date");
      return this;
    }

    /**
     * Initializes the optional value {@link EmailMessageCoo#getDate() date} to date.
     * @param date The value for date
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("date")
    @JsonPropertyDescription("Specifies the date/time that the email message was sent.")
    public final Builder date(Optional<? extends StixInstant> date) {
      this.date = date.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link EmailMessageCoo#getContentType() contentType} to contentType.
     * @param contentType The value for contentType
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder contentType(String contentType) {
      this.contentType = Objects.requireNonNull(contentType, "contentType");
      return this;
    }

    /**
     * Initializes the optional value {@link EmailMessageCoo#getContentType() contentType} to contentType.
     * @param contentType The value for contentType
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content_type")
    @JsonPropertyDescription("Specifies the value of the \'Content-Type\' header of the email message.")
    public final Builder contentType(Optional<String> contentType) {
      this.contentType = contentType.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link EmailMessageCoo#getFromRef() fromRef} to fromRef.
     * @param fromRef The value for fromRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fromRef(String fromRef) {
      this.fromRef = Objects.requireNonNull(fromRef, "fromRef");
      return this;
    }

    /**
     * Initializes the optional value {@link EmailMessageCoo#getFromRef() fromRef} to fromRef.
     * @param fromRef The value for fromRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("from_ref")
    @JsonPropertyDescription("Specifies the value of the \'From:\' header of the email message.")
    public final Builder fromRef(Optional<String> fromRef) {
      this.fromRef = fromRef.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link EmailMessageCoo#getSenderRef() senderRef} to senderRef.
     * @param senderRef The value for senderRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder senderRef(String senderRef) {
      this.senderRef = Objects.requireNonNull(senderRef, "senderRef");
      return this;
    }

    /**
     * Initializes the optional value {@link EmailMessageCoo#getSenderRef() senderRef} to senderRef.
     * @param senderRef The value for senderRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("sender_ref")
    @JsonPropertyDescription("Specifies the value of the \'From\' field of the email message")
    public final Builder senderRef(Optional<String> senderRef) {
      this.senderRef = senderRef.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link EmailMessageCoo#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Adds one element to {@link EmailMessageCoo#getExtensions() extensions} set.
     * @param element A extensions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtension(@Nullable CyberObservableExtension element) {
      this.extensions.add(element);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }

    /**
     * Adds elements to {@link EmailMessageCoo#getExtensions() extensions} set.
     * @param elements An array of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtensions(CyberObservableExtension... elements) {
      this.extensions.add(elements);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link EmailMessageCoo#getExtensions() extensions} set.
     * @param elements An iterable of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("extensions")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Specifies any extensions of the object, as a dictionary.")
    @JsonSerialize(using = CyberObservableExtensionsFieldSerializer.class)
    @JsonDeserialize(using = CyberObservableExtensionsFieldDeserializer.class)
    public final Builder extensions(Iterable<? extends CyberObservableExtension> elements) {
      this.extensions = ImmutableSet.builder();
      return addAllExtensions(elements);
    }

    /**
     * Adds elements to {@link EmailMessageCoo#getExtensions() extensions} set.
     * @param elements An iterable of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExtensions(Iterable<? extends CyberObservableExtension> elements) {
      this.extensions.addAll(elements);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }

    /**
     * Initializes the value for the {@link EmailMessageCoo#getObservableObjectKey() observableObjectKey} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link EmailMessageCoo#getObservableObjectKey() observableObjectKey}.</em>
     * @param observableObjectKey The value for observableObjectKey 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "observable_object_key", access = JsonProperty.Access.WRITE_ONLY)
    public final Builder observableObjectKey(String observableObjectKey) {
      this.observableObjectKey = Objects.requireNonNull(observableObjectKey, "observableObjectKey");
      return this;
    }

    /**
     * Initializes the optional value {@link EmailMessageCoo#getDefanged() defanged} to defanged.
     * @param defanged The value for defanged
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defanged(boolean defanged) {
      this.defanged = defanged;
      return this;
    }

    /**
     * Initializes the optional value {@link EmailMessageCoo#getDefanged() defanged} to defanged.
     * @param defanged The value for defanged
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("defanged")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Indicates whether the data contained in the SCO has been defanged.")
    public final Builder defanged(Optional<Boolean> defanged) {
      this.defanged = defanged.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link EmailMessageCoo#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link EmailMessageCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link EmailMessageCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link EmailMessageCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link EmailMessageCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param element A objectMarkingRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
      this.objectMarkingRefs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link EmailMessageCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An array of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRefs(MarkingDefinitionDm... elements) {
      this.objectMarkingRefs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link EmailMessageCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("objectMarkingRefs")
    public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs = ImmutableSet.builder();
      return addAllObjectMarkingRefs(elements);
    }

    /**
     * Adds elements to {@link EmailMessageCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link EmailMessageCoo#getGranularMarkings() granularMarkings} set.
     * @param element A granularMarkings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
      this.granularMarkings.add(element);
      return this;
    }

    /**
     * Adds elements to {@link EmailMessageCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An array of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarkings(GranularMarkingDm... elements) {
      this.granularMarkings.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link EmailMessageCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("granularMarkings")
    public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings = ImmutableSet.builder();
      return addAllGranularMarkings(elements);
    }

    /**
     * Adds elements to {@link EmailMessageCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link EmailMessageCoo#getHydrated() hydrated} attribute.
     * @param hydrated The value for hydrated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hydrated")
    public final Builder hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      return this;
    }

    /**
     * Initializes the value for the {@link EmailMessageCoo#toJsonString() toJsonString} attribute.
     * @param toJsonString The value for toJsonString (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("toJsonString")
    public final Builder toJsonString(String toJsonString) {
      this.toJsonString = toJsonString;
      return this;
    }

    /**
     * Builds a new {@link EmailMessage EmailMessage}.
     * @return An immutable instance of EmailMessage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public EmailMessage build() {
      return EmailMessage.validate(new EmailMessage(this));
    }

    private boolean extensionsIsSet() {
      return (optBits & OPT_BIT_EXTENSIONS) != 0;
    }
  }
}
