package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObjectCommonProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldDeserializer;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldSerializer;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;

/**
 * file
 * <p>
 * The File Object represents the properties of a file.
 */
@Generated(from = "FileCoo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("file")
public final class File implements FileCoo {
  private final ImmutableMap<String, String> hashes;
  private final @Nullable Long size;
  private final @Nullable String name;
  private final @Nullable String nameEnc;
  private final @Nullable String magicNumberHex;
  private final @Nullable String mimeType;
  private final @Nullable StixInstant created;
  private final @Nullable StixInstant modified;
  private final @Nullable StixInstant accessed;
  private final @Nullable String parentDirectoryRef;
  private final @Nullable Boolean isEncrypted;
  private final @Nullable String encryptionAlgorithm;
  private final @Nullable String decryptionKey;
  private final @Nullable String contentRef;
  private final String id;
  private final String type;
  private final ImmutableSet<CyberObservableExtension> extensions;
  private final String observableObjectKey;
  private final @Nullable Boolean defanged;
  private final ImmutableMap<String, Object> customProperties;
  private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
  private final ImmutableSet<GranularMarkingDm> granularMarkings;
  private final boolean hydrated;
  private final String toJsonString;

  private File(File.Builder builder) {
    this.hashes = builder.hashes.build();
    this.size = builder.size;
    this.name = builder.name;
    this.nameEnc = builder.nameEnc;
    this.magicNumberHex = builder.magicNumberHex;
    this.mimeType = builder.mimeType;
    this.created = builder.created;
    this.modified = builder.modified;
    this.accessed = builder.accessed;
    this.parentDirectoryRef = builder.parentDirectoryRef;
    this.isEncrypted = builder.isEncrypted;
    this.encryptionAlgorithm = builder.encryptionAlgorithm;
    this.decryptionKey = builder.decryptionKey;
    this.contentRef = builder.contentRef;
    this.type = builder.type;
    this.defanged = builder.defanged;
    this.customProperties = builder.customProperties.build();
    this.objectMarkingRefs = builder.objectMarkingRefs.build();
    this.granularMarkings = builder.granularMarkings.build();
    this.hydrated = builder.hydrated;
    this.toJsonString = builder.toJsonString;
    if (builder.extensionsIsSet()) {
      initShim.extensions(builder.extensions.build());
    }
    if (builder.observableObjectKey != null) {
      initShim.observableObjectKey(builder.observableObjectKey);
    }
    this.id = initShim.getId();
    this.extensions = initShim.getExtensions();
    this.observableObjectKey = initShim.getObservableObjectKey();
    this.initShim = null;
  }

  private File(
      ImmutableMap<String, String> hashes,
      @Nullable Long size,
      @Nullable String name,
      @Nullable String nameEnc,
      @Nullable String magicNumberHex,
      @Nullable String mimeType,
      @Nullable StixInstant created,
      @Nullable StixInstant modified,
      @Nullable StixInstant accessed,
      @Nullable String parentDirectoryRef,
      @Nullable Boolean isEncrypted,
      @Nullable String encryptionAlgorithm,
      @Nullable String decryptionKey,
      @Nullable String contentRef,
      String type,
      ImmutableSet<CyberObservableExtension> extensions,
      String observableObjectKey,
      @Nullable Boolean defanged,
      ImmutableMap<String, Object> customProperties,
      ImmutableSet<MarkingDefinitionDm> objectMarkingRefs,
      ImmutableSet<GranularMarkingDm> granularMarkings,
      boolean hydrated,
      String toJsonString) {
    this.hashes = hashes;
    this.size = size;
    this.name = name;
    this.nameEnc = nameEnc;
    this.magicNumberHex = magicNumberHex;
    this.mimeType = mimeType;
    this.created = created;
    this.modified = modified;
    this.accessed = accessed;
    this.parentDirectoryRef = parentDirectoryRef;
    this.isEncrypted = isEncrypted;
    this.encryptionAlgorithm = encryptionAlgorithm;
    this.decryptionKey = decryptionKey;
    this.contentRef = contentRef;
    this.type = type;
    initShim.extensions(extensions);
    initShim.observableObjectKey(observableObjectKey);
    this.defanged = defanged;
    this.customProperties = customProperties;
    this.objectMarkingRefs = objectMarkingRefs;
    this.granularMarkings = granularMarkings;
    this.hydrated = hydrated;
    this.toJsonString = toJsonString;
    this.id = initShim.getId();
    this.extensions = initShim.getExtensions();
    this.observableObjectKey = initShim.getObservableObjectKey();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "FileCoo", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    private byte extensionsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<CyberObservableExtension> extensions;

    ImmutableSet<CyberObservableExtension> getExtensions() {
      if (extensionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (extensionsBuildStage == STAGE_UNINITIALIZED) {
        extensionsBuildStage = STAGE_INITIALIZING;
        this.extensions = ImmutableSet.copyOf(getExtensionsInitialize());
        extensionsBuildStage = STAGE_INITIALIZED;
      }
      return this.extensions;
    }

    void extensions(ImmutableSet<CyberObservableExtension> extensions) {
      this.extensions = extensions;
      extensionsBuildStage = STAGE_INITIALIZED;
    }

    private byte observableObjectKeyBuildStage = STAGE_UNINITIALIZED;
    private String observableObjectKey;

    String getObservableObjectKey() {
      if (observableObjectKeyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (observableObjectKeyBuildStage == STAGE_UNINITIALIZED) {
        observableObjectKeyBuildStage = STAGE_INITIALIZING;
        this.observableObjectKey = Objects.requireNonNull(getObservableObjectKeyInitialize(), "observableObjectKey");
        observableObjectKeyBuildStage = STAGE_INITIALIZED;
      }
      return this.observableObjectKey;
    }

    void observableObjectKey(String observableObjectKey) {
      this.observableObjectKey = observableObjectKey;
      observableObjectKeyBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (extensionsBuildStage == STAGE_INITIALIZING) attributes.add("extensions");
      if (observableObjectKeyBuildStage == STAGE_INITIALIZING) attributes.add("observableObjectKey");
      return "Cannot build File, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return FileCoo.super.getId();
  }

  private Set<CyberObservableExtension> getExtensionsInitialize() {
    return FileCoo.super.getExtensions();
  }

  private String getObservableObjectKeyInitialize() {
    return FileCoo.super.getObservableObjectKey();
  }

  /**
   * @return The value of the {@code hashes} attribute
   */
  @JsonProperty("hashes")
  @JsonPropertyDescription("Specifies a dictionary of hashes for the contents of the file.")
  @Override
  public ImmutableMap<String, String> getHashes() {
    return hashes;
  }

  /**
   * @return The value of the {@code size} attribute
   */
  @JsonProperty("size")
  @JsonPropertyDescription("Specifies the size of the file, in bytes, as a non-negative integer.")
  @Override
  public Optional<Long> getSize() {
    return Optional.ofNullable(size);
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JsonPropertyDescription("Specifies the name of the file.")
  @Override
  public Optional<String> getName() {
    return Optional.ofNullable(name);
  }

  /**
   * @return The value of the {@code nameEnc} attribute
   */
  @JsonProperty("name_enc")
  @JsonPropertyDescription("Specifies the observed encoding for the name of the file.")
  @Override
  public Optional<String> getNameEnc() {
    return Optional.ofNullable(nameEnc);
  }

  /**
   * @return The value of the {@code magicNumberHex} attribute
   */
  @JsonProperty("magic_number_hex")
  @JsonPropertyDescription("Specifies the hexadecimal constant (\'magic number\') associated with a specific file format that corresponds to the file, if applicable.")
  @Override
  public Optional<String> getMagicNumberHex() {
    return Optional.ofNullable(magicNumberHex);
  }

  /**
   * @return The value of the {@code mimeType} attribute
   */
  @JsonProperty("mime_type")
  @JsonPropertyDescription("Specifies the MIME type name specified for the file, e.g., \'application/msword\'.")
  @Override
  public Optional<String> getMimeType() {
    return Optional.ofNullable(mimeType);
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @JsonPropertyDescription("Specifies the date/time the file was created.")
  @Override
  public Optional<StixInstant> getCreated() {
    return Optional.ofNullable(created);
  }

  /**
   * @return The value of the {@code modified} attribute
   */
  @JsonProperty("modified")
  @JsonPropertyDescription("Specifies the date/time the file was last written to/modified.")
  @Override
  public Optional<StixInstant> getModified() {
    return Optional.ofNullable(modified);
  }

  /**
   * @return The value of the {@code accessed} attribute
   */
  @JsonProperty("accessed")
  @JsonPropertyDescription("Specifies the date/time the file was last accessed.")
  @Override
  public Optional<StixInstant> getAccessed() {
    return Optional.ofNullable(accessed);
  }

  /**
   * @return The value of the {@code parentDirectoryRef} attribute
   */
  @JsonProperty("parent_directory_ref")
  @JsonPropertyDescription("Specifies the parent directory of the file, as a reference to a Directory Object.")
  @Override
  public Optional<String> getParentDirectoryRef() {
    return Optional.ofNullable(parentDirectoryRef);
  }

  /**
   * @return The value of the {@code isEncrypted} attribute
   */
  @JsonProperty("is_encrypted")
  @JsonPropertyDescription("Specifies whether the file is encrypted.")
  @Override
  public Optional<Boolean> isEncrypted() {
    return Optional.ofNullable(isEncrypted);
  }

  /**
   * @return The value of the {@code encryptionAlgorithm} attribute
   */
  @JsonProperty("encryption_algorithm")
  @JsonPropertyDescription("Specifies the name of the encryption algorithm used to encrypt the file. Open Vocabulary - encryption-algorithm-ov")
  @Override
  public Optional<String> getEncryptionAlgorithm() {
    return Optional.ofNullable(encryptionAlgorithm);
  }

  /**
   * @return The value of the {@code decryptionKey} attribute
   */
  @JsonProperty("decryption_key")
  @JsonPropertyDescription("Specifies the decryption key used to decrypt the archive file.")
  @Override
  public Optional<String> getDecryptionKey() {
    return Optional.ofNullable(decryptionKey);
  }

  /**
   * @return The value of the {@code contentRef} attribute
   */
  @JsonProperty("content_ref")
  @JsonPropertyDescription("Specifies the content of the file, represented as an Artifact Object.")
  @Override
  public Optional<String> getContentRef() {
    return Optional.ofNullable(contentRef);
  }

  /**
   * Deterministically generates the ID for this file based on its hashes and name.
   * Uses the first available hash from the hashes map, or the file name if no hashes are present.
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Multiple extensions can be added, but only 1 instance of a specific extension can be added.
   */
  @JsonProperty("extensions")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Specifies any extensions of the object, as a dictionary.")
  @JsonSerialize(using = CyberObservableExtensionsFieldSerializer.class)
  @JsonDeserialize(using = CyberObservableExtensionsFieldDeserializer.class)
  @Override
  public ImmutableSet<CyberObservableExtension> getExtensions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExtensions()
        : this.extensions;
  }

  /**
   * Used for generation of Map Keys by {@link ObservedDataSdo#getObjects()}
   * Manually set this value if you want to control key names.  Otherwise UUIDs will be used.
   */
  @JsonProperty(value = "observable_object_key", access = JsonProperty.Access.WRITE_ONLY)
  @Override
  public String getObservableObjectKey() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObservableObjectKey()
        : this.observableObjectKey;
  }

  /**
   * Indicates whether the data contained in the SCO has been defanged.
   * Defanging refers to the process of modifying data to make it safe to handle
   * (e.g., changing an IP address from 192.168.1.1 to 192[.]168[.]1[.]1).
   */
  @JsonProperty("defanged")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Indicates whether the data contained in the SCO has been defanged.")
  @Override
  public Optional<Boolean> getDefanged() {
    return Optional.ofNullable(defanged);
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * @return The value of the {@code objectMarkingRefs} attribute
   */
  @JsonProperty("objectMarkingRefs")
  @Override
  public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
    return objectMarkingRefs;
  }

  /**
   * @return The value of the {@code granularMarkings} attribute
   */
  @JsonProperty("granularMarkings")
  @Override
  public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
    return granularMarkings;
  }

  /**
   * @return The value of the {@code hydrated} attribute
   */
  @JsonProperty("hydrated")
  @Override
  public boolean getHydrated() {
    return hydrated;
  }

  /**
   * @return The value of the {@code toJsonString} attribute
   */
  @JsonProperty("toJsonString")
  @Override
  public String toJsonString() {
    return toJsonString;
  }

  /**
   * Copy the current immutable object by replacing the {@link FileCoo#getHashes() hashes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the hashes map
   * @return A modified copy of {@code this} object
   */
  public final File withHashes(Map<String, ? extends String> entries) {
    if (this.hashes == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return validate(new File(
        newValue,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getSize() size} attribute.
   * @param value The value for size
   * @return A modified copy of {@code this} object
   */
  public final File withSize(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.size, newValue)) return this;
    return validate(new File(
        this.hashes,
        newValue,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getSize() size} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for size
   * @return A modified copy of {@code this} object
   */
  public final File withSize(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.size, value)) return this;
    return validate(new File(
        this.hashes,
        value,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getName() name} attribute.
   * @param value The value for name
   * @return A modified copy of {@code this} object
   */
  public final File withName(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "name");
    if (Objects.equals(this.name, newValue)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        newValue,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getName() name} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final File withName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.name, value)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        value,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getNameEnc() nameEnc} attribute.
   * @param value The value for nameEnc
   * @return A modified copy of {@code this} object
   */
  public final File withNameEnc(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "nameEnc");
    if (Objects.equals(this.nameEnc, newValue)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        newValue,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getNameEnc() nameEnc} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for nameEnc
   * @return A modified copy of {@code this} object
   */
  public final File withNameEnc(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.nameEnc, value)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        value,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getMagicNumberHex() magicNumberHex} attribute.
   * @param value The value for magicNumberHex
   * @return A modified copy of {@code this} object
   */
  public final File withMagicNumberHex(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "magicNumberHex");
    if (Objects.equals(this.magicNumberHex, newValue)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        newValue,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getMagicNumberHex() magicNumberHex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for magicNumberHex
   * @return A modified copy of {@code this} object
   */
  public final File withMagicNumberHex(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.magicNumberHex, value)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        value,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getMimeType() mimeType} attribute.
   * @param value The value for mimeType
   * @return A modified copy of {@code this} object
   */
  public final File withMimeType(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "mimeType");
    if (Objects.equals(this.mimeType, newValue)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        newValue,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getMimeType() mimeType} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for mimeType
   * @return A modified copy of {@code this} object
   */
  public final File withMimeType(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.mimeType, value)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        value,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getCreated() created} attribute.
   * @param value The value for created
   * @return A modified copy of {@code this} object
   */
  public final File withCreated(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "created");
    if (this.created == newValue) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        newValue,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getCreated() created} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for created
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final File withCreated(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.created == value) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        value,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getModified() modified} attribute.
   * @param value The value for modified
   * @return A modified copy of {@code this} object
   */
  public final File withModified(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "modified");
    if (this.modified == newValue) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        newValue,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getModified() modified} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for modified
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final File withModified(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.modified == value) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        value,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getAccessed() accessed} attribute.
   * @param value The value for accessed
   * @return A modified copy of {@code this} object
   */
  public final File withAccessed(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "accessed");
    if (this.accessed == newValue) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        newValue,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getAccessed() accessed} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for accessed
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final File withAccessed(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.accessed == value) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        value,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getParentDirectoryRef() parentDirectoryRef} attribute.
   * @param value The value for parentDirectoryRef
   * @return A modified copy of {@code this} object
   */
  public final File withParentDirectoryRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "parentDirectoryRef");
    if (Objects.equals(this.parentDirectoryRef, newValue)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        newValue,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getParentDirectoryRef() parentDirectoryRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for parentDirectoryRef
   * @return A modified copy of {@code this} object
   */
  public final File withParentDirectoryRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.parentDirectoryRef, value)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        value,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#isEncrypted() isEncrypted} attribute.
   * @param value The value for isEncrypted
   * @return A modified copy of {@code this} object
   */
  public final File withIsEncrypted(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isEncrypted, newValue)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        newValue,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#isEncrypted() isEncrypted} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isEncrypted
   * @return A modified copy of {@code this} object
   */
  public final File withIsEncrypted(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isEncrypted, value)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        value,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getEncryptionAlgorithm() encryptionAlgorithm} attribute.
   * @param value The value for encryptionAlgorithm
   * @return A modified copy of {@code this} object
   */
  public final File withEncryptionAlgorithm(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "encryptionAlgorithm");
    if (Objects.equals(this.encryptionAlgorithm, newValue)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        newValue,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getEncryptionAlgorithm() encryptionAlgorithm} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for encryptionAlgorithm
   * @return A modified copy of {@code this} object
   */
  public final File withEncryptionAlgorithm(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.encryptionAlgorithm, value)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        value,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getDecryptionKey() decryptionKey} attribute.
   * @param value The value for decryptionKey
   * @return A modified copy of {@code this} object
   */
  public final File withDecryptionKey(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "decryptionKey");
    if (Objects.equals(this.decryptionKey, newValue)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        newValue,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getDecryptionKey() decryptionKey} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for decryptionKey
   * @return A modified copy of {@code this} object
   */
  public final File withDecryptionKey(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.decryptionKey, value)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        value,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getContentRef() contentRef} attribute.
   * @param value The value for contentRef
   * @return A modified copy of {@code this} object
   */
  public final File withContentRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "contentRef");
    if (Objects.equals(this.contentRef, newValue)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        newValue,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getContentRef() contentRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for contentRef
   * @return A modified copy of {@code this} object
   */
  public final File withContentRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.contentRef, value)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        value,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileCoo#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final File withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        value,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FileCoo#getExtensions() extensions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final File withExtensions(CyberObservableExtension... elements) {
    ImmutableSet<CyberObservableExtension> newValue = ImmutableSet.copyOf(elements);
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        newValue,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FileCoo#getExtensions() extensions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of extensions elements to set
   * @return A modified copy of {@code this} object
   */
  public final File withExtensions(Iterable<? extends CyberObservableExtension> elements) {
    if (this.extensions == elements) return this;
    ImmutableSet<CyberObservableExtension> newValue = ImmutableSet.copyOf(elements);
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        newValue,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileCoo#getObservableObjectKey() observableObjectKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for observableObjectKey
   * @return A modified copy of the {@code this} object
   */
  public final File withObservableObjectKey(String value) {
    String newValue = Objects.requireNonNull(value, "observableObjectKey");
    if (this.observableObjectKey.equals(newValue)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        newValue,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileCoo#getDefanged() defanged} attribute.
   * @param value The value for defanged
   * @return A modified copy of {@code this} object
   */
  public final File withDefanged(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.defanged, newValue)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        newValue,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileCoo#getDefanged() defanged} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for defanged
   * @return A modified copy of {@code this} object
   */
  public final File withDefanged(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.defanged, value)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        value,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by replacing the {@link FileCoo#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final File withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FileCoo#getObjectMarkingRefs() objectMarkingRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final File withObjectMarkingRefs(MarkingDefinitionDm... elements) {
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        newValue,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FileCoo#getObjectMarkingRefs() objectMarkingRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectMarkingRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final File withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
    if (this.objectMarkingRefs == elements) return this;
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        newValue,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FileCoo#getGranularMarkings() granularMarkings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final File withGranularMarkings(GranularMarkingDm... elements) {
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        newValue,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FileCoo#getGranularMarkings() granularMarkings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of granularMarkings elements to set
   * @return A modified copy of {@code this} object
   */
  public final File withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
    if (this.granularMarkings == elements) return this;
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        newValue,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileCoo#getHydrated() hydrated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hydrated
   * @return A modified copy of the {@code this} object
   */
  public final File withHydrated(boolean value) {
    if (this.hydrated == value) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        value,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileCoo#toJsonString() toJsonString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toJsonString (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final File withToJsonString(String value) {
    if (Objects.equals(this.toJsonString, value)) return this;
    return validate(new File(
        this.hashes,
        this.size,
        this.name,
        this.nameEnc,
        this.magicNumberHex,
        this.mimeType,
        this.created,
        this.modified,
        this.accessed,
        this.parentDirectoryRef,
        this.isEncrypted,
        this.encryptionAlgorithm,
        this.decryptionKey,
        this.contentRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        value));
  }

  /**
   * This instance is equal to all instances of {@code File} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof File
        && equalTo((File) another);
  }

  private boolean equalTo(File another) {
    return hashes.equals(another.hashes)
        && Objects.equals(size, another.size)
        && Objects.equals(name, another.name)
        && Objects.equals(nameEnc, another.nameEnc)
        && Objects.equals(magicNumberHex, another.magicNumberHex)
        && Objects.equals(mimeType, another.mimeType)
        && Objects.equals(created, another.created)
        && Objects.equals(modified, another.modified)
        && Objects.equals(accessed, another.accessed)
        && Objects.equals(parentDirectoryRef, another.parentDirectoryRef)
        && Objects.equals(isEncrypted, another.isEncrypted)
        && Objects.equals(encryptionAlgorithm, another.encryptionAlgorithm)
        && Objects.equals(decryptionKey, another.decryptionKey)
        && Objects.equals(contentRef, another.contentRef)
        && id.equals(another.id)
        && Objects.equals(type, another.type)
        && extensions.equals(another.extensions)
        && observableObjectKey.equals(another.observableObjectKey)
        && Objects.equals(defanged, another.defanged)
        && customProperties.equals(another.customProperties)
        && objectMarkingRefs.equals(another.objectMarkingRefs)
        && granularMarkings.equals(another.granularMarkings)
        && hydrated == another.hydrated
        && Objects.equals(toJsonString, another.toJsonString);
  }

  /**
   * Computes a hash code from attributes: {@code hashes}, {@code size}, {@code name}, {@code nameEnc}, {@code magicNumberHex}, {@code mimeType}, {@code created}, {@code modified}, {@code accessed}, {@code parentDirectoryRef}, {@code isEncrypted}, {@code encryptionAlgorithm}, {@code decryptionKey}, {@code contentRef}, {@code id}, {@code type}, {@code extensions}, {@code observableObjectKey}, {@code defanged}, {@code customProperties}, {@code objectMarkingRefs}, {@code granularMarkings}, {@code hydrated}, {@code toJsonString}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + hashes.hashCode();
    h += (h << 5) + Objects.hashCode(size);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(nameEnc);
    h += (h << 5) + Objects.hashCode(magicNumberHex);
    h += (h << 5) + Objects.hashCode(mimeType);
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(modified);
    h += (h << 5) + Objects.hashCode(accessed);
    h += (h << 5) + Objects.hashCode(parentDirectoryRef);
    h += (h << 5) + Objects.hashCode(isEncrypted);
    h += (h << 5) + Objects.hashCode(encryptionAlgorithm);
    h += (h << 5) + Objects.hashCode(decryptionKey);
    h += (h << 5) + Objects.hashCode(contentRef);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + extensions.hashCode();
    h += (h << 5) + observableObjectKey.hashCode();
    h += (h << 5) + Objects.hashCode(defanged);
    h += (h << 5) + customProperties.hashCode();
    h += (h << 5) + objectMarkingRefs.hashCode();
    h += (h << 5) + granularMarkings.hashCode();
    h += (h << 5) + Booleans.hashCode(hydrated);
    h += (h << 5) + Objects.hashCode(toJsonString);
    return h;
  }

  /**
   * Prints the immutable value {@code File} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("File")
        .omitNullValues()
        .add("hashes", hashes)
        .add("size", size)
        .add("name", name)
        .add("nameEnc", nameEnc)
        .add("magicNumberHex", magicNumberHex)
        .add("mimeType", mimeType)
        .add("created", created)
        .add("modified", modified)
        .add("accessed", accessed)
        .add("parentDirectoryRef", parentDirectoryRef)
        .add("isEncrypted", isEncrypted)
        .add("encryptionAlgorithm", encryptionAlgorithm)
        .add("decryptionKey", decryptionKey)
        .add("contentRef", contentRef)
        .add("id", id)
        .add("type", type)
        .add("extensions", extensions)
        .add("observableObjectKey", observableObjectKey)
        .add("defanged", defanged)
        .add("customProperties", customProperties)
        .add("objectMarkingRefs", objectMarkingRefs)
        .add("granularMarkings", granularMarkings)
        .add("hydrated", hydrated)
        .add("toJsonString", toJsonString)
        .toString();
  }


  private static File validate(File instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link FileCoo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable File instance
   */
  public static File copyOf(FileCoo instance) {
    if (instance instanceof File) {
      return (File) instance;
    }
    return File.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link File File}.
   * @return A new File builder
   */
  public static File.Builder builder() {
    return new File.Builder();
  }

  /**
   * Builds instances of type {@link File File}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FileCoo", generator = "Immutables")
  @NotThreadSafe
  @JsonTypeName("file")
  @JsonPropertyOrder({"type", "extensions", "hashes", "size", "name", "name_enc", "magic_number_hex", "mime_type", "created", "modified", "accessed", "parent_directory_ref", "is_encrypted", "encryption_algorithm", "decryption_key", "contains_refs", "content_ref"})
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  public static final class Builder {
    private static final long OPT_BIT_EXTENSIONS = 0x1L;
    private long optBits;

    private ImmutableMap.Builder<String, String> hashes = ImmutableMap.builder();
    private @Nullable Long size;
    private @Nullable String name;
    private @Nullable String nameEnc;
    private @Nullable String magicNumberHex;
    private @Nullable String mimeType;
    private @Nullable StixInstant created;
    private @Nullable StixInstant modified;
    private @Nullable StixInstant accessed;
    private @Nullable String parentDirectoryRef;
    private @Nullable Boolean isEncrypted;
    private @Nullable String encryptionAlgorithm;
    private @Nullable String decryptionKey;
    private @Nullable String contentRef;
    private @Nullable String type;
    private ImmutableSet.Builder<CyberObservableExtension> extensions = ImmutableSet.builder();
    private @Nullable String observableObjectKey;
    private @Nullable Boolean defanged;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
    private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
    private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
    private boolean hydrated;
    private @Nullable String toJsonString;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleableObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleableObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.CyberObservableObjectCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableObjectCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.objects.FileCoo} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FileCoo instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BundleableObject) {
        BundleableObject instance = (BundleableObject) object;
        addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        hydrated(instance.getHydrated());
        addAllGranularMarkings(instance.getGranularMarkings());
        String toJsonStringValue = instance.toJsonString();
        if (toJsonStringValue != null) {
          toJsonString(toJsonStringValue);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof CyberObservableObjectCommonProperties) {
        CyberObservableObjectCommonProperties instance = (CyberObservableObjectCommonProperties) object;
        addAllExtensions(instance.getExtensions());
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        observableObjectKey(instance.getObservableObjectKey());
        Optional<Boolean> defangedOptional = instance.getDefanged();
        if (defangedOptional.isPresent()) {
          defanged(defangedOptional);
        }
      }
      if (object instanceof FileCoo) {
        FileCoo instance = (FileCoo) object;
        Optional<StixInstant> createdOptional = instance.getCreated();
        if (createdOptional.isPresent()) {
          created(createdOptional);
        }
        Optional<String> mimeTypeOptional = instance.getMimeType();
        if (mimeTypeOptional.isPresent()) {
          mimeType(mimeTypeOptional);
        }
        Optional<StixInstant> accessedOptional = instance.getAccessed();
        if (accessedOptional.isPresent()) {
          accessed(accessedOptional);
        }
        Optional<String> nameEncOptional = instance.getNameEnc();
        if (nameEncOptional.isPresent()) {
          nameEnc(nameEncOptional);
        }
        Optional<String> encryptionAlgorithmOptional = instance.getEncryptionAlgorithm();
        if (encryptionAlgorithmOptional.isPresent()) {
          encryptionAlgorithm(encryptionAlgorithmOptional);
        }
        Optional<String> magicNumberHexOptional = instance.getMagicNumberHex();
        if (magicNumberHexOptional.isPresent()) {
          magicNumberHex(magicNumberHexOptional);
        }
        Optional<String> decryptionKeyOptional = instance.getDecryptionKey();
        if (decryptionKeyOptional.isPresent()) {
          decryptionKey(decryptionKeyOptional);
        }
        Optional<String> parentDirectoryRefOptional = instance.getParentDirectoryRef();
        if (parentDirectoryRefOptional.isPresent()) {
          parentDirectoryRef(parentDirectoryRefOptional);
        }
        Optional<Long> sizeOptional = instance.getSize();
        if (sizeOptional.isPresent()) {
          size(sizeOptional);
        }
        Optional<Boolean> isEncryptedOptional = instance.isEncrypted();
        if (isEncryptedOptional.isPresent()) {
          isEncrypted(isEncryptedOptional);
        }
        putAllHashes(instance.getHashes());
        Optional<String> nameOptional = instance.getName();
        if (nameOptional.isPresent()) {
          name(nameOptional);
        }
        Optional<StixInstant> modifiedOptional = instance.getModified();
        if (modifiedOptional.isPresent()) {
          modified(modifiedOptional);
        }
        Optional<String> contentRefOptional = instance.getContentRef();
        if (contentRefOptional.isPresent()) {
          contentRef(contentRefOptional);
        }
      }
    }

    /**
     * Put one entry to the {@link FileCoo#getHashes() hashes} map.
     * @param key The key in the hashes map
     * @param value The associated value in the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHash(String key, String value) {
      this.hashes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link FileCoo#getHashes() hashes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHash(Map.Entry<String, ? extends String> entry) {
      this.hashes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FileCoo#getHashes() hashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hashes")
    @JsonPropertyDescription("Specifies a dictionary of hashes for the contents of the file.")
    public final Builder hashes(Map<String, ? extends String> entries) {
      this.hashes = ImmutableMap.builder();
      return putAllHashes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FileCoo#getHashes() hashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllHashes(Map<String, ? extends String> entries) {
      this.hashes.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getSize() size} to size.
     * @param size The value for size
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder size(long size) {
      this.size = size;
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getSize() size} to size.
     * @param size The value for size
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size")
    @JsonPropertyDescription("Specifies the size of the file, in bytes, as a non-negative integer.")
    public final Builder size(Optional<Long> size) {
      this.size = size.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    @JsonPropertyDescription("Specifies the name of the file.")
    public final Builder name(Optional<String> name) {
      this.name = name.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getNameEnc() nameEnc} to nameEnc.
     * @param nameEnc The value for nameEnc
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nameEnc(String nameEnc) {
      this.nameEnc = Objects.requireNonNull(nameEnc, "nameEnc");
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getNameEnc() nameEnc} to nameEnc.
     * @param nameEnc The value for nameEnc
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name_enc")
    @JsonPropertyDescription("Specifies the observed encoding for the name of the file.")
    public final Builder nameEnc(Optional<String> nameEnc) {
      this.nameEnc = nameEnc.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getMagicNumberHex() magicNumberHex} to magicNumberHex.
     * @param magicNumberHex The value for magicNumberHex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder magicNumberHex(String magicNumberHex) {
      this.magicNumberHex = Objects.requireNonNull(magicNumberHex, "magicNumberHex");
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getMagicNumberHex() magicNumberHex} to magicNumberHex.
     * @param magicNumberHex The value for magicNumberHex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("magic_number_hex")
    @JsonPropertyDescription("Specifies the hexadecimal constant (\'magic number\') associated with a specific file format that corresponds to the file, if applicable.")
    public final Builder magicNumberHex(Optional<String> magicNumberHex) {
      this.magicNumberHex = magicNumberHex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getMimeType() mimeType} to mimeType.
     * @param mimeType The value for mimeType
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mimeType(String mimeType) {
      this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getMimeType() mimeType} to mimeType.
     * @param mimeType The value for mimeType
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("mime_type")
    @JsonPropertyDescription("Specifies the MIME type name specified for the file, e.g., \'application/msword\'.")
    public final Builder mimeType(Optional<String> mimeType) {
      this.mimeType = mimeType.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getCreated() created} to created.
     * @param created The value for created
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder created(StixInstant created) {
      this.created = Objects.requireNonNull(created, "created");
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getCreated() created} to created.
     * @param created The value for created
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    @JsonPropertyDescription("Specifies the date/time the file was created.")
    public final Builder created(Optional<? extends StixInstant> created) {
      this.created = created.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getModified() modified} to modified.
     * @param modified The value for modified
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder modified(StixInstant modified) {
      this.modified = Objects.requireNonNull(modified, "modified");
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getModified() modified} to modified.
     * @param modified The value for modified
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("modified")
    @JsonPropertyDescription("Specifies the date/time the file was last written to/modified.")
    public final Builder modified(Optional<? extends StixInstant> modified) {
      this.modified = modified.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getAccessed() accessed} to accessed.
     * @param accessed The value for accessed
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder accessed(StixInstant accessed) {
      this.accessed = Objects.requireNonNull(accessed, "accessed");
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getAccessed() accessed} to accessed.
     * @param accessed The value for accessed
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("accessed")
    @JsonPropertyDescription("Specifies the date/time the file was last accessed.")
    public final Builder accessed(Optional<? extends StixInstant> accessed) {
      this.accessed = accessed.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getParentDirectoryRef() parentDirectoryRef} to parentDirectoryRef.
     * @param parentDirectoryRef The value for parentDirectoryRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parentDirectoryRef(String parentDirectoryRef) {
      this.parentDirectoryRef = Objects.requireNonNull(parentDirectoryRef, "parentDirectoryRef");
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getParentDirectoryRef() parentDirectoryRef} to parentDirectoryRef.
     * @param parentDirectoryRef The value for parentDirectoryRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("parent_directory_ref")
    @JsonPropertyDescription("Specifies the parent directory of the file, as a reference to a Directory Object.")
    public final Builder parentDirectoryRef(Optional<String> parentDirectoryRef) {
      this.parentDirectoryRef = parentDirectoryRef.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#isEncrypted() isEncrypted} to isEncrypted.
     * @param isEncrypted The value for isEncrypted
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isEncrypted(boolean isEncrypted) {
      this.isEncrypted = isEncrypted;
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#isEncrypted() isEncrypted} to isEncrypted.
     * @param isEncrypted The value for isEncrypted
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("is_encrypted")
    @JsonPropertyDescription("Specifies whether the file is encrypted.")
    public final Builder isEncrypted(Optional<Boolean> isEncrypted) {
      this.isEncrypted = isEncrypted.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getEncryptionAlgorithm() encryptionAlgorithm} to encryptionAlgorithm.
     * @param encryptionAlgorithm The value for encryptionAlgorithm
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder encryptionAlgorithm(String encryptionAlgorithm) {
      this.encryptionAlgorithm = Objects.requireNonNull(encryptionAlgorithm, "encryptionAlgorithm");
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getEncryptionAlgorithm() encryptionAlgorithm} to encryptionAlgorithm.
     * @param encryptionAlgorithm The value for encryptionAlgorithm
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("encryption_algorithm")
    @JsonPropertyDescription("Specifies the name of the encryption algorithm used to encrypt the file. Open Vocabulary - encryption-algorithm-ov")
    public final Builder encryptionAlgorithm(Optional<String> encryptionAlgorithm) {
      this.encryptionAlgorithm = encryptionAlgorithm.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getDecryptionKey() decryptionKey} to decryptionKey.
     * @param decryptionKey The value for decryptionKey
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder decryptionKey(String decryptionKey) {
      this.decryptionKey = Objects.requireNonNull(decryptionKey, "decryptionKey");
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getDecryptionKey() decryptionKey} to decryptionKey.
     * @param decryptionKey The value for decryptionKey
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("decryption_key")
    @JsonPropertyDescription("Specifies the decryption key used to decrypt the archive file.")
    public final Builder decryptionKey(Optional<String> decryptionKey) {
      this.decryptionKey = decryptionKey.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getContentRef() contentRef} to contentRef.
     * @param contentRef The value for contentRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder contentRef(String contentRef) {
      this.contentRef = Objects.requireNonNull(contentRef, "contentRef");
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getContentRef() contentRef} to contentRef.
     * @param contentRef The value for contentRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content_ref")
    @JsonPropertyDescription("Specifies the content of the file, represented as an Artifact Object.")
    public final Builder contentRef(Optional<String> contentRef) {
      this.contentRef = contentRef.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link FileCoo#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Adds one element to {@link FileCoo#getExtensions() extensions} set.
     * @param element A extensions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtension(@Nullable CyberObservableExtension element) {
      this.extensions.add(element);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }

    /**
     * Adds elements to {@link FileCoo#getExtensions() extensions} set.
     * @param elements An array of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtensions(CyberObservableExtension... elements) {
      this.extensions.add(elements);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FileCoo#getExtensions() extensions} set.
     * @param elements An iterable of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("extensions")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Specifies any extensions of the object, as a dictionary.")
    @JsonSerialize(using = CyberObservableExtensionsFieldSerializer.class)
    @JsonDeserialize(using = CyberObservableExtensionsFieldDeserializer.class)
    public final Builder extensions(Iterable<? extends CyberObservableExtension> elements) {
      this.extensions = ImmutableSet.builder();
      return addAllExtensions(elements);
    }

    /**
     * Adds elements to {@link FileCoo#getExtensions() extensions} set.
     * @param elements An iterable of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExtensions(Iterable<? extends CyberObservableExtension> elements) {
      this.extensions.addAll(elements);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }

    /**
     * Initializes the value for the {@link FileCoo#getObservableObjectKey() observableObjectKey} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link FileCoo#getObservableObjectKey() observableObjectKey}.</em>
     * @param observableObjectKey The value for observableObjectKey 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "observable_object_key", access = JsonProperty.Access.WRITE_ONLY)
    public final Builder observableObjectKey(String observableObjectKey) {
      this.observableObjectKey = Objects.requireNonNull(observableObjectKey, "observableObjectKey");
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getDefanged() defanged} to defanged.
     * @param defanged The value for defanged
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defanged(boolean defanged) {
      this.defanged = defanged;
      return this;
    }

    /**
     * Initializes the optional value {@link FileCoo#getDefanged() defanged} to defanged.
     * @param defanged The value for defanged
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("defanged")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Indicates whether the data contained in the SCO has been defanged.")
    public final Builder defanged(Optional<Boolean> defanged) {
      this.defanged = defanged.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link FileCoo#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link FileCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FileCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FileCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link FileCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param element A objectMarkingRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
      this.objectMarkingRefs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link FileCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An array of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRefs(MarkingDefinitionDm... elements) {
      this.objectMarkingRefs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FileCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("objectMarkingRefs")
    public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs = ImmutableSet.builder();
      return addAllObjectMarkingRefs(elements);
    }

    /**
     * Adds elements to {@link FileCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link FileCoo#getGranularMarkings() granularMarkings} set.
     * @param element A granularMarkings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
      this.granularMarkings.add(element);
      return this;
    }

    /**
     * Adds elements to {@link FileCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An array of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarkings(GranularMarkingDm... elements) {
      this.granularMarkings.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FileCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("granularMarkings")
    public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings = ImmutableSet.builder();
      return addAllGranularMarkings(elements);
    }

    /**
     * Adds elements to {@link FileCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link FileCoo#getHydrated() hydrated} attribute.
     * @param hydrated The value for hydrated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hydrated")
    public final Builder hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      return this;
    }

    /**
     * Initializes the value for the {@link FileCoo#toJsonString() toJsonString} attribute.
     * @param toJsonString The value for toJsonString (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("toJsonString")
    public final Builder toJsonString(String toJsonString) {
      this.toJsonString = toJsonString;
      return this;
    }

    /**
     * Builds a new {@link File File}.
     * @return An immutable instance of File
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public File build() {
      return File.validate(new File(this));
    }

    private boolean extensionsIsSet() {
      return (optBits & OPT_BIT_EXTENSIONS) != 0;
    }
  }
}
