package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObjectCommonProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldDeserializer;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldSerializer;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;

/**
 * network-traffic
 * <p>
 * The Network Traffic Object represents arbitrary network traffic that
 * originates from a source and is addressed to a destination.
 */
@Generated(from = "NetworkTrafficCoo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("network-traffic")
public final class NetworkTraffic implements NetworkTrafficCoo {
  private final @Nullable StixInstant start;
  private final @Nullable StixInstant end;
  private final @Nullable Boolean isActive;
  private final @Nullable String srcRef;
  private final @Nullable String dstRef;
  private final @Nullable Integer srcPort;
  private final @Nullable Integer dstPort;
  private final @Nullable Long srcByteCount;
  private final @Nullable Long dstByteCount;
  private final @Nullable Long srcPackets;
  private final @Nullable Long dstPackets;
  private final ImmutableMap<String, Object> ipFix;
  private final @Nullable String srcPayloadRef;
  private final @Nullable String dstPayloadRef;
  private final @Nullable String encapsulatedByRef;
  private final String id;
  private final String type;
  private final ImmutableSet<CyberObservableExtension> extensions;
  private final String observableObjectKey;
  private final @Nullable Boolean defanged;
  private final ImmutableMap<String, Object> customProperties;
  private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
  private final ImmutableSet<GranularMarkingDm> granularMarkings;
  private final boolean hydrated;
  private final String toJsonString;

  private NetworkTraffic(NetworkTraffic.Builder builder) {
    this.start = builder.start;
    this.end = builder.end;
    this.isActive = builder.isActive;
    this.srcRef = builder.srcRef;
    this.dstRef = builder.dstRef;
    this.srcPort = builder.srcPort;
    this.dstPort = builder.dstPort;
    this.srcByteCount = builder.srcByteCount;
    this.dstByteCount = builder.dstByteCount;
    this.srcPackets = builder.srcPackets;
    this.dstPackets = builder.dstPackets;
    this.ipFix = builder.ipFix.build();
    this.srcPayloadRef = builder.srcPayloadRef;
    this.dstPayloadRef = builder.dstPayloadRef;
    this.encapsulatedByRef = builder.encapsulatedByRef;
    this.type = builder.type;
    this.defanged = builder.defanged;
    this.customProperties = builder.customProperties.build();
    this.objectMarkingRefs = builder.objectMarkingRefs.build();
    this.granularMarkings = builder.granularMarkings.build();
    this.hydrated = builder.hydrated;
    this.toJsonString = builder.toJsonString;
    if (builder.extensionsIsSet()) {
      initShim.extensions(builder.extensions.build());
    }
    if (builder.observableObjectKey != null) {
      initShim.observableObjectKey(builder.observableObjectKey);
    }
    this.id = initShim.getId();
    this.extensions = initShim.getExtensions();
    this.observableObjectKey = initShim.getObservableObjectKey();
    this.initShim = null;
  }

  private NetworkTraffic(
      @Nullable StixInstant start,
      @Nullable StixInstant end,
      @Nullable Boolean isActive,
      @Nullable String srcRef,
      @Nullable String dstRef,
      @Nullable Integer srcPort,
      @Nullable Integer dstPort,
      @Nullable Long srcByteCount,
      @Nullable Long dstByteCount,
      @Nullable Long srcPackets,
      @Nullable Long dstPackets,
      ImmutableMap<String, Object> ipFix,
      @Nullable String srcPayloadRef,
      @Nullable String dstPayloadRef,
      @Nullable String encapsulatedByRef,
      String type,
      ImmutableSet<CyberObservableExtension> extensions,
      String observableObjectKey,
      @Nullable Boolean defanged,
      ImmutableMap<String, Object> customProperties,
      ImmutableSet<MarkingDefinitionDm> objectMarkingRefs,
      ImmutableSet<GranularMarkingDm> granularMarkings,
      boolean hydrated,
      String toJsonString) {
    this.start = start;
    this.end = end;
    this.isActive = isActive;
    this.srcRef = srcRef;
    this.dstRef = dstRef;
    this.srcPort = srcPort;
    this.dstPort = dstPort;
    this.srcByteCount = srcByteCount;
    this.dstByteCount = dstByteCount;
    this.srcPackets = srcPackets;
    this.dstPackets = dstPackets;
    this.ipFix = ipFix;
    this.srcPayloadRef = srcPayloadRef;
    this.dstPayloadRef = dstPayloadRef;
    this.encapsulatedByRef = encapsulatedByRef;
    this.type = type;
    initShim.extensions(extensions);
    initShim.observableObjectKey(observableObjectKey);
    this.defanged = defanged;
    this.customProperties = customProperties;
    this.objectMarkingRefs = objectMarkingRefs;
    this.granularMarkings = granularMarkings;
    this.hydrated = hydrated;
    this.toJsonString = toJsonString;
    this.id = initShim.getId();
    this.extensions = initShim.getExtensions();
    this.observableObjectKey = initShim.getObservableObjectKey();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "NetworkTrafficCoo", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    private byte extensionsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<CyberObservableExtension> extensions;

    ImmutableSet<CyberObservableExtension> getExtensions() {
      if (extensionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (extensionsBuildStage == STAGE_UNINITIALIZED) {
        extensionsBuildStage = STAGE_INITIALIZING;
        this.extensions = ImmutableSet.copyOf(getExtensionsInitialize());
        extensionsBuildStage = STAGE_INITIALIZED;
      }
      return this.extensions;
    }

    void extensions(ImmutableSet<CyberObservableExtension> extensions) {
      this.extensions = extensions;
      extensionsBuildStage = STAGE_INITIALIZED;
    }

    private byte observableObjectKeyBuildStage = STAGE_UNINITIALIZED;
    private String observableObjectKey;

    String getObservableObjectKey() {
      if (observableObjectKeyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (observableObjectKeyBuildStage == STAGE_UNINITIALIZED) {
        observableObjectKeyBuildStage = STAGE_INITIALIZING;
        this.observableObjectKey = Objects.requireNonNull(getObservableObjectKeyInitialize(), "observableObjectKey");
        observableObjectKeyBuildStage = STAGE_INITIALIZED;
      }
      return this.observableObjectKey;
    }

    void observableObjectKey(String observableObjectKey) {
      this.observableObjectKey = observableObjectKey;
      observableObjectKeyBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (extensionsBuildStage == STAGE_INITIALIZING) attributes.add("extensions");
      if (observableObjectKeyBuildStage == STAGE_INITIALIZING) attributes.add("observableObjectKey");
      return "Cannot build NetworkTraffic, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return NetworkTrafficCoo.super.getId();
  }

  private Set<CyberObservableExtension> getExtensionsInitialize() {
    return NetworkTrafficCoo.super.getExtensions();
  }

  private String getObservableObjectKeyInitialize() {
    return NetworkTrafficCoo.super.getObservableObjectKey();
  }

  /**
   * @return The value of the {@code start} attribute
   */
  @JsonProperty("start")
  @JsonPropertyDescription("Specifies the date/time the network traffic was initiated, if known.")
  @Override
  public Optional<StixInstant> getStart() {
    return Optional.ofNullable(start);
  }

  /**
   * @return The value of the {@code end} attribute
   */
  @JsonProperty("end")
  @JsonPropertyDescription("Specifies the date/time the network traffic ended, if known.")
  @Override
  public Optional<StixInstant> getEnd() {
    return Optional.ofNullable(end);
  }

  /**
   * @return The value of the {@code isActive} attribute
   */
  @JsonProperty("is_active")
  @JsonPropertyDescription("Indicates whether the network traffic is still ongoing.")
  @Override
  public Optional<Boolean> isActive() {
    return Optional.ofNullable(isActive);
  }

  /**
   * @return The value of the {@code srcRef} attribute
   */
  @JsonProperty("src_ref")
  @JsonPropertyDescription("Specifies the source of the network traffic, as a reference to one or more Observable Objects.")
  @Override
  public Optional<String> getSrcRef() {
    return Optional.ofNullable(srcRef);
  }

  /**
   * @return The value of the {@code dstRef} attribute
   */
  @JsonProperty("dst_ref")
  @JsonPropertyDescription("Specifies the destination of the network traffic, as a reference to one or more Observable Objects.")
  @Override
  public Optional<String> getDstRef() {
    return Optional.ofNullable(dstRef);
  }

  /**
   * @return The value of the {@code srcPort} attribute
   */
  @JsonProperty("src_port")
  @JsonPropertyDescription("Specifies the source port used in the network traffic, as an integer. The port value MUST be in the range of 0 - 65535.")
  @Override
  public Optional<Integer> getSrcPort() {
    return Optional.ofNullable(srcPort);
  }

  /**
   * @return The value of the {@code dstPort} attribute
   */
  @JsonProperty("dst_port")
  @JsonPropertyDescription("Specifies the destination port used in the network traffic, as an integer. The port value MUST be in the range of 0 - 65535.")
  @Override
  public Optional<Integer> getDstPort() {
    return Optional.ofNullable(dstPort);
  }

  /**
   * @return The value of the {@code srcByteCount} attribute
   */
  @JsonProperty("src_byte_count")
  @JsonPropertyDescription("Specifies the number of bytes sent from the source to the destination.")
  @Override
  public Optional<Long> getSrcByteCount() {
    return Optional.ofNullable(srcByteCount);
  }

  /**
   * @return The value of the {@code dstByteCount} attribute
   */
  @JsonProperty("dst_byte_count")
  @JsonPropertyDescription("Specifies the number of bytes sent from the destination to the source.")
  @Override
  public Optional<Long> getDstByteCount() {
    return Optional.ofNullable(dstByteCount);
  }

  /**
   * @return The value of the {@code srcPackets} attribute
   */
  @JsonProperty("src_packets")
  @JsonPropertyDescription("Specifies the number of packets sent from the source to the destination.")
  @Override
  public Optional<Long> getSrcPackets() {
    return Optional.ofNullable(srcPackets);
  }

  /**
   * @return The value of the {@code dstPackets} attribute
   */
  @JsonProperty("dst_packets")
  @JsonPropertyDescription("Specifies the number of packets sent destination to the source.")
  @Override
  public Optional<Long> getDstPackets() {
    return Optional.ofNullable(dstPackets);
  }

  /**
   * @return The value of the {@code ipFix} attribute
   */
  @JsonProperty("ipfix")
  @JsonPropertyDescription("Specifies any IP Flow Information Export [IPFIX] data for the traffic, as a dictionary.")
  @Override
  public ImmutableMap<String, Object> getIpFix() {
    return ipFix;
  }

  /**
   * @return The value of the {@code srcPayloadRef} attribute
   */
  @JsonProperty("src_payload_ref")
  @JsonPropertyDescription("Specifies the bytes sent from the source to the destination.")
  @Override
  public Optional<String> getSrcPayloadRef() {
    return Optional.ofNullable(srcPayloadRef);
  }

  /**
   * @return The value of the {@code dstPayloadRef} attribute
   */
  @JsonProperty("dst_payload_ref")
  @JsonPropertyDescription("Specifies the bytes sent from the source to the destination.")
  @Override
  public Optional<String> getDstPayloadRef() {
    return Optional.ofNullable(dstPayloadRef);
  }

  /**
   * @return The value of the {@code encapsulatedByRef} attribute
   */
  @JsonProperty("encapsulated_by_ref")
  @JsonPropertyDescription("Links to another network-traffic object which encapsulates this object.")
  @Override
  public Optional<String> getEncapsulatedByRef() {
    return Optional.ofNullable(encapsulatedByRef);
  }

  /**
   * Deterministically generates the ID for this network traffic based on source/destination references, ports, and protocols.
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Multiple extensions can be added, but only 1 instance of a specific extension can be added.
   */
  @JsonProperty("extensions")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Specifies any extensions of the object, as a dictionary.")
  @JsonSerialize(using = CyberObservableExtensionsFieldSerializer.class)
  @JsonDeserialize(using = CyberObservableExtensionsFieldDeserializer.class)
  @Override
  public ImmutableSet<CyberObservableExtension> getExtensions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExtensions()
        : this.extensions;
  }

  /**
   * Used for generation of Map Keys by {@link ObservedDataSdo#getObjects()}
   * Manually set this value if you want to control key names.  Otherwise UUIDs will be used.
   */
  @JsonProperty(value = "observable_object_key", access = JsonProperty.Access.WRITE_ONLY)
  @Override
  public String getObservableObjectKey() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObservableObjectKey()
        : this.observableObjectKey;
  }

  /**
   * Indicates whether the data contained in the SCO has been defanged.
   * Defanging refers to the process of modifying data to make it safe to handle
   * (e.g., changing an IP address from 192.168.1.1 to 192[.]168[.]1[.]1).
   */
  @JsonProperty("defanged")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Indicates whether the data contained in the SCO has been defanged.")
  @Override
  public Optional<Boolean> getDefanged() {
    return Optional.ofNullable(defanged);
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * @return The value of the {@code objectMarkingRefs} attribute
   */
  @JsonProperty("objectMarkingRefs")
  @Override
  public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
    return objectMarkingRefs;
  }

  /**
   * @return The value of the {@code granularMarkings} attribute
   */
  @JsonProperty("granularMarkings")
  @Override
  public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
    return granularMarkings;
  }

  /**
   * @return The value of the {@code hydrated} attribute
   */
  @JsonProperty("hydrated")
  @Override
  public boolean getHydrated() {
    return hydrated;
  }

  /**
   * @return The value of the {@code toJsonString} attribute
   */
  @JsonProperty("toJsonString")
  @Override
  public String toJsonString() {
    return toJsonString;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getStart() start} attribute.
   * @param value The value for start
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withStart(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "start");
    if (this.start == newValue) return this;
    return validate(new NetworkTraffic(
        newValue,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getStart() start} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for start
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final NetworkTraffic withStart(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.start == value) return this;
    return validate(new NetworkTraffic(
        value,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getEnd() end} attribute.
   * @param value The value for end
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withEnd(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "end");
    if (this.end == newValue) return this;
    return validate(new NetworkTraffic(
        this.start,
        newValue,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getEnd() end} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for end
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final NetworkTraffic withEnd(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.end == value) return this;
    return validate(new NetworkTraffic(
        this.start,
        value,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#isActive() isActive} attribute.
   * @param value The value for isActive
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withIsActive(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isActive, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        newValue,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#isActive() isActive} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isActive
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withIsActive(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isActive, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        value,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getSrcRef() srcRef} attribute.
   * @param value The value for srcRef
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withSrcRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "srcRef");
    if (Objects.equals(this.srcRef, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        newValue,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getSrcRef() srcRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for srcRef
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withSrcRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.srcRef, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        value,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getDstRef() dstRef} attribute.
   * @param value The value for dstRef
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withDstRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "dstRef");
    if (Objects.equals(this.dstRef, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        newValue,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getDstRef() dstRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dstRef
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withDstRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.dstRef, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        value,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getSrcPort() srcPort} attribute.
   * @param value The value for srcPort
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withSrcPort(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.srcPort, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        newValue,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getSrcPort() srcPort} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for srcPort
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withSrcPort(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.srcPort, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        value,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getDstPort() dstPort} attribute.
   * @param value The value for dstPort
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withDstPort(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.dstPort, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        newValue,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getDstPort() dstPort} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dstPort
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withDstPort(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.dstPort, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        value,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getSrcByteCount() srcByteCount} attribute.
   * @param value The value for srcByteCount
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withSrcByteCount(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.srcByteCount, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        newValue,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getSrcByteCount() srcByteCount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for srcByteCount
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withSrcByteCount(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.srcByteCount, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        value,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getDstByteCount() dstByteCount} attribute.
   * @param value The value for dstByteCount
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withDstByteCount(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.dstByteCount, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        newValue,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getDstByteCount() dstByteCount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dstByteCount
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withDstByteCount(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.dstByteCount, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        value,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getSrcPackets() srcPackets} attribute.
   * @param value The value for srcPackets
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withSrcPackets(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.srcPackets, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        newValue,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getSrcPackets() srcPackets} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for srcPackets
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withSrcPackets(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.srcPackets, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        value,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getDstPackets() dstPackets} attribute.
   * @param value The value for dstPackets
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withDstPackets(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.dstPackets, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        newValue,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getDstPackets() dstPackets} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dstPackets
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withDstPackets(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.dstPackets, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        value,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by replacing the {@link NetworkTrafficCoo#getIpFix() ipFix} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the ipFix map
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withIpFix(Map<String, ? extends Object> entries) {
    if (this.ipFix == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        newValue,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getSrcPayloadRef() srcPayloadRef} attribute.
   * @param value The value for srcPayloadRef
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withSrcPayloadRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "srcPayloadRef");
    if (Objects.equals(this.srcPayloadRef, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        newValue,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getSrcPayloadRef() srcPayloadRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for srcPayloadRef
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withSrcPayloadRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.srcPayloadRef, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        value,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getDstPayloadRef() dstPayloadRef} attribute.
   * @param value The value for dstPayloadRef
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withDstPayloadRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "dstPayloadRef");
    if (Objects.equals(this.dstPayloadRef, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        newValue,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getDstPayloadRef() dstPayloadRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dstPayloadRef
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withDstPayloadRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.dstPayloadRef, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        value,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getEncapsulatedByRef() encapsulatedByRef} attribute.
   * @param value The value for encapsulatedByRef
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withEncapsulatedByRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "encapsulatedByRef");
    if (Objects.equals(this.encapsulatedByRef, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        newValue,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getEncapsulatedByRef() encapsulatedByRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for encapsulatedByRef
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withEncapsulatedByRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.encapsulatedByRef, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        value,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkTrafficCoo#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final NetworkTraffic withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        value,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NetworkTrafficCoo#getExtensions() extensions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withExtensions(CyberObservableExtension... elements) {
    ImmutableSet<CyberObservableExtension> newValue = ImmutableSet.copyOf(elements);
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        newValue,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NetworkTrafficCoo#getExtensions() extensions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of extensions elements to set
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withExtensions(Iterable<? extends CyberObservableExtension> elements) {
    if (this.extensions == elements) return this;
    ImmutableSet<CyberObservableExtension> newValue = ImmutableSet.copyOf(elements);
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        newValue,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkTrafficCoo#getObservableObjectKey() observableObjectKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for observableObjectKey
   * @return A modified copy of the {@code this} object
   */
  public final NetworkTraffic withObservableObjectKey(String value) {
    String newValue = Objects.requireNonNull(value, "observableObjectKey");
    if (this.observableObjectKey.equals(newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        newValue,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NetworkTrafficCoo#getDefanged() defanged} attribute.
   * @param value The value for defanged
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withDefanged(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.defanged, newValue)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        newValue,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NetworkTrafficCoo#getDefanged() defanged} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for defanged
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withDefanged(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.defanged, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        value,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by replacing the {@link NetworkTrafficCoo#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NetworkTrafficCoo#getObjectMarkingRefs() objectMarkingRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withObjectMarkingRefs(MarkingDefinitionDm... elements) {
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        newValue,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NetworkTrafficCoo#getObjectMarkingRefs() objectMarkingRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectMarkingRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
    if (this.objectMarkingRefs == elements) return this;
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        newValue,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NetworkTrafficCoo#getGranularMarkings() granularMarkings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withGranularMarkings(GranularMarkingDm... elements) {
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        newValue,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NetworkTrafficCoo#getGranularMarkings() granularMarkings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of granularMarkings elements to set
   * @return A modified copy of {@code this} object
   */
  public final NetworkTraffic withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
    if (this.granularMarkings == elements) return this;
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        newValue,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkTrafficCoo#getHydrated() hydrated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hydrated
   * @return A modified copy of the {@code this} object
   */
  public final NetworkTraffic withHydrated(boolean value) {
    if (this.hydrated == value) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        value,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NetworkTrafficCoo#toJsonString() toJsonString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toJsonString (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final NetworkTraffic withToJsonString(String value) {
    if (Objects.equals(this.toJsonString, value)) return this;
    return validate(new NetworkTraffic(
        this.start,
        this.end,
        this.isActive,
        this.srcRef,
        this.dstRef,
        this.srcPort,
        this.dstPort,
        this.srcByteCount,
        this.dstByteCount,
        this.srcPackets,
        this.dstPackets,
        this.ipFix,
        this.srcPayloadRef,
        this.dstPayloadRef,
        this.encapsulatedByRef,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        value));
  }

  /**
   * This instance is equal to all instances of {@code NetworkTraffic} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof NetworkTraffic
        && equalTo((NetworkTraffic) another);
  }

  private boolean equalTo(NetworkTraffic another) {
    return Objects.equals(start, another.start)
        && Objects.equals(end, another.end)
        && Objects.equals(isActive, another.isActive)
        && Objects.equals(srcRef, another.srcRef)
        && Objects.equals(dstRef, another.dstRef)
        && Objects.equals(srcPort, another.srcPort)
        && Objects.equals(dstPort, another.dstPort)
        && Objects.equals(srcByteCount, another.srcByteCount)
        && Objects.equals(dstByteCount, another.dstByteCount)
        && Objects.equals(srcPackets, another.srcPackets)
        && Objects.equals(dstPackets, another.dstPackets)
        && ipFix.equals(another.ipFix)
        && Objects.equals(srcPayloadRef, another.srcPayloadRef)
        && Objects.equals(dstPayloadRef, another.dstPayloadRef)
        && Objects.equals(encapsulatedByRef, another.encapsulatedByRef)
        && id.equals(another.id)
        && Objects.equals(type, another.type)
        && extensions.equals(another.extensions)
        && observableObjectKey.equals(another.observableObjectKey)
        && Objects.equals(defanged, another.defanged)
        && customProperties.equals(another.customProperties)
        && objectMarkingRefs.equals(another.objectMarkingRefs)
        && granularMarkings.equals(another.granularMarkings)
        && hydrated == another.hydrated
        && Objects.equals(toJsonString, another.toJsonString);
  }

  /**
   * Computes a hash code from attributes: {@code start}, {@code end}, {@code isActive}, {@code srcRef}, {@code dstRef}, {@code srcPort}, {@code dstPort}, {@code srcByteCount}, {@code dstByteCount}, {@code srcPackets}, {@code dstPackets}, {@code ipFix}, {@code srcPayloadRef}, {@code dstPayloadRef}, {@code encapsulatedByRef}, {@code id}, {@code type}, {@code extensions}, {@code observableObjectKey}, {@code defanged}, {@code customProperties}, {@code objectMarkingRefs}, {@code granularMarkings}, {@code hydrated}, {@code toJsonString}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(start);
    h += (h << 5) + Objects.hashCode(end);
    h += (h << 5) + Objects.hashCode(isActive);
    h += (h << 5) + Objects.hashCode(srcRef);
    h += (h << 5) + Objects.hashCode(dstRef);
    h += (h << 5) + Objects.hashCode(srcPort);
    h += (h << 5) + Objects.hashCode(dstPort);
    h += (h << 5) + Objects.hashCode(srcByteCount);
    h += (h << 5) + Objects.hashCode(dstByteCount);
    h += (h << 5) + Objects.hashCode(srcPackets);
    h += (h << 5) + Objects.hashCode(dstPackets);
    h += (h << 5) + ipFix.hashCode();
    h += (h << 5) + Objects.hashCode(srcPayloadRef);
    h += (h << 5) + Objects.hashCode(dstPayloadRef);
    h += (h << 5) + Objects.hashCode(encapsulatedByRef);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + extensions.hashCode();
    h += (h << 5) + observableObjectKey.hashCode();
    h += (h << 5) + Objects.hashCode(defanged);
    h += (h << 5) + customProperties.hashCode();
    h += (h << 5) + objectMarkingRefs.hashCode();
    h += (h << 5) + granularMarkings.hashCode();
    h += (h << 5) + Booleans.hashCode(hydrated);
    h += (h << 5) + Objects.hashCode(toJsonString);
    return h;
  }

  /**
   * Prints the immutable value {@code NetworkTraffic} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NetworkTraffic")
        .omitNullValues()
        .add("start", start)
        .add("end", end)
        .add("isActive", isActive)
        .add("srcRef", srcRef)
        .add("dstRef", dstRef)
        .add("srcPort", srcPort)
        .add("dstPort", dstPort)
        .add("srcByteCount", srcByteCount)
        .add("dstByteCount", dstByteCount)
        .add("srcPackets", srcPackets)
        .add("dstPackets", dstPackets)
        .add("ipFix", ipFix)
        .add("srcPayloadRef", srcPayloadRef)
        .add("dstPayloadRef", dstPayloadRef)
        .add("encapsulatedByRef", encapsulatedByRef)
        .add("id", id)
        .add("type", type)
        .add("extensions", extensions)
        .add("observableObjectKey", observableObjectKey)
        .add("defanged", defanged)
        .add("customProperties", customProperties)
        .add("objectMarkingRefs", objectMarkingRefs)
        .add("granularMarkings", granularMarkings)
        .add("hydrated", hydrated)
        .add("toJsonString", toJsonString)
        .toString();
  }


  private static NetworkTraffic validate(NetworkTraffic instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link NetworkTrafficCoo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NetworkTraffic instance
   */
  public static NetworkTraffic copyOf(NetworkTrafficCoo instance) {
    if (instance instanceof NetworkTraffic) {
      return (NetworkTraffic) instance;
    }
    return NetworkTraffic.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link NetworkTraffic NetworkTraffic}.
   * @return A new NetworkTraffic builder
   */
  public static NetworkTraffic.Builder builder() {
    return new NetworkTraffic.Builder();
  }

  /**
   * Builds instances of type {@link NetworkTraffic NetworkTraffic}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NetworkTrafficCoo", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonTypeName("network-traffic")
  @JsonPropertyOrder({"type", "extensions", "start", "end", "src_ref", "dst_ref", "src_port", "dst_port", "protocols", "src_byte_count", "dst_byte_count", "src_packets", "dst_packets", "ipfix", "src_payload_ref", "dst_payload_ref", "encapsulates_refs", "encapsulated_by_ref"})
  public static final class Builder {
    private static final long OPT_BIT_EXTENSIONS = 0x1L;
    private long optBits;

    private @Nullable StixInstant start;
    private @Nullable StixInstant end;
    private @Nullable Boolean isActive;
    private @Nullable String srcRef;
    private @Nullable String dstRef;
    private @Nullable Integer srcPort;
    private @Nullable Integer dstPort;
    private @Nullable Long srcByteCount;
    private @Nullable Long dstByteCount;
    private @Nullable Long srcPackets;
    private @Nullable Long dstPackets;
    private ImmutableMap.Builder<String, Object> ipFix = ImmutableMap.builder();
    private @Nullable String srcPayloadRef;
    private @Nullable String dstPayloadRef;
    private @Nullable String encapsulatedByRef;
    private @Nullable String type;
    private ImmutableSet.Builder<CyberObservableExtension> extensions = ImmutableSet.builder();
    private @Nullable String observableObjectKey;
    private @Nullable Boolean defanged;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
    private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
    private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
    private boolean hydrated;
    private @Nullable String toJsonString;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.objects.NetworkTrafficCoo} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NetworkTrafficCoo instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleableObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleableObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.CyberObservableObjectCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableObjectCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof NetworkTrafficCoo) {
        NetworkTrafficCoo instance = (NetworkTrafficCoo) object;
        Optional<String> dstRefOptional = instance.getDstRef();
        if (dstRefOptional.isPresent()) {
          dstRef(dstRefOptional);
        }
        Optional<String> srcPayloadRefOptional = instance.getSrcPayloadRef();
        if (srcPayloadRefOptional.isPresent()) {
          srcPayloadRef(srcPayloadRefOptional);
        }
        Optional<StixInstant> startOptional = instance.getStart();
        if (startOptional.isPresent()) {
          start(startOptional);
        }
        Optional<String> encapsulatedByRefOptional = instance.getEncapsulatedByRef();
        if (encapsulatedByRefOptional.isPresent()) {
          encapsulatedByRef(encapsulatedByRefOptional);
        }
        Optional<Long> dstByteCountOptional = instance.getDstByteCount();
        if (dstByteCountOptional.isPresent()) {
          dstByteCount(dstByteCountOptional);
        }
        Optional<Integer> srcPortOptional = instance.getSrcPort();
        if (srcPortOptional.isPresent()) {
          srcPort(srcPortOptional);
        }
        Optional<Boolean> isActiveOptional = instance.isActive();
        if (isActiveOptional.isPresent()) {
          isActive(isActiveOptional);
        }
        Optional<Long> srcByteCountOptional = instance.getSrcByteCount();
        if (srcByteCountOptional.isPresent()) {
          srcByteCount(srcByteCountOptional);
        }
        Optional<Long> srcPacketsOptional = instance.getSrcPackets();
        if (srcPacketsOptional.isPresent()) {
          srcPackets(srcPacketsOptional);
        }
        Optional<Long> dstPacketsOptional = instance.getDstPackets();
        if (dstPacketsOptional.isPresent()) {
          dstPackets(dstPacketsOptional);
        }
        Optional<Integer> dstPortOptional = instance.getDstPort();
        if (dstPortOptional.isPresent()) {
          dstPort(dstPortOptional);
        }
        putAllIpFix(instance.getIpFix());
        Optional<String> dstPayloadRefOptional = instance.getDstPayloadRef();
        if (dstPayloadRefOptional.isPresent()) {
          dstPayloadRef(dstPayloadRefOptional);
        }
        Optional<StixInstant> endOptional = instance.getEnd();
        if (endOptional.isPresent()) {
          end(endOptional);
        }
        Optional<String> srcRefOptional = instance.getSrcRef();
        if (srcRefOptional.isPresent()) {
          srcRef(srcRefOptional);
        }
      }
      if (object instanceof BundleableObject) {
        BundleableObject instance = (BundleableObject) object;
        addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        hydrated(instance.getHydrated());
        addAllGranularMarkings(instance.getGranularMarkings());
        String toJsonStringValue = instance.toJsonString();
        if (toJsonStringValue != null) {
          toJsonString(toJsonStringValue);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof CyberObservableObjectCommonProperties) {
        CyberObservableObjectCommonProperties instance = (CyberObservableObjectCommonProperties) object;
        addAllExtensions(instance.getExtensions());
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        observableObjectKey(instance.getObservableObjectKey());
        Optional<Boolean> defangedOptional = instance.getDefanged();
        if (defangedOptional.isPresent()) {
          defanged(defangedOptional);
        }
      }
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getStart() start} to start.
     * @param start The value for start
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder start(StixInstant start) {
      this.start = Objects.requireNonNull(start, "start");
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getStart() start} to start.
     * @param start The value for start
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("start")
    @JsonPropertyDescription("Specifies the date/time the network traffic was initiated, if known.")
    public final Builder start(Optional<? extends StixInstant> start) {
      this.start = start.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getEnd() end} to end.
     * @param end The value for end
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder end(StixInstant end) {
      this.end = Objects.requireNonNull(end, "end");
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getEnd() end} to end.
     * @param end The value for end
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("end")
    @JsonPropertyDescription("Specifies the date/time the network traffic ended, if known.")
    public final Builder end(Optional<? extends StixInstant> end) {
      this.end = end.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#isActive() isActive} to isActive.
     * @param isActive The value for isActive
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isActive(boolean isActive) {
      this.isActive = isActive;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#isActive() isActive} to isActive.
     * @param isActive The value for isActive
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("is_active")
    @JsonPropertyDescription("Indicates whether the network traffic is still ongoing.")
    public final Builder isActive(Optional<Boolean> isActive) {
      this.isActive = isActive.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getSrcRef() srcRef} to srcRef.
     * @param srcRef The value for srcRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder srcRef(String srcRef) {
      this.srcRef = Objects.requireNonNull(srcRef, "srcRef");
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getSrcRef() srcRef} to srcRef.
     * @param srcRef The value for srcRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("src_ref")
    @JsonPropertyDescription("Specifies the source of the network traffic, as a reference to one or more Observable Objects.")
    public final Builder srcRef(Optional<String> srcRef) {
      this.srcRef = srcRef.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getDstRef() dstRef} to dstRef.
     * @param dstRef The value for dstRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dstRef(String dstRef) {
      this.dstRef = Objects.requireNonNull(dstRef, "dstRef");
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getDstRef() dstRef} to dstRef.
     * @param dstRef The value for dstRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("dst_ref")
    @JsonPropertyDescription("Specifies the destination of the network traffic, as a reference to one or more Observable Objects.")
    public final Builder dstRef(Optional<String> dstRef) {
      this.dstRef = dstRef.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getSrcPort() srcPort} to srcPort.
     * @param srcPort The value for srcPort
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder srcPort(int srcPort) {
      this.srcPort = srcPort;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getSrcPort() srcPort} to srcPort.
     * @param srcPort The value for srcPort
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("src_port")
    @JsonPropertyDescription("Specifies the source port used in the network traffic, as an integer. The port value MUST be in the range of 0 - 65535.")
    public final Builder srcPort(Optional<Integer> srcPort) {
      this.srcPort = srcPort.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getDstPort() dstPort} to dstPort.
     * @param dstPort The value for dstPort
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dstPort(int dstPort) {
      this.dstPort = dstPort;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getDstPort() dstPort} to dstPort.
     * @param dstPort The value for dstPort
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("dst_port")
    @JsonPropertyDescription("Specifies the destination port used in the network traffic, as an integer. The port value MUST be in the range of 0 - 65535.")
    public final Builder dstPort(Optional<Integer> dstPort) {
      this.dstPort = dstPort.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getSrcByteCount() srcByteCount} to srcByteCount.
     * @param srcByteCount The value for srcByteCount
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder srcByteCount(long srcByteCount) {
      this.srcByteCount = srcByteCount;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getSrcByteCount() srcByteCount} to srcByteCount.
     * @param srcByteCount The value for srcByteCount
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("src_byte_count")
    @JsonPropertyDescription("Specifies the number of bytes sent from the source to the destination.")
    public final Builder srcByteCount(Optional<Long> srcByteCount) {
      this.srcByteCount = srcByteCount.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getDstByteCount() dstByteCount} to dstByteCount.
     * @param dstByteCount The value for dstByteCount
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dstByteCount(long dstByteCount) {
      this.dstByteCount = dstByteCount;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getDstByteCount() dstByteCount} to dstByteCount.
     * @param dstByteCount The value for dstByteCount
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("dst_byte_count")
    @JsonPropertyDescription("Specifies the number of bytes sent from the destination to the source.")
    public final Builder dstByteCount(Optional<Long> dstByteCount) {
      this.dstByteCount = dstByteCount.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getSrcPackets() srcPackets} to srcPackets.
     * @param srcPackets The value for srcPackets
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder srcPackets(long srcPackets) {
      this.srcPackets = srcPackets;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getSrcPackets() srcPackets} to srcPackets.
     * @param srcPackets The value for srcPackets
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("src_packets")
    @JsonPropertyDescription("Specifies the number of packets sent from the source to the destination.")
    public final Builder srcPackets(Optional<Long> srcPackets) {
      this.srcPackets = srcPackets.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getDstPackets() dstPackets} to dstPackets.
     * @param dstPackets The value for dstPackets
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dstPackets(long dstPackets) {
      this.dstPackets = dstPackets;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getDstPackets() dstPackets} to dstPackets.
     * @param dstPackets The value for dstPackets
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("dst_packets")
    @JsonPropertyDescription("Specifies the number of packets sent destination to the source.")
    public final Builder dstPackets(Optional<Long> dstPackets) {
      this.dstPackets = dstPackets.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link NetworkTrafficCoo#getIpFix() ipFix} map.
     * @param key The key in the ipFix map
     * @param value The associated value in the ipFix map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIpFix(String key, Object value) {
      this.ipFix.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NetworkTrafficCoo#getIpFix() ipFix} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putIpFix(Map.Entry<String, ? extends Object> entry) {
      this.ipFix.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NetworkTrafficCoo#getIpFix() ipFix} map. Nulls are not permitted
     * @param entries The entries that will be added to the ipFix map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ipfix")
    @JsonPropertyDescription("Specifies any IP Flow Information Export [IPFIX] data for the traffic, as a dictionary.")
    public final Builder ipFix(Map<String, ? extends Object> entries) {
      this.ipFix = ImmutableMap.builder();
      return putAllIpFix(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NetworkTrafficCoo#getIpFix() ipFix} map. Nulls are not permitted
     * @param entries The entries that will be added to the ipFix map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllIpFix(Map<String, ? extends Object> entries) {
      this.ipFix.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getSrcPayloadRef() srcPayloadRef} to srcPayloadRef.
     * @param srcPayloadRef The value for srcPayloadRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder srcPayloadRef(String srcPayloadRef) {
      this.srcPayloadRef = Objects.requireNonNull(srcPayloadRef, "srcPayloadRef");
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getSrcPayloadRef() srcPayloadRef} to srcPayloadRef.
     * @param srcPayloadRef The value for srcPayloadRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("src_payload_ref")
    @JsonPropertyDescription("Specifies the bytes sent from the source to the destination.")
    public final Builder srcPayloadRef(Optional<String> srcPayloadRef) {
      this.srcPayloadRef = srcPayloadRef.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getDstPayloadRef() dstPayloadRef} to dstPayloadRef.
     * @param dstPayloadRef The value for dstPayloadRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dstPayloadRef(String dstPayloadRef) {
      this.dstPayloadRef = Objects.requireNonNull(dstPayloadRef, "dstPayloadRef");
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getDstPayloadRef() dstPayloadRef} to dstPayloadRef.
     * @param dstPayloadRef The value for dstPayloadRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("dst_payload_ref")
    @JsonPropertyDescription("Specifies the bytes sent from the source to the destination.")
    public final Builder dstPayloadRef(Optional<String> dstPayloadRef) {
      this.dstPayloadRef = dstPayloadRef.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getEncapsulatedByRef() encapsulatedByRef} to encapsulatedByRef.
     * @param encapsulatedByRef The value for encapsulatedByRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder encapsulatedByRef(String encapsulatedByRef) {
      this.encapsulatedByRef = Objects.requireNonNull(encapsulatedByRef, "encapsulatedByRef");
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getEncapsulatedByRef() encapsulatedByRef} to encapsulatedByRef.
     * @param encapsulatedByRef The value for encapsulatedByRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("encapsulated_by_ref")
    @JsonPropertyDescription("Links to another network-traffic object which encapsulates this object.")
    public final Builder encapsulatedByRef(Optional<String> encapsulatedByRef) {
      this.encapsulatedByRef = encapsulatedByRef.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkTrafficCoo#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Adds one element to {@link NetworkTrafficCoo#getExtensions() extensions} set.
     * @param element A extensions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtension(@Nullable CyberObservableExtension element) {
      this.extensions.add(element);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }

    /**
     * Adds elements to {@link NetworkTrafficCoo#getExtensions() extensions} set.
     * @param elements An array of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtensions(CyberObservableExtension... elements) {
      this.extensions.add(elements);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NetworkTrafficCoo#getExtensions() extensions} set.
     * @param elements An iterable of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("extensions")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Specifies any extensions of the object, as a dictionary.")
    @JsonSerialize(using = CyberObservableExtensionsFieldSerializer.class)
    @JsonDeserialize(using = CyberObservableExtensionsFieldDeserializer.class)
    public final Builder extensions(Iterable<? extends CyberObservableExtension> elements) {
      this.extensions = ImmutableSet.builder();
      return addAllExtensions(elements);
    }

    /**
     * Adds elements to {@link NetworkTrafficCoo#getExtensions() extensions} set.
     * @param elements An iterable of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExtensions(Iterable<? extends CyberObservableExtension> elements) {
      this.extensions.addAll(elements);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkTrafficCoo#getObservableObjectKey() observableObjectKey} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link NetworkTrafficCoo#getObservableObjectKey() observableObjectKey}.</em>
     * @param observableObjectKey The value for observableObjectKey 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "observable_object_key", access = JsonProperty.Access.WRITE_ONLY)
    public final Builder observableObjectKey(String observableObjectKey) {
      this.observableObjectKey = Objects.requireNonNull(observableObjectKey, "observableObjectKey");
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getDefanged() defanged} to defanged.
     * @param defanged The value for defanged
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defanged(boolean defanged) {
      this.defanged = defanged;
      return this;
    }

    /**
     * Initializes the optional value {@link NetworkTrafficCoo#getDefanged() defanged} to defanged.
     * @param defanged The value for defanged
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("defanged")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Indicates whether the data contained in the SCO has been defanged.")
    public final Builder defanged(Optional<Boolean> defanged) {
      this.defanged = defanged.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link NetworkTrafficCoo#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NetworkTrafficCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NetworkTrafficCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NetworkTrafficCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link NetworkTrafficCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param element A objectMarkingRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
      this.objectMarkingRefs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NetworkTrafficCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An array of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRefs(MarkingDefinitionDm... elements) {
      this.objectMarkingRefs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NetworkTrafficCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("objectMarkingRefs")
    public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs = ImmutableSet.builder();
      return addAllObjectMarkingRefs(elements);
    }

    /**
     * Adds elements to {@link NetworkTrafficCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link NetworkTrafficCoo#getGranularMarkings() granularMarkings} set.
     * @param element A granularMarkings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
      this.granularMarkings.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NetworkTrafficCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An array of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarkings(GranularMarkingDm... elements) {
      this.granularMarkings.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NetworkTrafficCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("granularMarkings")
    public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings = ImmutableSet.builder();
      return addAllGranularMarkings(elements);
    }

    /**
     * Adds elements to {@link NetworkTrafficCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkTrafficCoo#getHydrated() hydrated} attribute.
     * @param hydrated The value for hydrated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hydrated")
    public final Builder hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      return this;
    }

    /**
     * Initializes the value for the {@link NetworkTrafficCoo#toJsonString() toJsonString} attribute.
     * @param toJsonString The value for toJsonString (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("toJsonString")
    public final Builder toJsonString(String toJsonString) {
      this.toJsonString = toJsonString;
      return this;
    }

    /**
     * Builds a new {@link NetworkTraffic NetworkTraffic}.
     * @return An immutable instance of NetworkTraffic
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public NetworkTraffic build() {
      return NetworkTraffic.validate(new NetworkTraffic(this));
    }

    private boolean extensionsIsSet() {
      return (optBits & OPT_BIT_EXTENSIONS) != 0;
    }
  }
}
