package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObjectCommonProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldDeserializer;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldSerializer;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;

/**
 * user-account
 * <p>
 * The User Account Object represents an instance of any type of user account,
 * including but not limited to operating system, device, messaging service, and
 * social media platform accounts.
 */
@Generated(from = "UserAccountCoo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("user-account")
public final class UserAccount implements UserAccountCoo {
  private final String userId;
  private final @Nullable String accountLogin;
  private final @Nullable String accountType;
  private final @Nullable String displayName;
  private final @Nullable Boolean isServiceAccount;
  private final @Nullable Boolean isPrivileged;
  private final @Nullable Boolean isCanEscalatePrivs;
  private final @Nullable Boolean isDisabled;
  private final @Nullable StixInstant accountCreated;
  private final @Nullable StixInstant accountExpires;
  private final @Nullable StixInstant passwordLastChanged;
  private final @Nullable StixInstant accountFirstLogin;
  private final @Nullable StixInstant accountLastLogin;
  private final String id;
  private final String type;
  private final ImmutableSet<CyberObservableExtension> extensions;
  private final String observableObjectKey;
  private final @Nullable Boolean defanged;
  private final ImmutableMap<String, Object> customProperties;
  private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
  private final ImmutableSet<GranularMarkingDm> granularMarkings;
  private final boolean hydrated;
  private final String toJsonString;

  private UserAccount(UserAccount.Builder builder) {
    this.userId = builder.userId;
    this.accountLogin = builder.accountLogin;
    this.accountType = builder.accountType;
    this.displayName = builder.displayName;
    this.isServiceAccount = builder.isServiceAccount;
    this.isPrivileged = builder.isPrivileged;
    this.isCanEscalatePrivs = builder.isCanEscalatePrivs;
    this.isDisabled = builder.isDisabled;
    this.accountCreated = builder.accountCreated;
    this.accountExpires = builder.accountExpires;
    this.passwordLastChanged = builder.passwordLastChanged;
    this.accountFirstLogin = builder.accountFirstLogin;
    this.accountLastLogin = builder.accountLastLogin;
    this.type = builder.type;
    this.defanged = builder.defanged;
    this.customProperties = builder.customProperties.build();
    this.objectMarkingRefs = builder.objectMarkingRefs.build();
    this.granularMarkings = builder.granularMarkings.build();
    this.hydrated = builder.hydrated;
    this.toJsonString = builder.toJsonString;
    if (builder.extensionsIsSet()) {
      initShim.extensions(builder.extensions.build());
    }
    if (builder.observableObjectKey != null) {
      initShim.observableObjectKey(builder.observableObjectKey);
    }
    this.id = initShim.getId();
    this.extensions = initShim.getExtensions();
    this.observableObjectKey = initShim.getObservableObjectKey();
    this.initShim = null;
  }

  private UserAccount(
      String userId,
      @Nullable String accountLogin,
      @Nullable String accountType,
      @Nullable String displayName,
      @Nullable Boolean isServiceAccount,
      @Nullable Boolean isPrivileged,
      @Nullable Boolean isCanEscalatePrivs,
      @Nullable Boolean isDisabled,
      @Nullable StixInstant accountCreated,
      @Nullable StixInstant accountExpires,
      @Nullable StixInstant passwordLastChanged,
      @Nullable StixInstant accountFirstLogin,
      @Nullable StixInstant accountLastLogin,
      String type,
      ImmutableSet<CyberObservableExtension> extensions,
      String observableObjectKey,
      @Nullable Boolean defanged,
      ImmutableMap<String, Object> customProperties,
      ImmutableSet<MarkingDefinitionDm> objectMarkingRefs,
      ImmutableSet<GranularMarkingDm> granularMarkings,
      boolean hydrated,
      String toJsonString) {
    this.userId = userId;
    this.accountLogin = accountLogin;
    this.accountType = accountType;
    this.displayName = displayName;
    this.isServiceAccount = isServiceAccount;
    this.isPrivileged = isPrivileged;
    this.isCanEscalatePrivs = isCanEscalatePrivs;
    this.isDisabled = isDisabled;
    this.accountCreated = accountCreated;
    this.accountExpires = accountExpires;
    this.passwordLastChanged = passwordLastChanged;
    this.accountFirstLogin = accountFirstLogin;
    this.accountLastLogin = accountLastLogin;
    this.type = type;
    initShim.extensions(extensions);
    initShim.observableObjectKey(observableObjectKey);
    this.defanged = defanged;
    this.customProperties = customProperties;
    this.objectMarkingRefs = objectMarkingRefs;
    this.granularMarkings = granularMarkings;
    this.hydrated = hydrated;
    this.toJsonString = toJsonString;
    this.id = initShim.getId();
    this.extensions = initShim.getExtensions();
    this.observableObjectKey = initShim.getObservableObjectKey();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "UserAccountCoo", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    private byte extensionsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<CyberObservableExtension> extensions;

    ImmutableSet<CyberObservableExtension> getExtensions() {
      if (extensionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (extensionsBuildStage == STAGE_UNINITIALIZED) {
        extensionsBuildStage = STAGE_INITIALIZING;
        this.extensions = ImmutableSet.copyOf(getExtensionsInitialize());
        extensionsBuildStage = STAGE_INITIALIZED;
      }
      return this.extensions;
    }

    void extensions(ImmutableSet<CyberObservableExtension> extensions) {
      this.extensions = extensions;
      extensionsBuildStage = STAGE_INITIALIZED;
    }

    private byte observableObjectKeyBuildStage = STAGE_UNINITIALIZED;
    private String observableObjectKey;

    String getObservableObjectKey() {
      if (observableObjectKeyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (observableObjectKeyBuildStage == STAGE_UNINITIALIZED) {
        observableObjectKeyBuildStage = STAGE_INITIALIZING;
        this.observableObjectKey = Objects.requireNonNull(getObservableObjectKeyInitialize(), "observableObjectKey");
        observableObjectKeyBuildStage = STAGE_INITIALIZED;
      }
      return this.observableObjectKey;
    }

    void observableObjectKey(String observableObjectKey) {
      this.observableObjectKey = observableObjectKey;
      observableObjectKeyBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (extensionsBuildStage == STAGE_INITIALIZING) attributes.add("extensions");
      if (observableObjectKeyBuildStage == STAGE_INITIALIZING) attributes.add("observableObjectKey");
      return "Cannot build UserAccount, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return UserAccountCoo.super.getId();
  }

  private Set<CyberObservableExtension> getExtensionsInitialize() {
    return UserAccountCoo.super.getExtensions();
  }

  private String getObservableObjectKeyInitialize() {
    return UserAccountCoo.super.getObservableObjectKey();
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user_id")
  @JsonPropertyDescription("Specifies the identifier of the account.")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code accountLogin} attribute
   */
  @JsonProperty("account_login")
  @JsonPropertyDescription("Specifies the account login string, used in cases where the user_id property specifies something other than what a user would type when they login.")
  @Override
  public Optional<String> getAccountLogin() {
    return Optional.ofNullable(accountLogin);
  }

  /**
   * @return The value of the {@code accountType} attribute
   */
  @JsonProperty("account_type")
  @JsonPropertyDescription("Specifies the type of the account. This is an open vocabulary and values SHOULD come from the account-type-ov vocabulary.")
  @Override
  public Optional<String> getAccountType() {
    return Optional.ofNullable(accountType);
  }

  /**
   * @return The value of the {@code displayName} attribute
   */
  @JsonProperty("display_name")
  @JsonPropertyDescription("Specifies the display name of the account, to be shown in user interfaces, if applicable.")
  @Override
  public Optional<String> getDisplayName() {
    return Optional.ofNullable(displayName);
  }

  /**
   * @return The value of the {@code isServiceAccount} attribute
   */
  @JsonProperty("is_service_account")
  @JsonPropertyDescription("Indicates that the account is associated with a network service or system process (daemon), not a specific individual.")
  @Override
  public Optional<Boolean> isServiceAccount() {
    return Optional.ofNullable(isServiceAccount);
  }

  /**
   * @return The value of the {@code isPrivileged} attribute
   */
  @JsonProperty("is_privileged")
  @JsonPropertyDescription("Specifies that the account has elevated privileges (i.e., in the case of root on Unix or the Windows Administrator account).")
  @Override
  public Optional<Boolean> isPrivileged() {
    return Optional.ofNullable(isPrivileged);
  }

  /**
   * @return The value of the {@code isCanEscalatePrivs} attribute
   */
  @JsonProperty("can_escalate_privs")
  @JsonPropertyDescription("Specifies that the account has the ability to escalate privileges (i.e., in the case of sudo on Unix or a Windows Domain Admin account).")
  @Override
  public Optional<Boolean> isCanEscalatePrivs() {
    return Optional.ofNullable(isCanEscalatePrivs);
  }

  /**
   * @return The value of the {@code isDisabled} attribute
   */
  @JsonProperty("is_disabled")
  @JsonPropertyDescription("Specifies if the account is disabled.")
  @Override
  public Optional<Boolean> isDisabled() {
    return Optional.ofNullable(isDisabled);
  }

  /**
   * @return The value of the {@code accountCreated} attribute
   */
  @JsonProperty("account_created")
  @JsonPropertyDescription("Specifies when the account was created.")
  @Override
  public Optional<StixInstant> getAccountCreated() {
    return Optional.ofNullable(accountCreated);
  }

  /**
   * @return The value of the {@code accountExpires} attribute
   */
  @JsonProperty("account_expires")
  @JsonPropertyDescription("Specifies the expiration date of the account.")
  @Override
  public Optional<StixInstant> getAccountExpires() {
    return Optional.ofNullable(accountExpires);
  }

  /**
   * @return The value of the {@code passwordLastChanged} attribute
   */
  @JsonProperty("password_last_changed")
  @JsonPropertyDescription("Specifies when the account password was last changed.")
  @Override
  public Optional<StixInstant> getPasswordLastChanged() {
    return Optional.ofNullable(passwordLastChanged);
  }

  /**
   * @return The value of the {@code accountFirstLogin} attribute
   */
  @JsonProperty("account_first_login")
  @JsonPropertyDescription("Specifies when the account was first accessed.")
  @Override
  public Optional<StixInstant> getAccountFirstLogin() {
    return Optional.ofNullable(accountFirstLogin);
  }

  /**
   * @return The value of the {@code accountLastLogin} attribute
   */
  @JsonProperty("account_last_login")
  @JsonPropertyDescription("Specifies when the account was last accessed.")
  @Override
  public Optional<StixInstant> getAccountLastLogin() {
    return Optional.ofNullable(accountLastLogin);
  }

  /**
   * Deterministically generates the ID for this user account based on its user ID.
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Multiple extensions can be added, but only 1 instance of a specific extension can be added.
   */
  @JsonProperty("extensions")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Specifies any extensions of the object, as a dictionary.")
  @JsonSerialize(using = CyberObservableExtensionsFieldSerializer.class)
  @JsonDeserialize(using = CyberObservableExtensionsFieldDeserializer.class)
  @Override
  public ImmutableSet<CyberObservableExtension> getExtensions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExtensions()
        : this.extensions;
  }

  /**
   * Used for generation of Map Keys by {@link ObservedDataSdo#getObjects()}
   * Manually set this value if you want to control key names.  Otherwise UUIDs will be used.
   */
  @JsonProperty(value = "observable_object_key", access = JsonProperty.Access.WRITE_ONLY)
  @Override
  public String getObservableObjectKey() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObservableObjectKey()
        : this.observableObjectKey;
  }

  /**
   * Indicates whether the data contained in the SCO has been defanged.
   * Defanging refers to the process of modifying data to make it safe to handle
   * (e.g., changing an IP address from 192.168.1.1 to 192[.]168[.]1[.]1).
   */
  @JsonProperty("defanged")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Indicates whether the data contained in the SCO has been defanged.")
  @Override
  public Optional<Boolean> getDefanged() {
    return Optional.ofNullable(defanged);
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * @return The value of the {@code objectMarkingRefs} attribute
   */
  @JsonProperty("objectMarkingRefs")
  @Override
  public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
    return objectMarkingRefs;
  }

  /**
   * @return The value of the {@code granularMarkings} attribute
   */
  @JsonProperty("granularMarkings")
  @Override
  public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
    return granularMarkings;
  }

  /**
   * @return The value of the {@code hydrated} attribute
   */
  @JsonProperty("hydrated")
  @Override
  public boolean getHydrated() {
    return hydrated;
  }

  /**
   * @return The value of the {@code toJsonString} attribute
   */
  @JsonProperty("toJsonString")
  @Override
  public String toJsonString() {
    return toJsonString;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserAccountCoo#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final UserAccount withUserId(String value) {
    if (Objects.equals(this.userId, value)) return this;
    return validate(new UserAccount(
        value,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#getAccountLogin() accountLogin} attribute.
   * @param value The value for accountLogin
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withAccountLogin(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "accountLogin");
    if (Objects.equals(this.accountLogin, newValue)) return this;
    return validate(new UserAccount(
        this.userId,
        newValue,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#getAccountLogin() accountLogin} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for accountLogin
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withAccountLogin(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.accountLogin, value)) return this;
    return validate(new UserAccount(
        this.userId,
        value,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#getAccountType() accountType} attribute.
   * @param value The value for accountType
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withAccountType(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "accountType");
    if (Objects.equals(this.accountType, newValue)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        newValue,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#getAccountType() accountType} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for accountType
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withAccountType(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.accountType, value)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        value,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#getDisplayName() displayName} attribute.
   * @param value The value for displayName
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withDisplayName(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "displayName");
    if (Objects.equals(this.displayName, newValue)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        newValue,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#getDisplayName() displayName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for displayName
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withDisplayName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.displayName, value)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        value,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#isServiceAccount() isServiceAccount} attribute.
   * @param value The value for isServiceAccount
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withIsServiceAccount(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isServiceAccount, newValue)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        newValue,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#isServiceAccount() isServiceAccount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isServiceAccount
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withIsServiceAccount(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isServiceAccount, value)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        value,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#isPrivileged() isPrivileged} attribute.
   * @param value The value for isPrivileged
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withIsPrivileged(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isPrivileged, newValue)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        newValue,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#isPrivileged() isPrivileged} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isPrivileged
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withIsPrivileged(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isPrivileged, value)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        value,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#isCanEscalatePrivs() isCanEscalatePrivs} attribute.
   * @param value The value for isCanEscalatePrivs
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withIsCanEscalatePrivs(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isCanEscalatePrivs, newValue)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        newValue,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#isCanEscalatePrivs() isCanEscalatePrivs} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isCanEscalatePrivs
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withIsCanEscalatePrivs(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isCanEscalatePrivs, value)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        value,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#isDisabled() isDisabled} attribute.
   * @param value The value for isDisabled
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withIsDisabled(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isDisabled, newValue)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        newValue,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#isDisabled() isDisabled} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isDisabled
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withIsDisabled(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isDisabled, value)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        value,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#getAccountCreated() accountCreated} attribute.
   * @param value The value for accountCreated
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withAccountCreated(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "accountCreated");
    if (this.accountCreated == newValue) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        newValue,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#getAccountCreated() accountCreated} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for accountCreated
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final UserAccount withAccountCreated(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.accountCreated == value) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        value,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#getAccountExpires() accountExpires} attribute.
   * @param value The value for accountExpires
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withAccountExpires(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "accountExpires");
    if (this.accountExpires == newValue) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        newValue,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#getAccountExpires() accountExpires} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for accountExpires
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final UserAccount withAccountExpires(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.accountExpires == value) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        value,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#getPasswordLastChanged() passwordLastChanged} attribute.
   * @param value The value for passwordLastChanged
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withPasswordLastChanged(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "passwordLastChanged");
    if (this.passwordLastChanged == newValue) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        newValue,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#getPasswordLastChanged() passwordLastChanged} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for passwordLastChanged
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final UserAccount withPasswordLastChanged(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.passwordLastChanged == value) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        value,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#getAccountFirstLogin() accountFirstLogin} attribute.
   * @param value The value for accountFirstLogin
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withAccountFirstLogin(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "accountFirstLogin");
    if (this.accountFirstLogin == newValue) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        newValue,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#getAccountFirstLogin() accountFirstLogin} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for accountFirstLogin
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final UserAccount withAccountFirstLogin(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.accountFirstLogin == value) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        value,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#getAccountLastLogin() accountLastLogin} attribute.
   * @param value The value for accountLastLogin
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withAccountLastLogin(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "accountLastLogin");
    if (this.accountLastLogin == newValue) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        newValue,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#getAccountLastLogin() accountLastLogin} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for accountLastLogin
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final UserAccount withAccountLastLogin(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.accountLastLogin == value) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        value,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserAccountCoo#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final UserAccount withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        value,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserAccountCoo#getExtensions() extensions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withExtensions(CyberObservableExtension... elements) {
    ImmutableSet<CyberObservableExtension> newValue = ImmutableSet.copyOf(elements);
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        newValue,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserAccountCoo#getExtensions() extensions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of extensions elements to set
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withExtensions(Iterable<? extends CyberObservableExtension> elements) {
    if (this.extensions == elements) return this;
    ImmutableSet<CyberObservableExtension> newValue = ImmutableSet.copyOf(elements);
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        newValue,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserAccountCoo#getObservableObjectKey() observableObjectKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for observableObjectKey
   * @return A modified copy of the {@code this} object
   */
  public final UserAccount withObservableObjectKey(String value) {
    String newValue = Objects.requireNonNull(value, "observableObjectKey");
    if (this.observableObjectKey.equals(newValue)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        newValue,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UserAccountCoo#getDefanged() defanged} attribute.
   * @param value The value for defanged
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withDefanged(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.defanged, newValue)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        newValue,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UserAccountCoo#getDefanged() defanged} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for defanged
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withDefanged(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.defanged, value)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        value,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by replacing the {@link UserAccountCoo#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserAccountCoo#getObjectMarkingRefs() objectMarkingRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withObjectMarkingRefs(MarkingDefinitionDm... elements) {
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        newValue,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserAccountCoo#getObjectMarkingRefs() objectMarkingRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectMarkingRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
    if (this.objectMarkingRefs == elements) return this;
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        newValue,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserAccountCoo#getGranularMarkings() granularMarkings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withGranularMarkings(GranularMarkingDm... elements) {
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        newValue,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UserAccountCoo#getGranularMarkings() granularMarkings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of granularMarkings elements to set
   * @return A modified copy of {@code this} object
   */
  public final UserAccount withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
    if (this.granularMarkings == elements) return this;
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        newValue,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserAccountCoo#getHydrated() hydrated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hydrated
   * @return A modified copy of the {@code this} object
   */
  public final UserAccount withHydrated(boolean value) {
    if (this.hydrated == value) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        value,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserAccountCoo#toJsonString() toJsonString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toJsonString (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final UserAccount withToJsonString(String value) {
    if (Objects.equals(this.toJsonString, value)) return this;
    return validate(new UserAccount(
        this.userId,
        this.accountLogin,
        this.accountType,
        this.displayName,
        this.isServiceAccount,
        this.isPrivileged,
        this.isCanEscalatePrivs,
        this.isDisabled,
        this.accountCreated,
        this.accountExpires,
        this.passwordLastChanged,
        this.accountFirstLogin,
        this.accountLastLogin,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        value));
  }

  /**
   * This instance is equal to all instances of {@code UserAccount} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UserAccount
        && equalTo((UserAccount) another);
  }

  private boolean equalTo(UserAccount another) {
    return Objects.equals(userId, another.userId)
        && Objects.equals(accountLogin, another.accountLogin)
        && Objects.equals(accountType, another.accountType)
        && Objects.equals(displayName, another.displayName)
        && Objects.equals(isServiceAccount, another.isServiceAccount)
        && Objects.equals(isPrivileged, another.isPrivileged)
        && Objects.equals(isCanEscalatePrivs, another.isCanEscalatePrivs)
        && Objects.equals(isDisabled, another.isDisabled)
        && Objects.equals(accountCreated, another.accountCreated)
        && Objects.equals(accountExpires, another.accountExpires)
        && Objects.equals(passwordLastChanged, another.passwordLastChanged)
        && Objects.equals(accountFirstLogin, another.accountFirstLogin)
        && Objects.equals(accountLastLogin, another.accountLastLogin)
        && id.equals(another.id)
        && Objects.equals(type, another.type)
        && extensions.equals(another.extensions)
        && observableObjectKey.equals(another.observableObjectKey)
        && Objects.equals(defanged, another.defanged)
        && customProperties.equals(another.customProperties)
        && objectMarkingRefs.equals(another.objectMarkingRefs)
        && granularMarkings.equals(another.granularMarkings)
        && hydrated == another.hydrated
        && Objects.equals(toJsonString, another.toJsonString);
  }

  /**
   * Computes a hash code from attributes: {@code userId}, {@code accountLogin}, {@code accountType}, {@code displayName}, {@code isServiceAccount}, {@code isPrivileged}, {@code isCanEscalatePrivs}, {@code isDisabled}, {@code accountCreated}, {@code accountExpires}, {@code passwordLastChanged}, {@code accountFirstLogin}, {@code accountLastLogin}, {@code id}, {@code type}, {@code extensions}, {@code observableObjectKey}, {@code defanged}, {@code customProperties}, {@code objectMarkingRefs}, {@code granularMarkings}, {@code hydrated}, {@code toJsonString}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(userId);
    h += (h << 5) + Objects.hashCode(accountLogin);
    h += (h << 5) + Objects.hashCode(accountType);
    h += (h << 5) + Objects.hashCode(displayName);
    h += (h << 5) + Objects.hashCode(isServiceAccount);
    h += (h << 5) + Objects.hashCode(isPrivileged);
    h += (h << 5) + Objects.hashCode(isCanEscalatePrivs);
    h += (h << 5) + Objects.hashCode(isDisabled);
    h += (h << 5) + Objects.hashCode(accountCreated);
    h += (h << 5) + Objects.hashCode(accountExpires);
    h += (h << 5) + Objects.hashCode(passwordLastChanged);
    h += (h << 5) + Objects.hashCode(accountFirstLogin);
    h += (h << 5) + Objects.hashCode(accountLastLogin);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + extensions.hashCode();
    h += (h << 5) + observableObjectKey.hashCode();
    h += (h << 5) + Objects.hashCode(defanged);
    h += (h << 5) + customProperties.hashCode();
    h += (h << 5) + objectMarkingRefs.hashCode();
    h += (h << 5) + granularMarkings.hashCode();
    h += (h << 5) + Booleans.hashCode(hydrated);
    h += (h << 5) + Objects.hashCode(toJsonString);
    return h;
  }

  /**
   * Prints the immutable value {@code UserAccount} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UserAccount")
        .omitNullValues()
        .add("userId", userId)
        .add("accountLogin", accountLogin)
        .add("accountType", accountType)
        .add("displayName", displayName)
        .add("isServiceAccount", isServiceAccount)
        .add("isPrivileged", isPrivileged)
        .add("isCanEscalatePrivs", isCanEscalatePrivs)
        .add("isDisabled", isDisabled)
        .add("accountCreated", accountCreated)
        .add("accountExpires", accountExpires)
        .add("passwordLastChanged", passwordLastChanged)
        .add("accountFirstLogin", accountFirstLogin)
        .add("accountLastLogin", accountLastLogin)
        .add("id", id)
        .add("type", type)
        .add("extensions", extensions)
        .add("observableObjectKey", observableObjectKey)
        .add("defanged", defanged)
        .add("customProperties", customProperties)
        .add("objectMarkingRefs", objectMarkingRefs)
        .add("granularMarkings", granularMarkings)
        .add("hydrated", hydrated)
        .add("toJsonString", toJsonString)
        .toString();
  }


  private static UserAccount validate(UserAccount instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link UserAccountCoo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UserAccount instance
   */
  public static UserAccount copyOf(UserAccountCoo instance) {
    if (instance instanceof UserAccount) {
      return (UserAccount) instance;
    }
    return UserAccount.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link UserAccount UserAccount}.
   * @return A new UserAccount builder
   */
  public static UserAccount.Builder builder() {
    return new UserAccount.Builder();
  }

  /**
   * Builds instances of type {@link UserAccount UserAccount}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UserAccountCoo", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonTypeName("user-account")
  @JsonPropertyOrder({"type", "extensions", "user_id", "account_login", "account_type", "display_name", "is_service_account", "is_privileged", "can_escalate_privs", "is_disabled", "account_created", "account_expires", "password_last_changed", "account_first_login", "account_last_login"})
  public static final class Builder {
    private static final long OPT_BIT_EXTENSIONS = 0x1L;
    private long optBits;

    private @Nullable String userId;
    private @Nullable String accountLogin;
    private @Nullable String accountType;
    private @Nullable String displayName;
    private @Nullable Boolean isServiceAccount;
    private @Nullable Boolean isPrivileged;
    private @Nullable Boolean isCanEscalatePrivs;
    private @Nullable Boolean isDisabled;
    private @Nullable StixInstant accountCreated;
    private @Nullable StixInstant accountExpires;
    private @Nullable StixInstant passwordLastChanged;
    private @Nullable StixInstant accountFirstLogin;
    private @Nullable StixInstant accountLastLogin;
    private @Nullable String type;
    private ImmutableSet.Builder<CyberObservableExtension> extensions = ImmutableSet.builder();
    private @Nullable String observableObjectKey;
    private @Nullable Boolean defanged;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
    private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
    private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
    private boolean hydrated;
    private @Nullable String toJsonString;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleableObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleableObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.objects.UserAccountCoo} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UserAccountCoo instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.CyberObservableObjectCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableObjectCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BundleableObject) {
        BundleableObject instance = (BundleableObject) object;
        addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        hydrated(instance.getHydrated());
        addAllGranularMarkings(instance.getGranularMarkings());
        String toJsonStringValue = instance.toJsonString();
        if (toJsonStringValue != null) {
          toJsonString(toJsonStringValue);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof UserAccountCoo) {
        UserAccountCoo instance = (UserAccountCoo) object;
        Optional<StixInstant> accountCreatedOptional = instance.getAccountCreated();
        if (accountCreatedOptional.isPresent()) {
          accountCreated(accountCreatedOptional);
        }
        Optional<String> accountLoginOptional = instance.getAccountLogin();
        if (accountLoginOptional.isPresent()) {
          accountLogin(accountLoginOptional);
        }
        Optional<String> displayNameOptional = instance.getDisplayName();
        if (displayNameOptional.isPresent()) {
          displayName(displayNameOptional);
        }
        Optional<StixInstant> accountExpiresOptional = instance.getAccountExpires();
        if (accountExpiresOptional.isPresent()) {
          accountExpires(accountExpiresOptional);
        }
        Optional<String> accountTypeOptional = instance.getAccountType();
        if (accountTypeOptional.isPresent()) {
          accountType(accountTypeOptional);
        }
        String userIdValue = instance.getUserId();
        if (userIdValue != null) {
          userId(userIdValue);
        }
        Optional<Boolean> isCanEscalatePrivsOptional = instance.isCanEscalatePrivs();
        if (isCanEscalatePrivsOptional.isPresent()) {
          isCanEscalatePrivs(isCanEscalatePrivsOptional);
        }
        Optional<Boolean> isPrivilegedOptional = instance.isPrivileged();
        if (isPrivilegedOptional.isPresent()) {
          isPrivileged(isPrivilegedOptional);
        }
        Optional<StixInstant> passwordLastChangedOptional = instance.getPasswordLastChanged();
        if (passwordLastChangedOptional.isPresent()) {
          passwordLastChanged(passwordLastChangedOptional);
        }
        Optional<StixInstant> accountLastLoginOptional = instance.getAccountLastLogin();
        if (accountLastLoginOptional.isPresent()) {
          accountLastLogin(accountLastLoginOptional);
        }
        Optional<StixInstant> accountFirstLoginOptional = instance.getAccountFirstLogin();
        if (accountFirstLoginOptional.isPresent()) {
          accountFirstLogin(accountFirstLoginOptional);
        }
        Optional<Boolean> isDisabledOptional = instance.isDisabled();
        if (isDisabledOptional.isPresent()) {
          isDisabled(isDisabledOptional);
        }
        Optional<Boolean> isServiceAccountOptional = instance.isServiceAccount();
        if (isServiceAccountOptional.isPresent()) {
          isServiceAccount(isServiceAccountOptional);
        }
      }
      if (object instanceof CyberObservableObjectCommonProperties) {
        CyberObservableObjectCommonProperties instance = (CyberObservableObjectCommonProperties) object;
        addAllExtensions(instance.getExtensions());
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        observableObjectKey(instance.getObservableObjectKey());
        Optional<Boolean> defangedOptional = instance.getDefanged();
        if (defangedOptional.isPresent()) {
          defanged(defangedOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link UserAccountCoo#getUserId() userId} attribute.
     * @param userId The value for userId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("user_id")
    @JsonPropertyDescription("Specifies the identifier of the account.")
    public final Builder userId(String userId) {
      this.userId = userId;
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getAccountLogin() accountLogin} to accountLogin.
     * @param accountLogin The value for accountLogin
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder accountLogin(String accountLogin) {
      this.accountLogin = Objects.requireNonNull(accountLogin, "accountLogin");
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getAccountLogin() accountLogin} to accountLogin.
     * @param accountLogin The value for accountLogin
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("account_login")
    @JsonPropertyDescription("Specifies the account login string, used in cases where the user_id property specifies something other than what a user would type when they login.")
    public final Builder accountLogin(Optional<String> accountLogin) {
      this.accountLogin = accountLogin.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getAccountType() accountType} to accountType.
     * @param accountType The value for accountType
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder accountType(String accountType) {
      this.accountType = Objects.requireNonNull(accountType, "accountType");
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getAccountType() accountType} to accountType.
     * @param accountType The value for accountType
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("account_type")
    @JsonPropertyDescription("Specifies the type of the account. This is an open vocabulary and values SHOULD come from the account-type-ov vocabulary.")
    public final Builder accountType(Optional<String> accountType) {
      this.accountType = accountType.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getDisplayName() displayName} to displayName.
     * @param displayName The value for displayName
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder displayName(String displayName) {
      this.displayName = Objects.requireNonNull(displayName, "displayName");
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getDisplayName() displayName} to displayName.
     * @param displayName The value for displayName
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("display_name")
    @JsonPropertyDescription("Specifies the display name of the account, to be shown in user interfaces, if applicable.")
    public final Builder displayName(Optional<String> displayName) {
      this.displayName = displayName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#isServiceAccount() isServiceAccount} to isServiceAccount.
     * @param isServiceAccount The value for isServiceAccount
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isServiceAccount(boolean isServiceAccount) {
      this.isServiceAccount = isServiceAccount;
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#isServiceAccount() isServiceAccount} to isServiceAccount.
     * @param isServiceAccount The value for isServiceAccount
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("is_service_account")
    @JsonPropertyDescription("Indicates that the account is associated with a network service or system process (daemon), not a specific individual.")
    public final Builder isServiceAccount(Optional<Boolean> isServiceAccount) {
      this.isServiceAccount = isServiceAccount.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#isPrivileged() isPrivileged} to isPrivileged.
     * @param isPrivileged The value for isPrivileged
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isPrivileged(boolean isPrivileged) {
      this.isPrivileged = isPrivileged;
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#isPrivileged() isPrivileged} to isPrivileged.
     * @param isPrivileged The value for isPrivileged
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("is_privileged")
    @JsonPropertyDescription("Specifies that the account has elevated privileges (i.e., in the case of root on Unix or the Windows Administrator account).")
    public final Builder isPrivileged(Optional<Boolean> isPrivileged) {
      this.isPrivileged = isPrivileged.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#isCanEscalatePrivs() isCanEscalatePrivs} to isCanEscalatePrivs.
     * @param isCanEscalatePrivs The value for isCanEscalatePrivs
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isCanEscalatePrivs(boolean isCanEscalatePrivs) {
      this.isCanEscalatePrivs = isCanEscalatePrivs;
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#isCanEscalatePrivs() isCanEscalatePrivs} to isCanEscalatePrivs.
     * @param isCanEscalatePrivs The value for isCanEscalatePrivs
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("can_escalate_privs")
    @JsonPropertyDescription("Specifies that the account has the ability to escalate privileges (i.e., in the case of sudo on Unix or a Windows Domain Admin account).")
    public final Builder isCanEscalatePrivs(Optional<Boolean> isCanEscalatePrivs) {
      this.isCanEscalatePrivs = isCanEscalatePrivs.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#isDisabled() isDisabled} to isDisabled.
     * @param isDisabled The value for isDisabled
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isDisabled(boolean isDisabled) {
      this.isDisabled = isDisabled;
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#isDisabled() isDisabled} to isDisabled.
     * @param isDisabled The value for isDisabled
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("is_disabled")
    @JsonPropertyDescription("Specifies if the account is disabled.")
    public final Builder isDisabled(Optional<Boolean> isDisabled) {
      this.isDisabled = isDisabled.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getAccountCreated() accountCreated} to accountCreated.
     * @param accountCreated The value for accountCreated
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder accountCreated(StixInstant accountCreated) {
      this.accountCreated = Objects.requireNonNull(accountCreated, "accountCreated");
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getAccountCreated() accountCreated} to accountCreated.
     * @param accountCreated The value for accountCreated
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("account_created")
    @JsonPropertyDescription("Specifies when the account was created.")
    public final Builder accountCreated(Optional<? extends StixInstant> accountCreated) {
      this.accountCreated = accountCreated.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getAccountExpires() accountExpires} to accountExpires.
     * @param accountExpires The value for accountExpires
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder accountExpires(StixInstant accountExpires) {
      this.accountExpires = Objects.requireNonNull(accountExpires, "accountExpires");
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getAccountExpires() accountExpires} to accountExpires.
     * @param accountExpires The value for accountExpires
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("account_expires")
    @JsonPropertyDescription("Specifies the expiration date of the account.")
    public final Builder accountExpires(Optional<? extends StixInstant> accountExpires) {
      this.accountExpires = accountExpires.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getPasswordLastChanged() passwordLastChanged} to passwordLastChanged.
     * @param passwordLastChanged The value for passwordLastChanged
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder passwordLastChanged(StixInstant passwordLastChanged) {
      this.passwordLastChanged = Objects.requireNonNull(passwordLastChanged, "passwordLastChanged");
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getPasswordLastChanged() passwordLastChanged} to passwordLastChanged.
     * @param passwordLastChanged The value for passwordLastChanged
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("password_last_changed")
    @JsonPropertyDescription("Specifies when the account password was last changed.")
    public final Builder passwordLastChanged(Optional<? extends StixInstant> passwordLastChanged) {
      this.passwordLastChanged = passwordLastChanged.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getAccountFirstLogin() accountFirstLogin} to accountFirstLogin.
     * @param accountFirstLogin The value for accountFirstLogin
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder accountFirstLogin(StixInstant accountFirstLogin) {
      this.accountFirstLogin = Objects.requireNonNull(accountFirstLogin, "accountFirstLogin");
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getAccountFirstLogin() accountFirstLogin} to accountFirstLogin.
     * @param accountFirstLogin The value for accountFirstLogin
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("account_first_login")
    @JsonPropertyDescription("Specifies when the account was first accessed.")
    public final Builder accountFirstLogin(Optional<? extends StixInstant> accountFirstLogin) {
      this.accountFirstLogin = accountFirstLogin.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getAccountLastLogin() accountLastLogin} to accountLastLogin.
     * @param accountLastLogin The value for accountLastLogin
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder accountLastLogin(StixInstant accountLastLogin) {
      this.accountLastLogin = Objects.requireNonNull(accountLastLogin, "accountLastLogin");
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getAccountLastLogin() accountLastLogin} to accountLastLogin.
     * @param accountLastLogin The value for accountLastLogin
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("account_last_login")
    @JsonPropertyDescription("Specifies when the account was last accessed.")
    public final Builder accountLastLogin(Optional<? extends StixInstant> accountLastLogin) {
      this.accountLastLogin = accountLastLogin.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link UserAccountCoo#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Adds one element to {@link UserAccountCoo#getExtensions() extensions} set.
     * @param element A extensions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtension(@Nullable CyberObservableExtension element) {
      this.extensions.add(element);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }

    /**
     * Adds elements to {@link UserAccountCoo#getExtensions() extensions} set.
     * @param elements An array of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtensions(CyberObservableExtension... elements) {
      this.extensions.add(elements);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UserAccountCoo#getExtensions() extensions} set.
     * @param elements An iterable of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("extensions")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Specifies any extensions of the object, as a dictionary.")
    @JsonSerialize(using = CyberObservableExtensionsFieldSerializer.class)
    @JsonDeserialize(using = CyberObservableExtensionsFieldDeserializer.class)
    public final Builder extensions(Iterable<? extends CyberObservableExtension> elements) {
      this.extensions = ImmutableSet.builder();
      return addAllExtensions(elements);
    }

    /**
     * Adds elements to {@link UserAccountCoo#getExtensions() extensions} set.
     * @param elements An iterable of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExtensions(Iterable<? extends CyberObservableExtension> elements) {
      this.extensions.addAll(elements);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }

    /**
     * Initializes the value for the {@link UserAccountCoo#getObservableObjectKey() observableObjectKey} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link UserAccountCoo#getObservableObjectKey() observableObjectKey}.</em>
     * @param observableObjectKey The value for observableObjectKey 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "observable_object_key", access = JsonProperty.Access.WRITE_ONLY)
    public final Builder observableObjectKey(String observableObjectKey) {
      this.observableObjectKey = Objects.requireNonNull(observableObjectKey, "observableObjectKey");
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getDefanged() defanged} to defanged.
     * @param defanged The value for defanged
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defanged(boolean defanged) {
      this.defanged = defanged;
      return this;
    }

    /**
     * Initializes the optional value {@link UserAccountCoo#getDefanged() defanged} to defanged.
     * @param defanged The value for defanged
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("defanged")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Indicates whether the data contained in the SCO has been defanged.")
    public final Builder defanged(Optional<Boolean> defanged) {
      this.defanged = defanged.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link UserAccountCoo#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UserAccountCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UserAccountCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UserAccountCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link UserAccountCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param element A objectMarkingRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
      this.objectMarkingRefs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UserAccountCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An array of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRefs(MarkingDefinitionDm... elements) {
      this.objectMarkingRefs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UserAccountCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("objectMarkingRefs")
    public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs = ImmutableSet.builder();
      return addAllObjectMarkingRefs(elements);
    }

    /**
     * Adds elements to {@link UserAccountCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link UserAccountCoo#getGranularMarkings() granularMarkings} set.
     * @param element A granularMarkings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
      this.granularMarkings.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UserAccountCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An array of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarkings(GranularMarkingDm... elements) {
      this.granularMarkings.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UserAccountCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("granularMarkings")
    public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings = ImmutableSet.builder();
      return addAllGranularMarkings(elements);
    }

    /**
     * Adds elements to {@link UserAccountCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link UserAccountCoo#getHydrated() hydrated} attribute.
     * @param hydrated The value for hydrated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hydrated")
    public final Builder hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      return this;
    }

    /**
     * Initializes the value for the {@link UserAccountCoo#toJsonString() toJsonString} attribute.
     * @param toJsonString The value for toJsonString (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("toJsonString")
    public final Builder toJsonString(String toJsonString) {
      this.toJsonString = toJsonString;
      return this;
    }

    /**
     * Builds a new {@link UserAccount UserAccount}.
     * @return An immutable instance of UserAccount
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UserAccount build() {
      return UserAccount.validate(new UserAccount(this));
    }

    private boolean extensionsIsSet() {
      return (optBits & OPT_BIT_EXTENSIONS) != 0;
    }
  }
}
