package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObjectCommonProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldDeserializer;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldSerializer;
import security.whisper.javastix.coo.types.X509v3ExtensionsObj;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;

/**
 * x509-certificate
 * <p>
 * The X509 Certificate Object represents the properties of an X.509 certificate.
 */
@Generated(from = "X509CertificateCoo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("x509-certificate")
public final class X509Certificate implements X509CertificateCoo {
  private final @Nullable Boolean isSelfSigned;
  private final ImmutableMap<String, String> hashes;
  private final @Nullable String version;
  private final @Nullable String serialNumber;
  private final @Nullable String signatureAlgorithm;
  private final @Nullable String issuer;
  private final @Nullable StixInstant validityNotBefore;
  private final @Nullable StixInstant validityNotAfter;
  private final @Nullable String subject;
  private final @Nullable String subjectPublicKeyAlgorithm;
  private final @Nullable String subjectPublicKeyModulus;
  private final @Nullable Long subjectPublicKeyExponent;
  private final @Nullable X509v3ExtensionsObj x509V3Extensions;
  private final String id;
  private final String type;
  private final ImmutableSet<CyberObservableExtension> extensions;
  private final String observableObjectKey;
  private final @Nullable Boolean defanged;
  private final ImmutableMap<String, Object> customProperties;
  private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
  private final ImmutableSet<GranularMarkingDm> granularMarkings;
  private final boolean hydrated;
  private final String toJsonString;

  private X509Certificate(X509Certificate.Builder builder) {
    this.isSelfSigned = builder.isSelfSigned;
    this.hashes = builder.hashes.build();
    this.version = builder.version;
    this.serialNumber = builder.serialNumber;
    this.signatureAlgorithm = builder.signatureAlgorithm;
    this.issuer = builder.issuer;
    this.validityNotBefore = builder.validityNotBefore;
    this.validityNotAfter = builder.validityNotAfter;
    this.subject = builder.subject;
    this.subjectPublicKeyAlgorithm = builder.subjectPublicKeyAlgorithm;
    this.subjectPublicKeyModulus = builder.subjectPublicKeyModulus;
    this.subjectPublicKeyExponent = builder.subjectPublicKeyExponent;
    this.x509V3Extensions = builder.x509V3Extensions;
    this.type = builder.type;
    this.defanged = builder.defanged;
    this.customProperties = builder.customProperties.build();
    this.objectMarkingRefs = builder.objectMarkingRefs.build();
    this.granularMarkings = builder.granularMarkings.build();
    this.hydrated = builder.hydrated;
    this.toJsonString = builder.toJsonString;
    if (builder.extensionsIsSet()) {
      initShim.extensions(builder.extensions.build());
    }
    if (builder.observableObjectKey != null) {
      initShim.observableObjectKey(builder.observableObjectKey);
    }
    this.id = initShim.getId();
    this.extensions = initShim.getExtensions();
    this.observableObjectKey = initShim.getObservableObjectKey();
    this.initShim = null;
  }

  private X509Certificate(
      @Nullable Boolean isSelfSigned,
      ImmutableMap<String, String> hashes,
      @Nullable String version,
      @Nullable String serialNumber,
      @Nullable String signatureAlgorithm,
      @Nullable String issuer,
      @Nullable StixInstant validityNotBefore,
      @Nullable StixInstant validityNotAfter,
      @Nullable String subject,
      @Nullable String subjectPublicKeyAlgorithm,
      @Nullable String subjectPublicKeyModulus,
      @Nullable Long subjectPublicKeyExponent,
      @Nullable X509v3ExtensionsObj x509V3Extensions,
      String type,
      ImmutableSet<CyberObservableExtension> extensions,
      String observableObjectKey,
      @Nullable Boolean defanged,
      ImmutableMap<String, Object> customProperties,
      ImmutableSet<MarkingDefinitionDm> objectMarkingRefs,
      ImmutableSet<GranularMarkingDm> granularMarkings,
      boolean hydrated,
      String toJsonString) {
    this.isSelfSigned = isSelfSigned;
    this.hashes = hashes;
    this.version = version;
    this.serialNumber = serialNumber;
    this.signatureAlgorithm = signatureAlgorithm;
    this.issuer = issuer;
    this.validityNotBefore = validityNotBefore;
    this.validityNotAfter = validityNotAfter;
    this.subject = subject;
    this.subjectPublicKeyAlgorithm = subjectPublicKeyAlgorithm;
    this.subjectPublicKeyModulus = subjectPublicKeyModulus;
    this.subjectPublicKeyExponent = subjectPublicKeyExponent;
    this.x509V3Extensions = x509V3Extensions;
    this.type = type;
    initShim.extensions(extensions);
    initShim.observableObjectKey(observableObjectKey);
    this.defanged = defanged;
    this.customProperties = customProperties;
    this.objectMarkingRefs = objectMarkingRefs;
    this.granularMarkings = granularMarkings;
    this.hydrated = hydrated;
    this.toJsonString = toJsonString;
    this.id = initShim.getId();
    this.extensions = initShim.getExtensions();
    this.observableObjectKey = initShim.getObservableObjectKey();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "X509CertificateCoo", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    private byte extensionsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<CyberObservableExtension> extensions;

    ImmutableSet<CyberObservableExtension> getExtensions() {
      if (extensionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (extensionsBuildStage == STAGE_UNINITIALIZED) {
        extensionsBuildStage = STAGE_INITIALIZING;
        this.extensions = ImmutableSet.copyOf(getExtensionsInitialize());
        extensionsBuildStage = STAGE_INITIALIZED;
      }
      return this.extensions;
    }

    void extensions(ImmutableSet<CyberObservableExtension> extensions) {
      this.extensions = extensions;
      extensionsBuildStage = STAGE_INITIALIZED;
    }

    private byte observableObjectKeyBuildStage = STAGE_UNINITIALIZED;
    private String observableObjectKey;

    String getObservableObjectKey() {
      if (observableObjectKeyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (observableObjectKeyBuildStage == STAGE_UNINITIALIZED) {
        observableObjectKeyBuildStage = STAGE_INITIALIZING;
        this.observableObjectKey = Objects.requireNonNull(getObservableObjectKeyInitialize(), "observableObjectKey");
        observableObjectKeyBuildStage = STAGE_INITIALIZED;
      }
      return this.observableObjectKey;
    }

    void observableObjectKey(String observableObjectKey) {
      this.observableObjectKey = observableObjectKey;
      observableObjectKeyBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (extensionsBuildStage == STAGE_INITIALIZING) attributes.add("extensions");
      if (observableObjectKeyBuildStage == STAGE_INITIALIZING) attributes.add("observableObjectKey");
      return "Cannot build X509Certificate, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return X509CertificateCoo.super.getId();
  }

  private Set<CyberObservableExtension> getExtensionsInitialize() {
    return X509CertificateCoo.super.getExtensions();
  }

  private String getObservableObjectKeyInitialize() {
    return X509CertificateCoo.super.getObservableObjectKey();
  }

  /**
   * @return The value of the {@code isSelfSigned} attribute
   */
  @JsonProperty("is_self_signed")
  @JsonPropertyDescription("Specifies whether the certificate is self-signed, i.e., whether it is signed by the same entity whose identity it certifies.")
  @Override
  public Optional<Boolean> isSelfSigned() {
    return Optional.ofNullable(isSelfSigned);
  }

  /**
   * @return The value of the {@code hashes} attribute
   */
  @JsonProperty("hashes")
  @JsonPropertyDescription("Specifies any hashes that were calculated for the entire contents of the certificate.")
  @Override
  public ImmutableMap<String, String> getHashes() {
    return hashes;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @JsonPropertyDescription("Specifies the version of the encoded certificate.")
  @Override
  public Optional<String> getVersion() {
    return Optional.ofNullable(version);
  }

  /**
   * @return The value of the {@code serialNumber} attribute
   */
  @JsonProperty("serial_number")
  @JsonPropertyDescription("Specifies the unique identifier for the certificate, as issued by a specific Certificate Authority.")
  @Override
  public Optional<String> getSerialNumber() {
    return Optional.ofNullable(serialNumber);
  }

  /**
   * @return The value of the {@code signatureAlgorithm} attribute
   */
  @JsonProperty("signature_algorithm")
  @JsonPropertyDescription("Specifies the name of the algorithm used to sign the certificate.")
  @Override
  public Optional<String> getSignatureAlgorithm() {
    return Optional.ofNullable(signatureAlgorithm);
  }

  /**
   * @return The value of the {@code issuer} attribute
   */
  @JsonProperty("issuer")
  @JsonPropertyDescription("Specifies the name of the Certificate Authority that issued the certificate.")
  @Override
  public Optional<String> getIssuer() {
    return Optional.ofNullable(issuer);
  }

  /**
   * @return The value of the {@code validityNotBefore} attribute
   */
  @JsonProperty("validity_not_before")
  @JsonPropertyDescription("Specifies the date on which the certificate validity period begins.")
  @Override
  public Optional<StixInstant> getValidityNotBefore() {
    return Optional.ofNullable(validityNotBefore);
  }

  /**
   * @return The value of the {@code validityNotAfter} attribute
   */
  @JsonProperty("validity_not_after")
  @JsonPropertyDescription("Specifies the date on which the certificate validity period ends.")
  @Override
  public Optional<StixInstant> getValidityNotAfter() {
    return Optional.ofNullable(validityNotAfter);
  }

  /**
   * @return The value of the {@code subject} attribute
   */
  @JsonProperty("subject")
  @JsonPropertyDescription("Specifies the name of the entity associated with the public key stored in the subject public key field of the certificate.")
  @Override
  public Optional<String> getSubject() {
    return Optional.ofNullable(subject);
  }

  /**
   * @return The value of the {@code subjectPublicKeyAlgorithm} attribute
   */
  @JsonProperty("subject_public_key_algorithm")
  @JsonPropertyDescription("Specifies the name of the algorithm with which to encrypt data being sent to the subject.")
  @Override
  public Optional<String> getSubjectPublicKeyAlgorithm() {
    return Optional.ofNullable(subjectPublicKeyAlgorithm);
  }

  /**
   * @return The value of the {@code subjectPublicKeyModulus} attribute
   */
  @JsonProperty("subject_public_key_modulus")
  @JsonPropertyDescription("Specifies the modulus portion of the subject\u2019s public RSA key.")
  @Override
  public Optional<String> getSubjectPublicKeyModulus() {
    return Optional.ofNullable(subjectPublicKeyModulus);
  }

  /**
   * @return The value of the {@code subjectPublicKeyExponent} attribute
   */
  @JsonProperty("subject_public_key_exponent")
  @JsonPropertyDescription("Specifies the exponent portion of the subject\u2019s public RSA key, as an integer.")
  @Override
  public Optional<Long> getSubjectPublicKeyExponent() {
    return Optional.ofNullable(subjectPublicKeyExponent);
  }

  /**
   * @return The value of the {@code x509V3Extensions} attribute
   */
  @JsonProperty("x509_v3_extensions")
  @JsonPropertyDescription("Specifies any standard X.509 v3 extensions that may be used in the certificate.")
  @Override
  public Optional<X509v3ExtensionsObj> getX509V3Extensions() {
    return Optional.ofNullable(x509V3Extensions);
  }

  /**
   * Deterministically generates the ID for this X.509 certificate based on its serial number, hashes, or subject.
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * Multiple extensions can be added, but only 1 instance of a specific extension can be added.
   */
  @JsonProperty("extensions")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Specifies any extensions of the object, as a dictionary.")
  @JsonSerialize(using = CyberObservableExtensionsFieldSerializer.class)
  @JsonDeserialize(using = CyberObservableExtensionsFieldDeserializer.class)
  @Override
  public ImmutableSet<CyberObservableExtension> getExtensions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExtensions()
        : this.extensions;
  }

  /**
   * Used for generation of Map Keys by {@link ObservedDataSdo#getObjects()}
   * Manually set this value if you want to control key names.  Otherwise UUIDs will be used.
   */
  @JsonProperty(value = "observable_object_key", access = JsonProperty.Access.WRITE_ONLY)
  @Override
  public String getObservableObjectKey() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObservableObjectKey()
        : this.observableObjectKey;
  }

  /**
   * Indicates whether the data contained in the SCO has been defanged.
   * Defanging refers to the process of modifying data to make it safe to handle
   * (e.g., changing an IP address from 192.168.1.1 to 192[.]168[.]1[.]1).
   */
  @JsonProperty("defanged")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Indicates whether the data contained in the SCO has been defanged.")
  @Override
  public Optional<Boolean> getDefanged() {
    return Optional.ofNullable(defanged);
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * @return The value of the {@code objectMarkingRefs} attribute
   */
  @JsonProperty("objectMarkingRefs")
  @Override
  public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
    return objectMarkingRefs;
  }

  /**
   * @return The value of the {@code granularMarkings} attribute
   */
  @JsonProperty("granularMarkings")
  @Override
  public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
    return granularMarkings;
  }

  /**
   * @return The value of the {@code hydrated} attribute
   */
  @JsonProperty("hydrated")
  @Override
  public boolean getHydrated() {
    return hydrated;
  }

  /**
   * @return The value of the {@code toJsonString} attribute
   */
  @JsonProperty("toJsonString")
  @Override
  public String toJsonString() {
    return toJsonString;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#isSelfSigned() isSelfSigned} attribute.
   * @param value The value for isSelfSigned
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withIsSelfSigned(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isSelfSigned, newValue)) return this;
    return validate(new X509Certificate(
        newValue,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#isSelfSigned() isSelfSigned} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isSelfSigned
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withIsSelfSigned(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isSelfSigned, value)) return this;
    return validate(new X509Certificate(
        value,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by replacing the {@link X509CertificateCoo#getHashes() hashes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the hashes map
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withHashes(Map<String, ? extends String> entries) {
    if (this.hashes == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return validate(new X509Certificate(
        this.isSelfSigned,
        newValue,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#getVersion() version} attribute.
   * @param value The value for version
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withVersion(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "version");
    if (Objects.equals(this.version, newValue)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        newValue,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#getVersion() version} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for version
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withVersion(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.version, value)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        value,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#getSerialNumber() serialNumber} attribute.
   * @param value The value for serialNumber
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withSerialNumber(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "serialNumber");
    if (Objects.equals(this.serialNumber, newValue)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        newValue,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#getSerialNumber() serialNumber} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serialNumber
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withSerialNumber(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.serialNumber, value)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        value,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#getSignatureAlgorithm() signatureAlgorithm} attribute.
   * @param value The value for signatureAlgorithm
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withSignatureAlgorithm(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "signatureAlgorithm");
    if (Objects.equals(this.signatureAlgorithm, newValue)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        newValue,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#getSignatureAlgorithm() signatureAlgorithm} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for signatureAlgorithm
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withSignatureAlgorithm(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.signatureAlgorithm, value)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        value,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#getIssuer() issuer} attribute.
   * @param value The value for issuer
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withIssuer(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "issuer");
    if (Objects.equals(this.issuer, newValue)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        newValue,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#getIssuer() issuer} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for issuer
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withIssuer(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.issuer, value)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        value,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#getValidityNotBefore() validityNotBefore} attribute.
   * @param value The value for validityNotBefore
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withValidityNotBefore(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "validityNotBefore");
    if (this.validityNotBefore == newValue) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        newValue,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#getValidityNotBefore() validityNotBefore} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for validityNotBefore
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final X509Certificate withValidityNotBefore(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.validityNotBefore == value) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        value,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#getValidityNotAfter() validityNotAfter} attribute.
   * @param value The value for validityNotAfter
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withValidityNotAfter(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "validityNotAfter");
    if (this.validityNotAfter == newValue) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        newValue,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#getValidityNotAfter() validityNotAfter} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for validityNotAfter
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final X509Certificate withValidityNotAfter(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.validityNotAfter == value) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        value,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#getSubject() subject} attribute.
   * @param value The value for subject
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withSubject(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "subject");
    if (Objects.equals(this.subject, newValue)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        newValue,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#getSubject() subject} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subject
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withSubject(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.subject, value)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        value,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#getSubjectPublicKeyAlgorithm() subjectPublicKeyAlgorithm} attribute.
   * @param value The value for subjectPublicKeyAlgorithm
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withSubjectPublicKeyAlgorithm(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "subjectPublicKeyAlgorithm");
    if (Objects.equals(this.subjectPublicKeyAlgorithm, newValue)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        newValue,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#getSubjectPublicKeyAlgorithm() subjectPublicKeyAlgorithm} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subjectPublicKeyAlgorithm
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withSubjectPublicKeyAlgorithm(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.subjectPublicKeyAlgorithm, value)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        value,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#getSubjectPublicKeyModulus() subjectPublicKeyModulus} attribute.
   * @param value The value for subjectPublicKeyModulus
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withSubjectPublicKeyModulus(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "subjectPublicKeyModulus");
    if (Objects.equals(this.subjectPublicKeyModulus, newValue)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        newValue,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#getSubjectPublicKeyModulus() subjectPublicKeyModulus} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subjectPublicKeyModulus
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withSubjectPublicKeyModulus(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.subjectPublicKeyModulus, value)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        value,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#getSubjectPublicKeyExponent() subjectPublicKeyExponent} attribute.
   * @param value The value for subjectPublicKeyExponent
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withSubjectPublicKeyExponent(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.subjectPublicKeyExponent, newValue)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        newValue,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#getSubjectPublicKeyExponent() subjectPublicKeyExponent} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subjectPublicKeyExponent
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withSubjectPublicKeyExponent(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.subjectPublicKeyExponent, value)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        value,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#getX509V3Extensions() x509V3Extensions} attribute.
   * @param value The value for x509V3Extensions
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withX509V3Extensions(X509v3ExtensionsObj value) {
    @Nullable X509v3ExtensionsObj newValue = Objects.requireNonNull(value, "x509V3Extensions");
    if (this.x509V3Extensions == newValue) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        newValue,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#getX509V3Extensions() x509V3Extensions} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for x509V3Extensions
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final X509Certificate withX509V3Extensions(Optional<? extends X509v3ExtensionsObj> optional) {
    @Nullable X509v3ExtensionsObj value = optional.orElse(null);
    if (this.x509V3Extensions == value) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        value,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link X509CertificateCoo#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final X509Certificate withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        value,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link X509CertificateCoo#getExtensions() extensions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withExtensions(CyberObservableExtension... elements) {
    ImmutableSet<CyberObservableExtension> newValue = ImmutableSet.copyOf(elements);
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        newValue,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link X509CertificateCoo#getExtensions() extensions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of extensions elements to set
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withExtensions(Iterable<? extends CyberObservableExtension> elements) {
    if (this.extensions == elements) return this;
    ImmutableSet<CyberObservableExtension> newValue = ImmutableSet.copyOf(elements);
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        newValue,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link X509CertificateCoo#getObservableObjectKey() observableObjectKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for observableObjectKey
   * @return A modified copy of the {@code this} object
   */
  public final X509Certificate withObservableObjectKey(String value) {
    String newValue = Objects.requireNonNull(value, "observableObjectKey");
    if (this.observableObjectKey.equals(newValue)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        newValue,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509CertificateCoo#getDefanged() defanged} attribute.
   * @param value The value for defanged
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withDefanged(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.defanged, newValue)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        newValue,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509CertificateCoo#getDefanged() defanged} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for defanged
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withDefanged(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.defanged, value)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        value,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by replacing the {@link X509CertificateCoo#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link X509CertificateCoo#getObjectMarkingRefs() objectMarkingRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withObjectMarkingRefs(MarkingDefinitionDm... elements) {
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        newValue,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link X509CertificateCoo#getObjectMarkingRefs() objectMarkingRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectMarkingRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
    if (this.objectMarkingRefs == elements) return this;
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        newValue,
        this.granularMarkings,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link X509CertificateCoo#getGranularMarkings() granularMarkings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withGranularMarkings(GranularMarkingDm... elements) {
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        newValue,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link X509CertificateCoo#getGranularMarkings() granularMarkings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of granularMarkings elements to set
   * @return A modified copy of {@code this} object
   */
  public final X509Certificate withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
    if (this.granularMarkings == elements) return this;
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        newValue,
        this.hydrated,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link X509CertificateCoo#getHydrated() hydrated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hydrated
   * @return A modified copy of the {@code this} object
   */
  public final X509Certificate withHydrated(boolean value) {
    if (this.hydrated == value) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        value,
        this.toJsonString));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link X509CertificateCoo#toJsonString() toJsonString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toJsonString (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final X509Certificate withToJsonString(String value) {
    if (Objects.equals(this.toJsonString, value)) return this;
    return validate(new X509Certificate(
        this.isSelfSigned,
        this.hashes,
        this.version,
        this.serialNumber,
        this.signatureAlgorithm,
        this.issuer,
        this.validityNotBefore,
        this.validityNotAfter,
        this.subject,
        this.subjectPublicKeyAlgorithm,
        this.subjectPublicKeyModulus,
        this.subjectPublicKeyExponent,
        this.x509V3Extensions,
        this.type,
        this.extensions,
        this.observableObjectKey,
        this.defanged,
        this.customProperties,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.hydrated,
        value));
  }

  /**
   * This instance is equal to all instances of {@code X509Certificate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof X509Certificate
        && equalTo((X509Certificate) another);
  }

  private boolean equalTo(X509Certificate another) {
    return Objects.equals(isSelfSigned, another.isSelfSigned)
        && hashes.equals(another.hashes)
        && Objects.equals(version, another.version)
        && Objects.equals(serialNumber, another.serialNumber)
        && Objects.equals(signatureAlgorithm, another.signatureAlgorithm)
        && Objects.equals(issuer, another.issuer)
        && Objects.equals(validityNotBefore, another.validityNotBefore)
        && Objects.equals(validityNotAfter, another.validityNotAfter)
        && Objects.equals(subject, another.subject)
        && Objects.equals(subjectPublicKeyAlgorithm, another.subjectPublicKeyAlgorithm)
        && Objects.equals(subjectPublicKeyModulus, another.subjectPublicKeyModulus)
        && Objects.equals(subjectPublicKeyExponent, another.subjectPublicKeyExponent)
        && Objects.equals(x509V3Extensions, another.x509V3Extensions)
        && id.equals(another.id)
        && Objects.equals(type, another.type)
        && extensions.equals(another.extensions)
        && observableObjectKey.equals(another.observableObjectKey)
        && Objects.equals(defanged, another.defanged)
        && customProperties.equals(another.customProperties)
        && objectMarkingRefs.equals(another.objectMarkingRefs)
        && granularMarkings.equals(another.granularMarkings)
        && hydrated == another.hydrated
        && Objects.equals(toJsonString, another.toJsonString);
  }

  /**
   * Computes a hash code from attributes: {@code isSelfSigned}, {@code hashes}, {@code version}, {@code serialNumber}, {@code signatureAlgorithm}, {@code issuer}, {@code validityNotBefore}, {@code validityNotAfter}, {@code subject}, {@code subjectPublicKeyAlgorithm}, {@code subjectPublicKeyModulus}, {@code subjectPublicKeyExponent}, {@code x509V3Extensions}, {@code id}, {@code type}, {@code extensions}, {@code observableObjectKey}, {@code defanged}, {@code customProperties}, {@code objectMarkingRefs}, {@code granularMarkings}, {@code hydrated}, {@code toJsonString}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(isSelfSigned);
    h += (h << 5) + hashes.hashCode();
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(serialNumber);
    h += (h << 5) + Objects.hashCode(signatureAlgorithm);
    h += (h << 5) + Objects.hashCode(issuer);
    h += (h << 5) + Objects.hashCode(validityNotBefore);
    h += (h << 5) + Objects.hashCode(validityNotAfter);
    h += (h << 5) + Objects.hashCode(subject);
    h += (h << 5) + Objects.hashCode(subjectPublicKeyAlgorithm);
    h += (h << 5) + Objects.hashCode(subjectPublicKeyModulus);
    h += (h << 5) + Objects.hashCode(subjectPublicKeyExponent);
    h += (h << 5) + Objects.hashCode(x509V3Extensions);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + extensions.hashCode();
    h += (h << 5) + observableObjectKey.hashCode();
    h += (h << 5) + Objects.hashCode(defanged);
    h += (h << 5) + customProperties.hashCode();
    h += (h << 5) + objectMarkingRefs.hashCode();
    h += (h << 5) + granularMarkings.hashCode();
    h += (h << 5) + Booleans.hashCode(hydrated);
    h += (h << 5) + Objects.hashCode(toJsonString);
    return h;
  }

  /**
   * Prints the immutable value {@code X509Certificate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("X509Certificate")
        .omitNullValues()
        .add("isSelfSigned", isSelfSigned)
        .add("hashes", hashes)
        .add("version", version)
        .add("serialNumber", serialNumber)
        .add("signatureAlgorithm", signatureAlgorithm)
        .add("issuer", issuer)
        .add("validityNotBefore", validityNotBefore)
        .add("validityNotAfter", validityNotAfter)
        .add("subject", subject)
        .add("subjectPublicKeyAlgorithm", subjectPublicKeyAlgorithm)
        .add("subjectPublicKeyModulus", subjectPublicKeyModulus)
        .add("subjectPublicKeyExponent", subjectPublicKeyExponent)
        .add("x509V3Extensions", x509V3Extensions)
        .add("id", id)
        .add("type", type)
        .add("extensions", extensions)
        .add("observableObjectKey", observableObjectKey)
        .add("defanged", defanged)
        .add("customProperties", customProperties)
        .add("objectMarkingRefs", objectMarkingRefs)
        .add("granularMarkings", granularMarkings)
        .add("hydrated", hydrated)
        .add("toJsonString", toJsonString)
        .toString();
  }


  private static X509Certificate validate(X509Certificate instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link X509CertificateCoo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable X509Certificate instance
   */
  public static X509Certificate copyOf(X509CertificateCoo instance) {
    if (instance instanceof X509Certificate) {
      return (X509Certificate) instance;
    }
    return X509Certificate.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link X509Certificate X509Certificate}.
   * @return A new X509Certificate builder
   */
  public static X509Certificate.Builder builder() {
    return new X509Certificate.Builder();
  }

  /**
   * Builds instances of type {@link X509Certificate X509Certificate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "X509CertificateCoo", generator = "Immutables")
  @NotThreadSafe
  @JsonTypeName("x509-certificate")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"type", "extensions", "is_self_signed", "hashes", "version", "serial_number", "signature_algorithm", "issuer", "validity_not_before", "validity_not_after", "subject", "subject_public_key_algorithm", "subject_public_key_modulus", "subject_public_key_exponent", "x509_v3_extensions"})
  public static final class Builder {
    private static final long OPT_BIT_EXTENSIONS = 0x1L;
    private long optBits;

    private @Nullable Boolean isSelfSigned;
    private ImmutableMap.Builder<String, String> hashes = ImmutableMap.builder();
    private @Nullable String version;
    private @Nullable String serialNumber;
    private @Nullable String signatureAlgorithm;
    private @Nullable String issuer;
    private @Nullable StixInstant validityNotBefore;
    private @Nullable StixInstant validityNotAfter;
    private @Nullable String subject;
    private @Nullable String subjectPublicKeyAlgorithm;
    private @Nullable String subjectPublicKeyModulus;
    private @Nullable Long subjectPublicKeyExponent;
    private @Nullable X509v3ExtensionsObj x509V3Extensions;
    private @Nullable String type;
    private ImmutableSet.Builder<CyberObservableExtension> extensions = ImmutableSet.builder();
    private @Nullable String observableObjectKey;
    private @Nullable Boolean defanged;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
    private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
    private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
    private boolean hydrated;
    private @Nullable String toJsonString;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleableObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleableObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.objects.X509CertificateCoo} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(X509CertificateCoo instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.CyberObservableObjectCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CyberObservableObjectCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BundleableObject) {
        BundleableObject instance = (BundleableObject) object;
        addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        hydrated(instance.getHydrated());
        addAllGranularMarkings(instance.getGranularMarkings());
        String toJsonStringValue = instance.toJsonString();
        if (toJsonStringValue != null) {
          toJsonString(toJsonStringValue);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof X509CertificateCoo) {
        X509CertificateCoo instance = (X509CertificateCoo) object;
        Optional<Long> subjectPublicKeyExponentOptional = instance.getSubjectPublicKeyExponent();
        if (subjectPublicKeyExponentOptional.isPresent()) {
          subjectPublicKeyExponent(subjectPublicKeyExponentOptional);
        }
        Optional<String> serialNumberOptional = instance.getSerialNumber();
        if (serialNumberOptional.isPresent()) {
          serialNumber(serialNumberOptional);
        }
        Optional<String> subjectOptional = instance.getSubject();
        if (subjectOptional.isPresent()) {
          subject(subjectOptional);
        }
        Optional<StixInstant> validityNotBeforeOptional = instance.getValidityNotBefore();
        if (validityNotBeforeOptional.isPresent()) {
          validityNotBefore(validityNotBeforeOptional);
        }
        Optional<String> versionOptional = instance.getVersion();
        if (versionOptional.isPresent()) {
          version(versionOptional);
        }
        Optional<String> signatureAlgorithmOptional = instance.getSignatureAlgorithm();
        if (signatureAlgorithmOptional.isPresent()) {
          signatureAlgorithm(signatureAlgorithmOptional);
        }
        Optional<String> issuerOptional = instance.getIssuer();
        if (issuerOptional.isPresent()) {
          issuer(issuerOptional);
        }
        Optional<String> subjectPublicKeyAlgorithmOptional = instance.getSubjectPublicKeyAlgorithm();
        if (subjectPublicKeyAlgorithmOptional.isPresent()) {
          subjectPublicKeyAlgorithm(subjectPublicKeyAlgorithmOptional);
        }
        Optional<Boolean> isSelfSignedOptional = instance.isSelfSigned();
        if (isSelfSignedOptional.isPresent()) {
          isSelfSigned(isSelfSignedOptional);
        }
        Optional<String> subjectPublicKeyModulusOptional = instance.getSubjectPublicKeyModulus();
        if (subjectPublicKeyModulusOptional.isPresent()) {
          subjectPublicKeyModulus(subjectPublicKeyModulusOptional);
        }
        Optional<X509v3ExtensionsObj> x509V3ExtensionsOptional = instance.getX509V3Extensions();
        if (x509V3ExtensionsOptional.isPresent()) {
          x509V3Extensions(x509V3ExtensionsOptional);
        }
        putAllHashes(instance.getHashes());
        Optional<StixInstant> validityNotAfterOptional = instance.getValidityNotAfter();
        if (validityNotAfterOptional.isPresent()) {
          validityNotAfter(validityNotAfterOptional);
        }
      }
      if (object instanceof CyberObservableObjectCommonProperties) {
        CyberObservableObjectCommonProperties instance = (CyberObservableObjectCommonProperties) object;
        addAllExtensions(instance.getExtensions());
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        observableObjectKey(instance.getObservableObjectKey());
        Optional<Boolean> defangedOptional = instance.getDefanged();
        if (defangedOptional.isPresent()) {
          defanged(defangedOptional);
        }
      }
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#isSelfSigned() isSelfSigned} to isSelfSigned.
     * @param isSelfSigned The value for isSelfSigned
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isSelfSigned(boolean isSelfSigned) {
      this.isSelfSigned = isSelfSigned;
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#isSelfSigned() isSelfSigned} to isSelfSigned.
     * @param isSelfSigned The value for isSelfSigned
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("is_self_signed")
    @JsonPropertyDescription("Specifies whether the certificate is self-signed, i.e., whether it is signed by the same entity whose identity it certifies.")
    public final Builder isSelfSigned(Optional<Boolean> isSelfSigned) {
      this.isSelfSigned = isSelfSigned.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link X509CertificateCoo#getHashes() hashes} map.
     * @param key The key in the hashes map
     * @param value The associated value in the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHash(String key, String value) {
      this.hashes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link X509CertificateCoo#getHashes() hashes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHash(Map.Entry<String, ? extends String> entry) {
      this.hashes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link X509CertificateCoo#getHashes() hashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hashes")
    @JsonPropertyDescription("Specifies any hashes that were calculated for the entire contents of the certificate.")
    public final Builder hashes(Map<String, ? extends String> entries) {
      this.hashes = ImmutableMap.builder();
      return putAllHashes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link X509CertificateCoo#getHashes() hashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllHashes(Map<String, ? extends String> entries) {
      this.hashes.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getVersion() version} to version.
     * @param version The value for version
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getVersion() version} to version.
     * @param version The value for version
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    @JsonPropertyDescription("Specifies the version of the encoded certificate.")
    public final Builder version(Optional<String> version) {
      this.version = version.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getSerialNumber() serialNumber} to serialNumber.
     * @param serialNumber The value for serialNumber
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serialNumber(String serialNumber) {
      this.serialNumber = Objects.requireNonNull(serialNumber, "serialNumber");
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getSerialNumber() serialNumber} to serialNumber.
     * @param serialNumber The value for serialNumber
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("serial_number")
    @JsonPropertyDescription("Specifies the unique identifier for the certificate, as issued by a specific Certificate Authority.")
    public final Builder serialNumber(Optional<String> serialNumber) {
      this.serialNumber = serialNumber.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getSignatureAlgorithm() signatureAlgorithm} to signatureAlgorithm.
     * @param signatureAlgorithm The value for signatureAlgorithm
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder signatureAlgorithm(String signatureAlgorithm) {
      this.signatureAlgorithm = Objects.requireNonNull(signatureAlgorithm, "signatureAlgorithm");
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getSignatureAlgorithm() signatureAlgorithm} to signatureAlgorithm.
     * @param signatureAlgorithm The value for signatureAlgorithm
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("signature_algorithm")
    @JsonPropertyDescription("Specifies the name of the algorithm used to sign the certificate.")
    public final Builder signatureAlgorithm(Optional<String> signatureAlgorithm) {
      this.signatureAlgorithm = signatureAlgorithm.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getIssuer() issuer} to issuer.
     * @param issuer The value for issuer
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder issuer(String issuer) {
      this.issuer = Objects.requireNonNull(issuer, "issuer");
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getIssuer() issuer} to issuer.
     * @param issuer The value for issuer
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("issuer")
    @JsonPropertyDescription("Specifies the name of the Certificate Authority that issued the certificate.")
    public final Builder issuer(Optional<String> issuer) {
      this.issuer = issuer.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getValidityNotBefore() validityNotBefore} to validityNotBefore.
     * @param validityNotBefore The value for validityNotBefore
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder validityNotBefore(StixInstant validityNotBefore) {
      this.validityNotBefore = Objects.requireNonNull(validityNotBefore, "validityNotBefore");
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getValidityNotBefore() validityNotBefore} to validityNotBefore.
     * @param validityNotBefore The value for validityNotBefore
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("validity_not_before")
    @JsonPropertyDescription("Specifies the date on which the certificate validity period begins.")
    public final Builder validityNotBefore(Optional<? extends StixInstant> validityNotBefore) {
      this.validityNotBefore = validityNotBefore.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getValidityNotAfter() validityNotAfter} to validityNotAfter.
     * @param validityNotAfter The value for validityNotAfter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder validityNotAfter(StixInstant validityNotAfter) {
      this.validityNotAfter = Objects.requireNonNull(validityNotAfter, "validityNotAfter");
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getValidityNotAfter() validityNotAfter} to validityNotAfter.
     * @param validityNotAfter The value for validityNotAfter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("validity_not_after")
    @JsonPropertyDescription("Specifies the date on which the certificate validity period ends.")
    public final Builder validityNotAfter(Optional<? extends StixInstant> validityNotAfter) {
      this.validityNotAfter = validityNotAfter.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getSubject() subject} to subject.
     * @param subject The value for subject
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder subject(String subject) {
      this.subject = Objects.requireNonNull(subject, "subject");
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getSubject() subject} to subject.
     * @param subject The value for subject
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subject")
    @JsonPropertyDescription("Specifies the name of the entity associated with the public key stored in the subject public key field of the certificate.")
    public final Builder subject(Optional<String> subject) {
      this.subject = subject.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getSubjectPublicKeyAlgorithm() subjectPublicKeyAlgorithm} to subjectPublicKeyAlgorithm.
     * @param subjectPublicKeyAlgorithm The value for subjectPublicKeyAlgorithm
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder subjectPublicKeyAlgorithm(String subjectPublicKeyAlgorithm) {
      this.subjectPublicKeyAlgorithm = Objects.requireNonNull(subjectPublicKeyAlgorithm, "subjectPublicKeyAlgorithm");
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getSubjectPublicKeyAlgorithm() subjectPublicKeyAlgorithm} to subjectPublicKeyAlgorithm.
     * @param subjectPublicKeyAlgorithm The value for subjectPublicKeyAlgorithm
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subject_public_key_algorithm")
    @JsonPropertyDescription("Specifies the name of the algorithm with which to encrypt data being sent to the subject.")
    public final Builder subjectPublicKeyAlgorithm(Optional<String> subjectPublicKeyAlgorithm) {
      this.subjectPublicKeyAlgorithm = subjectPublicKeyAlgorithm.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getSubjectPublicKeyModulus() subjectPublicKeyModulus} to subjectPublicKeyModulus.
     * @param subjectPublicKeyModulus The value for subjectPublicKeyModulus
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder subjectPublicKeyModulus(String subjectPublicKeyModulus) {
      this.subjectPublicKeyModulus = Objects.requireNonNull(subjectPublicKeyModulus, "subjectPublicKeyModulus");
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getSubjectPublicKeyModulus() subjectPublicKeyModulus} to subjectPublicKeyModulus.
     * @param subjectPublicKeyModulus The value for subjectPublicKeyModulus
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subject_public_key_modulus")
    @JsonPropertyDescription("Specifies the modulus portion of the subject\u2019s public RSA key.")
    public final Builder subjectPublicKeyModulus(Optional<String> subjectPublicKeyModulus) {
      this.subjectPublicKeyModulus = subjectPublicKeyModulus.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getSubjectPublicKeyExponent() subjectPublicKeyExponent} to subjectPublicKeyExponent.
     * @param subjectPublicKeyExponent The value for subjectPublicKeyExponent
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder subjectPublicKeyExponent(long subjectPublicKeyExponent) {
      this.subjectPublicKeyExponent = subjectPublicKeyExponent;
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getSubjectPublicKeyExponent() subjectPublicKeyExponent} to subjectPublicKeyExponent.
     * @param subjectPublicKeyExponent The value for subjectPublicKeyExponent
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subject_public_key_exponent")
    @JsonPropertyDescription("Specifies the exponent portion of the subject\u2019s public RSA key, as an integer.")
    public final Builder subjectPublicKeyExponent(Optional<Long> subjectPublicKeyExponent) {
      this.subjectPublicKeyExponent = subjectPublicKeyExponent.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getX509V3Extensions() x509V3Extensions} to x509V3Extensions.
     * @param x509V3Extensions The value for x509V3Extensions
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder x509V3Extensions(X509v3ExtensionsObj x509V3Extensions) {
      this.x509V3Extensions = Objects.requireNonNull(x509V3Extensions, "x509V3Extensions");
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getX509V3Extensions() x509V3Extensions} to x509V3Extensions.
     * @param x509V3Extensions The value for x509V3Extensions
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("x509_v3_extensions")
    @JsonPropertyDescription("Specifies any standard X.509 v3 extensions that may be used in the certificate.")
    public final Builder x509V3Extensions(Optional<? extends X509v3ExtensionsObj> x509V3Extensions) {
      this.x509V3Extensions = x509V3Extensions.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link X509CertificateCoo#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Adds one element to {@link X509CertificateCoo#getExtensions() extensions} set.
     * @param element A extensions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtension(@Nullable CyberObservableExtension element) {
      this.extensions.add(element);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }

    /**
     * Adds elements to {@link X509CertificateCoo#getExtensions() extensions} set.
     * @param elements An array of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtensions(CyberObservableExtension... elements) {
      this.extensions.add(elements);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link X509CertificateCoo#getExtensions() extensions} set.
     * @param elements An iterable of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("extensions")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Specifies any extensions of the object, as a dictionary.")
    @JsonSerialize(using = CyberObservableExtensionsFieldSerializer.class)
    @JsonDeserialize(using = CyberObservableExtensionsFieldDeserializer.class)
    public final Builder extensions(Iterable<? extends CyberObservableExtension> elements) {
      this.extensions = ImmutableSet.builder();
      return addAllExtensions(elements);
    }

    /**
     * Adds elements to {@link X509CertificateCoo#getExtensions() extensions} set.
     * @param elements An iterable of extensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExtensions(Iterable<? extends CyberObservableExtension> elements) {
      this.extensions.addAll(elements);
      optBits |= OPT_BIT_EXTENSIONS;
      return this;
    }

    /**
     * Initializes the value for the {@link X509CertificateCoo#getObservableObjectKey() observableObjectKey} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link X509CertificateCoo#getObservableObjectKey() observableObjectKey}.</em>
     * @param observableObjectKey The value for observableObjectKey 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "observable_object_key", access = JsonProperty.Access.WRITE_ONLY)
    public final Builder observableObjectKey(String observableObjectKey) {
      this.observableObjectKey = Objects.requireNonNull(observableObjectKey, "observableObjectKey");
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getDefanged() defanged} to defanged.
     * @param defanged The value for defanged
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defanged(boolean defanged) {
      this.defanged = defanged;
      return this;
    }

    /**
     * Initializes the optional value {@link X509CertificateCoo#getDefanged() defanged} to defanged.
     * @param defanged The value for defanged
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("defanged")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Indicates whether the data contained in the SCO has been defanged.")
    public final Builder defanged(Optional<Boolean> defanged) {
      this.defanged = defanged.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link X509CertificateCoo#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link X509CertificateCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link X509CertificateCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link X509CertificateCoo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link X509CertificateCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param element A objectMarkingRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
      this.objectMarkingRefs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link X509CertificateCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An array of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRefs(MarkingDefinitionDm... elements) {
      this.objectMarkingRefs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link X509CertificateCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("objectMarkingRefs")
    public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs = ImmutableSet.builder();
      return addAllObjectMarkingRefs(elements);
    }

    /**
     * Adds elements to {@link X509CertificateCoo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link X509CertificateCoo#getGranularMarkings() granularMarkings} set.
     * @param element A granularMarkings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
      this.granularMarkings.add(element);
      return this;
    }

    /**
     * Adds elements to {@link X509CertificateCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An array of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarkings(GranularMarkingDm... elements) {
      this.granularMarkings.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link X509CertificateCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("granularMarkings")
    public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings = ImmutableSet.builder();
      return addAllGranularMarkings(elements);
    }

    /**
     * Adds elements to {@link X509CertificateCoo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link X509CertificateCoo#getHydrated() hydrated} attribute.
     * @param hydrated The value for hydrated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hydrated")
    public final Builder hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      return this;
    }

    /**
     * Initializes the value for the {@link X509CertificateCoo#toJsonString() toJsonString} attribute.
     * @param toJsonString The value for toJsonString (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("toJsonString")
    public final Builder toJsonString(String toJsonString) {
      this.toJsonString = toJsonString;
      return this;
    }

    /**
     * Builds a new {@link X509Certificate X509Certificate}.
     * @return An immutable instance of X509Certificate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public X509Certificate build() {
      return X509Certificate.validate(new X509Certificate(this));
    }

    private boolean extensionsIsSet() {
      return (optBits & OPT_BIT_EXTENSIONS) != 0;
    }
  }
}
