package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;

/**
 * Specifies a component of a multi-part email body.
 */
@Generated(from = "MimePartTypeObj", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class MimePartType implements MimePartTypeObj {
  private final @Nullable String body;
  private final @Nullable String bodyRawRef;
  private final @Nullable String contentType;
  private final @Nullable String contentDisposition;
  private final ImmutableMap<String, Object> customProperties;

  private MimePartType(
      @Nullable String body,
      @Nullable String bodyRawRef,
      @Nullable String contentType,
      @Nullable String contentDisposition,
      ImmutableMap<String, Object> customProperties) {
    this.body = body;
    this.bodyRawRef = bodyRawRef;
    this.contentType = contentType;
    this.contentDisposition = contentDisposition;
    this.customProperties = customProperties;
  }

  /**
   * Contents of body MUST be decoded to Unicode.
   */
  @JsonProperty("body")
  @JsonPropertyDescription("Specifies the contents of the MIME part if the content_type is not provided OR starts with text/")
  @Override
  public Optional<String> getBody() {
    return Optional.ofNullable(body);
  }

  /**
   * The object referenced in this property MUST be of type artifact or file.
   * For use cases where conveying the actual data contained in the MIME part is of primary importance, artifact SHOULD be used.
   * Otherwise, for use cases where conveying metadata about the file-like properties of the MIME part is of primary importance, file SHOULD be used.
   */
  @JsonProperty("body_raw_ref")
  @JsonPropertyDescription("Specifies the contents of non-textual MIME parts, that is those whose content_type does not start with text/")
  @Override
  public Optional<String> getBodyRawRef() {
    return Optional.ofNullable(bodyRawRef);
  }

  /**
   * Any additional “Content-Type” header field parameters such as charset SHOULD be included in this property.
   */
  @JsonProperty("content_type")
  @JsonPropertyDescription("Specifies the value of the \'Content-Type\' header field of the MIME part.")
  @Override
  public Optional<String> getContentType() {
    return Optional.ofNullable(contentType);
  }

  /**
   * @return The value of the {@code contentDisposition} attribute
   */
  @JsonProperty("content_disposition")
  @JsonPropertyDescription("Specifies the value of the \'Content-Disposition\' header field of the MIME part.")
  @Override
  public Optional<String> getContentDisposition() {
    return Optional.ofNullable(contentDisposition);
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MimePartTypeObj#getBody() body} attribute.
   * @param value The value for body
   * @return A modified copy of {@code this} object
   */
  public final MimePartType withBody(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "body");
    if (Objects.equals(this.body, newValue)) return this;
    return validate(new MimePartType(newValue, this.bodyRawRef, this.contentType, this.contentDisposition, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MimePartTypeObj#getBody() body} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for body
   * @return A modified copy of {@code this} object
   */
  public final MimePartType withBody(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.body, value)) return this;
    return validate(new MimePartType(value, this.bodyRawRef, this.contentType, this.contentDisposition, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MimePartTypeObj#getBodyRawRef() bodyRawRef} attribute.
   * @param value The value for bodyRawRef
   * @return A modified copy of {@code this} object
   */
  public final MimePartType withBodyRawRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "bodyRawRef");
    if (Objects.equals(this.bodyRawRef, newValue)) return this;
    return validate(new MimePartType(this.body, newValue, this.contentType, this.contentDisposition, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MimePartTypeObj#getBodyRawRef() bodyRawRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for bodyRawRef
   * @return A modified copy of {@code this} object
   */
  public final MimePartType withBodyRawRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.bodyRawRef, value)) return this;
    return validate(new MimePartType(this.body, value, this.contentType, this.contentDisposition, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MimePartTypeObj#getContentType() contentType} attribute.
   * @param value The value for contentType
   * @return A modified copy of {@code this} object
   */
  public final MimePartType withContentType(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "contentType");
    if (Objects.equals(this.contentType, newValue)) return this;
    return validate(new MimePartType(this.body, this.bodyRawRef, newValue, this.contentDisposition, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MimePartTypeObj#getContentType() contentType} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for contentType
   * @return A modified copy of {@code this} object
   */
  public final MimePartType withContentType(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.contentType, value)) return this;
    return validate(new MimePartType(this.body, this.bodyRawRef, value, this.contentDisposition, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MimePartTypeObj#getContentDisposition() contentDisposition} attribute.
   * @param value The value for contentDisposition
   * @return A modified copy of {@code this} object
   */
  public final MimePartType withContentDisposition(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "contentDisposition");
    if (Objects.equals(this.contentDisposition, newValue)) return this;
    return validate(new MimePartType(this.body, this.bodyRawRef, this.contentType, newValue, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MimePartTypeObj#getContentDisposition() contentDisposition} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for contentDisposition
   * @return A modified copy of {@code this} object
   */
  public final MimePartType withContentDisposition(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.contentDisposition, value)) return this;
    return validate(new MimePartType(this.body, this.bodyRawRef, this.contentType, value, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link MimePartTypeObj#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final MimePartType withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new MimePartType(this.body, this.bodyRawRef, this.contentType, this.contentDisposition, newValue));
  }

  /**
   * This instance is equal to all instances of {@code MimePartType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof MimePartType
        && equalTo((MimePartType) another);
  }

  private boolean equalTo(MimePartType another) {
    return Objects.equals(body, another.body)
        && Objects.equals(bodyRawRef, another.bodyRawRef)
        && Objects.equals(contentType, another.contentType)
        && Objects.equals(contentDisposition, another.contentDisposition)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code body}, {@code bodyRawRef}, {@code contentType}, {@code contentDisposition}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + Objects.hashCode(bodyRawRef);
    h += (h << 5) + Objects.hashCode(contentType);
    h += (h << 5) + Objects.hashCode(contentDisposition);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MimePartType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MimePartType")
        .omitNullValues()
        .add("body", body)
        .add("bodyRawRef", bodyRawRef)
        .add("contentType", contentType)
        .add("contentDisposition", contentDisposition)
        .add("customProperties", customProperties)
        .toString();
  }


  private static MimePartType validate(MimePartType instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link MimePartTypeObj} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MimePartType instance
   */
  public static MimePartType copyOf(MimePartTypeObj instance) {
    if (instance instanceof MimePartType) {
      return (MimePartType) instance;
    }
    return MimePartType.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link MimePartType MimePartType}.
   * @return A new MimePartType builder
   */
  public static MimePartType.Builder builder() {
    return new MimePartType.Builder();
  }

  /**
   * Builds instances of type {@link MimePartType MimePartType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MimePartTypeObj", generator = "Immutables")
  @NotThreadSafe
  @JsonPropertyOrder({"body", "body_raw_ref", "content_type", "content_disposition"})
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  public static final class Builder {
    private @Nullable String body;
    private @Nullable String bodyRawRef;
    private @Nullable String contentType;
    private @Nullable String contentDisposition;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.types.MimePartTypeObj} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MimePartTypeObj instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof MimePartTypeObj) {
        MimePartTypeObj instance = (MimePartTypeObj) object;
        Optional<String> contentDispositionOptional = instance.getContentDisposition();
        if (contentDispositionOptional.isPresent()) {
          contentDisposition(contentDispositionOptional);
        }
        Optional<String> bodyRawRefOptional = instance.getBodyRawRef();
        if (bodyRawRefOptional.isPresent()) {
          bodyRawRef(bodyRawRefOptional);
        }
        Optional<String> bodyOptional = instance.getBody();
        if (bodyOptional.isPresent()) {
          body(bodyOptional);
        }
        Optional<String> contentTypeOptional = instance.getContentType();
        if (contentTypeOptional.isPresent()) {
          contentType(contentTypeOptional);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
    }

    /**
     * Initializes the optional value {@link MimePartTypeObj#getBody() body} to body.
     * @param body The value for body
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder body(String body) {
      this.body = Objects.requireNonNull(body, "body");
      return this;
    }

    /**
     * Initializes the optional value {@link MimePartTypeObj#getBody() body} to body.
     * @param body The value for body
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("body")
    @JsonPropertyDescription("Specifies the contents of the MIME part if the content_type is not provided OR starts with text/")
    public final Builder body(Optional<String> body) {
      this.body = body.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MimePartTypeObj#getBodyRawRef() bodyRawRef} to bodyRawRef.
     * @param bodyRawRef The value for bodyRawRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bodyRawRef(String bodyRawRef) {
      this.bodyRawRef = Objects.requireNonNull(bodyRawRef, "bodyRawRef");
      return this;
    }

    /**
     * Initializes the optional value {@link MimePartTypeObj#getBodyRawRef() bodyRawRef} to bodyRawRef.
     * @param bodyRawRef The value for bodyRawRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("body_raw_ref")
    @JsonPropertyDescription("Specifies the contents of non-textual MIME parts, that is those whose content_type does not start with text/")
    public final Builder bodyRawRef(Optional<String> bodyRawRef) {
      this.bodyRawRef = bodyRawRef.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MimePartTypeObj#getContentType() contentType} to contentType.
     * @param contentType The value for contentType
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder contentType(String contentType) {
      this.contentType = Objects.requireNonNull(contentType, "contentType");
      return this;
    }

    /**
     * Initializes the optional value {@link MimePartTypeObj#getContentType() contentType} to contentType.
     * @param contentType The value for contentType
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content_type")
    @JsonPropertyDescription("Specifies the value of the \'Content-Type\' header field of the MIME part.")
    public final Builder contentType(Optional<String> contentType) {
      this.contentType = contentType.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MimePartTypeObj#getContentDisposition() contentDisposition} to contentDisposition.
     * @param contentDisposition The value for contentDisposition
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder contentDisposition(String contentDisposition) {
      this.contentDisposition = Objects.requireNonNull(contentDisposition, "contentDisposition");
      return this;
    }

    /**
     * Initializes the optional value {@link MimePartTypeObj#getContentDisposition() contentDisposition} to contentDisposition.
     * @param contentDisposition The value for contentDisposition
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content_disposition")
    @JsonPropertyDescription("Specifies the value of the \'Content-Disposition\' header field of the MIME part.")
    public final Builder contentDisposition(Optional<String> contentDisposition) {
      this.contentDisposition = contentDisposition.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link MimePartTypeObj#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link MimePartTypeObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MimePartTypeObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MimePartTypeObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link MimePartType MimePartType}.
     * @return An immutable instance of MimePartType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public MimePartType build() {
      return MimePartType.validate(new MimePartType(body, bodyRawRef, contentType, contentDisposition, customProperties.build()));
    }
  }
}
