package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;

/**
 * The Alternate Data Stream type represents an NTFS alternate data stream.
 */
@Generated(from = "NtfsAlternateDataStreamObj", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class NtfsAlternateDataStream
    implements NtfsAlternateDataStreamObj {
  private final String name;
  private final ImmutableMap<String, String> hashes;
  private final @Nullable Long size;
  private final ImmutableMap<String, Object> customProperties;

  private NtfsAlternateDataStream(
      String name,
      ImmutableMap<String, String> hashes,
      @Nullable Long size,
      ImmutableMap<String, Object> customProperties) {
    this.name = name;
    this.hashes = hashes;
    this.size = size;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JsonPropertyDescription("Specifies the name of the alternate data stream.")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code hashes} attribute
   */
  @JsonProperty("hashes")
  @JsonPropertyDescription("Specifies a dictionary of hashes for the data contained in the alternate data stream.")
  @Override
  public ImmutableMap<String, String> getHashes() {
    return hashes;
  }

  /**
   * @return The value of the {@code size} attribute
   */
  @JsonProperty("size")
  @JsonPropertyDescription("Specifies the size of the alternate data stream, in bytes, as a non-negative integer.")
  @Override
  public Optional<Long> getSize() {
    return Optional.ofNullable(size);
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NtfsAlternateDataStreamObj#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final NtfsAlternateDataStream withName(String value) {
    if (Objects.equals(this.name, value)) return this;
    return validate(new NtfsAlternateDataStream(value, this.hashes, this.size, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link NtfsAlternateDataStreamObj#getHashes() hashes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the hashes map
   * @return A modified copy of {@code this} object
   */
  public final NtfsAlternateDataStream withHashes(Map<String, ? extends String> entries) {
    if (this.hashes == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return validate(new NtfsAlternateDataStream(this.name, newValue, this.size, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link NtfsAlternateDataStreamObj#getSize() size} attribute.
   * @param value The value for size
   * @return A modified copy of {@code this} object
   */
  public final NtfsAlternateDataStream withSize(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.size, newValue)) return this;
    return validate(new NtfsAlternateDataStream(this.name, this.hashes, newValue, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link NtfsAlternateDataStreamObj#getSize() size} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for size
   * @return A modified copy of {@code this} object
   */
  public final NtfsAlternateDataStream withSize(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.size, value)) return this;
    return validate(new NtfsAlternateDataStream(this.name, this.hashes, value, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link NtfsAlternateDataStreamObj#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final NtfsAlternateDataStream withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new NtfsAlternateDataStream(this.name, this.hashes, this.size, newValue));
  }

  /**
   * This instance is equal to all instances of {@code NtfsAlternateDataStream} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof NtfsAlternateDataStream
        && equalTo((NtfsAlternateDataStream) another);
  }

  private boolean equalTo(NtfsAlternateDataStream another) {
    return Objects.equals(name, another.name)
        && hashes.equals(another.hashes)
        && Objects.equals(size, another.size)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code hashes}, {@code size}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + hashes.hashCode();
    h += (h << 5) + Objects.hashCode(size);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NtfsAlternateDataStream} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NtfsAlternateDataStream")
        .omitNullValues()
        .add("name", name)
        .add("hashes", hashes)
        .add("size", size)
        .add("customProperties", customProperties)
        .toString();
  }


  private static NtfsAlternateDataStream validate(NtfsAlternateDataStream instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link NtfsAlternateDataStreamObj} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NtfsAlternateDataStream instance
   */
  public static NtfsAlternateDataStream copyOf(NtfsAlternateDataStreamObj instance) {
    if (instance instanceof NtfsAlternateDataStream) {
      return (NtfsAlternateDataStream) instance;
    }
    return NtfsAlternateDataStream.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link NtfsAlternateDataStream NtfsAlternateDataStream}.
   * @return A new NtfsAlternateDataStream builder
   */
  public static NtfsAlternateDataStream.Builder builder() {
    return new NtfsAlternateDataStream.Builder();
  }

  /**
   * Builds instances of type {@link NtfsAlternateDataStream NtfsAlternateDataStream}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NtfsAlternateDataStreamObj", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"name", "hashes", "size"})
  public static final class Builder {
    private @Nullable String name;
    private ImmutableMap.Builder<String, String> hashes = ImmutableMap.builder();
    private @Nullable Long size;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.types.NtfsAlternateDataStreamObj} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NtfsAlternateDataStreamObj instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof NtfsAlternateDataStreamObj) {
        NtfsAlternateDataStreamObj instance = (NtfsAlternateDataStreamObj) object;
        Optional<Long> sizeOptional = instance.getSize();
        if (sizeOptional.isPresent()) {
          size(sizeOptional);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        putAllHashes(instance.getHashes());
      }
    }

    /**
     * Initializes the value for the {@link NtfsAlternateDataStreamObj#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    @JsonPropertyDescription("Specifies the name of the alternate data stream.")
    public final Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * Put one entry to the {@link NtfsAlternateDataStreamObj#getHashes() hashes} map.
     * @param key The key in the hashes map
     * @param value The associated value in the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHash(String key, String value) {
      this.hashes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NtfsAlternateDataStreamObj#getHashes() hashes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHash(Map.Entry<String, ? extends String> entry) {
      this.hashes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NtfsAlternateDataStreamObj#getHashes() hashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hashes")
    @JsonPropertyDescription("Specifies a dictionary of hashes for the data contained in the alternate data stream.")
    public final Builder hashes(Map<String, ? extends String> entries) {
      this.hashes = ImmutableMap.builder();
      return putAllHashes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NtfsAlternateDataStreamObj#getHashes() hashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllHashes(Map<String, ? extends String> entries) {
      this.hashes.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link NtfsAlternateDataStreamObj#getSize() size} to size.
     * @param size The value for size
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder size(long size) {
      this.size = size;
      return this;
    }

    /**
     * Initializes the optional value {@link NtfsAlternateDataStreamObj#getSize() size} to size.
     * @param size The value for size
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size")
    @JsonPropertyDescription("Specifies the size of the alternate data stream, in bytes, as a non-negative integer.")
    public final Builder size(Optional<Long> size) {
      this.size = size.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link NtfsAlternateDataStreamObj#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NtfsAlternateDataStreamObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NtfsAlternateDataStreamObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NtfsAlternateDataStreamObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link NtfsAlternateDataStream NtfsAlternateDataStream}.
     * @return An immutable instance of NtfsAlternateDataStream
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public NtfsAlternateDataStream build() {
      return NtfsAlternateDataStream.validate(new NtfsAlternateDataStream(name, hashes.build(), size, customProperties.build()));
    }
  }
}
