package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;

/**
 * The Windows PE Optional Header type represents the properties of the PE
 * optional header.
 */
@Generated(from = "WindowsPeOptionalHeaderObj", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class WindowsPeOptionalHeader
    implements WindowsPeOptionalHeaderObj {
  private final @Nullable String magicHex;
  private final @Nullable Long majorLinkerVersion;
  private final @Nullable Long minorLinkerVersion;
  private final @Nullable Long sizeOfCode;
  private final @Nullable Long sizeOfInitializedData;
  private final @Nullable Long sizeOfUninitializedData;
  private final @Nullable Long addressOfEntryPoint;
  private final @Nullable Long baseOfCode;
  private final @Nullable Long baseOfData;
  private final @Nullable Long imageBase;
  private final @Nullable Long sectionAlignment;
  private final @Nullable Long fileAlignment;
  private final @Nullable Long majorOsVersion;
  private final @Nullable Long minorOsVersion;
  private final @Nullable Long majorImageVersion;
  private final @Nullable Long minorImageVersion;
  private final @Nullable Long majorSubsystemVersion;
  private final @Nullable Long minorSubsystemVersion;
  private final @Nullable String win32VersionValueHex;
  private final @Nullable Long sizeOfImage;
  private final @Nullable Long sizeOfHeaders;
  private final @Nullable String checksumHex;
  private final @Nullable String subsystemHex;
  private final @Nullable String dllCharacteristicsHex;
  private final @Nullable Long sizeOfStackReserve;
  private final @Nullable Long sizeOfStackCommit;
  private final @Nullable Long sizeOfHeapReserve;
  private final @Nullable Long sizeOfHeapCommit;
  private final @Nullable String loaderFlagsHex;
  private final @Nullable Long numberOfRvaAndSizes;
  private final ImmutableMap<String, String> hashes;
  private final ImmutableMap<String, Object> customProperties;

  private WindowsPeOptionalHeader(
      @Nullable String magicHex,
      @Nullable Long majorLinkerVersion,
      @Nullable Long minorLinkerVersion,
      @Nullable Long sizeOfCode,
      @Nullable Long sizeOfInitializedData,
      @Nullable Long sizeOfUninitializedData,
      @Nullable Long addressOfEntryPoint,
      @Nullable Long baseOfCode,
      @Nullable Long baseOfData,
      @Nullable Long imageBase,
      @Nullable Long sectionAlignment,
      @Nullable Long fileAlignment,
      @Nullable Long majorOsVersion,
      @Nullable Long minorOsVersion,
      @Nullable Long majorImageVersion,
      @Nullable Long minorImageVersion,
      @Nullable Long majorSubsystemVersion,
      @Nullable Long minorSubsystemVersion,
      @Nullable String win32VersionValueHex,
      @Nullable Long sizeOfImage,
      @Nullable Long sizeOfHeaders,
      @Nullable String checksumHex,
      @Nullable String subsystemHex,
      @Nullable String dllCharacteristicsHex,
      @Nullable Long sizeOfStackReserve,
      @Nullable Long sizeOfStackCommit,
      @Nullable Long sizeOfHeapReserve,
      @Nullable Long sizeOfHeapCommit,
      @Nullable String loaderFlagsHex,
      @Nullable Long numberOfRvaAndSizes,
      ImmutableMap<String, String> hashes,
      ImmutableMap<String, Object> customProperties) {
    this.magicHex = magicHex;
    this.majorLinkerVersion = majorLinkerVersion;
    this.minorLinkerVersion = minorLinkerVersion;
    this.sizeOfCode = sizeOfCode;
    this.sizeOfInitializedData = sizeOfInitializedData;
    this.sizeOfUninitializedData = sizeOfUninitializedData;
    this.addressOfEntryPoint = addressOfEntryPoint;
    this.baseOfCode = baseOfCode;
    this.baseOfData = baseOfData;
    this.imageBase = imageBase;
    this.sectionAlignment = sectionAlignment;
    this.fileAlignment = fileAlignment;
    this.majorOsVersion = majorOsVersion;
    this.minorOsVersion = minorOsVersion;
    this.majorImageVersion = majorImageVersion;
    this.minorImageVersion = minorImageVersion;
    this.majorSubsystemVersion = majorSubsystemVersion;
    this.minorSubsystemVersion = minorSubsystemVersion;
    this.win32VersionValueHex = win32VersionValueHex;
    this.sizeOfImage = sizeOfImage;
    this.sizeOfHeaders = sizeOfHeaders;
    this.checksumHex = checksumHex;
    this.subsystemHex = subsystemHex;
    this.dllCharacteristicsHex = dllCharacteristicsHex;
    this.sizeOfStackReserve = sizeOfStackReserve;
    this.sizeOfStackCommit = sizeOfStackCommit;
    this.sizeOfHeapReserve = sizeOfHeapReserve;
    this.sizeOfHeapCommit = sizeOfHeapCommit;
    this.loaderFlagsHex = loaderFlagsHex;
    this.numberOfRvaAndSizes = numberOfRvaAndSizes;
    this.hashes = hashes;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code magicHex} attribute
   */
  @JsonProperty("magic_hex")
  @JsonPropertyDescription("Specifies the unsigned Optional<Integer> that indicates the type of the PE binary.")
  @Override
  public Optional<String> getMagicHex() {
    return Optional.ofNullable(magicHex);
  }

  /**
   * @return The value of the {@code majorLinkerVersion} attribute
   */
  @JsonProperty("major_linker_version")
  @JsonPropertyDescription("Specifies the linker major version number.")
  @Override
  public Optional<Long> getMajorLinkerVersion() {
    return Optional.ofNullable(majorLinkerVersion);
  }

  /**
   * @return The value of the {@code minorLinkerVersion} attribute
   */
  @JsonProperty("minor_linker_version")
  @JsonPropertyDescription("Specifies the linker minor version number.")
  @Override
  public Optional<Long> getMinorLinkerVersion() {
    return Optional.ofNullable(minorLinkerVersion);
  }

  /**
   * @return The value of the {@code sizeOfCode} attribute
   */
  @JsonProperty("size_of_code")
  @JsonPropertyDescription("Specifies the size of the code (text) section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
  @Override
  public Optional<Long> getSizeOfCode() {
    return Optional.ofNullable(sizeOfCode);
  }

  /**
   * @return The value of the {@code sizeOfInitializedData} attribute
   */
  @JsonProperty("size_of_initialized_data")
  @JsonPropertyDescription("Specifies the size of the initialized data section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
  @Override
  public Optional<Long> getSizeOfInitializedData() {
    return Optional.ofNullable(sizeOfInitializedData);
  }

  /**
   * @return The value of the {@code sizeOfUninitializedData} attribute
   */
  @JsonProperty("size_of_uninitialized_data")
  @JsonPropertyDescription("Specifies the size of the uninitialized data section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
  @Override
  public Optional<Long> getSizeOfUninitializedData() {
    return Optional.ofNullable(sizeOfUninitializedData);
  }

  /**
   * @return The value of the {@code addressOfEntryPoint} attribute
   */
  @JsonProperty("address_of_entry_point")
  @JsonPropertyDescription("Specifies the address of the entry point relative to the image base when the executable is loaded into memory.")
  @Override
  public Optional<Long> getAddressOfEntryPoint() {
    return Optional.ofNullable(addressOfEntryPoint);
  }

  /**
   * @return The value of the {@code baseOfCode} attribute
   */
  @JsonProperty("base_of_code")
  @JsonPropertyDescription("Specifies the address that is relative to the image base of the beginning-of-code section when it is loaded into memory.")
  @Override
  public Optional<Long> getBaseOfCode() {
    return Optional.ofNullable(baseOfCode);
  }

  /**
   * @return The value of the {@code baseOfData} attribute
   */
  @JsonProperty("base_of_data")
  @JsonPropertyDescription("Specifies the address that is relative to the image base of the beginning-of-data section when it is loaded into memory.")
  @Override
  public Optional<Long> getBaseOfData() {
    return Optional.ofNullable(baseOfData);
  }

  /**
   * @return The value of the {@code imageBase} attribute
   */
  @JsonProperty("image_base")
  @JsonPropertyDescription("Specifies the preferred address of the first byte of the image when loaded into memory.")
  @Override
  public Optional<Long> getImageBase() {
    return Optional.ofNullable(imageBase);
  }

  /**
   * @return The value of the {@code sectionAlignment} attribute
   */
  @JsonProperty("section_alignment")
  @JsonPropertyDescription("Specifies the alignment (in bytes) of PE sections when they are loaded into memory.")
  @Override
  public Optional<Long> getSectionAlignment() {
    return Optional.ofNullable(sectionAlignment);
  }

  /**
   * @return The value of the {@code fileAlignment} attribute
   */
  @JsonProperty("file_alignment")
  @JsonPropertyDescription("Specifies the factor (in bytes) that is used to align the raw data of sections in the image file.")
  @Override
  public Optional<Long> getFileAlignment() {
    return Optional.ofNullable(fileAlignment);
  }

  /**
   * @return The value of the {@code majorOsVersion} attribute
   */
  @JsonProperty("major_os_version")
  @JsonPropertyDescription("Specifies the major version number of the required operating system.")
  @Override
  public Optional<Long> getMajorOsVersion() {
    return Optional.ofNullable(majorOsVersion);
  }

  /**
   * @return The value of the {@code minorOsVersion} attribute
   */
  @JsonProperty("minor_os_version")
  @JsonPropertyDescription("Specifies the minor version number of the required operating system.")
  @Override
  public Optional<Long> getMinorOsVersion() {
    return Optional.ofNullable(minorOsVersion);
  }

  /**
   * @return The value of the {@code majorImageVersion} attribute
   */
  @JsonProperty("major_image_version")
  @JsonPropertyDescription("Specifies the major version number of the image.")
  @Override
  public Optional<Long> getMajorImageVersion() {
    return Optional.ofNullable(majorImageVersion);
  }

  /**
   * @return The value of the {@code minorImageVersion} attribute
   */
  @JsonProperty("minor_image_version")
  @JsonPropertyDescription("Specifies the minor version number of the image.")
  @Override
  public Optional<Long> getMinorImageVersion() {
    return Optional.ofNullable(minorImageVersion);
  }

  /**
   * @return The value of the {@code majorSubsystemVersion} attribute
   */
  @JsonProperty("major_subsystem_version")
  @JsonPropertyDescription("Specifies the major version number of the subsystem.")
  @Override
  public Optional<Long> getMajorSubsystemVersion() {
    return Optional.ofNullable(majorSubsystemVersion);
  }

  /**
   * @return The value of the {@code minorSubsystemVersion} attribute
   */
  @JsonProperty("minor_subsystem_version")
  @JsonPropertyDescription("Specifies the minor version number of the subsystem.")
  @Override
  public Optional<Long> getMinorSubsystemVersion() {
    return Optional.ofNullable(minorSubsystemVersion);
  }

  /**
   * @return The value of the {@code win32VersionValueHex} attribute
   */
  @JsonProperty("win32_version_value_hex")
  @JsonPropertyDescription("Specifies the reserved win32 version value.")
  @Override
  public Optional<String> getWin32VersionValueHex() {
    return Optional.ofNullable(win32VersionValueHex);
  }

  /**
   * @return The value of the {@code sizeOfImage} attribute
   */
  @JsonProperty("size_of_image")
  @JsonPropertyDescription("Specifies the size, in bytes, of the image, including all headers, as the image is loaded in memory.")
  @Override
  public Optional<Long> getSizeOfImage() {
    return Optional.ofNullable(sizeOfImage);
  }

  /**
   * @return The value of the {@code sizeOfHeaders} attribute
   */
  @JsonProperty("size_of_headers")
  @JsonPropertyDescription("Specifies the combined size of the MS-DOS, PE header, and section headers, rounded up a multiple of the value specified in the file_alignment header.")
  @Override
  public Optional<Long> getSizeOfHeaders() {
    return Optional.ofNullable(sizeOfHeaders);
  }

  /**
   * @return The value of the {@code checksumHex} attribute
   */
  @JsonProperty("checksum_hex")
  @JsonPropertyDescription("Specifies the checksum of the PE binary.")
  @Override
  public Optional<String> getChecksumHex() {
    return Optional.ofNullable(checksumHex);
  }

  /**
   * @return The value of the {@code subsystemHex} attribute
   */
  @JsonProperty("subsystem_hex")
  @JsonPropertyDescription("Specifies the subsystem (e.g., GUI, device driver, etc.) that is required to run this image.")
  @Override
  public Optional<String> getSubsystemHex() {
    return Optional.ofNullable(subsystemHex);
  }

  /**
   * @return The value of the {@code dllCharacteristicsHex} attribute
   */
  @JsonProperty("dll_characteristics_hex")
  @JsonPropertyDescription("Specifies the flags that characterize the PE binary.")
  @Override
  public Optional<String> getDllCharacteristicsHex() {
    return Optional.ofNullable(dllCharacteristicsHex);
  }

  /**
   * @return The value of the {@code sizeOfStackReserve} attribute
   */
  @JsonProperty("size_of_stack_reserve")
  @JsonPropertyDescription("Specifies the size of the stack to reserve")
  @Override
  public Optional<Long> getSizeOfStackReserve() {
    return Optional.ofNullable(sizeOfStackReserve);
  }

  /**
   * @return The value of the {@code sizeOfStackCommit} attribute
   */
  @JsonProperty("size_of_stack_commit")
  @JsonPropertyDescription("Specifies the size of the stack to commit.")
  @Override
  public Optional<Long> getSizeOfStackCommit() {
    return Optional.ofNullable(sizeOfStackCommit);
  }

  /**
   * @return The value of the {@code sizeOfHeapReserve} attribute
   */
  @JsonProperty("size_of_heap_reserve")
  @JsonPropertyDescription("Specifies the size of the local heap space to reserve.")
  @Override
  public Optional<Long> getSizeOfHeapReserve() {
    return Optional.ofNullable(sizeOfHeapReserve);
  }

  /**
   * @return The value of the {@code sizeOfHeapCommit} attribute
   */
  @JsonProperty("size_of_heap_commit")
  @JsonPropertyDescription("Specifies the size of the local heap space to commit.")
  @Override
  public Optional<Long> getSizeOfHeapCommit() {
    return Optional.ofNullable(sizeOfHeapCommit);
  }

  /**
   * @return The value of the {@code loaderFlagsHex} attribute
   */
  @JsonProperty("loader_flags_hex")
  @JsonPropertyDescription("Specifies the reserved loader flags.")
  @Override
  public Optional<String> getLoaderFlagsHex() {
    return Optional.ofNullable(loaderFlagsHex);
  }

  /**
   * @return The value of the {@code numberOfRvaAndSizes} attribute
   */
  @JsonProperty("number_of_rva_and_sizes")
  @JsonPropertyDescription("Specifies the number of data-directory entries in the remainder of the optional header.")
  @Override
  public Optional<Long> getNumberOfRvaAndSizes() {
    return Optional.ofNullable(numberOfRvaAndSizes);
  }

  /**
   * @return The value of the {@code hashes} attribute
   */
  @JsonProperty("hashes")
  @JsonPropertyDescription("Specifies any hashes that were computed for the optional header.")
  @Override
  public ImmutableMap<String, String> getHashes() {
    return hashes;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getMagicHex() magicHex} attribute.
   * @param value The value for magicHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMagicHex(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "magicHex");
    if (Objects.equals(this.magicHex, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        newValue,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getMagicHex() magicHex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for magicHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMagicHex(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.magicHex, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        value,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getMajorLinkerVersion() majorLinkerVersion} attribute.
   * @param value The value for majorLinkerVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMajorLinkerVersion(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.majorLinkerVersion, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        newValue,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getMajorLinkerVersion() majorLinkerVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for majorLinkerVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMajorLinkerVersion(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.majorLinkerVersion, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        value,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getMinorLinkerVersion() minorLinkerVersion} attribute.
   * @param value The value for minorLinkerVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMinorLinkerVersion(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.minorLinkerVersion, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        newValue,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getMinorLinkerVersion() minorLinkerVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for minorLinkerVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMinorLinkerVersion(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.minorLinkerVersion, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        value,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getSizeOfCode() sizeOfCode} attribute.
   * @param value The value for sizeOfCode
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfCode(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.sizeOfCode, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        newValue,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getSizeOfCode() sizeOfCode} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sizeOfCode
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfCode(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.sizeOfCode, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        value,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getSizeOfInitializedData() sizeOfInitializedData} attribute.
   * @param value The value for sizeOfInitializedData
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfInitializedData(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.sizeOfInitializedData, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        newValue,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getSizeOfInitializedData() sizeOfInitializedData} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sizeOfInitializedData
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfInitializedData(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.sizeOfInitializedData, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        value,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getSizeOfUninitializedData() sizeOfUninitializedData} attribute.
   * @param value The value for sizeOfUninitializedData
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfUninitializedData(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.sizeOfUninitializedData, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        newValue,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getSizeOfUninitializedData() sizeOfUninitializedData} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sizeOfUninitializedData
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfUninitializedData(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.sizeOfUninitializedData, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        value,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getAddressOfEntryPoint() addressOfEntryPoint} attribute.
   * @param value The value for addressOfEntryPoint
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withAddressOfEntryPoint(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.addressOfEntryPoint, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        newValue,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getAddressOfEntryPoint() addressOfEntryPoint} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for addressOfEntryPoint
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withAddressOfEntryPoint(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.addressOfEntryPoint, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        value,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getBaseOfCode() baseOfCode} attribute.
   * @param value The value for baseOfCode
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withBaseOfCode(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.baseOfCode, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        newValue,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getBaseOfCode() baseOfCode} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for baseOfCode
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withBaseOfCode(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.baseOfCode, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        value,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getBaseOfData() baseOfData} attribute.
   * @param value The value for baseOfData
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withBaseOfData(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.baseOfData, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        newValue,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getBaseOfData() baseOfData} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for baseOfData
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withBaseOfData(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.baseOfData, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        value,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getImageBase() imageBase} attribute.
   * @param value The value for imageBase
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withImageBase(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.imageBase, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        newValue,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getImageBase() imageBase} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for imageBase
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withImageBase(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.imageBase, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        value,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getSectionAlignment() sectionAlignment} attribute.
   * @param value The value for sectionAlignment
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSectionAlignment(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.sectionAlignment, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        newValue,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getSectionAlignment() sectionAlignment} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sectionAlignment
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSectionAlignment(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.sectionAlignment, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        value,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getFileAlignment() fileAlignment} attribute.
   * @param value The value for fileAlignment
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withFileAlignment(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.fileAlignment, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        newValue,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getFileAlignment() fileAlignment} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for fileAlignment
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withFileAlignment(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.fileAlignment, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        value,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getMajorOsVersion() majorOsVersion} attribute.
   * @param value The value for majorOsVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMajorOsVersion(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.majorOsVersion, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        newValue,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getMajorOsVersion() majorOsVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for majorOsVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMajorOsVersion(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.majorOsVersion, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        value,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getMinorOsVersion() minorOsVersion} attribute.
   * @param value The value for minorOsVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMinorOsVersion(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.minorOsVersion, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        newValue,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getMinorOsVersion() minorOsVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for minorOsVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMinorOsVersion(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.minorOsVersion, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        value,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getMajorImageVersion() majorImageVersion} attribute.
   * @param value The value for majorImageVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMajorImageVersion(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.majorImageVersion, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        newValue,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getMajorImageVersion() majorImageVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for majorImageVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMajorImageVersion(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.majorImageVersion, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        value,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getMinorImageVersion() minorImageVersion} attribute.
   * @param value The value for minorImageVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMinorImageVersion(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.minorImageVersion, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        newValue,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getMinorImageVersion() minorImageVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for minorImageVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMinorImageVersion(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.minorImageVersion, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        value,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getMajorSubsystemVersion() majorSubsystemVersion} attribute.
   * @param value The value for majorSubsystemVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMajorSubsystemVersion(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.majorSubsystemVersion, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        newValue,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getMajorSubsystemVersion() majorSubsystemVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for majorSubsystemVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMajorSubsystemVersion(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.majorSubsystemVersion, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        value,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getMinorSubsystemVersion() minorSubsystemVersion} attribute.
   * @param value The value for minorSubsystemVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMinorSubsystemVersion(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.minorSubsystemVersion, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        newValue,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getMinorSubsystemVersion() minorSubsystemVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for minorSubsystemVersion
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withMinorSubsystemVersion(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.minorSubsystemVersion, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        value,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getWin32VersionValueHex() win32VersionValueHex} attribute.
   * @param value The value for win32VersionValueHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withWin32VersionValueHex(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "win32VersionValueHex");
    if (Objects.equals(this.win32VersionValueHex, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        newValue,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getWin32VersionValueHex() win32VersionValueHex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for win32VersionValueHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withWin32VersionValueHex(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.win32VersionValueHex, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        value,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getSizeOfImage() sizeOfImage} attribute.
   * @param value The value for sizeOfImage
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfImage(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.sizeOfImage, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        newValue,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getSizeOfImage() sizeOfImage} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sizeOfImage
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfImage(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.sizeOfImage, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        value,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getSizeOfHeaders() sizeOfHeaders} attribute.
   * @param value The value for sizeOfHeaders
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfHeaders(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.sizeOfHeaders, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        newValue,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getSizeOfHeaders() sizeOfHeaders} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sizeOfHeaders
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfHeaders(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.sizeOfHeaders, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        value,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getChecksumHex() checksumHex} attribute.
   * @param value The value for checksumHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withChecksumHex(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "checksumHex");
    if (Objects.equals(this.checksumHex, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        newValue,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getChecksumHex() checksumHex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for checksumHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withChecksumHex(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.checksumHex, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        value,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getSubsystemHex() subsystemHex} attribute.
   * @param value The value for subsystemHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSubsystemHex(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "subsystemHex");
    if (Objects.equals(this.subsystemHex, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        newValue,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getSubsystemHex() subsystemHex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subsystemHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSubsystemHex(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.subsystemHex, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        value,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getDllCharacteristicsHex() dllCharacteristicsHex} attribute.
   * @param value The value for dllCharacteristicsHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withDllCharacteristicsHex(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "dllCharacteristicsHex");
    if (Objects.equals(this.dllCharacteristicsHex, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        newValue,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getDllCharacteristicsHex() dllCharacteristicsHex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dllCharacteristicsHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withDllCharacteristicsHex(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.dllCharacteristicsHex, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        value,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getSizeOfStackReserve() sizeOfStackReserve} attribute.
   * @param value The value for sizeOfStackReserve
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfStackReserve(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.sizeOfStackReserve, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        newValue,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getSizeOfStackReserve() sizeOfStackReserve} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sizeOfStackReserve
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfStackReserve(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.sizeOfStackReserve, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        value,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getSizeOfStackCommit() sizeOfStackCommit} attribute.
   * @param value The value for sizeOfStackCommit
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfStackCommit(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.sizeOfStackCommit, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        newValue,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getSizeOfStackCommit() sizeOfStackCommit} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sizeOfStackCommit
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfStackCommit(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.sizeOfStackCommit, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        value,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getSizeOfHeapReserve() sizeOfHeapReserve} attribute.
   * @param value The value for sizeOfHeapReserve
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfHeapReserve(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.sizeOfHeapReserve, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        newValue,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getSizeOfHeapReserve() sizeOfHeapReserve} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sizeOfHeapReserve
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfHeapReserve(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.sizeOfHeapReserve, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        value,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getSizeOfHeapCommit() sizeOfHeapCommit} attribute.
   * @param value The value for sizeOfHeapCommit
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfHeapCommit(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.sizeOfHeapCommit, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        newValue,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getSizeOfHeapCommit() sizeOfHeapCommit} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sizeOfHeapCommit
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withSizeOfHeapCommit(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.sizeOfHeapCommit, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        value,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getLoaderFlagsHex() loaderFlagsHex} attribute.
   * @param value The value for loaderFlagsHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withLoaderFlagsHex(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "loaderFlagsHex");
    if (Objects.equals(this.loaderFlagsHex, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        newValue,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getLoaderFlagsHex() loaderFlagsHex} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for loaderFlagsHex
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withLoaderFlagsHex(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.loaderFlagsHex, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        value,
        this.numberOfRvaAndSizes,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeOptionalHeaderObj#getNumberOfRvaAndSizes() numberOfRvaAndSizes} attribute.
   * @param value The value for numberOfRvaAndSizes
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withNumberOfRvaAndSizes(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.numberOfRvaAndSizes, newValue)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        newValue,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeOptionalHeaderObj#getNumberOfRvaAndSizes() numberOfRvaAndSizes} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for numberOfRvaAndSizes
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withNumberOfRvaAndSizes(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.numberOfRvaAndSizes, value)) return this;
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        value,
        this.hashes,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link WindowsPeOptionalHeaderObj#getHashes() hashes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the hashes map
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withHashes(Map<String, ? extends String> entries) {
    if (this.hashes == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        newValue,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link WindowsPeOptionalHeaderObj#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeOptionalHeader withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new WindowsPeOptionalHeader(
        this.magicHex,
        this.majorLinkerVersion,
        this.minorLinkerVersion,
        this.sizeOfCode,
        this.sizeOfInitializedData,
        this.sizeOfUninitializedData,
        this.addressOfEntryPoint,
        this.baseOfCode,
        this.baseOfData,
        this.imageBase,
        this.sectionAlignment,
        this.fileAlignment,
        this.majorOsVersion,
        this.minorOsVersion,
        this.majorImageVersion,
        this.minorImageVersion,
        this.majorSubsystemVersion,
        this.minorSubsystemVersion,
        this.win32VersionValueHex,
        this.sizeOfImage,
        this.sizeOfHeaders,
        this.checksumHex,
        this.subsystemHex,
        this.dllCharacteristicsHex,
        this.sizeOfStackReserve,
        this.sizeOfStackCommit,
        this.sizeOfHeapReserve,
        this.sizeOfHeapCommit,
        this.loaderFlagsHex,
        this.numberOfRvaAndSizes,
        this.hashes,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code WindowsPeOptionalHeader} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof WindowsPeOptionalHeader
        && equalTo((WindowsPeOptionalHeader) another);
  }

  private boolean equalTo(WindowsPeOptionalHeader another) {
    return Objects.equals(magicHex, another.magicHex)
        && Objects.equals(majorLinkerVersion, another.majorLinkerVersion)
        && Objects.equals(minorLinkerVersion, another.minorLinkerVersion)
        && Objects.equals(sizeOfCode, another.sizeOfCode)
        && Objects.equals(sizeOfInitializedData, another.sizeOfInitializedData)
        && Objects.equals(sizeOfUninitializedData, another.sizeOfUninitializedData)
        && Objects.equals(addressOfEntryPoint, another.addressOfEntryPoint)
        && Objects.equals(baseOfCode, another.baseOfCode)
        && Objects.equals(baseOfData, another.baseOfData)
        && Objects.equals(imageBase, another.imageBase)
        && Objects.equals(sectionAlignment, another.sectionAlignment)
        && Objects.equals(fileAlignment, another.fileAlignment)
        && Objects.equals(majorOsVersion, another.majorOsVersion)
        && Objects.equals(minorOsVersion, another.minorOsVersion)
        && Objects.equals(majorImageVersion, another.majorImageVersion)
        && Objects.equals(minorImageVersion, another.minorImageVersion)
        && Objects.equals(majorSubsystemVersion, another.majorSubsystemVersion)
        && Objects.equals(minorSubsystemVersion, another.minorSubsystemVersion)
        && Objects.equals(win32VersionValueHex, another.win32VersionValueHex)
        && Objects.equals(sizeOfImage, another.sizeOfImage)
        && Objects.equals(sizeOfHeaders, another.sizeOfHeaders)
        && Objects.equals(checksumHex, another.checksumHex)
        && Objects.equals(subsystemHex, another.subsystemHex)
        && Objects.equals(dllCharacteristicsHex, another.dllCharacteristicsHex)
        && Objects.equals(sizeOfStackReserve, another.sizeOfStackReserve)
        && Objects.equals(sizeOfStackCommit, another.sizeOfStackCommit)
        && Objects.equals(sizeOfHeapReserve, another.sizeOfHeapReserve)
        && Objects.equals(sizeOfHeapCommit, another.sizeOfHeapCommit)
        && Objects.equals(loaderFlagsHex, another.loaderFlagsHex)
        && Objects.equals(numberOfRvaAndSizes, another.numberOfRvaAndSizes)
        && hashes.equals(another.hashes)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code magicHex}, {@code majorLinkerVersion}, {@code minorLinkerVersion}, {@code sizeOfCode}, {@code sizeOfInitializedData}, {@code sizeOfUninitializedData}, {@code addressOfEntryPoint}, {@code baseOfCode}, {@code baseOfData}, {@code imageBase}, {@code sectionAlignment}, {@code fileAlignment}, {@code majorOsVersion}, {@code minorOsVersion}, {@code majorImageVersion}, {@code minorImageVersion}, {@code majorSubsystemVersion}, {@code minorSubsystemVersion}, {@code win32VersionValueHex}, {@code sizeOfImage}, {@code sizeOfHeaders}, {@code checksumHex}, {@code subsystemHex}, {@code dllCharacteristicsHex}, {@code sizeOfStackReserve}, {@code sizeOfStackCommit}, {@code sizeOfHeapReserve}, {@code sizeOfHeapCommit}, {@code loaderFlagsHex}, {@code numberOfRvaAndSizes}, {@code hashes}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(magicHex);
    h += (h << 5) + Objects.hashCode(majorLinkerVersion);
    h += (h << 5) + Objects.hashCode(minorLinkerVersion);
    h += (h << 5) + Objects.hashCode(sizeOfCode);
    h += (h << 5) + Objects.hashCode(sizeOfInitializedData);
    h += (h << 5) + Objects.hashCode(sizeOfUninitializedData);
    h += (h << 5) + Objects.hashCode(addressOfEntryPoint);
    h += (h << 5) + Objects.hashCode(baseOfCode);
    h += (h << 5) + Objects.hashCode(baseOfData);
    h += (h << 5) + Objects.hashCode(imageBase);
    h += (h << 5) + Objects.hashCode(sectionAlignment);
    h += (h << 5) + Objects.hashCode(fileAlignment);
    h += (h << 5) + Objects.hashCode(majorOsVersion);
    h += (h << 5) + Objects.hashCode(minorOsVersion);
    h += (h << 5) + Objects.hashCode(majorImageVersion);
    h += (h << 5) + Objects.hashCode(minorImageVersion);
    h += (h << 5) + Objects.hashCode(majorSubsystemVersion);
    h += (h << 5) + Objects.hashCode(minorSubsystemVersion);
    h += (h << 5) + Objects.hashCode(win32VersionValueHex);
    h += (h << 5) + Objects.hashCode(sizeOfImage);
    h += (h << 5) + Objects.hashCode(sizeOfHeaders);
    h += (h << 5) + Objects.hashCode(checksumHex);
    h += (h << 5) + Objects.hashCode(subsystemHex);
    h += (h << 5) + Objects.hashCode(dllCharacteristicsHex);
    h += (h << 5) + Objects.hashCode(sizeOfStackReserve);
    h += (h << 5) + Objects.hashCode(sizeOfStackCommit);
    h += (h << 5) + Objects.hashCode(sizeOfHeapReserve);
    h += (h << 5) + Objects.hashCode(sizeOfHeapCommit);
    h += (h << 5) + Objects.hashCode(loaderFlagsHex);
    h += (h << 5) + Objects.hashCode(numberOfRvaAndSizes);
    h += (h << 5) + hashes.hashCode();
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WindowsPeOptionalHeader} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WindowsPeOptionalHeader")
        .omitNullValues()
        .add("magicHex", magicHex)
        .add("majorLinkerVersion", majorLinkerVersion)
        .add("minorLinkerVersion", minorLinkerVersion)
        .add("sizeOfCode", sizeOfCode)
        .add("sizeOfInitializedData", sizeOfInitializedData)
        .add("sizeOfUninitializedData", sizeOfUninitializedData)
        .add("addressOfEntryPoint", addressOfEntryPoint)
        .add("baseOfCode", baseOfCode)
        .add("baseOfData", baseOfData)
        .add("imageBase", imageBase)
        .add("sectionAlignment", sectionAlignment)
        .add("fileAlignment", fileAlignment)
        .add("majorOsVersion", majorOsVersion)
        .add("minorOsVersion", minorOsVersion)
        .add("majorImageVersion", majorImageVersion)
        .add("minorImageVersion", minorImageVersion)
        .add("majorSubsystemVersion", majorSubsystemVersion)
        .add("minorSubsystemVersion", minorSubsystemVersion)
        .add("win32VersionValueHex", win32VersionValueHex)
        .add("sizeOfImage", sizeOfImage)
        .add("sizeOfHeaders", sizeOfHeaders)
        .add("checksumHex", checksumHex)
        .add("subsystemHex", subsystemHex)
        .add("dllCharacteristicsHex", dllCharacteristicsHex)
        .add("sizeOfStackReserve", sizeOfStackReserve)
        .add("sizeOfStackCommit", sizeOfStackCommit)
        .add("sizeOfHeapReserve", sizeOfHeapReserve)
        .add("sizeOfHeapCommit", sizeOfHeapCommit)
        .add("loaderFlagsHex", loaderFlagsHex)
        .add("numberOfRvaAndSizes", numberOfRvaAndSizes)
        .add("hashes", hashes)
        .add("customProperties", customProperties)
        .toString();
  }


  private static WindowsPeOptionalHeader validate(WindowsPeOptionalHeader instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link WindowsPeOptionalHeaderObj} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WindowsPeOptionalHeader instance
   */
  public static WindowsPeOptionalHeader copyOf(WindowsPeOptionalHeaderObj instance) {
    if (instance instanceof WindowsPeOptionalHeader) {
      return (WindowsPeOptionalHeader) instance;
    }
    return WindowsPeOptionalHeader.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link WindowsPeOptionalHeader WindowsPeOptionalHeader}.
   * @return A new WindowsPeOptionalHeader builder
   */
  public static WindowsPeOptionalHeader.Builder builder() {
    return new WindowsPeOptionalHeader.Builder();
  }

  /**
   * Builds instances of type {@link WindowsPeOptionalHeader WindowsPeOptionalHeader}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WindowsPeOptionalHeaderObj", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"magic_hex", "major_linker_version", "minor_linker_version", "size_of_code", "size_of_initialized_data", "size_of_uninitialized_data", "address_of_entry_point", "base_of_code", "base_of_data", "image_base", "section_alignment", "file_alignment", "major_os_version", "minor_os_version", "major_image_version", "minor_image_version", "major_subsystem_version", "minor_subsystem_version", "win32_version_value_hex", "size_of_image", "size_of_headers", "checksum_hex", "subsystem_hex", "dll_characteristics_hex", "size_of_stack_reserve", "size_of_stack_commit", "size_of_heap_reserve", "size_of_heap_commit", "loader_flags_hex", "number_of_rva_and_sizes", "hashes"})
  public static final class Builder {
    private @Nullable String magicHex;
    private @Nullable Long majorLinkerVersion;
    private @Nullable Long minorLinkerVersion;
    private @Nullable Long sizeOfCode;
    private @Nullable Long sizeOfInitializedData;
    private @Nullable Long sizeOfUninitializedData;
    private @Nullable Long addressOfEntryPoint;
    private @Nullable Long baseOfCode;
    private @Nullable Long baseOfData;
    private @Nullable Long imageBase;
    private @Nullable Long sectionAlignment;
    private @Nullable Long fileAlignment;
    private @Nullable Long majorOsVersion;
    private @Nullable Long minorOsVersion;
    private @Nullable Long majorImageVersion;
    private @Nullable Long minorImageVersion;
    private @Nullable Long majorSubsystemVersion;
    private @Nullable Long minorSubsystemVersion;
    private @Nullable String win32VersionValueHex;
    private @Nullable Long sizeOfImage;
    private @Nullable Long sizeOfHeaders;
    private @Nullable String checksumHex;
    private @Nullable String subsystemHex;
    private @Nullable String dllCharacteristicsHex;
    private @Nullable Long sizeOfStackReserve;
    private @Nullable Long sizeOfStackCommit;
    private @Nullable Long sizeOfHeapReserve;
    private @Nullable Long sizeOfHeapCommit;
    private @Nullable String loaderFlagsHex;
    private @Nullable Long numberOfRvaAndSizes;
    private ImmutableMap.Builder<String, String> hashes = ImmutableMap.builder();
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.types.WindowsPeOptionalHeaderObj} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WindowsPeOptionalHeaderObj instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof WindowsPeOptionalHeaderObj) {
        WindowsPeOptionalHeaderObj instance = (WindowsPeOptionalHeaderObj) object;
        Optional<Long> baseOfCodeOptional = instance.getBaseOfCode();
        if (baseOfCodeOptional.isPresent()) {
          baseOfCode(baseOfCodeOptional);
        }
        Optional<Long> majorSubsystemVersionOptional = instance.getMajorSubsystemVersion();
        if (majorSubsystemVersionOptional.isPresent()) {
          majorSubsystemVersion(majorSubsystemVersionOptional);
        }
        Optional<Long> sizeOfStackReserveOptional = instance.getSizeOfStackReserve();
        if (sizeOfStackReserveOptional.isPresent()) {
          sizeOfStackReserve(sizeOfStackReserveOptional);
        }
        Optional<Long> sizeOfCodeOptional = instance.getSizeOfCode();
        if (sizeOfCodeOptional.isPresent()) {
          sizeOfCode(sizeOfCodeOptional);
        }
        Optional<Long> minorSubsystemVersionOptional = instance.getMinorSubsystemVersion();
        if (minorSubsystemVersionOptional.isPresent()) {
          minorSubsystemVersion(minorSubsystemVersionOptional);
        }
        Optional<Long> baseOfDataOptional = instance.getBaseOfData();
        if (baseOfDataOptional.isPresent()) {
          baseOfData(baseOfDataOptional);
        }
        Optional<Long> majorImageVersionOptional = instance.getMajorImageVersion();
        if (majorImageVersionOptional.isPresent()) {
          majorImageVersion(majorImageVersionOptional);
        }
        Optional<Long> minorImageVersionOptional = instance.getMinorImageVersion();
        if (minorImageVersionOptional.isPresent()) {
          minorImageVersion(minorImageVersionOptional);
        }
        Optional<Long> sizeOfHeadersOptional = instance.getSizeOfHeaders();
        if (sizeOfHeadersOptional.isPresent()) {
          sizeOfHeaders(sizeOfHeadersOptional);
        }
        Optional<Long> majorLinkerVersionOptional = instance.getMajorLinkerVersion();
        if (majorLinkerVersionOptional.isPresent()) {
          majorLinkerVersion(majorLinkerVersionOptional);
        }
        Optional<Long> sizeOfInitializedDataOptional = instance.getSizeOfInitializedData();
        if (sizeOfInitializedDataOptional.isPresent()) {
          sizeOfInitializedData(sizeOfInitializedDataOptional);
        }
        Optional<Long> minorOsVersionOptional = instance.getMinorOsVersion();
        if (minorOsVersionOptional.isPresent()) {
          minorOsVersion(minorOsVersionOptional);
        }
        Optional<String> subsystemHexOptional = instance.getSubsystemHex();
        if (subsystemHexOptional.isPresent()) {
          subsystemHex(subsystemHexOptional);
        }
        Optional<String> dllCharacteristicsHexOptional = instance.getDllCharacteristicsHex();
        if (dllCharacteristicsHexOptional.isPresent()) {
          dllCharacteristicsHex(dllCharacteristicsHexOptional);
        }
        Optional<Long> imageBaseOptional = instance.getImageBase();
        if (imageBaseOptional.isPresent()) {
          imageBase(imageBaseOptional);
        }
        Optional<String> loaderFlagsHexOptional = instance.getLoaderFlagsHex();
        if (loaderFlagsHexOptional.isPresent()) {
          loaderFlagsHex(loaderFlagsHexOptional);
        }
        Optional<Long> sectionAlignmentOptional = instance.getSectionAlignment();
        if (sectionAlignmentOptional.isPresent()) {
          sectionAlignment(sectionAlignmentOptional);
        }
        Optional<Long> sizeOfHeapReserveOptional = instance.getSizeOfHeapReserve();
        if (sizeOfHeapReserveOptional.isPresent()) {
          sizeOfHeapReserve(sizeOfHeapReserveOptional);
        }
        Optional<Long> fileAlignmentOptional = instance.getFileAlignment();
        if (fileAlignmentOptional.isPresent()) {
          fileAlignment(fileAlignmentOptional);
        }
        Optional<Long> sizeOfImageOptional = instance.getSizeOfImage();
        if (sizeOfImageOptional.isPresent()) {
          sizeOfImage(sizeOfImageOptional);
        }
        Optional<Long> majorOsVersionOptional = instance.getMajorOsVersion();
        if (majorOsVersionOptional.isPresent()) {
          majorOsVersion(majorOsVersionOptional);
        }
        Optional<Long> sizeOfHeapCommitOptional = instance.getSizeOfHeapCommit();
        if (sizeOfHeapCommitOptional.isPresent()) {
          sizeOfHeapCommit(sizeOfHeapCommitOptional);
        }
        Optional<String> checksumHexOptional = instance.getChecksumHex();
        if (checksumHexOptional.isPresent()) {
          checksumHex(checksumHexOptional);
        }
        Optional<String> win32VersionValueHexOptional = instance.getWin32VersionValueHex();
        if (win32VersionValueHexOptional.isPresent()) {
          win32VersionValueHex(win32VersionValueHexOptional);
        }
        Optional<Long> sizeOfUninitializedDataOptional = instance.getSizeOfUninitializedData();
        if (sizeOfUninitializedDataOptional.isPresent()) {
          sizeOfUninitializedData(sizeOfUninitializedDataOptional);
        }
        Optional<Long> minorLinkerVersionOptional = instance.getMinorLinkerVersion();
        if (minorLinkerVersionOptional.isPresent()) {
          minorLinkerVersion(minorLinkerVersionOptional);
        }
        putAllHashes(instance.getHashes());
        Optional<String> magicHexOptional = instance.getMagicHex();
        if (magicHexOptional.isPresent()) {
          magicHex(magicHexOptional);
        }
        Optional<Long> addressOfEntryPointOptional = instance.getAddressOfEntryPoint();
        if (addressOfEntryPointOptional.isPresent()) {
          addressOfEntryPoint(addressOfEntryPointOptional);
        }
        Optional<Long> numberOfRvaAndSizesOptional = instance.getNumberOfRvaAndSizes();
        if (numberOfRvaAndSizesOptional.isPresent()) {
          numberOfRvaAndSizes(numberOfRvaAndSizesOptional);
        }
        Optional<Long> sizeOfStackCommitOptional = instance.getSizeOfStackCommit();
        if (sizeOfStackCommitOptional.isPresent()) {
          sizeOfStackCommit(sizeOfStackCommitOptional);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMagicHex() magicHex} to magicHex.
     * @param magicHex The value for magicHex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder magicHex(String magicHex) {
      this.magicHex = Objects.requireNonNull(magicHex, "magicHex");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMagicHex() magicHex} to magicHex.
     * @param magicHex The value for magicHex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("magic_hex")
    @JsonPropertyDescription("Specifies the unsigned Optional<Integer> that indicates the type of the PE binary.")
    public final Builder magicHex(Optional<String> magicHex) {
      this.magicHex = magicHex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMajorLinkerVersion() majorLinkerVersion} to majorLinkerVersion.
     * @param majorLinkerVersion The value for majorLinkerVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder majorLinkerVersion(long majorLinkerVersion) {
      this.majorLinkerVersion = majorLinkerVersion;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMajorLinkerVersion() majorLinkerVersion} to majorLinkerVersion.
     * @param majorLinkerVersion The value for majorLinkerVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("major_linker_version")
    @JsonPropertyDescription("Specifies the linker major version number.")
    public final Builder majorLinkerVersion(Optional<Long> majorLinkerVersion) {
      this.majorLinkerVersion = majorLinkerVersion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMinorLinkerVersion() minorLinkerVersion} to minorLinkerVersion.
     * @param minorLinkerVersion The value for minorLinkerVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder minorLinkerVersion(long minorLinkerVersion) {
      this.minorLinkerVersion = minorLinkerVersion;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMinorLinkerVersion() minorLinkerVersion} to minorLinkerVersion.
     * @param minorLinkerVersion The value for minorLinkerVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("minor_linker_version")
    @JsonPropertyDescription("Specifies the linker minor version number.")
    public final Builder minorLinkerVersion(Optional<Long> minorLinkerVersion) {
      this.minorLinkerVersion = minorLinkerVersion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfCode() sizeOfCode} to sizeOfCode.
     * @param sizeOfCode The value for sizeOfCode
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sizeOfCode(long sizeOfCode) {
      this.sizeOfCode = sizeOfCode;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfCode() sizeOfCode} to sizeOfCode.
     * @param sizeOfCode The value for sizeOfCode
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size_of_code")
    @JsonPropertyDescription("Specifies the size of the code (text) section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
    public final Builder sizeOfCode(Optional<Long> sizeOfCode) {
      this.sizeOfCode = sizeOfCode.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfInitializedData() sizeOfInitializedData} to sizeOfInitializedData.
     * @param sizeOfInitializedData The value for sizeOfInitializedData
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sizeOfInitializedData(long sizeOfInitializedData) {
      this.sizeOfInitializedData = sizeOfInitializedData;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfInitializedData() sizeOfInitializedData} to sizeOfInitializedData.
     * @param sizeOfInitializedData The value for sizeOfInitializedData
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size_of_initialized_data")
    @JsonPropertyDescription("Specifies the size of the initialized data section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
    public final Builder sizeOfInitializedData(Optional<Long> sizeOfInitializedData) {
      this.sizeOfInitializedData = sizeOfInitializedData.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfUninitializedData() sizeOfUninitializedData} to sizeOfUninitializedData.
     * @param sizeOfUninitializedData The value for sizeOfUninitializedData
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sizeOfUninitializedData(long sizeOfUninitializedData) {
      this.sizeOfUninitializedData = sizeOfUninitializedData;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfUninitializedData() sizeOfUninitializedData} to sizeOfUninitializedData.
     * @param sizeOfUninitializedData The value for sizeOfUninitializedData
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size_of_uninitialized_data")
    @JsonPropertyDescription("Specifies the size of the uninitialized data section. If there are multiple such sections, this refers to the sum of the sizes of each section.")
    public final Builder sizeOfUninitializedData(Optional<Long> sizeOfUninitializedData) {
      this.sizeOfUninitializedData = sizeOfUninitializedData.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getAddressOfEntryPoint() addressOfEntryPoint} to addressOfEntryPoint.
     * @param addressOfEntryPoint The value for addressOfEntryPoint
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addressOfEntryPoint(long addressOfEntryPoint) {
      this.addressOfEntryPoint = addressOfEntryPoint;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getAddressOfEntryPoint() addressOfEntryPoint} to addressOfEntryPoint.
     * @param addressOfEntryPoint The value for addressOfEntryPoint
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("address_of_entry_point")
    @JsonPropertyDescription("Specifies the address of the entry point relative to the image base when the executable is loaded into memory.")
    public final Builder addressOfEntryPoint(Optional<Long> addressOfEntryPoint) {
      this.addressOfEntryPoint = addressOfEntryPoint.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getBaseOfCode() baseOfCode} to baseOfCode.
     * @param baseOfCode The value for baseOfCode
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder baseOfCode(long baseOfCode) {
      this.baseOfCode = baseOfCode;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getBaseOfCode() baseOfCode} to baseOfCode.
     * @param baseOfCode The value for baseOfCode
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("base_of_code")
    @JsonPropertyDescription("Specifies the address that is relative to the image base of the beginning-of-code section when it is loaded into memory.")
    public final Builder baseOfCode(Optional<Long> baseOfCode) {
      this.baseOfCode = baseOfCode.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getBaseOfData() baseOfData} to baseOfData.
     * @param baseOfData The value for baseOfData
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder baseOfData(long baseOfData) {
      this.baseOfData = baseOfData;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getBaseOfData() baseOfData} to baseOfData.
     * @param baseOfData The value for baseOfData
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("base_of_data")
    @JsonPropertyDescription("Specifies the address that is relative to the image base of the beginning-of-data section when it is loaded into memory.")
    public final Builder baseOfData(Optional<Long> baseOfData) {
      this.baseOfData = baseOfData.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getImageBase() imageBase} to imageBase.
     * @param imageBase The value for imageBase
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder imageBase(long imageBase) {
      this.imageBase = imageBase;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getImageBase() imageBase} to imageBase.
     * @param imageBase The value for imageBase
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("image_base")
    @JsonPropertyDescription("Specifies the preferred address of the first byte of the image when loaded into memory.")
    public final Builder imageBase(Optional<Long> imageBase) {
      this.imageBase = imageBase.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSectionAlignment() sectionAlignment} to sectionAlignment.
     * @param sectionAlignment The value for sectionAlignment
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sectionAlignment(long sectionAlignment) {
      this.sectionAlignment = sectionAlignment;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSectionAlignment() sectionAlignment} to sectionAlignment.
     * @param sectionAlignment The value for sectionAlignment
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("section_alignment")
    @JsonPropertyDescription("Specifies the alignment (in bytes) of PE sections when they are loaded into memory.")
    public final Builder sectionAlignment(Optional<Long> sectionAlignment) {
      this.sectionAlignment = sectionAlignment.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getFileAlignment() fileAlignment} to fileAlignment.
     * @param fileAlignment The value for fileAlignment
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fileAlignment(long fileAlignment) {
      this.fileAlignment = fileAlignment;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getFileAlignment() fileAlignment} to fileAlignment.
     * @param fileAlignment The value for fileAlignment
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("file_alignment")
    @JsonPropertyDescription("Specifies the factor (in bytes) that is used to align the raw data of sections in the image file.")
    public final Builder fileAlignment(Optional<Long> fileAlignment) {
      this.fileAlignment = fileAlignment.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMajorOsVersion() majorOsVersion} to majorOsVersion.
     * @param majorOsVersion The value for majorOsVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder majorOsVersion(long majorOsVersion) {
      this.majorOsVersion = majorOsVersion;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMajorOsVersion() majorOsVersion} to majorOsVersion.
     * @param majorOsVersion The value for majorOsVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("major_os_version")
    @JsonPropertyDescription("Specifies the major version number of the required operating system.")
    public final Builder majorOsVersion(Optional<Long> majorOsVersion) {
      this.majorOsVersion = majorOsVersion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMinorOsVersion() minorOsVersion} to minorOsVersion.
     * @param minorOsVersion The value for minorOsVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder minorOsVersion(long minorOsVersion) {
      this.minorOsVersion = minorOsVersion;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMinorOsVersion() minorOsVersion} to minorOsVersion.
     * @param minorOsVersion The value for minorOsVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("minor_os_version")
    @JsonPropertyDescription("Specifies the minor version number of the required operating system.")
    public final Builder minorOsVersion(Optional<Long> minorOsVersion) {
      this.minorOsVersion = minorOsVersion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMajorImageVersion() majorImageVersion} to majorImageVersion.
     * @param majorImageVersion The value for majorImageVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder majorImageVersion(long majorImageVersion) {
      this.majorImageVersion = majorImageVersion;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMajorImageVersion() majorImageVersion} to majorImageVersion.
     * @param majorImageVersion The value for majorImageVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("major_image_version")
    @JsonPropertyDescription("Specifies the major version number of the image.")
    public final Builder majorImageVersion(Optional<Long> majorImageVersion) {
      this.majorImageVersion = majorImageVersion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMinorImageVersion() minorImageVersion} to minorImageVersion.
     * @param minorImageVersion The value for minorImageVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder minorImageVersion(long minorImageVersion) {
      this.minorImageVersion = minorImageVersion;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMinorImageVersion() minorImageVersion} to minorImageVersion.
     * @param minorImageVersion The value for minorImageVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("minor_image_version")
    @JsonPropertyDescription("Specifies the minor version number of the image.")
    public final Builder minorImageVersion(Optional<Long> minorImageVersion) {
      this.minorImageVersion = minorImageVersion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMajorSubsystemVersion() majorSubsystemVersion} to majorSubsystemVersion.
     * @param majorSubsystemVersion The value for majorSubsystemVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder majorSubsystemVersion(long majorSubsystemVersion) {
      this.majorSubsystemVersion = majorSubsystemVersion;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMajorSubsystemVersion() majorSubsystemVersion} to majorSubsystemVersion.
     * @param majorSubsystemVersion The value for majorSubsystemVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("major_subsystem_version")
    @JsonPropertyDescription("Specifies the major version number of the subsystem.")
    public final Builder majorSubsystemVersion(Optional<Long> majorSubsystemVersion) {
      this.majorSubsystemVersion = majorSubsystemVersion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMinorSubsystemVersion() minorSubsystemVersion} to minorSubsystemVersion.
     * @param minorSubsystemVersion The value for minorSubsystemVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder minorSubsystemVersion(long minorSubsystemVersion) {
      this.minorSubsystemVersion = minorSubsystemVersion;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getMinorSubsystemVersion() minorSubsystemVersion} to minorSubsystemVersion.
     * @param minorSubsystemVersion The value for minorSubsystemVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("minor_subsystem_version")
    @JsonPropertyDescription("Specifies the minor version number of the subsystem.")
    public final Builder minorSubsystemVersion(Optional<Long> minorSubsystemVersion) {
      this.minorSubsystemVersion = minorSubsystemVersion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getWin32VersionValueHex() win32VersionValueHex} to win32VersionValueHex.
     * @param win32VersionValueHex The value for win32VersionValueHex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder win32VersionValueHex(String win32VersionValueHex) {
      this.win32VersionValueHex = Objects.requireNonNull(win32VersionValueHex, "win32VersionValueHex");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getWin32VersionValueHex() win32VersionValueHex} to win32VersionValueHex.
     * @param win32VersionValueHex The value for win32VersionValueHex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("win32_version_value_hex")
    @JsonPropertyDescription("Specifies the reserved win32 version value.")
    public final Builder win32VersionValueHex(Optional<String> win32VersionValueHex) {
      this.win32VersionValueHex = win32VersionValueHex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfImage() sizeOfImage} to sizeOfImage.
     * @param sizeOfImage The value for sizeOfImage
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sizeOfImage(long sizeOfImage) {
      this.sizeOfImage = sizeOfImage;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfImage() sizeOfImage} to sizeOfImage.
     * @param sizeOfImage The value for sizeOfImage
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size_of_image")
    @JsonPropertyDescription("Specifies the size, in bytes, of the image, including all headers, as the image is loaded in memory.")
    public final Builder sizeOfImage(Optional<Long> sizeOfImage) {
      this.sizeOfImage = sizeOfImage.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfHeaders() sizeOfHeaders} to sizeOfHeaders.
     * @param sizeOfHeaders The value for sizeOfHeaders
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sizeOfHeaders(long sizeOfHeaders) {
      this.sizeOfHeaders = sizeOfHeaders;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfHeaders() sizeOfHeaders} to sizeOfHeaders.
     * @param sizeOfHeaders The value for sizeOfHeaders
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size_of_headers")
    @JsonPropertyDescription("Specifies the combined size of the MS-DOS, PE header, and section headers, rounded up a multiple of the value specified in the file_alignment header.")
    public final Builder sizeOfHeaders(Optional<Long> sizeOfHeaders) {
      this.sizeOfHeaders = sizeOfHeaders.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getChecksumHex() checksumHex} to checksumHex.
     * @param checksumHex The value for checksumHex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder checksumHex(String checksumHex) {
      this.checksumHex = Objects.requireNonNull(checksumHex, "checksumHex");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getChecksumHex() checksumHex} to checksumHex.
     * @param checksumHex The value for checksumHex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("checksum_hex")
    @JsonPropertyDescription("Specifies the checksum of the PE binary.")
    public final Builder checksumHex(Optional<String> checksumHex) {
      this.checksumHex = checksumHex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSubsystemHex() subsystemHex} to subsystemHex.
     * @param subsystemHex The value for subsystemHex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder subsystemHex(String subsystemHex) {
      this.subsystemHex = Objects.requireNonNull(subsystemHex, "subsystemHex");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSubsystemHex() subsystemHex} to subsystemHex.
     * @param subsystemHex The value for subsystemHex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subsystem_hex")
    @JsonPropertyDescription("Specifies the subsystem (e.g., GUI, device driver, etc.) that is required to run this image.")
    public final Builder subsystemHex(Optional<String> subsystemHex) {
      this.subsystemHex = subsystemHex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getDllCharacteristicsHex() dllCharacteristicsHex} to dllCharacteristicsHex.
     * @param dllCharacteristicsHex The value for dllCharacteristicsHex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dllCharacteristicsHex(String dllCharacteristicsHex) {
      this.dllCharacteristicsHex = Objects.requireNonNull(dllCharacteristicsHex, "dllCharacteristicsHex");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getDllCharacteristicsHex() dllCharacteristicsHex} to dllCharacteristicsHex.
     * @param dllCharacteristicsHex The value for dllCharacteristicsHex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("dll_characteristics_hex")
    @JsonPropertyDescription("Specifies the flags that characterize the PE binary.")
    public final Builder dllCharacteristicsHex(Optional<String> dllCharacteristicsHex) {
      this.dllCharacteristicsHex = dllCharacteristicsHex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfStackReserve() sizeOfStackReserve} to sizeOfStackReserve.
     * @param sizeOfStackReserve The value for sizeOfStackReserve
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sizeOfStackReserve(long sizeOfStackReserve) {
      this.sizeOfStackReserve = sizeOfStackReserve;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfStackReserve() sizeOfStackReserve} to sizeOfStackReserve.
     * @param sizeOfStackReserve The value for sizeOfStackReserve
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size_of_stack_reserve")
    @JsonPropertyDescription("Specifies the size of the stack to reserve")
    public final Builder sizeOfStackReserve(Optional<Long> sizeOfStackReserve) {
      this.sizeOfStackReserve = sizeOfStackReserve.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfStackCommit() sizeOfStackCommit} to sizeOfStackCommit.
     * @param sizeOfStackCommit The value for sizeOfStackCommit
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sizeOfStackCommit(long sizeOfStackCommit) {
      this.sizeOfStackCommit = sizeOfStackCommit;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfStackCommit() sizeOfStackCommit} to sizeOfStackCommit.
     * @param sizeOfStackCommit The value for sizeOfStackCommit
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size_of_stack_commit")
    @JsonPropertyDescription("Specifies the size of the stack to commit.")
    public final Builder sizeOfStackCommit(Optional<Long> sizeOfStackCommit) {
      this.sizeOfStackCommit = sizeOfStackCommit.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfHeapReserve() sizeOfHeapReserve} to sizeOfHeapReserve.
     * @param sizeOfHeapReserve The value for sizeOfHeapReserve
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sizeOfHeapReserve(long sizeOfHeapReserve) {
      this.sizeOfHeapReserve = sizeOfHeapReserve;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfHeapReserve() sizeOfHeapReserve} to sizeOfHeapReserve.
     * @param sizeOfHeapReserve The value for sizeOfHeapReserve
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size_of_heap_reserve")
    @JsonPropertyDescription("Specifies the size of the local heap space to reserve.")
    public final Builder sizeOfHeapReserve(Optional<Long> sizeOfHeapReserve) {
      this.sizeOfHeapReserve = sizeOfHeapReserve.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfHeapCommit() sizeOfHeapCommit} to sizeOfHeapCommit.
     * @param sizeOfHeapCommit The value for sizeOfHeapCommit
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sizeOfHeapCommit(long sizeOfHeapCommit) {
      this.sizeOfHeapCommit = sizeOfHeapCommit;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getSizeOfHeapCommit() sizeOfHeapCommit} to sizeOfHeapCommit.
     * @param sizeOfHeapCommit The value for sizeOfHeapCommit
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size_of_heap_commit")
    @JsonPropertyDescription("Specifies the size of the local heap space to commit.")
    public final Builder sizeOfHeapCommit(Optional<Long> sizeOfHeapCommit) {
      this.sizeOfHeapCommit = sizeOfHeapCommit.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getLoaderFlagsHex() loaderFlagsHex} to loaderFlagsHex.
     * @param loaderFlagsHex The value for loaderFlagsHex
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder loaderFlagsHex(String loaderFlagsHex) {
      this.loaderFlagsHex = Objects.requireNonNull(loaderFlagsHex, "loaderFlagsHex");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getLoaderFlagsHex() loaderFlagsHex} to loaderFlagsHex.
     * @param loaderFlagsHex The value for loaderFlagsHex
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("loader_flags_hex")
    @JsonPropertyDescription("Specifies the reserved loader flags.")
    public final Builder loaderFlagsHex(Optional<String> loaderFlagsHex) {
      this.loaderFlagsHex = loaderFlagsHex.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getNumberOfRvaAndSizes() numberOfRvaAndSizes} to numberOfRvaAndSizes.
     * @param numberOfRvaAndSizes The value for numberOfRvaAndSizes
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder numberOfRvaAndSizes(long numberOfRvaAndSizes) {
      this.numberOfRvaAndSizes = numberOfRvaAndSizes;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeOptionalHeaderObj#getNumberOfRvaAndSizes() numberOfRvaAndSizes} to numberOfRvaAndSizes.
     * @param numberOfRvaAndSizes The value for numberOfRvaAndSizes
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("number_of_rva_and_sizes")
    @JsonPropertyDescription("Specifies the number of data-directory entries in the remainder of the optional header.")
    public final Builder numberOfRvaAndSizes(Optional<Long> numberOfRvaAndSizes) {
      this.numberOfRvaAndSizes = numberOfRvaAndSizes.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsPeOptionalHeaderObj#getHashes() hashes} map.
     * @param key The key in the hashes map
     * @param value The associated value in the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHash(String key, String value) {
      this.hashes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsPeOptionalHeaderObj#getHashes() hashes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHash(Map.Entry<String, ? extends String> entry) {
      this.hashes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link WindowsPeOptionalHeaderObj#getHashes() hashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hashes")
    @JsonPropertyDescription("Specifies any hashes that were computed for the optional header.")
    public final Builder hashes(Map<String, ? extends String> entries) {
      this.hashes = ImmutableMap.builder();
      return putAllHashes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link WindowsPeOptionalHeaderObj#getHashes() hashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllHashes(Map<String, ? extends String> entries) {
      this.hashes.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsPeOptionalHeaderObj#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsPeOptionalHeaderObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link WindowsPeOptionalHeaderObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link WindowsPeOptionalHeaderObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link WindowsPeOptionalHeader WindowsPeOptionalHeader}.
     * @return An immutable instance of WindowsPeOptionalHeader
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public WindowsPeOptionalHeader build() {
      return WindowsPeOptionalHeader.validate(new WindowsPeOptionalHeader(
          magicHex,
          majorLinkerVersion,
          minorLinkerVersion,
          sizeOfCode,
          sizeOfInitializedData,
          sizeOfUninitializedData,
          addressOfEntryPoint,
          baseOfCode,
          baseOfData,
          imageBase,
          sectionAlignment,
          fileAlignment,
          majorOsVersion,
          minorOsVersion,
          majorImageVersion,
          minorImageVersion,
          majorSubsystemVersion,
          minorSubsystemVersion,
          win32VersionValueHex,
          sizeOfImage,
          sizeOfHeaders,
          checksumHex,
          subsystemHex,
          dllCharacteristicsHex,
          sizeOfStackReserve,
          sizeOfStackCommit,
          sizeOfHeapReserve,
          sizeOfHeapCommit,
          loaderFlagsHex,
          numberOfRvaAndSizes,
          hashes.build(),
          customProperties.build()));
    }
  }
}
