package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;

/**
 * The PE Section type specifies metadata about a PE file section.
 */
@Generated(from = "WindowsPeSectionObj", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class WindowsPeSection implements WindowsPeSectionObj {
  private final @Nullable String name;
  private final @Nullable Long size;
  private final @Nullable Float entropy;
  private final ImmutableMap<String, String> hashes;
  private final ImmutableMap<String, Object> customProperties;

  private WindowsPeSection(
      @Nullable String name,
      @Nullable Long size,
      @Nullable Float entropy,
      ImmutableMap<String, String> hashes,
      ImmutableMap<String, Object> customProperties) {
    this.name = name;
    this.size = size;
    this.entropy = entropy;
    this.hashes = hashes;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JsonPropertyDescription("Specifies the name of the section.")
  @Override
  public Optional<String> getName() {
    return Optional.ofNullable(name);
  }

  /**
   * @return The value of the {@code size} attribute
   */
  @JsonProperty("size")
  @JsonPropertyDescription("Specifies the size of the section, in bytes.")
  @Override
  public Optional<Long> getSize() {
    return Optional.ofNullable(size);
  }

  /**
   * @return The value of the {@code entropy} attribute
   */
  @JsonProperty("entropy")
  @JsonPropertyDescription("Specifies the calculated entropy for the section, as calculated using the Shannon algorithm.")
  @Override
  public Optional<Float> getEntropy() {
    return Optional.ofNullable(entropy);
  }

  /**
   * @return The value of the {@code hashes} attribute
   */
  @JsonProperty("hashes")
  @JsonPropertyDescription("Specifies any hashes computed over the section.")
  @Override
  public ImmutableMap<String, String> getHashes() {
    return hashes;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeSectionObj#getName() name} attribute.
   * @param value The value for name
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeSection withName(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "name");
    if (Objects.equals(this.name, newValue)) return this;
    return validate(new WindowsPeSection(newValue, this.size, this.entropy, this.hashes, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeSectionObj#getName() name} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeSection withName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.name, value)) return this;
    return validate(new WindowsPeSection(value, this.size, this.entropy, this.hashes, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeSectionObj#getSize() size} attribute.
   * @param value The value for size
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeSection withSize(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.size, newValue)) return this;
    return validate(new WindowsPeSection(this.name, newValue, this.entropy, this.hashes, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeSectionObj#getSize() size} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for size
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeSection withSize(Optional<Long> optional) {
    @Nullable Long value = optional.orElse(null);
    if (Objects.equals(this.size, value)) return this;
    return validate(new WindowsPeSection(this.name, value, this.entropy, this.hashes, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsPeSectionObj#getEntropy() entropy} attribute.
   * @param value The value for entropy
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeSection withEntropy(float value) {
    @Nullable Float newValue = value;
    if (Objects.equals(this.entropy, newValue)) return this;
    return validate(new WindowsPeSection(this.name, this.size, newValue, this.hashes, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsPeSectionObj#getEntropy() entropy} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for entropy
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeSection withEntropy(Optional<Float> optional) {
    @Nullable Float value = optional.orElse(null);
    if (Objects.equals(this.entropy, value)) return this;
    return validate(new WindowsPeSection(this.name, this.size, value, this.hashes, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link WindowsPeSectionObj#getHashes() hashes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the hashes map
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeSection withHashes(Map<String, ? extends String> entries) {
    if (this.hashes == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return validate(new WindowsPeSection(this.name, this.size, this.entropy, newValue, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link WindowsPeSectionObj#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final WindowsPeSection withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new WindowsPeSection(this.name, this.size, this.entropy, this.hashes, newValue));
  }

  /**
   * This instance is equal to all instances of {@code WindowsPeSection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof WindowsPeSection
        && equalTo((WindowsPeSection) another);
  }

  private boolean equalTo(WindowsPeSection another) {
    return Objects.equals(name, another.name)
        && Objects.equals(size, another.size)
        && Objects.equals(entropy, another.entropy)
        && hashes.equals(another.hashes)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code size}, {@code entropy}, {@code hashes}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(size);
    h += (h << 5) + Objects.hashCode(entropy);
    h += (h << 5) + hashes.hashCode();
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WindowsPeSection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WindowsPeSection")
        .omitNullValues()
        .add("name", name)
        .add("size", size)
        .add("entropy", entropy)
        .add("hashes", hashes)
        .add("customProperties", customProperties)
        .toString();
  }


  private static WindowsPeSection validate(WindowsPeSection instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link WindowsPeSectionObj} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WindowsPeSection instance
   */
  public static WindowsPeSection copyOf(WindowsPeSectionObj instance) {
    if (instance instanceof WindowsPeSection) {
      return (WindowsPeSection) instance;
    }
    return WindowsPeSection.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link WindowsPeSection WindowsPeSection}.
   * @return A new WindowsPeSection builder
   */
  public static WindowsPeSection.Builder builder() {
    return new WindowsPeSection.Builder();
  }

  /**
   * Builds instances of type {@link WindowsPeSection WindowsPeSection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WindowsPeSectionObj", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"name", "size", "entropy", "hashes"})
  public static final class Builder {
    private @Nullable String name;
    private @Nullable Long size;
    private @Nullable Float entropy;
    private ImmutableMap.Builder<String, String> hashes = ImmutableMap.builder();
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.types.WindowsPeSectionObj} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WindowsPeSectionObj instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof WindowsPeSectionObj) {
        WindowsPeSectionObj instance = (WindowsPeSectionObj) object;
        Optional<String> nameOptional = instance.getName();
        if (nameOptional.isPresent()) {
          name(nameOptional);
        }
        putAllHashes(instance.getHashes());
        Optional<Float> entropyOptional = instance.getEntropy();
        if (entropyOptional.isPresent()) {
          entropy(entropyOptional);
        }
        Optional<Long> sizeOptional = instance.getSize();
        if (sizeOptional.isPresent()) {
          size(sizeOptional);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
    }

    /**
     * Initializes the optional value {@link WindowsPeSectionObj#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeSectionObj#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    @JsonPropertyDescription("Specifies the name of the section.")
    public final Builder name(Optional<String> name) {
      this.name = name.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeSectionObj#getSize() size} to size.
     * @param size The value for size
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder size(long size) {
      this.size = size;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeSectionObj#getSize() size} to size.
     * @param size The value for size
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("size")
    @JsonPropertyDescription("Specifies the size of the section, in bytes.")
    public final Builder size(Optional<Long> size) {
      this.size = size.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeSectionObj#getEntropy() entropy} to entropy.
     * @param entropy The value for entropy
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder entropy(float entropy) {
      this.entropy = entropy;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsPeSectionObj#getEntropy() entropy} to entropy.
     * @param entropy The value for entropy
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("entropy")
    @JsonPropertyDescription("Specifies the calculated entropy for the section, as calculated using the Shannon algorithm.")
    public final Builder entropy(Optional<Float> entropy) {
      this.entropy = entropy.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsPeSectionObj#getHashes() hashes} map.
     * @param key The key in the hashes map
     * @param value The associated value in the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHash(String key, String value) {
      this.hashes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsPeSectionObj#getHashes() hashes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHash(Map.Entry<String, ? extends String> entry) {
      this.hashes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link WindowsPeSectionObj#getHashes() hashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hashes")
    @JsonPropertyDescription("Specifies any hashes computed over the section.")
    public final Builder hashes(Map<String, ? extends String> entries) {
      this.hashes = ImmutableMap.builder();
      return putAllHashes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link WindowsPeSectionObj#getHashes() hashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllHashes(Map<String, ? extends String> entries) {
      this.hashes.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsPeSectionObj#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsPeSectionObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link WindowsPeSectionObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link WindowsPeSectionObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link WindowsPeSection WindowsPeSection}.
     * @return An immutable instance of WindowsPeSection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public WindowsPeSection build() {
      return WindowsPeSection.validate(new WindowsPeSection(name, size, entropy, hashes.build(), customProperties.build()));
    }
  }
}
