package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;

/**
 * The Windows Registry Value type captures the properties of a Windows Registry Key Value.
 */
@Generated(from = "WindowsRegistryValueObj", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class WindowsRegistryValue implements WindowsRegistryValueObj {
  private final String name;
  private final @Nullable String data;
  private final @Nullable String dataType;
  private final ImmutableMap<String, Object> customProperties;

  private WindowsRegistryValue(
      String name,
      @Nullable String data,
      @Nullable String dataType,
      ImmutableMap<String, Object> customProperties) {
    this.name = name;
    this.data = data;
    this.dataType = dataType;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JsonPropertyDescription("Specifies the name of the registry value. For specifying the default value in a registry key, an empty string MUST be used.")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code data} attribute
   */
  @JsonProperty("data")
  @JsonPropertyDescription("Specifies the data contained in the registry value.")
  @Override
  public Optional<String> getData() {
    return Optional.ofNullable(data);
  }

  /**
   * @return The value of the {@code dataType} attribute
   */
  @JsonProperty("data_type")
  @JsonPropertyDescription("Specifies the registry (REG_*) data type used in the registry value.")
  @Override
  public Optional<String> getDataType() {
    return Optional.ofNullable(dataType);
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WindowsRegistryValueObj#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final WindowsRegistryValue withName(String value) {
    if (Objects.equals(this.name, value)) return this;
    return validate(new WindowsRegistryValue(value, this.data, this.dataType, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsRegistryValueObj#getData() data} attribute.
   * @param value The value for data
   * @return A modified copy of {@code this} object
   */
  public final WindowsRegistryValue withData(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "data");
    if (Objects.equals(this.data, newValue)) return this;
    return validate(new WindowsRegistryValue(this.name, newValue, this.dataType, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsRegistryValueObj#getData() data} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for data
   * @return A modified copy of {@code this} object
   */
  public final WindowsRegistryValue withData(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.data, value)) return this;
    return validate(new WindowsRegistryValue(this.name, value, this.dataType, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link WindowsRegistryValueObj#getDataType() dataType} attribute.
   * @param value The value for dataType
   * @return A modified copy of {@code this} object
   */
  public final WindowsRegistryValue withDataType(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "dataType");
    if (Objects.equals(this.dataType, newValue)) return this;
    return validate(new WindowsRegistryValue(this.name, this.data, newValue, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link WindowsRegistryValueObj#getDataType() dataType} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dataType
   * @return A modified copy of {@code this} object
   */
  public final WindowsRegistryValue withDataType(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.dataType, value)) return this;
    return validate(new WindowsRegistryValue(this.name, this.data, value, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link WindowsRegistryValueObj#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final WindowsRegistryValue withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new WindowsRegistryValue(this.name, this.data, this.dataType, newValue));
  }

  /**
   * This instance is equal to all instances of {@code WindowsRegistryValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof WindowsRegistryValue
        && equalTo((WindowsRegistryValue) another);
  }

  private boolean equalTo(WindowsRegistryValue another) {
    return Objects.equals(name, another.name)
        && Objects.equals(data, another.data)
        && Objects.equals(dataType, another.dataType)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code data}, {@code dataType}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + Objects.hashCode(dataType);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WindowsRegistryValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WindowsRegistryValue")
        .omitNullValues()
        .add("name", name)
        .add("data", data)
        .add("dataType", dataType)
        .add("customProperties", customProperties)
        .toString();
  }


  private static WindowsRegistryValue validate(WindowsRegistryValue instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link WindowsRegistryValueObj} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WindowsRegistryValue instance
   */
  public static WindowsRegistryValue copyOf(WindowsRegistryValueObj instance) {
    if (instance instanceof WindowsRegistryValue) {
      return (WindowsRegistryValue) instance;
    }
    return WindowsRegistryValue.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link WindowsRegistryValue WindowsRegistryValue}.
   * @return A new WindowsRegistryValue builder
   */
  public static WindowsRegistryValue.Builder builder() {
    return new WindowsRegistryValue.Builder();
  }

  /**
   * Builds instances of type {@link WindowsRegistryValue WindowsRegistryValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WindowsRegistryValueObj", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"name", "data", "data_type"})
  public static final class Builder {
    private @Nullable String name;
    private @Nullable String data;
    private @Nullable String dataType;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.types.WindowsRegistryValueObj} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WindowsRegistryValueObj instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof WindowsRegistryValueObj) {
        WindowsRegistryValueObj instance = (WindowsRegistryValueObj) object;
        Optional<String> dataOptional = instance.getData();
        if (dataOptional.isPresent()) {
          data(dataOptional);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        Optional<String> dataTypeOptional = instance.getDataType();
        if (dataTypeOptional.isPresent()) {
          dataType(dataTypeOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link WindowsRegistryValueObj#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    @JsonPropertyDescription("Specifies the name of the registry value. For specifying the default value in a registry key, an empty string MUST be used.")
    public final Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsRegistryValueObj#getData() data} to data.
     * @param data The value for data
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder data(String data) {
      this.data = Objects.requireNonNull(data, "data");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsRegistryValueObj#getData() data} to data.
     * @param data The value for data
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("data")
    @JsonPropertyDescription("Specifies the data contained in the registry value.")
    public final Builder data(Optional<String> data) {
      this.data = data.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsRegistryValueObj#getDataType() dataType} to dataType.
     * @param dataType The value for dataType
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dataType(String dataType) {
      this.dataType = Objects.requireNonNull(dataType, "dataType");
      return this;
    }

    /**
     * Initializes the optional value {@link WindowsRegistryValueObj#getDataType() dataType} to dataType.
     * @param dataType The value for dataType
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("data_type")
    @JsonPropertyDescription("Specifies the registry (REG_*) data type used in the registry value.")
    public final Builder dataType(Optional<String> dataType) {
      this.dataType = dataType.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsRegistryValueObj#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link WindowsRegistryValueObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link WindowsRegistryValueObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link WindowsRegistryValueObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link WindowsRegistryValue WindowsRegistryValue}.
     * @return An immutable instance of WindowsRegistryValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public WindowsRegistryValue build() {
      return WindowsRegistryValue.validate(new WindowsRegistryValue(name, data, dataType, customProperties.build()));
    }
  }
}
