package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;

/**
 * x509-certificate
 * <p>
 * The X509 Certificate Object represents the properties of an X.509 certificate.
 * Note that the X.509 v3 Extensions type is not a STIX Cyber Observables extension,
 * it is a type that describes X.509 extensions.
 */
@Generated(from = "X509v3ExtensionsObj", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class X509v3Extensions implements X509v3ExtensionsObj {
  private final @Nullable String basicConstraints;
  private final @Nullable String nameConstraints;
  private final @Nullable String policyConstraints;
  private final @Nullable String keyUsage;
  private final @Nullable String extendedKeyUsage;
  private final @Nullable String subjectKeyIdentifier;
  private final @Nullable String authorityKeyIdentifier;
  private final @Nullable String subjectAlternativeName;
  private final @Nullable String issuerAlternativeName;
  private final @Nullable String subjectDirectoryAttributes;
  private final @Nullable String crlDistributionPoints;
  private final @Nullable String inhibitAnyPolicy;
  private final @Nullable StixInstant privateKeyUsagePeriodNotBefore;
  private final @Nullable StixInstant privateKeyUsagePeriodNotAfter;
  private final @Nullable String certificatePolicies;
  private final @Nullable String policyMappings;
  private final ImmutableMap<String, Object> customProperties;

  private X509v3Extensions(
      @Nullable String basicConstraints,
      @Nullable String nameConstraints,
      @Nullable String policyConstraints,
      @Nullable String keyUsage,
      @Nullable String extendedKeyUsage,
      @Nullable String subjectKeyIdentifier,
      @Nullable String authorityKeyIdentifier,
      @Nullable String subjectAlternativeName,
      @Nullable String issuerAlternativeName,
      @Nullable String subjectDirectoryAttributes,
      @Nullable String crlDistributionPoints,
      @Nullable String inhibitAnyPolicy,
      @Nullable StixInstant privateKeyUsagePeriodNotBefore,
      @Nullable StixInstant privateKeyUsagePeriodNotAfter,
      @Nullable String certificatePolicies,
      @Nullable String policyMappings,
      ImmutableMap<String, Object> customProperties) {
    this.basicConstraints = basicConstraints;
    this.nameConstraints = nameConstraints;
    this.policyConstraints = policyConstraints;
    this.keyUsage = keyUsage;
    this.extendedKeyUsage = extendedKeyUsage;
    this.subjectKeyIdentifier = subjectKeyIdentifier;
    this.authorityKeyIdentifier = authorityKeyIdentifier;
    this.subjectAlternativeName = subjectAlternativeName;
    this.issuerAlternativeName = issuerAlternativeName;
    this.subjectDirectoryAttributes = subjectDirectoryAttributes;
    this.crlDistributionPoints = crlDistributionPoints;
    this.inhibitAnyPolicy = inhibitAnyPolicy;
    this.privateKeyUsagePeriodNotBefore = privateKeyUsagePeriodNotBefore;
    this.privateKeyUsagePeriodNotAfter = privateKeyUsagePeriodNotAfter;
    this.certificatePolicies = certificatePolicies;
    this.policyMappings = policyMappings;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code basicConstraints} attribute
   */
  @JsonProperty("basic_constraints")
  @JsonPropertyDescription("Specifies a multi-valued extension which indicates whether a certificate is a CA certificate.")
  @Override
  public Optional<String> getBasicConstraints() {
    return Optional.ofNullable(basicConstraints);
  }

  /**
   * @return The value of the {@code nameConstraints} attribute
   */
  @JsonProperty("name_constraints")
  @JsonPropertyDescription("Specifies a namespace within which all subject names in subsequent certificates in a certification path MUST be located.")
  @Override
  public Optional<String> getNameConstraints() {
    return Optional.ofNullable(nameConstraints);
  }

  /**
   * @return The value of the {@code policyConstraints} attribute
   */
  @JsonProperty("policy_constraints")
  @JsonPropertyDescription("Specifies any constraints on path validation for certificates issued to CAs.")
  @Override
  public Optional<String> getPolicyConstraints() {
    return Optional.ofNullable(policyConstraints);
  }

  /**
   * @return The value of the {@code keyUsage} attribute
   */
  @JsonProperty("key_usage")
  @JsonPropertyDescription("Specifies a multi-valued extension consisting of a list of names of the permitted key usages.")
  @Override
  public Optional<String> getKeyUsage() {
    return Optional.ofNullable(keyUsage);
  }

  /**
   * @return The value of the {@code extendedKeyUsage} attribute
   */
  @JsonProperty("extended_key_usage")
  @JsonPropertyDescription("Specifies a list of usages indicating purposes for which the certificate public key can be used for.")
  @Override
  public Optional<String> getExtendedKeyUsage() {
    return Optional.ofNullable(extendedKeyUsage);
  }

  /**
   * @return The value of the {@code subjectKeyIdentifier} attribute
   */
  @JsonProperty("subject_key_identifier")
  @JsonPropertyDescription("Specifies the identifier that provides a means of identifying certificates that contain a particular public key.")
  @Override
  public Optional<String> getSubjectKeyIdentifier() {
    return Optional.ofNullable(subjectKeyIdentifier);
  }

  /**
   * @return The value of the {@code authorityKeyIdentifier} attribute
   */
  @JsonProperty("authority_key_identifier")
  @JsonPropertyDescription("Specifies the identifier that provides a means of identifying the public key corresponding to the key used to sign a certificate.")
  @Override
  public Optional<String> getAuthorityKeyIdentifier() {
    return Optional.ofNullable(authorityKeyIdentifier);
  }

  /**
   * @return The value of the {@code subjectAlternativeName} attribute
   */
  @JsonProperty("subject_alternative_name")
  @JsonPropertyDescription("Specifies the additional identities to be bound to the subject of the certificate.")
  @Override
  public Optional<String> getSubjectAlternativeName() {
    return Optional.ofNullable(subjectAlternativeName);
  }

  /**
   * @return The value of the {@code issuerAlternativeName} attribute
   */
  @JsonProperty("issuer_alternative_name")
  @JsonPropertyDescription("Specifies the additional identities to be bound to the issuer of the certificate.")
  @Override
  public Optional<String> getIssuerAlternativeName() {
    return Optional.ofNullable(issuerAlternativeName);
  }

  /**
   * @return The value of the {@code subjectDirectoryAttributes} attribute
   */
  @JsonProperty("subject_directory_attributes")
  @JsonPropertyDescription("Specifies the identification attributes (e.g., nationality) of the subject.")
  @Override
  public Optional<String> getSubjectDirectoryAttributes() {
    return Optional.ofNullable(subjectDirectoryAttributes);
  }

  /**
   * @return The value of the {@code crlDistributionPoints} attribute
   */
  @JsonProperty("crl_distribution_points")
  @JsonPropertyDescription("Specifies how CRL information is obtained.")
  @Override
  public Optional<String> getCrlDistributionPoints() {
    return Optional.ofNullable(crlDistributionPoints);
  }

  /**
   * @return The value of the {@code inhibitAnyPolicy} attribute
   */
  @JsonProperty("inhibit_any_policy")
  @JsonPropertyDescription("Specifies the number of additional certificates that may appear in the path before anyPolicy is no longer permitted.")
  @Override
  public Optional<String> getInhibitAnyPolicy() {
    return Optional.ofNullable(inhibitAnyPolicy);
  }

  /**
   * @return The value of the {@code privateKeyUsagePeriodNotBefore} attribute
   */
  @JsonProperty("private_key_usage_period_not_before")
  @JsonPropertyDescription("Specifies the date on which the validity period begins for the key, if it is different from the validity period of the certificate.")
  @Override
  public Optional<StixInstant> getPrivateKeyUsagePeriodNotBefore() {
    return Optional.ofNullable(privateKeyUsagePeriodNotBefore);
  }

  /**
   * @return The value of the {@code privateKeyUsagePeriodNotAfter} attribute
   */
  @JsonProperty("private_key_usage_period_not_after")
  @JsonPropertyDescription("Specifies the date on which the validity period ends for the key, if it is different from the validity period of the certificate.")
  @Override
  public Optional<StixInstant> getPrivateKeyUsagePeriodNotAfter() {
    return Optional.ofNullable(privateKeyUsagePeriodNotAfter);
  }

  /**
   * @return The value of the {@code certificatePolicies} attribute
   */
  @JsonProperty("certificate_policies")
  @JsonPropertyDescription("Specifies a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers.")
  @Override
  public Optional<String> getCertificatePolicies() {
    return Optional.ofNullable(certificatePolicies);
  }

  /**
   * @return The value of the {@code policyMappings} attribute
   */
  @JsonProperty("policy_mappings")
  @JsonPropertyDescription("Specifies one or more pairs of OIDs(); each pair includes an issuerDomainPolicy and a subjectDomainPolicy")
  @Override
  public Optional<String> getPolicyMappings() {
    return Optional.ofNullable(policyMappings);
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getBasicConstraints() basicConstraints} attribute.
   * @param value The value for basicConstraints
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withBasicConstraints(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "basicConstraints");
    if (Objects.equals(this.basicConstraints, newValue)) return this;
    return validate(new X509v3Extensions(
        newValue,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getBasicConstraints() basicConstraints} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for basicConstraints
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withBasicConstraints(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.basicConstraints, value)) return this;
    return validate(new X509v3Extensions(
        value,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getNameConstraints() nameConstraints} attribute.
   * @param value The value for nameConstraints
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withNameConstraints(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "nameConstraints");
    if (Objects.equals(this.nameConstraints, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        newValue,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getNameConstraints() nameConstraints} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for nameConstraints
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withNameConstraints(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.nameConstraints, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        value,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getPolicyConstraints() policyConstraints} attribute.
   * @param value The value for policyConstraints
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withPolicyConstraints(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "policyConstraints");
    if (Objects.equals(this.policyConstraints, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        newValue,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getPolicyConstraints() policyConstraints} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for policyConstraints
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withPolicyConstraints(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.policyConstraints, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        value,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getKeyUsage() keyUsage} attribute.
   * @param value The value for keyUsage
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withKeyUsage(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "keyUsage");
    if (Objects.equals(this.keyUsage, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        newValue,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getKeyUsage() keyUsage} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for keyUsage
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withKeyUsage(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.keyUsage, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        value,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getExtendedKeyUsage() extendedKeyUsage} attribute.
   * @param value The value for extendedKeyUsage
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withExtendedKeyUsage(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "extendedKeyUsage");
    if (Objects.equals(this.extendedKeyUsage, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        newValue,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getExtendedKeyUsage() extendedKeyUsage} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for extendedKeyUsage
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withExtendedKeyUsage(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.extendedKeyUsage, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        value,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getSubjectKeyIdentifier() subjectKeyIdentifier} attribute.
   * @param value The value for subjectKeyIdentifier
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withSubjectKeyIdentifier(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "subjectKeyIdentifier");
    if (Objects.equals(this.subjectKeyIdentifier, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        newValue,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getSubjectKeyIdentifier() subjectKeyIdentifier} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subjectKeyIdentifier
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withSubjectKeyIdentifier(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.subjectKeyIdentifier, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        value,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getAuthorityKeyIdentifier() authorityKeyIdentifier} attribute.
   * @param value The value for authorityKeyIdentifier
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withAuthorityKeyIdentifier(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "authorityKeyIdentifier");
    if (Objects.equals(this.authorityKeyIdentifier, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        newValue,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getAuthorityKeyIdentifier() authorityKeyIdentifier} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for authorityKeyIdentifier
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withAuthorityKeyIdentifier(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.authorityKeyIdentifier, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        value,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getSubjectAlternativeName() subjectAlternativeName} attribute.
   * @param value The value for subjectAlternativeName
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withSubjectAlternativeName(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "subjectAlternativeName");
    if (Objects.equals(this.subjectAlternativeName, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        newValue,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getSubjectAlternativeName() subjectAlternativeName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subjectAlternativeName
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withSubjectAlternativeName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.subjectAlternativeName, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        value,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getIssuerAlternativeName() issuerAlternativeName} attribute.
   * @param value The value for issuerAlternativeName
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withIssuerAlternativeName(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "issuerAlternativeName");
    if (Objects.equals(this.issuerAlternativeName, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        newValue,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getIssuerAlternativeName() issuerAlternativeName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for issuerAlternativeName
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withIssuerAlternativeName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.issuerAlternativeName, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        value,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getSubjectDirectoryAttributes() subjectDirectoryAttributes} attribute.
   * @param value The value for subjectDirectoryAttributes
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withSubjectDirectoryAttributes(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "subjectDirectoryAttributes");
    if (Objects.equals(this.subjectDirectoryAttributes, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        newValue,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getSubjectDirectoryAttributes() subjectDirectoryAttributes} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subjectDirectoryAttributes
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withSubjectDirectoryAttributes(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.subjectDirectoryAttributes, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        value,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getCrlDistributionPoints() crlDistributionPoints} attribute.
   * @param value The value for crlDistributionPoints
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withCrlDistributionPoints(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "crlDistributionPoints");
    if (Objects.equals(this.crlDistributionPoints, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        newValue,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getCrlDistributionPoints() crlDistributionPoints} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for crlDistributionPoints
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withCrlDistributionPoints(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.crlDistributionPoints, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        value,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getInhibitAnyPolicy() inhibitAnyPolicy} attribute.
   * @param value The value for inhibitAnyPolicy
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withInhibitAnyPolicy(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "inhibitAnyPolicy");
    if (Objects.equals(this.inhibitAnyPolicy, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        newValue,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getInhibitAnyPolicy() inhibitAnyPolicy} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for inhibitAnyPolicy
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withInhibitAnyPolicy(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.inhibitAnyPolicy, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        value,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getPrivateKeyUsagePeriodNotBefore() privateKeyUsagePeriodNotBefore} attribute.
   * @param value The value for privateKeyUsagePeriodNotBefore
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withPrivateKeyUsagePeriodNotBefore(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "privateKeyUsagePeriodNotBefore");
    if (this.privateKeyUsagePeriodNotBefore == newValue) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        newValue,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getPrivateKeyUsagePeriodNotBefore() privateKeyUsagePeriodNotBefore} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for privateKeyUsagePeriodNotBefore
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final X509v3Extensions withPrivateKeyUsagePeriodNotBefore(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.privateKeyUsagePeriodNotBefore == value) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        value,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getPrivateKeyUsagePeriodNotAfter() privateKeyUsagePeriodNotAfter} attribute.
   * @param value The value for privateKeyUsagePeriodNotAfter
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withPrivateKeyUsagePeriodNotAfter(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "privateKeyUsagePeriodNotAfter");
    if (this.privateKeyUsagePeriodNotAfter == newValue) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        newValue,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getPrivateKeyUsagePeriodNotAfter() privateKeyUsagePeriodNotAfter} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for privateKeyUsagePeriodNotAfter
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final X509v3Extensions withPrivateKeyUsagePeriodNotAfter(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.privateKeyUsagePeriodNotAfter == value) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        value,
        this.certificatePolicies,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getCertificatePolicies() certificatePolicies} attribute.
   * @param value The value for certificatePolicies
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withCertificatePolicies(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "certificatePolicies");
    if (Objects.equals(this.certificatePolicies, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        newValue,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getCertificatePolicies() certificatePolicies} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for certificatePolicies
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withCertificatePolicies(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.certificatePolicies, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        value,
        this.policyMappings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link X509v3ExtensionsObj#getPolicyMappings() policyMappings} attribute.
   * @param value The value for policyMappings
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withPolicyMappings(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "policyMappings");
    if (Objects.equals(this.policyMappings, newValue)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        newValue,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link X509v3ExtensionsObj#getPolicyMappings() policyMappings} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for policyMappings
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withPolicyMappings(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.policyMappings, value)) return this;
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        value,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link X509v3ExtensionsObj#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final X509v3Extensions withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new X509v3Extensions(
        this.basicConstraints,
        this.nameConstraints,
        this.policyConstraints,
        this.keyUsage,
        this.extendedKeyUsage,
        this.subjectKeyIdentifier,
        this.authorityKeyIdentifier,
        this.subjectAlternativeName,
        this.issuerAlternativeName,
        this.subjectDirectoryAttributes,
        this.crlDistributionPoints,
        this.inhibitAnyPolicy,
        this.privateKeyUsagePeriodNotBefore,
        this.privateKeyUsagePeriodNotAfter,
        this.certificatePolicies,
        this.policyMappings,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code X509v3Extensions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof X509v3Extensions
        && equalTo((X509v3Extensions) another);
  }

  private boolean equalTo(X509v3Extensions another) {
    return Objects.equals(basicConstraints, another.basicConstraints)
        && Objects.equals(nameConstraints, another.nameConstraints)
        && Objects.equals(policyConstraints, another.policyConstraints)
        && Objects.equals(keyUsage, another.keyUsage)
        && Objects.equals(extendedKeyUsage, another.extendedKeyUsage)
        && Objects.equals(subjectKeyIdentifier, another.subjectKeyIdentifier)
        && Objects.equals(authorityKeyIdentifier, another.authorityKeyIdentifier)
        && Objects.equals(subjectAlternativeName, another.subjectAlternativeName)
        && Objects.equals(issuerAlternativeName, another.issuerAlternativeName)
        && Objects.equals(subjectDirectoryAttributes, another.subjectDirectoryAttributes)
        && Objects.equals(crlDistributionPoints, another.crlDistributionPoints)
        && Objects.equals(inhibitAnyPolicy, another.inhibitAnyPolicy)
        && Objects.equals(privateKeyUsagePeriodNotBefore, another.privateKeyUsagePeriodNotBefore)
        && Objects.equals(privateKeyUsagePeriodNotAfter, another.privateKeyUsagePeriodNotAfter)
        && Objects.equals(certificatePolicies, another.certificatePolicies)
        && Objects.equals(policyMappings, another.policyMappings)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code basicConstraints}, {@code nameConstraints}, {@code policyConstraints}, {@code keyUsage}, {@code extendedKeyUsage}, {@code subjectKeyIdentifier}, {@code authorityKeyIdentifier}, {@code subjectAlternativeName}, {@code issuerAlternativeName}, {@code subjectDirectoryAttributes}, {@code crlDistributionPoints}, {@code inhibitAnyPolicy}, {@code privateKeyUsagePeriodNotBefore}, {@code privateKeyUsagePeriodNotAfter}, {@code certificatePolicies}, {@code policyMappings}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(basicConstraints);
    h += (h << 5) + Objects.hashCode(nameConstraints);
    h += (h << 5) + Objects.hashCode(policyConstraints);
    h += (h << 5) + Objects.hashCode(keyUsage);
    h += (h << 5) + Objects.hashCode(extendedKeyUsage);
    h += (h << 5) + Objects.hashCode(subjectKeyIdentifier);
    h += (h << 5) + Objects.hashCode(authorityKeyIdentifier);
    h += (h << 5) + Objects.hashCode(subjectAlternativeName);
    h += (h << 5) + Objects.hashCode(issuerAlternativeName);
    h += (h << 5) + Objects.hashCode(subjectDirectoryAttributes);
    h += (h << 5) + Objects.hashCode(crlDistributionPoints);
    h += (h << 5) + Objects.hashCode(inhibitAnyPolicy);
    h += (h << 5) + Objects.hashCode(privateKeyUsagePeriodNotBefore);
    h += (h << 5) + Objects.hashCode(privateKeyUsagePeriodNotAfter);
    h += (h << 5) + Objects.hashCode(certificatePolicies);
    h += (h << 5) + Objects.hashCode(policyMappings);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code X509v3Extensions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("X509v3Extensions")
        .omitNullValues()
        .add("basicConstraints", basicConstraints)
        .add("nameConstraints", nameConstraints)
        .add("policyConstraints", policyConstraints)
        .add("keyUsage", keyUsage)
        .add("extendedKeyUsage", extendedKeyUsage)
        .add("subjectKeyIdentifier", subjectKeyIdentifier)
        .add("authorityKeyIdentifier", authorityKeyIdentifier)
        .add("subjectAlternativeName", subjectAlternativeName)
        .add("issuerAlternativeName", issuerAlternativeName)
        .add("subjectDirectoryAttributes", subjectDirectoryAttributes)
        .add("crlDistributionPoints", crlDistributionPoints)
        .add("inhibitAnyPolicy", inhibitAnyPolicy)
        .add("privateKeyUsagePeriodNotBefore", privateKeyUsagePeriodNotBefore)
        .add("privateKeyUsagePeriodNotAfter", privateKeyUsagePeriodNotAfter)
        .add("certificatePolicies", certificatePolicies)
        .add("policyMappings", policyMappings)
        .add("customProperties", customProperties)
        .toString();
  }


  private static X509v3Extensions validate(X509v3Extensions instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link X509v3ExtensionsObj} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable X509v3Extensions instance
   */
  public static X509v3Extensions copyOf(X509v3ExtensionsObj instance) {
    if (instance instanceof X509v3Extensions) {
      return (X509v3Extensions) instance;
    }
    return X509v3Extensions.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link X509v3Extensions X509v3Extensions}.
   * @return A new X509v3Extensions builder
   */
  public static X509v3Extensions.Builder builder() {
    return new X509v3Extensions.Builder();
  }

  /**
   * Builds instances of type {@link X509v3Extensions X509v3Extensions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "X509v3ExtensionsObj", generator = "Immutables")
  @NotThreadSafe
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyOrder({"basic_constraints", "name_constraints", "policy_constraints", "key_usage", "extended_key_usage", "subject_key_identifier", "authority_key_identifier", "subject_alternative_name", "issuer_alternative_name", "subject_directory_attributes", "crl_distribution_points", "inhibit_any_policy", "private_key_usage_period_not_before", "private_key_usage_period_not_after", "certificate_policies", "policy_mappings"})
  public static final class Builder {
    private @Nullable String basicConstraints;
    private @Nullable String nameConstraints;
    private @Nullable String policyConstraints;
    private @Nullable String keyUsage;
    private @Nullable String extendedKeyUsage;
    private @Nullable String subjectKeyIdentifier;
    private @Nullable String authorityKeyIdentifier;
    private @Nullable String subjectAlternativeName;
    private @Nullable String issuerAlternativeName;
    private @Nullable String subjectDirectoryAttributes;
    private @Nullable String crlDistributionPoints;
    private @Nullable String inhibitAnyPolicy;
    private @Nullable StixInstant privateKeyUsagePeriodNotBefore;
    private @Nullable StixInstant privateKeyUsagePeriodNotAfter;
    private @Nullable String certificatePolicies;
    private @Nullable String policyMappings;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.coo.types.X509v3ExtensionsObj} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(X509v3ExtensionsObj instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof X509v3ExtensionsObj) {
        X509v3ExtensionsObj instance = (X509v3ExtensionsObj) object;
        Optional<String> authorityKeyIdentifierOptional = instance.getAuthorityKeyIdentifier();
        if (authorityKeyIdentifierOptional.isPresent()) {
          authorityKeyIdentifier(authorityKeyIdentifierOptional);
        }
        Optional<String> subjectDirectoryAttributesOptional = instance.getSubjectDirectoryAttributes();
        if (subjectDirectoryAttributesOptional.isPresent()) {
          subjectDirectoryAttributes(subjectDirectoryAttributesOptional);
        }
        Optional<String> policyConstraintsOptional = instance.getPolicyConstraints();
        if (policyConstraintsOptional.isPresent()) {
          policyConstraints(policyConstraintsOptional);
        }
        Optional<StixInstant> privateKeyUsagePeriodNotBeforeOptional = instance.getPrivateKeyUsagePeriodNotBefore();
        if (privateKeyUsagePeriodNotBeforeOptional.isPresent()) {
          privateKeyUsagePeriodNotBefore(privateKeyUsagePeriodNotBeforeOptional);
        }
        Optional<String> subjectAlternativeNameOptional = instance.getSubjectAlternativeName();
        if (subjectAlternativeNameOptional.isPresent()) {
          subjectAlternativeName(subjectAlternativeNameOptional);
        }
        Optional<StixInstant> privateKeyUsagePeriodNotAfterOptional = instance.getPrivateKeyUsagePeriodNotAfter();
        if (privateKeyUsagePeriodNotAfterOptional.isPresent()) {
          privateKeyUsagePeriodNotAfter(privateKeyUsagePeriodNotAfterOptional);
        }
        Optional<String> issuerAlternativeNameOptional = instance.getIssuerAlternativeName();
        if (issuerAlternativeNameOptional.isPresent()) {
          issuerAlternativeName(issuerAlternativeNameOptional);
        }
        Optional<String> subjectKeyIdentifierOptional = instance.getSubjectKeyIdentifier();
        if (subjectKeyIdentifierOptional.isPresent()) {
          subjectKeyIdentifier(subjectKeyIdentifierOptional);
        }
        Optional<String> policyMappingsOptional = instance.getPolicyMappings();
        if (policyMappingsOptional.isPresent()) {
          policyMappings(policyMappingsOptional);
        }
        Optional<String> keyUsageOptional = instance.getKeyUsage();
        if (keyUsageOptional.isPresent()) {
          keyUsage(keyUsageOptional);
        }
        Optional<String> inhibitAnyPolicyOptional = instance.getInhibitAnyPolicy();
        if (inhibitAnyPolicyOptional.isPresent()) {
          inhibitAnyPolicy(inhibitAnyPolicyOptional);
        }
        Optional<String> certificatePoliciesOptional = instance.getCertificatePolicies();
        if (certificatePoliciesOptional.isPresent()) {
          certificatePolicies(certificatePoliciesOptional);
        }
        Optional<String> basicConstraintsOptional = instance.getBasicConstraints();
        if (basicConstraintsOptional.isPresent()) {
          basicConstraints(basicConstraintsOptional);
        }
        Optional<String> extendedKeyUsageOptional = instance.getExtendedKeyUsage();
        if (extendedKeyUsageOptional.isPresent()) {
          extendedKeyUsage(extendedKeyUsageOptional);
        }
        Optional<String> nameConstraintsOptional = instance.getNameConstraints();
        if (nameConstraintsOptional.isPresent()) {
          nameConstraints(nameConstraintsOptional);
        }
        Optional<String> crlDistributionPointsOptional = instance.getCrlDistributionPoints();
        if (crlDistributionPointsOptional.isPresent()) {
          crlDistributionPoints(crlDistributionPointsOptional);
        }
      }
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getBasicConstraints() basicConstraints} to basicConstraints.
     * @param basicConstraints The value for basicConstraints
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder basicConstraints(String basicConstraints) {
      this.basicConstraints = Objects.requireNonNull(basicConstraints, "basicConstraints");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getBasicConstraints() basicConstraints} to basicConstraints.
     * @param basicConstraints The value for basicConstraints
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("basic_constraints")
    @JsonPropertyDescription("Specifies a multi-valued extension which indicates whether a certificate is a CA certificate.")
    public final Builder basicConstraints(Optional<String> basicConstraints) {
      this.basicConstraints = basicConstraints.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getNameConstraints() nameConstraints} to nameConstraints.
     * @param nameConstraints The value for nameConstraints
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nameConstraints(String nameConstraints) {
      this.nameConstraints = Objects.requireNonNull(nameConstraints, "nameConstraints");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getNameConstraints() nameConstraints} to nameConstraints.
     * @param nameConstraints The value for nameConstraints
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name_constraints")
    @JsonPropertyDescription("Specifies a namespace within which all subject names in subsequent certificates in a certification path MUST be located.")
    public final Builder nameConstraints(Optional<String> nameConstraints) {
      this.nameConstraints = nameConstraints.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getPolicyConstraints() policyConstraints} to policyConstraints.
     * @param policyConstraints The value for policyConstraints
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder policyConstraints(String policyConstraints) {
      this.policyConstraints = Objects.requireNonNull(policyConstraints, "policyConstraints");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getPolicyConstraints() policyConstraints} to policyConstraints.
     * @param policyConstraints The value for policyConstraints
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("policy_constraints")
    @JsonPropertyDescription("Specifies any constraints on path validation for certificates issued to CAs.")
    public final Builder policyConstraints(Optional<String> policyConstraints) {
      this.policyConstraints = policyConstraints.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getKeyUsage() keyUsage} to keyUsage.
     * @param keyUsage The value for keyUsage
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder keyUsage(String keyUsage) {
      this.keyUsage = Objects.requireNonNull(keyUsage, "keyUsage");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getKeyUsage() keyUsage} to keyUsage.
     * @param keyUsage The value for keyUsage
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("key_usage")
    @JsonPropertyDescription("Specifies a multi-valued extension consisting of a list of names of the permitted key usages.")
    public final Builder keyUsage(Optional<String> keyUsage) {
      this.keyUsage = keyUsage.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getExtendedKeyUsage() extendedKeyUsage} to extendedKeyUsage.
     * @param extendedKeyUsage The value for extendedKeyUsage
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder extendedKeyUsage(String extendedKeyUsage) {
      this.extendedKeyUsage = Objects.requireNonNull(extendedKeyUsage, "extendedKeyUsage");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getExtendedKeyUsage() extendedKeyUsage} to extendedKeyUsage.
     * @param extendedKeyUsage The value for extendedKeyUsage
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("extended_key_usage")
    @JsonPropertyDescription("Specifies a list of usages indicating purposes for which the certificate public key can be used for.")
    public final Builder extendedKeyUsage(Optional<String> extendedKeyUsage) {
      this.extendedKeyUsage = extendedKeyUsage.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getSubjectKeyIdentifier() subjectKeyIdentifier} to subjectKeyIdentifier.
     * @param subjectKeyIdentifier The value for subjectKeyIdentifier
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder subjectKeyIdentifier(String subjectKeyIdentifier) {
      this.subjectKeyIdentifier = Objects.requireNonNull(subjectKeyIdentifier, "subjectKeyIdentifier");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getSubjectKeyIdentifier() subjectKeyIdentifier} to subjectKeyIdentifier.
     * @param subjectKeyIdentifier The value for subjectKeyIdentifier
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subject_key_identifier")
    @JsonPropertyDescription("Specifies the identifier that provides a means of identifying certificates that contain a particular public key.")
    public final Builder subjectKeyIdentifier(Optional<String> subjectKeyIdentifier) {
      this.subjectKeyIdentifier = subjectKeyIdentifier.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getAuthorityKeyIdentifier() authorityKeyIdentifier} to authorityKeyIdentifier.
     * @param authorityKeyIdentifier The value for authorityKeyIdentifier
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder authorityKeyIdentifier(String authorityKeyIdentifier) {
      this.authorityKeyIdentifier = Objects.requireNonNull(authorityKeyIdentifier, "authorityKeyIdentifier");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getAuthorityKeyIdentifier() authorityKeyIdentifier} to authorityKeyIdentifier.
     * @param authorityKeyIdentifier The value for authorityKeyIdentifier
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("authority_key_identifier")
    @JsonPropertyDescription("Specifies the identifier that provides a means of identifying the public key corresponding to the key used to sign a certificate.")
    public final Builder authorityKeyIdentifier(Optional<String> authorityKeyIdentifier) {
      this.authorityKeyIdentifier = authorityKeyIdentifier.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getSubjectAlternativeName() subjectAlternativeName} to subjectAlternativeName.
     * @param subjectAlternativeName The value for subjectAlternativeName
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder subjectAlternativeName(String subjectAlternativeName) {
      this.subjectAlternativeName = Objects.requireNonNull(subjectAlternativeName, "subjectAlternativeName");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getSubjectAlternativeName() subjectAlternativeName} to subjectAlternativeName.
     * @param subjectAlternativeName The value for subjectAlternativeName
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subject_alternative_name")
    @JsonPropertyDescription("Specifies the additional identities to be bound to the subject of the certificate.")
    public final Builder subjectAlternativeName(Optional<String> subjectAlternativeName) {
      this.subjectAlternativeName = subjectAlternativeName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getIssuerAlternativeName() issuerAlternativeName} to issuerAlternativeName.
     * @param issuerAlternativeName The value for issuerAlternativeName
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder issuerAlternativeName(String issuerAlternativeName) {
      this.issuerAlternativeName = Objects.requireNonNull(issuerAlternativeName, "issuerAlternativeName");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getIssuerAlternativeName() issuerAlternativeName} to issuerAlternativeName.
     * @param issuerAlternativeName The value for issuerAlternativeName
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("issuer_alternative_name")
    @JsonPropertyDescription("Specifies the additional identities to be bound to the issuer of the certificate.")
    public final Builder issuerAlternativeName(Optional<String> issuerAlternativeName) {
      this.issuerAlternativeName = issuerAlternativeName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getSubjectDirectoryAttributes() subjectDirectoryAttributes} to subjectDirectoryAttributes.
     * @param subjectDirectoryAttributes The value for subjectDirectoryAttributes
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder subjectDirectoryAttributes(String subjectDirectoryAttributes) {
      this.subjectDirectoryAttributes = Objects.requireNonNull(subjectDirectoryAttributes, "subjectDirectoryAttributes");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getSubjectDirectoryAttributes() subjectDirectoryAttributes} to subjectDirectoryAttributes.
     * @param subjectDirectoryAttributes The value for subjectDirectoryAttributes
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subject_directory_attributes")
    @JsonPropertyDescription("Specifies the identification attributes (e.g., nationality) of the subject.")
    public final Builder subjectDirectoryAttributes(Optional<String> subjectDirectoryAttributes) {
      this.subjectDirectoryAttributes = subjectDirectoryAttributes.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getCrlDistributionPoints() crlDistributionPoints} to crlDistributionPoints.
     * @param crlDistributionPoints The value for crlDistributionPoints
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder crlDistributionPoints(String crlDistributionPoints) {
      this.crlDistributionPoints = Objects.requireNonNull(crlDistributionPoints, "crlDistributionPoints");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getCrlDistributionPoints() crlDistributionPoints} to crlDistributionPoints.
     * @param crlDistributionPoints The value for crlDistributionPoints
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("crl_distribution_points")
    @JsonPropertyDescription("Specifies how CRL information is obtained.")
    public final Builder crlDistributionPoints(Optional<String> crlDistributionPoints) {
      this.crlDistributionPoints = crlDistributionPoints.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getInhibitAnyPolicy() inhibitAnyPolicy} to inhibitAnyPolicy.
     * @param inhibitAnyPolicy The value for inhibitAnyPolicy
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder inhibitAnyPolicy(String inhibitAnyPolicy) {
      this.inhibitAnyPolicy = Objects.requireNonNull(inhibitAnyPolicy, "inhibitAnyPolicy");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getInhibitAnyPolicy() inhibitAnyPolicy} to inhibitAnyPolicy.
     * @param inhibitAnyPolicy The value for inhibitAnyPolicy
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("inhibit_any_policy")
    @JsonPropertyDescription("Specifies the number of additional certificates that may appear in the path before anyPolicy is no longer permitted.")
    public final Builder inhibitAnyPolicy(Optional<String> inhibitAnyPolicy) {
      this.inhibitAnyPolicy = inhibitAnyPolicy.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getPrivateKeyUsagePeriodNotBefore() privateKeyUsagePeriodNotBefore} to privateKeyUsagePeriodNotBefore.
     * @param privateKeyUsagePeriodNotBefore The value for privateKeyUsagePeriodNotBefore
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder privateKeyUsagePeriodNotBefore(StixInstant privateKeyUsagePeriodNotBefore) {
      this.privateKeyUsagePeriodNotBefore = Objects.requireNonNull(privateKeyUsagePeriodNotBefore, "privateKeyUsagePeriodNotBefore");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getPrivateKeyUsagePeriodNotBefore() privateKeyUsagePeriodNotBefore} to privateKeyUsagePeriodNotBefore.
     * @param privateKeyUsagePeriodNotBefore The value for privateKeyUsagePeriodNotBefore
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("private_key_usage_period_not_before")
    @JsonPropertyDescription("Specifies the date on which the validity period begins for the key, if it is different from the validity period of the certificate.")
    public final Builder privateKeyUsagePeriodNotBefore(Optional<? extends StixInstant> privateKeyUsagePeriodNotBefore) {
      this.privateKeyUsagePeriodNotBefore = privateKeyUsagePeriodNotBefore.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getPrivateKeyUsagePeriodNotAfter() privateKeyUsagePeriodNotAfter} to privateKeyUsagePeriodNotAfter.
     * @param privateKeyUsagePeriodNotAfter The value for privateKeyUsagePeriodNotAfter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder privateKeyUsagePeriodNotAfter(StixInstant privateKeyUsagePeriodNotAfter) {
      this.privateKeyUsagePeriodNotAfter = Objects.requireNonNull(privateKeyUsagePeriodNotAfter, "privateKeyUsagePeriodNotAfter");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getPrivateKeyUsagePeriodNotAfter() privateKeyUsagePeriodNotAfter} to privateKeyUsagePeriodNotAfter.
     * @param privateKeyUsagePeriodNotAfter The value for privateKeyUsagePeriodNotAfter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("private_key_usage_period_not_after")
    @JsonPropertyDescription("Specifies the date on which the validity period ends for the key, if it is different from the validity period of the certificate.")
    public final Builder privateKeyUsagePeriodNotAfter(Optional<? extends StixInstant> privateKeyUsagePeriodNotAfter) {
      this.privateKeyUsagePeriodNotAfter = privateKeyUsagePeriodNotAfter.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getCertificatePolicies() certificatePolicies} to certificatePolicies.
     * @param certificatePolicies The value for certificatePolicies
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder certificatePolicies(String certificatePolicies) {
      this.certificatePolicies = Objects.requireNonNull(certificatePolicies, "certificatePolicies");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getCertificatePolicies() certificatePolicies} to certificatePolicies.
     * @param certificatePolicies The value for certificatePolicies
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("certificate_policies")
    @JsonPropertyDescription("Specifies a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers.")
    public final Builder certificatePolicies(Optional<String> certificatePolicies) {
      this.certificatePolicies = certificatePolicies.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getPolicyMappings() policyMappings} to policyMappings.
     * @param policyMappings The value for policyMappings
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder policyMappings(String policyMappings) {
      this.policyMappings = Objects.requireNonNull(policyMappings, "policyMappings");
      return this;
    }

    /**
     * Initializes the optional value {@link X509v3ExtensionsObj#getPolicyMappings() policyMappings} to policyMappings.
     * @param policyMappings The value for policyMappings
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("policy_mappings")
    @JsonPropertyDescription("Specifies one or more pairs of OIDs(); each pair includes an issuerDomainPolicy and a subjectDomainPolicy")
    public final Builder policyMappings(Optional<String> policyMappings) {
      this.policyMappings = policyMappings.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link X509v3ExtensionsObj#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link X509v3ExtensionsObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link X509v3ExtensionsObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link X509v3ExtensionsObj#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link X509v3Extensions X509v3Extensions}.
     * @return An immutable instance of X509v3Extensions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public X509v3Extensions build() {
      return X509v3Extensions.validate(new X509v3Extensions(
          basicConstraints,
          nameConstraints,
          policyConstraints,
          keyUsage,
          extendedKeyUsage,
          subjectKeyIdentifier,
          authorityKeyIdentifier,
          subjectAlternativeName,
          issuerAlternativeName,
          subjectDirectoryAttributes,
          crlDistributionPoints,
          inhibitAnyPolicy,
          privateKeyUsagePeriodNotBefore,
          privateKeyUsagePeriodNotAfter,
          certificatePolicies,
          policyMappings,
          customProperties.build()));
    }
  }
}
