package security.whisper.javastix.custom.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixBoolean;
import security.whisper.javastix.common.StixCommonProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.common.StixLabels;
import security.whisper.javastix.common.StixModified;
import security.whisper.javastix.common.StixRevoked;
import security.whisper.javastix.custom.StixCustomObject;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectOptionalConverter;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.objects.IdentitySdo;
import security.whisper.javastix.sdo.types.ExternalReferenceType;
import security.whisper.javastix.validation.constraints.startswith.StartsWith;

/**
 * Immutable implementation of {@link GenericCustomObject}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CustomObject.builder()}.
 */
@Generated(from = "GenericCustomObject", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class CustomObject implements GenericCustomObject {
  private final java.lang.@StartsWith("x-") String type;
  private final java.lang.@StartsWith("x-") String id;
  private final ImmutableMap<String, Object> customObjectProperties;
  private final boolean hydrated;
  private final @Nullable IdentitySdo createdByRef;
  private final StixInstant created;
  private final @Nullable String lang;
  private final ImmutableSet<ExternalReferenceType> externalReferences;
  private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
  private final ImmutableSet<GranularMarkingDm> granularMarkings;
  private final ImmutableSet<String> labels;
  private final StixInstant modified;
  private final StixBoolean revoked;

  private CustomObject(CustomObject.Builder builder) {
    this.type = builder.type;
    this.id = builder.id;
    this.customObjectProperties = builder.customObjectProperties.build();
    this.createdByRef = builder.createdByRef;
    this.lang = builder.lang;
    if (builder.hydratedIsSet()) {
      initShim.hydrated(builder.hydrated);
    }
    if (builder.created != null) {
      initShim.created(builder.created);
    }
    if (builder.externalReferencesIsSet()) {
      initShim.externalReferences(builder.externalReferences.build());
    }
    if (builder.objectMarkingRefsIsSet()) {
      initShim.objectMarkingRefs(builder.objectMarkingRefs.build());
    }
    if (builder.granularMarkingsIsSet()) {
      initShim.granularMarkings(builder.granularMarkings.build());
    }
    if (builder.labelsIsSet()) {
      initShim.labels(builder.labels.build());
    }
    if (builder.modified != null) {
      initShim.modified(builder.modified);
    }
    if (builder.revoked != null) {
      initShim.revoked(builder.revoked);
    }
    this.hydrated = initShim.getHydrated();
    this.created = initShim.getCreated();
    this.externalReferences = initShim.getExternalReferences();
    this.objectMarkingRefs = initShim.getObjectMarkingRefs();
    this.granularMarkings = initShim.getGranularMarkings();
    this.labels = initShim.getLabels();
    this.modified = initShim.getModified();
    this.revoked = initShim.getRevoked();
    this.initShim = null;
  }

  private CustomObject(
      java.lang.@StartsWith("x-") String type,
      java.lang.@StartsWith("x-") String id,
      ImmutableMap<String, Object> customObjectProperties,
      boolean hydrated,
      @Nullable IdentitySdo createdByRef,
      StixInstant created,
      @Nullable String lang,
      ImmutableSet<ExternalReferenceType> externalReferences,
      ImmutableSet<MarkingDefinitionDm> objectMarkingRefs,
      ImmutableSet<GranularMarkingDm> granularMarkings,
      ImmutableSet<String> labels,
      StixInstant modified,
      StixBoolean revoked) {
    this.type = type;
    this.id = id;
    this.customObjectProperties = customObjectProperties;
    this.hydrated = hydrated;
    this.createdByRef = createdByRef;
    this.created = created;
    this.lang = lang;
    this.externalReferences = externalReferences;
    this.objectMarkingRefs = objectMarkingRefs;
    this.granularMarkings = granularMarkings;
    this.labels = labels;
    this.modified = modified;
    this.revoked = revoked;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GenericCustomObject", generator = "Immutables")
  private final class InitShim {
    private byte hydratedBuildStage = STAGE_UNINITIALIZED;
    private boolean hydrated;

    boolean getHydrated() {
      if (hydratedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hydratedBuildStage == STAGE_UNINITIALIZED) {
        hydratedBuildStage = STAGE_INITIALIZING;
        this.hydrated = getHydratedInitialize();
        hydratedBuildStage = STAGE_INITIALIZED;
      }
      return this.hydrated;
    }

    void hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      hydratedBuildStage = STAGE_INITIALIZED;
    }

    private byte createdBuildStage = STAGE_UNINITIALIZED;
    private StixInstant created;

    StixInstant getCreated() {
      if (createdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (createdBuildStage == STAGE_UNINITIALIZED) {
        createdBuildStage = STAGE_INITIALIZING;
        this.created = Objects.requireNonNull(getCreatedInitialize(), "created");
        createdBuildStage = STAGE_INITIALIZED;
      }
      return this.created;
    }

    void created(StixInstant created) {
      this.created = created;
      createdBuildStage = STAGE_INITIALIZED;
    }

    private byte externalReferencesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<ExternalReferenceType> externalReferences;

    ImmutableSet<ExternalReferenceType> getExternalReferences() {
      if (externalReferencesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (externalReferencesBuildStage == STAGE_UNINITIALIZED) {
        externalReferencesBuildStage = STAGE_INITIALIZING;
        this.externalReferences = ImmutableSet.copyOf(getExternalReferencesInitialize());
        externalReferencesBuildStage = STAGE_INITIALIZED;
      }
      return this.externalReferences;
    }

    void externalReferences(ImmutableSet<ExternalReferenceType> externalReferences) {
      this.externalReferences = externalReferences;
      externalReferencesBuildStage = STAGE_INITIALIZED;
    }

    private byte objectMarkingRefsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;

    ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
      if (objectMarkingRefsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectMarkingRefsBuildStage == STAGE_UNINITIALIZED) {
        objectMarkingRefsBuildStage = STAGE_INITIALIZING;
        this.objectMarkingRefs = ImmutableSet.copyOf(getObjectMarkingRefsInitialize());
        objectMarkingRefsBuildStage = STAGE_INITIALIZED;
      }
      return this.objectMarkingRefs;
    }

    void objectMarkingRefs(ImmutableSet<MarkingDefinitionDm> objectMarkingRefs) {
      this.objectMarkingRefs = objectMarkingRefs;
      objectMarkingRefsBuildStage = STAGE_INITIALIZED;
    }

    private byte granularMarkingsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<GranularMarkingDm> granularMarkings;

    ImmutableSet<GranularMarkingDm> getGranularMarkings() {
      if (granularMarkingsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (granularMarkingsBuildStage == STAGE_UNINITIALIZED) {
        granularMarkingsBuildStage = STAGE_INITIALIZING;
        this.granularMarkings = ImmutableSet.copyOf(getGranularMarkingsInitialize());
        granularMarkingsBuildStage = STAGE_INITIALIZED;
      }
      return this.granularMarkings;
    }

    void granularMarkings(ImmutableSet<GranularMarkingDm> granularMarkings) {
      this.granularMarkings = granularMarkings;
      granularMarkingsBuildStage = STAGE_INITIALIZED;
    }

    private byte labelsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<String> labels;

    ImmutableSet<String> getLabels() {
      if (labelsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (labelsBuildStage == STAGE_UNINITIALIZED) {
        labelsBuildStage = STAGE_INITIALIZING;
        this.labels = ImmutableSet.copyOf(getLabelsInitialize());
        labelsBuildStage = STAGE_INITIALIZED;
      }
      return this.labels;
    }

    void labels(ImmutableSet<String> labels) {
      this.labels = labels;
      labelsBuildStage = STAGE_INITIALIZED;
    }

    private byte modifiedBuildStage = STAGE_UNINITIALIZED;
    private StixInstant modified;

    StixInstant getModified() {
      if (modifiedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (modifiedBuildStage == STAGE_UNINITIALIZED) {
        modifiedBuildStage = STAGE_INITIALIZING;
        this.modified = Objects.requireNonNull(getModifiedInitialize(), "modified");
        modifiedBuildStage = STAGE_INITIALIZED;
      }
      return this.modified;
    }

    void modified(StixInstant modified) {
      this.modified = modified;
      modifiedBuildStage = STAGE_INITIALIZED;
    }

    private byte revokedBuildStage = STAGE_UNINITIALIZED;
    private StixBoolean revoked;

    StixBoolean getRevoked() {
      if (revokedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (revokedBuildStage == STAGE_UNINITIALIZED) {
        revokedBuildStage = STAGE_INITIALIZING;
        this.revoked = Objects.requireNonNull(getRevokedInitialize(), "revoked");
        revokedBuildStage = STAGE_INITIALIZED;
      }
      return this.revoked;
    }

    void revoked(StixBoolean revoked) {
      this.revoked = revoked;
      revokedBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (hydratedBuildStage == STAGE_INITIALIZING) attributes.add("hydrated");
      if (createdBuildStage == STAGE_INITIALIZING) attributes.add("created");
      if (externalReferencesBuildStage == STAGE_INITIALIZING) attributes.add("externalReferences");
      if (objectMarkingRefsBuildStage == STAGE_INITIALIZING) attributes.add("objectMarkingRefs");
      if (granularMarkingsBuildStage == STAGE_INITIALIZING) attributes.add("granularMarkings");
      if (labelsBuildStage == STAGE_INITIALIZING) attributes.add("labels");
      if (modifiedBuildStage == STAGE_INITIALIZING) attributes.add("modified");
      if (revokedBuildStage == STAGE_INITIALIZING) attributes.add("revoked");
      return "Cannot build CustomObject, attribute initializers form cycle " + attributes;
    }
  }

  private boolean getHydratedInitialize() {
    return GenericCustomObject.super.getHydrated();
  }

  private StixInstant getCreatedInitialize() {
    return GenericCustomObject.super.getCreated();
  }

  private Set<ExternalReferenceType> getExternalReferencesInitialize() {
    return GenericCustomObject.super.getExternalReferences();
  }

  private Set<MarkingDefinitionDm> getObjectMarkingRefsInitialize() {
    return GenericCustomObject.super.getObjectMarkingRefs();
  }

  private Set<GranularMarkingDm> getGranularMarkingsInitialize() {
    return GenericCustomObject.super.getGranularMarkings();
  }

  private Set<String> getLabelsInitialize() {
    return GenericCustomObject.super.getLabels();
  }

  private StixInstant getModifiedInitialize() {
    return GenericCustomObject.super.getModified();
  }

  private StixBoolean getRevokedInitialize() {
    return GenericCustomObject.super.getRevoked();
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public java.lang.@StartsWith("x-") String getType() {
    return type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public java.lang.@StartsWith("x-") String getId() {
    return id;
  }

  /**
   * @return The value of the {@code customObjectProperties} attribute
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomObjectProperties() {
    return customObjectProperties;
  }

  /**
   * Dictates if the object is hydrated.
   * Hydration is defined as if the Object has only a "ID" or has been properly
   * hydrated with the expected required fields
   * @return boolean
   */
  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @Override
  public boolean getHydrated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHydrated()
        : this.hydrated;
  }

  /**
   * @return The value of the {@code createdByRef} attribute
   */
  @JsonProperty("created_by_ref")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
  @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
  @JsonIdentityReference(alwaysAsId = true)
  @JsonDeserialize(converter = DomainObjectOptionalConverter.class)
  @Redactable(useMask = true, redactionMask = "identity--__REDACTED__")
  @Override
  public Optional<IdentitySdo> getCreatedByRef() {
    return Optional.ofNullable(createdByRef);
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @JsonPropertyDescription("The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
  @Redactable(useMask = true, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getCreated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCreated()
        : this.created;
  }

  /**
   * @return The value of the {@code lang} attribute
   */
  @JsonProperty("lang")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Identifies the language of the text content in this object using ISO 639-2 language codes.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getLang() {
    return Optional.ofNullable(lang);
  }

  /**
   * @return The value of the {@code externalReferences} attribute
   */
  @JsonProperty("external_references")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A list of external references which refers to non-STIX information.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<ExternalReferenceType> getExternalReferences() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExternalReferences()
        : this.externalReferences;
  }

  /**
   * @return The value of the {@code objectMarkingRefs} attribute
   */
  @JsonProperty("object_marking_refs")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
  @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
  @JsonIdentityReference(alwaysAsId = true)
  @JsonDeserialize(converter = MarkingDefinitionSetConverter.class)
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObjectMarkingRefs()
        : this.objectMarkingRefs;
  }

  /**
   * @return The value of the {@code granularMarkings} attribute
   */
  @JsonProperty("granular_markings")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The set of granular markings that apply to this object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getGranularMarkings()
        : this.granularMarkings;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The labels property specifies a set of classifications.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<String> getLabels() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLabels()
        : this.labels;
  }

  /**
   * @return The value of the {@code modified} attribute
   */
  @JsonProperty("modified")
  @JsonPropertyDescription("The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getModified() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getModified()
        : this.modified;
  }

  /**
   * @return The value of the {@code revoked} attribute
   */
  @JsonProperty("revoked")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The revoked property indicates whether the object has been revoked.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixBoolean getRevoked() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRevoked()
        : this.revoked;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericCustomObject#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final CustomObject withType(java.lang.@StartsWith("x-") String value) {
    if (this.type == value) return this;
    return validate(new CustomObject(
        value,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericCustomObject#getId() id} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final CustomObject withId(java.lang.@StartsWith("x-") String value) {
    if (this.id == value) return this;
    return validate(new CustomObject(
        this.type,
        value,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by replacing the {@link GenericCustomObject#getCustomObjectProperties() customObjectProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customObjectProperties map
   * @return A modified copy of {@code this} object
   */
  public final CustomObject withCustomObjectProperties(Map<String, ? extends Object> entries) {
    if (this.customObjectProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new CustomObject(
        this.type,
        this.id,
        newValue,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericCustomObject#getHydrated() hydrated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hydrated
   * @return A modified copy of the {@code this} object
   */
  public final CustomObject withHydrated(boolean value) {
    if (this.hydrated == value) return this;
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        value,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link GenericCustomObject#getCreatedByRef() createdByRef} attribute.
   * @param value The value for createdByRef
   * @return A modified copy of {@code this} object
   */
  public final CustomObject withCreatedByRef(IdentitySdo value) {
    @Nullable IdentitySdo newValue = Objects.requireNonNull(value, "createdByRef");
    if (this.createdByRef == newValue) return this;
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        newValue,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link GenericCustomObject#getCreatedByRef() createdByRef} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for createdByRef
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final CustomObject withCreatedByRef(Optional<? extends IdentitySdo> optional) {
    @Nullable IdentitySdo value = optional.orElse(null);
    if (this.createdByRef == value) return this;
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        value,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericCustomObject#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final CustomObject withCreated(StixInstant value) {
    if (this.created == value) return this;
    StixInstant newValue = Objects.requireNonNull(value, "created");
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        newValue,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link GenericCustomObject#getLang() lang} attribute.
   * @param value The value for lang
   * @return A modified copy of {@code this} object
   */
  public final CustomObject withLang(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "lang");
    if (Objects.equals(this.lang, newValue)) return this;
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        newValue,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link GenericCustomObject#getLang() lang} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for lang
   * @return A modified copy of {@code this} object
   */
  public final CustomObject withLang(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.lang, value)) return this;
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        value,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GenericCustomObject#getExternalReferences() externalReferences}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final CustomObject withExternalReferences(ExternalReferenceType... elements) {
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GenericCustomObject#getExternalReferences() externalReferences}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of externalReferences elements to set
   * @return A modified copy of {@code this} object
   */
  public final CustomObject withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
    if (this.externalReferences == elements) return this;
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GenericCustomObject#getObjectMarkingRefs() objectMarkingRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final CustomObject withObjectMarkingRefs(MarkingDefinitionDm... elements) {
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GenericCustomObject#getObjectMarkingRefs() objectMarkingRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectMarkingRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final CustomObject withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
    if (this.objectMarkingRefs == elements) return this;
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GenericCustomObject#getGranularMarkings() granularMarkings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final CustomObject withGranularMarkings(GranularMarkingDm... elements) {
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GenericCustomObject#getGranularMarkings() granularMarkings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of granularMarkings elements to set
   * @return A modified copy of {@code this} object
   */
  public final CustomObject withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
    if (this.granularMarkings == elements) return this;
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GenericCustomObject#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final CustomObject withLabels(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        newValue,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GenericCustomObject#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final CustomObject withLabels(Iterable<String> elements) {
    if (this.labels == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        newValue,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericCustomObject#getModified() modified} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modified
   * @return A modified copy of the {@code this} object
   */
  public final CustomObject withModified(StixInstant value) {
    if (this.modified == value) return this;
    StixInstant newValue = Objects.requireNonNull(value, "modified");
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        newValue,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericCustomObject#getRevoked() revoked} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revoked
   * @return A modified copy of the {@code this} object
   */
  public final CustomObject withRevoked(StixBoolean value) {
    if (this.revoked == value) return this;
    StixBoolean newValue = Objects.requireNonNull(value, "revoked");
    return validate(new CustomObject(
        this.type,
        this.id,
        this.customObjectProperties,
        this.hydrated,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.labels,
        this.modified,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code CustomObject} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof CustomObject
        && equalTo((CustomObject) another);
  }

  private boolean equalTo(CustomObject another) {
    return Objects.equals(type, another.type)
        && Objects.equals(id, another.id)
        && customObjectProperties.equals(another.customObjectProperties)
        && hydrated == another.hydrated
        && Objects.equals(createdByRef, another.createdByRef)
        && created.equals(another.created)
        && Objects.equals(lang, another.lang)
        && externalReferences.equals(another.externalReferences)
        && objectMarkingRefs.equals(another.objectMarkingRefs)
        && granularMarkings.equals(another.granularMarkings)
        && labels.equals(another.labels)
        && modified.equals(another.modified)
        && revoked.equals(another.revoked);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code id}, {@code customObjectProperties}, {@code hydrated}, {@code createdByRef}, {@code created}, {@code lang}, {@code externalReferences}, {@code objectMarkingRefs}, {@code granularMarkings}, {@code labels}, {@code modified}, {@code revoked}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + customObjectProperties.hashCode();
    h += (h << 5) + Booleans.hashCode(hydrated);
    h += (h << 5) + Objects.hashCode(createdByRef);
    h += (h << 5) + created.hashCode();
    h += (h << 5) + Objects.hashCode(lang);
    h += (h << 5) + externalReferences.hashCode();
    h += (h << 5) + objectMarkingRefs.hashCode();
    h += (h << 5) + granularMarkings.hashCode();
    h += (h << 5) + labels.hashCode();
    h += (h << 5) + modified.hashCode();
    h += (h << 5) + revoked.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CustomObject} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CustomObject")
        .omitNullValues()
        .add("type", type)
        .add("id", id)
        .add("customObjectProperties", customObjectProperties)
        .add("hydrated", hydrated)
        .add("createdByRef", createdByRef)
        .add("created", created)
        .add("lang", lang)
        .add("externalReferences", externalReferences)
        .add("objectMarkingRefs", objectMarkingRefs)
        .add("granularMarkings", granularMarkings)
        .add("labels", labels)
        .add("modified", modified)
        .add("revoked", revoked)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long TO_JSON_STRING_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String toJsonString;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link GenericCustomObject#toJsonString() toJsonString} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code toJsonString} attribute
   */
  @Override
  public String toJsonString() {
    if ((lazyInitBitmap & TO_JSON_STRING_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TO_JSON_STRING_LAZY_INIT_BIT) == 0) {
          this.toJsonString = Objects.requireNonNull(GenericCustomObject.super.toJsonString(), "toJsonString");
          lazyInitBitmap |= TO_JSON_STRING_LAZY_INIT_BIT;
        }
      }
    }
    return toJsonString;
  }

  private static final long SPEC_VERSION_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient String specVersion;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link GenericCustomObject#getSpecVersion() specVersion} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code specVersion} attribute
   */
  @Override
  public String getSpecVersion() {
    if ((lazyInitBitmap & SPEC_VERSION_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SPEC_VERSION_LAZY_INIT_BIT) == 0) {
          this.specVersion = Objects.requireNonNull(GenericCustomObject.super.getSpecVersion(), "specVersion");
          lazyInitBitmap |= SPEC_VERSION_LAZY_INIT_BIT;
        }
      }
    }
    return specVersion;
  }


  private static CustomObject validate(CustomObject instance) {
    instance.checkHydrationValidation();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link GenericCustomObject} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CustomObject instance
   */
  public static CustomObject copyOf(GenericCustomObject instance) {
    if (instance instanceof CustomObject) {
      return (CustomObject) instance;
    }
    return CustomObject.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link CustomObject CustomObject}.
   * @return A new CustomObject builder
   */
  public static CustomObject.Builder builder() {
    return new CustomObject.Builder();
  }

  /**
   * Builds instances of type {@link CustomObject CustomObject}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GenericCustomObject", generator = "Immutables")
  @NotThreadSafe
  @JsonPropertyOrder({"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings"})
  public static final class Builder {
    private static final long OPT_BIT_HYDRATED = 0x1L;
    private static final long OPT_BIT_EXTERNAL_REFERENCES = 0x2L;
    private static final long OPT_BIT_OBJECT_MARKING_REFS = 0x4L;
    private static final long OPT_BIT_GRANULAR_MARKINGS = 0x8L;
    private static final long OPT_BIT_LABELS = 0x10L;
    private long optBits;

    private @Nullable java.lang.@StartsWith("x-") String type;
    private @Nullable java.lang.@StartsWith("x-") String id;
    private ImmutableMap.Builder<String, Object> customObjectProperties = ImmutableMap.builder();
    private boolean hydrated;
    private @Nullable IdentitySdo createdByRef;
    private @Nullable StixInstant created;
    private @Nullable String lang;
    private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
    private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
    private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
    private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
    private @Nullable StixInstant modified;
    private @Nullable StixBoolean revoked;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleableObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleableObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixRevoked} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixRevoked instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.custom.StixCustomObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixLabels} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixLabels instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixModified} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixModified instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.custom.objects.GenericCustomObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GenericCustomObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BundleableObject) {
        BundleableObject instance = (BundleableObject) object;
        if ((bits & 0x8L) == 0) {
          java.lang.@StartsWith("x-") String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x10L;
        }
        if ((bits & 0x1L) == 0) {
          java.lang.@StartsWith("x-") String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          hydrated(instance.getHydrated());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x4L;
        }
      }
      if (object instanceof StixCommonProperties) {
        StixCommonProperties instance = (StixCommonProperties) object;
        addAllExternalReferences(instance.getExternalReferences());
        if ((bits & 0x2L) == 0) {
          hydrated(instance.getHydrated());
          bits |= 0x2L;
        }
        created(instance.getCreated());
        if ((bits & 0x4L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x4L;
        }
        Optional<IdentitySdo> createdByRefOptional = instance.getCreatedByRef();
        if (createdByRefOptional.isPresent()) {
          createdByRef(createdByRefOptional);
        }
        if ((bits & 0x8L) == 0) {
          java.lang.@StartsWith("x-") String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x10L;
        }
        if ((bits & 0x1L) == 0) {
          java.lang.@StartsWith("x-") String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        Optional<String> langOptional = instance.getLang();
        if (langOptional.isPresent()) {
          lang(langOptional);
        }
      }
      if (object instanceof StixRevoked) {
        StixRevoked instance = (StixRevoked) object;
        revoked(instance.getRevoked());
      }
      if (object instanceof StixCustomObject) {
        StixCustomObject instance = (StixCustomObject) object;
        if ((bits & 0x1L) == 0) {
          java.lang.@StartsWith("x-") String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x8L) == 0) {
          java.lang.@StartsWith("x-") String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x8L;
        }
        putAllCustomObjectProperties(instance.getCustomObjectProperties());
      }
      if (object instanceof StixLabels) {
        StixLabels instance = (StixLabels) object;
        addAllLabels(instance.getLabels());
      }
      if (object instanceof StixModified) {
        StixModified instance = (StixModified) object;
        modified(instance.getModified());
      }
    }

    /**
     * Initializes the value for the {@link GenericCustomObject#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(java.lang.@StartsWith("x-") String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link GenericCustomObject#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(java.lang.@StartsWith("x-") String id) {
      this.id = id;
      return this;
    }

    /**
     * Put one entry to the {@link GenericCustomObject#getCustomObjectProperties() customObjectProperties} map.
     * @param key The key in the customObjectProperties map
     * @param value The associated value in the customObjectProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomObjectProperty(String key, Object value) {
      this.customObjectProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GenericCustomObject#getCustomObjectProperties() customObjectProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomObjectProperty(Map.Entry<String, ? extends Object> entry) {
      this.customObjectProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GenericCustomObject#getCustomObjectProperties() customObjectProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customObjectProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customObjectProperties(Map<String, ? extends Object> entries) {
      this.customObjectProperties = ImmutableMap.builder();
      return putAllCustomObjectProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GenericCustomObject#getCustomObjectProperties() customObjectProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customObjectProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomObjectProperties(Map<String, ? extends Object> entries) {
      this.customObjectProperties.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link GenericCustomObject#getHydrated() hydrated} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GenericCustomObject#getHydrated() hydrated}.</em>
     * @param hydrated The value for hydrated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    public final Builder hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      optBits |= OPT_BIT_HYDRATED;
      return this;
    }

    /**
     * Initializes the optional value {@link GenericCustomObject#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder createdByRef(IdentitySdo createdByRef) {
      this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
      return this;
    }

    /**
     * Initializes the optional value {@link GenericCustomObject#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created_by_ref")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
    @JsonIdentityReference(alwaysAsId = true)
    @JsonDeserialize(converter = DomainObjectOptionalConverter.class)
    public final Builder createdByRef(Optional<? extends IdentitySdo> createdByRef) {
      this.createdByRef = createdByRef.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link GenericCustomObject#getCreated() created} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GenericCustomObject#getCreated() created}.</em>
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    @JsonPropertyDescription("The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
    public final Builder created(StixInstant created) {
      this.created = Objects.requireNonNull(created, "created");
      return this;
    }

    /**
     * Initializes the optional value {@link GenericCustomObject#getLang() lang} to lang.
     * @param lang The value for lang
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder lang(String lang) {
      this.lang = Objects.requireNonNull(lang, "lang");
      return this;
    }

    /**
     * Initializes the optional value {@link GenericCustomObject#getLang() lang} to lang.
     * @param lang The value for lang
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lang")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Identifies the language of the text content in this object using ISO 639-2 language codes.")
    public final Builder lang(Optional<String> lang) {
      this.lang = lang.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link GenericCustomObject#getExternalReferences() externalReferences} set.
     * @param element A externalReferences element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
      this.externalReferences.add(element);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }

    /**
     * Adds elements to {@link GenericCustomObject#getExternalReferences() externalReferences} set.
     * @param elements An array of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReferences(ExternalReferenceType... elements) {
      this.externalReferences.add(elements);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GenericCustomObject#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("external_references")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A list of external references which refers to non-STIX information.")
    public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences = ImmutableSet.builder();
      return addAllExternalReferences(elements);
    }

    /**
     * Adds elements to {@link GenericCustomObject#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences.addAll(elements);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }

    /**
     * Adds one element to {@link GenericCustomObject#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param element A objectMarkingRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
      this.objectMarkingRefs.add(element);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }

    /**
     * Adds elements to {@link GenericCustomObject#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An array of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRefs(MarkingDefinitionDm... elements) {
      this.objectMarkingRefs.add(elements);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GenericCustomObject#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("object_marking_refs")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
    @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
    @JsonIdentityReference(alwaysAsId = true)
    @JsonDeserialize(converter = MarkingDefinitionSetConverter.class)
    public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs = ImmutableSet.builder();
      return addAllObjectMarkingRefs(elements);
    }

    /**
     * Adds elements to {@link GenericCustomObject#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs.addAll(elements);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }

    /**
     * Adds one element to {@link GenericCustomObject#getGranularMarkings() granularMarkings} set.
     * @param element A granularMarkings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
      this.granularMarkings.add(element);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }

    /**
     * Adds elements to {@link GenericCustomObject#getGranularMarkings() granularMarkings} set.
     * @param elements An array of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarkings(GranularMarkingDm... elements) {
      this.granularMarkings.add(elements);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GenericCustomObject#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("granular_markings")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The set of granular markings that apply to this object.")
    public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings = ImmutableSet.builder();
      return addAllGranularMarkings(elements);
    }

    /**
     * Adds elements to {@link GenericCustomObject#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings.addAll(elements);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }

    /**
     * Adds one element to {@link GenericCustomObject#getLabels() labels} set.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabel(@Nullable String element) {
      this.labels.add(element);
      optBits |= OPT_BIT_LABELS;
      return this;
    }

    /**
     * Adds elements to {@link GenericCustomObject#getLabels() labels} set.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(String... elements) {
      this.labels.add(elements);
      optBits |= OPT_BIT_LABELS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GenericCustomObject#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labels")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The labels property specifies a set of classifications.")
    public final Builder labels(Iterable<String> elements) {
      this.labels = ImmutableSet.builder();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link GenericCustomObject#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<String> elements) {
      this.labels.addAll(elements);
      optBits |= OPT_BIT_LABELS;
      return this;
    }

    /**
     * Initializes the value for the {@link GenericCustomObject#getModified() modified} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GenericCustomObject#getModified() modified}.</em>
     * @param modified The value for modified 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("modified")
    @JsonPropertyDescription("The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
    public final Builder modified(StixInstant modified) {
      this.modified = Objects.requireNonNull(modified, "modified");
      return this;
    }

    /**
     * Initializes the value for the {@link GenericCustomObject#getRevoked() revoked} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GenericCustomObject#getRevoked() revoked}.</em>
     * @param revoked The value for revoked 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("revoked")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The revoked property indicates whether the object has been revoked.")
    public final Builder revoked(StixBoolean revoked) {
      this.revoked = Objects.requireNonNull(revoked, "revoked");
      return this;
    }

    /**
     * Builds a new {@link CustomObject CustomObject}.
     * @return An immutable instance of CustomObject
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CustomObject build() {
      return CustomObject.validate(new CustomObject(this));
    }

    private boolean hydratedIsSet() {
      return (optBits & OPT_BIT_HYDRATED) != 0;
    }

    private boolean externalReferencesIsSet() {
      return (optBits & OPT_BIT_EXTERNAL_REFERENCES) != 0;
    }

    private boolean objectMarkingRefsIsSet() {
      return (optBits & OPT_BIT_OBJECT_MARKING_REFS) != 0;
    }

    private boolean granularMarkingsIsSet() {
      return (optBits & OPT_BIT_GRANULAR_MARKINGS) != 0;
    }

    private boolean labelsIsSet() {
      return (optBits & OPT_BIT_LABELS) != 0;
    }
  }
}
