package security.whisper.javastix.datamarkings;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionConverter;
import security.whisper.javastix.redaction.Redactable;

/**
 * Immutable implementation of {@link GranularMarkingDm}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GranularMarking.builder()}.
 */
@Generated(from = "GranularMarkingDm", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
public final class GranularMarking implements GranularMarkingDm {
  private final MarkingDefinitionDm markingRef;
  private final ImmutableMap<String, Object> customProperties;

  private GranularMarking(
      MarkingDefinitionDm markingRef,
      ImmutableMap<String, Object> customProperties) {
    this.markingRef = markingRef;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code markingRef} attribute
   */
  @JsonProperty("marking_ref")
  @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
  @JsonIdentityReference(alwaysAsId = true)
  @JsonDeserialize(converter = MarkingDefinitionConverter.class)
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public MarkingDefinitionDm getMarkingRef() {
    return markingRef;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GranularMarkingDm#getMarkingRef() markingRef} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for markingRef (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final GranularMarking withMarkingRef(MarkingDefinitionDm value) {
    if (this.markingRef == value) return this;
    return new GranularMarking(value, this.customProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link GranularMarkingDm#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final GranularMarking withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return new GranularMarking(this.markingRef, newValue);
  }

  /**
   * This instance is equal to all instances of {@code GranularMarking} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof GranularMarking
        && equalTo((GranularMarking) another);
  }

  private boolean equalTo(GranularMarking another) {
    return Objects.equals(markingRef, another.markingRef)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code markingRef}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(markingRef);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GranularMarking} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GranularMarking")
        .omitNullValues()
        .add("markingRef", markingRef)
        .add("customProperties", customProperties)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GranularMarkingDm} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GranularMarking instance
   */
  public static GranularMarking copyOf(GranularMarkingDm instance) {
    if (instance instanceof GranularMarking) {
      return (GranularMarking) instance;
    }
    return GranularMarking.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  /**
   * Creates a builder for {@link GranularMarking GranularMarking}.
   * @return A new GranularMarking builder
   */
  public static GranularMarking.Builder builder() {
    return new GranularMarking.Builder();
  }

  /**
   * Builds instances of type {@link GranularMarking GranularMarking}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GranularMarkingDm", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable MarkingDefinitionDm markingRef;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.datamarkings.GranularMarkingDm} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GranularMarkingDm instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof GranularMarkingDm) {
        GranularMarkingDm instance = (GranularMarkingDm) object;
        MarkingDefinitionDm markingRefValue = instance.getMarkingRef();
        if (markingRefValue != null) {
          markingRef(markingRefValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link GranularMarkingDm#getMarkingRef() markingRef} attribute.
     * @param markingRef The value for markingRef (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("marking_ref")
    @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
    @JsonIdentityReference(alwaysAsId = true)
    @JsonDeserialize(converter = MarkingDefinitionConverter.class)
    public final Builder markingRef(MarkingDefinitionDm markingRef) {
      this.markingRef = markingRef;
      return this;
    }

    /**
     * Put one entry to the {@link GranularMarkingDm#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GranularMarkingDm#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GranularMarkingDm#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GranularMarkingDm#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link GranularMarking GranularMarking}.
     * @return An immutable instance of GranularMarking
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GranularMarking build() {
      return new GranularMarking(markingRef, customProperties.build());
    }
  }
}
