package security.whisper.javastix.datamarkings;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCommonProperties;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectOptionalConverter;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.objects.IdentitySdo;
import security.whisper.javastix.sdo.types.ExternalReferenceType;

/**
 * Immutable implementation of {@link MarkingDefinitionDm}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code MarkingDefinition.builder()}.
 */
@Generated(from = "MarkingDefinitionDm", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("marking-definition")
@Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
public final class MarkingDefinition implements MarkingDefinitionDm {
  private final String definitionType;
  private final StixMarkingObject definition;
  private final boolean hydrated;
  private final String type;
  private final String id;
  private final @Nullable IdentitySdo createdByRef;
  private final StixInstant created;
  private final @Nullable String lang;
  private final ImmutableSet<ExternalReferenceType> externalReferences;
  private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
  private final ImmutableSet<GranularMarkingDm> granularMarkings;
  private final ImmutableMap<String, Object> customProperties;

  private MarkingDefinition(MarkingDefinition.Builder builder) {
    this.definitionType = builder.definitionType;
    this.definition = builder.definition;
    this.type = builder.type;
    this.id = builder.id;
    this.createdByRef = builder.createdByRef;
    this.lang = builder.lang;
    this.customProperties = builder.customProperties.build();
    if (builder.hydratedIsSet()) {
      initShim.hydrated(builder.hydrated);
    }
    if (builder.created != null) {
      initShim.created(builder.created);
    }
    if (builder.externalReferencesIsSet()) {
      initShim.externalReferences(builder.externalReferences.build());
    }
    if (builder.objectMarkingRefsIsSet()) {
      initShim.objectMarkingRefs(builder.objectMarkingRefs.build());
    }
    if (builder.granularMarkingsIsSet()) {
      initShim.granularMarkings(builder.granularMarkings.build());
    }
    this.hydrated = initShim.getHydrated();
    this.created = initShim.getCreated();
    this.externalReferences = initShim.getExternalReferences();
    this.objectMarkingRefs = initShim.getObjectMarkingRefs();
    this.granularMarkings = initShim.getGranularMarkings();
    this.initShim = null;
  }

  private MarkingDefinition(
      String definitionType,
      StixMarkingObject definition,
      boolean hydrated,
      String type,
      String id,
      @Nullable IdentitySdo createdByRef,
      StixInstant created,
      @Nullable String lang,
      ImmutableSet<ExternalReferenceType> externalReferences,
      ImmutableSet<MarkingDefinitionDm> objectMarkingRefs,
      ImmutableSet<GranularMarkingDm> granularMarkings,
      ImmutableMap<String, Object> customProperties) {
    this.definitionType = definitionType;
    this.definition = definition;
    this.hydrated = hydrated;
    this.type = type;
    this.id = id;
    this.createdByRef = createdByRef;
    this.created = created;
    this.lang = lang;
    this.externalReferences = externalReferences;
    this.objectMarkingRefs = objectMarkingRefs;
    this.granularMarkings = granularMarkings;
    this.customProperties = customProperties;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MarkingDefinitionDm", generator = "Immutables")
  private final class InitShim {
    private byte hydratedBuildStage = STAGE_UNINITIALIZED;
    private boolean hydrated;

    boolean getHydrated() {
      if (hydratedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hydratedBuildStage == STAGE_UNINITIALIZED) {
        hydratedBuildStage = STAGE_INITIALIZING;
        this.hydrated = getHydratedInitialize();
        hydratedBuildStage = STAGE_INITIALIZED;
      }
      return this.hydrated;
    }

    void hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      hydratedBuildStage = STAGE_INITIALIZED;
    }

    private byte createdBuildStage = STAGE_UNINITIALIZED;
    private StixInstant created;

    StixInstant getCreated() {
      if (createdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (createdBuildStage == STAGE_UNINITIALIZED) {
        createdBuildStage = STAGE_INITIALIZING;
        this.created = Objects.requireNonNull(getCreatedInitialize(), "created");
        createdBuildStage = STAGE_INITIALIZED;
      }
      return this.created;
    }

    void created(StixInstant created) {
      this.created = created;
      createdBuildStage = STAGE_INITIALIZED;
    }

    private byte externalReferencesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<ExternalReferenceType> externalReferences;

    ImmutableSet<ExternalReferenceType> getExternalReferences() {
      if (externalReferencesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (externalReferencesBuildStage == STAGE_UNINITIALIZED) {
        externalReferencesBuildStage = STAGE_INITIALIZING;
        this.externalReferences = ImmutableSet.copyOf(getExternalReferencesInitialize());
        externalReferencesBuildStage = STAGE_INITIALIZED;
      }
      return this.externalReferences;
    }

    void externalReferences(ImmutableSet<ExternalReferenceType> externalReferences) {
      this.externalReferences = externalReferences;
      externalReferencesBuildStage = STAGE_INITIALIZED;
    }

    private byte objectMarkingRefsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;

    ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
      if (objectMarkingRefsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectMarkingRefsBuildStage == STAGE_UNINITIALIZED) {
        objectMarkingRefsBuildStage = STAGE_INITIALIZING;
        this.objectMarkingRefs = ImmutableSet.copyOf(getObjectMarkingRefsInitialize());
        objectMarkingRefsBuildStage = STAGE_INITIALIZED;
      }
      return this.objectMarkingRefs;
    }

    void objectMarkingRefs(ImmutableSet<MarkingDefinitionDm> objectMarkingRefs) {
      this.objectMarkingRefs = objectMarkingRefs;
      objectMarkingRefsBuildStage = STAGE_INITIALIZED;
    }

    private byte granularMarkingsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<GranularMarkingDm> granularMarkings;

    ImmutableSet<GranularMarkingDm> getGranularMarkings() {
      if (granularMarkingsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (granularMarkingsBuildStage == STAGE_UNINITIALIZED) {
        granularMarkingsBuildStage = STAGE_INITIALIZING;
        this.granularMarkings = ImmutableSet.copyOf(getGranularMarkingsInitialize());
        granularMarkingsBuildStage = STAGE_INITIALIZED;
      }
      return this.granularMarkings;
    }

    void granularMarkings(ImmutableSet<GranularMarkingDm> granularMarkings) {
      this.granularMarkings = granularMarkings;
      granularMarkingsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (hydratedBuildStage == STAGE_INITIALIZING) attributes.add("hydrated");
      if (createdBuildStage == STAGE_INITIALIZING) attributes.add("created");
      if (externalReferencesBuildStage == STAGE_INITIALIZING) attributes.add("externalReferences");
      if (objectMarkingRefsBuildStage == STAGE_INITIALIZING) attributes.add("objectMarkingRefs");
      if (granularMarkingsBuildStage == STAGE_INITIALIZING) attributes.add("granularMarkings");
      return "Cannot build MarkingDefinition, attribute initializers form cycle " + attributes;
    }
  }

  private boolean getHydratedInitialize() {
    return MarkingDefinitionDm.super.getHydrated();
  }

  private StixInstant getCreatedInitialize() {
    return MarkingDefinitionDm.super.getCreated();
  }

  private Set<ExternalReferenceType> getExternalReferencesInitialize() {
    return MarkingDefinitionDm.super.getExternalReferences();
  }

  private Set<MarkingDefinitionDm> getObjectMarkingRefsInitialize() {
    return MarkingDefinitionDm.super.getObjectMarkingRefs();
  }

  private Set<GranularMarkingDm> getGranularMarkingsInitialize() {
    return MarkingDefinitionDm.super.getGranularMarkings();
  }

  /**
   * @return The value of the {@code definitionType} attribute
   */
  @JsonProperty("definition_type")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getDefinitionType() {
    return definitionType;
  }

  /**
   * @return The value of the {@code definition} attribute
   */
  @JsonProperty("definition")
  @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "definition_type", include = JsonTypeInfo.As.EXTERNAL_PROPERTY)
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixMarkingObject getDefinition() {
    return definition;
  }

  /**
   * Dictates if the object is hydrated.
   * Hydration is defined as if the Object has only a "ID" or has been properly
   * hydrated with the expected required fields
   * @return boolean
   */
  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public boolean getHydrated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHydrated()
        : this.hydrated;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @JsonPropertyDescription("The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code createdByRef} attribute
   */
  @JsonProperty("created_by_ref")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
  @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
  @JsonIdentityReference(alwaysAsId = true)
  @JsonDeserialize(converter = DomainObjectOptionalConverter.class)
  @Redactable(useMask = true, redactionMask = "identity--__REDACTED__")
  @Override
  public Optional<IdentitySdo> getCreatedByRef() {
    return Optional.ofNullable(createdByRef);
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @JsonPropertyDescription("The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
  @Redactable(useMask = true, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getCreated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCreated()
        : this.created;
  }

  /**
   * @return The value of the {@code lang} attribute
   */
  @JsonProperty("lang")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Identifies the language of the text content in this object using ISO 639-2 language codes.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getLang() {
    return Optional.ofNullable(lang);
  }

  /**
   * @return The value of the {@code externalReferences} attribute
   */
  @JsonProperty("external_references")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A list of external references which refers to non-STIX information.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<ExternalReferenceType> getExternalReferences() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExternalReferences()
        : this.externalReferences;
  }

  /**
   * @return The value of the {@code objectMarkingRefs} attribute
   */
  @JsonProperty("object_marking_refs")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
  @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
  @JsonIdentityReference(alwaysAsId = true)
  @JsonDeserialize(converter = MarkingDefinitionSetConverter.class)
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObjectMarkingRefs()
        : this.objectMarkingRefs;
  }

  /**
   * @return The value of the {@code granularMarkings} attribute
   */
  @JsonProperty("granular_markings")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The set of granular markings that apply to this object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getGranularMarkings()
        : this.granularMarkings;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MarkingDefinitionDm#getDefinitionType() definitionType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for definitionType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final MarkingDefinition withDefinitionType(String value) {
    if (Objects.equals(this.definitionType, value)) return this;
    return validate(new MarkingDefinition(
        value,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MarkingDefinitionDm#getDefinition() definition} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for definition (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final MarkingDefinition withDefinition(StixMarkingObject value) {
    if (this.definition == value) return this;
    return validate(new MarkingDefinition(
        this.definitionType,
        value,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MarkingDefinitionDm#getHydrated() hydrated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hydrated
   * @return A modified copy of the {@code this} object
   */
  public final MarkingDefinition withHydrated(boolean value) {
    if (this.hydrated == value) return this;
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        value,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MarkingDefinitionDm#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final MarkingDefinition withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        value,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MarkingDefinitionDm#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final MarkingDefinition withId(String value) {
    if (Objects.equals(this.id, value)) return this;
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        value,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MarkingDefinitionDm#getCreatedByRef() createdByRef} attribute.
   * @param value The value for createdByRef
   * @return A modified copy of {@code this} object
   */
  public final MarkingDefinition withCreatedByRef(IdentitySdo value) {
    @Nullable IdentitySdo newValue = Objects.requireNonNull(value, "createdByRef");
    if (this.createdByRef == newValue) return this;
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        newValue,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MarkingDefinitionDm#getCreatedByRef() createdByRef} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for createdByRef
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final MarkingDefinition withCreatedByRef(Optional<? extends IdentitySdo> optional) {
    @Nullable IdentitySdo value = optional.orElse(null);
    if (this.createdByRef == value) return this;
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        value,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MarkingDefinitionDm#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final MarkingDefinition withCreated(StixInstant value) {
    if (this.created == value) return this;
    StixInstant newValue = Objects.requireNonNull(value, "created");
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        newValue,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MarkingDefinitionDm#getLang() lang} attribute.
   * @param value The value for lang
   * @return A modified copy of {@code this} object
   */
  public final MarkingDefinition withLang(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "lang");
    if (Objects.equals(this.lang, newValue)) return this;
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        newValue,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MarkingDefinitionDm#getLang() lang} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for lang
   * @return A modified copy of {@code this} object
   */
  public final MarkingDefinition withLang(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.lang, value)) return this;
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        value,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkingDefinitionDm#getExternalReferences() externalReferences}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MarkingDefinition withExternalReferences(ExternalReferenceType... elements) {
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkingDefinitionDm#getExternalReferences() externalReferences}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of externalReferences elements to set
   * @return A modified copy of {@code this} object
   */
  public final MarkingDefinition withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
    if (this.externalReferences == elements) return this;
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkingDefinitionDm#getObjectMarkingRefs() objectMarkingRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MarkingDefinition withObjectMarkingRefs(MarkingDefinitionDm... elements) {
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkingDefinitionDm#getObjectMarkingRefs() objectMarkingRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectMarkingRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final MarkingDefinition withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
    if (this.objectMarkingRefs == elements) return this;
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.customProperties));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkingDefinitionDm#getGranularMarkings() granularMarkings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MarkingDefinition withGranularMarkings(GranularMarkingDm... elements) {
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.customProperties));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MarkingDefinitionDm#getGranularMarkings() granularMarkings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of granularMarkings elements to set
   * @return A modified copy of {@code this} object
   */
  public final MarkingDefinition withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
    if (this.granularMarkings == elements) return this;
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link MarkingDefinitionDm#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final MarkingDefinition withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new MarkingDefinition(
        this.definitionType,
        this.definition,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code MarkingDefinition} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof MarkingDefinition
        && equalTo((MarkingDefinition) another);
  }

  private boolean equalTo(MarkingDefinition another) {
    return Objects.equals(definitionType, another.definitionType)
        && Objects.equals(definition, another.definition)
        && hydrated == another.hydrated
        && Objects.equals(type, another.type)
        && Objects.equals(id, another.id)
        && Objects.equals(createdByRef, another.createdByRef)
        && created.equals(another.created)
        && Objects.equals(lang, another.lang)
        && externalReferences.equals(another.externalReferences)
        && objectMarkingRefs.equals(another.objectMarkingRefs)
        && granularMarkings.equals(another.granularMarkings)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code definitionType}, {@code definition}, {@code hydrated}, {@code type}, {@code id}, {@code createdByRef}, {@code created}, {@code lang}, {@code externalReferences}, {@code objectMarkingRefs}, {@code granularMarkings}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(definitionType);
    h += (h << 5) + Objects.hashCode(definition);
    h += (h << 5) + Booleans.hashCode(hydrated);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(createdByRef);
    h += (h << 5) + created.hashCode();
    h += (h << 5) + Objects.hashCode(lang);
    h += (h << 5) + externalReferences.hashCode();
    h += (h << 5) + objectMarkingRefs.hashCode();
    h += (h << 5) + granularMarkings.hashCode();
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MarkingDefinition} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MarkingDefinition")
        .omitNullValues()
        .add("definitionType", definitionType)
        .add("definition", definition)
        .add("hydrated", hydrated)
        .add("type", type)
        .add("id", id)
        .add("createdByRef", createdByRef)
        .add("created", created)
        .add("lang", lang)
        .add("externalReferences", externalReferences)
        .add("objectMarkingRefs", objectMarkingRefs)
        .add("granularMarkings", granularMarkings)
        .add("customProperties", customProperties)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long TO_JSON_STRING_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String toJsonString;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link MarkingDefinitionDm#toJsonString() toJsonString} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code toJsonString} attribute
   */
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String toJsonString() {
    if ((lazyInitBitmap & TO_JSON_STRING_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TO_JSON_STRING_LAZY_INIT_BIT) == 0) {
          this.toJsonString = Objects.requireNonNull(MarkingDefinitionDm.super.toJsonString(), "toJsonString");
          lazyInitBitmap |= TO_JSON_STRING_LAZY_INIT_BIT;
        }
      }
    }
    return toJsonString;
  }

  private static final long SPEC_VERSION_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient String specVersion;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link MarkingDefinitionDm#getSpecVersion() specVersion} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code specVersion} attribute
   */
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getSpecVersion() {
    if ((lazyInitBitmap & SPEC_VERSION_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SPEC_VERSION_LAZY_INIT_BIT) == 0) {
          this.specVersion = Objects.requireNonNull(MarkingDefinitionDm.super.getSpecVersion(), "specVersion");
          lazyInitBitmap |= SPEC_VERSION_LAZY_INIT_BIT;
        }
      }
    }
    return specVersion;
  }


  private static MarkingDefinition validate(MarkingDefinition instance) {
    instance.checkHydrationValidation();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link MarkingDefinitionDm} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MarkingDefinition instance
   */
  public static MarkingDefinition copyOf(MarkingDefinitionDm instance) {
    if (instance instanceof MarkingDefinition) {
      return (MarkingDefinition) instance;
    }
    return MarkingDefinition.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link MarkingDefinition MarkingDefinition}.
   * @return A new MarkingDefinition builder
   */
  public static MarkingDefinition.Builder builder() {
    return new MarkingDefinition.Builder();
  }

  /**
   * Builds instances of type {@link MarkingDefinition MarkingDefinition}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MarkingDefinitionDm", generator = "Immutables")
  @NotThreadSafe
  @JsonTypeName("marking-definition")
  @JsonPropertyOrder({"type", "id", "created_by_ref", "created", "external_references", "object_marking_refs", "granular_markings", "definition_type", "definition"})
  public static final class Builder {
    private static final long OPT_BIT_HYDRATED = 0x1L;
    private static final long OPT_BIT_EXTERNAL_REFERENCES = 0x2L;
    private static final long OPT_BIT_OBJECT_MARKING_REFS = 0x4L;
    private static final long OPT_BIT_GRANULAR_MARKINGS = 0x8L;
    private long optBits;

    private @Nullable String definitionType;
    private @Nullable StixMarkingObject definition;
    private boolean hydrated;
    private @Nullable String type;
    private @Nullable String id;
    private @Nullable IdentitySdo createdByRef;
    private @Nullable StixInstant created;
    private @Nullable String lang;
    private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
    private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
    private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.datamarkings.MarkingDefinitionDm} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MarkingDefinitionDm instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleableObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleableObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof MarkingDefinitionDm) {
        MarkingDefinitionDm instance = (MarkingDefinitionDm) object;
        String definitionTypeValue = instance.getDefinitionType();
        if (definitionTypeValue != null) {
          definitionType(definitionTypeValue);
        }
        StixMarkingObject definitionValue = instance.getDefinition();
        if (definitionValue != null) {
          definition(definitionValue);
        }
      }
      if (object instanceof BundleableObject) {
        BundleableObject instance = (BundleableObject) object;
        if ((bits & 0x4L) == 0) {
          String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x8L;
        }
        if ((bits & 0x1L) == 0) {
          hydrated(instance.getHydrated());
          bits |= 0x1L;
        }
        if ((bits & 0x10L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x2L;
        }
      }
      if (object instanceof StixCommonProperties) {
        StixCommonProperties instance = (StixCommonProperties) object;
        addAllExternalReferences(instance.getExternalReferences());
        if ((bits & 0x1L) == 0) {
          hydrated(instance.getHydrated());
          bits |= 0x1L;
        }
        created(instance.getCreated());
        if ((bits & 0x2L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x2L;
        }
        Optional<IdentitySdo> createdByRefOptional = instance.getCreatedByRef();
        if (createdByRefOptional.isPresent()) {
          createdByRef(createdByRefOptional);
        }
        if ((bits & 0x4L) == 0) {
          String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x10L;
        }
        Optional<String> langOptional = instance.getLang();
        if (langOptional.isPresent()) {
          lang(langOptional);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
    }

    /**
     * Initializes the value for the {@link MarkingDefinitionDm#getDefinitionType() definitionType} attribute.
     * @param definitionType The value for definitionType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("definition_type")
    public final Builder definitionType(String definitionType) {
      this.definitionType = definitionType;
      return this;
    }

    /**
     * Initializes the value for the {@link MarkingDefinitionDm#getDefinition() definition} attribute.
     * @param definition The value for definition (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("definition")
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "definition_type", include = JsonTypeInfo.As.EXTERNAL_PROPERTY)
    public final Builder definition(StixMarkingObject definition) {
      this.definition = definition;
      return this;
    }

    /**
     * Initializes the value for the {@link MarkingDefinitionDm#getHydrated() hydrated} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MarkingDefinitionDm#getHydrated() hydrated}.</em>
     * @param hydrated The value for hydrated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    public final Builder hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      optBits |= OPT_BIT_HYDRATED;
      return this;
    }

    /**
     * Initializes the value for the {@link MarkingDefinitionDm#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    @JsonPropertyDescription("The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link MarkingDefinitionDm#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    public final Builder id(String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the optional value {@link MarkingDefinitionDm#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder createdByRef(IdentitySdo createdByRef) {
      this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
      return this;
    }

    /**
     * Initializes the optional value {@link MarkingDefinitionDm#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created_by_ref")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
    @JsonIdentityReference(alwaysAsId = true)
    @JsonDeserialize(converter = DomainObjectOptionalConverter.class)
    public final Builder createdByRef(Optional<? extends IdentitySdo> createdByRef) {
      this.createdByRef = createdByRef.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MarkingDefinitionDm#getCreated() created} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MarkingDefinitionDm#getCreated() created}.</em>
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    @JsonPropertyDescription("The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
    public final Builder created(StixInstant created) {
      this.created = Objects.requireNonNull(created, "created");
      return this;
    }

    /**
     * Initializes the optional value {@link MarkingDefinitionDm#getLang() lang} to lang.
     * @param lang The value for lang
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder lang(String lang) {
      this.lang = Objects.requireNonNull(lang, "lang");
      return this;
    }

    /**
     * Initializes the optional value {@link MarkingDefinitionDm#getLang() lang} to lang.
     * @param lang The value for lang
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lang")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Identifies the language of the text content in this object using ISO 639-2 language codes.")
    public final Builder lang(Optional<String> lang) {
      this.lang = lang.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link MarkingDefinitionDm#getExternalReferences() externalReferences} set.
     * @param element A externalReferences element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
      this.externalReferences.add(element);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }

    /**
     * Adds elements to {@link MarkingDefinitionDm#getExternalReferences() externalReferences} set.
     * @param elements An array of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReferences(ExternalReferenceType... elements) {
      this.externalReferences.add(elements);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MarkingDefinitionDm#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("external_references")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A list of external references which refers to non-STIX information.")
    public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences = ImmutableSet.builder();
      return addAllExternalReferences(elements);
    }

    /**
     * Adds elements to {@link MarkingDefinitionDm#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences.addAll(elements);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }

    /**
     * Adds one element to {@link MarkingDefinitionDm#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param element A objectMarkingRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
      this.objectMarkingRefs.add(element);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }

    /**
     * Adds elements to {@link MarkingDefinitionDm#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An array of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRefs(MarkingDefinitionDm... elements) {
      this.objectMarkingRefs.add(elements);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MarkingDefinitionDm#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("object_marking_refs")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
    @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
    @JsonIdentityReference(alwaysAsId = true)
    @JsonDeserialize(converter = MarkingDefinitionSetConverter.class)
    public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs = ImmutableSet.builder();
      return addAllObjectMarkingRefs(elements);
    }

    /**
     * Adds elements to {@link MarkingDefinitionDm#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs.addAll(elements);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }

    /**
     * Adds one element to {@link MarkingDefinitionDm#getGranularMarkings() granularMarkings} set.
     * @param element A granularMarkings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
      this.granularMarkings.add(element);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }

    /**
     * Adds elements to {@link MarkingDefinitionDm#getGranularMarkings() granularMarkings} set.
     * @param elements An array of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarkings(GranularMarkingDm... elements) {
      this.granularMarkings.add(elements);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MarkingDefinitionDm#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("granular_markings")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The set of granular markings that apply to this object.")
    public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings = ImmutableSet.builder();
      return addAllGranularMarkings(elements);
    }

    /**
     * Adds elements to {@link MarkingDefinitionDm#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings.addAll(elements);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }

    /**
     * Put one entry to the {@link MarkingDefinitionDm#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link MarkingDefinitionDm#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MarkingDefinitionDm#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MarkingDefinitionDm#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link MarkingDefinition MarkingDefinition}.
     * @return An immutable instance of MarkingDefinition
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public MarkingDefinition build() {
      return MarkingDefinition.validate(new MarkingDefinition(this));
    }

    private boolean hydratedIsSet() {
      return (optBits & OPT_BIT_HYDRATED) != 0;
    }

    private boolean externalReferencesIsSet() {
      return (optBits & OPT_BIT_EXTERNAL_REFERENCES) != 0;
    }

    private boolean objectMarkingRefsIsSet() {
      return (optBits & OPT_BIT_OBJECT_MARKING_REFS) != 0;
    }

    private boolean granularMarkingsIsSet() {
      return (optBits & OPT_BIT_GRANULAR_MARKINGS) != 0;
    }
  }
}
