package security.whisper.javastix.datamarkings.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.redaction.Redactable;

/**
 * Immutable implementation of {@link StatementMarkingObject}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Statement.builder()}.
 */
@Generated(from = "StatementMarkingObject", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("statement")
@Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
public final class Statement implements StatementMarkingObject {
  private final String statement;
  private final ImmutableMap<String, Object> customProperties;

  private Statement(
      String statement,
      ImmutableMap<String, Object> customProperties) {
    this.statement = statement;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code statement} attribute
   */
  @JsonProperty("statement")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getStatement() {
    return statement;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StatementMarkingObject#getStatement() statement} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for statement (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Statement withStatement(String value) {
    if (Objects.equals(this.statement, value)) return this;
    return validate(new Statement(value, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link StatementMarkingObject#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final Statement withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new Statement(this.statement, newValue));
  }

  /**
   * This instance is equal to all instances of {@code Statement} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Statement
        && equalTo((Statement) another);
  }

  private boolean equalTo(Statement another) {
    return Objects.equals(statement, another.statement)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code statement}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(statement);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StatementMarkingObject} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StatementMarkingObject")
        .omitNullValues()
        .add("statement", statement)
        .add("customProperties", customProperties)
        .toString();
  }


  private static Statement validate(Statement instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link StatementMarkingObject} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StatementMarkingObject instance
   */
  public static Statement copyOf(StatementMarkingObject instance) {
    if (instance instanceof Statement) {
      return (Statement) instance;
    }
    return Statement.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link Statement Statement}.
   * @return A new Statement builder
   */
  public static Statement.Builder builder() {
    return new Statement.Builder();
  }

  /**
   * Builds instances of type {@link Statement Statement}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StatementMarkingObject", generator = "Immutables")
  @NotThreadSafe
  @JsonTypeName("statement")
  public static final class Builder {
    private @Nullable String statement;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.datamarkings.objects.StatementMarkingObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StatementMarkingObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof StatementMarkingObject) {
        StatementMarkingObject instance = (StatementMarkingObject) object;
        String statementValue = instance.getStatement();
        if (statementValue != null) {
          statement(statementValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link StatementMarkingObject#getStatement() statement} attribute.
     * @param statement The value for statement (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("statement")
    public final Builder statement(String statement) {
      this.statement = statement;
      return this;
    }

    /**
     * Put one entry to the {@link StatementMarkingObject#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link StatementMarkingObject#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link StatementMarkingObject#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link StatementMarkingObject#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link Statement Statement}.
     * @return An immutable instance of StatementMarkingObject
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Statement build() {
      return Statement.validate(new Statement(statement, customProperties.build()));
    }
  }
}
