package security.whisper.javastix.datamarkings.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.redaction.Redactable;

/**
 * Immutable implementation of {@link TlpMarkingObject}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Tlp.builder()}.
 */
@Generated(from = "TlpMarkingObject", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("tlp")
@Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
public final class Tlp implements TlpMarkingObject {
  private final String tlp;
  private final ImmutableMap<String, Object> customProperties;

  private Tlp(
      String tlp,
      ImmutableMap<String, Object> customProperties) {
    this.tlp = tlp;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code tlp} attribute
   */
  @JsonProperty("tlp")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getTlp() {
    return tlp;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TlpMarkingObject#getTlp() tlp} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tlp (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Tlp withTlp(String value) {
    if (Objects.equals(this.tlp, value)) return this;
    return validate(new Tlp(value, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link TlpMarkingObject#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final Tlp withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new Tlp(this.tlp, newValue));
  }

  /**
   * This instance is equal to all instances of {@code Tlp} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Tlp
        && equalTo((Tlp) another);
  }

  private boolean equalTo(Tlp another) {
    return Objects.equals(tlp, another.tlp)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code tlp}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(tlp);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TlpMarkingObject} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TlpMarkingObject")
        .omitNullValues()
        .add("tlp", tlp)
        .add("customProperties", customProperties)
        .toString();
  }


  private static Tlp validate(Tlp instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link TlpMarkingObject} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TlpMarkingObject instance
   */
  public static Tlp copyOf(TlpMarkingObject instance) {
    if (instance instanceof Tlp) {
      return (Tlp) instance;
    }
    return Tlp.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link Tlp Tlp}.
   * @return A new Tlp builder
   */
  public static Tlp.Builder builder() {
    return new Tlp.Builder();
  }

  /**
   * Builds instances of type {@link Tlp Tlp}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TlpMarkingObject", generator = "Immutables")
  @NotThreadSafe
  @JsonTypeName("tlp")
  public static final class Builder {
    private @Nullable String tlp;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.datamarkings.objects.TlpMarkingObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TlpMarkingObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof TlpMarkingObject) {
        TlpMarkingObject instance = (TlpMarkingObject) object;
        String tlpValue = instance.getTlp();
        if (tlpValue != null) {
          tlp(tlpValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link TlpMarkingObject#getTlp() tlp} attribute.
     * @param tlp The value for tlp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("tlp")
    public final Builder tlp(String tlp) {
      this.tlp = tlp;
      return this;
    }

    /**
     * Put one entry to the {@link TlpMarkingObject#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link TlpMarkingObject#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link TlpMarkingObject#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link TlpMarkingObject#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link Tlp Tlp}.
     * @return An immutable instance of TlpMarkingObject
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Tlp build() {
      return Tlp.validate(new Tlp(tlp, customProperties.build()));
    }
  }
}
