package security.whisper.javastix.meta;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.types.ExternalReferenceType;

/**
 * Immutable implementation of {@link ExtensionDefinition}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ExtensionDefinitionObject.builder()}.
 */
@Generated(from = "ExtensionDefinition", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("extension-definition")
@Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
public final class ExtensionDefinitionObject implements ExtensionDefinition {
  private final String id;
  private final String specVersion;
  private final @Nullable String createdByRef;
  private final StixInstant created;
  private final StixInstant modified;
  private final @Nullable Boolean revoked;
  private final ImmutableSet<String> labels;
  private final @Nullable Integer confidence;
  private final ImmutableSet<ExternalReferenceType> externalReferences;
  private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
  private final ImmutableSet<GranularMarkingDm> granularMarkings;
  private final String name;
  private final @Nullable String description;
  private final ImmutableMap<String, Object> schema;
  private final String version;
  private final ImmutableSet<String> extensionTypes;
  private final ImmutableSet<String> extensionProperties;
  private final boolean hydrated;
  private final String toJsonString;
  private final ImmutableMap<String, Object> customProperties;

  private ExtensionDefinitionObject(ExtensionDefinitionObject.Builder builder) {
    this.id = builder.id;
    this.createdByRef = builder.createdByRef;
    this.created = builder.created;
    this.modified = builder.modified;
    this.revoked = builder.revoked;
    this.labels = builder.labels.build();
    this.confidence = builder.confidence;
    this.externalReferences = builder.externalReferences.build();
    this.objectMarkingRefs = builder.objectMarkingRefs.build();
    this.granularMarkings = builder.granularMarkings.build();
    this.name = builder.name;
    this.description = builder.description;
    this.schema = builder.schema.build();
    this.version = builder.version;
    this.extensionTypes = builder.extensionTypes.build();
    this.extensionProperties = builder.extensionProperties.build();
    this.hydrated = builder.hydrated;
    this.toJsonString = builder.toJsonString;
    this.customProperties = builder.customProperties.build();
    this.specVersion = builder.specVersion != null
        ? builder.specVersion
        : Objects.requireNonNull(ExtensionDefinition.super.getSpecVersion(), "specVersion");
  }

  private ExtensionDefinitionObject(
      String id,
      String specVersion,
      @Nullable String createdByRef,
      StixInstant created,
      StixInstant modified,
      @Nullable Boolean revoked,
      ImmutableSet<String> labels,
      @Nullable Integer confidence,
      ImmutableSet<ExternalReferenceType> externalReferences,
      ImmutableSet<MarkingDefinitionDm> objectMarkingRefs,
      ImmutableSet<GranularMarkingDm> granularMarkings,
      String name,
      @Nullable String description,
      ImmutableMap<String, Object> schema,
      String version,
      ImmutableSet<String> extensionTypes,
      ImmutableSet<String> extensionProperties,
      boolean hydrated,
      String toJsonString,
      ImmutableMap<String, Object> customProperties) {
    this.id = id;
    this.specVersion = specVersion;
    this.createdByRef = createdByRef;
    this.created = created;
    this.modified = modified;
    this.revoked = revoked;
    this.labels = labels;
    this.confidence = confidence;
    this.externalReferences = externalReferences;
    this.objectMarkingRefs = objectMarkingRefs;
    this.granularMarkings = granularMarkings;
    this.name = name;
    this.description = description;
    this.schema = schema;
    this.version = version;
    this.extensionTypes = extensionTypes;
    this.extensionProperties = extensionProperties;
    this.hydrated = hydrated;
    this.toJsonString = toJsonString;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JsonPropertyDescription("Specifies the identifier for this Extension Definition object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code specVersion} attribute
   */
  @JsonProperty("spec_version")
  @JsonPropertyDescription("The version of the STIX specification used to represent this object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getSpecVersion() {
    return specVersion;
  }

  /**
   * @return The value of the {@code createdByRef} attribute
   */
  @JsonProperty("created_by_ref")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The ID of the identity that created this extension definition.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getCreatedByRef() {
    return Optional.ofNullable(createdByRef);
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @JsonPropertyDescription("The created property represents the time at which this object was originally created.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code modified} attribute
   */
  @JsonProperty("modified")
  @JsonPropertyDescription("The modified property represents the time at which this object was last modified.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getModified() {
    return modified;
  }

  /**
   * @return The value of the {@code revoked} attribute
   */
  @JsonProperty("revoked")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The revoked property is a boolean that indicates whether the object has been revoked.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<Boolean> getRevoked() {
    return Optional.ofNullable(revoked);
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The labels property specifies a set of categorization labels.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<String> getLabels() {
    return labels;
  }

  /**
   * @return The value of the {@code confidence} attribute
   */
  @JsonProperty("confidence")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The confidence property identifies the confidence that the creator has in the correctness of their data.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<Integer> getConfidence() {
    return Optional.ofNullable(confidence);
  }

  /**
   * @return The value of the {@code externalReferences} attribute
   */
  @JsonProperty("external_references")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A list of external references which refer to non-STIX information.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<ExternalReferenceType> getExternalReferences() {
    return externalReferences;
  }

  /**
   * @return The value of the {@code objectMarkingRefs} attribute
   */
  @JsonProperty("object_marking_refs")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
    return objectMarkingRefs;
  }

  /**
   * @return The value of the {@code granularMarkings} attribute
   */
  @JsonProperty("granular_markings")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The set of granular markings that apply to this object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
    return granularMarkings;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JsonPropertyDescription("The name of this extension.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A detailed description of this extension.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getDescription() {
    return Optional.ofNullable(description);
  }

  /**
   * @return The value of the {@code schema} attribute
   */
  @JsonProperty("schema")
  @JsonPropertyDescription("The JSON schema for this extension.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableMap<String, Object> getSchema() {
    return schema;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @JsonPropertyDescription("The version of this extension.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code extensionTypes} attribute
   */
  @JsonProperty("extension_types")
  @JsonPropertyDescription("A list of the types of STIX Objects that this extension can be applied to.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<String> getExtensionTypes() {
    return extensionTypes;
  }

  /**
   * @return The value of the {@code extensionProperties} attribute
   */
  @JsonProperty("extension_properties")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The list of properties that this extension adds to the objects it extends.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<String> getExtensionProperties() {
    return extensionProperties;
  }

  /**
   * @return The value of the {@code hydrated} attribute
   */
  @JsonProperty("hydrated")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public boolean getHydrated() {
    return hydrated;
  }

  /**
   * @return The value of the {@code toJsonString} attribute
   */
  @JsonProperty("toJsonString")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String toJsonString() {
    return toJsonString;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtensionDefinition#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ExtensionDefinitionObject withId(String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ExtensionDefinitionObject(
        value,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtensionDefinition#getSpecVersion() specVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for specVersion
   * @return A modified copy of the {@code this} object
   */
  public final ExtensionDefinitionObject withSpecVersion(String value) {
    String newValue = Objects.requireNonNull(value, "specVersion");
    if (this.specVersion.equals(newValue)) return this;
    return new ExtensionDefinitionObject(
        this.id,
        newValue,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExtensionDefinition#getCreatedByRef() createdByRef} attribute.
   * @param value The value for createdByRef
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withCreatedByRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "createdByRef");
    if (Objects.equals(this.createdByRef, newValue)) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        newValue,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExtensionDefinition#getCreatedByRef() createdByRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for createdByRef
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withCreatedByRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.createdByRef, value)) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        value,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtensionDefinition#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ExtensionDefinitionObject withCreated(StixInstant value) {
    if (this.created == value) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        value,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtensionDefinition#getModified() modified} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modified (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ExtensionDefinitionObject withModified(StixInstant value) {
    if (this.modified == value) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        value,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExtensionDefinition#getRevoked() revoked} attribute.
   * @param value The value for revoked
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withRevoked(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.revoked, newValue)) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        newValue,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExtensionDefinition#getRevoked() revoked} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for revoked
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withRevoked(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.revoked, value)) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        value,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtensionDefinition#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withLabels(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        newValue,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtensionDefinition#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withLabels(Iterable<String> elements) {
    if (this.labels == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        newValue,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExtensionDefinition#getConfidence() confidence} attribute.
   * @param value The value for confidence
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withConfidence(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.confidence, newValue)) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        newValue,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExtensionDefinition#getConfidence() confidence} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for confidence
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withConfidence(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.confidence, value)) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        value,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtensionDefinition#getExternalReferences() externalReferences}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withExternalReferences(ExternalReferenceType... elements) {
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtensionDefinition#getExternalReferences() externalReferences}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of externalReferences elements to set
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
    if (this.externalReferences == elements) return this;
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtensionDefinition#getObjectMarkingRefs() objectMarkingRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withObjectMarkingRefs(MarkingDefinitionDm... elements) {
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtensionDefinition#getObjectMarkingRefs() objectMarkingRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectMarkingRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
    if (this.objectMarkingRefs == elements) return this;
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtensionDefinition#getGranularMarkings() granularMarkings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withGranularMarkings(GranularMarkingDm... elements) {
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtensionDefinition#getGranularMarkings() granularMarkings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of granularMarkings elements to set
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
    if (this.granularMarkings == elements) return this;
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtensionDefinition#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ExtensionDefinitionObject withName(String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        value,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExtensionDefinition#getDescription() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withDescription(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        newValue,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExtensionDefinition#getDescription() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        value,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link ExtensionDefinition#getSchema() schema} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the schema map
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withSchema(Map<String, ? extends Object> entries) {
    if (this.schema == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        newValue,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtensionDefinition#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ExtensionDefinitionObject withVersion(String value) {
    if (Objects.equals(this.version, value)) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        value,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtensionDefinition#getExtensionTypes() extensionTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withExtensionTypes(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        newValue,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtensionDefinition#getExtensionTypes() extensionTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of extensionTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withExtensionTypes(Iterable<String> elements) {
    if (this.extensionTypes == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        newValue,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtensionDefinition#getExtensionProperties() extensionProperties}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withExtensionProperties(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        newValue,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExtensionDefinition#getExtensionProperties() extensionProperties}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of extensionProperties elements to set
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withExtensionProperties(Iterable<String> elements) {
    if (this.extensionProperties == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        newValue,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtensionDefinition#getHydrated() hydrated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hydrated
   * @return A modified copy of the {@code this} object
   */
  public final ExtensionDefinitionObject withHydrated(boolean value) {
    if (this.hydrated == value) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        value,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtensionDefinition#toJsonString() toJsonString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toJsonString (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ExtensionDefinitionObject withToJsonString(String value) {
    if (Objects.equals(this.toJsonString, value)) return this;
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        value,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link ExtensionDefinition#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final ExtensionDefinitionObject withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return new ExtensionDefinitionObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.name,
        this.description,
        this.schema,
        this.version,
        this.extensionTypes,
        this.extensionProperties,
        this.hydrated,
        this.toJsonString,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ExtensionDefinitionObject} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ExtensionDefinitionObject
        && equalTo((ExtensionDefinitionObject) another);
  }

  private boolean equalTo(ExtensionDefinitionObject another) {
    return Objects.equals(id, another.id)
        && specVersion.equals(another.specVersion)
        && Objects.equals(createdByRef, another.createdByRef)
        && Objects.equals(created, another.created)
        && Objects.equals(modified, another.modified)
        && Objects.equals(revoked, another.revoked)
        && labels.equals(another.labels)
        && Objects.equals(confidence, another.confidence)
        && externalReferences.equals(another.externalReferences)
        && objectMarkingRefs.equals(another.objectMarkingRefs)
        && granularMarkings.equals(another.granularMarkings)
        && Objects.equals(name, another.name)
        && Objects.equals(description, another.description)
        && schema.equals(another.schema)
        && Objects.equals(version, another.version)
        && extensionTypes.equals(another.extensionTypes)
        && extensionProperties.equals(another.extensionProperties)
        && hydrated == another.hydrated
        && Objects.equals(toJsonString, another.toJsonString)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code specVersion}, {@code createdByRef}, {@code created}, {@code modified}, {@code revoked}, {@code labels}, {@code confidence}, {@code externalReferences}, {@code objectMarkingRefs}, {@code granularMarkings}, {@code name}, {@code description}, {@code schema}, {@code version}, {@code extensionTypes}, {@code extensionProperties}, {@code hydrated}, {@code toJsonString}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + specVersion.hashCode();
    h += (h << 5) + Objects.hashCode(createdByRef);
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(modified);
    h += (h << 5) + Objects.hashCode(revoked);
    h += (h << 5) + labels.hashCode();
    h += (h << 5) + Objects.hashCode(confidence);
    h += (h << 5) + externalReferences.hashCode();
    h += (h << 5) + objectMarkingRefs.hashCode();
    h += (h << 5) + granularMarkings.hashCode();
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + schema.hashCode();
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + extensionTypes.hashCode();
    h += (h << 5) + extensionProperties.hashCode();
    h += (h << 5) + Booleans.hashCode(hydrated);
    h += (h << 5) + Objects.hashCode(toJsonString);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExtensionDefinition} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExtensionDefinition")
        .omitNullValues()
        .add("id", id)
        .add("specVersion", specVersion)
        .add("createdByRef", createdByRef)
        .add("created", created)
        .add("modified", modified)
        .add("revoked", revoked)
        .add("labels", labels)
        .add("confidence", confidence)
        .add("externalReferences", externalReferences)
        .add("objectMarkingRefs", objectMarkingRefs)
        .add("granularMarkings", granularMarkings)
        .add("name", name)
        .add("description", description)
        .add("schema", schema)
        .add("version", version)
        .add("extensionTypes", extensionTypes)
        .add("extensionProperties", extensionProperties)
        .add("hydrated", hydrated)
        .add("toJsonString", toJsonString)
        .add("customProperties", customProperties)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ExtensionDefinition} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExtensionDefinition instance
   */
  public static ExtensionDefinitionObject copyOf(ExtensionDefinition instance) {
    if (instance instanceof ExtensionDefinitionObject) {
      return (ExtensionDefinitionObject) instance;
    }
    return ExtensionDefinitionObject.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  /**
   * Creates a builder for {@link ExtensionDefinitionObject ExtensionDefinitionObject}.
   * @return A new ExtensionDefinitionObject builder
   */
  public static ExtensionDefinitionObject.Builder builder() {
    return new ExtensionDefinitionObject.Builder();
  }

  /**
   * Builds instances of type {@link ExtensionDefinitionObject ExtensionDefinitionObject}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExtensionDefinition", generator = "Immutables")
  @NotThreadSafe
  @JsonTypeName("extension-definition")
  @JsonPropertyOrder({"type", "spec_version", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "name", "description", "schema", "version", "extension_types", "extension_properties"})
  public static final class Builder {
    private @Nullable String id;
    private @Nullable String specVersion;
    private @Nullable String createdByRef;
    private @Nullable StixInstant created;
    private @Nullable StixInstant modified;
    private @Nullable Boolean revoked;
    private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
    private @Nullable Integer confidence;
    private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
    private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
    private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
    private @Nullable String name;
    private @Nullable String description;
    private ImmutableMap.Builder<String, Object> schema = ImmutableMap.builder();
    private @Nullable String version;
    private ImmutableSet.Builder<String> extensionTypes = ImmutableSet.builder();
    private ImmutableSet.Builder<String> extensionProperties = ImmutableSet.builder();
    private boolean hydrated;
    private @Nullable String toJsonString;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleableObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleableObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.meta.ExtensionDefinition} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ExtensionDefinition instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BundleableObject) {
        BundleableObject instance = (BundleableObject) object;
        if ((bits & 0x2L) == 0) {
          String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x4L;
        }
        hydrated(instance.getHydrated());
        if ((bits & 0x1L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x1L;
        }
        String toJsonStringValue = instance.toJsonString();
        if (toJsonStringValue != null) {
          toJsonString(toJsonStringValue);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof ExtensionDefinition) {
        ExtensionDefinition instance = (ExtensionDefinition) object;
        putAllSchema(instance.getSchema());
        specVersion(instance.getSpecVersion());
        addAllExternalReferences(instance.getExternalReferences());
        addAllExtensionProperties(instance.getExtensionProperties());
        StixInstant createdValue = instance.getCreated();
        if (createdValue != null) {
          created(createdValue);
        }
        Optional<Integer> confidenceOptional = instance.getConfidence();
        if (confidenceOptional.isPresent()) {
          confidence(confidenceOptional);
        }
        Optional<String> descriptionOptional = instance.getDescription();
        if (descriptionOptional.isPresent()) {
          description(descriptionOptional);
        }
        Optional<Boolean> revokedOptional = instance.getRevoked();
        if (revokedOptional.isPresent()) {
          revoked(revokedOptional);
        }
        String versionValue = instance.getVersion();
        if (versionValue != null) {
          version(versionValue);
        }
        addAllLabels(instance.getLabels());
        addAllExtensionTypes(instance.getExtensionTypes());
        if ((bits & 0x1L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x1L;
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        StixInstant modifiedValue = instance.getModified();
        if (modifiedValue != null) {
          modified(modifiedValue);
        }
        Optional<String> createdByRefOptional = instance.getCreatedByRef();
        if (createdByRefOptional.isPresent()) {
          createdByRef(createdByRefOptional);
        }
        if ((bits & 0x2L) == 0) {
          String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ExtensionDefinition#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    @JsonPropertyDescription("Specifies the identifier for this Extension Definition object.")
    public final Builder id(String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link ExtensionDefinition#getSpecVersion() specVersion} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ExtensionDefinition#getSpecVersion() specVersion}.</em>
     * @param specVersion The value for specVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("spec_version")
    @JsonPropertyDescription("The version of the STIX specification used to represent this object.")
    public final Builder specVersion(String specVersion) {
      this.specVersion = Objects.requireNonNull(specVersion, "specVersion");
      return this;
    }

    /**
     * Initializes the optional value {@link ExtensionDefinition#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder createdByRef(String createdByRef) {
      this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
      return this;
    }

    /**
     * Initializes the optional value {@link ExtensionDefinition#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created_by_ref")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The ID of the identity that created this extension definition.")
    public final Builder createdByRef(Optional<String> createdByRef) {
      this.createdByRef = createdByRef.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ExtensionDefinition#getCreated() created} attribute.
     * @param created The value for created (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    @JsonPropertyDescription("The created property represents the time at which this object was originally created.")
    public final Builder created(StixInstant created) {
      this.created = created;
      return this;
    }

    /**
     * Initializes the value for the {@link ExtensionDefinition#getModified() modified} attribute.
     * @param modified The value for modified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("modified")
    @JsonPropertyDescription("The modified property represents the time at which this object was last modified.")
    public final Builder modified(StixInstant modified) {
      this.modified = modified;
      return this;
    }

    /**
     * Initializes the optional value {@link ExtensionDefinition#getRevoked() revoked} to revoked.
     * @param revoked The value for revoked
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder revoked(boolean revoked) {
      this.revoked = revoked;
      return this;
    }

    /**
     * Initializes the optional value {@link ExtensionDefinition#getRevoked() revoked} to revoked.
     * @param revoked The value for revoked
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("revoked")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The revoked property is a boolean that indicates whether the object has been revoked.")
    public final Builder revoked(Optional<Boolean> revoked) {
      this.revoked = revoked.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ExtensionDefinition#getLabels() labels} set.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabel(@Nullable String element) {
      this.labels.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ExtensionDefinition#getLabels() labels} set.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(String... elements) {
      this.labels.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ExtensionDefinition#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labels")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The labels property specifies a set of categorization labels.")
    public final Builder labels(Iterable<String> elements) {
      this.labels = ImmutableSet.builder();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link ExtensionDefinition#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<String> elements) {
      this.labels.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link ExtensionDefinition#getConfidence() confidence} to confidence.
     * @param confidence The value for confidence
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder confidence(int confidence) {
      this.confidence = confidence;
      return this;
    }

    /**
     * Initializes the optional value {@link ExtensionDefinition#getConfidence() confidence} to confidence.
     * @param confidence The value for confidence
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("confidence")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The confidence property identifies the confidence that the creator has in the correctness of their data.")
    public final Builder confidence(Optional<Integer> confidence) {
      this.confidence = confidence.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ExtensionDefinition#getExternalReferences() externalReferences} set.
     * @param element A externalReferences element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
      this.externalReferences.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ExtensionDefinition#getExternalReferences() externalReferences} set.
     * @param elements An array of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReferences(ExternalReferenceType... elements) {
      this.externalReferences.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ExtensionDefinition#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("external_references")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A list of external references which refer to non-STIX information.")
    public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences = ImmutableSet.builder();
      return addAllExternalReferences(elements);
    }

    /**
     * Adds elements to {@link ExtensionDefinition#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link ExtensionDefinition#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param element A objectMarkingRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
      this.objectMarkingRefs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ExtensionDefinition#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An array of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRefs(MarkingDefinitionDm... elements) {
      this.objectMarkingRefs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ExtensionDefinition#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("object_marking_refs")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
    public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs = ImmutableSet.builder();
      return addAllObjectMarkingRefs(elements);
    }

    /**
     * Adds elements to {@link ExtensionDefinition#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link ExtensionDefinition#getGranularMarkings() granularMarkings} set.
     * @param element A granularMarkings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
      this.granularMarkings.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ExtensionDefinition#getGranularMarkings() granularMarkings} set.
     * @param elements An array of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarkings(GranularMarkingDm... elements) {
      this.granularMarkings.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ExtensionDefinition#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("granular_markings")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The set of granular markings that apply to this object.")
    public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings = ImmutableSet.builder();
      return addAllGranularMarkings(elements);
    }

    /**
     * Adds elements to {@link ExtensionDefinition#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link ExtensionDefinition#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    @JsonPropertyDescription("The name of this extension.")
    public final Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the optional value {@link ExtensionDefinition#getDescription() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link ExtensionDefinition#getDescription() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A detailed description of this extension.")
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link ExtensionDefinition#getSchema() schema} map.
     * @param key The key in the schema map
     * @param value The associated value in the schema map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putSchema(String key, Object value) {
      this.schema.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ExtensionDefinition#getSchema() schema} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putSchema(Map.Entry<String, ? extends Object> entry) {
      this.schema.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ExtensionDefinition#getSchema() schema} map. Nulls are not permitted
     * @param entries The entries that will be added to the schema map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("schema")
    @JsonPropertyDescription("The JSON schema for this extension.")
    public final Builder schema(Map<String, ? extends Object> entries) {
      this.schema = ImmutableMap.builder();
      return putAllSchema(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ExtensionDefinition#getSchema() schema} map. Nulls are not permitted
     * @param entries The entries that will be added to the schema map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllSchema(Map<String, ? extends Object> entries) {
      this.schema.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link ExtensionDefinition#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    @JsonPropertyDescription("The version of this extension.")
    public final Builder version(String version) {
      this.version = version;
      return this;
    }

    /**
     * Adds one element to {@link ExtensionDefinition#getExtensionTypes() extensionTypes} set.
     * @param element A extensionTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtensionType(@Nullable String element) {
      this.extensionTypes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ExtensionDefinition#getExtensionTypes() extensionTypes} set.
     * @param elements An array of extensionTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtensionTypes(String... elements) {
      this.extensionTypes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ExtensionDefinition#getExtensionTypes() extensionTypes} set.
     * @param elements An iterable of extensionTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("extension_types")
    @JsonPropertyDescription("A list of the types of STIX Objects that this extension can be applied to.")
    public final Builder extensionTypes(Iterable<String> elements) {
      this.extensionTypes = ImmutableSet.builder();
      return addAllExtensionTypes(elements);
    }

    /**
     * Adds elements to {@link ExtensionDefinition#getExtensionTypes() extensionTypes} set.
     * @param elements An iterable of extensionTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExtensionTypes(Iterable<String> elements) {
      this.extensionTypes.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link ExtensionDefinition#getExtensionProperties() extensionProperties} set.
     * @param element A extensionProperties element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtensionProperty(@Nullable String element) {
      this.extensionProperties.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ExtensionDefinition#getExtensionProperties() extensionProperties} set.
     * @param elements An array of extensionProperties elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtensionProperties(String... elements) {
      this.extensionProperties.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ExtensionDefinition#getExtensionProperties() extensionProperties} set.
     * @param elements An iterable of extensionProperties elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("extension_properties")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The list of properties that this extension adds to the objects it extends.")
    public final Builder extensionProperties(Iterable<String> elements) {
      this.extensionProperties = ImmutableSet.builder();
      return addAllExtensionProperties(elements);
    }

    /**
     * Adds elements to {@link ExtensionDefinition#getExtensionProperties() extensionProperties} set.
     * @param elements An iterable of extensionProperties elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExtensionProperties(Iterable<String> elements) {
      this.extensionProperties.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link ExtensionDefinition#getHydrated() hydrated} attribute.
     * @param hydrated The value for hydrated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hydrated")
    public final Builder hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      return this;
    }

    /**
     * Initializes the value for the {@link ExtensionDefinition#toJsonString() toJsonString} attribute.
     * @param toJsonString The value for toJsonString (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("toJsonString")
    public final Builder toJsonString(String toJsonString) {
      this.toJsonString = toJsonString;
      return this;
    }

    /**
     * Put one entry to the {@link ExtensionDefinition#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ExtensionDefinition#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ExtensionDefinition#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ExtensionDefinition#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ExtensionDefinitionObject ExtensionDefinitionObject}.
     * @return An immutable instance of ExtensionDefinition
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ExtensionDefinitionObject build() {
      return new ExtensionDefinitionObject(this);
    }
  }
}
