package security.whisper.javastix.meta;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.types.ExternalReferenceType;

/**
 * Immutable implementation of {@link LanguageContent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code LanguageContentObject.builder()}.
 */
@Generated(from = "LanguageContent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("language-content")
@Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
public final class LanguageContentObject implements LanguageContent {
  private final String id;
  private final String specVersion;
  private final @Nullable String createdByRef;
  private final StixInstant created;
  private final StixInstant modified;
  private final @Nullable Boolean revoked;
  private final ImmutableSet<String> labels;
  private final @Nullable Integer confidence;
  private final ImmutableSet<ExternalReferenceType> externalReferences;
  private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
  private final ImmutableSet<GranularMarkingDm> granularMarkings;
  private final String objectRef;
  private final StixInstant objectModified;
  private final ImmutableMap<String, Map<String, String>> contents;
  private final boolean hydrated;
  private final String toJsonString;
  private final ImmutableMap<String, Object> customProperties;

  private LanguageContentObject(LanguageContentObject.Builder builder) {
    this.id = builder.id;
    this.createdByRef = builder.createdByRef;
    this.created = builder.created;
    this.modified = builder.modified;
    this.revoked = builder.revoked;
    this.labels = builder.labels.build();
    this.confidence = builder.confidence;
    this.externalReferences = builder.externalReferences.build();
    this.objectMarkingRefs = builder.objectMarkingRefs.build();
    this.granularMarkings = builder.granularMarkings.build();
    this.objectRef = builder.objectRef;
    this.objectModified = builder.objectModified;
    this.contents = builder.contents.build();
    this.hydrated = builder.hydrated;
    this.toJsonString = builder.toJsonString;
    this.customProperties = builder.customProperties.build();
    this.specVersion = builder.specVersion != null
        ? builder.specVersion
        : Objects.requireNonNull(LanguageContent.super.getSpecVersion(), "specVersion");
  }

  private LanguageContentObject(
      String id,
      String specVersion,
      @Nullable String createdByRef,
      StixInstant created,
      StixInstant modified,
      @Nullable Boolean revoked,
      ImmutableSet<String> labels,
      @Nullable Integer confidence,
      ImmutableSet<ExternalReferenceType> externalReferences,
      ImmutableSet<MarkingDefinitionDm> objectMarkingRefs,
      ImmutableSet<GranularMarkingDm> granularMarkings,
      String objectRef,
      StixInstant objectModified,
      ImmutableMap<String, Map<String, String>> contents,
      boolean hydrated,
      String toJsonString,
      ImmutableMap<String, Object> customProperties) {
    this.id = id;
    this.specVersion = specVersion;
    this.createdByRef = createdByRef;
    this.created = created;
    this.modified = modified;
    this.revoked = revoked;
    this.labels = labels;
    this.confidence = confidence;
    this.externalReferences = externalReferences;
    this.objectMarkingRefs = objectMarkingRefs;
    this.granularMarkings = granularMarkings;
    this.objectRef = objectRef;
    this.objectModified = objectModified;
    this.contents = contents;
    this.hydrated = hydrated;
    this.toJsonString = toJsonString;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JsonPropertyDescription("Specifies the identifier for this Language Content object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code specVersion} attribute
   */
  @JsonProperty("spec_version")
  @JsonPropertyDescription("The version of the STIX specification used to represent this object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getSpecVersion() {
    return specVersion;
  }

  /**
   * @return The value of the {@code createdByRef} attribute
   */
  @JsonProperty("created_by_ref")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The ID of the identity that created this language content object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getCreatedByRef() {
    return Optional.ofNullable(createdByRef);
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @JsonPropertyDescription("The created property represents the time at which this object was originally created.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code modified} attribute
   */
  @JsonProperty("modified")
  @JsonPropertyDescription("The modified property represents the time at which this object was last modified.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getModified() {
    return modified;
  }

  /**
   * @return The value of the {@code revoked} attribute
   */
  @JsonProperty("revoked")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The revoked property is a boolean that indicates whether the object has been revoked.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<Boolean> getRevoked() {
    return Optional.ofNullable(revoked);
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The labels property specifies a set of categorization labels.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<String> getLabels() {
    return labels;
  }

  /**
   * @return The value of the {@code confidence} attribute
   */
  @JsonProperty("confidence")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The confidence property identifies the confidence that the creator has in the correctness of their data.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<Integer> getConfidence() {
    return Optional.ofNullable(confidence);
  }

  /**
   * @return The value of the {@code externalReferences} attribute
   */
  @JsonProperty("external_references")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A list of external references which refer to non-STIX information.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<ExternalReferenceType> getExternalReferences() {
    return externalReferences;
  }

  /**
   * @return The value of the {@code objectMarkingRefs} attribute
   */
  @JsonProperty("object_marking_refs")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
    return objectMarkingRefs;
  }

  /**
   * @return The value of the {@code granularMarkings} attribute
   */
  @JsonProperty("granular_markings")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The set of granular markings that apply to this object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
    return granularMarkings;
  }

  /**
   * @return The value of the {@code objectRef} attribute
   */
  @JsonProperty("object_ref")
  @JsonPropertyDescription("Specifies the identifier of the object that this language content applies to.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getObjectRef() {
    return objectRef;
  }

  /**
   * @return The value of the {@code objectModified} attribute
   */
  @JsonProperty("object_modified")
  @JsonPropertyDescription("Specifies the modified time of the object that this language content applies to.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getObjectModified() {
    return objectModified;
  }

  /**
   * @return The value of the {@code contents} attribute
   */
  @JsonProperty("contents")
  @JsonPropertyDescription("A dictionary that captures the text content in different languages. The key is the language code and the value is a dictionary containing the translated content.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableMap<String, Map<String, String>> getContents() {
    return contents;
  }

  /**
   * @return The value of the {@code hydrated} attribute
   */
  @JsonProperty("hydrated")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public boolean getHydrated() {
    return hydrated;
  }

  /**
   * @return The value of the {@code toJsonString} attribute
   */
  @JsonProperty("toJsonString")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String toJsonString() {
    return toJsonString;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LanguageContent#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final LanguageContentObject withId(String value) {
    if (Objects.equals(this.id, value)) return this;
    return new LanguageContentObject(
        value,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LanguageContent#getSpecVersion() specVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for specVersion
   * @return A modified copy of the {@code this} object
   */
  public final LanguageContentObject withSpecVersion(String value) {
    String newValue = Objects.requireNonNull(value, "specVersion");
    if (this.specVersion.equals(newValue)) return this;
    return new LanguageContentObject(
        this.id,
        newValue,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LanguageContent#getCreatedByRef() createdByRef} attribute.
   * @param value The value for createdByRef
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withCreatedByRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "createdByRef");
    if (Objects.equals(this.createdByRef, newValue)) return this;
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        newValue,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LanguageContent#getCreatedByRef() createdByRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for createdByRef
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withCreatedByRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.createdByRef, value)) return this;
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        value,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LanguageContent#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final LanguageContentObject withCreated(StixInstant value) {
    if (this.created == value) return this;
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        value,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LanguageContent#getModified() modified} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modified (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final LanguageContentObject withModified(StixInstant value) {
    if (this.modified == value) return this;
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        value,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LanguageContent#getRevoked() revoked} attribute.
   * @param value The value for revoked
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withRevoked(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.revoked, newValue)) return this;
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        newValue,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LanguageContent#getRevoked() revoked} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for revoked
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withRevoked(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.revoked, value)) return this;
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        value,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LanguageContent#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withLabels(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        newValue,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LanguageContent#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withLabels(Iterable<String> elements) {
    if (this.labels == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        newValue,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LanguageContent#getConfidence() confidence} attribute.
   * @param value The value for confidence
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withConfidence(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.confidence, newValue)) return this;
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        newValue,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LanguageContent#getConfidence() confidence} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for confidence
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withConfidence(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.confidence, value)) return this;
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        value,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LanguageContent#getExternalReferences() externalReferences}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withExternalReferences(ExternalReferenceType... elements) {
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LanguageContent#getExternalReferences() externalReferences}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of externalReferences elements to set
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
    if (this.externalReferences == elements) return this;
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LanguageContent#getObjectMarkingRefs() objectMarkingRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withObjectMarkingRefs(MarkingDefinitionDm... elements) {
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LanguageContent#getObjectMarkingRefs() objectMarkingRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectMarkingRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
    if (this.objectMarkingRefs == elements) return this;
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LanguageContent#getGranularMarkings() granularMarkings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withGranularMarkings(GranularMarkingDm... elements) {
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LanguageContent#getGranularMarkings() granularMarkings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of granularMarkings elements to set
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
    if (this.granularMarkings == elements) return this;
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LanguageContent#getObjectRef() objectRef} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for objectRef (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final LanguageContentObject withObjectRef(String value) {
    if (Objects.equals(this.objectRef, value)) return this;
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        value,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LanguageContent#getObjectModified() objectModified} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for objectModified (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final LanguageContentObject withObjectModified(StixInstant value) {
    if (this.objectModified == value) return this;
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        value,
        this.contents,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link LanguageContent#getContents() contents} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the contents map
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withContents(Map<String, ? extends Map<String, String>> entries) {
    if (this.contents == entries) return this;
    ImmutableMap<String, Map<String, String>> newValue = ImmutableMap.copyOf(entries);
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        newValue,
        this.hydrated,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LanguageContent#getHydrated() hydrated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hydrated
   * @return A modified copy of the {@code this} object
   */
  public final LanguageContentObject withHydrated(boolean value) {
    if (this.hydrated == value) return this;
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        value,
        this.toJsonString,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LanguageContent#toJsonString() toJsonString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toJsonString (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final LanguageContentObject withToJsonString(String value) {
    if (Objects.equals(this.toJsonString, value)) return this;
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        value,
        this.customProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link LanguageContent#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final LanguageContentObject withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return new LanguageContentObject(
        this.id,
        this.specVersion,
        this.createdByRef,
        this.created,
        this.modified,
        this.revoked,
        this.labels,
        this.confidence,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.objectRef,
        this.objectModified,
        this.contents,
        this.hydrated,
        this.toJsonString,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code LanguageContentObject} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof LanguageContentObject
        && equalTo((LanguageContentObject) another);
  }

  private boolean equalTo(LanguageContentObject another) {
    return Objects.equals(id, another.id)
        && specVersion.equals(another.specVersion)
        && Objects.equals(createdByRef, another.createdByRef)
        && Objects.equals(created, another.created)
        && Objects.equals(modified, another.modified)
        && Objects.equals(revoked, another.revoked)
        && labels.equals(another.labels)
        && Objects.equals(confidence, another.confidence)
        && externalReferences.equals(another.externalReferences)
        && objectMarkingRefs.equals(another.objectMarkingRefs)
        && granularMarkings.equals(another.granularMarkings)
        && Objects.equals(objectRef, another.objectRef)
        && Objects.equals(objectModified, another.objectModified)
        && contents.equals(another.contents)
        && hydrated == another.hydrated
        && Objects.equals(toJsonString, another.toJsonString)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code specVersion}, {@code createdByRef}, {@code created}, {@code modified}, {@code revoked}, {@code labels}, {@code confidence}, {@code externalReferences}, {@code objectMarkingRefs}, {@code granularMarkings}, {@code objectRef}, {@code objectModified}, {@code contents}, {@code hydrated}, {@code toJsonString}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + specVersion.hashCode();
    h += (h << 5) + Objects.hashCode(createdByRef);
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(modified);
    h += (h << 5) + Objects.hashCode(revoked);
    h += (h << 5) + labels.hashCode();
    h += (h << 5) + Objects.hashCode(confidence);
    h += (h << 5) + externalReferences.hashCode();
    h += (h << 5) + objectMarkingRefs.hashCode();
    h += (h << 5) + granularMarkings.hashCode();
    h += (h << 5) + Objects.hashCode(objectRef);
    h += (h << 5) + Objects.hashCode(objectModified);
    h += (h << 5) + contents.hashCode();
    h += (h << 5) + Booleans.hashCode(hydrated);
    h += (h << 5) + Objects.hashCode(toJsonString);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LanguageContent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LanguageContent")
        .omitNullValues()
        .add("id", id)
        .add("specVersion", specVersion)
        .add("createdByRef", createdByRef)
        .add("created", created)
        .add("modified", modified)
        .add("revoked", revoked)
        .add("labels", labels)
        .add("confidence", confidence)
        .add("externalReferences", externalReferences)
        .add("objectMarkingRefs", objectMarkingRefs)
        .add("granularMarkings", granularMarkings)
        .add("objectRef", objectRef)
        .add("objectModified", objectModified)
        .add("contents", contents)
        .add("hydrated", hydrated)
        .add("toJsonString", toJsonString)
        .add("customProperties", customProperties)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link LanguageContent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LanguageContent instance
   */
  public static LanguageContentObject copyOf(LanguageContent instance) {
    if (instance instanceof LanguageContentObject) {
      return (LanguageContentObject) instance;
    }
    return LanguageContentObject.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  /**
   * Creates a builder for {@link LanguageContentObject LanguageContentObject}.
   * @return A new LanguageContentObject builder
   */
  public static LanguageContentObject.Builder builder() {
    return new LanguageContentObject.Builder();
  }

  /**
   * Builds instances of type {@link LanguageContentObject LanguageContentObject}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LanguageContent", generator = "Immutables")
  @NotThreadSafe
  @JsonTypeName("language-content")
  @JsonPropertyOrder({"type", "spec_version", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "object_ref", "object_modified", "contents"})
  public static final class Builder {
    private @Nullable String id;
    private @Nullable String specVersion;
    private @Nullable String createdByRef;
    private @Nullable StixInstant created;
    private @Nullable StixInstant modified;
    private @Nullable Boolean revoked;
    private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
    private @Nullable Integer confidence;
    private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
    private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
    private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
    private @Nullable String objectRef;
    private @Nullable StixInstant objectModified;
    private ImmutableMap.Builder<String, Map<String, String>> contents = ImmutableMap.builder();
    private boolean hydrated;
    private @Nullable String toJsonString;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleableObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleableObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.meta.LanguageContent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LanguageContent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BundleableObject) {
        BundleableObject instance = (BundleableObject) object;
        if ((bits & 0x2L) == 0) {
          String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x4L;
        }
        hydrated(instance.getHydrated());
        if ((bits & 0x1L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x1L;
        }
        String toJsonStringValue = instance.toJsonString();
        if (toJsonStringValue != null) {
          toJsonString(toJsonStringValue);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof LanguageContent) {
        LanguageContent instance = (LanguageContent) object;
        specVersion(instance.getSpecVersion());
        addAllExternalReferences(instance.getExternalReferences());
        String objectRefValue = instance.getObjectRef();
        if (objectRefValue != null) {
          objectRef(objectRefValue);
        }
        StixInstant createdValue = instance.getCreated();
        if (createdValue != null) {
          created(createdValue);
        }
        Optional<Integer> confidenceOptional = instance.getConfidence();
        if (confidenceOptional.isPresent()) {
          confidence(confidenceOptional);
        }
        StixInstant objectModifiedValue = instance.getObjectModified();
        if (objectModifiedValue != null) {
          objectModified(objectModifiedValue);
        }
        Optional<Boolean> revokedOptional = instance.getRevoked();
        if (revokedOptional.isPresent()) {
          revoked(revokedOptional);
        }
        addAllLabels(instance.getLabels());
        putAllContents(instance.getContents());
        if ((bits & 0x1L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x1L;
        }
        StixInstant modifiedValue = instance.getModified();
        if (modifiedValue != null) {
          modified(modifiedValue);
        }
        Optional<String> createdByRefOptional = instance.getCreatedByRef();
        if (createdByRefOptional.isPresent()) {
          createdByRef(createdByRefOptional);
        }
        if ((bits & 0x2L) == 0) {
          String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link LanguageContent#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    @JsonPropertyDescription("Specifies the identifier for this Language Content object.")
    public final Builder id(String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link LanguageContent#getSpecVersion() specVersion} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LanguageContent#getSpecVersion() specVersion}.</em>
     * @param specVersion The value for specVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("spec_version")
    @JsonPropertyDescription("The version of the STIX specification used to represent this object.")
    public final Builder specVersion(String specVersion) {
      this.specVersion = Objects.requireNonNull(specVersion, "specVersion");
      return this;
    }

    /**
     * Initializes the optional value {@link LanguageContent#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder createdByRef(String createdByRef) {
      this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
      return this;
    }

    /**
     * Initializes the optional value {@link LanguageContent#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created_by_ref")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The ID of the identity that created this language content object.")
    public final Builder createdByRef(Optional<String> createdByRef) {
      this.createdByRef = createdByRef.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link LanguageContent#getCreated() created} attribute.
     * @param created The value for created (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    @JsonPropertyDescription("The created property represents the time at which this object was originally created.")
    public final Builder created(StixInstant created) {
      this.created = created;
      return this;
    }

    /**
     * Initializes the value for the {@link LanguageContent#getModified() modified} attribute.
     * @param modified The value for modified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("modified")
    @JsonPropertyDescription("The modified property represents the time at which this object was last modified.")
    public final Builder modified(StixInstant modified) {
      this.modified = modified;
      return this;
    }

    /**
     * Initializes the optional value {@link LanguageContent#getRevoked() revoked} to revoked.
     * @param revoked The value for revoked
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder revoked(boolean revoked) {
      this.revoked = revoked;
      return this;
    }

    /**
     * Initializes the optional value {@link LanguageContent#getRevoked() revoked} to revoked.
     * @param revoked The value for revoked
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("revoked")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The revoked property is a boolean that indicates whether the object has been revoked.")
    public final Builder revoked(Optional<Boolean> revoked) {
      this.revoked = revoked.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link LanguageContent#getLabels() labels} set.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabel(@Nullable String element) {
      this.labels.add(element);
      return this;
    }

    /**
     * Adds elements to {@link LanguageContent#getLabels() labels} set.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(String... elements) {
      this.labels.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LanguageContent#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labels")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The labels property specifies a set of categorization labels.")
    public final Builder labels(Iterable<String> elements) {
      this.labels = ImmutableSet.builder();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link LanguageContent#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<String> elements) {
      this.labels.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link LanguageContent#getConfidence() confidence} to confidence.
     * @param confidence The value for confidence
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder confidence(int confidence) {
      this.confidence = confidence;
      return this;
    }

    /**
     * Initializes the optional value {@link LanguageContent#getConfidence() confidence} to confidence.
     * @param confidence The value for confidence
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("confidence")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The confidence property identifies the confidence that the creator has in the correctness of their data.")
    public final Builder confidence(Optional<Integer> confidence) {
      this.confidence = confidence.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link LanguageContent#getExternalReferences() externalReferences} set.
     * @param element A externalReferences element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
      this.externalReferences.add(element);
      return this;
    }

    /**
     * Adds elements to {@link LanguageContent#getExternalReferences() externalReferences} set.
     * @param elements An array of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReferences(ExternalReferenceType... elements) {
      this.externalReferences.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LanguageContent#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("external_references")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A list of external references which refer to non-STIX information.")
    public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences = ImmutableSet.builder();
      return addAllExternalReferences(elements);
    }

    /**
     * Adds elements to {@link LanguageContent#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link LanguageContent#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param element A objectMarkingRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
      this.objectMarkingRefs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link LanguageContent#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An array of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRefs(MarkingDefinitionDm... elements) {
      this.objectMarkingRefs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LanguageContent#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("object_marking_refs")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
    public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs = ImmutableSet.builder();
      return addAllObjectMarkingRefs(elements);
    }

    /**
     * Adds elements to {@link LanguageContent#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link LanguageContent#getGranularMarkings() granularMarkings} set.
     * @param element A granularMarkings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
      this.granularMarkings.add(element);
      return this;
    }

    /**
     * Adds elements to {@link LanguageContent#getGranularMarkings() granularMarkings} set.
     * @param elements An array of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarkings(GranularMarkingDm... elements) {
      this.granularMarkings.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LanguageContent#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("granular_markings")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The set of granular markings that apply to this object.")
    public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings = ImmutableSet.builder();
      return addAllGranularMarkings(elements);
    }

    /**
     * Adds elements to {@link LanguageContent#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link LanguageContent#getObjectRef() objectRef} attribute.
     * @param objectRef The value for objectRef (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("object_ref")
    @JsonPropertyDescription("Specifies the identifier of the object that this language content applies to.")
    public final Builder objectRef(String objectRef) {
      this.objectRef = objectRef;
      return this;
    }

    /**
     * Initializes the value for the {@link LanguageContent#getObjectModified() objectModified} attribute.
     * @param objectModified The value for objectModified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("object_modified")
    @JsonPropertyDescription("Specifies the modified time of the object that this language content applies to.")
    public final Builder objectModified(StixInstant objectModified) {
      this.objectModified = objectModified;
      return this;
    }

    /**
     * Put one entry to the {@link LanguageContent#getContents() contents} map.
     * @param key The key in the contents map
     * @param value The associated value in the contents map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putContent(String key, Map<String, String> value) {
      this.contents.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link LanguageContent#getContents() contents} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putContent(Map.Entry<String, ? extends Map<String, String>> entry) {
      this.contents.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link LanguageContent#getContents() contents} map. Nulls are not permitted
     * @param entries The entries that will be added to the contents map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("contents")
    @JsonPropertyDescription("A dictionary that captures the text content in different languages. The key is the language code and the value is a dictionary containing the translated content.")
    public final Builder contents(Map<String, ? extends Map<String, String>> entries) {
      this.contents = ImmutableMap.builder();
      return putAllContents(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link LanguageContent#getContents() contents} map. Nulls are not permitted
     * @param entries The entries that will be added to the contents map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllContents(Map<String, ? extends Map<String, String>> entries) {
      this.contents.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link LanguageContent#getHydrated() hydrated} attribute.
     * @param hydrated The value for hydrated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hydrated")
    public final Builder hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      return this;
    }

    /**
     * Initializes the value for the {@link LanguageContent#toJsonString() toJsonString} attribute.
     * @param toJsonString The value for toJsonString (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("toJsonString")
    public final Builder toJsonString(String toJsonString) {
      this.toJsonString = toJsonString;
      return this;
    }

    /**
     * Put one entry to the {@link LanguageContent#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link LanguageContent#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link LanguageContent#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link LanguageContent#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link LanguageContentObject LanguageContentObject}.
     * @return An immutable instance of LanguageContent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public LanguageContentObject build() {
      return new LanguageContentObject(this);
    }
  }
}
