package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixBoolean;
import security.whisper.javastix.common.StixCommonProperties;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.common.StixLabels;
import security.whisper.javastix.common.StixModified;
import security.whisper.javastix.common.StixRevoked;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectOptionalConverter;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.types.ExternalReferenceType;
import security.whisper.javastix.sdo.types.KillChainPhaseType;
import security.whisper.javastix.sro.objects.RelationshipSro;

/**
 * infrastructure
 * <p>
 * The Infrastructure SDO represents a type of TTP and describes any systems, software services,
 * and associated physical or virtual resources intended to support some purpose (e.g., C2 servers
 * used as part of an attack, drive-by download websites, etc.).
 * This object is part of STIX 2.1 specification.
 */
@Generated(from = "InfrastructureSdo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("infrastructure")
@Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
public final class Infrastructure implements InfrastructureSdo {
  private final String name;
  private final @Nullable String description;
  private final ImmutableSet<String> infrastructureTypes;
  private final ImmutableSet<String> aliases;
  private final ImmutableSet<KillChainPhaseType> killChainPhases;
  private final @Nullable StixInstant firstSeen;
  private final @Nullable StixInstant lastSeen;
  private final ImmutableSet<RelationshipSro> relationships;
  private final boolean hydrated;
  private final String type;
  private final String id;
  private final @Nullable IdentitySdo createdByRef;
  private final StixInstant created;
  private final @Nullable String lang;
  private final ImmutableSet<ExternalReferenceType> externalReferences;
  private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
  private final ImmutableSet<GranularMarkingDm> granularMarkings;
  private final ImmutableMap<String, Object> customProperties;
  private final ImmutableSet<String> labels;
  private final StixInstant modified;
  private final StixBoolean revoked;

  private Infrastructure(Infrastructure.Builder builder) {
    this.name = builder.name;
    this.description = builder.description;
    this.infrastructureTypes = builder.infrastructureTypes.build();
    this.firstSeen = builder.firstSeen;
    this.lastSeen = builder.lastSeen;
    this.type = builder.type;
    this.id = builder.id;
    this.createdByRef = builder.createdByRef;
    this.lang = builder.lang;
    this.customProperties = builder.customProperties.build();
    if (builder.aliasesIsSet()) {
      initShim.aliases(builder.aliases.build());
    }
    if (builder.killChainPhasesIsSet()) {
      initShim.killChainPhases(builder.killChainPhases.build());
    }
    if (builder.relationshipsIsSet()) {
      initShim.relationships(builder.relationships.build());
    }
    if (builder.hydratedIsSet()) {
      initShim.hydrated(builder.hydrated);
    }
    if (builder.created != null) {
      initShim.created(builder.created);
    }
    if (builder.externalReferencesIsSet()) {
      initShim.externalReferences(builder.externalReferences.build());
    }
    if (builder.objectMarkingRefsIsSet()) {
      initShim.objectMarkingRefs(builder.objectMarkingRefs.build());
    }
    if (builder.granularMarkingsIsSet()) {
      initShim.granularMarkings(builder.granularMarkings.build());
    }
    if (builder.labelsIsSet()) {
      initShim.labels(builder.labels.build());
    }
    if (builder.modified != null) {
      initShim.modified(builder.modified);
    }
    if (builder.revoked != null) {
      initShim.revoked(builder.revoked);
    }
    this.aliases = initShim.getAliases();
    this.killChainPhases = initShim.getKillChainPhases();
    this.relationships = initShim.getRelationships();
    this.hydrated = initShim.getHydrated();
    this.created = initShim.getCreated();
    this.externalReferences = initShim.getExternalReferences();
    this.objectMarkingRefs = initShim.getObjectMarkingRefs();
    this.granularMarkings = initShim.getGranularMarkings();
    this.labels = initShim.getLabels();
    this.modified = initShim.getModified();
    this.revoked = initShim.getRevoked();
    this.initShim = null;
  }

  private Infrastructure(
      String name,
      @Nullable String description,
      ImmutableSet<String> infrastructureTypes,
      ImmutableSet<String> aliases,
      ImmutableSet<KillChainPhaseType> killChainPhases,
      @Nullable StixInstant firstSeen,
      @Nullable StixInstant lastSeen,
      ImmutableSet<RelationshipSro> relationships,
      boolean hydrated,
      String type,
      String id,
      @Nullable IdentitySdo createdByRef,
      StixInstant created,
      @Nullable String lang,
      ImmutableSet<ExternalReferenceType> externalReferences,
      ImmutableSet<MarkingDefinitionDm> objectMarkingRefs,
      ImmutableSet<GranularMarkingDm> granularMarkings,
      ImmutableMap<String, Object> customProperties,
      ImmutableSet<String> labels,
      StixInstant modified,
      StixBoolean revoked) {
    this.name = name;
    this.description = description;
    this.infrastructureTypes = infrastructureTypes;
    this.aliases = aliases;
    this.killChainPhases = killChainPhases;
    this.firstSeen = firstSeen;
    this.lastSeen = lastSeen;
    this.relationships = relationships;
    this.hydrated = hydrated;
    this.type = type;
    this.id = id;
    this.createdByRef = createdByRef;
    this.created = created;
    this.lang = lang;
    this.externalReferences = externalReferences;
    this.objectMarkingRefs = objectMarkingRefs;
    this.granularMarkings = granularMarkings;
    this.customProperties = customProperties;
    this.labels = labels;
    this.modified = modified;
    this.revoked = revoked;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "InfrastructureSdo", generator = "Immutables")
  private final class InitShim {
    private byte aliasesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<String> aliases;

    ImmutableSet<String> getAliases() {
      if (aliasesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (aliasesBuildStage == STAGE_UNINITIALIZED) {
        aliasesBuildStage = STAGE_INITIALIZING;
        this.aliases = ImmutableSet.copyOf(getAliasesInitialize());
        aliasesBuildStage = STAGE_INITIALIZED;
      }
      return this.aliases;
    }

    void aliases(ImmutableSet<String> aliases) {
      this.aliases = aliases;
      aliasesBuildStage = STAGE_INITIALIZED;
    }

    private byte killChainPhasesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<KillChainPhaseType> killChainPhases;

    ImmutableSet<KillChainPhaseType> getKillChainPhases() {
      if (killChainPhasesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (killChainPhasesBuildStage == STAGE_UNINITIALIZED) {
        killChainPhasesBuildStage = STAGE_INITIALIZING;
        this.killChainPhases = ImmutableSet.copyOf(getKillChainPhasesInitialize());
        killChainPhasesBuildStage = STAGE_INITIALIZED;
      }
      return this.killChainPhases;
    }

    void killChainPhases(ImmutableSet<KillChainPhaseType> killChainPhases) {
      this.killChainPhases = killChainPhases;
      killChainPhasesBuildStage = STAGE_INITIALIZED;
    }

    private byte relationshipsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<RelationshipSro> relationships;

    ImmutableSet<RelationshipSro> getRelationships() {
      if (relationshipsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (relationshipsBuildStage == STAGE_UNINITIALIZED) {
        relationshipsBuildStage = STAGE_INITIALIZING;
        this.relationships = ImmutableSet.copyOf(getRelationshipsInitialize());
        relationshipsBuildStage = STAGE_INITIALIZED;
      }
      return this.relationships;
    }

    void relationships(ImmutableSet<RelationshipSro> relationships) {
      this.relationships = relationships;
      relationshipsBuildStage = STAGE_INITIALIZED;
    }

    private byte hydratedBuildStage = STAGE_UNINITIALIZED;
    private boolean hydrated;

    boolean getHydrated() {
      if (hydratedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hydratedBuildStage == STAGE_UNINITIALIZED) {
        hydratedBuildStage = STAGE_INITIALIZING;
        this.hydrated = getHydratedInitialize();
        hydratedBuildStage = STAGE_INITIALIZED;
      }
      return this.hydrated;
    }

    void hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      hydratedBuildStage = STAGE_INITIALIZED;
    }

    private byte createdBuildStage = STAGE_UNINITIALIZED;
    private StixInstant created;

    StixInstant getCreated() {
      if (createdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (createdBuildStage == STAGE_UNINITIALIZED) {
        createdBuildStage = STAGE_INITIALIZING;
        this.created = Objects.requireNonNull(getCreatedInitialize(), "created");
        createdBuildStage = STAGE_INITIALIZED;
      }
      return this.created;
    }

    void created(StixInstant created) {
      this.created = created;
      createdBuildStage = STAGE_INITIALIZED;
    }

    private byte externalReferencesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<ExternalReferenceType> externalReferences;

    ImmutableSet<ExternalReferenceType> getExternalReferences() {
      if (externalReferencesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (externalReferencesBuildStage == STAGE_UNINITIALIZED) {
        externalReferencesBuildStage = STAGE_INITIALIZING;
        this.externalReferences = ImmutableSet.copyOf(getExternalReferencesInitialize());
        externalReferencesBuildStage = STAGE_INITIALIZED;
      }
      return this.externalReferences;
    }

    void externalReferences(ImmutableSet<ExternalReferenceType> externalReferences) {
      this.externalReferences = externalReferences;
      externalReferencesBuildStage = STAGE_INITIALIZED;
    }

    private byte objectMarkingRefsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;

    ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
      if (objectMarkingRefsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectMarkingRefsBuildStage == STAGE_UNINITIALIZED) {
        objectMarkingRefsBuildStage = STAGE_INITIALIZING;
        this.objectMarkingRefs = ImmutableSet.copyOf(getObjectMarkingRefsInitialize());
        objectMarkingRefsBuildStage = STAGE_INITIALIZED;
      }
      return this.objectMarkingRefs;
    }

    void objectMarkingRefs(ImmutableSet<MarkingDefinitionDm> objectMarkingRefs) {
      this.objectMarkingRefs = objectMarkingRefs;
      objectMarkingRefsBuildStage = STAGE_INITIALIZED;
    }

    private byte granularMarkingsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<GranularMarkingDm> granularMarkings;

    ImmutableSet<GranularMarkingDm> getGranularMarkings() {
      if (granularMarkingsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (granularMarkingsBuildStage == STAGE_UNINITIALIZED) {
        granularMarkingsBuildStage = STAGE_INITIALIZING;
        this.granularMarkings = ImmutableSet.copyOf(getGranularMarkingsInitialize());
        granularMarkingsBuildStage = STAGE_INITIALIZED;
      }
      return this.granularMarkings;
    }

    void granularMarkings(ImmutableSet<GranularMarkingDm> granularMarkings) {
      this.granularMarkings = granularMarkings;
      granularMarkingsBuildStage = STAGE_INITIALIZED;
    }

    private byte labelsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<String> labels;

    ImmutableSet<String> getLabels() {
      if (labelsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (labelsBuildStage == STAGE_UNINITIALIZED) {
        labelsBuildStage = STAGE_INITIALIZING;
        this.labels = ImmutableSet.copyOf(getLabelsInitialize());
        labelsBuildStage = STAGE_INITIALIZED;
      }
      return this.labels;
    }

    void labels(ImmutableSet<String> labels) {
      this.labels = labels;
      labelsBuildStage = STAGE_INITIALIZED;
    }

    private byte modifiedBuildStage = STAGE_UNINITIALIZED;
    private StixInstant modified;

    StixInstant getModified() {
      if (modifiedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (modifiedBuildStage == STAGE_UNINITIALIZED) {
        modifiedBuildStage = STAGE_INITIALIZING;
        this.modified = Objects.requireNonNull(getModifiedInitialize(), "modified");
        modifiedBuildStage = STAGE_INITIALIZED;
      }
      return this.modified;
    }

    void modified(StixInstant modified) {
      this.modified = modified;
      modifiedBuildStage = STAGE_INITIALIZED;
    }

    private byte revokedBuildStage = STAGE_UNINITIALIZED;
    private StixBoolean revoked;

    StixBoolean getRevoked() {
      if (revokedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (revokedBuildStage == STAGE_UNINITIALIZED) {
        revokedBuildStage = STAGE_INITIALIZING;
        this.revoked = Objects.requireNonNull(getRevokedInitialize(), "revoked");
        revokedBuildStage = STAGE_INITIALIZED;
      }
      return this.revoked;
    }

    void revoked(StixBoolean revoked) {
      this.revoked = revoked;
      revokedBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (aliasesBuildStage == STAGE_INITIALIZING) attributes.add("aliases");
      if (killChainPhasesBuildStage == STAGE_INITIALIZING) attributes.add("killChainPhases");
      if (relationshipsBuildStage == STAGE_INITIALIZING) attributes.add("relationships");
      if (hydratedBuildStage == STAGE_INITIALIZING) attributes.add("hydrated");
      if (createdBuildStage == STAGE_INITIALIZING) attributes.add("created");
      if (externalReferencesBuildStage == STAGE_INITIALIZING) attributes.add("externalReferences");
      if (objectMarkingRefsBuildStage == STAGE_INITIALIZING) attributes.add("objectMarkingRefs");
      if (granularMarkingsBuildStage == STAGE_INITIALIZING) attributes.add("granularMarkings");
      if (labelsBuildStage == STAGE_INITIALIZING) attributes.add("labels");
      if (modifiedBuildStage == STAGE_INITIALIZING) attributes.add("modified");
      if (revokedBuildStage == STAGE_INITIALIZING) attributes.add("revoked");
      return "Cannot build Infrastructure, attribute initializers form cycle " + attributes;
    }
  }

  private Set<String> getAliasesInitialize() {
    return InfrastructureSdo.super.getAliases();
  }

  private Set<KillChainPhaseType> getKillChainPhasesInitialize() {
    return InfrastructureSdo.super.getKillChainPhases();
  }

  private Set<RelationshipSro> getRelationshipsInitialize() {
    return InfrastructureSdo.super.getRelationships();
  }

  private boolean getHydratedInitialize() {
    return InfrastructureSdo.super.getHydrated();
  }

  private StixInstant getCreatedInitialize() {
    return InfrastructureSdo.super.getCreated();
  }

  private Set<ExternalReferenceType> getExternalReferencesInitialize() {
    return InfrastructureSdo.super.getExternalReferences();
  }

  private Set<MarkingDefinitionDm> getObjectMarkingRefsInitialize() {
    return InfrastructureSdo.super.getObjectMarkingRefs();
  }

  private Set<GranularMarkingDm> getGranularMarkingsInitialize() {
    return InfrastructureSdo.super.getGranularMarkings();
  }

  private Set<String> getLabelsInitialize() {
    return InfrastructureSdo.super.getLabels();
  }

  private StixInstant getModifiedInitialize() {
    return InfrastructureSdo.super.getModified();
  }

  private StixBoolean getRevokedInitialize() {
    return InfrastructureSdo.super.getRevoked();
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JsonPropertyDescription("The name used to identify the Infrastructure.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A description that provides more details and context about the Infrastructure, potentially including its purpose and its key characteristics.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getDescription() {
    return Optional.ofNullable(description);
  }

  /**
   * @return The value of the {@code infrastructureTypes} attribute
   */
  @JsonProperty("infrastructure_types")
  @JsonPropertyDescription("The type of infrastructure being described. Open Vocabulary: infrastructure-type-ov")
  @Redactable(useMask = true, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<String> getInfrastructureTypes() {
    return infrastructureTypes;
  }

  /**
   * @return The value of the {@code aliases} attribute
   */
  @JsonProperty("aliases")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Alternative names used to identify this Infrastructure.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<String> getAliases() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAliases()
        : this.aliases;
  }

  /**
   * @return The value of the {@code killChainPhases} attribute
   */
  @JsonProperty("kill_chain_phases")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The list of kill chain phases for which this Infrastructure is used.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<KillChainPhaseType> getKillChainPhases() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getKillChainPhases()
        : this.killChainPhases;
  }

  /**
   * @return The value of the {@code firstSeen} attribute
   */
  @JsonProperty("first_seen")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The time that this Infrastructure was first seen performing malicious activities.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<StixInstant> getFirstSeen() {
    return Optional.ofNullable(firstSeen);
  }

  /**
   * @return The value of the {@code lastSeen} attribute
   */
  @JsonProperty("last_seen")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The time that this Infrastructure was last seen performing malicious activities.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<StixInstant> getLastSeen() {
    return Optional.ofNullable(lastSeen);
  }

  /**
   * This is used with the SROs.  The SRO interface enforces what relationships can be created.  The Relationships can then be stored in the Domain object if they choose.
   * Otherwise you would typically add these Relationship SROs that are specific to SDOs, can be grabbed during bundle creation.
   * @return Set of Relationship SROs
   */
  @JsonProperty("relationships")
  @JsonIgnore
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<RelationshipSro> getRelationships() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRelationships()
        : this.relationships;
  }

  /**
   * Dictates if the object is hydrated.
   * Hydration is defined as if the Object has only a "ID" or has been properly
   * hydrated with the expected required fields
   * @return boolean
   */
  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public boolean getHydrated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHydrated()
        : this.hydrated;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @JsonPropertyDescription("The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code createdByRef} attribute
   */
  @JsonProperty("created_by_ref")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
  @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
  @JsonIdentityReference(alwaysAsId = true)
  @JsonDeserialize(converter = DomainObjectOptionalConverter.class)
  @Redactable(useMask = true, redactionMask = "identity--__REDACTED__")
  @Override
  public Optional<IdentitySdo> getCreatedByRef() {
    return Optional.ofNullable(createdByRef);
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @JsonPropertyDescription("The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
  @Redactable(useMask = true, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getCreated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCreated()
        : this.created;
  }

  /**
   * @return The value of the {@code lang} attribute
   */
  @JsonProperty("lang")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Identifies the language of the text content in this object using ISO 639-2 language codes.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getLang() {
    return Optional.ofNullable(lang);
  }

  /**
   * @return The value of the {@code externalReferences} attribute
   */
  @JsonProperty("external_references")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A list of external references which refers to non-STIX information.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<ExternalReferenceType> getExternalReferences() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExternalReferences()
        : this.externalReferences;
  }

  /**
   * @return The value of the {@code objectMarkingRefs} attribute
   */
  @JsonProperty("object_marking_refs")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
  @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
  @JsonIdentityReference(alwaysAsId = true)
  @JsonDeserialize(converter = MarkingDefinitionSetConverter.class)
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObjectMarkingRefs()
        : this.objectMarkingRefs;
  }

  /**
   * @return The value of the {@code granularMarkings} attribute
   */
  @JsonProperty("granular_markings")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The set of granular markings that apply to this object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getGranularMarkings()
        : this.granularMarkings;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The labels property specifies a set of classifications.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<String> getLabels() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLabels()
        : this.labels;
  }

  /**
   * @return The value of the {@code modified} attribute
   */
  @JsonProperty("modified")
  @JsonPropertyDescription("The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getModified() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getModified()
        : this.modified;
  }

  /**
   * @return The value of the {@code revoked} attribute
   */
  @JsonProperty("revoked")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The revoked property indicates whether the object has been revoked.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixBoolean getRevoked() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRevoked()
        : this.revoked;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InfrastructureSdo#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Infrastructure withName(String value) {
    if (Objects.equals(this.name, value)) return this;
    return validate(new Infrastructure(
        value,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link InfrastructureSdo#getDescription() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withDescription(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return validate(new Infrastructure(
        this.name,
        newValue,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link InfrastructureSdo#getDescription() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return validate(new Infrastructure(
        this.name,
        value,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getInfrastructureTypes() infrastructureTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withInfrastructureTypes(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        newValue,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getInfrastructureTypes() infrastructureTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of infrastructureTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withInfrastructureTypes(Iterable<String> elements) {
    if (this.infrastructureTypes == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        newValue,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getAliases() aliases}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withAliases(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        newValue,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getAliases() aliases}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of aliases elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withAliases(Iterable<String> elements) {
    if (this.aliases == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        newValue,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getKillChainPhases() killChainPhases}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withKillChainPhases(KillChainPhaseType... elements) {
    ImmutableSet<KillChainPhaseType> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        newValue,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getKillChainPhases() killChainPhases}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of killChainPhases elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withKillChainPhases(Iterable<? extends KillChainPhaseType> elements) {
    if (this.killChainPhases == elements) return this;
    ImmutableSet<KillChainPhaseType> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        newValue,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link InfrastructureSdo#getFirstSeen() firstSeen} attribute.
   * @param value The value for firstSeen
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withFirstSeen(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "firstSeen");
    if (this.firstSeen == newValue) return this;
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        newValue,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link InfrastructureSdo#getFirstSeen() firstSeen} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for firstSeen
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final Infrastructure withFirstSeen(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.firstSeen == value) return this;
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        value,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link InfrastructureSdo#getLastSeen() lastSeen} attribute.
   * @param value The value for lastSeen
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withLastSeen(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "lastSeen");
    if (this.lastSeen == newValue) return this;
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        newValue,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link InfrastructureSdo#getLastSeen() lastSeen} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for lastSeen
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final Infrastructure withLastSeen(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.lastSeen == value) return this;
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        value,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getRelationships() relationships}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withRelationships(RelationshipSro... elements) {
    ImmutableSet<RelationshipSro> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        newValue,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getRelationships() relationships}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of relationships elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withRelationships(Iterable<? extends RelationshipSro> elements) {
    if (this.relationships == elements) return this;
    ImmutableSet<RelationshipSro> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        newValue,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InfrastructureSdo#getHydrated() hydrated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hydrated
   * @return A modified copy of the {@code this} object
   */
  public final Infrastructure withHydrated(boolean value) {
    if (this.hydrated == value) return this;
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        value,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InfrastructureSdo#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Infrastructure withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        value,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InfrastructureSdo#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Infrastructure withId(String value) {
    if (Objects.equals(this.id, value)) return this;
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        value,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link InfrastructureSdo#getCreatedByRef() createdByRef} attribute.
   * @param value The value for createdByRef
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withCreatedByRef(IdentitySdo value) {
    @Nullable IdentitySdo newValue = Objects.requireNonNull(value, "createdByRef");
    if (this.createdByRef == newValue) return this;
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        newValue,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link InfrastructureSdo#getCreatedByRef() createdByRef} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for createdByRef
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final Infrastructure withCreatedByRef(Optional<? extends IdentitySdo> optional) {
    @Nullable IdentitySdo value = optional.orElse(null);
    if (this.createdByRef == value) return this;
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        value,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InfrastructureSdo#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final Infrastructure withCreated(StixInstant value) {
    if (this.created == value) return this;
    StixInstant newValue = Objects.requireNonNull(value, "created");
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        newValue,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link InfrastructureSdo#getLang() lang} attribute.
   * @param value The value for lang
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withLang(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "lang");
    if (Objects.equals(this.lang, newValue)) return this;
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        newValue,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link InfrastructureSdo#getLang() lang} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for lang
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withLang(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.lang, value)) return this;
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        value,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getExternalReferences() externalReferences}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withExternalReferences(ExternalReferenceType... elements) {
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getExternalReferences() externalReferences}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of externalReferences elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
    if (this.externalReferences == elements) return this;
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getObjectMarkingRefs() objectMarkingRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withObjectMarkingRefs(MarkingDefinitionDm... elements) {
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getObjectMarkingRefs() objectMarkingRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectMarkingRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
    if (this.objectMarkingRefs == elements) return this;
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getGranularMarkings() granularMarkings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withGranularMarkings(GranularMarkingDm... elements) {
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getGranularMarkings() granularMarkings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of granularMarkings elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
    if (this.granularMarkings == elements) return this;
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by replacing the {@link InfrastructureSdo#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        newValue,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withLabels(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        newValue,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link InfrastructureSdo#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final Infrastructure withLabels(Iterable<String> elements) {
    if (this.labels == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        newValue,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InfrastructureSdo#getModified() modified} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modified
   * @return A modified copy of the {@code this} object
   */
  public final Infrastructure withModified(StixInstant value) {
    if (this.modified == value) return this;
    StixInstant newValue = Objects.requireNonNull(value, "modified");
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        newValue,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InfrastructureSdo#getRevoked() revoked} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revoked
   * @return A modified copy of the {@code this} object
   */
  public final Infrastructure withRevoked(StixBoolean value) {
    if (this.revoked == value) return this;
    StixBoolean newValue = Objects.requireNonNull(value, "revoked");
    return validate(new Infrastructure(
        this.name,
        this.description,
        this.infrastructureTypes,
        this.aliases,
        this.killChainPhases,
        this.firstSeen,
        this.lastSeen,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code Infrastructure} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Infrastructure
        && equalTo((Infrastructure) another);
  }

  private boolean equalTo(Infrastructure another) {
    return Objects.equals(name, another.name)
        && Objects.equals(description, another.description)
        && infrastructureTypes.equals(another.infrastructureTypes)
        && aliases.equals(another.aliases)
        && killChainPhases.equals(another.killChainPhases)
        && Objects.equals(firstSeen, another.firstSeen)
        && Objects.equals(lastSeen, another.lastSeen)
        && relationships.equals(another.relationships)
        && hydrated == another.hydrated
        && Objects.equals(type, another.type)
        && Objects.equals(id, another.id)
        && Objects.equals(createdByRef, another.createdByRef)
        && created.equals(another.created)
        && Objects.equals(lang, another.lang)
        && externalReferences.equals(another.externalReferences)
        && objectMarkingRefs.equals(another.objectMarkingRefs)
        && granularMarkings.equals(another.granularMarkings)
        && customProperties.equals(another.customProperties)
        && labels.equals(another.labels)
        && modified.equals(another.modified)
        && revoked.equals(another.revoked);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}, {@code infrastructureTypes}, {@code aliases}, {@code killChainPhases}, {@code firstSeen}, {@code lastSeen}, {@code relationships}, {@code hydrated}, {@code type}, {@code id}, {@code createdByRef}, {@code created}, {@code lang}, {@code externalReferences}, {@code objectMarkingRefs}, {@code granularMarkings}, {@code customProperties}, {@code labels}, {@code modified}, {@code revoked}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + infrastructureTypes.hashCode();
    h += (h << 5) + aliases.hashCode();
    h += (h << 5) + killChainPhases.hashCode();
    h += (h << 5) + Objects.hashCode(firstSeen);
    h += (h << 5) + Objects.hashCode(lastSeen);
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + Booleans.hashCode(hydrated);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(createdByRef);
    h += (h << 5) + created.hashCode();
    h += (h << 5) + Objects.hashCode(lang);
    h += (h << 5) + externalReferences.hashCode();
    h += (h << 5) + objectMarkingRefs.hashCode();
    h += (h << 5) + granularMarkings.hashCode();
    h += (h << 5) + customProperties.hashCode();
    h += (h << 5) + labels.hashCode();
    h += (h << 5) + modified.hashCode();
    h += (h << 5) + revoked.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Infrastructure} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Infrastructure")
        .omitNullValues()
        .add("name", name)
        .add("description", description)
        .add("infrastructureTypes", infrastructureTypes)
        .add("aliases", aliases)
        .add("killChainPhases", killChainPhases)
        .add("firstSeen", firstSeen)
        .add("lastSeen", lastSeen)
        .add("relationships", relationships)
        .add("hydrated", hydrated)
        .add("type", type)
        .add("id", id)
        .add("createdByRef", createdByRef)
        .add("created", created)
        .add("lang", lang)
        .add("externalReferences", externalReferences)
        .add("objectMarkingRefs", objectMarkingRefs)
        .add("granularMarkings", granularMarkings)
        .add("customProperties", customProperties)
        .add("labels", labels)
        .add("modified", modified)
        .add("revoked", revoked)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long TO_JSON_STRING_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String toJsonString;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link InfrastructureSdo#toJsonString() toJsonString} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code toJsonString} attribute
   */
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String toJsonString() {
    if ((lazyInitBitmap & TO_JSON_STRING_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TO_JSON_STRING_LAZY_INIT_BIT) == 0) {
          this.toJsonString = Objects.requireNonNull(InfrastructureSdo.super.toJsonString(), "toJsonString");
          lazyInitBitmap |= TO_JSON_STRING_LAZY_INIT_BIT;
        }
      }
    }
    return toJsonString;
  }

  private static final long SPEC_VERSION_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient String specVersion;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link InfrastructureSdo#getSpecVersion() specVersion} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code specVersion} attribute
   */
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getSpecVersion() {
    if ((lazyInitBitmap & SPEC_VERSION_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SPEC_VERSION_LAZY_INIT_BIT) == 0) {
          this.specVersion = Objects.requireNonNull(InfrastructureSdo.super.getSpecVersion(), "specVersion");
          lazyInitBitmap |= SPEC_VERSION_LAZY_INIT_BIT;
        }
      }
    }
    return specVersion;
  }


  private static Infrastructure validate(Infrastructure instance) {
    instance.checkHydrationValidation();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link InfrastructureSdo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Infrastructure instance
   */
  public static Infrastructure copyOf(InfrastructureSdo instance) {
    if (instance instanceof Infrastructure) {
      return (Infrastructure) instance;
    }
    return Infrastructure.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link Infrastructure Infrastructure}.
   * @return A new Infrastructure builder
   */
  public static Infrastructure.Builder builder() {
    return new Infrastructure.Builder();
  }

  /**
   * Builds instances of type {@link Infrastructure Infrastructure}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InfrastructureSdo", generator = "Immutables")
  @NotThreadSafe
  @JsonTypeName("infrastructure")
  @JsonPropertyOrder({"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "name", "description", "infrastructure_types", "aliases", "kill_chain_phases", "first_seen", "last_seen"})
  public static final class Builder {
    private static final long OPT_BIT_ALIASES = 0x1L;
    private static final long OPT_BIT_KILL_CHAIN_PHASES = 0x2L;
    private static final long OPT_BIT_RELATIONSHIPS = 0x4L;
    private static final long OPT_BIT_HYDRATED = 0x8L;
    private static final long OPT_BIT_EXTERNAL_REFERENCES = 0x10L;
    private static final long OPT_BIT_OBJECT_MARKING_REFS = 0x20L;
    private static final long OPT_BIT_GRANULAR_MARKINGS = 0x40L;
    private static final long OPT_BIT_LABELS = 0x80L;
    private long optBits;

    private @Nullable String name;
    private @Nullable String description;
    private ImmutableSet.Builder<String> infrastructureTypes = ImmutableSet.builder();
    private ImmutableSet.Builder<String> aliases = ImmutableSet.builder();
    private ImmutableSet.Builder<KillChainPhaseType> killChainPhases = ImmutableSet.builder();
    private @Nullable StixInstant firstSeen;
    private @Nullable StixInstant lastSeen;
    private ImmutableSet.Builder<RelationshipSro> relationships = ImmutableSet.builder();
    private boolean hydrated;
    private @Nullable String type;
    private @Nullable String id;
    private @Nullable IdentitySdo createdByRef;
    private @Nullable StixInstant created;
    private @Nullable String lang;
    private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
    private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
    private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
    private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
    private @Nullable StixInstant modified;
    private @Nullable StixBoolean revoked;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleableObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleableObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixRevoked} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixRevoked instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixLabels} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixLabels instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.sdo.objects.InfrastructureSdo} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(InfrastructureSdo instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixModified} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixModified instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.sdo.DomainObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DomainObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BundleableObject) {
        BundleableObject instance = (BundleableObject) object;
        if ((bits & 0x8L) == 0) {
          String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x10L;
        }
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          hydrated(instance.getHydrated());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x4L;
        }
      }
      if (object instanceof StixCommonProperties) {
        StixCommonProperties instance = (StixCommonProperties) object;
        addAllExternalReferences(instance.getExternalReferences());
        if ((bits & 0x2L) == 0) {
          hydrated(instance.getHydrated());
          bits |= 0x2L;
        }
        created(instance.getCreated());
        if ((bits & 0x4L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x4L;
        }
        Optional<IdentitySdo> createdByRefOptional = instance.getCreatedByRef();
        if (createdByRefOptional.isPresent()) {
          createdByRef(createdByRefOptional);
        }
        if ((bits & 0x8L) == 0) {
          String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x10L;
        }
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        Optional<String> langOptional = instance.getLang();
        if (langOptional.isPresent()) {
          lang(langOptional);
        }
      }
      if (object instanceof StixRevoked) {
        StixRevoked instance = (StixRevoked) object;
        revoked(instance.getRevoked());
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof StixLabels) {
        StixLabels instance = (StixLabels) object;
        addAllLabels(instance.getLabels());
      }
      if (object instanceof InfrastructureSdo) {
        InfrastructureSdo instance = (InfrastructureSdo) object;
        addAllInfrastructureTypes(instance.getInfrastructureTypes());
        addAllAliases(instance.getAliases());
        addAllKillChainPhases(instance.getKillChainPhases());
        Optional<StixInstant> lastSeenOptional = instance.getLastSeen();
        if (lastSeenOptional.isPresent()) {
          lastSeen(lastSeenOptional);
        }
        Optional<StixInstant> firstSeenOptional = instance.getFirstSeen();
        if (firstSeenOptional.isPresent()) {
          firstSeen(firstSeenOptional);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        Optional<String> descriptionOptional = instance.getDescription();
        if (descriptionOptional.isPresent()) {
          description(descriptionOptional);
        }
      }
      if (object instanceof StixModified) {
        StixModified instance = (StixModified) object;
        modified(instance.getModified());
      }
      if (object instanceof DomainObject) {
        DomainObject instance = (DomainObject) object;
        addAllRelationships(instance.getRelationships());
      }
    }

    /**
     * Initializes the value for the {@link InfrastructureSdo#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    @JsonPropertyDescription("The name used to identify the Infrastructure.")
    public final Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the optional value {@link InfrastructureSdo#getDescription() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link InfrastructureSdo#getDescription() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A description that provides more details and context about the Infrastructure, potentially including its purpose and its key characteristics.")
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link InfrastructureSdo#getInfrastructureTypes() infrastructureTypes} set.
     * @param element A infrastructureTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInfrastructureType(@Nullable String element) {
      this.infrastructureTypes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getInfrastructureTypes() infrastructureTypes} set.
     * @param elements An array of infrastructureTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInfrastructureTypes(String... elements) {
      this.infrastructureTypes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InfrastructureSdo#getInfrastructureTypes() infrastructureTypes} set.
     * @param elements An iterable of infrastructureTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("infrastructure_types")
    @JsonPropertyDescription("The type of infrastructure being described. Open Vocabulary: infrastructure-type-ov")
    public final Builder infrastructureTypes(Iterable<String> elements) {
      this.infrastructureTypes = ImmutableSet.builder();
      return addAllInfrastructureTypes(elements);
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getInfrastructureTypes() infrastructureTypes} set.
     * @param elements An iterable of infrastructureTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInfrastructureTypes(Iterable<String> elements) {
      this.infrastructureTypes.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link InfrastructureSdo#getAliases() aliases} set.
     * @param element A aliases element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAliase(@Nullable String element) {
      this.aliases.add(element);
      optBits |= OPT_BIT_ALIASES;
      return this;
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getAliases() aliases} set.
     * @param elements An array of aliases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAliases(String... elements) {
      this.aliases.add(elements);
      optBits |= OPT_BIT_ALIASES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InfrastructureSdo#getAliases() aliases} set.
     * @param elements An iterable of aliases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("aliases")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Alternative names used to identify this Infrastructure.")
    public final Builder aliases(Iterable<String> elements) {
      this.aliases = ImmutableSet.builder();
      return addAllAliases(elements);
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getAliases() aliases} set.
     * @param elements An iterable of aliases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAliases(Iterable<String> elements) {
      this.aliases.addAll(elements);
      optBits |= OPT_BIT_ALIASES;
      return this;
    }

    /**
     * Adds one element to {@link InfrastructureSdo#getKillChainPhases() killChainPhases} set.
     * @param element A killChainPhases element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addKillChainPhase(@Nullable KillChainPhaseType element) {
      this.killChainPhases.add(element);
      optBits |= OPT_BIT_KILL_CHAIN_PHASES;
      return this;
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getKillChainPhases() killChainPhases} set.
     * @param elements An array of killChainPhases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addKillChainPhases(KillChainPhaseType... elements) {
      this.killChainPhases.add(elements);
      optBits |= OPT_BIT_KILL_CHAIN_PHASES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InfrastructureSdo#getKillChainPhases() killChainPhases} set.
     * @param elements An iterable of killChainPhases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("kill_chain_phases")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The list of kill chain phases for which this Infrastructure is used.")
    public final Builder killChainPhases(Iterable<? extends KillChainPhaseType> elements) {
      this.killChainPhases = ImmutableSet.builder();
      return addAllKillChainPhases(elements);
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getKillChainPhases() killChainPhases} set.
     * @param elements An iterable of killChainPhases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllKillChainPhases(Iterable<? extends KillChainPhaseType> elements) {
      this.killChainPhases.addAll(elements);
      optBits |= OPT_BIT_KILL_CHAIN_PHASES;
      return this;
    }

    /**
     * Initializes the optional value {@link InfrastructureSdo#getFirstSeen() firstSeen} to firstSeen.
     * @param firstSeen The value for firstSeen
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder firstSeen(StixInstant firstSeen) {
      this.firstSeen = Objects.requireNonNull(firstSeen, "firstSeen");
      return this;
    }

    /**
     * Initializes the optional value {@link InfrastructureSdo#getFirstSeen() firstSeen} to firstSeen.
     * @param firstSeen The value for firstSeen
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("first_seen")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The time that this Infrastructure was first seen performing malicious activities.")
    public final Builder firstSeen(Optional<? extends StixInstant> firstSeen) {
      this.firstSeen = firstSeen.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link InfrastructureSdo#getLastSeen() lastSeen} to lastSeen.
     * @param lastSeen The value for lastSeen
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder lastSeen(StixInstant lastSeen) {
      this.lastSeen = Objects.requireNonNull(lastSeen, "lastSeen");
      return this;
    }

    /**
     * Initializes the optional value {@link InfrastructureSdo#getLastSeen() lastSeen} to lastSeen.
     * @param lastSeen The value for lastSeen
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("last_seen")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The time that this Infrastructure was last seen performing malicious activities.")
    public final Builder lastSeen(Optional<? extends StixInstant> lastSeen) {
      this.lastSeen = lastSeen.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link InfrastructureSdo#getRelationships() relationships} set.
     * @param element A relationships element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRelationship(@Nullable RelationshipSro element) {
      this.relationships.add(element);
      optBits |= OPT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getRelationships() relationships} set.
     * @param elements An array of relationships elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRelationships(RelationshipSro... elements) {
      this.relationships.add(elements);
      optBits |= OPT_BIT_RELATIONSHIPS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InfrastructureSdo#getRelationships() relationships} set.
     * @param elements An iterable of relationships elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("relationships")
    @JsonIgnore
    public final Builder relationships(Iterable<? extends RelationshipSro> elements) {
      this.relationships = ImmutableSet.builder();
      return addAllRelationships(elements);
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getRelationships() relationships} set.
     * @param elements An iterable of relationships elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRelationships(Iterable<? extends RelationshipSro> elements) {
      this.relationships.addAll(elements);
      optBits |= OPT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link InfrastructureSdo#getHydrated() hydrated} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link InfrastructureSdo#getHydrated() hydrated}.</em>
     * @param hydrated The value for hydrated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    public final Builder hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      optBits |= OPT_BIT_HYDRATED;
      return this;
    }

    /**
     * Initializes the value for the {@link InfrastructureSdo#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    @JsonPropertyDescription("The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link InfrastructureSdo#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    public final Builder id(String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the optional value {@link InfrastructureSdo#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder createdByRef(IdentitySdo createdByRef) {
      this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
      return this;
    }

    /**
     * Initializes the optional value {@link InfrastructureSdo#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created_by_ref")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
    @JsonIdentityReference(alwaysAsId = true)
    @JsonDeserialize(converter = DomainObjectOptionalConverter.class)
    public final Builder createdByRef(Optional<? extends IdentitySdo> createdByRef) {
      this.createdByRef = createdByRef.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link InfrastructureSdo#getCreated() created} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link InfrastructureSdo#getCreated() created}.</em>
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    @JsonPropertyDescription("The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
    public final Builder created(StixInstant created) {
      this.created = Objects.requireNonNull(created, "created");
      return this;
    }

    /**
     * Initializes the optional value {@link InfrastructureSdo#getLang() lang} to lang.
     * @param lang The value for lang
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder lang(String lang) {
      this.lang = Objects.requireNonNull(lang, "lang");
      return this;
    }

    /**
     * Initializes the optional value {@link InfrastructureSdo#getLang() lang} to lang.
     * @param lang The value for lang
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lang")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Identifies the language of the text content in this object using ISO 639-2 language codes.")
    public final Builder lang(Optional<String> lang) {
      this.lang = lang.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link InfrastructureSdo#getExternalReferences() externalReferences} set.
     * @param element A externalReferences element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
      this.externalReferences.add(element);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getExternalReferences() externalReferences} set.
     * @param elements An array of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReferences(ExternalReferenceType... elements) {
      this.externalReferences.add(elements);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InfrastructureSdo#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("external_references")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A list of external references which refers to non-STIX information.")
    public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences = ImmutableSet.builder();
      return addAllExternalReferences(elements);
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences.addAll(elements);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }

    /**
     * Adds one element to {@link InfrastructureSdo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param element A objectMarkingRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
      this.objectMarkingRefs.add(element);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An array of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRefs(MarkingDefinitionDm... elements) {
      this.objectMarkingRefs.add(elements);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InfrastructureSdo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("object_marking_refs")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
    @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
    @JsonIdentityReference(alwaysAsId = true)
    @JsonDeserialize(converter = MarkingDefinitionSetConverter.class)
    public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs = ImmutableSet.builder();
      return addAllObjectMarkingRefs(elements);
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs.addAll(elements);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }

    /**
     * Adds one element to {@link InfrastructureSdo#getGranularMarkings() granularMarkings} set.
     * @param element A granularMarkings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
      this.granularMarkings.add(element);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getGranularMarkings() granularMarkings} set.
     * @param elements An array of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarkings(GranularMarkingDm... elements) {
      this.granularMarkings.add(elements);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InfrastructureSdo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("granular_markings")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The set of granular markings that apply to this object.")
    public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings = ImmutableSet.builder();
      return addAllGranularMarkings(elements);
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings.addAll(elements);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }

    /**
     * Put one entry to the {@link InfrastructureSdo#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link InfrastructureSdo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link InfrastructureSdo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link InfrastructureSdo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link InfrastructureSdo#getLabels() labels} set.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabel(@Nullable String element) {
      this.labels.add(element);
      optBits |= OPT_BIT_LABELS;
      return this;
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getLabels() labels} set.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(String... elements) {
      this.labels.add(elements);
      optBits |= OPT_BIT_LABELS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link InfrastructureSdo#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labels")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The labels property specifies a set of classifications.")
    public final Builder labels(Iterable<String> elements) {
      this.labels = ImmutableSet.builder();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link InfrastructureSdo#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<String> elements) {
      this.labels.addAll(elements);
      optBits |= OPT_BIT_LABELS;
      return this;
    }

    /**
     * Initializes the value for the {@link InfrastructureSdo#getModified() modified} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link InfrastructureSdo#getModified() modified}.</em>
     * @param modified The value for modified 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("modified")
    @JsonPropertyDescription("The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
    public final Builder modified(StixInstant modified) {
      this.modified = Objects.requireNonNull(modified, "modified");
      return this;
    }

    /**
     * Initializes the value for the {@link InfrastructureSdo#getRevoked() revoked} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link InfrastructureSdo#getRevoked() revoked}.</em>
     * @param revoked The value for revoked 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("revoked")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The revoked property indicates whether the object has been revoked.")
    public final Builder revoked(StixBoolean revoked) {
      this.revoked = Objects.requireNonNull(revoked, "revoked");
      return this;
    }

    /**
     * Builds a new {@link Infrastructure Infrastructure}.
     * @return An immutable instance of Infrastructure
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Infrastructure build() {
      return Infrastructure.validate(new Infrastructure(this));
    }

    private boolean aliasesIsSet() {
      return (optBits & OPT_BIT_ALIASES) != 0;
    }

    private boolean killChainPhasesIsSet() {
      return (optBits & OPT_BIT_KILL_CHAIN_PHASES) != 0;
    }

    private boolean relationshipsIsSet() {
      return (optBits & OPT_BIT_RELATIONSHIPS) != 0;
    }

    private boolean hydratedIsSet() {
      return (optBits & OPT_BIT_HYDRATED) != 0;
    }

    private boolean externalReferencesIsSet() {
      return (optBits & OPT_BIT_EXTERNAL_REFERENCES) != 0;
    }

    private boolean objectMarkingRefsIsSet() {
      return (optBits & OPT_BIT_OBJECT_MARKING_REFS) != 0;
    }

    private boolean granularMarkingsIsSet() {
      return (optBits & OPT_BIT_GRANULAR_MARKINGS) != 0;
    }

    private boolean labelsIsSet() {
      return (optBits & OPT_BIT_LABELS) != 0;
    }
  }
}
