package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixBoolean;
import security.whisper.javastix.common.StixCommonProperties;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.common.StixLabels;
import security.whisper.javastix.common.StixModified;
import security.whisper.javastix.common.StixRevoked;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectOptionalConverter;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.types.ExternalReferenceType;
import security.whisper.javastix.sro.objects.RelationshipSro;

/**
 * location
 * <p>
 * A Location represents a geographic location.
 * This object is part of STIX 2.1 specification.
 */
@Generated(from = "LocationSdo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("location")
@Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
public final class Location implements LocationSdo {
  private final @Nullable String name;
  private final @Nullable String description;
  private final @Nullable Double latitude;
  private final @Nullable Double longitude;
  private final @Nullable Double precision;
  private final @Nullable String region;
  private final @Nullable String country;
  private final @Nullable String administrativeArea;
  private final @Nullable String city;
  private final @Nullable String streetAddress;
  private final @Nullable String postalCode;
  private final ImmutableSet<RelationshipSro> relationships;
  private final boolean hydrated;
  private final String type;
  private final String id;
  private final @Nullable IdentitySdo createdByRef;
  private final StixInstant created;
  private final @Nullable String lang;
  private final ImmutableSet<ExternalReferenceType> externalReferences;
  private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
  private final ImmutableSet<GranularMarkingDm> granularMarkings;
  private final ImmutableMap<String, Object> customProperties;
  private final ImmutableSet<String> labels;
  private final StixInstant modified;
  private final StixBoolean revoked;

  private Location(Location.Builder builder) {
    this.name = builder.name;
    this.description = builder.description;
    this.latitude = builder.latitude;
    this.longitude = builder.longitude;
    this.precision = builder.precision;
    this.region = builder.region;
    this.country = builder.country;
    this.administrativeArea = builder.administrativeArea;
    this.city = builder.city;
    this.streetAddress = builder.streetAddress;
    this.postalCode = builder.postalCode;
    this.type = builder.type;
    this.id = builder.id;
    this.createdByRef = builder.createdByRef;
    this.lang = builder.lang;
    this.customProperties = builder.customProperties.build();
    if (builder.relationshipsIsSet()) {
      initShim.relationships(builder.relationships.build());
    }
    if (builder.hydratedIsSet()) {
      initShim.hydrated(builder.hydrated);
    }
    if (builder.created != null) {
      initShim.created(builder.created);
    }
    if (builder.externalReferencesIsSet()) {
      initShim.externalReferences(builder.externalReferences.build());
    }
    if (builder.objectMarkingRefsIsSet()) {
      initShim.objectMarkingRefs(builder.objectMarkingRefs.build());
    }
    if (builder.granularMarkingsIsSet()) {
      initShim.granularMarkings(builder.granularMarkings.build());
    }
    if (builder.labelsIsSet()) {
      initShim.labels(builder.labels.build());
    }
    if (builder.modified != null) {
      initShim.modified(builder.modified);
    }
    if (builder.revoked != null) {
      initShim.revoked(builder.revoked);
    }
    this.relationships = initShim.getRelationships();
    this.hydrated = initShim.getHydrated();
    this.created = initShim.getCreated();
    this.externalReferences = initShim.getExternalReferences();
    this.objectMarkingRefs = initShim.getObjectMarkingRefs();
    this.granularMarkings = initShim.getGranularMarkings();
    this.labels = initShim.getLabels();
    this.modified = initShim.getModified();
    this.revoked = initShim.getRevoked();
    this.initShim = null;
  }

  private Location(
      @Nullable String name,
      @Nullable String description,
      @Nullable Double latitude,
      @Nullable Double longitude,
      @Nullable Double precision,
      @Nullable String region,
      @Nullable String country,
      @Nullable String administrativeArea,
      @Nullable String city,
      @Nullable String streetAddress,
      @Nullable String postalCode,
      ImmutableSet<RelationshipSro> relationships,
      boolean hydrated,
      String type,
      String id,
      @Nullable IdentitySdo createdByRef,
      StixInstant created,
      @Nullable String lang,
      ImmutableSet<ExternalReferenceType> externalReferences,
      ImmutableSet<MarkingDefinitionDm> objectMarkingRefs,
      ImmutableSet<GranularMarkingDm> granularMarkings,
      ImmutableMap<String, Object> customProperties,
      ImmutableSet<String> labels,
      StixInstant modified,
      StixBoolean revoked) {
    this.name = name;
    this.description = description;
    this.latitude = latitude;
    this.longitude = longitude;
    this.precision = precision;
    this.region = region;
    this.country = country;
    this.administrativeArea = administrativeArea;
    this.city = city;
    this.streetAddress = streetAddress;
    this.postalCode = postalCode;
    this.relationships = relationships;
    this.hydrated = hydrated;
    this.type = type;
    this.id = id;
    this.createdByRef = createdByRef;
    this.created = created;
    this.lang = lang;
    this.externalReferences = externalReferences;
    this.objectMarkingRefs = objectMarkingRefs;
    this.granularMarkings = granularMarkings;
    this.customProperties = customProperties;
    this.labels = labels;
    this.modified = modified;
    this.revoked = revoked;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "LocationSdo", generator = "Immutables")
  private final class InitShim {
    private byte relationshipsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<RelationshipSro> relationships;

    ImmutableSet<RelationshipSro> getRelationships() {
      if (relationshipsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (relationshipsBuildStage == STAGE_UNINITIALIZED) {
        relationshipsBuildStage = STAGE_INITIALIZING;
        this.relationships = ImmutableSet.copyOf(getRelationshipsInitialize());
        relationshipsBuildStage = STAGE_INITIALIZED;
      }
      return this.relationships;
    }

    void relationships(ImmutableSet<RelationshipSro> relationships) {
      this.relationships = relationships;
      relationshipsBuildStage = STAGE_INITIALIZED;
    }

    private byte hydratedBuildStage = STAGE_UNINITIALIZED;
    private boolean hydrated;

    boolean getHydrated() {
      if (hydratedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hydratedBuildStage == STAGE_UNINITIALIZED) {
        hydratedBuildStage = STAGE_INITIALIZING;
        this.hydrated = getHydratedInitialize();
        hydratedBuildStage = STAGE_INITIALIZED;
      }
      return this.hydrated;
    }

    void hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      hydratedBuildStage = STAGE_INITIALIZED;
    }

    private byte createdBuildStage = STAGE_UNINITIALIZED;
    private StixInstant created;

    StixInstant getCreated() {
      if (createdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (createdBuildStage == STAGE_UNINITIALIZED) {
        createdBuildStage = STAGE_INITIALIZING;
        this.created = Objects.requireNonNull(getCreatedInitialize(), "created");
        createdBuildStage = STAGE_INITIALIZED;
      }
      return this.created;
    }

    void created(StixInstant created) {
      this.created = created;
      createdBuildStage = STAGE_INITIALIZED;
    }

    private byte externalReferencesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<ExternalReferenceType> externalReferences;

    ImmutableSet<ExternalReferenceType> getExternalReferences() {
      if (externalReferencesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (externalReferencesBuildStage == STAGE_UNINITIALIZED) {
        externalReferencesBuildStage = STAGE_INITIALIZING;
        this.externalReferences = ImmutableSet.copyOf(getExternalReferencesInitialize());
        externalReferencesBuildStage = STAGE_INITIALIZED;
      }
      return this.externalReferences;
    }

    void externalReferences(ImmutableSet<ExternalReferenceType> externalReferences) {
      this.externalReferences = externalReferences;
      externalReferencesBuildStage = STAGE_INITIALIZED;
    }

    private byte objectMarkingRefsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;

    ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
      if (objectMarkingRefsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectMarkingRefsBuildStage == STAGE_UNINITIALIZED) {
        objectMarkingRefsBuildStage = STAGE_INITIALIZING;
        this.objectMarkingRefs = ImmutableSet.copyOf(getObjectMarkingRefsInitialize());
        objectMarkingRefsBuildStage = STAGE_INITIALIZED;
      }
      return this.objectMarkingRefs;
    }

    void objectMarkingRefs(ImmutableSet<MarkingDefinitionDm> objectMarkingRefs) {
      this.objectMarkingRefs = objectMarkingRefs;
      objectMarkingRefsBuildStage = STAGE_INITIALIZED;
    }

    private byte granularMarkingsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<GranularMarkingDm> granularMarkings;

    ImmutableSet<GranularMarkingDm> getGranularMarkings() {
      if (granularMarkingsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (granularMarkingsBuildStage == STAGE_UNINITIALIZED) {
        granularMarkingsBuildStage = STAGE_INITIALIZING;
        this.granularMarkings = ImmutableSet.copyOf(getGranularMarkingsInitialize());
        granularMarkingsBuildStage = STAGE_INITIALIZED;
      }
      return this.granularMarkings;
    }

    void granularMarkings(ImmutableSet<GranularMarkingDm> granularMarkings) {
      this.granularMarkings = granularMarkings;
      granularMarkingsBuildStage = STAGE_INITIALIZED;
    }

    private byte labelsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<String> labels;

    ImmutableSet<String> getLabels() {
      if (labelsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (labelsBuildStage == STAGE_UNINITIALIZED) {
        labelsBuildStage = STAGE_INITIALIZING;
        this.labels = ImmutableSet.copyOf(getLabelsInitialize());
        labelsBuildStage = STAGE_INITIALIZED;
      }
      return this.labels;
    }

    void labels(ImmutableSet<String> labels) {
      this.labels = labels;
      labelsBuildStage = STAGE_INITIALIZED;
    }

    private byte modifiedBuildStage = STAGE_UNINITIALIZED;
    private StixInstant modified;

    StixInstant getModified() {
      if (modifiedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (modifiedBuildStage == STAGE_UNINITIALIZED) {
        modifiedBuildStage = STAGE_INITIALIZING;
        this.modified = Objects.requireNonNull(getModifiedInitialize(), "modified");
        modifiedBuildStage = STAGE_INITIALIZED;
      }
      return this.modified;
    }

    void modified(StixInstant modified) {
      this.modified = modified;
      modifiedBuildStage = STAGE_INITIALIZED;
    }

    private byte revokedBuildStage = STAGE_UNINITIALIZED;
    private StixBoolean revoked;

    StixBoolean getRevoked() {
      if (revokedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (revokedBuildStage == STAGE_UNINITIALIZED) {
        revokedBuildStage = STAGE_INITIALIZING;
        this.revoked = Objects.requireNonNull(getRevokedInitialize(), "revoked");
        revokedBuildStage = STAGE_INITIALIZED;
      }
      return this.revoked;
    }

    void revoked(StixBoolean revoked) {
      this.revoked = revoked;
      revokedBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (relationshipsBuildStage == STAGE_INITIALIZING) attributes.add("relationships");
      if (hydratedBuildStage == STAGE_INITIALIZING) attributes.add("hydrated");
      if (createdBuildStage == STAGE_INITIALIZING) attributes.add("created");
      if (externalReferencesBuildStage == STAGE_INITIALIZING) attributes.add("externalReferences");
      if (objectMarkingRefsBuildStage == STAGE_INITIALIZING) attributes.add("objectMarkingRefs");
      if (granularMarkingsBuildStage == STAGE_INITIALIZING) attributes.add("granularMarkings");
      if (labelsBuildStage == STAGE_INITIALIZING) attributes.add("labels");
      if (modifiedBuildStage == STAGE_INITIALIZING) attributes.add("modified");
      if (revokedBuildStage == STAGE_INITIALIZING) attributes.add("revoked");
      return "Cannot build Location, attribute initializers form cycle " + attributes;
    }
  }

  private Set<RelationshipSro> getRelationshipsInitialize() {
    return LocationSdo.super.getRelationships();
  }

  private boolean getHydratedInitialize() {
    return LocationSdo.super.getHydrated();
  }

  private StixInstant getCreatedInitialize() {
    return LocationSdo.super.getCreated();
  }

  private Set<ExternalReferenceType> getExternalReferencesInitialize() {
    return LocationSdo.super.getExternalReferences();
  }

  private Set<MarkingDefinitionDm> getObjectMarkingRefsInitialize() {
    return LocationSdo.super.getObjectMarkingRefs();
  }

  private Set<GranularMarkingDm> getGranularMarkingsInitialize() {
    return LocationSdo.super.getGranularMarkings();
  }

  private Set<String> getLabelsInitialize() {
    return LocationSdo.super.getLabels();
  }

  private StixInstant getModifiedInitialize() {
    return LocationSdo.super.getModified();
  }

  private StixBoolean getRevokedInitialize() {
    return LocationSdo.super.getRevoked();
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A name used to identify the Location.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getName() {
    return Optional.ofNullable(name);
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A textual description of the Location.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getDescription() {
    return Optional.ofNullable(description);
  }

  /**
   * @return The value of the {@code latitude} attribute
   */
  @JsonProperty("latitude")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The latitude of the Location in decimal degrees.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<Double> getLatitude() {
    return Optional.ofNullable(latitude);
  }

  /**
   * @return The value of the {@code longitude} attribute
   */
  @JsonProperty("longitude")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The longitude of the Location in decimal degrees.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<Double> getLongitude() {
    return Optional.ofNullable(longitude);
  }

  /**
   * @return The value of the {@code precision} attribute
   */
  @JsonProperty("precision")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Defines the precision of the coordinates specified by the latitude and longitude properties in meters.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<Double> getPrecision() {
    return Optional.ofNullable(precision);
  }

  /**
   * @return The value of the {@code region} attribute
   */
  @JsonProperty("region")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The region that this Location describes. Open Vocabulary: region-ov")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getRegion() {
    return Optional.ofNullable(region);
  }

  /**
   * @return The value of the {@code country} attribute
   */
  @JsonProperty("country")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The country that this Location describes (ISO 3166-1 ALPHA-2 Code).")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getCountry() {
    return Optional.ofNullable(country);
  }

  /**
   * @return The value of the {@code administrativeArea} attribute
   */
  @JsonProperty("administrative_area")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The state, province, or other sub-national administrative area that this Location describes.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getAdministrativeArea() {
    return Optional.ofNullable(administrativeArea);
  }

  /**
   * @return The value of the {@code city} attribute
   */
  @JsonProperty("city")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The city that this Location describes.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getCity() {
    return Optional.ofNullable(city);
  }

  /**
   * @return The value of the {@code streetAddress} attribute
   */
  @JsonProperty("street_address")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The street address that this Location describes.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getStreetAddress() {
    return Optional.ofNullable(streetAddress);
  }

  /**
   * @return The value of the {@code postalCode} attribute
   */
  @JsonProperty("postal_code")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The postal code for this Location.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getPostalCode() {
    return Optional.ofNullable(postalCode);
  }

  /**
   * This is used with the SROs.  The SRO interface enforces what relationships can be created.  The Relationships can then be stored in the Domain object if they choose.
   * Otherwise you would typically add these Relationship SROs that are specific to SDOs, can be grabbed during bundle creation.
   * @return Set of Relationship SROs
   */
  @JsonProperty("relationships")
  @JsonIgnore
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<RelationshipSro> getRelationships() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRelationships()
        : this.relationships;
  }

  /**
   * Dictates if the object is hydrated.
   * Hydration is defined as if the Object has only a "ID" or has been properly
   * hydrated with the expected required fields
   * @return boolean
   */
  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public boolean getHydrated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHydrated()
        : this.hydrated;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @JsonPropertyDescription("The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code createdByRef} attribute
   */
  @JsonProperty("created_by_ref")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
  @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
  @JsonIdentityReference(alwaysAsId = true)
  @JsonDeserialize(converter = DomainObjectOptionalConverter.class)
  @Redactable(useMask = true, redactionMask = "identity--__REDACTED__")
  @Override
  public Optional<IdentitySdo> getCreatedByRef() {
    return Optional.ofNullable(createdByRef);
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @JsonPropertyDescription("The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
  @Redactable(useMask = true, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getCreated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCreated()
        : this.created;
  }

  /**
   * @return The value of the {@code lang} attribute
   */
  @JsonProperty("lang")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Identifies the language of the text content in this object using ISO 639-2 language codes.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getLang() {
    return Optional.ofNullable(lang);
  }

  /**
   * @return The value of the {@code externalReferences} attribute
   */
  @JsonProperty("external_references")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A list of external references which refers to non-STIX information.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<ExternalReferenceType> getExternalReferences() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExternalReferences()
        : this.externalReferences;
  }

  /**
   * @return The value of the {@code objectMarkingRefs} attribute
   */
  @JsonProperty("object_marking_refs")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
  @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
  @JsonIdentityReference(alwaysAsId = true)
  @JsonDeserialize(converter = MarkingDefinitionSetConverter.class)
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObjectMarkingRefs()
        : this.objectMarkingRefs;
  }

  /**
   * @return The value of the {@code granularMarkings} attribute
   */
  @JsonProperty("granular_markings")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The set of granular markings that apply to this object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getGranularMarkings()
        : this.granularMarkings;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The labels property specifies a set of classifications.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<String> getLabels() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLabels()
        : this.labels;
  }

  /**
   * @return The value of the {@code modified} attribute
   */
  @JsonProperty("modified")
  @JsonPropertyDescription("The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getModified() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getModified()
        : this.modified;
  }

  /**
   * @return The value of the {@code revoked} attribute
   */
  @JsonProperty("revoked")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The revoked property indicates whether the object has been revoked.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixBoolean getRevoked() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRevoked()
        : this.revoked;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getName() name} attribute.
   * @param value The value for name
   * @return A modified copy of {@code this} object
   */
  public final Location withName(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "name");
    if (Objects.equals(this.name, newValue)) return this;
    return validate(new Location(
        newValue,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getName() name} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final Location withName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.name, value)) return this;
    return validate(new Location(
        value,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getDescription() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final Location withDescription(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return validate(new Location(
        this.name,
        newValue,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getDescription() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final Location withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return validate(new Location(
        this.name,
        value,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getLatitude() latitude} attribute.
   * @param value The value for latitude
   * @return A modified copy of {@code this} object
   */
  public final Location withLatitude(double value) {
    @Nullable Double newValue = value;
    if (Objects.equals(this.latitude, newValue)) return this;
    return validate(new Location(
        this.name,
        this.description,
        newValue,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getLatitude() latitude} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for latitude
   * @return A modified copy of {@code this} object
   */
  public final Location withLatitude(Optional<Double> optional) {
    @Nullable Double value = optional.orElse(null);
    if (Objects.equals(this.latitude, value)) return this;
    return validate(new Location(
        this.name,
        this.description,
        value,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getLongitude() longitude} attribute.
   * @param value The value for longitude
   * @return A modified copy of {@code this} object
   */
  public final Location withLongitude(double value) {
    @Nullable Double newValue = value;
    if (Objects.equals(this.longitude, newValue)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        newValue,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getLongitude() longitude} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for longitude
   * @return A modified copy of {@code this} object
   */
  public final Location withLongitude(Optional<Double> optional) {
    @Nullable Double value = optional.orElse(null);
    if (Objects.equals(this.longitude, value)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        value,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getPrecision() precision} attribute.
   * @param value The value for precision
   * @return A modified copy of {@code this} object
   */
  public final Location withPrecision(double value) {
    @Nullable Double newValue = value;
    if (Objects.equals(this.precision, newValue)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        newValue,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getPrecision() precision} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for precision
   * @return A modified copy of {@code this} object
   */
  public final Location withPrecision(Optional<Double> optional) {
    @Nullable Double value = optional.orElse(null);
    if (Objects.equals(this.precision, value)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        value,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getRegion() region} attribute.
   * @param value The value for region
   * @return A modified copy of {@code this} object
   */
  public final Location withRegion(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "region");
    if (Objects.equals(this.region, newValue)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        newValue,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getRegion() region} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for region
   * @return A modified copy of {@code this} object
   */
  public final Location withRegion(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.region, value)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        value,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getCountry() country} attribute.
   * @param value The value for country
   * @return A modified copy of {@code this} object
   */
  public final Location withCountry(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "country");
    if (Objects.equals(this.country, newValue)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        newValue,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getCountry() country} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for country
   * @return A modified copy of {@code this} object
   */
  public final Location withCountry(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.country, value)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        value,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getAdministrativeArea() administrativeArea} attribute.
   * @param value The value for administrativeArea
   * @return A modified copy of {@code this} object
   */
  public final Location withAdministrativeArea(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "administrativeArea");
    if (Objects.equals(this.administrativeArea, newValue)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        newValue,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getAdministrativeArea() administrativeArea} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for administrativeArea
   * @return A modified copy of {@code this} object
   */
  public final Location withAdministrativeArea(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.administrativeArea, value)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        value,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getCity() city} attribute.
   * @param value The value for city
   * @return A modified copy of {@code this} object
   */
  public final Location withCity(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "city");
    if (Objects.equals(this.city, newValue)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        newValue,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getCity() city} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for city
   * @return A modified copy of {@code this} object
   */
  public final Location withCity(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.city, value)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        value,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getStreetAddress() streetAddress} attribute.
   * @param value The value for streetAddress
   * @return A modified copy of {@code this} object
   */
  public final Location withStreetAddress(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "streetAddress");
    if (Objects.equals(this.streetAddress, newValue)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        newValue,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getStreetAddress() streetAddress} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for streetAddress
   * @return A modified copy of {@code this} object
   */
  public final Location withStreetAddress(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.streetAddress, value)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        value,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getPostalCode() postalCode} attribute.
   * @param value The value for postalCode
   * @return A modified copy of {@code this} object
   */
  public final Location withPostalCode(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "postalCode");
    if (Objects.equals(this.postalCode, newValue)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        newValue,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getPostalCode() postalCode} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for postalCode
   * @return A modified copy of {@code this} object
   */
  public final Location withPostalCode(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.postalCode, value)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        value,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LocationSdo#getRelationships() relationships}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Location withRelationships(RelationshipSro... elements) {
    ImmutableSet<RelationshipSro> newValue = ImmutableSet.copyOf(elements);
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        newValue,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LocationSdo#getRelationships() relationships}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of relationships elements to set
   * @return A modified copy of {@code this} object
   */
  public final Location withRelationships(Iterable<? extends RelationshipSro> elements) {
    if (this.relationships == elements) return this;
    ImmutableSet<RelationshipSro> newValue = ImmutableSet.copyOf(elements);
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        newValue,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LocationSdo#getHydrated() hydrated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hydrated
   * @return A modified copy of the {@code this} object
   */
  public final Location withHydrated(boolean value) {
    if (this.hydrated == value) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        value,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LocationSdo#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Location withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        value,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LocationSdo#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final Location withId(String value) {
    if (Objects.equals(this.id, value)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        value,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getCreatedByRef() createdByRef} attribute.
   * @param value The value for createdByRef
   * @return A modified copy of {@code this} object
   */
  public final Location withCreatedByRef(IdentitySdo value) {
    @Nullable IdentitySdo newValue = Objects.requireNonNull(value, "createdByRef");
    if (this.createdByRef == newValue) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        newValue,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getCreatedByRef() createdByRef} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for createdByRef
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final Location withCreatedByRef(Optional<? extends IdentitySdo> optional) {
    @Nullable IdentitySdo value = optional.orElse(null);
    if (this.createdByRef == value) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        value,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LocationSdo#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final Location withCreated(StixInstant value) {
    if (this.created == value) return this;
    StixInstant newValue = Objects.requireNonNull(value, "created");
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        newValue,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LocationSdo#getLang() lang} attribute.
   * @param value The value for lang
   * @return A modified copy of {@code this} object
   */
  public final Location withLang(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "lang");
    if (Objects.equals(this.lang, newValue)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        newValue,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LocationSdo#getLang() lang} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for lang
   * @return A modified copy of {@code this} object
   */
  public final Location withLang(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.lang, value)) return this;
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        value,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LocationSdo#getExternalReferences() externalReferences}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Location withExternalReferences(ExternalReferenceType... elements) {
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LocationSdo#getExternalReferences() externalReferences}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of externalReferences elements to set
   * @return A modified copy of {@code this} object
   */
  public final Location withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
    if (this.externalReferences == elements) return this;
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LocationSdo#getObjectMarkingRefs() objectMarkingRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Location withObjectMarkingRefs(MarkingDefinitionDm... elements) {
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LocationSdo#getObjectMarkingRefs() objectMarkingRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectMarkingRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final Location withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
    if (this.objectMarkingRefs == elements) return this;
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LocationSdo#getGranularMarkings() granularMarkings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Location withGranularMarkings(GranularMarkingDm... elements) {
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LocationSdo#getGranularMarkings() granularMarkings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of granularMarkings elements to set
   * @return A modified copy of {@code this} object
   */
  public final Location withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
    if (this.granularMarkings == elements) return this;
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by replacing the {@link LocationSdo#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final Location withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        newValue,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LocationSdo#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Location withLabels(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        newValue,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LocationSdo#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final Location withLabels(Iterable<String> elements) {
    if (this.labels == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        newValue,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LocationSdo#getModified() modified} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modified
   * @return A modified copy of the {@code this} object
   */
  public final Location withModified(StixInstant value) {
    if (this.modified == value) return this;
    StixInstant newValue = Objects.requireNonNull(value, "modified");
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        newValue,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LocationSdo#getRevoked() revoked} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revoked
   * @return A modified copy of the {@code this} object
   */
  public final Location withRevoked(StixBoolean value) {
    if (this.revoked == value) return this;
    StixBoolean newValue = Objects.requireNonNull(value, "revoked");
    return validate(new Location(
        this.name,
        this.description,
        this.latitude,
        this.longitude,
        this.precision,
        this.region,
        this.country,
        this.administrativeArea,
        this.city,
        this.streetAddress,
        this.postalCode,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code Location} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Location
        && equalTo((Location) another);
  }

  private boolean equalTo(Location another) {
    return Objects.equals(name, another.name)
        && Objects.equals(description, another.description)
        && Objects.equals(latitude, another.latitude)
        && Objects.equals(longitude, another.longitude)
        && Objects.equals(precision, another.precision)
        && Objects.equals(region, another.region)
        && Objects.equals(country, another.country)
        && Objects.equals(administrativeArea, another.administrativeArea)
        && Objects.equals(city, another.city)
        && Objects.equals(streetAddress, another.streetAddress)
        && Objects.equals(postalCode, another.postalCode)
        && relationships.equals(another.relationships)
        && hydrated == another.hydrated
        && Objects.equals(type, another.type)
        && Objects.equals(id, another.id)
        && Objects.equals(createdByRef, another.createdByRef)
        && created.equals(another.created)
        && Objects.equals(lang, another.lang)
        && externalReferences.equals(another.externalReferences)
        && objectMarkingRefs.equals(another.objectMarkingRefs)
        && granularMarkings.equals(another.granularMarkings)
        && customProperties.equals(another.customProperties)
        && labels.equals(another.labels)
        && modified.equals(another.modified)
        && revoked.equals(another.revoked);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}, {@code latitude}, {@code longitude}, {@code precision}, {@code region}, {@code country}, {@code administrativeArea}, {@code city}, {@code streetAddress}, {@code postalCode}, {@code relationships}, {@code hydrated}, {@code type}, {@code id}, {@code createdByRef}, {@code created}, {@code lang}, {@code externalReferences}, {@code objectMarkingRefs}, {@code granularMarkings}, {@code customProperties}, {@code labels}, {@code modified}, {@code revoked}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(latitude);
    h += (h << 5) + Objects.hashCode(longitude);
    h += (h << 5) + Objects.hashCode(precision);
    h += (h << 5) + Objects.hashCode(region);
    h += (h << 5) + Objects.hashCode(country);
    h += (h << 5) + Objects.hashCode(administrativeArea);
    h += (h << 5) + Objects.hashCode(city);
    h += (h << 5) + Objects.hashCode(streetAddress);
    h += (h << 5) + Objects.hashCode(postalCode);
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + Booleans.hashCode(hydrated);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(createdByRef);
    h += (h << 5) + created.hashCode();
    h += (h << 5) + Objects.hashCode(lang);
    h += (h << 5) + externalReferences.hashCode();
    h += (h << 5) + objectMarkingRefs.hashCode();
    h += (h << 5) + granularMarkings.hashCode();
    h += (h << 5) + customProperties.hashCode();
    h += (h << 5) + labels.hashCode();
    h += (h << 5) + modified.hashCode();
    h += (h << 5) + revoked.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Location} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Location")
        .omitNullValues()
        .add("name", name)
        .add("description", description)
        .add("latitude", latitude)
        .add("longitude", longitude)
        .add("precision", precision)
        .add("region", region)
        .add("country", country)
        .add("administrativeArea", administrativeArea)
        .add("city", city)
        .add("streetAddress", streetAddress)
        .add("postalCode", postalCode)
        .add("relationships", relationships)
        .add("hydrated", hydrated)
        .add("type", type)
        .add("id", id)
        .add("createdByRef", createdByRef)
        .add("created", created)
        .add("lang", lang)
        .add("externalReferences", externalReferences)
        .add("objectMarkingRefs", objectMarkingRefs)
        .add("granularMarkings", granularMarkings)
        .add("customProperties", customProperties)
        .add("labels", labels)
        .add("modified", modified)
        .add("revoked", revoked)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long TO_JSON_STRING_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String toJsonString;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link LocationSdo#toJsonString() toJsonString} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code toJsonString} attribute
   */
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String toJsonString() {
    if ((lazyInitBitmap & TO_JSON_STRING_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TO_JSON_STRING_LAZY_INIT_BIT) == 0) {
          this.toJsonString = Objects.requireNonNull(LocationSdo.super.toJsonString(), "toJsonString");
          lazyInitBitmap |= TO_JSON_STRING_LAZY_INIT_BIT;
        }
      }
    }
    return toJsonString;
  }

  private static final long SPEC_VERSION_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient String specVersion;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link LocationSdo#getSpecVersion() specVersion} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code specVersion} attribute
   */
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getSpecVersion() {
    if ((lazyInitBitmap & SPEC_VERSION_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SPEC_VERSION_LAZY_INIT_BIT) == 0) {
          this.specVersion = Objects.requireNonNull(LocationSdo.super.getSpecVersion(), "specVersion");
          lazyInitBitmap |= SPEC_VERSION_LAZY_INIT_BIT;
        }
      }
    }
    return specVersion;
  }


  private static Location validate(Location instance) {
    instance.checkHydrationValidation();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link LocationSdo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Location instance
   */
  public static Location copyOf(LocationSdo instance) {
    if (instance instanceof Location) {
      return (Location) instance;
    }
    return Location.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link Location Location}.
   * @return A new Location builder
   */
  public static Location.Builder builder() {
    return new Location.Builder();
  }

  /**
   * Builds instances of type {@link Location Location}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LocationSdo", generator = "Immutables")
  @NotThreadSafe
  @JsonTypeName("location")
  @JsonPropertyOrder({"type", "id", "created_by_ref", "created", "modified", "revoked", "labels", "external_references", "object_marking_refs", "granular_markings", "name", "description", "latitude", "longitude", "precision", "region", "country", "administrative_area", "city", "street_address", "postal_code"})
  public static final class Builder {
    private static final long OPT_BIT_RELATIONSHIPS = 0x1L;
    private static final long OPT_BIT_HYDRATED = 0x2L;
    private static final long OPT_BIT_EXTERNAL_REFERENCES = 0x4L;
    private static final long OPT_BIT_OBJECT_MARKING_REFS = 0x8L;
    private static final long OPT_BIT_GRANULAR_MARKINGS = 0x10L;
    private static final long OPT_BIT_LABELS = 0x20L;
    private long optBits;

    private @Nullable String name;
    private @Nullable String description;
    private @Nullable Double latitude;
    private @Nullable Double longitude;
    private @Nullable Double precision;
    private @Nullable String region;
    private @Nullable String country;
    private @Nullable String administrativeArea;
    private @Nullable String city;
    private @Nullable String streetAddress;
    private @Nullable String postalCode;
    private ImmutableSet.Builder<RelationshipSro> relationships = ImmutableSet.builder();
    private boolean hydrated;
    private @Nullable String type;
    private @Nullable String id;
    private @Nullable IdentitySdo createdByRef;
    private @Nullable StixInstant created;
    private @Nullable String lang;
    private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
    private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
    private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
    private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
    private @Nullable StixInstant modified;
    private @Nullable StixBoolean revoked;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleableObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleableObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixRevoked} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixRevoked instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.sdo.objects.LocationSdo} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LocationSdo instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixLabels} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixLabels instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixModified} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixModified instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.sdo.DomainObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DomainObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BundleableObject) {
        BundleableObject instance = (BundleableObject) object;
        if ((bits & 0x8L) == 0) {
          String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x10L;
        }
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          hydrated(instance.getHydrated());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x4L;
        }
      }
      if (object instanceof StixCommonProperties) {
        StixCommonProperties instance = (StixCommonProperties) object;
        addAllExternalReferences(instance.getExternalReferences());
        if ((bits & 0x2L) == 0) {
          hydrated(instance.getHydrated());
          bits |= 0x2L;
        }
        created(instance.getCreated());
        if ((bits & 0x4L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x4L;
        }
        Optional<IdentitySdo> createdByRefOptional = instance.getCreatedByRef();
        if (createdByRefOptional.isPresent()) {
          createdByRef(createdByRefOptional);
        }
        if ((bits & 0x8L) == 0) {
          String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x10L;
        }
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        Optional<String> langOptional = instance.getLang();
        if (langOptional.isPresent()) {
          lang(langOptional);
        }
      }
      if (object instanceof StixRevoked) {
        StixRevoked instance = (StixRevoked) object;
        revoked(instance.getRevoked());
      }
      if (object instanceof LocationSdo) {
        LocationSdo instance = (LocationSdo) object;
        Optional<String> countryOptional = instance.getCountry();
        if (countryOptional.isPresent()) {
          country(countryOptional);
        }
        Optional<String> cityOptional = instance.getCity();
        if (cityOptional.isPresent()) {
          city(cityOptional);
        }
        Optional<String> streetAddressOptional = instance.getStreetAddress();
        if (streetAddressOptional.isPresent()) {
          streetAddress(streetAddressOptional);
        }
        Optional<Double> latitudeOptional = instance.getLatitude();
        if (latitudeOptional.isPresent()) {
          latitude(latitudeOptional);
        }
        Optional<Double> precisionOptional = instance.getPrecision();
        if (precisionOptional.isPresent()) {
          precision(precisionOptional);
        }
        Optional<String> postalCodeOptional = instance.getPostalCode();
        if (postalCodeOptional.isPresent()) {
          postalCode(postalCodeOptional);
        }
        Optional<String> nameOptional = instance.getName();
        if (nameOptional.isPresent()) {
          name(nameOptional);
        }
        Optional<String> descriptionOptional = instance.getDescription();
        if (descriptionOptional.isPresent()) {
          description(descriptionOptional);
        }
        Optional<String> administrativeAreaOptional = instance.getAdministrativeArea();
        if (administrativeAreaOptional.isPresent()) {
          administrativeArea(administrativeAreaOptional);
        }
        Optional<String> regionOptional = instance.getRegion();
        if (regionOptional.isPresent()) {
          region(regionOptional);
        }
        Optional<Double> longitudeOptional = instance.getLongitude();
        if (longitudeOptional.isPresent()) {
          longitude(longitudeOptional);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof StixLabels) {
        StixLabels instance = (StixLabels) object;
        addAllLabels(instance.getLabels());
      }
      if (object instanceof StixModified) {
        StixModified instance = (StixModified) object;
        modified(instance.getModified());
      }
      if (object instanceof DomainObject) {
        DomainObject instance = (DomainObject) object;
        addAllRelationships(instance.getRelationships());
      }
    }

    /**
     * Initializes the optional value {@link LocationSdo#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A name used to identify the Location.")
    public final Builder name(Optional<String> name) {
      this.name = name.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getDescription() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getDescription() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A textual description of the Location.")
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getLatitude() latitude} to latitude.
     * @param latitude The value for latitude
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder latitude(double latitude) {
      this.latitude = latitude;
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getLatitude() latitude} to latitude.
     * @param latitude The value for latitude
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("latitude")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The latitude of the Location in decimal degrees.")
    public final Builder latitude(Optional<Double> latitude) {
      this.latitude = latitude.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getLongitude() longitude} to longitude.
     * @param longitude The value for longitude
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder longitude(double longitude) {
      this.longitude = longitude;
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getLongitude() longitude} to longitude.
     * @param longitude The value for longitude
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("longitude")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The longitude of the Location in decimal degrees.")
    public final Builder longitude(Optional<Double> longitude) {
      this.longitude = longitude.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getPrecision() precision} to precision.
     * @param precision The value for precision
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder precision(double precision) {
      this.precision = precision;
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getPrecision() precision} to precision.
     * @param precision The value for precision
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("precision")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Defines the precision of the coordinates specified by the latitude and longitude properties in meters.")
    public final Builder precision(Optional<Double> precision) {
      this.precision = precision.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getRegion() region} to region.
     * @param region The value for region
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder region(String region) {
      this.region = Objects.requireNonNull(region, "region");
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getRegion() region} to region.
     * @param region The value for region
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("region")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The region that this Location describes. Open Vocabulary: region-ov")
    public final Builder region(Optional<String> region) {
      this.region = region.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getCountry() country} to country.
     * @param country The value for country
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder country(String country) {
      this.country = Objects.requireNonNull(country, "country");
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getCountry() country} to country.
     * @param country The value for country
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("country")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The country that this Location describes (ISO 3166-1 ALPHA-2 Code).")
    public final Builder country(Optional<String> country) {
      this.country = country.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getAdministrativeArea() administrativeArea} to administrativeArea.
     * @param administrativeArea The value for administrativeArea
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder administrativeArea(String administrativeArea) {
      this.administrativeArea = Objects.requireNonNull(administrativeArea, "administrativeArea");
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getAdministrativeArea() administrativeArea} to administrativeArea.
     * @param administrativeArea The value for administrativeArea
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("administrative_area")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The state, province, or other sub-national administrative area that this Location describes.")
    public final Builder administrativeArea(Optional<String> administrativeArea) {
      this.administrativeArea = administrativeArea.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getCity() city} to city.
     * @param city The value for city
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder city(String city) {
      this.city = Objects.requireNonNull(city, "city");
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getCity() city} to city.
     * @param city The value for city
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("city")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The city that this Location describes.")
    public final Builder city(Optional<String> city) {
      this.city = city.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getStreetAddress() streetAddress} to streetAddress.
     * @param streetAddress The value for streetAddress
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder streetAddress(String streetAddress) {
      this.streetAddress = Objects.requireNonNull(streetAddress, "streetAddress");
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getStreetAddress() streetAddress} to streetAddress.
     * @param streetAddress The value for streetAddress
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("street_address")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The street address that this Location describes.")
    public final Builder streetAddress(Optional<String> streetAddress) {
      this.streetAddress = streetAddress.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getPostalCode() postalCode} to postalCode.
     * @param postalCode The value for postalCode
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder postalCode(String postalCode) {
      this.postalCode = Objects.requireNonNull(postalCode, "postalCode");
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getPostalCode() postalCode} to postalCode.
     * @param postalCode The value for postalCode
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("postal_code")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The postal code for this Location.")
    public final Builder postalCode(Optional<String> postalCode) {
      this.postalCode = postalCode.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link LocationSdo#getRelationships() relationships} set.
     * @param element A relationships element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRelationship(@Nullable RelationshipSro element) {
      this.relationships.add(element);
      optBits |= OPT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Adds elements to {@link LocationSdo#getRelationships() relationships} set.
     * @param elements An array of relationships elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRelationships(RelationshipSro... elements) {
      this.relationships.add(elements);
      optBits |= OPT_BIT_RELATIONSHIPS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LocationSdo#getRelationships() relationships} set.
     * @param elements An iterable of relationships elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("relationships")
    @JsonIgnore
    public final Builder relationships(Iterable<? extends RelationshipSro> elements) {
      this.relationships = ImmutableSet.builder();
      return addAllRelationships(elements);
    }

    /**
     * Adds elements to {@link LocationSdo#getRelationships() relationships} set.
     * @param elements An iterable of relationships elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRelationships(Iterable<? extends RelationshipSro> elements) {
      this.relationships.addAll(elements);
      optBits |= OPT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link LocationSdo#getHydrated() hydrated} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LocationSdo#getHydrated() hydrated}.</em>
     * @param hydrated The value for hydrated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    public final Builder hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      optBits |= OPT_BIT_HYDRATED;
      return this;
    }

    /**
     * Initializes the value for the {@link LocationSdo#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    @JsonPropertyDescription("The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link LocationSdo#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    public final Builder id(String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder createdByRef(IdentitySdo createdByRef) {
      this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created_by_ref")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
    @JsonIdentityReference(alwaysAsId = true)
    @JsonDeserialize(converter = DomainObjectOptionalConverter.class)
    public final Builder createdByRef(Optional<? extends IdentitySdo> createdByRef) {
      this.createdByRef = createdByRef.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link LocationSdo#getCreated() created} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LocationSdo#getCreated() created}.</em>
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    @JsonPropertyDescription("The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
    public final Builder created(StixInstant created) {
      this.created = Objects.requireNonNull(created, "created");
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getLang() lang} to lang.
     * @param lang The value for lang
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder lang(String lang) {
      this.lang = Objects.requireNonNull(lang, "lang");
      return this;
    }

    /**
     * Initializes the optional value {@link LocationSdo#getLang() lang} to lang.
     * @param lang The value for lang
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lang")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Identifies the language of the text content in this object using ISO 639-2 language codes.")
    public final Builder lang(Optional<String> lang) {
      this.lang = lang.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link LocationSdo#getExternalReferences() externalReferences} set.
     * @param element A externalReferences element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
      this.externalReferences.add(element);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }

    /**
     * Adds elements to {@link LocationSdo#getExternalReferences() externalReferences} set.
     * @param elements An array of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReferences(ExternalReferenceType... elements) {
      this.externalReferences.add(elements);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LocationSdo#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("external_references")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A list of external references which refers to non-STIX information.")
    public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences = ImmutableSet.builder();
      return addAllExternalReferences(elements);
    }

    /**
     * Adds elements to {@link LocationSdo#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences.addAll(elements);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }

    /**
     * Adds one element to {@link LocationSdo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param element A objectMarkingRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
      this.objectMarkingRefs.add(element);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }

    /**
     * Adds elements to {@link LocationSdo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An array of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRefs(MarkingDefinitionDm... elements) {
      this.objectMarkingRefs.add(elements);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LocationSdo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("object_marking_refs")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
    @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
    @JsonIdentityReference(alwaysAsId = true)
    @JsonDeserialize(converter = MarkingDefinitionSetConverter.class)
    public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs = ImmutableSet.builder();
      return addAllObjectMarkingRefs(elements);
    }

    /**
     * Adds elements to {@link LocationSdo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs.addAll(elements);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }

    /**
     * Adds one element to {@link LocationSdo#getGranularMarkings() granularMarkings} set.
     * @param element A granularMarkings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
      this.granularMarkings.add(element);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }

    /**
     * Adds elements to {@link LocationSdo#getGranularMarkings() granularMarkings} set.
     * @param elements An array of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarkings(GranularMarkingDm... elements) {
      this.granularMarkings.add(elements);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LocationSdo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("granular_markings")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The set of granular markings that apply to this object.")
    public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings = ImmutableSet.builder();
      return addAllGranularMarkings(elements);
    }

    /**
     * Adds elements to {@link LocationSdo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings.addAll(elements);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }

    /**
     * Put one entry to the {@link LocationSdo#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link LocationSdo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link LocationSdo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link LocationSdo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link LocationSdo#getLabels() labels} set.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabel(@Nullable String element) {
      this.labels.add(element);
      optBits |= OPT_BIT_LABELS;
      return this;
    }

    /**
     * Adds elements to {@link LocationSdo#getLabels() labels} set.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(String... elements) {
      this.labels.add(elements);
      optBits |= OPT_BIT_LABELS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LocationSdo#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labels")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The labels property specifies a set of classifications.")
    public final Builder labels(Iterable<String> elements) {
      this.labels = ImmutableSet.builder();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link LocationSdo#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<String> elements) {
      this.labels.addAll(elements);
      optBits |= OPT_BIT_LABELS;
      return this;
    }

    /**
     * Initializes the value for the {@link LocationSdo#getModified() modified} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LocationSdo#getModified() modified}.</em>
     * @param modified The value for modified 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("modified")
    @JsonPropertyDescription("The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
    public final Builder modified(StixInstant modified) {
      this.modified = Objects.requireNonNull(modified, "modified");
      return this;
    }

    /**
     * Initializes the value for the {@link LocationSdo#getRevoked() revoked} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LocationSdo#getRevoked() revoked}.</em>
     * @param revoked The value for revoked 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("revoked")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The revoked property indicates whether the object has been revoked.")
    public final Builder revoked(StixBoolean revoked) {
      this.revoked = Objects.requireNonNull(revoked, "revoked");
      return this;
    }

    /**
     * Builds a new {@link Location Location}.
     * @return An immutable instance of Location
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Location build() {
      return Location.validate(new Location(this));
    }

    private boolean relationshipsIsSet() {
      return (optBits & OPT_BIT_RELATIONSHIPS) != 0;
    }

    private boolean hydratedIsSet() {
      return (optBits & OPT_BIT_HYDRATED) != 0;
    }

    private boolean externalReferencesIsSet() {
      return (optBits & OPT_BIT_EXTERNAL_REFERENCES) != 0;
    }

    private boolean objectMarkingRefsIsSet() {
      return (optBits & OPT_BIT_OBJECT_MARKING_REFS) != 0;
    }

    private boolean granularMarkingsIsSet() {
      return (optBits & OPT_BIT_GRANULAR_MARKINGS) != 0;
    }

    private boolean labelsIsSet() {
      return (optBits & OPT_BIT_LABELS) != 0;
    }
  }
}
