package security.whisper.javastix.sdo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixBoolean;
import security.whisper.javastix.common.StixCommonProperties;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.common.StixLabels;
import security.whisper.javastix.common.StixModified;
import security.whisper.javastix.common.StixRevoked;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectOptionalConverter;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.DomainObject;
import security.whisper.javastix.sdo.types.ExternalReferenceType;
import security.whisper.javastix.sro.objects.RelationshipSro;

/**
 * malware-analysis
 * <p>
 * A Malware Analysis captures the results of a particular analysis performed on a malware instance or family.
 * Each result captures the analysis product (including version) that was used to analyze the malware along with
 * the result of that analysis.
 */
@Generated(from = "MalwareAnalysisSdo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonTypeName("malware-analysis")
@Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
public final class MalwareAnalysis implements MalwareAnalysisSdo {
  private final String product;
  private final @Nullable String version;
  private final @Nullable String hostVmRef;
  private final @Nullable String operatingSystemRef;
  private final ImmutableSet<String> installedSoftwareRefs;
  private final @Nullable String configurationVersion;
  private final @Nullable String module;
  private final @Nullable String analysisEngineVersion;
  private final @Nullable String analysisDefinitionVersion;
  private final @Nullable StixInstant submitted;
  private final @Nullable StixInstant analysisStarted;
  private final @Nullable StixInstant analysisEnded;
  private final @Nullable String avResult;
  private final ImmutableSet<String> analysisScoRefs;
  private final @Nullable String sampleRef;
  private final ImmutableSet<RelationshipSro> relationships;
  private final boolean hydrated;
  private final String type;
  private final String id;
  private final @Nullable IdentitySdo createdByRef;
  private final StixInstant created;
  private final @Nullable String lang;
  private final ImmutableSet<ExternalReferenceType> externalReferences;
  private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
  private final ImmutableSet<GranularMarkingDm> granularMarkings;
  private final ImmutableMap<String, Object> customProperties;
  private final ImmutableSet<String> labels;
  private final StixInstant modified;
  private final StixBoolean revoked;

  private MalwareAnalysis(MalwareAnalysis.Builder builder) {
    this.product = builder.product;
    this.version = builder.version;
    this.hostVmRef = builder.hostVmRef;
    this.operatingSystemRef = builder.operatingSystemRef;
    this.installedSoftwareRefs = builder.installedSoftwareRefs.build();
    this.configurationVersion = builder.configurationVersion;
    this.module = builder.module;
    this.analysisEngineVersion = builder.analysisEngineVersion;
    this.analysisDefinitionVersion = builder.analysisDefinitionVersion;
    this.submitted = builder.submitted;
    this.analysisStarted = builder.analysisStarted;
    this.analysisEnded = builder.analysisEnded;
    this.avResult = builder.avResult;
    this.analysisScoRefs = builder.analysisScoRefs.build();
    this.sampleRef = builder.sampleRef;
    this.type = builder.type;
    this.id = builder.id;
    this.createdByRef = builder.createdByRef;
    this.lang = builder.lang;
    this.customProperties = builder.customProperties.build();
    if (builder.relationshipsIsSet()) {
      initShim.relationships(builder.relationships.build());
    }
    if (builder.hydratedIsSet()) {
      initShim.hydrated(builder.hydrated);
    }
    if (builder.created != null) {
      initShim.created(builder.created);
    }
    if (builder.externalReferencesIsSet()) {
      initShim.externalReferences(builder.externalReferences.build());
    }
    if (builder.objectMarkingRefsIsSet()) {
      initShim.objectMarkingRefs(builder.objectMarkingRefs.build());
    }
    if (builder.granularMarkingsIsSet()) {
      initShim.granularMarkings(builder.granularMarkings.build());
    }
    if (builder.labelsIsSet()) {
      initShim.labels(builder.labels.build());
    }
    if (builder.modified != null) {
      initShim.modified(builder.modified);
    }
    if (builder.revoked != null) {
      initShim.revoked(builder.revoked);
    }
    this.relationships = initShim.getRelationships();
    this.hydrated = initShim.getHydrated();
    this.created = initShim.getCreated();
    this.externalReferences = initShim.getExternalReferences();
    this.objectMarkingRefs = initShim.getObjectMarkingRefs();
    this.granularMarkings = initShim.getGranularMarkings();
    this.labels = initShim.getLabels();
    this.modified = initShim.getModified();
    this.revoked = initShim.getRevoked();
    this.initShim = null;
  }

  private MalwareAnalysis(
      String product,
      @Nullable String version,
      @Nullable String hostVmRef,
      @Nullable String operatingSystemRef,
      ImmutableSet<String> installedSoftwareRefs,
      @Nullable String configurationVersion,
      @Nullable String module,
      @Nullable String analysisEngineVersion,
      @Nullable String analysisDefinitionVersion,
      @Nullable StixInstant submitted,
      @Nullable StixInstant analysisStarted,
      @Nullable StixInstant analysisEnded,
      @Nullable String avResult,
      ImmutableSet<String> analysisScoRefs,
      @Nullable String sampleRef,
      ImmutableSet<RelationshipSro> relationships,
      boolean hydrated,
      String type,
      String id,
      @Nullable IdentitySdo createdByRef,
      StixInstant created,
      @Nullable String lang,
      ImmutableSet<ExternalReferenceType> externalReferences,
      ImmutableSet<MarkingDefinitionDm> objectMarkingRefs,
      ImmutableSet<GranularMarkingDm> granularMarkings,
      ImmutableMap<String, Object> customProperties,
      ImmutableSet<String> labels,
      StixInstant modified,
      StixBoolean revoked) {
    this.product = product;
    this.version = version;
    this.hostVmRef = hostVmRef;
    this.operatingSystemRef = operatingSystemRef;
    this.installedSoftwareRefs = installedSoftwareRefs;
    this.configurationVersion = configurationVersion;
    this.module = module;
    this.analysisEngineVersion = analysisEngineVersion;
    this.analysisDefinitionVersion = analysisDefinitionVersion;
    this.submitted = submitted;
    this.analysisStarted = analysisStarted;
    this.analysisEnded = analysisEnded;
    this.avResult = avResult;
    this.analysisScoRefs = analysisScoRefs;
    this.sampleRef = sampleRef;
    this.relationships = relationships;
    this.hydrated = hydrated;
    this.type = type;
    this.id = id;
    this.createdByRef = createdByRef;
    this.created = created;
    this.lang = lang;
    this.externalReferences = externalReferences;
    this.objectMarkingRefs = objectMarkingRefs;
    this.granularMarkings = granularMarkings;
    this.customProperties = customProperties;
    this.labels = labels;
    this.modified = modified;
    this.revoked = revoked;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MalwareAnalysisSdo", generator = "Immutables")
  private final class InitShim {
    private byte relationshipsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<RelationshipSro> relationships;

    ImmutableSet<RelationshipSro> getRelationships() {
      if (relationshipsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (relationshipsBuildStage == STAGE_UNINITIALIZED) {
        relationshipsBuildStage = STAGE_INITIALIZING;
        this.relationships = ImmutableSet.copyOf(getRelationshipsInitialize());
        relationshipsBuildStage = STAGE_INITIALIZED;
      }
      return this.relationships;
    }

    void relationships(ImmutableSet<RelationshipSro> relationships) {
      this.relationships = relationships;
      relationshipsBuildStage = STAGE_INITIALIZED;
    }

    private byte hydratedBuildStage = STAGE_UNINITIALIZED;
    private boolean hydrated;

    boolean getHydrated() {
      if (hydratedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hydratedBuildStage == STAGE_UNINITIALIZED) {
        hydratedBuildStage = STAGE_INITIALIZING;
        this.hydrated = getHydratedInitialize();
        hydratedBuildStage = STAGE_INITIALIZED;
      }
      return this.hydrated;
    }

    void hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      hydratedBuildStage = STAGE_INITIALIZED;
    }

    private byte createdBuildStage = STAGE_UNINITIALIZED;
    private StixInstant created;

    StixInstant getCreated() {
      if (createdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (createdBuildStage == STAGE_UNINITIALIZED) {
        createdBuildStage = STAGE_INITIALIZING;
        this.created = Objects.requireNonNull(getCreatedInitialize(), "created");
        createdBuildStage = STAGE_INITIALIZED;
      }
      return this.created;
    }

    void created(StixInstant created) {
      this.created = created;
      createdBuildStage = STAGE_INITIALIZED;
    }

    private byte externalReferencesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<ExternalReferenceType> externalReferences;

    ImmutableSet<ExternalReferenceType> getExternalReferences() {
      if (externalReferencesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (externalReferencesBuildStage == STAGE_UNINITIALIZED) {
        externalReferencesBuildStage = STAGE_INITIALIZING;
        this.externalReferences = ImmutableSet.copyOf(getExternalReferencesInitialize());
        externalReferencesBuildStage = STAGE_INITIALIZED;
      }
      return this.externalReferences;
    }

    void externalReferences(ImmutableSet<ExternalReferenceType> externalReferences) {
      this.externalReferences = externalReferences;
      externalReferencesBuildStage = STAGE_INITIALIZED;
    }

    private byte objectMarkingRefsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;

    ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
      if (objectMarkingRefsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectMarkingRefsBuildStage == STAGE_UNINITIALIZED) {
        objectMarkingRefsBuildStage = STAGE_INITIALIZING;
        this.objectMarkingRefs = ImmutableSet.copyOf(getObjectMarkingRefsInitialize());
        objectMarkingRefsBuildStage = STAGE_INITIALIZED;
      }
      return this.objectMarkingRefs;
    }

    void objectMarkingRefs(ImmutableSet<MarkingDefinitionDm> objectMarkingRefs) {
      this.objectMarkingRefs = objectMarkingRefs;
      objectMarkingRefsBuildStage = STAGE_INITIALIZED;
    }

    private byte granularMarkingsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<GranularMarkingDm> granularMarkings;

    ImmutableSet<GranularMarkingDm> getGranularMarkings() {
      if (granularMarkingsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (granularMarkingsBuildStage == STAGE_UNINITIALIZED) {
        granularMarkingsBuildStage = STAGE_INITIALIZING;
        this.granularMarkings = ImmutableSet.copyOf(getGranularMarkingsInitialize());
        granularMarkingsBuildStage = STAGE_INITIALIZED;
      }
      return this.granularMarkings;
    }

    void granularMarkings(ImmutableSet<GranularMarkingDm> granularMarkings) {
      this.granularMarkings = granularMarkings;
      granularMarkingsBuildStage = STAGE_INITIALIZED;
    }

    private byte labelsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<String> labels;

    ImmutableSet<String> getLabels() {
      if (labelsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (labelsBuildStage == STAGE_UNINITIALIZED) {
        labelsBuildStage = STAGE_INITIALIZING;
        this.labels = ImmutableSet.copyOf(getLabelsInitialize());
        labelsBuildStage = STAGE_INITIALIZED;
      }
      return this.labels;
    }

    void labels(ImmutableSet<String> labels) {
      this.labels = labels;
      labelsBuildStage = STAGE_INITIALIZED;
    }

    private byte modifiedBuildStage = STAGE_UNINITIALIZED;
    private StixInstant modified;

    StixInstant getModified() {
      if (modifiedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (modifiedBuildStage == STAGE_UNINITIALIZED) {
        modifiedBuildStage = STAGE_INITIALIZING;
        this.modified = Objects.requireNonNull(getModifiedInitialize(), "modified");
        modifiedBuildStage = STAGE_INITIALIZED;
      }
      return this.modified;
    }

    void modified(StixInstant modified) {
      this.modified = modified;
      modifiedBuildStage = STAGE_INITIALIZED;
    }

    private byte revokedBuildStage = STAGE_UNINITIALIZED;
    private StixBoolean revoked;

    StixBoolean getRevoked() {
      if (revokedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (revokedBuildStage == STAGE_UNINITIALIZED) {
        revokedBuildStage = STAGE_INITIALIZING;
        this.revoked = Objects.requireNonNull(getRevokedInitialize(), "revoked");
        revokedBuildStage = STAGE_INITIALIZED;
      }
      return this.revoked;
    }

    void revoked(StixBoolean revoked) {
      this.revoked = revoked;
      revokedBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (relationshipsBuildStage == STAGE_INITIALIZING) attributes.add("relationships");
      if (hydratedBuildStage == STAGE_INITIALIZING) attributes.add("hydrated");
      if (createdBuildStage == STAGE_INITIALIZING) attributes.add("created");
      if (externalReferencesBuildStage == STAGE_INITIALIZING) attributes.add("externalReferences");
      if (objectMarkingRefsBuildStage == STAGE_INITIALIZING) attributes.add("objectMarkingRefs");
      if (granularMarkingsBuildStage == STAGE_INITIALIZING) attributes.add("granularMarkings");
      if (labelsBuildStage == STAGE_INITIALIZING) attributes.add("labels");
      if (modifiedBuildStage == STAGE_INITIALIZING) attributes.add("modified");
      if (revokedBuildStage == STAGE_INITIALIZING) attributes.add("revoked");
      return "Cannot build MalwareAnalysis, attribute initializers form cycle " + attributes;
    }
  }

  private Set<RelationshipSro> getRelationshipsInitialize() {
    return MalwareAnalysisSdo.super.getRelationships();
  }

  private boolean getHydratedInitialize() {
    return MalwareAnalysisSdo.super.getHydrated();
  }

  private StixInstant getCreatedInitialize() {
    return MalwareAnalysisSdo.super.getCreated();
  }

  private Set<ExternalReferenceType> getExternalReferencesInitialize() {
    return MalwareAnalysisSdo.super.getExternalReferences();
  }

  private Set<MarkingDefinitionDm> getObjectMarkingRefsInitialize() {
    return MalwareAnalysisSdo.super.getObjectMarkingRefs();
  }

  private Set<GranularMarkingDm> getGranularMarkingsInitialize() {
    return MalwareAnalysisSdo.super.getGranularMarkings();
  }

  private Set<String> getLabelsInitialize() {
    return MalwareAnalysisSdo.super.getLabels();
  }

  private StixInstant getModifiedInitialize() {
    return MalwareAnalysisSdo.super.getModified();
  }

  private StixBoolean getRevokedInitialize() {
    return MalwareAnalysisSdo.super.getRevoked();
  }

  /**
   * @return The value of the {@code product} attribute
   */
  @JsonProperty("product")
  @JsonPropertyDescription("The name of the analysis product that was used to perform the analysis.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getProduct() {
    return product;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The version of the analysis product that was used to perform the analysis.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getVersion() {
    return Optional.ofNullable(version);
  }

  /**
   * @return The value of the {@code hostVmRef} attribute
   */
  @JsonProperty("host_vm_ref")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A reference to a SCO Software object for the VM that hosted the malware during the analysis.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getHostVmRef() {
    return Optional.ofNullable(hostVmRef);
  }

  /**
   * @return The value of the {@code operatingSystemRef} attribute
   */
  @JsonProperty("operating_system_ref")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A reference to a SCO Software object for the operating system used for the analysis VM.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getOperatingSystemRef() {
    return Optional.ofNullable(operatingSystemRef);
  }

  /**
   * @return The value of the {@code installedSoftwareRefs} attribute
   */
  @JsonProperty("installed_software_refs")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A list of references to SCO Software objects for the operating system software installed on the analysis VM.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<String> getInstalledSoftwareRefs() {
    return installedSoftwareRefs;
  }

  /**
   * @return The value of the {@code configurationVersion} attribute
   */
  @JsonProperty("configuration_version")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The version of the configuration used for the analysis.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getConfigurationVersion() {
    return Optional.ofNullable(configurationVersion);
  }

  /**
   * @return The value of the {@code module} attribute
   */
  @JsonProperty("module")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The name of the specific analysis module that was used, if different from the product.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getModule() {
    return Optional.ofNullable(module);
  }

  /**
   * @return The value of the {@code analysisEngineVersion} attribute
   */
  @JsonProperty("analysis_engine_version")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The version of the analysis engine or runtime environment.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getAnalysisEngineVersion() {
    return Optional.ofNullable(analysisEngineVersion);
  }

  /**
   * @return The value of the {@code analysisDefinitionVersion} attribute
   */
  @JsonProperty("analysis_definition_version")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The version of the analysis definitions used (e.g., virus definition version).")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getAnalysisDefinitionVersion() {
    return Optional.ofNullable(analysisDefinitionVersion);
  }

  /**
   * @return The value of the {@code submitted} attribute
   */
  @JsonProperty("submitted")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The date and time that the malware sample was submitted for analysis.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<StixInstant> getSubmitted() {
    return Optional.ofNullable(submitted);
  }

  /**
   * @return The value of the {@code analysisStarted} attribute
   */
  @JsonProperty("analysis_started")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The date and time that the malware analysis started.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<StixInstant> getAnalysisStarted() {
    return Optional.ofNullable(analysisStarted);
  }

  /**
   * @return The value of the {@code analysisEnded} attribute
   */
  @JsonProperty("analysis_ended")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The date and time that the malware analysis ended.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<StixInstant> getAnalysisEnded() {
    return Optional.ofNullable(analysisEnded);
  }

  /**
   * @return The value of the {@code avResult} attribute
   */
  @JsonProperty("av_result")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The result of the anti-virus analysis. Open vocabulary - malware-av-result-ov")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getAvResult() {
    return Optional.ofNullable(avResult);
  }

  /**
   * @return The value of the {@code analysisScoRefs} attribute
   */
  @JsonProperty("analysis_sco_refs")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A list of references to SCOs that were captured during the analysis process.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<String> getAnalysisScoRefs() {
    return analysisScoRefs;
  }

  /**
   * @return The value of the {@code sampleRef} attribute
   */
  @JsonProperty("sample_ref")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A reference to the SCO file, malware or artifact object that was analyzed.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getSampleRef() {
    return Optional.ofNullable(sampleRef);
  }

  /**
   * This is used with the SROs.  The SRO interface enforces what relationships can be created.  The Relationships can then be stored in the Domain object if they choose.
   * Otherwise you would typically add these Relationship SROs that are specific to SDOs, can be grabbed during bundle creation.
   * @return Set of Relationship SROs
   */
  @JsonProperty("relationships")
  @JsonIgnore
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<RelationshipSro> getRelationships() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRelationships()
        : this.relationships;
  }

  /**
   * Dictates if the object is hydrated.
   * Hydration is defined as if the Object has only a "ID" or has been properly
   * hydrated with the expected required fields
   * @return boolean
   */
  @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public boolean getHydrated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHydrated()
        : this.hydrated;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @JsonPropertyDescription("The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code createdByRef} attribute
   */
  @JsonProperty("created_by_ref")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
  @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
  @JsonIdentityReference(alwaysAsId = true)
  @JsonDeserialize(converter = DomainObjectOptionalConverter.class)
  @Redactable(useMask = true, redactionMask = "identity--__REDACTED__")
  @Override
  public Optional<IdentitySdo> getCreatedByRef() {
    return Optional.ofNullable(createdByRef);
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @JsonPropertyDescription("The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
  @Redactable(useMask = true, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getCreated() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCreated()
        : this.created;
  }

  /**
   * @return The value of the {@code lang} attribute
   */
  @JsonProperty("lang")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Identifies the language of the text content in this object using ISO 639-2 language codes.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public Optional<String> getLang() {
    return Optional.ofNullable(lang);
  }

  /**
   * @return The value of the {@code externalReferences} attribute
   */
  @JsonProperty("external_references")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A list of external references which refers to non-STIX information.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<ExternalReferenceType> getExternalReferences() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExternalReferences()
        : this.externalReferences;
  }

  /**
   * @return The value of the {@code objectMarkingRefs} attribute
   */
  @JsonProperty("object_marking_refs")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
  @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
  @JsonIdentityReference(alwaysAsId = true)
  @JsonDeserialize(converter = MarkingDefinitionSetConverter.class)
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObjectMarkingRefs()
        : this.objectMarkingRefs;
  }

  /**
   * @return The value of the {@code granularMarkings} attribute
   */
  @JsonProperty("granular_markings")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The set of granular markings that apply to this object.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getGranularMarkings()
        : this.granularMarkings;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The labels property specifies a set of classifications.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public ImmutableSet<String> getLabels() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLabels()
        : this.labels;
  }

  /**
   * @return The value of the {@code modified} attribute
   */
  @JsonProperty("modified")
  @JsonPropertyDescription("The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixInstant getModified() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getModified()
        : this.modified;
  }

  /**
   * @return The value of the {@code revoked} attribute
   */
  @JsonProperty("revoked")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("The revoked property indicates whether the object has been revoked.")
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public StixBoolean getRevoked() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRevoked()
        : this.revoked;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MalwareAnalysisSdo#getProduct() product} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for product (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final MalwareAnalysis withProduct(String value) {
    if (Objects.equals(this.product, value)) return this;
    return validate(new MalwareAnalysis(
        value,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getVersion() version} attribute.
   * @param value The value for version
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withVersion(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "version");
    if (Objects.equals(this.version, newValue)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        newValue,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getVersion() version} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for version
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withVersion(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.version, value)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        value,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getHostVmRef() hostVmRef} attribute.
   * @param value The value for hostVmRef
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withHostVmRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "hostVmRef");
    if (Objects.equals(this.hostVmRef, newValue)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        newValue,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getHostVmRef() hostVmRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for hostVmRef
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withHostVmRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.hostVmRef, value)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        value,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getOperatingSystemRef() operatingSystemRef} attribute.
   * @param value The value for operatingSystemRef
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withOperatingSystemRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "operatingSystemRef");
    if (Objects.equals(this.operatingSystemRef, newValue)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        newValue,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getOperatingSystemRef() operatingSystemRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for operatingSystemRef
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withOperatingSystemRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.operatingSystemRef, value)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        value,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getInstalledSoftwareRefs() installedSoftwareRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withInstalledSoftwareRefs(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        newValue,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getInstalledSoftwareRefs() installedSoftwareRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of installedSoftwareRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withInstalledSoftwareRefs(Iterable<String> elements) {
    if (this.installedSoftwareRefs == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        newValue,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getConfigurationVersion() configurationVersion} attribute.
   * @param value The value for configurationVersion
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withConfigurationVersion(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "configurationVersion");
    if (Objects.equals(this.configurationVersion, newValue)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        newValue,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getConfigurationVersion() configurationVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for configurationVersion
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withConfigurationVersion(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.configurationVersion, value)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        value,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getModule() module} attribute.
   * @param value The value for module
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withModule(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "module");
    if (Objects.equals(this.module, newValue)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        newValue,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getModule() module} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for module
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withModule(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.module, value)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        value,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getAnalysisEngineVersion() analysisEngineVersion} attribute.
   * @param value The value for analysisEngineVersion
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withAnalysisEngineVersion(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "analysisEngineVersion");
    if (Objects.equals(this.analysisEngineVersion, newValue)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        newValue,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getAnalysisEngineVersion() analysisEngineVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for analysisEngineVersion
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withAnalysisEngineVersion(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.analysisEngineVersion, value)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        value,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getAnalysisDefinitionVersion() analysisDefinitionVersion} attribute.
   * @param value The value for analysisDefinitionVersion
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withAnalysisDefinitionVersion(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "analysisDefinitionVersion");
    if (Objects.equals(this.analysisDefinitionVersion, newValue)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        newValue,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getAnalysisDefinitionVersion() analysisDefinitionVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for analysisDefinitionVersion
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withAnalysisDefinitionVersion(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.analysisDefinitionVersion, value)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        value,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getSubmitted() submitted} attribute.
   * @param value The value for submitted
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withSubmitted(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "submitted");
    if (this.submitted == newValue) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        newValue,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getSubmitted() submitted} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for submitted
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final MalwareAnalysis withSubmitted(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.submitted == value) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        value,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getAnalysisStarted() analysisStarted} attribute.
   * @param value The value for analysisStarted
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withAnalysisStarted(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "analysisStarted");
    if (this.analysisStarted == newValue) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        newValue,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getAnalysisStarted() analysisStarted} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for analysisStarted
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final MalwareAnalysis withAnalysisStarted(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.analysisStarted == value) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        value,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getAnalysisEnded() analysisEnded} attribute.
   * @param value The value for analysisEnded
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withAnalysisEnded(StixInstant value) {
    @Nullable StixInstant newValue = Objects.requireNonNull(value, "analysisEnded");
    if (this.analysisEnded == newValue) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        newValue,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getAnalysisEnded() analysisEnded} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for analysisEnded
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final MalwareAnalysis withAnalysisEnded(Optional<? extends StixInstant> optional) {
    @Nullable StixInstant value = optional.orElse(null);
    if (this.analysisEnded == value) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        value,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getAvResult() avResult} attribute.
   * @param value The value for avResult
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withAvResult(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "avResult");
    if (Objects.equals(this.avResult, newValue)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        newValue,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getAvResult() avResult} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for avResult
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withAvResult(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.avResult, value)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        value,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getAnalysisScoRefs() analysisScoRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withAnalysisScoRefs(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        newValue,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getAnalysisScoRefs() analysisScoRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of analysisScoRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withAnalysisScoRefs(Iterable<String> elements) {
    if (this.analysisScoRefs == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        newValue,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getSampleRef() sampleRef} attribute.
   * @param value The value for sampleRef
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withSampleRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "sampleRef");
    if (Objects.equals(this.sampleRef, newValue)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        newValue,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getSampleRef() sampleRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sampleRef
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withSampleRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.sampleRef, value)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        value,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getRelationships() relationships}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withRelationships(RelationshipSro... elements) {
    ImmutableSet<RelationshipSro> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        newValue,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getRelationships() relationships}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of relationships elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withRelationships(Iterable<? extends RelationshipSro> elements) {
    if (this.relationships == elements) return this;
    ImmutableSet<RelationshipSro> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        newValue,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MalwareAnalysisSdo#getHydrated() hydrated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hydrated
   * @return A modified copy of the {@code this} object
   */
  public final MalwareAnalysis withHydrated(boolean value) {
    if (this.hydrated == value) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        value,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MalwareAnalysisSdo#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final MalwareAnalysis withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        value,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MalwareAnalysisSdo#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final MalwareAnalysis withId(String value) {
    if (Objects.equals(this.id, value)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        value,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getCreatedByRef() createdByRef} attribute.
   * @param value The value for createdByRef
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withCreatedByRef(IdentitySdo value) {
    @Nullable IdentitySdo newValue = Objects.requireNonNull(value, "createdByRef");
    if (this.createdByRef == newValue) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        newValue,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getCreatedByRef() createdByRef} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for createdByRef
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final MalwareAnalysis withCreatedByRef(Optional<? extends IdentitySdo> optional) {
    @Nullable IdentitySdo value = optional.orElse(null);
    if (this.createdByRef == value) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        value,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MalwareAnalysisSdo#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final MalwareAnalysis withCreated(StixInstant value) {
    if (this.created == value) return this;
    StixInstant newValue = Objects.requireNonNull(value, "created");
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        newValue,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MalwareAnalysisSdo#getLang() lang} attribute.
   * @param value The value for lang
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withLang(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "lang");
    if (Objects.equals(this.lang, newValue)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        newValue,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MalwareAnalysisSdo#getLang() lang} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for lang
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withLang(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.lang, value)) return this;
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        value,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getExternalReferences() externalReferences}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withExternalReferences(ExternalReferenceType... elements) {
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getExternalReferences() externalReferences}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of externalReferences elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
    if (this.externalReferences == elements) return this;
    ImmutableSet<ExternalReferenceType> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        newValue,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getObjectMarkingRefs() objectMarkingRefs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withObjectMarkingRefs(MarkingDefinitionDm... elements) {
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getObjectMarkingRefs() objectMarkingRefs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objectMarkingRefs elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
    if (this.objectMarkingRefs == elements) return this;
    ImmutableSet<MarkingDefinitionDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        newValue,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getGranularMarkings() granularMarkings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withGranularMarkings(GranularMarkingDm... elements) {
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getGranularMarkings() granularMarkings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of granularMarkings elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
    if (this.granularMarkings == elements) return this;
    ImmutableSet<GranularMarkingDm> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        newValue,
        this.customProperties,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by replacing the {@link MalwareAnalysisSdo#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        newValue,
        this.labels,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withLabels(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        newValue,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MalwareAnalysisSdo#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final MalwareAnalysis withLabels(Iterable<String> elements) {
    if (this.labels == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        newValue,
        this.modified,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MalwareAnalysisSdo#getModified() modified} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modified
   * @return A modified copy of the {@code this} object
   */
  public final MalwareAnalysis withModified(StixInstant value) {
    if (this.modified == value) return this;
    StixInstant newValue = Objects.requireNonNull(value, "modified");
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        newValue,
        this.revoked));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MalwareAnalysisSdo#getRevoked() revoked} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revoked
   * @return A modified copy of the {@code this} object
   */
  public final MalwareAnalysis withRevoked(StixBoolean value) {
    if (this.revoked == value) return this;
    StixBoolean newValue = Objects.requireNonNull(value, "revoked");
    return validate(new MalwareAnalysis(
        this.product,
        this.version,
        this.hostVmRef,
        this.operatingSystemRef,
        this.installedSoftwareRefs,
        this.configurationVersion,
        this.module,
        this.analysisEngineVersion,
        this.analysisDefinitionVersion,
        this.submitted,
        this.analysisStarted,
        this.analysisEnded,
        this.avResult,
        this.analysisScoRefs,
        this.sampleRef,
        this.relationships,
        this.hydrated,
        this.type,
        this.id,
        this.createdByRef,
        this.created,
        this.lang,
        this.externalReferences,
        this.objectMarkingRefs,
        this.granularMarkings,
        this.customProperties,
        this.labels,
        this.modified,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code MalwareAnalysis} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof MalwareAnalysis
        && equalTo((MalwareAnalysis) another);
  }

  private boolean equalTo(MalwareAnalysis another) {
    return Objects.equals(product, another.product)
        && Objects.equals(version, another.version)
        && Objects.equals(hostVmRef, another.hostVmRef)
        && Objects.equals(operatingSystemRef, another.operatingSystemRef)
        && installedSoftwareRefs.equals(another.installedSoftwareRefs)
        && Objects.equals(configurationVersion, another.configurationVersion)
        && Objects.equals(module, another.module)
        && Objects.equals(analysisEngineVersion, another.analysisEngineVersion)
        && Objects.equals(analysisDefinitionVersion, another.analysisDefinitionVersion)
        && Objects.equals(submitted, another.submitted)
        && Objects.equals(analysisStarted, another.analysisStarted)
        && Objects.equals(analysisEnded, another.analysisEnded)
        && Objects.equals(avResult, another.avResult)
        && analysisScoRefs.equals(another.analysisScoRefs)
        && Objects.equals(sampleRef, another.sampleRef)
        && relationships.equals(another.relationships)
        && hydrated == another.hydrated
        && Objects.equals(type, another.type)
        && Objects.equals(id, another.id)
        && Objects.equals(createdByRef, another.createdByRef)
        && created.equals(another.created)
        && Objects.equals(lang, another.lang)
        && externalReferences.equals(another.externalReferences)
        && objectMarkingRefs.equals(another.objectMarkingRefs)
        && granularMarkings.equals(another.granularMarkings)
        && customProperties.equals(another.customProperties)
        && labels.equals(another.labels)
        && modified.equals(another.modified)
        && revoked.equals(another.revoked);
  }

  /**
   * Computes a hash code from attributes: {@code product}, {@code version}, {@code hostVmRef}, {@code operatingSystemRef}, {@code installedSoftwareRefs}, {@code configurationVersion}, {@code module}, {@code analysisEngineVersion}, {@code analysisDefinitionVersion}, {@code submitted}, {@code analysisStarted}, {@code analysisEnded}, {@code avResult}, {@code analysisScoRefs}, {@code sampleRef}, {@code relationships}, {@code hydrated}, {@code type}, {@code id}, {@code createdByRef}, {@code created}, {@code lang}, {@code externalReferences}, {@code objectMarkingRefs}, {@code granularMarkings}, {@code customProperties}, {@code labels}, {@code modified}, {@code revoked}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(product);
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(hostVmRef);
    h += (h << 5) + Objects.hashCode(operatingSystemRef);
    h += (h << 5) + installedSoftwareRefs.hashCode();
    h += (h << 5) + Objects.hashCode(configurationVersion);
    h += (h << 5) + Objects.hashCode(module);
    h += (h << 5) + Objects.hashCode(analysisEngineVersion);
    h += (h << 5) + Objects.hashCode(analysisDefinitionVersion);
    h += (h << 5) + Objects.hashCode(submitted);
    h += (h << 5) + Objects.hashCode(analysisStarted);
    h += (h << 5) + Objects.hashCode(analysisEnded);
    h += (h << 5) + Objects.hashCode(avResult);
    h += (h << 5) + analysisScoRefs.hashCode();
    h += (h << 5) + Objects.hashCode(sampleRef);
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + Booleans.hashCode(hydrated);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(createdByRef);
    h += (h << 5) + created.hashCode();
    h += (h << 5) + Objects.hashCode(lang);
    h += (h << 5) + externalReferences.hashCode();
    h += (h << 5) + objectMarkingRefs.hashCode();
    h += (h << 5) + granularMarkings.hashCode();
    h += (h << 5) + customProperties.hashCode();
    h += (h << 5) + labels.hashCode();
    h += (h << 5) + modified.hashCode();
    h += (h << 5) + revoked.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MalwareAnalysis} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MalwareAnalysis")
        .omitNullValues()
        .add("product", product)
        .add("version", version)
        .add("hostVmRef", hostVmRef)
        .add("operatingSystemRef", operatingSystemRef)
        .add("installedSoftwareRefs", installedSoftwareRefs)
        .add("configurationVersion", configurationVersion)
        .add("module", module)
        .add("analysisEngineVersion", analysisEngineVersion)
        .add("analysisDefinitionVersion", analysisDefinitionVersion)
        .add("submitted", submitted)
        .add("analysisStarted", analysisStarted)
        .add("analysisEnded", analysisEnded)
        .add("avResult", avResult)
        .add("analysisScoRefs", analysisScoRefs)
        .add("sampleRef", sampleRef)
        .add("relationships", relationships)
        .add("hydrated", hydrated)
        .add("type", type)
        .add("id", id)
        .add("createdByRef", createdByRef)
        .add("created", created)
        .add("lang", lang)
        .add("externalReferences", externalReferences)
        .add("objectMarkingRefs", objectMarkingRefs)
        .add("granularMarkings", granularMarkings)
        .add("customProperties", customProperties)
        .add("labels", labels)
        .add("modified", modified)
        .add("revoked", revoked)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long TO_JSON_STRING_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient String toJsonString;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link MalwareAnalysisSdo#toJsonString() toJsonString} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code toJsonString} attribute
   */
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String toJsonString() {
    if ((lazyInitBitmap & TO_JSON_STRING_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TO_JSON_STRING_LAZY_INIT_BIT) == 0) {
          this.toJsonString = Objects.requireNonNull(MalwareAnalysisSdo.super.toJsonString(), "toJsonString");
          lazyInitBitmap |= TO_JSON_STRING_LAZY_INIT_BIT;
        }
      }
    }
    return toJsonString;
  }

  private static final long SPEC_VERSION_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient String specVersion;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link MalwareAnalysisSdo#getSpecVersion() specVersion} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code specVersion} attribute
   */
  @Redactable(useMask = false, redactionMask = "\u2588\u2588REDACTED\u2588\u2588")
  @Override
  public String getSpecVersion() {
    if ((lazyInitBitmap & SPEC_VERSION_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SPEC_VERSION_LAZY_INIT_BIT) == 0) {
          this.specVersion = Objects.requireNonNull(MalwareAnalysisSdo.super.getSpecVersion(), "specVersion");
          lazyInitBitmap |= SPEC_VERSION_LAZY_INIT_BIT;
        }
      }
    }
    return specVersion;
  }


  private static MalwareAnalysis validate(MalwareAnalysis instance) {
    instance.checkHydrationValidation();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link MalwareAnalysisSdo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MalwareAnalysis instance
   */
  public static MalwareAnalysis copyOf(MalwareAnalysisSdo instance) {
    if (instance instanceof MalwareAnalysis) {
      return (MalwareAnalysis) instance;
    }
    return MalwareAnalysis.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link MalwareAnalysis MalwareAnalysis}.
   * @return A new MalwareAnalysis builder
   */
  public static MalwareAnalysis.Builder builder() {
    return new MalwareAnalysis.Builder();
  }

  /**
   * Builds instances of type {@link MalwareAnalysis MalwareAnalysis}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MalwareAnalysisSdo", generator = "Immutables")
  @NotThreadSafe
  @JsonTypeName("malware-analysis")
  @JsonPropertyOrder({"type", "spec_version", "id", "created_by_ref", "created", "modified", "revoked", "labels", "confidence", "external_references", "object_marking_refs", "granular_markings", "product", "version", "host_vm_ref", "operating_system_ref", "installed_software_refs", "configuration_version", "module", "analysis_engine_version", "analysis_definition_version", "submitted", "analysis_started", "analysis_ended", "av_result", "analysis_sco_refs", "sample_ref"})
  public static final class Builder {
    private static final long OPT_BIT_RELATIONSHIPS = 0x1L;
    private static final long OPT_BIT_HYDRATED = 0x2L;
    private static final long OPT_BIT_EXTERNAL_REFERENCES = 0x4L;
    private static final long OPT_BIT_OBJECT_MARKING_REFS = 0x8L;
    private static final long OPT_BIT_GRANULAR_MARKINGS = 0x10L;
    private static final long OPT_BIT_LABELS = 0x20L;
    private long optBits;

    private @Nullable String product;
    private @Nullable String version;
    private @Nullable String hostVmRef;
    private @Nullable String operatingSystemRef;
    private ImmutableSet.Builder<String> installedSoftwareRefs = ImmutableSet.builder();
    private @Nullable String configurationVersion;
    private @Nullable String module;
    private @Nullable String analysisEngineVersion;
    private @Nullable String analysisDefinitionVersion;
    private @Nullable StixInstant submitted;
    private @Nullable StixInstant analysisStarted;
    private @Nullable StixInstant analysisEnded;
    private @Nullable String avResult;
    private ImmutableSet.Builder<String> analysisScoRefs = ImmutableSet.builder();
    private @Nullable String sampleRef;
    private ImmutableSet.Builder<RelationshipSro> relationships = ImmutableSet.builder();
    private boolean hydrated;
    private @Nullable String type;
    private @Nullable String id;
    private @Nullable IdentitySdo createdByRef;
    private @Nullable StixInstant created;
    private @Nullable String lang;
    private ImmutableSet.Builder<ExternalReferenceType> externalReferences = ImmutableSet.builder();
    private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
    private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
    private ImmutableSet.Builder<String> labels = ImmutableSet.builder();
    private @Nullable StixInstant modified;
    private @Nullable StixBoolean revoked;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.bundle.BundleableObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BundleableObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCommonProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCommonProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixRevoked} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixRevoked instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixLabels} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixLabels instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixModified} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixModified instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.sdo.objects.MalwareAnalysisSdo} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MalwareAnalysisSdo instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.sdo.DomainObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DomainObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BundleableObject) {
        BundleableObject instance = (BundleableObject) object;
        if ((bits & 0x8L) == 0) {
          String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x10L;
        }
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          hydrated(instance.getHydrated());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x4L;
        }
      }
      if (object instanceof StixCommonProperties) {
        StixCommonProperties instance = (StixCommonProperties) object;
        addAllExternalReferences(instance.getExternalReferences());
        if ((bits & 0x2L) == 0) {
          hydrated(instance.getHydrated());
          bits |= 0x2L;
        }
        created(instance.getCreated());
        if ((bits & 0x4L) == 0) {
          addAllGranularMarkings(instance.getGranularMarkings());
          bits |= 0x4L;
        }
        Optional<IdentitySdo> createdByRefOptional = instance.getCreatedByRef();
        if (createdByRefOptional.isPresent()) {
          createdByRef(createdByRefOptional);
        }
        if ((bits & 0x8L) == 0) {
          String idValue = instance.getId();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
          bits |= 0x10L;
        }
        if ((bits & 0x1L) == 0) {
          String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x1L;
        }
        Optional<String> langOptional = instance.getLang();
        if (langOptional.isPresent()) {
          lang(langOptional);
        }
      }
      if (object instanceof StixRevoked) {
        StixRevoked instance = (StixRevoked) object;
        revoked(instance.getRevoked());
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof StixLabels) {
        StixLabels instance = (StixLabels) object;
        addAllLabels(instance.getLabels());
      }
      if (object instanceof StixModified) {
        StixModified instance = (StixModified) object;
        modified(instance.getModified());
      }
      if (object instanceof MalwareAnalysisSdo) {
        MalwareAnalysisSdo instance = (MalwareAnalysisSdo) object;
        addAllInstalledSoftwareRefs(instance.getInstalledSoftwareRefs());
        String productValue = instance.getProduct();
        if (productValue != null) {
          product(productValue);
        }
        Optional<String> analysisDefinitionVersionOptional = instance.getAnalysisDefinitionVersion();
        if (analysisDefinitionVersionOptional.isPresent()) {
          analysisDefinitionVersion(analysisDefinitionVersionOptional);
        }
        Optional<String> analysisEngineVersionOptional = instance.getAnalysisEngineVersion();
        if (analysisEngineVersionOptional.isPresent()) {
          analysisEngineVersion(analysisEngineVersionOptional);
        }
        Optional<String> moduleOptional = instance.getModule();
        if (moduleOptional.isPresent()) {
          module(moduleOptional);
        }
        Optional<String> hostVmRefOptional = instance.getHostVmRef();
        if (hostVmRefOptional.isPresent()) {
          hostVmRef(hostVmRefOptional);
        }
        Optional<String> operatingSystemRefOptional = instance.getOperatingSystemRef();
        if (operatingSystemRefOptional.isPresent()) {
          operatingSystemRef(operatingSystemRefOptional);
        }
        Optional<String> versionOptional = instance.getVersion();
        if (versionOptional.isPresent()) {
          version(versionOptional);
        }
        addAllAnalysisScoRefs(instance.getAnalysisScoRefs());
        Optional<String> configurationVersionOptional = instance.getConfigurationVersion();
        if (configurationVersionOptional.isPresent()) {
          configurationVersion(configurationVersionOptional);
        }
        Optional<StixInstant> submittedOptional = instance.getSubmitted();
        if (submittedOptional.isPresent()) {
          submitted(submittedOptional);
        }
        Optional<String> avResultOptional = instance.getAvResult();
        if (avResultOptional.isPresent()) {
          avResult(avResultOptional);
        }
        Optional<StixInstant> analysisEndedOptional = instance.getAnalysisEnded();
        if (analysisEndedOptional.isPresent()) {
          analysisEnded(analysisEndedOptional);
        }
        Optional<StixInstant> analysisStartedOptional = instance.getAnalysisStarted();
        if (analysisStartedOptional.isPresent()) {
          analysisStarted(analysisStartedOptional);
        }
        Optional<String> sampleRefOptional = instance.getSampleRef();
        if (sampleRefOptional.isPresent()) {
          sampleRef(sampleRefOptional);
        }
      }
      if (object instanceof DomainObject) {
        DomainObject instance = (DomainObject) object;
        addAllRelationships(instance.getRelationships());
      }
    }

    /**
     * Initializes the value for the {@link MalwareAnalysisSdo#getProduct() product} attribute.
     * @param product The value for product (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("product")
    @JsonPropertyDescription("The name of the analysis product that was used to perform the analysis.")
    public final Builder product(String product) {
      this.product = product;
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getVersion() version} to version.
     * @param version The value for version
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getVersion() version} to version.
     * @param version The value for version
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The version of the analysis product that was used to perform the analysis.")
    public final Builder version(Optional<String> version) {
      this.version = version.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getHostVmRef() hostVmRef} to hostVmRef.
     * @param hostVmRef The value for hostVmRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hostVmRef(String hostVmRef) {
      this.hostVmRef = Objects.requireNonNull(hostVmRef, "hostVmRef");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getHostVmRef() hostVmRef} to hostVmRef.
     * @param hostVmRef The value for hostVmRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("host_vm_ref")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A reference to a SCO Software object for the VM that hosted the malware during the analysis.")
    public final Builder hostVmRef(Optional<String> hostVmRef) {
      this.hostVmRef = hostVmRef.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getOperatingSystemRef() operatingSystemRef} to operatingSystemRef.
     * @param operatingSystemRef The value for operatingSystemRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder operatingSystemRef(String operatingSystemRef) {
      this.operatingSystemRef = Objects.requireNonNull(operatingSystemRef, "operatingSystemRef");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getOperatingSystemRef() operatingSystemRef} to operatingSystemRef.
     * @param operatingSystemRef The value for operatingSystemRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("operating_system_ref")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A reference to a SCO Software object for the operating system used for the analysis VM.")
    public final Builder operatingSystemRef(Optional<String> operatingSystemRef) {
      this.operatingSystemRef = operatingSystemRef.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link MalwareAnalysisSdo#getInstalledSoftwareRefs() installedSoftwareRefs} set.
     * @param element A installedSoftwareRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInstalledSoftwareRef(@Nullable String element) {
      this.installedSoftwareRefs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getInstalledSoftwareRefs() installedSoftwareRefs} set.
     * @param elements An array of installedSoftwareRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInstalledSoftwareRefs(String... elements) {
      this.installedSoftwareRefs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MalwareAnalysisSdo#getInstalledSoftwareRefs() installedSoftwareRefs} set.
     * @param elements An iterable of installedSoftwareRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installed_software_refs")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A list of references to SCO Software objects for the operating system software installed on the analysis VM.")
    public final Builder installedSoftwareRefs(Iterable<String> elements) {
      this.installedSoftwareRefs = ImmutableSet.builder();
      return addAllInstalledSoftwareRefs(elements);
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getInstalledSoftwareRefs() installedSoftwareRefs} set.
     * @param elements An iterable of installedSoftwareRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInstalledSoftwareRefs(Iterable<String> elements) {
      this.installedSoftwareRefs.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getConfigurationVersion() configurationVersion} to configurationVersion.
     * @param configurationVersion The value for configurationVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder configurationVersion(String configurationVersion) {
      this.configurationVersion = Objects.requireNonNull(configurationVersion, "configurationVersion");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getConfigurationVersion() configurationVersion} to configurationVersion.
     * @param configurationVersion The value for configurationVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("configuration_version")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The version of the configuration used for the analysis.")
    public final Builder configurationVersion(Optional<String> configurationVersion) {
      this.configurationVersion = configurationVersion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getModule() module} to module.
     * @param module The value for module
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder module(String module) {
      this.module = Objects.requireNonNull(module, "module");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getModule() module} to module.
     * @param module The value for module
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("module")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The name of the specific analysis module that was used, if different from the product.")
    public final Builder module(Optional<String> module) {
      this.module = module.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getAnalysisEngineVersion() analysisEngineVersion} to analysisEngineVersion.
     * @param analysisEngineVersion The value for analysisEngineVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder analysisEngineVersion(String analysisEngineVersion) {
      this.analysisEngineVersion = Objects.requireNonNull(analysisEngineVersion, "analysisEngineVersion");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getAnalysisEngineVersion() analysisEngineVersion} to analysisEngineVersion.
     * @param analysisEngineVersion The value for analysisEngineVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("analysis_engine_version")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The version of the analysis engine or runtime environment.")
    public final Builder analysisEngineVersion(Optional<String> analysisEngineVersion) {
      this.analysisEngineVersion = analysisEngineVersion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getAnalysisDefinitionVersion() analysisDefinitionVersion} to analysisDefinitionVersion.
     * @param analysisDefinitionVersion The value for analysisDefinitionVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder analysisDefinitionVersion(String analysisDefinitionVersion) {
      this.analysisDefinitionVersion = Objects.requireNonNull(analysisDefinitionVersion, "analysisDefinitionVersion");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getAnalysisDefinitionVersion() analysisDefinitionVersion} to analysisDefinitionVersion.
     * @param analysisDefinitionVersion The value for analysisDefinitionVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("analysis_definition_version")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The version of the analysis definitions used (e.g., virus definition version).")
    public final Builder analysisDefinitionVersion(Optional<String> analysisDefinitionVersion) {
      this.analysisDefinitionVersion = analysisDefinitionVersion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getSubmitted() submitted} to submitted.
     * @param submitted The value for submitted
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder submitted(StixInstant submitted) {
      this.submitted = Objects.requireNonNull(submitted, "submitted");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getSubmitted() submitted} to submitted.
     * @param submitted The value for submitted
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("submitted")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The date and time that the malware sample was submitted for analysis.")
    public final Builder submitted(Optional<? extends StixInstant> submitted) {
      this.submitted = submitted.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getAnalysisStarted() analysisStarted} to analysisStarted.
     * @param analysisStarted The value for analysisStarted
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder analysisStarted(StixInstant analysisStarted) {
      this.analysisStarted = Objects.requireNonNull(analysisStarted, "analysisStarted");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getAnalysisStarted() analysisStarted} to analysisStarted.
     * @param analysisStarted The value for analysisStarted
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("analysis_started")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The date and time that the malware analysis started.")
    public final Builder analysisStarted(Optional<? extends StixInstant> analysisStarted) {
      this.analysisStarted = analysisStarted.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getAnalysisEnded() analysisEnded} to analysisEnded.
     * @param analysisEnded The value for analysisEnded
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder analysisEnded(StixInstant analysisEnded) {
      this.analysisEnded = Objects.requireNonNull(analysisEnded, "analysisEnded");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getAnalysisEnded() analysisEnded} to analysisEnded.
     * @param analysisEnded The value for analysisEnded
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("analysis_ended")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The date and time that the malware analysis ended.")
    public final Builder analysisEnded(Optional<? extends StixInstant> analysisEnded) {
      this.analysisEnded = analysisEnded.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getAvResult() avResult} to avResult.
     * @param avResult The value for avResult
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder avResult(String avResult) {
      this.avResult = Objects.requireNonNull(avResult, "avResult");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getAvResult() avResult} to avResult.
     * @param avResult The value for avResult
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("av_result")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The result of the anti-virus analysis. Open vocabulary - malware-av-result-ov")
    public final Builder avResult(Optional<String> avResult) {
      this.avResult = avResult.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link MalwareAnalysisSdo#getAnalysisScoRefs() analysisScoRefs} set.
     * @param element A analysisScoRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAnalysisScoRef(@Nullable String element) {
      this.analysisScoRefs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getAnalysisScoRefs() analysisScoRefs} set.
     * @param elements An array of analysisScoRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAnalysisScoRefs(String... elements) {
      this.analysisScoRefs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MalwareAnalysisSdo#getAnalysisScoRefs() analysisScoRefs} set.
     * @param elements An iterable of analysisScoRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("analysis_sco_refs")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A list of references to SCOs that were captured during the analysis process.")
    public final Builder analysisScoRefs(Iterable<String> elements) {
      this.analysisScoRefs = ImmutableSet.builder();
      return addAllAnalysisScoRefs(elements);
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getAnalysisScoRefs() analysisScoRefs} set.
     * @param elements An iterable of analysisScoRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAnalysisScoRefs(Iterable<String> elements) {
      this.analysisScoRefs.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getSampleRef() sampleRef} to sampleRef.
     * @param sampleRef The value for sampleRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sampleRef(String sampleRef) {
      this.sampleRef = Objects.requireNonNull(sampleRef, "sampleRef");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getSampleRef() sampleRef} to sampleRef.
     * @param sampleRef The value for sampleRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("sample_ref")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A reference to the SCO file, malware or artifact object that was analyzed.")
    public final Builder sampleRef(Optional<String> sampleRef) {
      this.sampleRef = sampleRef.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link MalwareAnalysisSdo#getRelationships() relationships} set.
     * @param element A relationships element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRelationship(@Nullable RelationshipSro element) {
      this.relationships.add(element);
      optBits |= OPT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getRelationships() relationships} set.
     * @param elements An array of relationships elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRelationships(RelationshipSro... elements) {
      this.relationships.add(elements);
      optBits |= OPT_BIT_RELATIONSHIPS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MalwareAnalysisSdo#getRelationships() relationships} set.
     * @param elements An iterable of relationships elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("relationships")
    @JsonIgnore
    public final Builder relationships(Iterable<? extends RelationshipSro> elements) {
      this.relationships = ImmutableSet.builder();
      return addAllRelationships(elements);
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getRelationships() relationships} set.
     * @param elements An iterable of relationships elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRelationships(Iterable<? extends RelationshipSro> elements) {
      this.relationships.addAll(elements);
      optBits |= OPT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Initializes the value for the {@link MalwareAnalysisSdo#getHydrated() hydrated} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MalwareAnalysisSdo#getHydrated() hydrated}.</em>
     * @param hydrated The value for hydrated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    public final Builder hydrated(boolean hydrated) {
      this.hydrated = hydrated;
      optBits |= OPT_BIT_HYDRATED;
      return this;
    }

    /**
     * Initializes the value for the {@link MalwareAnalysisSdo#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    @JsonPropertyDescription("The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link MalwareAnalysisSdo#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    public final Builder id(String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder createdByRef(IdentitySdo createdByRef) {
      this.createdByRef = Objects.requireNonNull(createdByRef, "createdByRef");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getCreatedByRef() createdByRef} to createdByRef.
     * @param createdByRef The value for createdByRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created_by_ref")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
    @JsonIdentityReference(alwaysAsId = true)
    @JsonDeserialize(converter = DomainObjectOptionalConverter.class)
    public final Builder createdByRef(Optional<? extends IdentitySdo> createdByRef) {
      this.createdByRef = createdByRef.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MalwareAnalysisSdo#getCreated() created} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MalwareAnalysisSdo#getCreated() created}.</em>
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    @JsonPropertyDescription("The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
    public final Builder created(StixInstant created) {
      this.created = Objects.requireNonNull(created, "created");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getLang() lang} to lang.
     * @param lang The value for lang
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder lang(String lang) {
      this.lang = Objects.requireNonNull(lang, "lang");
      return this;
    }

    /**
     * Initializes the optional value {@link MalwareAnalysisSdo#getLang() lang} to lang.
     * @param lang The value for lang
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lang")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Identifies the language of the text content in this object using ISO 639-2 language codes.")
    public final Builder lang(Optional<String> lang) {
      this.lang = lang.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link MalwareAnalysisSdo#getExternalReferences() externalReferences} set.
     * @param element A externalReferences element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReference(@Nullable ExternalReferenceType element) {
      this.externalReferences.add(element);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getExternalReferences() externalReferences} set.
     * @param elements An array of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExternalReferences(ExternalReferenceType... elements) {
      this.externalReferences.add(elements);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MalwareAnalysisSdo#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("external_references")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A list of external references which refers to non-STIX information.")
    public final Builder externalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences = ImmutableSet.builder();
      return addAllExternalReferences(elements);
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getExternalReferences() externalReferences} set.
     * @param elements An iterable of externalReferences elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExternalReferences(Iterable<? extends ExternalReferenceType> elements) {
      this.externalReferences.addAll(elements);
      optBits |= OPT_BIT_EXTERNAL_REFERENCES;
      return this;
    }

    /**
     * Adds one element to {@link MalwareAnalysisSdo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param element A objectMarkingRefs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
      this.objectMarkingRefs.add(element);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An array of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addObjectMarkingRefs(MarkingDefinitionDm... elements) {
      this.objectMarkingRefs.add(elements);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MalwareAnalysisSdo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("object_marking_refs")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The list of marking-definition objects to be applied to this object.")
    @JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "id")
    @JsonIdentityReference(alwaysAsId = true)
    @JsonDeserialize(converter = MarkingDefinitionSetConverter.class)
    public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs = ImmutableSet.builder();
      return addAllObjectMarkingRefs(elements);
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getObjectMarkingRefs() objectMarkingRefs} set.
     * @param elements An iterable of objectMarkingRefs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
      this.objectMarkingRefs.addAll(elements);
      optBits |= OPT_BIT_OBJECT_MARKING_REFS;
      return this;
    }

    /**
     * Adds one element to {@link MalwareAnalysisSdo#getGranularMarkings() granularMarkings} set.
     * @param element A granularMarkings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
      this.granularMarkings.add(element);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getGranularMarkings() granularMarkings} set.
     * @param elements An array of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGranularMarkings(GranularMarkingDm... elements) {
      this.granularMarkings.add(elements);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MalwareAnalysisSdo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("granular_markings")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The set of granular markings that apply to this object.")
    public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings = ImmutableSet.builder();
      return addAllGranularMarkings(elements);
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getGranularMarkings() granularMarkings} set.
     * @param elements An iterable of granularMarkings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
      this.granularMarkings.addAll(elements);
      optBits |= OPT_BIT_GRANULAR_MARKINGS;
      return this;
    }

    /**
     * Put one entry to the {@link MalwareAnalysisSdo#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link MalwareAnalysisSdo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MalwareAnalysisSdo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MalwareAnalysisSdo#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link MalwareAnalysisSdo#getLabels() labels} set.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabel(@Nullable String element) {
      this.labels.add(element);
      optBits |= OPT_BIT_LABELS;
      return this;
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getLabels() labels} set.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(String... elements) {
      this.labels.add(elements);
      optBits |= OPT_BIT_LABELS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MalwareAnalysisSdo#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labels")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The labels property specifies a set of classifications.")
    public final Builder labels(Iterable<String> elements) {
      this.labels = ImmutableSet.builder();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link MalwareAnalysisSdo#getLabels() labels} set.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<String> elements) {
      this.labels.addAll(elements);
      optBits |= OPT_BIT_LABELS;
      return this;
    }

    /**
     * Initializes the value for the {@link MalwareAnalysisSdo#getModified() modified} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MalwareAnalysisSdo#getModified() modified}.</em>
     * @param modified The value for modified 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("modified")
    @JsonPropertyDescription("The modified property represents the time that this particular version of the object was created. The timstamp value MUST be precise to the nearest millisecond.")
    public final Builder modified(StixInstant modified) {
      this.modified = Objects.requireNonNull(modified, "modified");
      return this;
    }

    /**
     * Initializes the value for the {@link MalwareAnalysisSdo#getRevoked() revoked} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MalwareAnalysisSdo#getRevoked() revoked}.</em>
     * @param revoked The value for revoked 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("revoked")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("The revoked property indicates whether the object has been revoked.")
    public final Builder revoked(StixBoolean revoked) {
      this.revoked = Objects.requireNonNull(revoked, "revoked");
      return this;
    }

    /**
     * Builds a new {@link MalwareAnalysis MalwareAnalysis}.
     * @return An immutable instance of MalwareAnalysis
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public MalwareAnalysis build() {
      return MalwareAnalysis.validate(new MalwareAnalysis(this));
    }

    private boolean relationshipsIsSet() {
      return (optBits & OPT_BIT_RELATIONSHIPS) != 0;
    }

    private boolean hydratedIsSet() {
      return (optBits & OPT_BIT_HYDRATED) != 0;
    }

    private boolean externalReferencesIsSet() {
      return (optBits & OPT_BIT_EXTERNAL_REFERENCES) != 0;
    }

    private boolean objectMarkingRefsIsSet() {
      return (optBits & OPT_BIT_OBJECT_MARKING_REFS) != 0;
    }

    private boolean granularMarkingsIsSet() {
      return (optBits & OPT_BIT_GRANULAR_MARKINGS) != 0;
    }

    private boolean labelsIsSet() {
      return (optBits & OPT_BIT_LABELS) != 0;
    }
  }
}
