package security.whisper.javastix.sdo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;

/**
 * external-reference
 * <p>
 * External references are used to describe pointers to information represented outside of STIX.
 * 
 */
@Generated(from = "ExternalReferenceType", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ExternalReference implements ExternalReferenceType {
  private final String sourceName;
  private final @Nullable String description;
  private final @Nullable String url;
  private final ImmutableMap<String, String> hashes;
  private final @Nullable String externalId;
  private final ImmutableMap<String, Object> customProperties;

  private ExternalReference(
      String sourceName,
      @Nullable String description,
      @Nullable String url,
      ImmutableMap<String, String> hashes,
      @Nullable String externalId,
      ImmutableMap<String, Object> customProperties) {
    this.sourceName = sourceName;
    this.description = description;
    this.url = url;
    this.hashes = hashes;
    this.externalId = externalId;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code sourceName} attribute
   */
  @JsonProperty("source_name")
  @JsonPropertyDescription("The source within which the external-reference is defined (system, registry, organization, etc.)")
  @Override
  public String getSourceName() {
    return sourceName;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("A human readable description")
  @Override
  public Optional<String> getDescription() {
    return Optional.ofNullable(description);
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty("url")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Matches the elements of a URL using a regular expression. Uses Diego Perini\'s regex from https://gist.github.com/dperini/729294.")
  @Override
  public Optional<String> getUrl() {
    return Optional.ofNullable(url);
  }

  /**
   * @return The value of the {@code hashes} attribute
   */
  @JsonProperty("hashes")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("Specifies a dictionary of hashes for the file.")
  @Override
  public ImmutableMap<String, String> getHashes() {
    return hashes;
  }

  /**
   * @return The value of the {@code externalId} attribute
   */
  @JsonProperty("external_id")
  @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
  @JsonPropertyDescription("An identifier for the external reference content")
  @Override
  public Optional<String> getExternalId() {
    return Optional.ofNullable(externalId);
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExternalReferenceType#getSourceName() sourceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sourceName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ExternalReference withSourceName(String value) {
    if (Objects.equals(this.sourceName, value)) return this;
    return validate(new ExternalReference(value, this.description, this.url, this.hashes, this.externalId, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExternalReferenceType#getDescription() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ExternalReference withDescription(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return validate(new ExternalReference(this.sourceName, newValue, this.url, this.hashes, this.externalId, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExternalReferenceType#getDescription() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ExternalReference withDescription(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return validate(new ExternalReference(this.sourceName, value, this.url, this.hashes, this.externalId, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExternalReferenceType#getUrl() url} attribute.
   * @param value The value for url
   * @return A modified copy of {@code this} object
   */
  public final ExternalReference withUrl(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "url");
    if (Objects.equals(this.url, newValue)) return this;
    return validate(new ExternalReference(
        this.sourceName,
        this.description,
        newValue,
        this.hashes,
        this.externalId,
        this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExternalReferenceType#getUrl() url} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for url
   * @return A modified copy of {@code this} object
   */
  public final ExternalReference withUrl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.url, value)) return this;
    return validate(new ExternalReference(this.sourceName, this.description, value, this.hashes, this.externalId, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link ExternalReferenceType#getHashes() hashes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the hashes map
   * @return A modified copy of {@code this} object
   */
  public final ExternalReference withHashes(Map<String, ? extends String> entries) {
    if (this.hashes == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return validate(new ExternalReference(this.sourceName, this.description, this.url, newValue, this.externalId, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExternalReferenceType#getExternalId() externalId} attribute.
   * @param value The value for externalId
   * @return A modified copy of {@code this} object
   */
  public final ExternalReference withExternalId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "externalId");
    if (Objects.equals(this.externalId, newValue)) return this;
    return validate(new ExternalReference(this.sourceName, this.description, this.url, this.hashes, newValue, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExternalReferenceType#getExternalId() externalId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for externalId
   * @return A modified copy of {@code this} object
   */
  public final ExternalReference withExternalId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.externalId, value)) return this;
    return validate(new ExternalReference(this.sourceName, this.description, this.url, this.hashes, value, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link ExternalReferenceType#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final ExternalReference withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new ExternalReference(this.sourceName, this.description, this.url, this.hashes, this.externalId, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ExternalReference} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ExternalReference
        && equalTo((ExternalReference) another);
  }

  private boolean equalTo(ExternalReference another) {
    return Objects.equals(sourceName, another.sourceName)
        && Objects.equals(description, another.description)
        && Objects.equals(url, another.url)
        && hashes.equals(another.hashes)
        && Objects.equals(externalId, another.externalId)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code sourceName}, {@code description}, {@code url}, {@code hashes}, {@code externalId}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sourceName);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + hashes.hashCode();
    h += (h << 5) + Objects.hashCode(externalId);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExternalReference} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExternalReference")
        .omitNullValues()
        .add("sourceName", sourceName)
        .add("description", description)
        .add("url", url)
        .add("hashes", hashes)
        .add("externalId", externalId)
        .add("customProperties", customProperties)
        .toString();
  }


  private static ExternalReference validate(ExternalReference instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ExternalReferenceType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExternalReference instance
   */
  public static ExternalReference copyOf(ExternalReferenceType instance) {
    if (instance instanceof ExternalReference) {
      return (ExternalReference) instance;
    }
    return ExternalReference.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link ExternalReference ExternalReference}.
   * @return A new ExternalReference builder
   */
  public static ExternalReference.Builder builder() {
    return new ExternalReference.Builder();
  }

  /**
   * Builds instances of type {@link ExternalReference ExternalReference}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExternalReferenceType", generator = "Immutables")
  @NotThreadSafe
  @JsonPropertyOrder({"source_name", "description", "url", "hashes", "external_id"})
  public static final class Builder {
    private @Nullable String sourceName;
    private @Nullable String description;
    private @Nullable String url;
    private ImmutableMap.Builder<String, String> hashes = ImmutableMap.builder();
    private @Nullable String externalId;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.sdo.types.ExternalReferenceType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ExternalReferenceType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
      if (object instanceof ExternalReferenceType) {
        ExternalReferenceType instance = (ExternalReferenceType) object;
        putAllHashes(instance.getHashes());
        Optional<String> descriptionOptional = instance.getDescription();
        if (descriptionOptional.isPresent()) {
          description(descriptionOptional);
        }
        Optional<String> externalIdOptional = instance.getExternalId();
        if (externalIdOptional.isPresent()) {
          externalId(externalIdOptional);
        }
        String sourceNameValue = instance.getSourceName();
        if (sourceNameValue != null) {
          sourceName(sourceNameValue);
        }
        Optional<String> urlOptional = instance.getUrl();
        if (urlOptional.isPresent()) {
          url(urlOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link ExternalReferenceType#getSourceName() sourceName} attribute.
     * @param sourceName The value for sourceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("source_name")
    @JsonPropertyDescription("The source within which the external-reference is defined (system, registry, organization, etc.)")
    public final Builder sourceName(String sourceName) {
      this.sourceName = sourceName;
      return this;
    }

    /**
     * Initializes the optional value {@link ExternalReferenceType#getDescription() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link ExternalReferenceType#getDescription() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("A human readable description")
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ExternalReferenceType#getUrl() url} to url.
     * @param url The value for url
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder url(String url) {
      this.url = Objects.requireNonNull(url, "url");
      return this;
    }

    /**
     * Initializes the optional value {@link ExternalReferenceType#getUrl() url} to url.
     * @param url The value for url
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("url")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Matches the elements of a URL using a regular expression. Uses Diego Perini\'s regex from https://gist.github.com/dperini/729294.")
    public final Builder url(Optional<String> url) {
      this.url = url.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link ExternalReferenceType#getHashes() hashes} map.
     * @param key The key in the hashes map
     * @param value The associated value in the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHash(String key, String value) {
      this.hashes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ExternalReferenceType#getHashes() hashes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putHash(Map.Entry<String, ? extends String> entry) {
      this.hashes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ExternalReferenceType#getHashes() hashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hashes")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("Specifies a dictionary of hashes for the file.")
    public final Builder hashes(Map<String, ? extends String> entries) {
      this.hashes = ImmutableMap.builder();
      return putAllHashes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ExternalReferenceType#getHashes() hashes} map. Nulls are not permitted
     * @param entries The entries that will be added to the hashes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllHashes(Map<String, ? extends String> entries) {
      this.hashes.putAll(entries);
      return this;
    }

    /**
     * Initializes the optional value {@link ExternalReferenceType#getExternalId() externalId} to externalId.
     * @param externalId The value for externalId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder externalId(String externalId) {
      this.externalId = Objects.requireNonNull(externalId, "externalId");
      return this;
    }

    /**
     * Initializes the optional value {@link ExternalReferenceType#getExternalId() externalId} to externalId.
     * @param externalId The value for externalId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("external_id")
    @JsonInclude(value = JsonInclude.Include.NON_EMPTY, content = JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription("An identifier for the external reference content")
    public final Builder externalId(Optional<String> externalId) {
      this.externalId = externalId.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link ExternalReferenceType#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ExternalReferenceType#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ExternalReferenceType#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ExternalReferenceType#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ExternalReference ExternalReference}.
     * @return An immutable instance of ExternalReference
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ExternalReference build() {
      return ExternalReference.validate(new ExternalReference(sourceName, description, url, hashes.build(), externalId, customProperties.build()));
    }
  }
}
