package security.whisper.javastix.sdo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;

/**
 * kill-chain-phase
 * <p>
 * The kill-chain-phase represents a phase in a kill chain.
 */
@Generated(from = "KillChainPhaseType", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class KillChainPhase implements KillChainPhaseType {
  private final String killChainName;
  private final String phaseName;
  private final ImmutableMap<String, Object> customProperties;

  private KillChainPhase(
      String killChainName,
      String phaseName,
      ImmutableMap<String, Object> customProperties) {
    this.killChainName = killChainName;
    this.phaseName = phaseName;
    this.customProperties = customProperties;
  }

  /**
   * @return The value of the {@code killChainName} attribute
   */
  @JsonProperty("kill_chain_name")
  @JsonPropertyDescription("The name of the kill chain.")
  @Override
  public String killChainName() {
    return killChainName;
  }

  /**
   * @return The value of the {@code phaseName} attribute
   */
  @JsonProperty("phase_name")
  @JsonPropertyDescription("The name of the phase in the kill chain.")
  @Override
  public String phaseName() {
    return phaseName;
  }

  /**
   * Custom Properties for STIX Objects.
   * Any object that supports custom properties will have a validation of the custom property prefix (typically "x_").
   * If the additional property in the JSON does not meet the StartsWith condition, then the JSON will be rejected.
   * @return Map of custom properties {@code Map<String, Object>}
   */
  @JsonProperty(access = JsonProperty.Access.READ_ONLY)
  @JsonUnwrapped
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, Object> getCustomProperties() {
    return customProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KillChainPhaseType#killChainName() killChainName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for killChainName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final KillChainPhase withKillChainName(String value) {
    if (Objects.equals(this.killChainName, value)) return this;
    return validate(new KillChainPhase(value, this.phaseName, this.customProperties));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KillChainPhaseType#phaseName() phaseName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for phaseName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final KillChainPhase withPhaseName(String value) {
    if (Objects.equals(this.phaseName, value)) return this;
    return validate(new KillChainPhase(this.killChainName, value, this.customProperties));
  }

  /**
   * Copy the current immutable object by replacing the {@link KillChainPhaseType#getCustomProperties() customProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customProperties map
   * @return A modified copy of {@code this} object
   */
  public final KillChainPhase withCustomProperties(Map<String, ? extends Object> entries) {
    if (this.customProperties == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return validate(new KillChainPhase(this.killChainName, this.phaseName, newValue));
  }

  /**
   * This instance is equal to all instances of {@code KillChainPhase} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof KillChainPhase
        && equalTo((KillChainPhase) another);
  }

  private boolean equalTo(KillChainPhase another) {
    return Objects.equals(killChainName, another.killChainName)
        && Objects.equals(phaseName, another.phaseName)
        && customProperties.equals(another.customProperties);
  }

  /**
   * Computes a hash code from attributes: {@code killChainName}, {@code phaseName}, {@code customProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(killChainName);
    h += (h << 5) + Objects.hashCode(phaseName);
    h += (h << 5) + customProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code KillChainPhase} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("KillChainPhase")
        .omitNullValues()
        .add("killChainName", killChainName)
        .add("phaseName", phaseName)
        .add("customProperties", customProperties)
        .toString();
  }


  private static KillChainPhase validate(KillChainPhase instance) {
    instance.validateEntity();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link KillChainPhaseType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable KillChainPhase instance
   */
  public static KillChainPhase copyOf(KillChainPhaseType instance) {
    if (instance instanceof KillChainPhase) {
      return (KillChainPhase) instance;
    }
    return KillChainPhase.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = 1L;

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link KillChainPhase KillChainPhase}.
   * @return A new KillChainPhase builder
   */
  public static KillChainPhase.Builder builder() {
    return new KillChainPhase.Builder();
  }

  /**
   * Builds instances of type {@link KillChainPhase KillChainPhase}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "KillChainPhaseType", generator = "Immutables")
  @NotThreadSafe
  @JsonPropertyOrder({"kill_chain_name", "phase_name"})
  public static final class Builder {
    private @Nullable String killChainName;
    private @Nullable String phaseName;
    private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.sdo.types.KillChainPhaseType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(KillChainPhaseType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code security.whisper.javastix.common.StixCustomProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StixCustomProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof KillChainPhaseType) {
        KillChainPhaseType instance = (KillChainPhaseType) object;
        String killChainNameValue = instance.killChainName();
        if (killChainNameValue != null) {
          killChainName(killChainNameValue);
        }
        String phaseNameValue = instance.phaseName();
        if (phaseNameValue != null) {
          phaseName(phaseNameValue);
        }
      }
      if (object instanceof StixCustomProperties) {
        StixCustomProperties instance = (StixCustomProperties) object;
        putAllCustomProperties(instance.getCustomProperties());
      }
    }

    /**
     * Initializes the value for the {@link KillChainPhaseType#killChainName() killChainName} attribute.
     * @param killChainName The value for killChainName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("kill_chain_name")
    @JsonPropertyDescription("The name of the kill chain.")
    public final Builder killChainName(String killChainName) {
      this.killChainName = killChainName;
      return this;
    }

    /**
     * Initializes the value for the {@link KillChainPhaseType#phaseName() phaseName} attribute.
     * @param phaseName The value for phaseName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("phase_name")
    @JsonPropertyDescription("The name of the phase in the kill chain.")
    public final Builder phaseName(String phaseName) {
      this.phaseName = phaseName;
      return this;
    }

    /**
     * Put one entry to the {@link KillChainPhaseType#getCustomProperties() customProperties} map.
     * @param key The key in the customProperties map
     * @param value The associated value in the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putCustomProperty(String key, Object value) {
      this.customProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link KillChainPhaseType#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
      this.customProperties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link KillChainPhaseType#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    public final Builder customProperties(Map<String, ? extends Object> entries) {
      this.customProperties = ImmutableMap.builder();
      return putAllCustomProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link KillChainPhaseType#getCustomProperties() customProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the customProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
      this.customProperties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link KillChainPhase KillChainPhase}.
     * @return An immutable instance of KillChainPhase
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public KillChainPhase build() {
      return KillChainPhase.validate(new KillChainPhase(killChainName, phaseName, customProperties.build()));
    }
  }
}
