package security.whisper.javastix.vocabulary.vocabularies;

import com.fasterxml.jackson.annotation.JsonProperty;
import security.whisper.javastix.vocabulary.StixVocabulary;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MalwareLabels implements StixVocabulary {

    @JsonProperty("malware_labels_vocabulary")
    private Set<String> terms = new HashSet<>(Arrays.asList(
            "adware", "backdoor", "bot",
            "ddos", "dropper", "exploit-kit",
            "keylogger", "ransomware", "remote-access-trojan",
            "resource-exploitation", "rogue-security-software", "rootkit",
            "screen-capture", "spyware", "trojan",
            "virus", "worm"));

    //
    // Getters and Setters
    //

    @Override
    public Set<String> getAllTerms() {
        return terms;
    }

    @Override
    public Set<String> getAllTermsWithAdditional(String[] terms) {
        return Stream.concat(getAllTerms().stream(), Arrays.stream(terms))
                .collect(Collectors.toCollection(HashSet::new));
    }
}
