package security.whisper.javastix.vocabulary.vocabularies;

import com.fasterxml.jackson.annotation.JsonProperty;
import security.whisper.javastix.vocabulary.StixVocabulary;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Malware Result is an open vocabulary used to describe the result of a malware analysis.
 * These values are derived from the STIX 2.1 specification.
 */
public class MalwareResult implements StixVocabulary {

    @JsonProperty("malware_result_vocabulary")
    private Set<String> terms = new HashSet<>(Arrays.asList(
            "malicious",
            "suspicious",
            "benign",
            "unknown"
    ));

    @Override
    public Set<String> getAllTerms() {
        return terms;
    }

    @Override
    public Set<String> getAllTermsWithAdditional(String[] terms) {
        return Stream.concat(getAllTerms().stream(), Arrays.stream(terms))
                .collect(Collectors.toCollection(HashSet::new));
    }
}