package security.whisper.javastix.vocabulary.vocabularies;

import com.fasterxml.jackson.annotation.JsonProperty;
import security.whisper.javastix.vocabulary.StixVocabulary;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * Vulnerability Types is an open vocabulary that describes types of vulnerabilities.
 * This vocabulary is used by the Vulnerability SDO to categorize vulnerabilities.
 * Based on common vulnerability categorizations like CWE and OWASP.
 */
public class VulnerabilityTypes implements StixVocabulary {

    @JsonProperty("vulnerability_types_vocabulary")
    private Set<String> terms = new HashSet<>(Arrays.asList(
            "buffer-overflow",             // Buffer overflow vulnerabilities
            "cross-site-scripting",        // XSS vulnerabilities
            "sql-injection",               // SQL injection vulnerabilities
            "denial-of-service",           // DoS vulnerabilities
            "privilege-escalation",        // Privilege escalation vulnerabilities
            "remote-code-execution",       // RCE vulnerabilities
            "information-disclosure",      // Information disclosure vulnerabilities
            "authentication-bypass",       // Authentication bypass vulnerabilities
            "cryptographic-weakness",      // Weak cryptography vulnerabilities
            "input-validation",            // Input validation vulnerabilities
            "configuration",               // Configuration vulnerabilities
            "path-traversal",              // Path traversal vulnerabilities
            "race-condition",              // Race condition vulnerabilities
            "memory-corruption",           // Memory corruption vulnerabilities
            "zero-day"                     // Zero-day vulnerabilities
    ));

    @Override
    public Set<String> getAllTerms() {
        return terms;
    }

    @Override
    public Set<String> getAllTermsWithAdditional(String[] terms) {
        return Stream.concat(getAllTerms().stream(), Arrays.stream(terms))
                .collect(Collectors.toCollection(HashSet::new));
    }
}