/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.bundle;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleObject;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="bundle")
@Generated(from="BundleObject", generator="Immutables")
@Immutable
public final class Bundle
implements BundleObject {
    private final String type;
    private final String id;
    private final String specVersion;
    private final ImmutableSet<BundleableObject> objects;
    private final ImmutableMap<String, Object> customProperties;
    private volatile transient long lazyInitBitmap;
    private static final long TO_JSON_STRING_LAZY_INIT_BIT = 1L;
    private transient String toJsonString;
    private static final long serialVersionUID = 1L;

    private Bundle(Builder builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.objects = builder.objects.build();
        this.customProperties = builder.customProperties.build();
        this.specVersion = builder.specVersion != null ? builder.specVersion : Objects.requireNonNull(BundleObject.super.getSpecVersion(), "specVersion");
    }

    private Bundle(String type, String id, String specVersion, ImmutableSet<BundleableObject> objects, ImmutableMap<String, Object> customProperties) {
        this.type = type;
        this.id = id;
        this.specVersion = specVersion;
        this.objects = objects;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="spec_version")
    @JsonPropertyDescription(value="The version of the STIX specification used to represent the content in this bundle.")
    public String getSpecVersion() {
        return this.specVersion;
    }

    @JsonProperty(value="objects", access=JsonProperty.Access.WRITE_ONLY)
    @JsonPropertyDescription(value="Specifies a set of one or more STIX Objects.")
    public ImmutableSet<BundleableObject> getObjects() {
        return this.objects;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final Bundle withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return Bundle.validate(new Bundle(value, this.id, this.specVersion, this.objects, this.customProperties));
    }

    public final Bundle withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return Bundle.validate(new Bundle(this.type, value, this.specVersion, this.objects, this.customProperties));
    }

    public final Bundle withSpecVersion(String value) {
        String newValue = Objects.requireNonNull(value, "specVersion");
        if (this.specVersion.equals(newValue)) {
            return this;
        }
        return Bundle.validate(new Bundle(this.type, this.id, newValue, this.objects, this.customProperties));
    }

    public final Bundle withObjects(BundleableObject ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return Bundle.validate(new Bundle(this.type, this.id, this.specVersion, (ImmutableSet<BundleableObject>)newValue, this.customProperties));
    }

    public final Bundle withObjects(Iterable<? extends BundleableObject> elements) {
        if (this.objects == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return Bundle.validate(new Bundle(this.type, this.id, this.specVersion, (ImmutableSet<BundleableObject>)newValue, this.customProperties));
    }

    public final Bundle withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return Bundle.validate(new Bundle(this.type, this.id, this.specVersion, this.objects, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Bundle && this.equalTo((Bundle)another);
    }

    private boolean equalTo(Bundle another) {
        return Objects.equals(this.type, another.type) && Objects.equals(this.id, another.id) && this.specVersion.equals(another.specVersion) && this.objects.equals(another.objects) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.specVersion.hashCode();
        h += (h << 5) + this.objects.hashCode();
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BundleObject").omitNullValues().add("type", (Object)this.type).add("id", (Object)this.id).add("specVersion", (Object)this.specVersion).add("objects", this.objects).add("customProperties", this.customProperties).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJsonString() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Bundle bundle = this;
            synchronized (bundle) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.toJsonString = Objects.requireNonNull(BundleObject.super.toJsonString(), "toJsonString");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.toJsonString;
    }

    private static Bundle validate(Bundle instance) {
        instance.validateEntity();
        return instance;
    }

    public static Bundle copyOf(BundleObject instance) {
        if (instance instanceof Bundle) {
            return (Bundle)instance;
        }
        return Bundle.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return Bundle.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="bundle")
    @JsonPropertyOrder(value={"type", "id", "spec_version", "objects"})
    @Generated(from="BundleObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String type;
        @Nullable
        private String id;
        @Nullable
        private String specVersion;
        private ImmutableSet.Builder<BundleableObject> objects = ImmutableSet.builder();
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StixCustomProperties instance;
            if (object instanceof BundleObject) {
                String typeValue;
                instance = (BundleObject)object;
                this.specVersion(instance.getSpecVersion());
                String idValue = instance.getId();
                if (idValue != null) {
                    this.id(idValue);
                }
                if ((typeValue = instance.getType()) != null) {
                    this.type(typeValue);
                }
                this.addAllObjects(instance.getObjects());
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
        }

        @JsonProperty(value="type")
        @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="id")
        @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="spec_version")
        @JsonPropertyDescription(value="The version of the STIX specification used to represent the content in this bundle.")
        @CanIgnoreReturnValue
        public final Builder specVersion(String specVersion) {
            this.specVersion = Objects.requireNonNull(specVersion, "specVersion");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObject(@Nullable BundleableObject element) {
            this.objects.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjects(BundleableObject ... elements) {
            this.objects.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="objects", access=JsonProperty.Access.WRITE_ONLY)
        @JsonPropertyDescription(value="Specifies a set of one or more STIX Objects.")
        @CanIgnoreReturnValue
        public final Builder objects(Iterable<? extends BundleableObject> elements) {
            this.objects = ImmutableSet.builder();
            return this.addAllObjects(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjects(Iterable<? extends BundleableObject> elements) {
            this.objects.addAll(elements);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public Bundle build() {
            return Bundle.validate(new Bundle(this));
        }
    }
}

