/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.bundle;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.bundle.Bundle;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.Stix;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.json.StixParsers;
import security.whisper.javastix.validation.GenericValidation;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="bundle", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="bundle")
@JsonSerialize(as=Bundle.class)
@JsonDeserialize(builder=Bundle.Builder.class)
@JsonPropertyOrder(value={"type", "id", "spec_version", "objects"})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeImmutable="Bundle", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface BundleObject
extends GenericValidation,
Serializable,
StixCustomProperties,
Stix {
    @NotBlank
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    @Pattern(regexp="^\\-?[a-zA-Z0-9]+(-[a-zA-Z0-9]+)*\\-?$")
    @Size(min=3, max=250)
    public @NotBlank @Pattern(regexp="^\\-?[a-zA-Z0-9]+(-[a-zA-Z0-9]+)*\\-?$") @Size(min=3, max=250) String getType();

    @NotBlank
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @Pattern(regexp="^[a-z][a-z-]+[a-z]--[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")
    public @NotBlank @Pattern(regexp="^[a-z][a-z-]+[a-z]--[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$") String getId();

    @NotBlank
    @JsonProperty(value="spec_version")
    @JsonPropertyDescription(value="The version of the STIX specification used to represent the content in this bundle.")
    @Value.Default
    default public String getSpecVersion() {
        return "2.1";
    }

    @Size(min=1, message="Must have at least 1 object in bundle")
    @JsonProperty(value="objects", access=JsonProperty.Access.WRITE_ONLY)
    @JsonPropertyDescription(value="Specifies a set of one or more STIX Objects.")
    public @Size(min=1, message="Must have at least 1 object in bundle") Set<BundleableObject> getObjects();

    @JsonIgnore
    @Value.Lazy
    default public String toJsonString() {
        JsonNode response = StixParsers.getJsonMapper().valueToTree((Object)this);
        ObjectNode responseNode = (ObjectNode)response;
        responseNode.putArray("objects");
        ArrayNode objects = (ArrayNode)response.get("objects");
        this.getObjects().forEach(o -> {
            String redactedJson = o.toJsonString();
            try {
                JsonNode redactedJsonNode = StixParsers.getJsonMapper().readTree(redactedJson);
                ObjectNode redactedObjectNode = (ObjectNode)redactedJsonNode;
                if (!redactedObjectNode.isNull() && redactedObjectNode.size() > 0) {
                    objects.add((JsonNode)redactedObjectNode);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to Parse Object within bundle JSON");
            }
        });
        try {
            return StixParsers.getJsonMapper().writeValueAsString((Object)response);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to Parse Bundle JSON");
        }
    }
}

